import { computed, toRefs } from '@vue/composition-api'
import i18n from '@/utils/locale'

export const useItemProps = {
  id: {
    type: String
  },
  scope: {
    type: String
  }
}

export const useItemTitle = (props) => {
  const {
    id,
    isClone,
    isNew
  } = toRefs(props)
  return computed(() => {
    switch (true) {
      case !isNew.value && !isClone.value:
        return i18n.t('Fingerbank MAC Vendor <code>{id}</code>', { id: id.value })
      case isClone.value:
        return i18n.t('Clone Fingerbank MAC Vendor <code>{id}</code>', { id: id.value })
      default:
        return i18n.t('New Fingerbank MAC Vendor')
    }
  })
}

export const useItemTitleBadge = props => props.scope

export { useRouter } from '../_router'

export { useStore } from '../_store'

import { pfSearchConditionType as conditionType } from '@/globals/pfSearch'
import makeSearch from '@/store/factory/search'
import api from '../_api'
export const useSearch = makeSearch('fingerbankMacVendors', {
  api,
  columns: [
    {
      key: 'selected',
      thStyle: 'width: 40px;', tdClass: 'text-center',
      locked: true
    },
    {
      key: 'id',
      label: 'Identifier', // i18n defer
      required: true,
      searchable: true,
      sortable: true,
      visible: true
    },
    {
      key: 'mac',
      label: 'OUI', // i18n defer
      searchable: true,
      sortable: true,
      visible: true
    },
    {
      key: 'name',
      label: 'MAC Vendor', // i18n defer
      searchable: true,
      sortable: true,
      visible: true
    },
    {
      key: 'created_at',
      label: 'Created', // i18n defer
      sortable: true,
      visible: true
    },
    {
      key: 'updated_at',
      label: 'Updated', // i18n defer
      sortable: true,
      visible: true
    },
    {
      key: 'buttons',
      class: 'text-right p-0',
      locked: true
    }
  ],
  fields: [
    {
      value: 'id',
      text: i18n.t('Identifier'),
      types: [conditionType.INTEGER]
    },
    {
      value: 'mac',
      text: i18n.t('OUI'),
      types: [conditionType.SUBSTRING]
    },
    {
      value: 'name',
      text: i18n.t('MAC Vendor'),
      types: [conditionType.SUBSTRING]
    }
  ],
  sortBy: 'id'
})
