package pf::util::radius_dictionary;

=head1 NAME

pf::util::radius_dictionary - 

=cut

=head1 DESCRIPTION

pf::util::radius_dictionary



=cut

use strict;
use warnings;

use Net::Radius::Dictionary;
use Exporter qw(import);
our @EXPORT_OK = qw($RADIUS_DICTIONARY);

our $RADIUS_DICTIONARY = bless(
    {
        attr => {
            "Acct-Authentic"                         => [ 45,   "integer" ],
            "Acct-Delay-Time"                        => [ 41,   "integer" ],
            "Acct-Input-Gigawords"                   => [ 52,   "integer" ],
            "Acct-Input-Octets"                      => [ 42,   "integer" ],
            "Acct-Input-Octets64"                    => [ 1148, "integer64" ],
            "Acct-Input-Packets"                     => [ 47,   "integer" ],
            "Acct-Interim-Interval"                  => [ 85,   "integer" ],
            "Acct-Link-Count"                        => [ 51,   "integer" ],
            "Acct-Multi-Session-Id"                  => [ 50,   "string" ],
            "Acct-Output-Gigawords"                  => [ 53,   "integer" ],
            "Acct-Output-Octets"                     => [ 43,   "integer" ],
            "Acct-Output-Octets64"                   => [ 1149, "integer64" ],
            "Acct-Output-Packets"                    => [ 48,   "integer" ],
            "Acct-Session-Id"                        => [ 44,   "string" ],
            "Acct-Session-Start-Time"                => [ 1050, "date" ],
            "Acct-Session-Time"                      => [ 46,   "integer" ],
            "Acct-Status-Type"                       => [ 40,   "integer" ],
            "Acct-Terminate-Cause"                   => [ 49,   "integer" ],
            "Acct-Tunnel-Connection"                 => [ 68,   "string" ],
            "Acct-Tunnel-Packets-Lost"               => [ 86,   "integer" ],
            "Acct-Type"                              => [ 1012, "integer" ],
            "Acct-Unique-Session-Id"                 => [ 1051, "string" ],
            "AD-Samaccountname"                      => [ 3003, "string" ],
            "Add-Prefix"                             => [ 1008, "string" ],
            "Add-Suffix"                             => [ 1009, "string" ],
            "Allow-Session-Resumption"               => [ 1127, "integer" ],
            "Allowed-Called-Station-Id"              => [ 174,  "string" ],
            "ARAP-Challenge-Response"                => [ 84,   "octets" ],
            "ARAP-Features"                          => [ 71,   "octets" ],
            "ARAP-Password"                          => [ 70,   "octets" ],
            "ARAP-Security"                          => [ 73,   "integer" ],
            "ARAP-Security-Data"                     => [ 74,   "string" ],
            "ARAP-Zone-Access"                       => [ 72,   "integer" ],
            "Attribute-Map"                          => [ 1112, "string" ],
            "Auth-Type"                              => [ 1000, "integer" ],
            "Autz-Type"                              => [ 1011, "integer" ],
            "Basic-Location-Policy-Rules"            => [ 129,  "octets" ],
            "Cache-Created"                          => [ 1171, "date" ],
            "Cache-Entry-Hits"                       => [ 1175, "integer" ],
            "Cache-Expires"                          => [ 1170, "date" ],
            "Cache-Merge"                            => [ 1174, "integer" ],
            "Cache-Read-Only"                        => [ 1176, "integer" ],
            "Cache-Status-Only"                      => [ 1173, "integer" ],
            "Cache-TTL"                              => [ 1172, "signed" ],
            "Cached-Session-Policy"                  => [ 1135, "string" ],
            "Calix-CMS-Alarm-Filter"                 => [ 221,  "integer" ],
            "Calix-CMS-Event-Filter"                 => [ 222,  "integer" ],
            "Calix-CMS-Threshold-Event-Filter"       => [ 223,  "integer" ],
            "Calix-CMS-User-Group"                   => [ 220,  "string" ],
            "Callback-Id"                            => [ 20,   "string" ],
            "Callback-Number"                        => [ 19,   "string" ],
            "Called-Station-Id"                      => [ 30,   "string" ],
            "Called-Station-SSID"                    => [ 1139, "string" ],
            "Caller-ID"                              => [ 31,   "string" ],
            "Calling-Station-Id"                     => [ 31,   "string" ],
            "Challenge-State"                        => [ 24,   "octets" ],
            "CHAP-Challenge"                         => [ 60,   "octets" ],
            "CHAP-Password"                          => [ 3,    "octets" ],
            "Char-Noecho"                            => [ 250,  "integer" ],
            "Chargeable-User-Identity"               => [ 89,   "octets" ],
            "Chbind-Response-Code"                   => [ 1147, "integer" ],
            "Class"                                  => [ 25,   "octets" ],
            "Cleartext-Password"                     => [ 1100, "string" ],
            "Client-Id"                              => [ 4,    "ipaddr" ],
            "Client-IP-Address"                      => [ 1052, "ipaddr" ],
            "Client-Port-DNIS"                       => [ 30,   "string" ],
            "Client-Port-Id"                         => [ 5,    "integer" ],
            "Client-Shortname"                       => [ 1024, "string" ],
            "CoA-Acct-Session-Id"                    => [ 1116, "string" ],
            "CoA-Packet-DST-IP-Address"              => [ 1114, "ipaddr" ],
            "CoA-Packet-DST-IPv6-Address"            => [ 1117, "ipv6addr" ],
            "CoA-Packet-DST-Port"                    => [ 1115, "integer" ],
            "CoA-Packet-Type"                        => [ 1113, "string" ],
            "Configuration-Token"                    => [ 78,   "string" ],
            "Connect-Info"                           => [ 77,   "string" ],
            "Crypt-Password"                         => [ 1006, "string" ],
            "Current-Time"                           => [ 1044, "string" ],
            "Delegated-IPv6-Prefix"                  => [ 123,  "ipv6prefix" ],
            "Delegated-IPv6-Prefix-Pool"             => [ 171,  "string" ],
            "Dialback-Name"                          => [ 20,   "string" ],
            "Dialback-No"                            => [ 19,   "string" ],
            "Digest-Algorithm"                       => [ 1068, "string" ],
            "Digest-Attributes"                      => [ 207,  "octets" ],
            "Digest-Body-Digest"                     => [ 1069, "string" ],
            "Digest-CNonce"                          => [ 1070, "string" ],
            "Digest-HA1"                             => [ 1081, "string" ],
            "Digest-Method"                          => [ 1065, "string" ],
            "Digest-Nonce"                           => [ 1064, "string" ],
            "Digest-Nonce-Count"                     => [ 1071, "string" ],
            "Digest-QOP"                             => [ 1067, "string" ],
            "Digest-Realm"                           => [ 1063, "string" ],
            "Digest-Response"                        => [ 206,  "string" ],
            "Digest-URI"                             => [ 1066, "string" ],
            "Digest-User-Name"                       => [ 1072, "string" ],
            "DNS-Server-IPv6-Address"                => [ 169,  "ipv6addr" ],
            "DS-Lite-Tunnel-Name"                    => [ 144,  "octets" ],
            "EAP-Code"                               => [ 1021, "integer" ],
            "EAP-EMSK"                               => [ 1130, "octets" ],
            "EAP-Id"                                 => [ 1020, "integer" ],
            "EAP-IKEv2-AuthType"                     => [ 1106, "integer" ],
            "EAP-IKEv2-ID"                           => [ 1104, "string" ],
            "EAP-IKEv2-IDType"                       => [ 1103, "integer" ],
            "EAP-IKEv2-Secret"                       => [ 1105, "string" ],
            "EAP-Key-Name"                           => [ 102,  "octets" ],
            "EAP-Lower-Layer"                        => [ 163,  "integer" ],
            "EAP-MD5-Password"                       => [ 1022, "string" ],
            "EAP-Message"                            => [ 79,   "octets" ],
            "EAP-MSK"                                => [ 1129, "octets" ],
            "EAP-Peer-Id"                            => [ 175,  "octets" ],
            "EAP-Pwd-Password-Hash"                  => [ 1220, "octets" ],
            "EAP-Pwd-Password-Prep"                  => [ 1222, "byte" ],
            "EAP-Pwd-Password-Salt"                  => [ 1221, "octets" ],
            "EAP-Server-Id"                          => [ 176,  "octets" ],
            "EAP-Session-Id"                         => [ 1146, "octets" ],
            "EAP-Session-Resumed"                    => [ 1128, "integer" ],
            "EAP-Sim-Algo-Version"                   => [ 1216, "integer" ],
            "EAP-Sim-ANY_ID_REQ"                     => [ 1549, "octets" ],
            "EAP-Sim-CHECKCODE"                      => [ 1670, "octets" ],
            "EAP-Sim-COUNTER"                        => [ 1555, "octets" ],
            "EAP-Sim-COUNTER_TOO_SMALL"              => [ 1556, "octets" ],
            "EAP-Sim-ENCR_DATA"                      => [ 1666, "octets" ],
            "EAP-Sim-EXTRA"                          => [ 1211, "octets" ],
            "EAP-Sim-FULLAUTH_ID_REQ"                => [ 1553, "octets" ],
            "EAP-Sim-HMAC"                           => [ 1209, "string" ],
            "EAP-Sim-IDENTITY"                       => [ 1550, "octets" ],
            "EAP-Sim-IMSI"                           => [ 1208, "string" ],
            "EAP-Sim-IV"                             => [ 1665, "octets" ],
            "EAP-Sim-KC1"                            => [ 1212, "octets" ],
            "EAP-Sim-KC2"                            => [ 1213, "octets" ],
            "EAP-Sim-KC3"                            => [ 1214, "octets" ],
            "EAP-Sim-KEY"                            => [ 1210, "octets" ],
            "EAP-Sim-Ki"                             => [ 1215, "octets" ],
            "EAP-Sim-MAC"                            => [ 1547, "octets" ],
            "EAP-Sim-NEXT_PSEUDONUM"                 => [ 1668, "octets" ],
            "EAP-Sim-NEXT_REAUTH_ID"                 => [ 1669, "octets" ],
            "EAP-Sim-NONCE_MT"                       => [ 1543, "octets" ],
            "EAP-Sim-NONCE_S"                        => [ 1557, "octets" ],
            "EAP-Sim-NOTIFICATION"                   => [ 1548, "octets" ],
            "EAP-Sim-PADDING"                        => [ 1542, "octets" ],
            "EAP-Sim-PERMANENT_ID_REQ"               => [ 1546, "octets" ],
            "EAP-Sim-RAND"                           => [ 1537, "octets" ],
            "EAP-Sim-Rand1"                          => [ 1201, "octets" ],
            "EAP-Sim-Rand2"                          => [ 1202, "octets" ],
            "EAP-Sim-Rand3"                          => [ 1203, "octets" ],
            "EAP-Sim-SELECTED_VERSION"               => [ 1552, "octets" ],
            "EAP-Sim-SRES1"                          => [ 1204, "octets" ],
            "EAP-Sim-SRES2"                          => [ 1205, "octets" ],
            "EAP-Sim-SRES3"                          => [ 1206, "octets" ],
            "EAP-Sim-State"                          => [ 1207, "integer" ],
            "EAP-Sim-Subtype"                        => [ 1200, "integer" ],
            "EAP-Sim-VERSION_LIST"                   => [ 1551, "octets" ],
            "EAP-TLS-Require-Client-Cert"            => [ 1019, "integer" ],
            "EAP-Type"                               => [ 1018, "integer" ],
            "EAP-Type-AirFortress-EAP"               => [ 1317, "octets" ],
            "EAP-Type-AKA"                           => [ 1303, "octets" ],
            "EAP-Type-Arcot-Systems-EAP"             => [ 1296, "octets" ],
            "EAP-Type-Base"                          => [ 1280, "octets" ],
            "EAP-Type-Cisco-LEAP"                    => [ 1297, "octets" ],
            "EAP-Type-Cisco-MS-CHAPv2"               => [ 1309, "octets" ],
            "EAP-Type-Cogent-Biomentric-EAP"         => [ 1316, "octets" ],
            "EAP-Type-CRYPTOCard"                    => [ 1308, "octets" ],
            "EAP-Type-Defender-Token"                => [ 1294, "octets" ],
            "EAP-Type-DeviceConnect-EAP"             => [ 1320, "octets" ],
            "EAP-Type-DSS-Unilateral"                => [ 1290, "octets" ],
            "EAP-Type-DynamID"                       => [ 1310, "octets" ],
            "EAP-Type-EAP-3Com-Wireless"             => [ 1304, "octets" ],
            "EAP-Type-EAP-Actiontec-Wireless"        => [ 1315, "octets" ],
            "EAP-Type-EAP-AKA2"                      => [ 1330, "octets" ],
            "EAP-Type-EAP-EVEv1"                     => [ 1333, "octets" ],
            "EAP-Type-EAP-FAST"                      => [ 1323, "octets" ],
            "EAP-Type-EAP-GPSK"                      => [ 1331, "octets" ],
            "EAP-Type-EAP-HTTP-Digest"               => [ 1318, "octets" ],
            "EAP-Type-EAP-IKEv2"                     => [ 1329, "octets" ],
            "EAP-Type-EAP-Link"                      => [ 1325, "octets" ],
            "EAP-Type-EAP-MOBAC"                     => [ 1322, "octets" ],
            "EAP-Type-EAP-MSCHAP-V2"                 => [ 1309, "octets" ],
            "EAP-Type-EAP-PAX"                       => [ 1326, "octets" ],
            "EAP-Type-EAP-PSK"                       => [ 1327, "octets" ],
            "EAP-Type-EAP-PWD"                       => [ 1332, "octets" ],
            "EAP-Type-EAP-SAKE"                      => [ 1328, "octets" ],
            "EAP-Type-EAP-SPEKE"                     => [ 1321, "octets" ],
            "EAP-Type-EAP-TLS"                       => [ 1293, "octets" ],
            "EAP-Type-EAP-TTLS"                      => [ 1301, "octets" ],
            "EAP-Type-Generic-Token-Card"            => [ 1286, "octets" ],
            "EAP-Type-Identity"                      => [ 1281, "octets" ],
            "EAP-Type-KEA"                           => [ 1291, "octets" ],
            "EAP-Type-KEA-Validate"                  => [ 1292, "octets" ],
            "EAP-Type-MAKE"                          => [ 1307, "octets" ],
            "EAP-Type-MD5-Challenge"                 => [ 1284, "octets" ],
            "EAP-Type-Microsoft-MS-CHAPv2"           => [ 1306, "octets" ],
            "EAP-Type-MS-Authentication-TLV"         => [ 1313, "octets" ],
            "EAP-Type-MS-CHAP-V2"                    => [ 1306, "octets" ],
            "EAP-Type-MS-EAP-Authentication"         => [ 1306, "octets" ],
            "EAP-Type-NAK"                           => [ 1283, "octets" ],
            "EAP-Type-Nokia-IP-Smart-Card"           => [ 1298, "octets" ],
            "EAP-Type-None"                          => [ 1280, "octets" ],
            "EAP-Type-Notification"                  => [ 1282, "octets" ],
            "EAP-Type-One-Time-Password"             => [ 1285, "octets" ],
            "EAP-Type-PEAP"                          => [ 1305, "octets" ],
            "EAP-Type-Remote-Access-Service"         => [ 1302, "octets" ],
            "EAP-Type-Rob-EAP"                       => [ 1311, "octets" ],
            "EAP-Type-RSA-Public-Key"                => [ 1289, "octets" ],
            "EAP-Type-RSA-SecurID-EAP"               => [ 1295, "octets" ],
            "EAP-Type-SecurID-EAP"                   => [ 1312, "octets" ],
            "EAP-Type-SecuriSuite-EAP"               => [ 1319, "octets" ],
            "EAP-Type-SentriNET"                     => [ 1314, "octets" ],
            "EAP-Type-SIM"                           => [ 1298, "octets" ],
            "EAP-Type-SRP-SHA1"                      => [ 1299, "octets" ],
            "EAP-Type-VALUE"                         => [ 1280, "octets" ],
            "EAP-Type-Zonelabs"                      => [ 1324, "octets" ],
            "EAP_Sim-Base"                           => [ 1536, "octets" ],
            "EAPoL-Announcement"                     => [ 180,  "octets" ],
            "Egress-VLAN-Name"                       => [ 58,   "string" ],
            "Egress-VLANID"                          => [ 56,   "integer" ],
            "Error-Cause"                            => [ 101,  "integer" ],
            "Event-Timestamp"                        => [ 55,   "date" ],
            "Exec-Program"                           => [ 502,  "string" ],
            "Exec-Program-Wait"                      => [ 503,  "string" ],
            "Expiration"                             => [ 1010, "date" ],
            "Extended-Location-Policy-Rules"         => [ 130,  "string" ],
            "Fall-Through"                           => [ 500,  "integer" ],
            "Filter-Id"                              => [ 11,   "string" ],
            "Frag-Status"                            => [ 241,  "integer" ],
            "Framed-Address"                         => [ 8,    "ipaddr" ],
            "Framed-AppleTalk-Link"                  => [ 37,   "integer" ],
            "Framed-AppleTalk-Network"               => [ 38,   "integer" ],
            "Framed-AppleTalk-Zone"                  => [ 39,   "string" ],
            "Framed-Callback-Id"                     => [ 20,   "string" ],
            "Framed-Compression"                     => [ 13,   "integer" ],
            "Framed-Filter-Id"                       => [ 11,   "string" ],
            "Framed-Interface-Id"                    => [ 96,   "ifid" ],
            "Framed-IP-Address"                      => [ 8,    "ipaddr" ],
            "Framed-IP-Netmask"                      => [ 9,    "ipaddr" ],
            "Framed-IPv6-Address"                    => [ 168,  "ipv6addr" ],
            "Framed-IPv6-Pool"                       => [ 100,  "string" ],
            "Framed-IPv6-Prefix"                     => [ 97,   "ipv6prefix" ],
            "Framed-IPv6-Route"                      => [ 99,   "string" ],
            "Framed-IPX-Network"                     => [ 23,   "ipaddr" ],
            "Framed-Management"                      => [ 133,  "integer" ],
            "Framed-MTU"                             => [ 12,   "integer" ],
            "Framed-Netmask"                         => [ 9,    "ipaddr" ],
            "Framed-Pool"                            => [ 88,   "string" ],
            "Framed-Protocol"                        => [ 7,    "integer" ],
            "Framed-Route"                           => [ 22,   "string" ],
            "Framed-Routing"                         => [ 10,   "integer" ],
            "FreeRADIUS-Client-IP-Address"           => [ 1120, "ipaddr" ],
            "FreeRADIUS-Client-IP-Prefix"            => [ 1150, "ipv4prefix" ],
            "FreeRADIUS-Client-IPv6-Address"         => [ 1121, "ipv6addr" ],
            "FreeRADIUS-Client-IPv6-Prefix"          => [ 1151, "ipv6prefix" ],
            "FreeRADIUS-Client-NAS-Type"             => [ 1125, "string" ],
            "FreeRADIUS-Client-Require-MA"           => [ 1122, "integer" ],
            "FreeRADIUS-Client-Secret"               => [ 1123, "string" ],
            "FreeRADIUS-Client-Shortname"            => [ 1124, "string" ],
            "FreeRADIUS-Client-Src-IP-Address"       => [ 1153, "ipaddr" ],
            "FreeRADIUS-Client-Src-IPv6-Address"     => [ 1154, "ipv6addr" ],
            "FreeRADIUS-Client-Virtual-Server"       => [ 1126, "string" ],
            "FreeRADIUS-Response-Delay"              => [ 1152, "integer" ],
            "FreeRADIUS-Response-Delay-USec"         => [ 1155, "integer" ],
            "Group"                                  => [ 1005, "string" ],
            "Group-Name"                             => [ 1030, "string" ],
            "GSS-Acceptor-Host-Name"                 => [ 165,  "string" ],
            "GSS-Acceptor-Realm-Name"                => [ 167,  "string" ],
            "GSS-Acceptor-Service-Name"              => [ 164,  "string" ],
            "GSS-Acceptor-Service-Specifics"         => [ 166,  "string" ],
            "Hint"                                   => [ 1040, "string" ],
            "Home-Server-Name"                       => [ 1193, "string" ],
            "Home-Server-Pool"                       => [ 1111, "string" ],
            "Huntgroup-Name"                         => [ 1031, "string" ],
            "Idle-Timeout"                           => [ 28,   "integer" ],
            "Ingress-Filters"                        => [ 57,   "integer" ],
            "Inner-Realm-Name"                       => [ 1219, "string" ],
            "Inner-Tunnel-User-Name"                 => [ 1102, "string" ],
            "IP-Port-Alloc"                          => [ 241,  "integer" ],
            "IP-Port-Ext-IPv4-Addr"                  => [ 241,  "ipaddr" ],
            "IP-Port-Ext-Port"                       => [ 241,  "integer" ],
            "IP-Port-Forwarding-Map"                 => [ 241,  "tlv" ],
            "IP-Port-Int-IPv4-Addr"                  => [ 241,  "ipaddr" ],
            "IP-Port-Int-IPv6-Addr"                  => [ 241,  "ipv6addr" ],
            "IP-Port-Int-Port"                       => [ 241,  "integer" ],
            "IP-Port-Limit"                          => [ 241,  "integer" ],
            "IP-Port-Limit-Info"                     => [ 241,  "tlv" ],
            "IP-Port-Local-Id"                       => [ 241,  "string" ],
            "IP-Port-Map-Alloc"                      => [ 241,  "integer" ],
            "IP-Port-Map-Ext-IPv4-Addr"              => [ 241,  "ipaddr" ],
            "IP-Port-Map-Ext-Port"                   => [ 241,  "integer" ],
            "IP-Port-Map-Int-IPv4-Addr"              => [ 241,  "ipaddr" ],
            "IP-Port-Map-Int-IPv6-Addr"              => [ 241,  "ipv6addr" ],
            "IP-Port-Map-Int-Port"                   => [ 241,  "integer" ],
            "IP-Port-Map-Limit"                      => [ 241,  "integer" ],
            "IP-Port-Map-Local-Id"                   => [ 241,  "string" ],
            "IP-Port-Map-Range-End"                  => [ 241,  "integer" ],
            "IP-Port-Map-Range-Start"                => [ 241,  "integer" ],
            "IP-Port-Map-Type"                       => [ 241,  "integer" ],
            "IP-Port-Range"                          => [ 241,  "tlv" ],
            "IP-Port-Range-Alloc"                    => [ 241,  "integer" ],
            "IP-Port-Range-End"                      => [ 241,  "integer" ],
            "IP-Port-Range-Ext-IPv4-Addr"            => [ 241,  "ipaddr" ],
            "IP-Port-Range-Ext-Port"                 => [ 241,  "integer" ],
            "IP-Port-Range-Int-IPv4-Addr"            => [ 241,  "ipaddr" ],
            "IP-Port-Range-Int-IPv6-Addr"            => [ 241,  "ipv6addr" ],
            "IP-Port-Range-Int-Port"                 => [ 241,  "integer" ],
            "IP-Port-Range-Limit"                    => [ 241,  "integer" ],
            "IP-Port-Range-Local-Id"                 => [ 241,  "string" ],
            "IP-Port-Range-Range-End"                => [ 241,  "integer" ],
            "IP-Port-Range-Range-Start"              => [ 241,  "integer" ],
            "IP-Port-Range-Start"                    => [ 241,  "integer" ],
            "IP-Port-Range-Type"                     => [ 241,  "integer" ],
            "IP-Port-Type"                           => [ 241,  "integer" ],
            "IPv6-6rd-BR-IPv4-Address"               => [ 173,  "ipaddr" ],
            "IPv6-6rd-Configuration"                 => [ 173,  "tlv" ],
            "IPv6-6rd-IPv4MaskLen"                   => [ 173,  "integer" ],
            "IPv6-6rd-Prefix"                        => [ 173,  "ipv6prefix" ],
            "LDAP-UserDN"                            => [ 1053, "string" ],
            "LM-Password"                            => [ 1057, "octets" ],
            "Load-Balance-Key"                       => [ 1025, "string" ],
            "Location-Capable"                       => [ 131,  "integer" ],
            "Location-Data"                          => [ 128,  "octets" ],
            "Location-Information"                   => [ 127,  "octets" ],
            "Login-Callback-Number"                  => [ 19,   "string" ],
            "Login-Host"                             => [ 14,   "ipaddr" ],
            "Login-IP-Host"                          => [ 14,   "ipaddr" ],
            "Login-IPv6-Host"                        => [ 98,   "ipv6addr" ],
            "Login-LAT-Group"                        => [ 36,   "octets" ],
            "Login-LAT-Node"                         => [ 35,   "string" ],
            "Login-LAT-Port"                         => [ 63,   "string" ],
            "Login-LAT-Service"                      => [ 34,   "string" ],
            "Login-Port"                             => [ 16,   "integer" ],
            "Login-Service"                          => [ 15,   "integer" ],
            "Login-TCP-Port"                         => [ 16,   "integer" ],
            "Login-Time"                             => [ 1042, "string" ],
            "Management-Policy-Id"                   => [ 135,  "string" ],
            "Management-Privilege-Level"             => [ 136,  "integer" ],
            "Management-Transport-Protection"        => [ 134,  "integer" ],
            "MD5-Password"                           => [ 1095, "octets" ],
            "Menu"                                   => [ 1001, "string" ],
            "Message-Authenticator"                  => [ 80,   "octets" ],
            "MIP6-Feature-Vector"                    => [ 124,  "integer64" ],
            "MIP6-Home-Link-Prefix"                  => [ 125,  "octets" ],
            "Mobile-Node-Identifier"                 => [ 145,  "octets" ],
            "Mobility-Domain-Id"                     => [ 177,  "integer" ],
            "Module-Failure-Message"                 => [ 1076, "string" ],
            "Module-Return-Code"                     => [ 1108, "integer" ],
            "Module-Success-Message"                 => [ 1075, "string" ],
            "MS-CHAP-New-Cleartext-Password"         => [ 1136, "string" ],
            "MS-CHAP-New-NT-Password"                => [ 1137, "octets" ],
            "MS-CHAP-Password"                       => [ 1133, "string" ],
            "MS-CHAP-Peer-Challenge"                 => [ 1192, "octets" ],
            "MS-CHAP-Use-NTLM-Auth"                  => [ 1082, "integer" ],
            "MS-CHAP-User-Name"                      => [ 1083, "string" ],
            "Multi-Link-Flag"                        => [ 126,  "integer" ],
            "NAS-Filter-Rule"                        => [ 92,   "string" ],
            "NAS-Identifier"                         => [ 32,   "string" ],
            "NAS-IP-Address"                         => [ 4,    "ipaddr" ],
            "NAS-IPv6-Address"                       => [ 95,   "ipv6addr" ],
            "NAS-Port"                               => [ 5,    "integer" ],
            "NAS-Port-Id"                            => [ 87,   "string" ],
            "NAS-Port-Type"                          => [ 61,   "integer" ],
            "Network-Id-Name"                        => [ 179,  "octets" ],
            "No-Such-Attribute"                      => [ 1046, "string" ],
            "NS-MTA-MD5-Password"                    => [ 1054, "string" ],
            "NT-Password"                            => [ 1058, "octets" ],
            "NTLM-User-Name"                         => [ 1083, "string" ],
            "OAuth2-Group"                           => [ 3001, "string" ],
            "OAuth2-Password-Last-Modified"          => [ 3000, "date" ],
            "Old-Password"                           => [ 17,   "string" ],
            "Operator-Name"                          => [ 126,  "string" ],
            "Operator-NAS-Identifier"                => [ 241,  "octets" ],
            "Original-Packet-Code"                   => [ 241,  "integer" ],
            "Originating-Line-Info"                  => [ 94,   "octets" ],
            "Originating-Realm-Key"                  => [ 1194, "string" ],
            "OTP-Challenge"                          => [ 1145, "string" ],
            "Outer-Realm-Name"                       => [ 1218, "string" ],
            "Packet-Authentication-Vector"           => [ 1088, "octets" ],
            "Packet-Dst-IP-Address"                  => [ 1085, "ipaddr" ],
            "Packet-Dst-IPv6-Address"                => [ 1098, "ipv6addr" ],
            "Packet-Dst-Port"                        => [ 1087, "integer" ],
            "Packet-Original-Timestamp"              => [ 1109, "date" ],
            "Packet-Src-IP-Address"                  => [ 1084, "ipaddr" ],
            "Packet-Src-IPv6-Address"                => [ 1097, "ipv6addr" ],
            "Packet-Src-Port"                        => [ 1086, "integer" ],
            "Packet-Transmit-Counter"                => [ 1134, "integer" ],
            "Packet-Type"                            => [ 1047, "integer" ],
            "Pam-Auth"                               => [ 1041, "string" ],
            "Password-Retry"                         => [ 75,   "integer" ],
            "Password-With-Header"                   => [ 1101, "string" ],
            "PBKDF2-Password"                        => [ 1181, "octets" ],
            "PEAP-Version"                           => [ 1023, "integer" ],
            "PKM-Auth-Key"                           => [ 143,  "octets" ],
            "PKM-CA-Cert"                            => [ 138,  "octets" ],
            "PKM-Config-Settings"                    => [ 139,  "octets" ],
            "PKM-Cryptosuite-List"                   => [ 140,  "octets" ],
            "PKM-SA-Descriptor"                      => [ 142,  "octets" ],
            "PKM-SAID"                               => [ 141,  "short" ],
            "PKM-SS-Cert"                            => [ 137,  "octets" ],
            "PMIP6-Home-DHCP4-Server-Address"        => [ 157,  "ipaddr" ],
            "PMIP6-Home-DHCP6-Server-Address"        => [ 159,  "ipv6addr" ],
            "PMIP6-Home-HN-Prefix"                   => [ 151,  "ipv6prefix" ],
            "PMIP6-Home-Interface-ID"                => [ 153,  "ifid" ],
            "PMIP6-Home-IPv4-Gateway"                => [ 161,  "ipaddr" ],
            "PMIP6-Home-IPv4-HoA"                    => [ 155,  "ipv4prefix" ],
            "PMIP6-Home-LMA-IPv4-Address"            => [ 149,  "ipaddr" ],
            "PMIP6-Home-LMA-IPv6-Address"            => [ 147,  "ipv6addr" ],
            "PMIP6-Visited-DHCP4-Server-Address"     => [ 158,  "ipaddr" ],
            "PMIP6-Visited-DHCP6-Server-Address"     => [ 160,  "ipv6addr" ],
            "PMIP6-Visited-HN-Prefix"                => [ 152,  "ipv6prefix" ],
            "PMIP6-Visited-Interface-ID"             => [ 154,  "ifid" ],
            "PMIP6-Visited-IPv4-Gateway"             => [ 162,  "ipaddr" ],
            "PMIP6-Visited-IPv4-HoA"                 => [ 156,  "ipv4prefix" ],
            "PMIP6-Visited-LMA-IPv4-Address"         => [ 150,  "ipaddr" ],
            "PMIP6-Visited-LMA-IPv6-Address"         => [ 148,  "ipv6addr" ],
            "Pool-Name"                              => [ 1073, "string" ],
            "Port-Limit"                             => [ 62,   "integer" ],
            "Port-Message"                           => [ 18,   "string" ],
            "Post-Auth-Type"                         => [ 1014, "integer" ],
            "Post-Proxy-Type"                        => [ 1016, "integer" ],
            "Pre-Acct-Type"                          => [ 1017, "integer" ],
            "Pre-Proxy-Type"                         => [ 1015, "integer" ],
            "Preauth-Timeout"                        => [ 178,  "integer" ],
            "Prefix"                                 => [ 1003, "string" ],
            "Prompt"                                 => [ 76,   "integer" ],
            "Proxy-State"                            => [ 33,   "octets" ],
            "Proxy-State-Length"                     => [ 241,  "integer" ],
            "Proxy-To-Originating-Realm"             => [ 1195, "string" ],
            "Proxy-To-Realm"                         => [ 1048, "string" ],
            "Proxy-Tunneled-Request-As-EAP"          => [ 1197, "integer" ],
            "Radclient-Test-Name"                    => [ 2200, "string" ],
            "Raw-Attribute"                          => [ 1026, "octets" ],
            "Realm"                                  => [ 1045, "string" ],
            "Recv-CoA-Type"                          => [ 1131, "integer" ],
            "Relax-Filter"                           => [ 501,  "integer" ],
            "Replicate-To-Realm"                     => [ 1049, "string" ],
            "Reply-Message"                          => [ 18,   "string" ],
            "Request-Processing-Stage"               => [ 1090, "string" ],
            "Requested-Location-Info"                => [ 132,  "integer" ],
            "Response-Length"                        => [ 241,  "integer" ],
            "Response-Packet-Type"                   => [ 1080, "integer" ],
            "REST-HTTP-Body"                         => [ 1161, "string" ],
            "REST-HTTP-Header"                       => [ 1160, "string" ],
            "REST-HTTP-Status-Code"                  => [ 1162, "integer" ],
            "Rewrite-Rule"                           => [ 1078, "string" ],
            "Route-IPv6-Information"                 => [ 170,  "ipv6prefix" ],
            "Send-CoA-Request"                       => [ 1107, "integer" ],
            "Send-CoA-Type"                          => [ 1132, "integer" ],
            "Send-Disconnect-Request"                => [ 1107, "integer" ],
            "Service-Selection"                      => [ 146,  "string" ],
            "Service-Type"                           => [ 6,    "integer" ],
            "Session-Timeout"                        => [ 27,   "integer" ],
            "Session-Type"                           => [ 1013, "integer" ],
            "SHA-Password"                           => [ 1093, "octets" ],
            "SHA1-Password"                          => [ 1093, "octets" ],
            "SHA2-Password"                          => [ 1092, "octets" ],
            "Simultaneous-Use"                       => [ 1034, "integer" ],
            "SMB-Account-CTRL"                       => [ 1059, "integer" ],
            "SMB-Account-CTRL-TEXT"                  => [ 1061, "string" ],
            "SMD5-Password"                          => [ 1096, "octets" ],
            "SoH-MS-Correlation-Id"                  => [ 2108, "octets" ],
            "SoH-MS-Health-Other"                    => [ 2129, "string" ],
            "SoH-MS-Machine-Name"                    => [ 2107, "string" ],
            "SoH-MS-Machine-OS-build"                => [ 2103, "integer" ],
            "SoH-MS-Machine-OS-release"              => [ 2102, "integer" ],
            "SoH-MS-Machine-OS-vendor"               => [ 2100, "integer" ],
            "SoH-MS-Machine-OS-version"              => [ 2101, "integer" ],
            "SoH-MS-Machine-Processor"               => [ 2106, "integer" ],
            "SoH-MS-Machine-Role"                    => [ 2109, "integer" ],
            "SoH-MS-Machine-SP-release"              => [ 2105, "integer" ],
            "SoH-MS-Machine-SP-version"              => [ 2104, "integer" ],
            "SoH-MS-Windows-Health-Status"           => [ 2120, "string" ],
            "SoH-Supported"                          => [ 2119, "integer" ],
            "SQL-Table-Name"                         => [ 1110, "string" ],
            "SQL-User-Name"                          => [ 1055, "string" ],
            "SSHA-Password"                          => [ 1094, "octets" ],
            "SSHA1-Password"                         => [ 1094, "octets" ],
            "SSHA2-224-Password"                     => [ 1177, "octets" ],
            "SSHA2-256-Password"                     => [ 1178, "octets" ],
            "SSHA2-384-Password"                     => [ 1179, "octets" ],
            "SSHA2-512-Password"                     => [ 1180, "octets" ],
            "SSHA3-224-Password"                     => [ 1182, "octets" ],
            "SSHA3-256-Password"                     => [ 1183, "octets" ],
            "SSHA3-384-Password"                     => [ 1184, "octets" ],
            "SSHA3-512-Password"                     => [ 1185, "octets" ],
            "State"                                  => [ 24,   "octets" ],
            "Stateful-IPv6-Address-Pool"             => [ 172,  "string" ],
            "Strip-User-Name"                        => [ 1035, "integer" ],
            "Stripped-User-Domain"                   => [ 1138, "string" ],
            "Stripped-User-Name"                     => [ 1043, "string" ],
            "Suffix"                                 => [ 1004, "string" ],
            "Temp-Home-Server-String"                => [ 1198, "string" ],
            "Termination-Action"                     => [ 29,   "integer" ],
            "Termination-Menu"                       => [ 1002, "string" ],
            "Time-Of-Day"                            => [ 1089, "string" ],
            "TLS-Cache-Filename"                     => [ 1946, "string" ],
            "TLS-Cache-Method"                       => [ 1938, "integer" ],
            "TLS-Cert-Common-Name"                   => [ 1914, "string" ],
            "TLS-Cert-Expiration"                    => [ 1911, "string" ],
            "TLS-Cert-Issuer"                        => [ 1912, "string" ],
            "TLS-Cert-Serial"                        => [ 1910, "string" ],
            "TLS-Cert-Subject"                       => [ 1913, "string" ],
            "TLS-Cert-Subject-Alt-Name-Dns"          => [ 1916, "string" ],
            "TLS-Cert-Subject-Alt-Name-Email"        => [ 1915, "string" ],
            "TLS-Cert-Subject-Alt-Name-Upn"          => [ 1917, "string" ],
            "TLS-Cert-Valid-Since"                   => [ 1918, "string" ],
            "TLS-Client-Cert-Common-Name"            => [ 1924, "string" ],
            "TLS-Client-Cert-Expiration"             => [ 1921, "string" ],
            "TLS-Client-Cert-Filename"               => [ 1925, "string" ],
            "TLS-Client-Cert-Issuer"                 => [ 1922, "string" ],
            "TLS-Client-Cert-Serial"                 => [ 1920, "string" ],
            "TLS-Client-Cert-Subject"                => [ 1923, "string" ],
            "TLS-Client-Cert-Subject-Alt-Name-Dns"   => [ 1931, "string" ],
            "TLS-Client-Cert-Subject-Alt-Name-Email" => [ 1926, "string" ],
            "TLS-Client-Cert-Subject-Alt-Name-Upn"   => [ 1932, "string" ],
            "TLS-Client-Cert-Valid-Since"            => [ 1937, "string" ],
            "TLS-Client-Cert-X509v3-Authority-Key-Identifier" =>
              [ 1929, "string" ],
            "TLS-Client-Cert-X509v3-Basic-Constraints"    => [ 1930, "string" ],
            "TLS-Client-Cert-X509v3-Certificate-Policies" => [ 1939, "string" ],
            "TLS-Client-Cert-X509v3-Extended-Key-Usage"   => [ 1927, "string" ],
            "TLS-Client-Cert-X509v3-Extended-Key-Usage-OID" =>
              [ 1936, "string" ],
            "TLS-Client-Cert-X509v3-Subject-Key-Identifier" =>
              [ 1928, "string" ],
            "TLS-OCSP-Cert-Valid"               => [ 1943, "integer" ],
            "TLS-PSK-Identity"                  => [ 1933, "string" ],
            "TLS-Server-Name-Indication"        => [ 1951, "string" ],
            "TLS-Session-Cert-File"             => [ 1949, "string" ],
            "TLS-Session-Cert-Private-Key-File" => [ 1950, "string" ],
            "TLS-Session-Cipher-Suite"          => [ 1948, "string" ],
            "TLS-Session-Data"                  => [ 1942, "octets" ],
            "TLS-Session-ID"                    => [ 1940, "octets" ],
            "TLS-Session-Information"           => [ 1919, "string" ],
            "TLS-Session-Version"               => [ 1947, "string" ],
            "Tmp-Cast-Abinary"                  => [ 1855, "abinary" ],
            "Tmp-Cast-Byte"                     => [ 1860, "byte" ],
            "Tmp-Cast-Date"                     => [ 1854, "date" ],
            "Tmp-Cast-Ethernet"                 => [ 1862, "ether" ],
            "Tmp-Cast-Ifid"                     => [ 1857, "ifid" ],
            "Tmp-Cast-Integer"                  => [ 1852, "integer" ],
            "Tmp-Cast-Integer64"                => [ 1869, "integer64" ],
            "Tmp-Cast-Ipaddr"                   => [ 1853, "ipaddr" ],
            "Tmp-Cast-IPv4Prefix"               => [ 1870, "ipv4prefix" ],
            "Tmp-Cast-IPv6Addr"                 => [ 1858, "ipv6addr" ],
            "Tmp-Cast-IPv6Prefix"               => [ 1859, "ipv6prefix" ],
            "Tmp-Cast-Octets"                   => [ 1856, "octets" ],
            "Tmp-Cast-Short"                    => [ 1861, "short" ],
            "Tmp-Cast-Signed"                   => [ 1863, "signed" ],
            "Tmp-Cast-String"                   => [ 1851, "string" ],
            "Tmp-Date-0"                        => [ 1840, "date" ],
            "Tmp-Date-1"                        => [ 1841, "date" ],
            "Tmp-Date-2"                        => [ 1842, "date" ],
            "Tmp-Date-3"                        => [ 1843, "date" ],
            "Tmp-Date-4"                        => [ 1844, "date" ],
            "Tmp-Date-5"                        => [ 1845, "date" ],
            "Tmp-Date-6"                        => [ 1846, "date" ],
            "Tmp-Date-7"                        => [ 1847, "date" ],
            "Tmp-Date-8"                        => [ 1848, "date" ],
            "Tmp-Date-9"                        => [ 1849, "date" ],
            "Tmp-Integer-0"                     => [ 1810, "integer" ],
            "Tmp-Integer-1"                     => [ 1811, "integer" ],
            "Tmp-Integer-2"                     => [ 1812, "integer" ],
            "Tmp-Integer-3"                     => [ 1813, "integer" ],
            "Tmp-Integer-4"                     => [ 1814, "integer" ],
            "Tmp-Integer-5"                     => [ 1815, "integer" ],
            "Tmp-Integer-6"                     => [ 1816, "integer" ],
            "Tmp-Integer-7"                     => [ 1817, "integer" ],
            "Tmp-Integer-8"                     => [ 1818, "integer" ],
            "Tmp-Integer-9"                     => [ 1819, "integer" ],
            "Tmp-Integer64-0"                   => [ 1871, "integer64" ],
            "Tmp-Integer64-1"                   => [ 1872, "integer64" ],
            "Tmp-Integer64-2"                   => [ 1873, "integer64" ],
            "Tmp-Integer64-3"                   => [ 1874, "integer64" ],
            "Tmp-Integer64-4"                   => [ 1875, "integer64" ],
            "Tmp-Integer64-5"                   => [ 1876, "integer64" ],
            "Tmp-Integer64-6"                   => [ 1877, "integer64" ],
            "Tmp-Integer64-7"                   => [ 1878, "integer64" ],
            "Tmp-Integer64-8"                   => [ 1879, "integer64" ],
            "Tmp-Integer64-9"                   => [ 1880, "integer64" ],
            "Tmp-IP-Address-0"                  => [ 1820, "ipaddr" ],
            "Tmp-IP-Address-1"                  => [ 1821, "ipaddr" ],
            "Tmp-IP-Address-2"                  => [ 1822, "ipaddr" ],
            "Tmp-IP-Address-3"                  => [ 1823, "ipaddr" ],
            "Tmp-IP-Address-4"                  => [ 1824, "ipaddr" ],
            "Tmp-IP-Address-5"                  => [ 1825, "ipaddr" ],
            "Tmp-IP-Address-6"                  => [ 1826, "ipaddr" ],
            "Tmp-IP-Address-7"                  => [ 1827, "ipaddr" ],
            "Tmp-IP-Address-8"                  => [ 1828, "ipaddr" ],
            "Tmp-IP-Address-9"                  => [ 1829, "ipaddr" ],
            "Tmp-Octets-0"                      => [ 1830, "octets" ],
            "Tmp-Octets-1"                      => [ 1831, "octets" ],
            "Tmp-Octets-2"                      => [ 1832, "octets" ],
            "Tmp-Octets-3"                      => [ 1833, "octets" ],
            "Tmp-Octets-4"                      => [ 1834, "octets" ],
            "Tmp-Octets-5"                      => [ 1835, "octets" ],
            "Tmp-Octets-6"                      => [ 1836, "octets" ],
            "Tmp-Octets-7"                      => [ 1837, "octets" ],
            "Tmp-Octets-8"                      => [ 1838, "octets" ],
            "Tmp-Octets-9"                      => [ 1839, "octets" ],
            "Tmp-String-0"                      => [ 1800, "string" ],
            "Tmp-String-1"                      => [ 1801, "string" ],
            "Tmp-String-2"                      => [ 1802, "string" ],
            "Tmp-String-3"                      => [ 1803, "string" ],
            "Tmp-String-4"                      => [ 1804, "string" ],
            "Tmp-String-5"                      => [ 1805, "string" ],
            "Tmp-String-6"                      => [ 1806, "string" ],
            "Tmp-String-7"                      => [ 1807, "string" ],
            "Tmp-String-8"                      => [ 1808, "string" ],
            "Tmp-String-9"                      => [ 1809, "string" ],
            "TNC-VLAN-Access"                   => [ 1027, "string" ],
            "TNC-VLAN-Isolate"                  => [ 1028, "string" ],
            "TOTP-Key"                          => [ 1195, "octets" ],
            "TOTP-Password"                     => [ 1196, "string" ],
            "TOTP-Secret"                       => [ 1194, "string" ],
            "Tunnel-Assignment-Id"              => [ 82,   "string" ],
            "Tunnel-Client-Auth-Id"             => [ 90,   "string" ],
            "Tunnel-Client-Endpoint"            => [ 66,   "string" ],
            "Tunnel-Medium-Type"                => [ 65,   "integer" ],
            "Tunnel-Password"                   => [ 69,   "string" ],
            "Tunnel-Preference"                 => [ 83,   "integer" ],
            "Tunnel-Private-Group-Id"           => [ 81,   "string" ],
            "Tunnel-Server-Auth-Id"             => [ 91,   "string" ],
            "Tunnel-Server-Endpoint"            => [ 67,   "string" ],
            "Tunnel-Type"                       => [ 64,   "integer" ],
            "User-Category"                     => [ 1029, "string" ],
            "User-Name"                         => [ 1,    "string" ],
            "User-Password"                     => [ 2,    "string" ],
            "User-Priority-Table"               => [ 59,   "octets" ],
            "User-Profile"                      => [ 1062, "string" ],
            "User-Service-Type"                 => [ 6,    "integer" ],
            "Vendor-Specific"                   => [ 26,   "vsa" ],
            "Virtual-Server"                    => [ 1099, "string" ],
            "WiMAX-MN-NAI"                      => [ 1900, "string" ],
            "WiMAX-SIM-AMF"                     => [ 1903, "octets" ],
            "WiMAX-SIM-Ki"                      => [ 1901, "octets" ],
            "WiMAX-SIM-OPc"                     => [ 1902, "octets" ],
            "WiMAX-SIM-RAND"                    => [ 1905, "octets" ],
            "WiMAX-SIM-SQN"                     => [ 1904, "octets" ],
            "WLAN-AKM-Suite"                    => [ 188,  "integer" ],
            "WLAN-Group-Cipher"                 => [ 187,  "integer" ],
            "WLAN-Group-Mgmt-Cipher"            => [ 189,  "integer" ],
            "WLAN-HESSID"                       => [ 181,  "string" ],
            "WLAN-Pairwise-Cipher"              => [ 186,  "integer" ],
            "WLAN-Reason-Code"                  => [ 185,  "integer" ],
            "WLAN-RF-Band"                      => [ 190,  "integer" ],
            "WLAN-Venue-Info"                   => [ 182,  "integer" ],
            "WLAN-Venue-Language"               => [ 183,  "octets" ],
            "WLAN-Venue-Name"                   => [ 184,  "string" ],
            "X-Ascend-Add-Seconds"              => [ 240,  "integer" ],
            "X-Ascend-Ara-PW"                   => [ 181,  "string" ],
            "X-Ascend-Assign-IP-Client"         => [ 144,  "ipaddr" ],
            "X-Ascend-Assign-IP-Global-Pool"    => [ 146,  "string" ],
            "X-Ascend-Assign-IP-Pool"           => [ 218,  "integer" ],
            "X-Ascend-Assign-IP-Server"         => [ 145,  "ipaddr" ],
            "X-Ascend-Authen-Alias"             => [ 203,  "string" ],
            "X-Ascend-Backup"                   => [ 176,  "string" ],
            "X-Ascend-BACP-Enable"              => [ 133,  "integer" ],
            "X-Ascend-Base-Channel-Count"       => [ 172,  "integer" ],
            "X-Ascend-Billing-Number"           => [ 249,  "string" ],
            "X-Ascend-Bridge"                   => [ 230,  "integer" ],
            "X-Ascend-Bridge-Address"           => [ 168,  "string" ],
            "X-Ascend-Call-Attempt-Limit"       => [ 123,  "integer" ],
            "X-Ascend-Call-Block-Duration"      => [ 124,  "integer" ],
            "X-Ascend-Call-By-Call"             => [ 250,  "integer" ],
            "X-Ascend-Call-Filter"              => [ 243,  "abinary" ],
            "X-Ascend-Call-Type"                => [ 177,  "integer" ],
            "X-Ascend-Callback"                 => [ 246,  "integer" ],
            "X-Ascend-Client-Assign-DNS"        => [ 137,  "integer" ],
            "X-Ascend-Client-Gateway"           => [ 132,  "ipaddr" ],
            "X-Ascend-Client-Primary-DNS"       => [ 135,  "ipaddr" ],
            "X-Ascend-Client-Secondary-DNS"     => [ 136,  "ipaddr" ],
            "X-Ascend-Connect-Progress"         => [ 196,  "integer" ],
            "X-Ascend-Data-Filter"              => [ 242,  "abinary" ],
            "X-Ascend-Data-Rate"                => [ 197,  "integer" ],
            "X-Ascend-Data-Svc"                 => [ 247,  "integer" ],
            "X-Ascend-DBA-Monitor"              => [ 171,  "integer" ],
            "X-Ascend-Dec-Channel-Count"        => [ 237,  "integer" ],
            "X-Ascend-DHCP-Maximum-Leases"      => [ 134,  "integer" ],
            "X-Ascend-DHCP-Pool-Number"         => [ 148,  "integer" ],
            "X-Ascend-DHCP-Reply"               => [ 147,  "integer" ],
            "X-Ascend-Dial-Number"              => [ 227,  "string" ],
            "X-Ascend-Dialout-Allowed"          => [ 131,  "integer" ],
            "X-Ascend-Disconnect-Cause"         => [ 195,  "integer" ],
            "X-Ascend-Event-Type"               => [ 150,  "integer" ],
            "X-Ascend-Expect-Callback"          => [ 149,  "integer" ],
            "X-Ascend-FCP-Parameter"            => [ 119,  "string" ],
            "X-Ascend-First-Dest"               => [ 189,  "ipaddr" ],
            "X-Ascend-Force-56"                 => [ 248,  "integer" ],
            "X-Ascend-FR-Circuit-Name"          => [ 156,  "string" ],
            "X-Ascend-FR-DCE-N392"              => [ 162,  "integer" ],
            "X-Ascend-FR-DCE-N393"              => [ 164,  "integer" ],
            "X-Ascend-FR-Direct"                => [ 219,  "integer" ],
            "X-Ascend-FR-Direct-DLCI"           => [ 221,  "integer" ],
            "X-Ascend-FR-Direct-Profile"        => [ 220,  "string" ],
            "X-Ascend-FR-DLCI"                  => [ 179,  "integer" ],
            "X-Ascend-FR-DTE-N392"              => [ 163,  "integer" ],
            "X-Ascend-FR-DTE-N393"              => [ 165,  "integer" ],
            "X-Ascend-FR-Link-Mgt"              => [ 160,  "integer" ],
            "X-Ascend-FR-LinkUp"                => [ 157,  "integer" ],
            "X-Ascend-FR-N391"                  => [ 161,  "integer" ],
            "X-Ascend-FR-Nailed-Grp"            => [ 158,  "integer" ],
            "X-Ascend-FR-Profile-Name"          => [ 180,  "string" ],
            "X-Ascend-FR-T391"                  => [ 166,  "integer" ],
            "X-Ascend-FR-T392"                  => [ 167,  "integer" ],
            "X-Ascend-FR-Type"                  => [ 159,  "integer" ],
            "X-Ascend-FT1-Caller"               => [ 175,  "integer" ],
            "X-Ascend-Group"                    => [ 178,  "string" ],
            "X-Ascend-Handle-IPX"               => [ 222,  "integer" ],
            "X-Ascend-History-Weigh-Type"       => [ 239,  "integer" ],
            "X-Ascend-Home-Agent-IP-Addr"       => [ 183,  "ipaddr" ],
            "X-Ascend-Home-Agent-Password"      => [ 184,  "string" ],
            "X-Ascend-Home-Agent-UDP-Port"      => [ 186,  "integer" ],
            "X-Ascend-Home-Network-Name"        => [ 185,  "string" ],
            "X-Ascend-Host-Info"                => [ 252,  "string" ],
            "X-Ascend-Idle-Limit"               => [ 244,  "integer" ],
            "X-Ascend-IF-Netmask"               => [ 153,  "ipaddr" ],
            "X-Ascend-Inc-Channel-Count"        => [ 236,  "integer" ],
            "X-Ascend-IP-Direct"                => [ 209,  "ipaddr" ],
            "X-Ascend-IP-Pool-Definition"       => [ 217,  "string" ],
            "X-Ascend-IPX-Alias"                => [ 224,  "integer" ],
            "X-Ascend-IPX-Node-Addr"            => [ 182,  "string" ],
            "X-Ascend-IPX-Peer-Mode"            => [ 216,  "integer" ],
            "X-Ascend-IPX-Route"                => [ 174,  "string" ],
            "X-Ascend-Link-Compression"         => [ 233,  "integer" ],
            "X-Ascend-Maximum-Call-Duration"    => [ 125,  "integer" ],
            "X-Ascend-Maximum-Channels"         => [ 235,  "integer" ],
            "X-Ascend-Maximum-Time"             => [ 194,  "integer" ],
            "X-Ascend-Menu-Item"                => [ 206,  "string" ],
            "X-Ascend-Menu-Selector"            => [ 205,  "string" ],
            "X-Ascend-Metric"                   => [ 225,  "integer" ],
            "X-Ascend-Minimum-Channels"         => [ 173,  "integer" ],
            "X-Ascend-Modem-PortNo"             => [ 120,  "integer" ],
            "X-Ascend-Modem-ShelfNo"            => [ 122,  "integer" ],
            "X-Ascend-Modem-SlotNo"             => [ 121,  "integer" ],
            "X-Ascend-MPP-Idle-Percent"         => [ 254,  "integer" ],
            "X-Ascend-Multicast-Client"         => [ 155,  "integer" ],
            "X-Ascend-Multicast-Rate-Limit"     => [ 152,  "integer" ],
            "X-Ascend-Multilink-ID"             => [ 187,  "integer" ],
            "X-Ascend-Netware-timeout"          => [ 223,  "integer" ],
            "X-Ascend-Num-In-Multilink"         => [ 188,  "integer" ],
            "X-Ascend-Number-Sessions"          => [ 202,  "string" ],
            "X-Ascend-PPP-Address"              => [ 253,  "ipaddr" ],
            "X-Ascend-PPP-Async-Map"            => [ 212,  "integer" ],
            "X-Ascend-PPP-VJ-1172"              => [ 211,  "integer" ],
            "X-Ascend-PPP-VJ-Slot-Comp"         => [ 210,  "integer" ],
            "X-Ascend-Pre-Input-Octets"         => [ 190,  "integer" ],
            "X-Ascend-Pre-Input-Packets"        => [ 192,  "integer" ],
            "X-Ascend-Pre-Output-Octets"        => [ 191,  "integer" ],
            "X-Ascend-Pre-Output-Packets"       => [ 193,  "integer" ],
            "X-Ascend-Preempt-Limit"            => [ 245,  "integer" ],
            "X-Ascend-PreSession-Time"          => [ 198,  "integer" ],
            "X-Ascend-PRI-Number-Type"          => [ 226,  "integer" ],
            "X-Ascend-Primary-Home-Agent"       => [ 129,  "string" ],
            "X-Ascend-PW-Lifetime"              => [ 208,  "integer" ],
            "X-Ascend-PW-Warntime"              => [ 207,  "integer" ],
            "X-Ascend-Receive-Secret"           => [ 215,  "string" ],
            "X-Ascend-Remote-Addr"              => [ 154,  "ipaddr" ],
            "X-Ascend-Remove-Seconds"           => [ 241,  "integer" ],
            "X-Ascend-Require-Auth"             => [ 201,  "integer" ],
            "X-Ascend-Route-IP"                 => [ 228,  "integer" ],
            "X-Ascend-Route-IPX"                => [ 229,  "integer" ],
            "X-Ascend-Secondary-Home-Agent"     => [ 130,  "string" ],
            "X-Ascend-Seconds-Of-History"       => [ 238,  "integer" ],
            "X-Ascend-Send-Auth"                => [ 231,  "integer" ],
            "X-Ascend-Send-Passwd"              => [ 232,  "string" ],
            "X-Ascend-Send-Secret"              => [ 214,  "string" ],
            "X-Ascend-Session-Svr-Key"          => [ 151,  "string" ],
            "X-Ascend-Shared-Profile-Enable"    => [ 128,  "integer" ],
            "X-Ascend-Target-Util"              => [ 234,  "integer" ],
            "X-Ascend-Temporary-Rtes"           => [ 126,  "integer" ],
            "X-Ascend-Third-Prompt"             => [ 213,  "string" ],
            "X-Ascend-Token-Expiry"             => [ 204,  "integer" ],
            "X-Ascend-Token-Idle"               => [ 199,  "integer" ],
            "X-Ascend-Token-Immediate"          => [ 200,  "integer" ],
            "X-Ascend-Transit-Number"           => [ 251,  "string" ],
            "X-Ascend-TS-Idle-Limit"            => [ 169,  "integer" ],
            "X-Ascend-TS-Idle-Mode"             => [ 170,  "integer" ],
            "X-Ascend-Tunneling-Protocol"       => [ 127,  "integer" ],
            "X-Ascend-User-Acct-Base"           => [ 142,  "integer" ],
            "X-Ascend-User-Acct-Host"           => [ 139,  "ipaddr" ],
            "X-Ascend-User-Acct-Key"            => [ 141,  "string" ],
            "X-Ascend-User-Acct-Port"           => [ 140,  "integer" ],
            "X-Ascend-User-Acct-Time"           => [ 143,  "integer" ],
            "X-Ascend-User-Acct-Type"           => [ 138,  "integer" ],
            "X-Ascend-Xmit-Rate"                => [ 255,  "integer" ],
        },
        avendors => {
            "3Com-Connect_Id"                                        => "3com",
            "3Com-Encryption-Type"                                   => "3com",
            "3Com-End-Date"                                          => "3com",
            "3Com-Ip-Host-Addr"                                      => "3com",
            "3Com-Mobility-Profile"                                  => "3com",
            "3Com-NAS-Startup-Timestamp"                             => "3com",
            "3Com-Product-ID"                                        => "3com",
            "3Com-SSID"                                              => "3com",
            "3Com-Time-Of-Day"                                       => "3com",
            "3Com-URL"                                               => "3com",
            "3Com-User-Access-Level"                                 => "3com",
            "3Com-VLAN-Name"                                         => "3com",
            "3GPP-Allocate-IP-Type"                                  => "3GPP",
            "3GPP-Camel-Charging-Info"                               => "3GPP",
            "3GPP-Charging-Characteristics"                          => "3GPP",
            "3GPP-Charging-Gateway-Address"                          => "3GPP",
            "3GPP-Charging-Gateway-IPv6-Address"                     => "3GPP",
            "3GPP-Charging-ID"                                       => "3GPP",
            "3GPP-GGSN-Address"                                      => "3GPP",
            "3GPP-GGSN-IPv6-Address"                                 => "3GPP",
            "3GPP-GGSN-MCC-MNC"                                      => "3GPP",
            "3GPP-GPRS-Negotiated-QoS-profile"                       => "3GPP",
            "3GPP-IMEISV"                                            => "3GPP",
            "3GPP-IMSI"                                              => "3GPP",
            "3GPP-IMSI-MCC-MNC"                                      => "3GPP",
            "3GPP-IPv6-DNS-Servers"                                  => "3GPP",
            "3GPP-Location-Info"                                     => "3GPP",
            "3GPP-MS-Time-Zone"                                      => "3GPP",
            "3GPP-Negotiated-DSCP"                                   => "3GPP",
            "3GPP-NSAPI"                                             => "3GPP",
            "3GPP-Packet-Filter"                                     => "3GPP",
            "3GPP-PDP-Type"                                          => "3GPP",
            "3GPP-RAT-Type"                                          => "3GPP",
            "3GPP-Selection-Mode"                                    => "3GPP",
            "3GPP-Session-Stop-Indicator"                            => "3GPP",
            "3GPP-SGSN-Address"                                      => "3GPP",
            "3GPP-SGSN-IPv6-Address"                                 => "3GPP",
            "3GPP-SGSN-MCC-MNC"                                      => "3GPP",
            "3GPP-Teardown-Indicator"                                => "3GPP",
            "3GPP-User-Location-Info"                                => "3GPP",
            "3GPP2-Accounting-Container"                             => "3GPP2",
            "3GPP2-Acct-Stop-Trigger"                                => "3GPP2",
            "3GPP2-Active-Time"                                      => "3GPP2",
            "3GPP2-Airlink-Priority"                                 => "3GPP2",
            "3GPP2-Airlink-Record-Type"                              => "3GPP2",
            "3GPP2-Airlink-Sequence-Number"                          => "3GPP2",
            "3GPP2-Allowed-Diffserv-Marking"                         => "3GPP2",
            "3GPP2-Allowed-Diffserv-Marking-Allowed"                 => "3GPP2",
            "3GPP2-Allowed-Diffserv-Marking-Max-Class"               => "3GPP2",
            "3GPP2-Allowed-Diffserv-Marking-Reverse-Runnel"          => "3GPP2",
            "3GPP2-Allowed-Persistent-TFTs"                          => "3GPP2",
            "3GPP2-Bad-PPP-Frame-Count"                              => "3GPP2",
            "3GPP2-Begin-Session"                                    => "3GPP2",
            "3GPP2-BSID"                                             => "3GPP2",
            "3GPP2-Carrier-ID"                                       => "3GPP2",
            "3GPP2-Compulsory-Tunnel-Indicator"                      => "3GPP2",
            "3GPP2-Correlation-Id"                                   => "3GPP2",
            "3GPP2-DCCH-Frame-Size"                                  => "3GPP2",
            "3GPP2-Diffserv-Class-Option"                            => "3GPP2",
            "3GPP2-Disconnect-Reason"                                => "3GPP2",
            "3GPP2-DNS-Server-Entity-Type"                           => "3GPP2",
            "3GPP2-DNS-Server-Flag"                                  => "3GPP2",
            "3GPP2-DNS-Server-IP-Address"                            => "3GPP2",
            "3GPP2-DNS-Server-Primary-IP-Address"                    => "3GPP2",
            "3GPP2-DNS-Server-Secondary-IP-Address"                  => "3GPP2",
            "3GPP2-DNS-Update-Capability"                            => "3GPP2",
            "3GPP2-DNS-Update-Required"                              => "3GPP2",
            "3GPP2-ESN"                                              => "3GPP2",
            "3GPP2-FCH-Frame-Size"                                   => "3GPP2",
            "3GPP2-Foreign-Agent-Address"                            => "3GPP2",
            "3GPP2-Forward-DCCH-Mux-Option"                          => "3GPP2",
            "3GPP2-Forward-DCCH-RC"                                  => "3GPP2",
            "3GPP2-Forward-FCH-Mux-Option"                           => "3GPP2",
            "3GPP2-Forward-FCH-RC"                                   => "3GPP2",
            "3GPP2-Forward-PDCH-RC"                                  => "3GPP2",
            "3GPP2-Forward-Traffic-Type"                             => "3GPP2",
            "3GPP2-GMT-Time-Zone-Offset"                             => "3GPP2",
            "3GPP2-HA-Authorised"                                    => "3GPP2",
            "3GPP2-HA-Request"                                       => "3GPP2",
            "3GPP2-Home-Agent-IP-Address"                            => "3GPP2",
            "3GPP2-Ike-Preshared-Secret-Request"                     => "3GPP2",
            "3GPP2-Inbound-Mobile-IP-Sig-Octets"                     => "3GPP2",
            "3GPP2-IP-QoS"                                           => "3GPP2",
            "3GPP2-IP-Technology"                                    => "3GPP2",
            "3GPP2-IP-Ver-Authorised"                                => "3GPP2",
            "3GPP2-KeyID"                                            => "3GPP2",
            "3GPP2-Last-User-Activity-Time"                          => "3GPP2",
            "3GPP2-MEID"                                             => "3GPP2",
            "3GPP2-MIP-Lifetime"                                     => "3GPP2",
            "3GPP2-MIPv4-Mesg-Id"                                    => "3GPP2",
            "3GPP2-MN-AAA-Removal-Indication"                        => "3GPP2",
            "3GPP2-MN-HA-Shared-Key"                                 => "3GPP2",
            "3GPP2-MN-HA-SPI"                                        => "3GPP2",
            "3GPP2-Module-Orig-Term-Indicator"                       => "3GPP2",
            "3GPP2-Number-Active-Transitions"                        => "3GPP2",
            "3GPP2-Originating-Number-SDBs"                          => "3GPP2",
            "3GPP2-Originating-SDB-OCtet-Count"                      => "3GPP2",
            "3GPP2-Outbound-Mobile-IP-Sig-Octets"                    => "3GPP2",
            "3GPP2-PCF-IP-Address"                                   => "3GPP2",
            "3GPP2-Pre-Shared-Secret"                                => "3GPP2",
            "3GPP2-Prepaid-acct-Capability"                          => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota"                               => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-QuotaIDentifier"               => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-UpdateReason"                  => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-VolumeQuota"                   => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-VolumeQuotaOverflow"           => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-VolumeThreshold"               => "3GPP2",
            "3GPP2-Prepaid-Acct-Quota-VolumeThresholdOverflow"       => "3GPP2",
            "3GPP2-Prepaid-Quota-Identifier"                         => "3GPP2",
            "3GPP2-Prepaid-Tariff-Switch-Interval"                   => "3GPP2",
            "3GPP2-PrePaid-Tariff-Switching"                         => "3GPP2",
            "3GPP2-Prepaid-Time-Interval-After-Tariff-Switch-Update" => "3GPP2",
            "3GPP2-Prepaid-Volume-Used-After-Tariff-Switch"          => "3GPP2",
            "3GPP2-Prepaid-Volume-Used-ATS-Overflow"                 => "3GPP2",
            "3GPP2-Received-HDLC-Octets"                             => "3GPP2",
            "3GPP2-Release-Indicator"                                => "3GPP2",
            "3GPP2-Remote-Address-Table-Index"                       => "3GPP2",
            "3GPP2-Remote-Address-Table-Index-Qualifier"             => "3GPP2",
            "3GPP2-Remote-Address-Table-Index-Value"                 => "3GPP2",
            "3GPP2-Remote-IP-Address"                                => "3GPP2",
            "3GPP2-Remote-IP-Address-Mask"                           => "3GPP2",
            "3GPP2-Remote-IP-Address-Value"                          => "3GPP2",
            "3GPP2-Remote-IP-Qualifier"                              => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count"                     => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Address"             => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Forward"             => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Forward-Overflow"    => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Mask"                => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Reverse"             => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Reverse-Overflow"    => "3GPP2",
            "3GPP2-Remote-IPv4-Addr-Octet-Count-Table-Index"         => "3GPP2",
            "3GPP2-Remote-IPv6-Address"                              => "3GPP2",
            "3GPP2-Remote-IPv6-Address-Prefix-Length"                => "3GPP2",
            "3GPP2-Remote-IPv6-Address-Qualifier"                    => "3GPP2",
            "3GPP2-Remote-IPv6-Address-Value"                        => "3GPP2",
            "3GPP2-Remote-IPv6-Count-Address"                        => "3GPP2",
            "3GPP2-Remote-IPv6-Forward-Octet-Count"                  => "3GPP2",
            "3GPP2-Remote-IPv6-Octet-Count"                          => "3GPP2",
            "3GPP2-Remote-IPv6-Prefix-Length"                        => "3GPP2",
            "3GPP2-Remote-IPv6-Reverse-Octet-Count"                  => "3GPP2",
            "3GPP2-Remote-IPv6-Reverse-Octet-Count-Overflow"         => "3GPP2",
            "3GPP2-Remote-IPv6-Table-Index"                          => "3GPP2",
            "3GPP2-Reverse-DCCH-Mux-Option"                          => "3GPP2",
            "3GPP2-Reverse-DHHC-RC"                                  => "3GPP2",
            "3GPP2-Reverse-FCH-Mux-Option"                           => "3GPP2",
            "3GPP2-Reverse-FCH-RC"                                   => "3GPP2",
            "3GPP2-Reverse-Traffic-Type"                             => "3GPP2",
            "3GPP2-Reverse-Tunnel-Spec"                              => "3GPP2",
            "3GPP2-RN-Packet-Data-Inactivity-Timer"                  => "3GPP2",
            "3GPP2-S-Key"                                            => "3GPP2",
            "3GPP2-S-Lifetime"                                       => "3GPP2",
            "3GPP2-S-Request"                                        => "3GPP2",
            "3GPP2-Security-Level"                                   => "3GPP2",
            "3GPP2-Service-Option"                                   => "3GPP2",
            "3GPP2-Service-Option-Profile"                           => "3GPP2",
            "3GPP2-Service-Option-Profile-Option"                    => "3GPP2",
            "3GPP2-Service-Reference-Id"                             => "3GPP2",
            "3GPP2-Service-Reference-Id-Value"                       => "3GPP2",
            "3GPP2-Service-Reference-Main-SC-Indicator"              => "3GPP2",
            "3GPP2-Session-Continue"                                 => "3GPP2",
            "3GPP2-Session-Termination-Capability"                   => "3GPP2",
            "3GPP2-Terminating-Number-SDBs"                          => "3GPP2",
            "3GPP2-Terminating-SDB-Octet-Count"                      => "3GPP2",
            "3GPP2-User-Id"                                          => "3GPP2",
            "A-AL-AAA"                                  => "Alcatel-ESAM",
            "A-AL-Alarm"                                => "Alcatel-ESAM",
            "A-AL-ATM"                                  => "Alcatel-ESAM",
            "A-AL-Cluster"                              => "Alcatel-ESAM",
            "A-AL-CPEProxy"                             => "Alcatel-ESAM",
            "A-AL-Description"                          => "Alcatel-ESAM",
            "A-AL-DHCP"                                 => "Alcatel-ESAM",
            "A-AL-EQP"                                  => "Alcatel-ESAM",
            "A-AL-IGMP"                                 => "Alcatel-ESAM",
            "A-AL-IP"                                   => "Alcatel-ESAM",
            "A-AL-Maintenance"                          => "Alcatel-ESAM",
            "A-AL-MAINTENANCE-BACKWARD"                 => "Alcatel-ESAM",
            "A-AL-PPPoE"                                => "Alcatel-ESAM",
            "A-AL-Prompt"                               => "Alcatel-ESAM",
            "A-AL-Provisioning"                         => "Alcatel-ESAM",
            "A-AL-PROVISIONING-BACKWARD"                => "Alcatel-ESAM",
            "A-AL-Pwd-Timeout"                          => "Alcatel-ESAM",
            "A-AL-QoS"                                  => "Alcatel-ESAM",
            "A-AL-Security"                             => "Alcatel-ESAM",
            "A-AL-SLOT-NUMBERING"                       => "Alcatel-ESAM",
            "A-AL-SWMgt"                                => "Alcatel-ESAM",
            "A-AL-Test"                                 => "Alcatel-ESAM",
            "A-AL-TEST-BACKWARD"                        => "Alcatel-ESAM",
            "A-AL-TL1-Security"                         => "Alcatel-ESAM",
            "A-AL-TL1-SECURITY-BACKWARD"                => "Alcatel-ESAM",
            "A-AL-Transport"                            => "Alcatel-ESAM",
            "A-AL-VLAN"                                 => "Alcatel-ESAM",
            "A-AL-XDSL"                                 => "Alcatel-ESAM",
            "A-ESAM-QOS-Params"                         => "Alcatel-ESAM",
            "A-ESAM-QOS-Profile-Name"                   => "Alcatel-ESAM",
            "A-ESAM-Termination-Cause"                  => "Alcatel-ESAM",
            "A-ESAM-Vlan-Id"                            => "Alcatel-ESAM",
            "A-ESAM-VRF-Name"                           => "Alcatel-ESAM",
            "AAT-Assign-IP-Pool"                        => "Alcatel",
            "AAT-ATM-Direct"                            => "Alcatel",
            "AAT-ATM-Traffic-Profile"                   => "Alcatel",
            "AAT-ATM-VCI"                               => "Alcatel",
            "AAT-ATM-VPI"                               => "Alcatel",
            "AAT-Auth-Type"                             => "Alcatel",
            "AAT-Client-Assign-DNS"                     => "Alcatel",
            "AAT-Client-Primary-DNS"                    => "Alcatel",
            "AAT-Client-Primary-WINS-NBNS"              => "Alcatel",
            "AAT-Client-Secondary-DNS"                  => "Alcatel",
            "AAT-Client-Secondary-WINS-NBNS"            => "Alcatel",
            "AAT-Data-Filter"                           => "Alcatel",
            "AAT-Filter"                                => "Alcatel",
            "AAT-FR-Direct"                             => "Alcatel",
            "AAT-FR-Direct-DLCI"                        => "Alcatel",
            "AAT-FR-Direct-Profile"                     => "Alcatel",
            "AAT-Home-Agent-Password"                   => "Alcatel",
            "AAT-Home-Agent-UDP-Port"                   => "Alcatel",
            "AAT-Home-Network-Name"                     => "Alcatel",
            "AAT-Input-Octets-Diff"                     => "Alcatel",
            "AAT-IP-Direct"                             => "Alcatel",
            "AAT-IP-Pool-Definition"                    => "Alcatel",
            "AAT-IP-TOS"                                => "Alcatel",
            "AAT-IP-TOS-Apply-To"                       => "Alcatel",
            "AAT-IP-TOS-Precedence"                     => "Alcatel",
            "AAT-MCast-Client"                          => "Alcatel",
            "AAT-Modem-Answer-String"                   => "Alcatel",
            "AAT-Modem-Port-No"                         => "Alcatel",
            "AAT-Modem-Shelf-No"                        => "Alcatel",
            "AAT-Modem-Slot-No"                         => "Alcatel",
            "AAT-Output-Octets-Diff"                    => "Alcatel",
            "AAT-PPP-Address"                           => "Alcatel",
            "AAT-PPP-Netmask"                           => "Alcatel",
            "AAT-Primary-Home-Agent"                    => "Alcatel",
            "AAT-Qoa"                                   => "Alcatel",
            "AAT-Qos"                                   => "Alcatel",
            "AAT-Require-Auth"                          => "Alcatel",
            "AAT-Secondary-Home-Agent"                  => "Alcatel",
            "AAT-Source-IP-Check"                       => "Alcatel",
            "AAT-User-MAC-Address"                      => "Alcatel",
            "AAT-Vrouter-Name"                          => "Alcatel",
            "Acc-Access-Community"                      => "Acc",
            "Acc-Access-Partition"                      => "Acc",
            "Acc-Acct-On-Off-Reason"                    => "Acc",
            "Acc-Ace-Token"                             => "Acc",
            "Acc-Ace-Token-Ttl"                         => "Acc",
            "Acc-Apsm-Oversubscribed"                   => "Acc",
            "Acc-Bridging-Support"                      => "Acc",
            "Acc-Callback-CBCP-Type"                    => "Acc",
            "Acc-Callback-Delay"                        => "Acc",
            "Acc-Callback-Mode"                         => "Acc",
            "Acc-Callback-Num-Valid"                    => "Acc",
            "Acc-Calling-Station-Category"              => "Acc",
            "Acc-Ccp-Option"                            => "Acc",
            "Acc-Clearing-Cause"                        => "Acc",
            "Acc-Clearing-Location"                     => "Acc",
            "Acc-Connect-Rx-Speed"                      => "Acc",
            "Acc-Connect-Tx-Speed"                      => "Acc",
            "Acc-Customer-Id"                           => "Acc",
            "Acc-Dial-Port-Index"                       => "Acc",
            "Acc-Dialout-Auth-Mode"                     => "Acc",
            "Acc-Dialout-Auth-Password"                 => "Acc",
            "Acc-Dialout-Auth-Username"                 => "Acc",
            "Acc-Dns-Server-Pri"                        => "Acc",
            "Acc-Dns-Server-Sec"                        => "Acc",
            "Acc-Igmp-Admin-State"                      => "Acc",
            "Acc-Igmp-Version"                          => "Acc",
            "Acc-Input-Errors"                          => "Acc",
            "Acc-Ip-Compression"                        => "Acc",
            "Acc-Ip-Gateway-Pri"                        => "Acc",
            "Acc-Ip-Gateway-Sec"                        => "Acc",
            "Acc-Ip-Pool-Name"                          => "Acc",
            "Acc-Ipx-Compression"                       => "Acc",
            "Acc-Location-Id"                           => "Acc",
            "Acc-ML-Call-Threshold"                     => "Acc",
            "Acc-ML-Clear-Threshold"                    => "Acc",
            "Acc-ML-Damping-Factor"                     => "Acc",
            "Acc-ML-MLX-Admin-State"                    => "Acc",
            "Acc-MN-HA-Secret"                          => "Acc",
            "Acc-Modem-Error-Protocol"                  => "Acc",
            "Acc-Modem-Modulation-Type"                 => "Acc",
            "Acc-Nbns-Server-Pri"                       => "Acc",
            "Acc-Nbns-Server-Sec"                       => "Acc",
            "Acc-Output-Errors"                         => "Acc",
            "Acc-Reason-Code"                           => "Acc",
            "Acc-Request-Type"                          => "Acc",
            "Acc-Route-Policy"                          => "Acc",
            "Acc-Service-Profile"                       => "Acc",
            "Acc-Tunnel-Port"                           => "Acc",
            "Acc-Tunnel-Secret"                         => "Acc",
            "Acc-Vpsm-Reject-Cause"                     => "Acc",
            "Access-Loop-Encapsulation"                 => "ADSL-Forum",
            "Acct-Alt-Session-ID"                       => "Ericsson-AB",
            "Acct-Dyn-Ac-Ent"                           => "Ericsson-AB",
            "Acct-Input-IPv4-Gigawords"                 => "Ericsson-AB",
            "Acct-Input-IPv4-Octets"                    => "Ericsson-AB",
            "Acct-Input-IPv4-Packets"                   => "Ericsson-AB",
            "Acct-Input-IPv6-Gigawords"                 => "Ericsson-AB",
            "Acct-Input-IPv6-Octets"                    => "Ericsson-AB",
            "Acct-Input-IPv6-Packets"                   => "Ericsson-AB",
            "Acct-Input-Octets-64"                      => "Ericsson-AB",
            "Acct-Input-Packets-64"                     => "Ericsson-AB",
            "Acct-Interim-Record-Number"                => "VerizonWireless",
            "Acct-Mcast-In-Octets"                      => "Ericsson-AB",
            "Acct-Mcast-In-Octets-64"                   => "Ericsson-AB",
            "Acct-Mcast-In-Packets"                     => "Ericsson-AB",
            "Acct-Mcast-In-Packets-64"                  => "Ericsson-AB",
            "Acct-Mcast-Out-Octets"                     => "Ericsson-AB",
            "Acct-Mcast-Out-Octets-64"                  => "Ericsson-AB",
            "Acct-Mcast-Out-Packets"                    => "Ericsson-AB",
            "Acct-Mcast-Out-Packets-64"                 => "Ericsson-AB",
            "Acct-Output-IPv4-Gigawords"                => "Ericsson-AB",
            "Acct-Output-IPv4-Octets"                   => "Ericsson-AB",
            "Acct-Output-IPv4-Packets"                  => "Ericsson-AB",
            "Acct-Output-IPv6-Gigawords"                => "Ericsson-AB",
            "Acct-Output-IPv6-Octets"                   => "Ericsson-AB",
            "Acct-Output-IPv6-Packets"                  => "Ericsson-AB",
            "Acct-Output-Octets-64"                     => "Ericsson-AB",
            "Acct-Output-Packets-64"                    => "Ericsson-AB",
            "Acct-Session-Gigawords"                    => "Gemtek",
            "Acct-Session-Input-Gigawords"              => "Gemtek",
            "Acct-Session-Input-Octets"                 => "Gemtek",
            "Acct-Session-Octets"                       => "Gemtek",
            "Acct-Session-Output-Gigawords"             => "Gemtek",
            "Acct-Session-Output-Octets"                => "Gemtek",
            "Acct-Update-Reason"                        => "Ericsson-AB",
            "ACL-Auth-Level"                            => "AudioCodes",
            "ACL-Definition"                            => "Ericsson-AB",
            "Acme-Called-MOS"                           => "Acme",
            "Acme-Called-Octets_FS1"                    => "Acme",
            "Acme-Called-Octets_FS2"                    => "Acme",
            "Acme-Called-Packets_FS1"                   => "Acme",
            "Acme-Called-Packets_FS2"                   => "Acme",
            "Acme-Called-R-Factor"                      => "Acme",
            "Acme-Called-RTCP-Avg-Jitter_FS1"           => "Acme",
            "Acme-Called-RTCP-Avg-Jitter_FS2"           => "Acme",
            "Acme-Called-RTCP-Avg-Latency_FS1"          => "Acme",
            "Acme-Called-RTCP-Avg-Latency_FS2"          => "Acme",
            "Acme-Called-RTCP-MaxJitter_FS1"            => "Acme",
            "Acme-Called-RTCP-MaxJitter_FS2"            => "Acme",
            "Acme-Called-RTCP-MaxLatency_FS1"           => "Acme",
            "Acme-Called-RTCP-MaxLatency_FS2"           => "Acme",
            "Acme-Called-RTCP-Packets-Lost_FS1"         => "Acme",
            "Acme-Called-RTCP-Packets-Lost_FS2"         => "Acme",
            "Acme-Called-RTP-Avg-Jitter_FS1"            => "Acme",
            "Acme-Called-RTP-Avg-Jitter_FS2"            => "Acme",
            "Acme-Called-RTP-MaxJitter_FS1"             => "Acme",
            "Acme-Called-RTP-MaxJitter_FS2"             => "Acme",
            "Acme-Called-RTP-Packets-Lost_FS1"          => "Acme",
            "Acme-Called-RTP-Packets-Lost_FS2"          => "Acme",
            "Acme-Calling-MOS"                          => "Acme",
            "Acme-Calling-Octets_FS1"                   => "Acme",
            "Acme-Calling-Octets_FS2"                   => "Acme",
            "Acme-Calling-Packets_FS1"                  => "Acme",
            "Acme-Calling-Packets_FS2"                  => "Acme",
            "Acme-Calling-R-Factor"                     => "Acme",
            "Acme-Calling-RTCP-Avg-Jitter_FS1"          => "Acme",
            "Acme-Calling-RTCP-Avg-Jitter_FS2"          => "Acme",
            "Acme-Calling-RTCP-Avg-Latency_FS1"         => "Acme",
            "Acme-Calling-RTCP-Avg-Latency_FS2"         => "Acme",
            "Acme-Calling-RTCP-MaxJitter_FS1"           => "Acme",
            "Acme-Calling-RTCP-MaxJitter_FS2"           => "Acme",
            "Acme-Calling-RTCP-MaxLatency_FS1"          => "Acme",
            "Acme-Calling-RTCP-MaxLatency_FS2"          => "Acme",
            "Acme-Calling-RTCP-Packets-Lost_FS1"        => "Acme",
            "Acme-Calling-RTCP-Packets-Lost_FS2"        => "Acme",
            "Acme-Calling-RTP-Avg-Jitter_FS1"           => "Acme",
            "Acme-Calling-RTP-Avg-Jitter_FS2"           => "Acme",
            "Acme-Calling-RTP-MaxJitter_FS1"            => "Acme",
            "Acme-Calling-RTP-MaxJitter_FS2"            => "Acme",
            "Acme-Calling-RTP-Packets-Lost_FS1"         => "Acme",
            "Acme-Calling-RTP-Packets-Lost_FS2"         => "Acme",
            "Acme-CDR-Sequence-Number"                  => "Acme",
            "Acme-Custom-VSA-200"                       => "Acme",
            "Acme-Custom-VSA-201"                       => "Acme",
            "Acme-Custom-VSA-202"                       => "Acme",
            "Acme-Custom-VSA-203"                       => "Acme",
            "Acme-Custom-VSA-204"                       => "Acme",
            "Acme-Custom-VSA-205"                       => "Acme",
            "Acme-Custom-VSA-206"                       => "Acme",
            "Acme-Custom-VSA-207"                       => "Acme",
            "Acme-Custom-VSA-208"                       => "Acme",
            "Acme-Custom-VSA-209"                       => "Acme",
            "Acme-Custom-VSA-210"                       => "Acme",
            "Acme-Custom-VSA-211"                       => "Acme",
            "Acme-Custom-VSA-212"                       => "Acme",
            "Acme-Custom-VSA-213"                       => "Acme",
            "Acme-Custom-VSA-214"                       => "Acme",
            "Acme-Custom-VSA-215"                       => "Acme",
            "Acme-Custom-VSA-216"                       => "Acme",
            "Acme-Custom-VSA-217"                       => "Acme",
            "Acme-Custom-VSA-218"                       => "Acme",
            "Acme-Custom-VSA-219"                       => "Acme",
            "Acme-Custom-VSA-220"                       => "Acme",
            "Acme-Custom-VSA-221"                       => "Acme",
            "Acme-Custom-VSA-222"                       => "Acme",
            "Acme-Custom-VSA-223"                       => "Acme",
            "Acme-Custom-VSA-224"                       => "Acme",
            "Acme-Custom-VSA-225"                       => "Acme",
            "Acme-Custom-VSA-226"                       => "Acme",
            "Acme-Custom-VSA-227"                       => "Acme",
            "Acme-Custom-VSA-228"                       => "Acme",
            "Acme-Custom-VSA-229"                       => "Acme",
            "Acme-Custom-VSA-230"                       => "Acme",
            "Acme-Disconnect-Cause"                     => "Acme",
            "Acme-Disconnect-Initiator"                 => "Acme",
            "Acme-Domain-Name"                          => "Acme",
            "Acme-Egress-Final-Routing-Number"          => "Acme",
            "Acme-Egress-Local-Addr"                    => "Acme",
            "Acme-Egress-Network-Interface-Id"          => "Acme",
            "Acme-Egress-Remote-Addr"                   => "Acme",
            "Acme-Egress-Vlan-Tag-Value"                => "Acme",
            "Acme-Firmware-Version"                     => "Acme",
            "Acme-Flow-Called-Media-Stop-Time-FS1"      => "Acme",
            "Acme-Flow-Called-Media-Stop-Time-FS2"      => "Acme",
            "Acme-Flow-Calling-Media-Stop-Time-FS1"     => "Acme",
            "Acme-Flow-Calling-Media-Stop-Time-FS2"     => "Acme",
            "Acme-Flow-In-Dst-Addr_FS1_F"               => "Acme",
            "Acme-Flow-In-Dst-Addr_FS1_R"               => "Acme",
            "Acme-Flow-In-Dst-Addr_FS2_F"               => "Acme",
            "Acme-Flow-In-Dst-Addr_FS2_R"               => "Acme",
            "Acme-Flow-In-Dst-IPv6_Addr_FS1_F"          => "Acme",
            "Acme-Flow-In-Dst-IPv6_Addr_FS1_R"          => "Acme",
            "Acme-Flow-In-Dst-IPv6_Addr_FS2_F"          => "Acme",
            "Acme-Flow-In-Dst-IPv6_Addr_FS2_R"          => "Acme",
            "Acme-Flow-In-Dst-Port_FS1_F"               => "Acme",
            "Acme-Flow-In-Dst-Port_FS1_R"               => "Acme",
            "Acme-Flow-In-Dst-Port_FS2_F"               => "Acme",
            "Acme-Flow-In-Dst-Port_FS2_R"               => "Acme",
            "Acme-Flow-In-Realm_FS1_F"                  => "Acme",
            "Acme-Flow-In-Realm_FS1_R"                  => "Acme",
            "Acme-Flow-In-Realm_FS2_F"                  => "Acme",
            "Acme-Flow-In-Realm_FS2_R"                  => "Acme",
            "Acme-Flow-In-Src-Addr_FS1_F"               => "Acme",
            "Acme-Flow-In-Src-Addr_FS1_R"               => "Acme",
            "Acme-Flow-In-Src-Addr_FS2_F"               => "Acme",
            "Acme-Flow-In-Src-Addr_FS2_R"               => "Acme",
            "Acme-Flow-In-Src-IPv6_Addr_FS1_F"          => "Acme",
            "Acme-Flow-In-Src-IPv6_Addr_FS1_R"          => "Acme",
            "Acme-Flow-In-Src-IPv6_Addr_FS2_F"          => "Acme",
            "Acme-Flow-In-Src-IPv6_Addr_FS2_R"          => "Acme",
            "Acme-Flow-In-Src-Port_FS1_F"               => "Acme",
            "Acme-Flow-In-Src-Port_FS1_R"               => "Acme",
            "Acme-Flow-In-Src-Port_FS2_F"               => "Acme",
            "Acme-Flow-In-Src-Port_FS2_R"               => "Acme",
            "Acme-Flow-Out-Dst-Addr_FS1_F"              => "Acme",
            "Acme-Flow-Out-Dst-Addr_FS1_R"              => "Acme",
            "Acme-Flow-Out-Dst-Addr_FS2_F"              => "Acme",
            "Acme-Flow-Out-Dst-Addr_FS2_R"              => "Acme",
            "Acme-Flow-Out-Dst-IPv6_Addr_FS1_F"         => "Acme",
            "Acme-Flow-Out-Dst-IPv6_Addr_FS1_R"         => "Acme",
            "Acme-Flow-Out-Dst-IPv6_Addr_FS2_F"         => "Acme",
            "Acme-Flow-Out-Dst-IPv6_Addr_FS2_R"         => "Acme",
            "Acme-Flow-Out-Dst-Port_FS1_F"              => "Acme",
            "Acme-Flow-Out-Dst-Port_FS1_R"              => "Acme",
            "Acme-Flow-Out-Dst-Port_FS2_F"              => "Acme",
            "Acme-Flow-Out-Dst-Port_FS2_R"              => "Acme",
            "Acme-Flow-Out-Realm_FS1_F"                 => "Acme",
            "Acme-Flow-Out-Realm_FS1_R"                 => "Acme",
            "Acme-Flow-Out-Realm_FS2_F"                 => "Acme",
            "Acme-Flow-Out-Realm_FS2_R"                 => "Acme",
            "Acme-Flow-Out-Src-Addr_FS1_F"              => "Acme",
            "Acme-Flow-Out-Src-Addr_FS1_R"              => "Acme",
            "Acme-Flow-Out-Src-Addr_FS2_F"              => "Acme",
            "Acme-Flow-Out-Src-Addr_FS2_R"              => "Acme",
            "Acme-Flow-Out-Src-IPv6_Addr_FS1_F"         => "Acme",
            "Acme-Flow-Out-Src-IPv6_Addr_FS1_R"         => "Acme",
            "Acme-Flow-Out-Src-IPv6_Addr_FS2_F"         => "Acme",
            "Acme-Flow-Out-Src-IPv6_Addr_FS2_R"         => "Acme",
            "Acme-Flow-Out-Src-Port_FS1_F"              => "Acme",
            "Acme-Flow-Out-Src-Port_FS1_R"              => "Acme",
            "Acme-Flow-Out-Src-Port_FS2_F"              => "Acme",
            "Acme-Flow-Out-Src-Port_FS2_R"              => "Acme",
            "Acme-Flow-PTime_FS1_F"                     => "Acme",
            "Acme-Flow-PTime_FS1_R"                     => "Acme",
            "Acme-Flow-PTime_FS2_F"                     => "Acme",
            "Acme-Flow-PTime_FS2_R"                     => "Acme",
            "Acme-FlowID_FS1_F"                         => "Acme",
            "Acme-FlowID_FS1_R"                         => "Acme",
            "Acme-FlowID_FS2_F"                         => "Acme",
            "Acme-FlowID_FS2_R"                         => "Acme",
            "Acme-FlowMediaType_FS1_F"                  => "Acme",
            "Acme-FlowMediaType_FS1_R"                  => "Acme",
            "Acme-FlowMediaType_FS2_F"                  => "Acme",
            "Acme-FlowMediaType_FS2_R"                  => "Acme",
            "Acme-FlowType_FS1_F"                       => "Acme",
            "Acme-FlowType_FS1_R"                       => "Acme",
            "Acme-FlowType_FS2_F"                       => "Acme",
            "Acme-FlowType_FS2_R"                       => "Acme",
            "Acme-Ingress-Local-Addr"                   => "Acme",
            "Acme-Ingress-Network-Interface-Id"         => "Acme",
            "Acme-Ingress-Remote-Addr"                  => "Acme",
            "Acme-Ingress-Vlan-Tag-Value"               => "Acme",
            "Acme-Intermediate_Time"                    => "Acme",
            "Acme-Local-Time-Zone"                      => "Acme",
            "Acme-Originating-Trunk-Context"            => "Acme",
            "Acme-Originating-Trunk-Group"              => "Acme",
            "Acme-P-Asserted-ID"                        => "Acme",
            "Acme-Post-Dial-Delay"                      => "Acme",
            "Acme-Primary-Routing-Number"               => "Acme",
            "Acme-Reason-Phrase"                        => "Acme",
            "Acme-Refer-Call-Transfer-Id"               => "Acme",
            "Acme-Session-Charging-Function_Address"    => "Acme",
            "Acme-Session-Charging-Vector"              => "Acme",
            "Acme-Session-Disposition"                  => "Acme",
            "Acme-Session-Egress-CallId"                => "Acme",
            "Acme-Session-Egress-Realm"                 => "Acme",
            "Acme-Session-Egress-RPH"                   => "Acme",
            "Acme-Session-Forked-Call-Id"               => "Acme",
            "Acme-Session-Generic-Id"                   => "Acme",
            "Acme-Session-Ingress-CallId"               => "Acme",
            "Acme-Session-Ingress-Realm"                => "Acme",
            "Acme-Session-Ingress-RPH"                  => "Acme",
            "Acme-Session-Media-Process"                => "Acme",
            "Acme-Session-Protocol-Type"                => "Acme",
            "Acme-SIP-Contact"                          => "Acme",
            "Acme-SIP-Diversion"                        => "Acme",
            "Acme-SIP-Expires"                          => "Acme",
            "Acme-SIP-Method-Type"                      => "Acme",
            "Acme-SIP-Status"                           => "Acme",
            "Acme-Terminating-Trunk-Context"            => "Acme",
            "Acme-Terminating-Trunk-Group"              => "Acme",
            "Acme-User-Class"                           => "Acme",
            "Acme-User-Privilege"                       => "Acme",
            "Actelis-Privilege"                         => "Actelis",
            "Actual-Data-Rate-Downstream"               => "ADSL-Forum",
            "Actual-Data-Rate-Upstream"                 => "ADSL-Forum",
            "Actual-Interleaving-Delay-Downstream"      => "ADSL-Forum",
            "Actual-Interleaving-Delay-Upstream"        => "ADSL-Forum",
            "ADSL-Agent-Circuit-Id"                     => "ADSL-Forum",
            "ADSL-Agent-Remote-Id"                      => "ADSL-Forum",
            "ADSL-Forum-Device-Manufacturer-OUI"        => "ADSL-Forum",
            "ADSL-Forum-Device-Product-Class"           => "ADSL-Forum",
            "ADSL-Forum-Device-Serial-Number"           => "ADSL-Forum",
            "ADSL-Forum-DHCP-Vendor-Specific"           => "ADSL-Forum",
            "ADSL-Forum-Gateway-Manufacturer-OUI"       => "ADSL-Forum",
            "Adtran-AP-IP"                              => "Adtran",
            "Adtran-AP-Name"                            => "Adtran",
            "Adtran-AP-Template"                        => "Adtran",
            "Adtran-Role"                               => "Adtran",
            "Adtran-SSID"                               => "Adtran",
            "Adva-Auth-Level-NM"                        => "Adva",
            "Adva-User-Level"                           => "Adva",
            "Adva-UUM-User-Level"                       => "Adva",
            "Agent-Circuit-Id"                          => "Ericsson-AB",
            "Agent-Remote-Id"                           => "Ericsson-AB",
            "AH-HM-Admin-Group-Id"                      => "Aerohive",
            "Airespace-8021p-Tag"                       => "Airespace",
            "Airespace-ACL-Name"                        => "Airespace",
            "Airespace-Data-Bandwidth-Average-Contract" => "Airespace",
            "Airespace-Data-Bandwidth-Average-Contract-Upstream" => "Airespace",
            "Airespace-Data-Bandwidth-Burst-Contract"            => "Airespace",
            "Airespace-Data-Bandwidth-Burst-Contract-Upstream"   => "Airespace",
            "Airespace-DSCP"                                     => "Airespace",
            "Airespace-Guest-Role-Name"                          => "Airespace",
            "Airespace-Interface-Name"                           => "Airespace",
            "Airespace-QOS-Level"                                => "Airespace",
            "Airespace-Real-Time-Bandwidth-Average-Contract"     => "Airespace",
            "Airespace-Real-Time-Bandwidth-Average-Contract-Upstream" =>
              "Airespace",
            "Airespace-Real-Time-Bandwidth-Burst-Contract" => "Airespace",
            "Airespace-Real-Time-Bandwidth-Burst-Contract-Upstream" =>
              "Airespace",
            "Airespace-Wlan-Id"              => "Airespace",
            "Alc-AA-Group-Partition-Isa-Id"  => "Alcatel-Lucent-Service-Router",
            "Alc-AA-Peer-Identifier"         => "Alcatel-Lucent-Service-Router",
            "Alc-AA-Transit-IP"              => "Alcatel-Lucent-Service-Router",
            "Alc-Access-Loop-Encap-Offset"   => "Alcatel-Lucent-Service-Router",
            "Alc-Access-Loop-Rate-Down"      => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-All-Octets-Offer_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-All-Octets_64"       => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-All-Pack-Offer_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-All-Packets_64"      => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-High-Octets-Drop_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-High-Octets-Offer_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-High-Pack-Drop_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-High-Pack-Offer_64"  => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Hiprio-Octets_64"    => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Hiprio-Packets_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Inprof-Octets-64"    => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Inprof-Pkts-64"      => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Low-Octets-Drop_64"  => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Low-Octets-Offer_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Low-Pack-Drop_64"    => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Low-Pack-Offer_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Lowprio-Octets_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Lowprio-Packets_64"  => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Outprof-Octets-64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Outprof-Pkts-64"     => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-statmode"            => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Unc-Octets-Offer_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-I-Unc-Pack-Offer_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-Interim-Level"         => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-All-Octets_64"       => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-All-Packets_64"      => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Hiprio-Octets_64"    => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Hiprio-Packets_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Inprof-Octets-64"    => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Inprof-Octs-Drop_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Inprof-Pack-Drop_64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Inprof-Pkts-64"      => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Lowprio-Octets_64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Lowprio-Packets_64"  => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Outprof-Octets-64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Outprof-Octs-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Outprof-Pack-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-Outprof-Pkts-64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-O-statmode"        => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-All-Octs-Offer_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-All-Pack-Offer_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Inpr-Octs-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Inpr-Pack-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Inprof-Octets-64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Inprof-Pkts-64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Outpr-Octs-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Outpr-Pack-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Outprof-Octets-64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-I-Outprof-Pkts-64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Inpr-Octs-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Inpr-Pack-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Inprof-Octets-64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Inprof-Pkts-64"   => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Outpr-Octs-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Outpr-Pack-Drop_64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Outprof-Octets-64" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Acct-OC-O-Outprof-Pkts-64" => "Alcatel-Lucent-Service-Router",
            "Alc-Acct-Triggered-Reason"     => "Alcatel-Lucent-Service-Router",
            "Alc-ANCP-Str"                  => "Alcatel-Lucent-Service-Router",
            "Alc-APN-Name"                  => "Alcatel-Lucent-Service-Router",
            "Alc-APN-Password"              => "Alcatel-Lucent-Service-Router",
            "Alc-App-Prof-Str"              => "Alcatel-Lucent-Service-Router",
            "Alc-Ascend-Data-Filter-Host-Spec" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-ATM-Egress-TD-Profile"      => "Alcatel-Lucent-Service-Router",
            "Alc-ATM-Ingress-TD-Profile"     => "Alcatel-Lucent-Service-Router",
            "Alc-Authentication-Policy-Name" => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-Auth-Key"               => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-Auth-Keychain"          => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-Export-Policy"          => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-Import-Policy"          => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-PeerAS"                 => "Alcatel-Lucent-Service-Router",
            "Alc-BGP-Policy"                 => "Alcatel-Lucent-Service-Router",
            "Alc-Charging-Prof-ID"           => "Alcatel-Lucent-Service-Router",
            "Alc-Client-Hardware-Addr"       => "Alcatel-Lucent-Service-Router",
            "Alc-Create-Host"                => "Alcatel-Lucent-Service-Router",
            "Alc-Credit-Control-CategoryMap" => "Alcatel-Lucent-Service-Router",
            "Alc-Credit-Control-Quota"       => "Alcatel-Lucent-Service-Router",
            "Alc-Default-Router"             => "Alcatel-Lucent-Service-Router",
            "Alc-Delegated-IPv6-Pool"        => "Alcatel-Lucent-Service-Router",
            "Alc-DHCP-Vendor-Class-Id"       => "Alcatel-Lucent-Service-Router",
            "Alc-Dhcp6-Rebind-Time"          => "Alcatel-Lucent-Service-Router",
            "Alc-Dhcp6-Renew-Time"           => "Alcatel-Lucent-Service-Router",
            "Alc-DNAT-Override"              => "Alcatel-Lucent-Service-Router",
            "Alc-DSL-Line-State"             => "Alcatel-Lucent-Service-Router",
            "Alc-DSL-Type"                   => "Alcatel-Lucent-Service-Router",
            "Alc-Force-DHCP-Relay"           => "Alcatel-Lucent-Service-Router",
            "Alc-Force-Nak"                  => "Alcatel-Lucent-Service-Router",
            "Alc-Force-Renew"                => "Alcatel-Lucent-Service-Router",
            "Alc-Int-Dest-Id-Str"            => "Alcatel-Lucent-Service-Router",
            "Alc-Interface"                  => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-Interface"            => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-SA-Auth-Algorithm"    => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-SA-Encr-Algorithm"    => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-SA-Lifetime"          => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-SA-PFS-Group"         => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-SA-Replay-Window"     => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-Serv-Id"              => "Alcatel-Lucent-Service-Router",
            "Alc-IPsec-Tunnel-Template-Id"   => "Alcatel-Lucent-Service-Router",
            "Alc-Ipv6-Address"               => "Alcatel-Lucent-Service-Router",
            "Alc-Ipv6-Portal-Url"            => "Alcatel-Lucent-Service-Router",
            "Alc-Ipv6-Primary-Dns"           => "Alcatel-Lucent-Service-Router",
            "Alc-Ipv6-Secondary-Dns"         => "Alcatel-Lucent-Service-Router",
            "Alc-Lease-Time"                 => "Alcatel-Lucent-Service-Router",
            "Alc-LI-Action"                  => "Alcatel-Lucent-Service-Router",
            "Alc-LI-Destination"             => "Alcatel-Lucent-Service-Router",
            "Alc-LI-Direction"               => "Alcatel-Lucent-Service-Router",
            "Alc-LI-FC"                      => "Alcatel-Lucent-Service-Router",
            "Alc-LI-Intercept-Id"            => "Alcatel-Lucent-Service-Router",
            "Alc-LI-Session-Id"              => "Alcatel-Lucent-Service-Router",
            "Alc-Mgw-Interface-Type"         => "Alcatel-Lucent-Service-Router",
            "Alc-MSAP-Interface"             => "Alcatel-Lucent-Service-Router",
            "Alc-MSAP-Policy"                => "Alcatel-Lucent-Service-Router",
            "Alc-MSAP-Serv-Id"               => "Alcatel-Lucent-Service-Router",
            "Alc-MsIsdn"                     => "Alcatel-Lucent-Service-Router",
            "Alc-Nas-Filter-Rule-Shared"     => "Alcatel-Lucent-Service-Router",
            "Alc-Nat-Outside-Ip-Addr"        => "Alcatel-Lucent-Service-Router",
            "Alc-Nat-Outside-Serv-Id"        => "Alcatel-Lucent-Service-Router",
            "Alc-Nat-Port-Range"             => "Alcatel-Lucent-Service-Router",
            "Alc-Num-Attached-UEs"           => "Alcatel-Lucent-Service-Router",
            "Alc-Onetime-Http-Redirect-Reactivate" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Onetime-Http-Redirection-Filter-Id" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Portal-Url"               => "Alcatel-Lucent-Service-Router",
            "Alc-PPP-Force-IPv6CP"         => "Alcatel-Lucent-Service-Router",
            "Alc-PPPoE-PADO-Delay"         => "Alcatel-Lucent-Service-Router",
            "Alc-PPPoE-Service-Name"       => "Alcatel-Lucent-Service-Router",
            "Alc-Primary-Dns"              => "Alcatel-Lucent-Service-Router",
            "Alc-Primary-Nbns"             => "Alcatel-Lucent-Service-Router",
            "Alc-Radius-Py"                => "Alcatel-Lucent-Service-Router",
            "Alc-Relative-Session-Timeout" => "Alcatel-Lucent-Service-Router",
            "Alc-Remove-Override"          => "Alcatel-Lucent-Service-Router",
            "Alc-Retail-Serv-Id"           => "Alcatel-Lucent-Service-Router",
            "Alc-RSSI"                     => "Alcatel-Lucent-Service-Router",
            "Alc-SAP-Session-Index"        => "Alcatel-Lucent-Service-Router",
            "Alc-Secondary-Dns"            => "Alcatel-Lucent-Service-Router",
            "Alc-Secondary-Nbns"           => "Alcatel-Lucent-Service-Router",
            "Alc-Serv-Id"                  => "Alcatel-Lucent-Service-Router",
            "Alc-SLA-Prof-Str"             => "Alcatel-Lucent-Service-Router",
            "Alc-SLAAC-IPv6-Pool"          => "Alcatel-Lucent-Service-Router",
            "Alc-Subsc-ID-Str"             => "Alcatel-Lucent-Service-Router",
            "Alc-Subsc-Prof-Str"           => "Alcatel-Lucent-Service-Router",
            "Alc-Subscriber-Filter"        => "Alcatel-Lucent-Service-Router",
            "Alc-Subscriber-QoS-Override"  => "Alcatel-Lucent-Service-Router",
            "Alc-ToClient-Dhcp-Options"    => "Alcatel-Lucent-Service-Router",
            "Alc-ToClient-Dhcp6-Options"   => "Alcatel-Lucent-Service-Router",
            "Alc-ToServer-Dhcp-Options"    => "Alcatel-Lucent-Service-Router",
            "Alc-ToServer-Dhcp6-Options"   => "Alcatel-Lucent-Service-Router",
            "Alc-Trigger-Acct-Interim"     => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Acct-Policy"       => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Algorithm"         => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-AVP-Hiding"        => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Challenge"         => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Destruct-Timeout"  => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Group"             => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Hello-Interval"    => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Idle-Timeout"      => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Max-Retries-Estab" => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Max-Retries-Not-Estab" =>
              "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Max-Sessions"      => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Rx-Window-Size"    => "Alcatel-Lucent-Service-Router",
            "Alc-Tunnel-Serv-Id"           => "Alcatel-Lucent-Service-Router",
            "Alc-UPnP-Sub-Override-Policy" => "Alcatel-Lucent-Service-Router",
            "Alc-v6-Preferred-Lifetime"    => "Alcatel-Lucent-Service-Router",
            "Alc-v6-Valid-Lifetime"        => "Alcatel-Lucent-Service-Router",
            "Alc-Wlan-APN-Name"            => "Alcatel-Lucent-Service-Router",
            "Alc-Wlan-Portal-Redirect"     => "Alcatel-Lucent-Service-Router",
            "Alc-Wlan-Portal-Url"          => "Alcatel-Lucent-Service-Router",
            "Alc-Wlan-SSID-VLAN"           => "Alcatel-Lucent-Service-Router",
            "Alc-WPP-ErrorCode"            => "Alcatel-Lucent-Service-Router",
            "Alteon-Client-IP-Address"     => "Alteon",
            "Alteon-Client-Netmask"        => "Alteon",
            "Alteon-Domain-Name"           => "Alteon",
            "Alteon-Group-Mapping"         => "Alteon",
            "Alteon-Primary-DNS-Server"    => "Alteon",
            "Alteon-Primary-NBNS-Server"   => "Alteon",
            "Alteon-Secondary-DNS-Server"  => "Alteon",
            "Alteon-Secondary-NBNS-Server" => "Alteon",
            "Alteon-Service-Type"          => "Alteon",
            "Alteon-VPN-Id"                => "Alteon",
            "Altiga-Access-Hours-G/U"      => "Altiga",
            "Altiga-Allow-Alpha-Only-Passwords-G"            => "Altiga",
            "Altiga-Argument-Authentication-Server-Priority" => "Altiga",
            "Altiga-Argument-Authentication-Server-Type"     => "Altiga",
            "Altiga-Argument-IPSec-Group-Name"               => "Altiga",
            "Altiga-Group-Name"                              => "Altiga",
            "Altiga-IPSec-Allow-Passwd-Store-G/U"            => "Altiga",
            "Altiga-IPSec-Authentication-G"                  => "Altiga",
            "Altiga-IPSec-Banner-G"                          => "Altiga",
            "Altiga-IPSec-Default-Domain-G"                  => "Altiga",
            "Altiga-IPSec-L2L-Keepalives-G"                  => "Altiga",
            "Altiga-IPSec-Mode-Config-G"                     => "Altiga",
            "Altiga-IPSec-Over-NAT-G"                        => "Altiga",
            "Altiga-IPSec-Over-NAT-Port-Num-G"               => "Altiga",
            "Altiga-IPSec-Sec-Association-G/U"               => "Altiga",
            "Altiga-IPSec-Secondary-Domains-G"               => "Altiga",
            "Altiga-IPSec-Split-Tunnel-List-G"               => "Altiga",
            "Altiga-IPSec-Tunnel-Type-G"                     => "Altiga",
            "Altiga-IPSec-User-Group-Lock-G"                 => "Altiga",
            "Altiga-L2TP-Encryption-G"                       => "Altiga",
            "Altiga-L2TP-Min-Authentication-G/U"             => "Altiga",
            "Altiga-Min-Password-Length-G"                   => "Altiga",
            "Altiga-Partitioning-Group"                      => "Altiga",
            "Altiga-Partitioning-Mobile-IP-Address"          => "Altiga",
            "Altiga-Partitioning-Mobile-IP-Key"              => "Altiga",
            "Altiga-Partitioning-Mobile-IP-SPI"              => "Altiga",
            "Altiga-Partitioning-Partition-Max-Sessions"     => "Altiga",
            "Altiga-Partitioning-Premise-Rout"               => "Altiga",
            "Altiga-Partitioning-Primary-DHCP"               => "Altiga",
            "Altiga-Partitioning-Secondary-DHCP"             => "Altiga",
            "Altiga-Partitioning-Strip-Realm"                => "Altiga",
            "Altiga-PPTP-Encryption-G"                       => "Altiga",
            "Altiga-PPTP-Min-Authentication-G/U"             => "Altiga",
            "Altiga-Primary-DNS-G"                           => "Altiga",
            "Altiga-Primary-WINS-G"                          => "Altiga",
            "Altiga-Priority-on-SEP-G/U"                     => "Altiga",
            "Altiga-Secondary-DNS-G"                         => "Altiga",
            "Altiga-Secondary-WINS-G"                        => "Altiga",
            "Altiga-SEP-Card-Assignment-G/U"                 => "Altiga",
            "Altiga-Simultaneous-Logins-G/U"                 => "Altiga",
            "Altiga-Tunneling-Protocols-G/U"                 => "Altiga",
            "Altiga-Use-Client-Address-G/U"                  => "Altiga",
            "ALU-AAA-Access-Rule"                            => "ALU-AAA",
            "ALU-AAA-AKA-AUTS"                               => "ALU-AAA",
            "ALU-AAA-AKA-Quintet"                            => "ALU-AAA",
            "ALU-AAA-AKA-Quintets-Needed"                    => "ALU-AAA",
            "ALU-AAA-AKA-RAND"                               => "ALU-AAA",
            "ALU-AAA-AV-Pair"                                => "ALU-AAA",
            "ALU-AAA-Called-Station-Id"                      => "ALU-AAA",
            "ALU-AAA-Civic-Location"                         => "ALU-AAA",
            "ALU-AAA-Client-Error-Action"                    => "ALU-AAA",
            "ALU-AAA-Client-OS"                              => "ALU-AAA",
            "ALU-AAA-Client-Program"                         => "ALU-AAA",
            "ALU-AAA-Client-Version"                         => "ALU-AAA",
            "ALU-AAA-Delta-Session"                          => "ALU-AAA",
            "ALU-AAA-DF-CC-Address"                          => "ALU-AAA",
            "ALU-AAA-DF-CC-Port"                             => "ALU-AAA",
            "ALU-AAA-Eval-0"                                 => "ALU-AAA",
            "ALU-AAA-Eval-1"                                 => "ALU-AAA",
            "ALU-AAA-Eval-2"                                 => "ALU-AAA",
            "ALU-AAA-Eval-3"                                 => "ALU-AAA",
            "ALU-AAA-Event"                                  => "ALU-AAA",
            "ALU-AAA-Exec-0"                                 => "ALU-AAA",
            "ALU-AAA-Exec-1"                                 => "ALU-AAA",
            "ALU-AAA-Exec-2"                                 => "ALU-AAA",
            "ALU-AAA-Exec-3"                                 => "ALU-AAA",
            "ALU-AAA-Femto-Associated-User-Name"             => "ALU-AAA",
            "ALU-AAA-Femto-Public-Key-Hash"                  => "ALU-AAA",
            "ALU-AAA-Geospatial-Location"                    => "ALU-AAA",
            "ALU-AAA-GSM-Triplet"                            => "ALU-AAA",
            "ALU-AAA-GSM-Triplets-Needed"                    => "ALU-AAA",
            "ALU-AAA-Integer-0"                              => "ALU-AAA",
            "ALU-AAA-Integer-1"                              => "ALU-AAA",
            "ALU-AAA-Integer-2"                              => "ALU-AAA",
            "ALU-AAA-Integer-3"                              => "ALU-AAA",
            "ALU-AAA-Key-0"                                  => "ALU-AAA",
            "ALU-AAA-Key-1"                                  => "ALU-AAA",
            "ALU-AAA-Key-2"                                  => "ALU-AAA",
            "ALU-AAA-Key-3"                                  => "ALU-AAA",
            "ALU-AAA-Lawful-Intercept-Status"                => "ALU-AAA",
            "ALU-AAA-NAS-IP-Address"                         => "ALU-AAA",
            "ALU-AAA-NAS-Port"                               => "ALU-AAA",
            "ALU-AAA-New-State"                              => "ALU-AAA",
            "ALU-AAA-New-Timestamp"                          => "ALU-AAA",
            "ALU-AAA-Nonce"                                  => "ALU-AAA",
            "ALU-AAA-Old-State"                              => "ALU-AAA",
            "ALU-AAA-Old-Timestamp"                          => "ALU-AAA",
            "ALU-AAA-Opaque-0"                               => "ALU-AAA",
            "ALU-AAA-Opaque-1"                               => "ALU-AAA",
            "ALU-AAA-Opaque-2"                               => "ALU-AAA",
            "ALU-AAA-Opaque-3"                               => "ALU-AAA",
            "ALU-AAA-Original-Receipt-Time"                  => "ALU-AAA",
            "ALU-AAA-Reply-Message"                          => "ALU-AAA",
            "ALU-AAA-Service-Profile"                        => "ALU-AAA",
            "ALU-AAA-String-0"                               => "ALU-AAA",
            "ALU-AAA-String-1"                               => "ALU-AAA",
            "ALU-AAA-String-2"                               => "ALU-AAA",
            "ALU-AAA-String-3"                               => "ALU-AAA",
            "ALU-AAA-Value-0"                                => "ALU-AAA",
            "ALU-AAA-Value-1"                                => "ALU-AAA",
            "ALU-AAA-Value-2"                                => "ALU-AAA",
            "ALU-AAA-Value-3"                                => "ALU-AAA",
            "Alvarion-VSA-1"                                 => "Alvarion",
            "Alvarion-VSA-10"                                => "Alvarion",
            "Alvarion-VSA-100"                               => "Alvarion",
            "Alvarion-VSA-101"                               => "Alvarion",
            "Alvarion-VSA-102"                               => "Alvarion",
            "Alvarion-VSA-103"                               => "Alvarion",
            "Alvarion-VSA-104"                               => "Alvarion",
            "Alvarion-VSA-105"                               => "Alvarion",
            "Alvarion-VSA-106"                               => "Alvarion",
            "Alvarion-VSA-107"                               => "Alvarion",
            "Alvarion-VSA-108"                               => "Alvarion",
            "Alvarion-VSA-109"                               => "Alvarion",
            "Alvarion-VSA-11"                                => "Alvarion",
            "Alvarion-VSA-110"                               => "Alvarion",
            "Alvarion-VSA-111"                               => "Alvarion",
            "Alvarion-VSA-112"                               => "Alvarion",
            "Alvarion-VSA-113"                               => "Alvarion",
            "Alvarion-VSA-114"                               => "Alvarion",
            "Alvarion-VSA-115"                               => "Alvarion",
            "Alvarion-VSA-116"                               => "Alvarion",
            "Alvarion-VSA-117"                               => "Alvarion",
            "Alvarion-VSA-118"                               => "Alvarion",
            "Alvarion-VSA-119"                               => "Alvarion",
            "Alvarion-VSA-12"                                => "Alvarion",
            "Alvarion-VSA-120"                               => "Alvarion",
            "Alvarion-VSA-121"                               => "Alvarion",
            "Alvarion-VSA-122"                               => "Alvarion",
            "Alvarion-VSA-123"                               => "Alvarion",
            "Alvarion-VSA-124"                               => "Alvarion",
            "Alvarion-VSA-125"                               => "Alvarion",
            "Alvarion-VSA-126"                               => "Alvarion",
            "Alvarion-VSA-127"                               => "Alvarion",
            "Alvarion-VSA-128"                               => "Alvarion",
            "Alvarion-VSA-129"                               => "Alvarion",
            "Alvarion-VSA-13"                                => "Alvarion",
            "Alvarion-VSA-130"                               => "Alvarion",
            "Alvarion-VSA-131"                               => "Alvarion",
            "Alvarion-VSA-132"                               => "Alvarion",
            "Alvarion-VSA-133"                               => "Alvarion",
            "Alvarion-VSA-134"                               => "Alvarion",
            "Alvarion-VSA-135"                               => "Alvarion",
            "Alvarion-VSA-136"                               => "Alvarion",
            "Alvarion-VSA-137"                               => "Alvarion",
            "Alvarion-VSA-138"                               => "Alvarion",
            "Alvarion-VSA-139"                               => "Alvarion",
            "Alvarion-VSA-14"                                => "Alvarion",
            "Alvarion-VSA-140"                               => "Alvarion",
            "Alvarion-VSA-141"                               => "Alvarion",
            "Alvarion-VSA-142"                               => "Alvarion",
            "Alvarion-VSA-143"                               => "Alvarion",
            "Alvarion-VSA-144"                               => "Alvarion",
            "Alvarion-VSA-145"                               => "Alvarion",
            "Alvarion-VSA-146"                               => "Alvarion",
            "Alvarion-VSA-147"                               => "Alvarion",
            "Alvarion-VSA-148"                               => "Alvarion",
            "Alvarion-VSA-149"                               => "Alvarion",
            "Alvarion-VSA-15"                                => "Alvarion",
            "Alvarion-VSA-150"                               => "Alvarion",
            "Alvarion-VSA-151"                               => "Alvarion",
            "Alvarion-VSA-152"                               => "Alvarion",
            "Alvarion-VSA-153"                               => "Alvarion",
            "Alvarion-VSA-154"                               => "Alvarion",
            "Alvarion-VSA-155"                               => "Alvarion",
            "Alvarion-VSA-156"                               => "Alvarion",
            "Alvarion-VSA-157"                               => "Alvarion",
            "Alvarion-VSA-158"                               => "Alvarion",
            "Alvarion-VSA-159"                               => "Alvarion",
            "Alvarion-VSA-16"                                => "Alvarion",
            "Alvarion-VSA-160"                               => "Alvarion",
            "Alvarion-VSA-161"                               => "Alvarion",
            "Alvarion-VSA-162"                               => "Alvarion",
            "Alvarion-VSA-163"                               => "Alvarion",
            "Alvarion-VSA-164"                               => "Alvarion",
            "Alvarion-VSA-165"                               => "Alvarion",
            "Alvarion-VSA-166"                               => "Alvarion",
            "Alvarion-VSA-167"                               => "Alvarion",
            "Alvarion-VSA-168"                               => "Alvarion",
            "Alvarion-VSA-169"                               => "Alvarion",
            "Alvarion-VSA-17"                                => "Alvarion",
            "Alvarion-VSA-170"                               => "Alvarion",
            "Alvarion-VSA-171"                               => "Alvarion",
            "Alvarion-VSA-172"                               => "Alvarion",
            "Alvarion-VSA-173"                               => "Alvarion",
            "Alvarion-VSA-174"                               => "Alvarion",
            "Alvarion-VSA-175"                               => "Alvarion",
            "Alvarion-VSA-176"                               => "Alvarion",
            "Alvarion-VSA-177"                               => "Alvarion",
            "Alvarion-VSA-178"                               => "Alvarion",
            "Alvarion-VSA-179"                               => "Alvarion",
            "Alvarion-VSA-18"                                => "Alvarion",
            "Alvarion-VSA-180"                               => "Alvarion",
            "Alvarion-VSA-181"                               => "Alvarion",
            "Alvarion-VSA-182"                               => "Alvarion",
            "Alvarion-VSA-183"                               => "Alvarion",
            "Alvarion-VSA-184"                               => "Alvarion",
            "Alvarion-VSA-185"                               => "Alvarion",
            "Alvarion-VSA-186"                               => "Alvarion",
            "Alvarion-VSA-187"                               => "Alvarion",
            "Alvarion-VSA-188"                               => "Alvarion",
            "Alvarion-VSA-189"                               => "Alvarion",
            "Alvarion-VSA-19"                                => "Alvarion",
            "Alvarion-VSA-190"                               => "Alvarion",
            "Alvarion-VSA-191"                               => "Alvarion",
            "Alvarion-VSA-192"                               => "Alvarion",
            "Alvarion-VSA-193"                               => "Alvarion",
            "Alvarion-VSA-194"                               => "Alvarion",
            "Alvarion-VSA-195"                               => "Alvarion",
            "Alvarion-VSA-196"                               => "Alvarion",
            "Alvarion-VSA-197"                               => "Alvarion",
            "Alvarion-VSA-198"                               => "Alvarion",
            "Alvarion-VSA-199"                               => "Alvarion",
            "Alvarion-VSA-2"                                 => "Alvarion",
            "Alvarion-VSA-20"                                => "Alvarion",
            "Alvarion-VSA-200"                               => "Alvarion",
            "Alvarion-VSA-201"                               => "Alvarion",
            "Alvarion-VSA-202"                               => "Alvarion",
            "Alvarion-VSA-203"                               => "Alvarion",
            "Alvarion-VSA-204"                               => "Alvarion",
            "Alvarion-VSA-205"                               => "Alvarion",
            "Alvarion-VSA-206"                               => "Alvarion",
            "Alvarion-VSA-207"                               => "Alvarion",
            "Alvarion-VSA-208"                               => "Alvarion",
            "Alvarion-VSA-209"                               => "Alvarion",
            "Alvarion-VSA-21"                                => "Alvarion",
            "Alvarion-VSA-210"                               => "Alvarion",
            "Alvarion-VSA-211"                               => "Alvarion",
            "Alvarion-VSA-212"                               => "Alvarion",
            "Alvarion-VSA-213"                               => "Alvarion",
            "Alvarion-VSA-214"                               => "Alvarion",
            "Alvarion-VSA-215"                               => "Alvarion",
            "Alvarion-VSA-216"                               => "Alvarion",
            "Alvarion-VSA-217"                               => "Alvarion",
            "Alvarion-VSA-218"                               => "Alvarion",
            "Alvarion-VSA-219"                               => "Alvarion",
            "Alvarion-VSA-22"                                => "Alvarion",
            "Alvarion-VSA-220"                               => "Alvarion",
            "Alvarion-VSA-221"                               => "Alvarion",
            "Alvarion-VSA-222"                               => "Alvarion",
            "Alvarion-VSA-223"                               => "Alvarion",
            "Alvarion-VSA-224"                               => "Alvarion",
            "Alvarion-VSA-225"                               => "Alvarion",
            "Alvarion-VSA-226"                               => "Alvarion",
            "Alvarion-VSA-227"                               => "Alvarion",
            "Alvarion-VSA-228"                               => "Alvarion",
            "Alvarion-VSA-229"                               => "Alvarion",
            "Alvarion-VSA-23"                                => "Alvarion",
            "Alvarion-VSA-230"                               => "Alvarion",
            "Alvarion-VSA-231"                               => "Alvarion",
            "Alvarion-VSA-232"                               => "Alvarion",
            "Alvarion-VSA-233"                               => "Alvarion",
            "Alvarion-VSA-234"                               => "Alvarion",
            "Alvarion-VSA-235"                               => "Alvarion",
            "Alvarion-VSA-236"                               => "Alvarion",
            "Alvarion-VSA-237"                               => "Alvarion",
            "Alvarion-VSA-238"                               => "Alvarion",
            "Alvarion-VSA-239"                               => "Alvarion",
            "Alvarion-VSA-24"                                => "Alvarion",
            "Alvarion-VSA-240"                               => "Alvarion",
            "Alvarion-VSA-241"                               => "Alvarion",
            "Alvarion-VSA-242"                               => "Alvarion",
            "Alvarion-VSA-243"                               => "Alvarion",
            "Alvarion-VSA-244"                               => "Alvarion",
            "Alvarion-VSA-245"                               => "Alvarion",
            "Alvarion-VSA-246"                               => "Alvarion",
            "Alvarion-VSA-247"                               => "Alvarion",
            "Alvarion-VSA-248"                               => "Alvarion",
            "Alvarion-VSA-249"                               => "Alvarion",
            "Alvarion-VSA-25"                                => "Alvarion",
            "Alvarion-VSA-250"                               => "Alvarion",
            "Alvarion-VSA-251"                               => "Alvarion",
            "Alvarion-VSA-252"                               => "Alvarion",
            "Alvarion-VSA-253"                               => "Alvarion",
            "Alvarion-VSA-254"                               => "Alvarion",
            "Alvarion-VSA-255"                               => "Alvarion",
            "Alvarion-VSA-26"                                => "Alvarion",
            "Alvarion-VSA-27"                                => "Alvarion",
            "Alvarion-VSA-28"                                => "Alvarion",
            "Alvarion-VSA-29"                                => "Alvarion",
            "Alvarion-VSA-3"                                 => "Alvarion",
            "Alvarion-VSA-30"                                => "Alvarion",
            "Alvarion-VSA-31"                                => "Alvarion",
            "Alvarion-VSA-32"                                => "Alvarion",
            "Alvarion-VSA-33"                                => "Alvarion",
            "Alvarion-VSA-34"                                => "Alvarion",
            "Alvarion-VSA-35"                                => "Alvarion",
            "Alvarion-VSA-36"                                => "Alvarion",
            "Alvarion-VSA-37"                                => "Alvarion",
            "Alvarion-VSA-38"                                => "Alvarion",
            "Alvarion-VSA-39"                                => "Alvarion",
            "Alvarion-VSA-4"                                 => "Alvarion",
            "Alvarion-VSA-40"                                => "Alvarion",
            "Alvarion-VSA-41"                                => "Alvarion",
            "Alvarion-VSA-42"                                => "Alvarion",
            "Alvarion-VSA-43"                                => "Alvarion",
            "Alvarion-VSA-44"                                => "Alvarion",
            "Alvarion-VSA-45"                                => "Alvarion",
            "Alvarion-VSA-46"                                => "Alvarion",
            "Alvarion-VSA-47"                                => "Alvarion",
            "Alvarion-VSA-48"                                => "Alvarion",
            "Alvarion-VSA-49"                                => "Alvarion",
            "Alvarion-VSA-5"                                 => "Alvarion",
            "Alvarion-VSA-50"                                => "Alvarion",
            "Alvarion-VSA-51"                                => "Alvarion",
            "Alvarion-VSA-52"                                => "Alvarion",
            "Alvarion-VSA-53"                                => "Alvarion",
            "Alvarion-VSA-54"                                => "Alvarion",
            "Alvarion-VSA-55"                                => "Alvarion",
            "Alvarion-VSA-56"                                => "Alvarion",
            "Alvarion-VSA-57"                                => "Alvarion",
            "Alvarion-VSA-58"                                => "Alvarion",
            "Alvarion-VSA-59"                                => "Alvarion",
            "Alvarion-VSA-6"                                 => "Alvarion",
            "Alvarion-VSA-60"                                => "Alvarion",
            "Alvarion-VSA-61"                                => "Alvarion",
            "Alvarion-VSA-62"                                => "Alvarion",
            "Alvarion-VSA-63"                                => "Alvarion",
            "Alvarion-VSA-64"                                => "Alvarion",
            "Alvarion-VSA-65"                                => "Alvarion",
            "Alvarion-VSA-66"                                => "Alvarion",
            "Alvarion-VSA-67"                                => "Alvarion",
            "Alvarion-VSA-68"                                => "Alvarion",
            "Alvarion-VSA-69"                                => "Alvarion",
            "Alvarion-VSA-7"                                 => "Alvarion",
            "Alvarion-VSA-70"                                => "Alvarion",
            "Alvarion-VSA-71"                                => "Alvarion",
            "Alvarion-VSA-72"                                => "Alvarion",
            "Alvarion-VSA-73"                                => "Alvarion",
            "Alvarion-VSA-74"                                => "Alvarion",
            "Alvarion-VSA-75"                                => "Alvarion",
            "Alvarion-VSA-76"                                => "Alvarion",
            "Alvarion-VSA-77"                                => "Alvarion",
            "Alvarion-VSA-78"                                => "Alvarion",
            "Alvarion-VSA-79"                                => "Alvarion",
            "Alvarion-VSA-8"                                 => "Alvarion",
            "Alvarion-VSA-80"                                => "Alvarion",
            "Alvarion-VSA-81"                                => "Alvarion",
            "Alvarion-VSA-82"                                => "Alvarion",
            "Alvarion-VSA-83"                                => "Alvarion",
            "Alvarion-VSA-84"                                => "Alvarion",
            "Alvarion-VSA-85"                                => "Alvarion",
            "Alvarion-VSA-86"                                => "Alvarion",
            "Alvarion-VSA-87"                                => "Alvarion",
            "Alvarion-VSA-88"                                => "Alvarion",
            "Alvarion-VSA-89"                                => "Alvarion",
            "Alvarion-VSA-9"                                 => "Alvarion",
            "Alvarion-VSA-90"                                => "Alvarion",
            "Alvarion-VSA-91"                                => "Alvarion",
            "Alvarion-VSA-92"                                => "Alvarion",
            "Alvarion-VSA-93"                                => "Alvarion",
            "Alvarion-VSA-94"                                => "Alvarion",
            "Alvarion-VSA-95"                                => "Alvarion",
            "Alvarion-VSA-96"                                => "Alvarion",
            "Alvarion-VSA-97"                                => "Alvarion",
            "Alvarion-VSA-98"                                => "Alvarion",
            "Alvarion-VSA-99"                                => "Alvarion",
            "AM-HTTP-Proxy-Port"                             => "IEA-Software",
            "AM-Interrupt-HTMLFile"                          => "IEA-Software",
            "AM-Interrupt-Interval"                          => "IEA-Software",
            "AM-Interrupt-Timeout"                           => "IEA-Software",
            "AM-Status-HTMLFile"                             => "IEA-Software",
            "Annex-Acct-Servers"                             => "Bay-Networks",
            "Annex-Addr-Resolution-Protocol"                 => "Bay-Networks",
            "Annex-Addr-Resolution-Servers"                  => "Bay-Networks",
            "Annex-Audit-Level"                              => "Bay-Networks",
            "Annex-Authen-Servers"                           => "Bay-Networks",
            "Annex-Begin-Modulation"                         => "Bay-Networks",
            "Annex-Begin-Receive-Line-Level"                 => "Bay-Networks",
            "Annex-Callback-Portlist"                        => "Bay-Networks",
            "Annex-CLI-Command"                              => "Bay-Networks",
            "Annex-Cli-Commands"                             => "Bay-Networks",
            "Annex-CLI-Filter"                               => "Bay-Networks",
            "Annex-Command-Access"                           => "Bay-Networks",
            "Annex-Compression-Protocol"                     => "Bay-Networks",
            "Annex-Connect-Progress"                         => "Bay-Networks",
            "Annex-Disconnect-Reason"                        => "Bay-Networks",
            "Annex-Domain-Name"                              => "Bay-Networks",
            "Annex-EDO"                                      => "Bay-Networks",
            "Annex-End-Modulation"                           => "Bay-Networks",
            "Annex-End-Receive-Line-Level"                   => "Bay-Networks",
            "Annex-Error-Correction-Prot"                    => "Bay-Networks",
            "Annex-Filter"                                   => "Bay-Networks",
            "Annex-Gwy-Selection-Mode"                       => "Bay-Networks",
            "Annex-Host-Allow"                               => "Bay-Networks",
            "Annex-Host-Restrict"                            => "Bay-Networks",
            "Annex-Input-Filter"                             => "Bay-Networks",
            "Annex-Keypress-Timeout"                         => "Bay-Networks",
            "Annex-Local-IP-Address"                         => "Bay-Networks",
            "Annex-Local-Username"                           => "Bay-Networks",
            "Annex-Logical-Channel-Number"                   => "Bay-Networks",
            "Annex-Maximum-Call-Duration"                    => "Bay-Networks",
            "Annex-Modem-Disc-Reason"                        => "Bay-Networks",
            "Annex-MRRU"                                     => "Bay-Networks",
            "Annex-Multicast-Rate-Limit"                     => "Bay-Networks",
            "Annex-Multilink-Id"                             => "Bay-Networks",
            "Annex-Num-In-Multilink"                         => "Bay-Networks",
            "Annex-Output-Filter"                            => "Bay-Networks",
            "Annex-Pool-Id"                                  => "Bay-Networks",
            "Annex-Port"                                     => "Bay-Networks",
            "Annex-PPP-Trace-Level"                          => "Bay-Networks",
            "Annex-Pre-Input-Octets"                         => "Bay-Networks",
            "Annex-Pre-Input-Packets"                        => "Bay-Networks",
            "Annex-Pre-Output-Octets"                        => "Bay-Networks",
            "Annex-Pre-Output-Packets"                       => "Bay-Networks",
            "Annex-Primary-DNS-Server"                       => "Bay-Networks",
            "Annex-Primary-NBNS-Server"                      => "Bay-Networks",
            "Annex-Product-Name"                             => "Bay-Networks",
            "Annex-Rate-Reneg-Req-Rcvd"                      => "Bay-Networks",
            "Annex-Rate-Reneg-Req-Sent"                      => "Bay-Networks",
            "Annex-Re-CHAP-Timeout"                          => "Bay-Networks",
            "Annex-Receive-Speed"                            => "Bay-Networks",
            "Annex-Retrain-Requests-Rcvd"                    => "Bay-Networks",
            "Annex-Retrain-Requests-Sent"                    => "Bay-Networks",
            "Annex-Retransmitted-Packets"                    => "Bay-Networks",
            "Annex-Sec-Profile-Index"                        => "Bay-Networks",
            "Annex-Secondary-DNS-Server"                     => "Bay-Networks",
            "Annex-Secondary-NBNS-Server"                    => "Bay-Networks",
            "Annex-Secondary-Srv-Endpoint"                   => "Bay-Networks",
            "Annex-Signal-to-Noise-Ratio"                    => "Bay-Networks",
            "Annex-SW-Version"                               => "Bay-Networks",
            "Annex-Syslog-Tap"                               => "Bay-Networks",
            "Annex-System-Disc-Reason"                       => "Bay-Networks",
            "Annex-Transmit-Speed"                           => "Bay-Networks",
            "Annex-Transmitted-Packets"                      => "Bay-Networks",
            "Annex-Tunnel-Authen-Mode"                       => "Bay-Networks",
            "Annex-Tunnel-Authen-Type"                       => "Bay-Networks",
            "Annex-Unauthenticated-Time"                     => "Bay-Networks",
            "Annex-User-Level"                               => "Bay-Networks",
            "Annex-User-Server-Location"                     => "Bay-Networks",
            "Annex-Wan-Number"                               => "Bay-Networks",
            "APC-ACCPX-Access1"                              => "APC",
            "APC-ACCPX-Access2"                              => "APC",
            "APC-ACCPX-Access3"                              => "APC",
            "APC-ACCPX-Access4"                              => "APC",
            "APC-ACCPX-Access5"                              => "APC",
            "APC-ACCPX-Access6"                              => "APC",
            "APC-ACCPX-Access7"                              => "APC",
            "APC-ACCPX-Doors"                                => "APC",
            "APC-ACCPX-Status"                               => "APC",
            "APC-Contact"                                    => "APC",
            "APC-Outlets"                                    => "APC",
            "APC-Perms"                                      => "APC",
            "APC-Service-Type"                               => "APC",
            "APC-Username"                                   => "APC",
            "Aptilo-Access-Profile"                          => "Aptilo",
            "Aptilo-Access-Profile-ID"                       => "Aptilo",
            "Aptilo-Ap-ID"                                   => "Aptilo",
            "Aptilo-Apc-ID"                                  => "Aptilo",
            "Aptilo-Auth-Param"                              => "Aptilo",
            "Aptilo-Auth-Result"                             => "Aptilo",
            "Aptilo-Auth-Type"                               => "Aptilo",
            "Aptilo-Automatic-Service"                       => "Aptilo",
            "Aptilo-Bw-Max-Down"                             => "Aptilo",
            "Aptilo-Bw-Max-Up"                               => "Aptilo",
            "Aptilo-Bw-Min-Down"                             => "Aptilo",
            "Aptilo-Bw-Min-Up"                               => "Aptilo",
            "Aptilo-Circuit-ID"                              => "Aptilo",
            "Aptilo-Debug-Option"                            => "Aptilo",
            "Aptilo-Denied-Cause"                            => "Aptilo",
            "Aptilo-Duration-Balance"                        => "Aptilo",
            "Aptilo-Duration-Quota"                          => "Aptilo",
            "Aptilo-Duration-Request"                        => "Aptilo",
            "Aptilo-Duration-Threshold"                      => "Aptilo",
            "Aptilo-Duration-Used"                           => "Aptilo",
            "Aptilo-Email"                                   => "Aptilo",
            "Aptilo-Exclusive-Count"                         => "Aptilo",
            "Aptilo-First-Name"                              => "Aptilo",
            "Aptilo-Gigawords-Limit"                         => "Aptilo",
            "Aptilo-Hotline-Indicator"                       => "Aptilo",
            "Aptilo-Input-Gigawords-Limit"                   => "Aptilo",
            "Aptilo-Input-Octets-Limit"                      => "Aptilo",
            "Aptilo-Key-Integer-1"                           => "Aptilo",
            "Aptilo-Key-Integer-2"                           => "Aptilo",
            "Aptilo-Key-Integer-3"                           => "Aptilo",
            "Aptilo-Key-Integer-4"                           => "Aptilo",
            "Aptilo-Key-Integer-5"                           => "Aptilo",
            "Aptilo-Key-IP-1"                                => "Aptilo",
            "Aptilo-Key-IP-2"                                => "Aptilo",
            "Aptilo-Key-IP-3"                                => "Aptilo",
            "Aptilo-Key-IP-4"                                => "Aptilo",
            "Aptilo-Key-IP-5"                                => "Aptilo",
            "Aptilo-Key-IPv6-1"                              => "Aptilo",
            "Aptilo-Key-IPv6-2"                              => "Aptilo",
            "Aptilo-Key-IPv6-3"                              => "Aptilo",
            "Aptilo-Key-IPv6-4"                              => "Aptilo",
            "Aptilo-Key-IPv6-5"                              => "Aptilo",
            "Aptilo-Key-Octets-1"                            => "Aptilo",
            "Aptilo-Key-Octets-2"                            => "Aptilo",
            "Aptilo-Key-Octets-3"                            => "Aptilo",
            "Aptilo-Key-Octets-4"                            => "Aptilo",
            "Aptilo-Key-Octets-5"                            => "Aptilo",
            "Aptilo-Key-String-1"                            => "Aptilo",
            "Aptilo-Key-String-2"                            => "Aptilo",
            "Aptilo-Key-String-3"                            => "Aptilo",
            "Aptilo-Key-String-4"                            => "Aptilo",
            "Aptilo-Key-String-5"                            => "Aptilo",
            "Aptilo-Last-Name"                               => "Aptilo",
            "Aptilo-Limit-Mode"                              => "Aptilo",
            "Aptilo-Location-Name"                           => "Aptilo",
            "Aptilo-NAS-Capabilities"                        => "Aptilo",
            "Aptilo-NAS-Model"                               => "Aptilo",
            "Aptilo-Octets-Balance"                          => "Aptilo",
            "Aptilo-Octets-Limit"                            => "Aptilo",
            "Aptilo-Octets-Quota"                            => "Aptilo",
            "Aptilo-Octets-Request"                          => "Aptilo",
            "Aptilo-Octets-Threshold"                        => "Aptilo",
            "Aptilo-Octets-Used"                             => "Aptilo",
            "Aptilo-Opaque-Key"                              => "Aptilo",
            "Aptilo-Organization"                            => "Aptilo",
            "Aptilo-Output-Gigawords-Limit"                  => "Aptilo",
            "Aptilo-Output-Octets-Limit"                     => "Aptilo",
            "Aptilo-Phone"                                   => "Aptilo",
            "Aptilo-Prepaid-Capabilities"                    => "Aptilo",
            "Aptilo-QoS-Indicator"                           => "Aptilo",
            "Aptilo-Quota-ID"                                => "Aptilo",
            "Aptilo-Realm-Concurrent-Login"                  => "Aptilo",
            "Aptilo-Realm-ID"                                => "Aptilo",
            "Aptilo-Remote-ID"                               => "Aptilo",
            "Aptilo-Resource-Balance"                        => "Aptilo",
            "Aptilo-Resource-Quota"                          => "Aptilo",
            "Aptilo-Resource-Request"                        => "Aptilo",
            "Aptilo-Resource-Threshold"                      => "Aptilo",
            "Aptilo-Resource-Used"                           => "Aptilo",
            "Aptilo-RX-Limit"                                => "Aptilo",
            "Aptilo-RX-Volume-Quota"                         => "Aptilo",
            "Aptilo-Service"                                 => "Aptilo",
            "Aptilo-Service-Profile"                         => "Aptilo",
            "Aptilo-Service-Profile-ID"                      => "Aptilo",
            "Aptilo-Session-Id"                              => "Aptilo",
            "Aptilo-Subnet-Name"                             => "Aptilo",
            "Aptilo-TRX-Limit"                               => "Aptilo",
            "Aptilo-TX-Limit"                                => "Aptilo",
            "Aptilo-TX-Volume-Quota"                         => "Aptilo",
            "Aptilo-User-ID"                                 => "Aptilo",
            "Aptilo-User-Type"                               => "Aptilo",
            "Aptilo-Volume-Quota"                            => "Aptilo",
            "Aptilo-Zone"                                    => "Aptilo",
            "Arbor-Privilege-Level"                          => "Arbor",
            "Arista-AVPair"                                  => "Arista",
            "Arista-BlockMac"                                => "Arista",
            "Arista-Captive-Portal"                          => "Arista",
            "Arista-Command"                                 => "Arista",
            "Arista-CVP-Role"                                => "Arista",
            "Arista-PortFlap"                                => "Arista",
            "Arista-UnblockMac"                              => "Arista",
            "Arista-User-Priv-Level"                         => "Arista",
            "Arista-User-Role"                               => "Arista",
            "Arista-WebAuth"                                 => "Arista",
            "Aruba-ACL-Server-Query-Info"                    => "Aruba",
            "Aruba-Admin-Device-Group"                       => "Aruba",
            "Aruba-Admin-Path"                               => "Aruba",
            "Aruba-Admin-Role"                               => "Aruba",
            "Aruba-AirGroup-Device-Type"                     => "Aruba",
            "Aruba-AirGroup-Shared-Group"                    => "Aruba",
            "Aruba-AirGroup-Shared-Role"                     => "Aruba",
            "Aruba-AirGroup-Shared-User"                     => "Aruba",
            "Aruba-AirGroup-User-Name"                       => "Aruba",
            "Aruba-AirGroup-Version"                         => "Aruba",
            "Aruba-AP-Group"                                 => "Aruba",
            "Aruba-AP-IP-Address"                            => "Aruba",
            "Aruba-AP-MAC-Address"                           => "Aruba",
            "Aruba-AS-Credential-Hash"                       => "Aruba",
            "Aruba-AS-User-Name"                             => "Aruba",
            "Aruba-Auth-Survivability"                       => "Aruba",
            "Aruba-Auth-SurvMethod"                          => "Aruba",
            "Aruba-Calea-Server-Ip"                          => "Aruba",
            "Aruba-Captive-Portal-URL"                       => "Aruba",
            "Aruba-Command-String"                           => "Aruba",
            "Aruba-CPPM-Role"                                => "Aruba",
            "Aruba-Device-MAC-Address"                       => "Aruba",
            "Aruba-Device-Traffic-Class"                     => "Aruba",
            "Aruba-Device-Type"                              => "Aruba",
            "Aruba-Essid-Name"                               => "Aruba",
            "Aruba-Framed-IPv6-Address"                      => "Aruba",
            "Aruba-Gateway-Zone"                             => "Aruba",
            "Aruba-Location-Id"                              => "Aruba",
            "Aruba-Mdps-Device-Iccid"                        => "Aruba",
            "Aruba-Mdps-Device-Imei"                         => "Aruba",
            "Aruba-Mdps-Device-Name"                         => "Aruba",
            "Aruba-Mdps-Device-Product"                      => "Aruba",
            "Aruba-Mdps-Device-Profile"                      => "Aruba",
            "Aruba-Mdps-Device-Serial"                       => "Aruba",
            "Aruba-Mdps-Device-Udid"                         => "Aruba",
            "Aruba-Mdps-Device-Version"                      => "Aruba",
            "Aruba-Mdps-Max-Devices"                         => "Aruba",
            "Aruba-Mdps-Provisioning-Settings"               => "Aruba",
            "Aruba-MMS-User-Template"                        => "Aruba",
            "Aruba-MPSK-Passphrase"                          => "Aruba",
            "Aruba-Named-User-Vlan"                          => "Aruba",
            "Aruba-NAS-Filter-Rule"                          => "Aruba",
            "Aruba-Network-Profile"                          => "Aruba",
            "Aruba-Network-SSO-Token"                        => "Aruba",
            "Aruba-No-DHCP-Fingerprint"                      => "Aruba",
            "Aruba-PoE-Priority"                             => "Aruba",
            "Aruba-Port-Auth-Mode"                           => "Aruba",
            "Aruba-Port-Bounce-Host"                         => "Aruba",
            "Aruba-Port-Identifier"                          => "Aruba",
            "Aruba-Priv-Admin-User"                          => "Aruba",
            "Aruba-QoS-Trust-Mode"                           => "Aruba",
            "Aruba-STP-Admin-Edge-Port"                      => "Aruba",
            "Aruba-UBT-Gateway-CPPM-Role"                    => "Aruba",
            "Aruba-UBT-Gateway-Role"                         => "Aruba",
            "Aruba-User-Group"                               => "Aruba",
            "Aruba-User-Role"                                => "Aruba",
            "Aruba-User-Vlan"                                => "Aruba",
            "Aruba-WorkSpace-App-Name"                       => "Aruba",
            "ASA-Access-List-Inbound"                        => "Cisco-ASA",
            "ASA-Access-List-Outbound"                       => "Cisco-ASA",
            "ASA-Address-Pools"                              => "Cisco-ASA",
            "ASA-Allow-Network-Extension-Mode"               => "Cisco-ASA",
            "ASA-Authenticated-User-Idle-Timeout"            => "Cisco-ASA",
            "ASA-Authorization-DN-Field"                     => "Cisco-ASA",
            "ASA-Authorization-Required"                     => "Cisco-ASA",
            "ASA-Authorization-Type"                         => "Cisco-ASA",
            "ASA-Banner1"                                    => "Cisco-ASA",
            "ASA-Banner2"                                    => "Cisco-ASA",
            "ASA-Cisco-IP-Phone-Bypass"                      => "Cisco-ASA",
            "ASA-Cisco-LEAP-Bypass"                          => "Cisco-ASA",
            "ASA-Client-Type-Version-Limiting"               => "Cisco-ASA",
            "ASA-ClientType"                                 => "Cisco-ASA",
            "ASA-DHCP-Network-Scope"                         => "Cisco-ASA",
            "ASA-Extended-Authentication-On-Rekey"           => "Cisco-ASA",
            "ASA-Group-Policy"                               => "Cisco-ASA",
            "ASA-IE-Proxy-Bypass-Local"                      => "Cisco-ASA",
            "ASA-IE-Proxy-Exception-List"                    => "Cisco-ASA",
            "ASA-IE-Proxy-PAC-URL"                           => "Cisco-ASA",
            "ASA-IE-Proxy-Server"                            => "Cisco-ASA",
            "ASA-IE-Proxy-Server-Policy"                     => "Cisco-ASA",
            "ASA-IKE-Keep-Alives"                            => "Cisco-ASA",
            "ASA-IKE-KeepAlive-Confidence-Interval"          => "Cisco-ASA",
            "ASA-IKE-Keepalive-Retry-Interval"               => "Cisco-ASA",
            "ASA-Intercept-DHCP-Configure-Msg"               => "Cisco-ASA",
            "ASA-IPsec-Allow-Passwd-Store"                   => "Cisco-ASA",
            "ASA-IPsec-Auth-On-Rekey"                        => "Cisco-ASA",
            "ASA-IPsec-Authentication"                       => "Cisco-ASA",
            "ASA-IPsec-Backup-Server-List"                   => "Cisco-ASA",
            "ASA-IPsec-Backup-Servers"                       => "Cisco-ASA",
            "ASA-IPsec-Client-Firewall-Filter-Name"          => "Cisco-ASA",
            "ASA-IPsec-Client-Firewall-Filter-Optional"      => "Cisco-ASA",
            "ASA-IPsec-Default-Domain"                       => "Cisco-ASA",
            "ASA-IPsec-IKE-Peer-ID-Check"                    => "Cisco-ASA",
            "ASA-IPsec-IP-Compression"                       => "Cisco-ASA",
            "ASA-IPsec-Mode-Config"                          => "Cisco-ASA",
            "ASA-IPsec-Over-UDP"                             => "Cisco-ASA",
            "ASA-IPsec-Over-UDP-Port"                        => "Cisco-ASA",
            "ASA-IPsec-Required-Client-Firewall-Capability"  => "Cisco-ASA",
            "ASA-IPsec-Sec-Association"                      => "Cisco-ASA",
            "ASA-IPsec-Split-DNS-Names"                      => "Cisco-ASA",
            "ASA-IPsec-Split-Tunnel-List"                    => "Cisco-ASA",
            "ASA-IPsec-Split-Tunneling-Policy"               => "Cisco-ASA",
            "ASA-IPsec-Tunnel-Type"                          => "Cisco-ASA",
            "ASA-IPv6-Address-Pools"                         => "Cisco-ASA",
            "ASA-IPv6-VPN-Filter"                            => "Cisco-ASA",
            "ASA-L2TP-Encryption"                            => "Cisco-ASA",
            "ASA-L2TP-MPPC-Compression"                      => "Cisco-ASA",
            "ASA-Member-Of"                                  => "Cisco-ASA",
            "ASA-MS-Client-Subnet-Mask"                      => "Cisco-ASA",
            "ASA-NAC-Default-ACL"                            => "Cisco-ASA",
            "ASA-NAC-Enable"                                 => "Cisco-ASA",
            "ASA-NAC-Revalidation-Timer"                     => "Cisco-ASA",
            "ASA-NAC-Settings"                               => "Cisco-ASA",
            "ASA-NAC-Status-Query-Timer"                     => "Cisco-ASA",
            "ASA-Perfect-Forward-Secrecy-Enable"             => "Cisco-ASA",
            "ASA-PPTP-Encryption"                            => "Cisco-ASA",
            "ASA-PPTP-MPPC-Compression"                      => "Cisco-ASA",
            "ASA-Primary-DNS"                                => "Cisco-ASA",
            "ASA-Primary-WINS"                               => "Cisco-ASA",
            "ASA-Privilege-Level"                            => "Cisco-ASA",
            "ASA-Require-HW-Client-Auth"                     => "Cisco-ASA",
            "ASA-Required-Client-Firewall-Description"       => "Cisco-ASA",
            "ASA-Required-Client-Firewall-Product-Code"      => "Cisco-ASA",
            "ASA-Required-Client-Firewall-Vendor-Code"       => "Cisco-ASA",
            "ASA-Required-Individual-User-Auth"              => "Cisco-ASA",
            "ASA-Secondary-DNS"                              => "Cisco-ASA",
            "ASA-Secondary-WINS"                             => "Cisco-ASA",
            "ASA-SEP-Card-Assignment"                        => "Cisco-ASA",
            "ASA-SessionSubtype"                             => "Cisco-ASA",
            "ASA-SessionType"                                => "Cisco-ASA",
            "ASA-Simultaneous-Logins"                        => "Cisco-ASA",
            "ASA-Smart-Tunnel"                               => "Cisco-ASA",
            "ASA-Smart-Tunnel-Auto"                          => "Cisco-ASA",
            "ASA-Smart-Tunnel-Auto-Signon-Enable"            => "Cisco-ASA",
            "ASA-Strip-Realm"                                => "Cisco-ASA",
            "ASA-SVC-Ask"                                    => "Cisco-ASA",
            "ASA-SVC-Ask-Timeout"                            => "Cisco-ASA",
            "ASA-SVC-DPD-Interval-Client"                    => "Cisco-ASA",
            "ASA-SVC-DPD-Interval-Gateway"                   => "Cisco-ASA",
            "ASA-SVC-DTLS"                                   => "Cisco-ASA",
            "ASA-SVC-Keepalive"                              => "Cisco-ASA",
            "ASA-SVC-Modules"                                => "Cisco-ASA",
            "ASA-SVC-MTU"                                    => "Cisco-ASA",
            "ASA-SVC-Profiles"                               => "Cisco-ASA",
            "ASA-SVC-Rekey-Time"                             => "Cisco-ASA",
            "ASA-Tunnel-Group-Lock"                          => "Cisco-ASA",
            "ASA-TunnelGroupName"                            => "Cisco-ASA",
            "ASA-Tunneling-Protocols"                        => "Cisco-ASA",
            "ASA-Use-Client-Address"                         => "Cisco-ASA",
            "ASA-VLAN"                                       => "Cisco-ASA",
            "ASA-WebVPN-Access-List"                         => "Cisco-ASA",
            "ASA-WebVPN-ActiveX-Relay"                       => "Cisco-ASA",
            "ASA-WebVPN-Apply-ACL"                           => "Cisco-ASA",
            "ASA-WebVPN-Auto-HTTP-Signon"                    => "Cisco-ASA",
            "ASA-WebVPN-Citrix-Metaframe-Enable"             => "Cisco-ASA",
            "ASA-WebVPN-Content-Filter-Parameters"           => "Cisco-ASA",
            "ASA-WebVPN-Customization"                       => "Cisco-ASA",
            "ASA-WebVPN-Default-Homepage"                    => "Cisco-ASA",
            "ASA-WebVPN-Deny-Message"                        => "Cisco-ASA",
            "ASA-WebVPN-Download_Max-Size"                   => "Cisco-ASA",
            "ASA-WebVPN-File-Access-Enable"                  => "Cisco-ASA",
            "ASA-WebVPN-File-Server-Browsing-Enable"         => "Cisco-ASA",
            "ASA-WebVPN-File-Server-Entry-Enable"            => "Cisco-ASA",
            "ASA-WebVPN-Group-based-HTTP/HTTPS-Proxy-Exception-List" =>
              "Cisco-ASA",
            "ASA-WebVPN-Hidden-Shares"                         => "Cisco-ASA",
            "ASA-WebVPN-Home-Page-Use-Smart-Tunnel"            => "Cisco-ASA",
            "ASA-WebVPN-HTML-Filter"                           => "Cisco-ASA",
            "ASA-WebVPN-HTTP-Compression"                      => "Cisco-ASA",
            "ASA-WebVPN-HTTP-Proxy-IP-Address"                 => "Cisco-ASA",
            "ASA-WebVPN-Idle-Timeout-Alert-Interval"           => "Cisco-ASA",
            "ASA-WebVPN-Keepalive-Ignore"                      => "Cisco-ASA",
            "ASA-WebVPN-Macro-Substitution-Value1"             => "Cisco-ASA",
            "ASA-WebVPN-Macro-Substitution-Value2"             => "Cisco-ASA",
            "ASA-WebVPN-Port-Forwarding-Enable"                => "Cisco-ASA",
            "ASA-WebVPN-Port-Forwarding-Exchange-Proxy-Enable" => "Cisco-ASA",
            "ASA-WebVPN-Port-Forwarding-HTTP-Proxy"            => "Cisco-ASA",
            "ASA-WebVPN-Port-Forwarding-List"                  => "Cisco-ASA",
            "ASA-WebVPN-Port-Forwarding-Name"                  => "Cisco-ASA",
            "ASA-WebVPN-Post-Max-Size"                         => "Cisco-ASA",
            "ASA-WebVPN-Session-Timeout-Alert-Interval"        => "Cisco-ASA",
            "ASA-WebVPN-Smart-Tunnel"                          => "Cisco-ASA",
            "ASA-WebVPN-Smart-Tunnel-Auto-Sign-On"             => "Cisco-ASA",
            "ASA-WebVPN-Smart-Tunnel-Auto-Start"               => "Cisco-ASA",
            "ASA-WebVPN-Smart-Tunnel-Tunnel-Policy"            => "Cisco-ASA",
            "ASA-WebVPN-SSL-VPN-Client-Enable"                 => "Cisco-ASA",
            "ASA-WebVPN-SSL-VPN-Client-Keep-Installation"      => "Cisco-ASA",
            "ASA-WebVPN-SSL-VPN-Client-Required"               => "Cisco-ASA",
            "ASA-WebVPN-SSO-Server-Name"                       => "Cisco-ASA",
            "ASA-WebVPN-Storage-Key"                           => "Cisco-ASA",
            "ASA-WebVPN-Storage-Objects"                       => "Cisco-ASA",
            "ASA-WebVPN-SVC-Client-DPD-Frequency"              => "Cisco-ASA",
            "ASA-WebVPN-SVC-Compression"                       => "Cisco-ASA",
            "ASA-WebVPN-SVC-DTLS-Enable"                       => "Cisco-ASA",
            "ASA-WebVPN-SVC-DTLS-MTU"                          => "Cisco-ASA",
            "ASA-WebVPN-SVC-Gateway-DPD-Frequency"             => "Cisco-ASA",
            "ASA-WebVPN-SVC-Keepalive-Frequency"               => "Cisco-ASA",
            "ASA-WebVPN-SVC-Rekey-Method"                      => "Cisco-ASA",
            "ASA-WebVPN-SVC-Rekey-Time"                        => "Cisco-ASA",
            "ASA-WebVPN-UNIX-Group-ID"                         => "Cisco-ASA",
            "ASA-WebVPN-UNIX-User-ID"                          => "Cisco-ASA",
            "ASA-WebVPN-Upload-Max-Size"                       => "Cisco-ASA",
            "ASA-WebVPN-URL-Entry-Enable"                      => "Cisco-ASA",
            "ASA-WebVPN-URL-List"                              => "Cisco-ASA",
            "ASA-WebVPN-User-Storage"                          => "Cisco-ASA",
            "ASA-WebVPN-VDI"                                   => "Cisco-ASA",
            "ASA-WebVPNACL"                                    => "Cisco-ASA",
            "ASA-WebVPNSmart-Card-Removal-Disconnect"          => "Cisco-ASA",
            "Ascend-Access-Intercept-LEA"                      => "Ascend",
            "Ascend-Access-Intercept-Log"                      => "Ascend",
            "Ascend-Add-Seconds"                               => "Ascend",
            "Ascend-Appletalk-Peer-Mode"                       => "Ascend",
            "Ascend-Appletalk-Route"                           => "Ascend",
            "Ascend-Ara-PW"                                    => "Ascend",
            "Ascend-Assign-IP-Client"                          => "Ascend",
            "Ascend-Assign-IP-Global-Pool"                     => "Ascend",
            "Ascend-Assign-IP-Pool"                            => "Ascend",
            "Ascend-Assign-IP-Server"                          => "Ascend",
            "Ascend-ATM-Connect-Group"                         => "Ascend",
            "Ascend-ATM-Connect-Vci"                           => "Ascend",
            "Ascend-ATM-Connect-Vpi"                           => "Ascend",
            "Ascend-ATM-Direct"                                => "Ascend",
            "Ascend-ATM-Direct-Profile"                        => "Ascend",
            "Ascend-ATM-Fault-Management"                      => "Ascend",
            "Ascend-ATM-Group"                                 => "Ascend",
            "Ascend-ATM-Loopback-Cell-Loss"                    => "Ascend",
            "Ascend-ATM-Vci"                                   => "Ascend",
            "Ascend-ATM-Vpi"                                   => "Ascend",
            "Ascend-Auth-Delay"                                => "Ascend",
            "Ascend-Auth-Type"                                 => "Ascend",
            "Ascend-Authen-Alias"                              => "Ascend",
            "Ascend-Backup"                                    => "Ascend",
            "Ascend-BACP-Enable"                               => "Ascend",
            "Ascend-Base-Channel-Count"                        => "Ascend",
            "Ascend-Bi-Directional-Auth"                       => "Ascend",
            "Ascend-Billing-Number"                            => "Ascend",
            "Ascend-BIR-Bridge-Group"                          => "Ascend",
            "Ascend-BIR-Enable"                                => "Ascend",
            "Ascend-BIR-Proxy"                                 => "Ascend",
            "Ascend-Bridge"                                    => "Ascend",
            "Ascend-Bridge-Address"                            => "Ascend",
            "Ascend-Bridge-Non-PPPoE"                          => "Ascend",
            "Ascend-Cache-Refresh"                             => "Ascend",
            "Ascend-Cache-Time"                                => "Ascend",
            "Ascend-Call-Attempt-Limit"                        => "Ascend",
            "Ascend-Call-Block-Duration"                       => "Ascend",
            "Ascend-Call-By-Call"                              => "Ascend",
            "Ascend-Call-Direction"                            => "Ascend",
            "Ascend-Call-Filter"                               => "Ascend",
            "Ascend-Call-Type"                                 => "Ascend",
            "Ascend-Callback"                                  => "Ascend",
            "Ascend-Callback-Delay"                            => "Ascend",
            "Ascend-Calling-Id-Number-Plan"                    => "Ascend",
            "Ascend-Calling-Id-Presentatn"                     => "Ascend",
            "Ascend-Calling-Id-Screening"                      => "Ascend",
            "Ascend-Calling-Id-Type-Of-Num"                    => "Ascend",
            "Ascend-Calling-Subaddress"                        => "Ascend",
            "Ascend-CBCP-Delay"                                => "Ascend",
            "Ascend-CBCP-Enable"                               => "Ascend",
            "Ascend-CBCP-Mode"                                 => "Ascend",
            "Ascend-CBCP-Trunk-Group"                          => "Ascend",
            "Ascend-CIR-Timer"                                 => "Ascend",
            "Ascend-Ckt-Type"                                  => "Ascend",
            "Ascend-Client-Assign-DNS"                         => "Ascend",
            "Ascend-Client-Assign-WINS"                        => "Ascend",
            "Ascend-Client-Gateway"                            => "Ascend",
            "Ascend-Client-Primary-DNS"                        => "Ascend",
            "Ascend-Client-Primary-WINS"                       => "Ascend",
            "Ascend-Client-Secondary-DNS"                      => "Ascend",
            "Ascend-Client-Secondary-WINS"                     => "Ascend",
            "Ascend-Connect-Progress"                          => "Ascend",
            "Ascend-Data-Filter"                               => "Ascend",
            "Ascend-Data-Rate"                                 => "Ascend",
            "Ascend-Data-Svc"                                  => "Ascend",
            "Ascend-DBA-Monitor"                               => "Ascend",
            "Ascend-Dec-Channel-Count"                         => "Ascend",
            "Ascend-Destination-Nas-Port"                      => "Ascend",
            "Ascend-DHCP-Maximum-Leases"                       => "Ascend",
            "Ascend-DHCP-Pool-Number"                          => "Ascend",
            "Ascend-DHCP-Reply"                                => "Ascend",
            "Ascend-Dial-Number"                               => "Ascend",
            "Ascend-Dialed-Number"                             => "Ascend",
            "Ascend-Dialout-Allowed"                           => "Ascend",
            "Ascend-Disconnect-Cause"                          => "Ascend",
            "Ascend-Dropped-Octets"                            => "Ascend",
            "Ascend-Dropped-Packets"                           => "Ascend",
            "Ascend-Dsl-CIR-Recv-Limit"                        => "Ascend",
            "Ascend-Dsl-CIR-Xmit-Limit"                        => "Ascend",
            "Ascend-Dsl-Downstream-Limit"                      => "Ascend",
            "Ascend-Dsl-Rate-Mode"                             => "Ascend",
            "Ascend-Dsl-Rate-Type"                             => "Ascend",
            "Ascend-Dsl-Upstream-Limit"                        => "Ascend",
            "Ascend-Egress-Enabled"                            => "Ascend",
            "Ascend-Endpoint-Disc"                             => "Ascend",
            "Ascend-Event-Type"                                => "Ascend",
            "Ascend-Expect-Callback"                           => "Ascend",
            "Ascend-FCP-Parameter"                             => "Ascend",
            "Ascend-Filter"                                    => "Ascend",
            "Ascend-Filter-Required"                           => "Ascend",
            "Ascend-First-Dest"                                => "Ascend",
            "Ascend-Force-56"                                  => "Ascend",
            "Ascend-FR-08-Mode"                                => "Ascend",
            "Ascend-FR-Circuit-Name"                           => "Ascend",
            "Ascend-FR-DCE-N392"                               => "Ascend",
            "Ascend-FR-DCE-N393"                               => "Ascend",
            "Ascend-FR-Direct"                                 => "Ascend",
            "Ascend-FR-Direct-DLCI"                            => "Ascend",
            "Ascend-FR-Direct-Profile"                         => "Ascend",
            "Ascend-FR-DLCI"                                   => "Ascend",
            "Ascend-FR-DTE-N392"                               => "Ascend",
            "Ascend-FR-DTE-N393"                               => "Ascend",
            "Ascend-FR-Link-Mgt"                               => "Ascend",
            "Ascend-FR-Link-Status-DLCI"                       => "Ascend",
            "Ascend-FR-LinkUp"                                 => "Ascend",
            "Ascend-FR-N391"                                   => "Ascend",
            "Ascend-FR-Nailed-Grp"                             => "Ascend",
            "Ascend-FR-Profile-Name"                           => "Ascend",
            "Ascend-FR-SVC-Addr"                               => "Ascend",
            "Ascend-FR-T391"                                   => "Ascend",
            "Ascend-FR-T392"                                   => "Ascend",
            "Ascend-FR-Type"                                   => "Ascend",
            "Ascend-FT1-Caller"                                => "Ascend",
            "Ascend-Global-Call-Id"                            => "Ascend",
            "Ascend-Group"                                     => "Ascend",
            "Ascend-H323-Conference-Id"                        => "Ascend",
            "Ascend-H323-Dialed-Time"                          => "Ascend",
            "Ascend-H323-Fegw-Address"                         => "Ascend",
            "Ascend-H323-Gatekeeper"                           => "Ascend",
            "Ascend-Handle-IPX"                                => "Ascend",
            "Ascend-History-Weigh-Type"                        => "Ascend",
            "Ascend-Home-Agent-IP-Addr"                        => "Ascend",
            "Ascend-Home-Agent-Password"                       => "Ascend",
            "Ascend-Home-Agent-UDP-Port"                       => "Ascend",
            "Ascend-Home-Network-Name"                         => "Ascend",
            "Ascend-Host-Info"                                 => "Ascend",
            "Ascend-Idle-Limit"                                => "Ascend",
            "Ascend-IF-Netmask"                                => "Ascend",
            "Ascend-Inc-Channel-Count"                         => "Ascend",
            "Ascend-Inter-Arrival-Jitter"                      => "Ascend",
            "Ascend-IP-Direct"                                 => "Ascend",
            "Ascend-IP-Pool-Chaining"                          => "Ascend",
            "Ascend-IP-Pool-Definition"                        => "Ascend",
            "Ascend-IP-TOS"                                    => "Ascend",
            "Ascend-IP-TOS-Apply-To"                           => "Ascend",
            "Ascend-IP-TOS-Precedence"                         => "Ascend",
            "Ascend-IPSEC-Profile"                             => "Ascend",
            "Ascend-IPX-Alias"                                 => "Ascend",
            "Ascend-IPX-Header-Compression"                    => "Ascend",
            "Ascend-IPX-Node-Addr"                             => "Ascend",
            "Ascend-IPX-Peer-Mode"                             => "Ascend",
            "Ascend-IPX-Route"                                 => "Ascend",
            "Ascend-Link-Compression"                          => "Ascend",
            "Ascend-Max-Shared-Users"                          => "Ascend",
            "Ascend-Maximum-Call-Duration"                     => "Ascend",
            "Ascend-Maximum-Channels"                          => "Ascend",
            "Ascend-Maximum-Time"                              => "Ascend",
            "Ascend-Menu-Item"                                 => "Ascend",
            "Ascend-Menu-Selector"                             => "Ascend",
            "Ascend-Metric"                                    => "Ascend",
            "Ascend-Minimum-Channels"                          => "Ascend",
            "Ascend-Modem-PortNo"                              => "Ascend",
            "Ascend-Modem-ShelfNo"                             => "Ascend",
            "Ascend-Modem-SlotNo"                              => "Ascend",
            "Ascend-MPP-Idle-Percent"                          => "Ascend",
            "Ascend-MTU"                                       => "Ascend",
            "Ascend-Multicast-Client"                          => "Ascend",
            "Ascend-Multicast-GLeave-Delay"                    => "Ascend",
            "Ascend-Multicast-Rate-Limit"                      => "Ascend",
            "Ascend-Multilink-ID"                              => "Ascend",
            "Ascend-NAS-Port-Format"                           => "Ascend",
            "Ascend-Netware-timeout"                           => "Ascend",
            "Ascend-Num-In-Multilink"                          => "Ascend",
            "Ascend-Number-Sessions"                           => "Ascend",
            "Ascend-Numbering-Plan-ID"                         => "Ascend",
            "Ascend-Owner-IP-Addr"                             => "Ascend",
            "Ascend-Port-Redir-Portnum"                        => "Ascend",
            "Ascend-Port-Redir-Protocol"                       => "Ascend",
            "Ascend-Port-Redir-Server"                         => "Ascend",
            "Ascend-PPP-Address"                               => "Ascend",
            "Ascend-PPP-Async-Map"                             => "Ascend",
            "Ascend-PPP-VJ-1172"                               => "Ascend",
            "Ascend-PPP-VJ-Slot-Comp"                          => "Ascend",
            "Ascend-PPPoE-Enable"                              => "Ascend",
            "Ascend-Pre-Input-Octets"                          => "Ascend",
            "Ascend-Pre-Input-Packets"                         => "Ascend",
            "Ascend-Pre-Output-Octets"                         => "Ascend",
            "Ascend-Pre-Output-Packets"                        => "Ascend",
            "Ascend-Preempt-Limit"                             => "Ascend",
            "Ascend-PreSession-Time"                           => "Ascend",
            "Ascend-PRI-Number-Type"                           => "Ascend",
            "Ascend-Primary-Home-Agent"                        => "Ascend",
            "Ascend-Private-Route"                             => "Ascend",
            "Ascend-Private-Route-Required"                    => "Ascend",
            "Ascend-Private-Route-Table-ID"                    => "Ascend",
            "Ascend-PW-Lifetime"                               => "Ascend",
            "Ascend-PW-Warntime"                               => "Ascend",
            "Ascend-QOS-Downstream"                            => "Ascend",
            "Ascend-QOS-Upstream"                              => "Ascend",
            "Ascend-Receive-Secret"                            => "Ascend",
            "Ascend-Recv-Name"                                 => "Ascend",
            "Ascend-Redirect-Number"                           => "Ascend",
            "Ascend-Remote-Addr"                               => "Ascend",
            "Ascend-Remote-FW"                                 => "Ascend",
            "Ascend-Remove-Seconds"                            => "Ascend",
            "Ascend-Require-Auth"                              => "Ascend",
            "Ascend-Route-Appletalk"                           => "Ascend",
            "Ascend-Route-IP"                                  => "Ascend",
            "Ascend-Route-IPX"                                 => "Ascend",
            "Ascend-Secondary-Home-Agent"                      => "Ascend",
            "Ascend-Seconds-Of-History"                        => "Ascend",
            "Ascend-Send-Auth"                                 => "Ascend",
            "Ascend-Send-Passwd"                               => "Ascend",
            "Ascend-Send-Secret"                               => "Ascend",
            "Ascend-Service-Type"                              => "Ascend",
            "Ascend-Session-Svr-Key"                           => "Ascend",
            "Ascend-Session-Type"                              => "Ascend",
            "Ascend-Shared-Profile-Enable"                     => "Ascend",
            "Ascend-Source-Auth"                               => "Ascend",
            "Ascend-Source-IP-Check"                           => "Ascend",
            "Ascend-SVC-Enabled"                               => "Ascend",
            "Ascend-Target-Util"                               => "Ascend",
            "Ascend-Telnet-Profile"                            => "Ascend",
            "Ascend-Temporary-Rtes"                            => "Ascend",
            "Ascend-Third-Prompt"                              => "Ascend",
            "Ascend-Token-Expiry"                              => "Ascend",
            "Ascend-Token-Idle"                                => "Ascend",
            "Ascend-Token-Immediate"                           => "Ascend",
            "Ascend-Traffic-Shaper"                            => "Ascend",
            "Ascend-Transit-Number"                            => "Ascend",
            "Ascend-TS-Idle-Limit"                             => "Ascend",
            "Ascend-TS-Idle-Mode"                              => "Ascend",
            "Ascend-Tunnel-VRouter-Name"                       => "Ascend",
            "Ascend-Tunneling-Protocol"                        => "Ascend",
            "Ascend-User-Acct-Base"                            => "Ascend",
            "Ascend-User-Acct-Host"                            => "Ascend",
            "Ascend-User-Acct-Key"                             => "Ascend",
            "Ascend-User-Acct-Port"                            => "Ascend",
            "Ascend-User-Acct-Time"                            => "Ascend",
            "Ascend-User-Acct-Type"                            => "Ascend",
            "Ascend-UU-Info"                                   => "Ascend",
            "Ascend-VRouter-Name"                              => "Ascend",
            "Ascend-X25-Cug"                                   => "Ascend",
            "Ascend-X25-Nui"                                   => "Ascend",
            "Ascend-X25-Nui-Password-Prompt"                   => "Ascend",
            "Ascend-X25-Nui-Prompt"                            => "Ascend",
            "Ascend-X25-Pad-Alias-1"                           => "Ascend",
            "Ascend-X25-Pad-Alias-2"                           => "Ascend",
            "Ascend-X25-Pad-Alias-3"                           => "Ascend",
            "Ascend-X25-Pad-Banner"                            => "Ascend",
            "Ascend-X25-Pad-Prompt"                            => "Ascend",
            "Ascend-X25-Pad-X3-Parameters"                     => "Ascend",
            "Ascend-X25-Pad-X3-Profile"                        => "Ascend",
            "Ascend-X25-Profile-Name"                          => "Ascend",
            "Ascend-X25-Reverse-Charging"                      => "Ascend",
            "Ascend-X25-Rpoa"                                  => "Ascend",
            "Ascend-X25-X121-Address"                          => "Ascend",
            "Ascend-Xmit-Rate"                                 => "Ascend",
            "ASN-Firewall-Available"                           => "ASN",
            "ASN-Firewall-Block-Ping"                          => "ASN",
            "ASN-Firewall-Open"                                => "ASN",
            "ASN-Firewall-State"                               => "ASN",
            "ASN-IP-Pool-Name"                                 => "ASN",
            "ASN-IP-Redirect"                                  => "ASN",
            "ASN-Kbps-Down"                                    => "ASN",
            "ASN-Kbps-Down-Localmedia"                         => "ASN",
            "ASN-Kbps-Up"                                      => "ASN",
            "ASN-Pps-Down"                                     => "ASN",
            "ASN-Pps-Up"                                       => "ASN",
            "ASN-QoS-Available"                                => "ASN",
            "ASN-QoS-State"                                    => "ASN",
            "ASN-TCP-Connlimit"                                => "ASN",
            "ASN-Webfilter-Destination"                        => "ASN",
            "ASN-Webfilter-Domain"                             => "ASN",
            "ASN-Webfilter-Mode"                               => "ASN",
            "ASN-Webfilter-Redirect"                           => "ASN",
            "Assigned-IP-Address"                              => "Ericsson-AB",
            "Asterisk-Acc-Code"                                => "Digium",
            "Asterisk-AMA-Flags"                               => "Digium",
            "Asterisk-Answer-Time"                             => "Digium",
            "Asterisk-Bill-Sec"                                => "Digium",
            "Asterisk-Chan"                                    => "Digium",
            "Asterisk-Clid"                                    => "Digium",
            "Asterisk-Disposition"                             => "Digium",
            "Asterisk-Dst"                                     => "Digium",
            "Asterisk-Dst-Chan"                                => "Digium",
            "Asterisk-Dst-Ctx"                                 => "Digium",
            "Asterisk-Duration"                                => "Digium",
            "Asterisk-End-Time"                                => "Digium",
            "Asterisk-Last-App"                                => "Digium",
            "Asterisk-Last-Data"                               => "Digium",
            "Asterisk-Src"                                     => "Digium",
            "Asterisk-Start-Time"                              => "Digium",
            "Asterisk-Unique-ID"                               => "Digium",
            "Asterisk-User-Field"                              => "Digium",
            "Attainable-Data-Rate-Downstream"                  => "ADSL-Forum",
            "Attainable-Data-Rate-Upstream"                    => "ADSL-Forum",
            "Avaya-PortPriority-Type"                          => "Cajun_p330",
            "Avaya-StaticVlan-Type"                            => "Cajun_p330",
            "Azaire-APN"                                       => "Azaire",
            "Azaire-APN-OI"                                    => "Azaire",
            "Azaire-APN-Resolution-Req"                        => "Azaire",
            "Azaire-Auth-Type"                                 => "Azaire",
            "Azaire-Brand-Code"                                => "Azaire",
            "Azaire-Client-Local-IP"                           => "Azaire",
            "Azaire-Gn-User-Name"                              => "Azaire",
            "Azaire-IMSI"                                      => "Azaire",
            "Azaire-MSISDN"                                    => "Azaire",
            "Azaire-NAS-Type"                                  => "Azaire",
            "Azaire-Policy-Name"                               => "Azaire",
            "Azaire-QoS"                                       => "Azaire",
            "Azaire-Selection-Mode"                            => "Azaire",
            "Azaire-Start-Time"                                => "Azaire",
            "Azaire-Status"                                    => "Azaire",
            "Azaire-Triplets"                                  => "Azaire",
            "BELRAS-Acct"                                      => "Cnergee",
            "BELRAS-AKAMAI-Speed"                              => "Cnergee",
            "BELRAS-Auth"                                      => "Cnergee",
            "BELRAS-BELCACHE-Speed"                            => "Cnergee",
            "BELRAS-BL"                                        => "Cnergee",
            "BELRAS-CACHE-Speed"                               => "Cnergee",
            "BELRAS-CacheFly-Speed"                            => "Cnergee",
            "BELRAS-CO"                                        => "Cnergee",
            "BELRAS-DHCP-Lease-Time"                           => "Cnergee",
            "BELRAS-DHCP-Mask"                                 => "Cnergee",
            "BELRAS-DHCP-Option82"                             => "Cnergee",
            "BELRAS-DHCP-Router-IP-Address"                    => "Cnergee",
            "BELRAS-Down-Speed-Limit"                          => "Cnergee",
            "BELRAS-Framed-IP-Address"                         => "Cnergee",
            "BELRAS-GGC-Speed"                                 => "Cnergee",
            "BELRAS-GOOGLE-Speed"                              => "Cnergee",
            "BELRAS-Group"                                     => "Cnergee",
            "BELRAS-IN"                                        => "Cnergee",
            "BELRAS-Incapsula-Speed"                           => "Cnergee",
            "BELRAS-LIMELIGHT-Speed"                           => "Cnergee",
            "BELRAS-LIMIT"                                     => "Cnergee",
            "BELRAS-Octets-Direction"                          => "Cnergee",
            "BELRAS-OTHERS-Speed"                              => "Cnergee",
            "BELRAS-Qos-Speed"                                 => "Cnergee",
            "BELRAS-REDIFF-Speed"                              => "Cnergee",
            "BELRAS-Redirect"                                  => "Cnergee",
            "BELRAS-redirect-Pool"                             => "Cnergee",
            "BELRAS-Session-Octets-Limit"                      => "Cnergee",
            "BELRAS-TORRENT-Speed"                             => "Cnergee",
            "BELRAS-Up-Speed-Limit"                            => "Cnergee",
            "BELRAS-User"                                      => "Cnergee",
            "BG-Aging-Time"                                    => "Ericsson-AB",
            "BG-Cct-Addr-Max"                                  => "Ericsson-AB",
            "BG-Path-Cost"                                     => "Ericsson-AB",
            "BG-Span-Dis"                                      => "Ericsson-AB",
            "BG-Trans-BPDU"                                    => "Ericsson-AB",
            "Bind-Auth-Context"                                => "Ericsson-AB",
            "Bind-Auth-Max-Sessions"                           => "Ericsson-AB",
            "Bind-Auth-Protocol"                               => "Ericsson-AB",
            "Bind-Auth-Service-Grp"                            => "Ericsson-AB",
            "Bind-Auto-Sub-Context"                            => "Ericsson-AB",
            "Bind-Auto-Sub-Password"                           => "Ericsson-AB",
            "Bind-Auto-Sub-User"                               => "Ericsson-AB",
            "Bind-Bypass-Bypass"                               => "Ericsson-AB",
            "Bind-Bypass-Context"                              => "Ericsson-AB",
            "Bind-Dot1q-Port"                                  => "Ericsson-AB",
            "Bind-Dot1q-Slot"                                  => "Ericsson-AB",
            "Bind-Dot1q-Vlan-Tag-Id"                           => "Ericsson-AB",
            "Bind-Int-Context"                                 => "Ericsson-AB",
            "Bind-Int-Interface-Name"                          => "Ericsson-AB",
            "Bind-L2TP-Flow-Control"                           => "Ericsson-AB",
            "Bind-L2TP-Tunnel-Name"                            => "Ericsson-AB",
            "Bind-Ses-Context"                                 => "Ericsson-AB",
            "Bind-Sub-Password"                                => "Ericsson-AB",
            "Bind-Sub-User-At-Context"                         => "Ericsson-AB",
            "Bind-Tun-Context"                                 => "Ericsson-AB",
            "Bind-Type"                                        => "Ericsson-AB",
            "BinTec-biboDialTable"                             => "BinTec",
            "BinTec-biboPPPTable"                              => "BinTec",
            "BinTec-ipExtIfTable"                              => "BinTec",
            "BinTec-ipExtRtTable"                              => "BinTec",
            "BinTec-ipFilterTable"                             => "BinTec",
            "BinTec-ipNatPresetTable"                          => "BinTec",
            "BinTec-ipQoSTable"                                => "BinTec",
            "BinTec-ipRouteTable"                              => "BinTec",
            "BinTec-ipxCircTable"                              => "BinTec",
            "BinTec-ipxStaticRouteTable"                       => "BinTec",
            "BinTec-ipxStaticServTable"                        => "BinTec",
            "BinTec-ospfIfTable"                               => "BinTec",
            "BinTec-pppExtIfTable"                             => "BinTec",
            "BinTec-qosIfTable"                                => "BinTec",
            "BinTec-qosPolicyTable"                            => "BinTec",
            "BinTec-ripCircTable"                              => "BinTec",
            "BinTec-sapCircTable"                              => "BinTec",
            "Blue-Coat-Authorization"                          => "BlueCoat",
            "Blue-Coat-Group"                                  => "BlueCoat",
            "Breezecom-Attr1"                                  => "Alvarion",
            "Breezecom-Attr10"                                 => "Alvarion",
            "Breezecom-Attr11"                                 => "Alvarion",
            "Breezecom-Attr2"                                  => "Alvarion",
            "Breezecom-Attr3"                                  => "Alvarion",
            "Breezecom-Attr4"                                  => "Alvarion",
            "Breezecom-Attr5"                                  => "Alvarion",
            "Breezecom-Attr6"                                  => "Alvarion",
            "Breezecom-Attr7"                                  => "Alvarion",
            "Breezecom-Attr8"                                  => "Alvarion",
            "Breezecom-Attr9"                                  => "Alvarion",
            "Bridge-Group"                                     => "Ericsson-AB",
            "BroadSoft-Attr-255"                               => "BroadSoft",
            "Brocade-Auth-Role"                                => "Brocade",
            "Brocade-AVPairs1"                                 => "Brocade",
            "Brocade-AVPairs2"                                 => "Brocade",
            "Brocade-AVPairs3"                                 => "Brocade",
            "Brocade-AVPairs4"                                 => "Brocade",
            "Brocade-Passwd-ExpiryDate"                        => "Brocade",
            "Brocade-Passwd-WarnPeriod"                        => "Brocade",
            "BSN-AVPair"                    => "Big-Switch-Networks",
            "BSN-User-Role"                 => "Big-Switch-Networks",
            "BW-Area-Code"                  => "Boingo",
            "BW-Category"                   => "Boingo",
            "BW-City-Name"                  => "Boingo",
            "BW-Class"                      => "Boingo",
            "BW-e164-Country-Code"          => "Boingo",
            "BW-ISO-Country-Code"           => "Boingo",
            "BW-Operator-Name"              => "Boingo",
            "BW-Service-Type"               => "Boingo",
            "BW-State-Name"                 => "Boingo",
            "BW-User-Group"                 => "Boingo",
            "BW-User-Name"                  => "Boingo",
            "BW-User-Password"              => "Boingo",
            "BW-User-Prefix"                => "Boingo",
            "BW-User-Realm"                 => "Boingo",
            "BW-User-Role"                  => "Boingo",
            "BW-Venue-Description"          => "Boingo",
            "BW-Venue-Id"                   => "Boingo",
            "BW-Venue-Name"                 => "Boingo",
            "BW-Venue-Port-Type"            => "Boingo",
            "BW-Venue-Price-Type"           => "Boingo",
            "BW-Venue-TZ"                   => "Boingo",
            "BWAS-Acb-Act-Fac-Result"       => "BroadSoft",
            "BWAS-Acb-Act-Invoke-Time"      => "BroadSoft",
            "BWAS-Acb-Deact-Fac-Result"     => "BroadSoft",
            "BWAS-Acb-Deact-Invoke-Time"    => "BroadSoft",
            "BWAS-Acc-Per-Call-Fac-Result"  => "BroadSoft",
            "BWAS-Acc-Per-Call-Invoke-Time" => "BroadSoft",
            "BWAS-Access-Callid"            => "BroadSoft",
            "BWAS-Access-Device-Address"    => "BroadSoft",
            "BWAS-Access-Network-Info"      => "BroadSoft",
            "BWAS-Account-Code"             => "BroadSoft",
            "BWAS-Acr-Act-Fac-Result"       => "BroadSoft",
            "BWAS-Acr-Act-Invoke-Time"      => "BroadSoft",
            "BWAS-Acr-Deact-Fac-Result"     => "BroadSoft",
            "BWAS-Acr-Deact-Invoke-Time"    => "BroadSoft",
            "BWAS-AHR-Action"               => "BroadSoft",
            "BWAS-AHR-Invoke-Time"          => "BroadSoft",
            "BWAS-Answer-Indic"             => "BroadSoft",
            "BWAS-Answer-Time"              => "BroadSoft",
            "BWAS-AOC-Activation-Time"      => "BroadSoft",
            "BWAS-AOC-Charge"               => "BroadSoft",
            "BWAS-AOC-Currency"             => "BroadSoft",
            "BWAS-AOC-Result"               => "BroadSoft",
            "BWAS-AOC-Sum"                  => "BroadSoft",
            "BWAS-AOC-Time"                 => "BroadSoft",
            "BWAS-AOC-Type"                 => "BroadSoft",
            "BWAS-AS-Call-Type"             => "BroadSoft",
            "BWAS-Authorization-Code"       => "BroadSoft",
            "BWAS-BA-Related-Call-Id"       => "BroadSoft",
            "BWAS-Body-Content-Disposition" => "BroadSoft",
            "BWAS-Body-Content-Length"      => "BroadSoft",
            "BWAS-Body-Content-Type"        => "BroadSoft",
            "BWAS-Body-Originator"          => "BroadSoft",
            "BWAS-Call-Bridge-Result"       => "BroadSoft",
            "BWAS-Call-Category"            => "BroadSoft",
            "BWAS-Call-Center-Forced-Forwarding-Act-Result"      => "BroadSoft",
            "BWAS-Call-Center-Forced-Forwarding-Deact-Result"    => "BroadSoft",
            "BWAS-Call-Center-Night-Service-Act-Result"          => "BroadSoft",
            "BWAS-Call-Center-Night-Service-Deact-Result"        => "BroadSoft",
            "BWAS-Call-Center-Outgoing-Call-Fac-Result"          => "BroadSoft",
            "BWAS-Call-Center-Outgoing-Personal-Call-Fac-Result" => "BroadSoft",
            "BWAS-Call-Center-Outgoing-Phone-Number"             => "BroadSoft",
            "BWAS-Call-Park-Fac-Result"                          => "BroadSoft",
            "BWAS-Call-Park-Invoke-Time"                         => "BroadSoft",
            "BWAS-Call-Park-Retr-Fac-Result"                     => "BroadSoft",
            "BWAS-Call-Park-Retr-Invoke-Time"                    => "BroadSoft",
            "BWAS-Call-Parked-Invoke-Time"                       => "BroadSoft",
            "BWAS-Call-Pickup-Fac-Result"                        => "BroadSoft",
            "BWAS-Call-Pickup-Invoke-Time"                       => "BroadSoft",
            "BWAS-Call-Retrieve-Result"                          => "BroadSoft",
            "BWAS-Call-Waiting-Act-Fac-Result"                   => "BroadSoft",
            "BWAS-Call-Waiting-Act-Invoke-Time"                  => "BroadSoft",
            "BWAS-Call-Waiting-Deact-Fac-Result"                 => "BroadSoft",
            "BWAS-Call-Waiting-Deact-Invoke-Time"                => "BroadSoft",
            "BWAS-Called-Asserted-Identity"                      => "BroadSoft",
            "BWAS-Called-Asserted-Pres-Indicator"                => "BroadSoft",
            "BWAS-Called-Number"                                 => "BroadSoft",
            "BWAS-Called-Number-Context"                         => "BroadSoft",
            "BWAS-Calling-Number"                                => "BroadSoft",
            "BWAS-Calling-Number-Context"                        => "BroadSoft",
            "BWAS-Calling-Party-Category"                        => "BroadSoft",
            "BWAS-Calling-Presentation-Indic"                    => "BroadSoft",
            "BWAS-Cancel-Cwt-Per-Call-Fac-Result"                => "BroadSoft",
            "BWAS-Cancel-Cwt-Per-Call-Invoke-Time"               => "BroadSoft",
            "BWAS-Carrier-Identification-Code"                   => "BroadSoft",
            "BWAS-CBF-Auth-Code"                                 => "BroadSoft",
            "BWAS-Cfa-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Cfa-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Cfa-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Cfa-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Cfa-Inter-Fac-Result"                          => "BroadSoft",
            "BWAS-Cfa-Inter-Invoke-Time"                         => "BroadSoft",
            "BWAS-Cfb-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Cfb-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Cfb-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Cfb-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Cfb-Inter-Fac-Result"                          => "BroadSoft",
            "BWAS-Cfb-Inter-Invoke-Time"                         => "BroadSoft",
            "BWAS-Cfna-Act-Fac-Result"                           => "BroadSoft",
            "BWAS-Cfna-Act-Invoke-Time"                          => "BroadSoft",
            "BWAS-Cfna-Deact-Fac-Result"                         => "BroadSoft",
            "BWAS-Cfna-Deact-Invoke-Time"                        => "BroadSoft",
            "BWAS-Cfna-Inter-Fac-Result"                         => "BroadSoft",
            "BWAS-Cfna-Inter-Invoke-Time"                        => "BroadSoft",
            "BWAS-Cfnrc-Act-Fac-Result"                          => "BroadSoft",
            "BWAS-Cfnrc-Act-Invoke-Time"                         => "BroadSoft",
            "BWAS-Cfnrc-Deact-Fac-Result"                        => "BroadSoft",
            "BWAS-Cfnrc-Deact-Invoke-Time"                       => "BroadSoft",
            "BWAS-Charge-Indic"                                  => "BroadSoft",
            "BWAS-Charge-Number"                                 => "BroadSoft",
            "BWAS-Charging-Function-Addresses"                   => "BroadSoft",
            "BWAS-Charging-Vection-Creator"                      => "BroadSoft",
            "BWAS-Charging-Vection-Orig"                         => "BroadSoft",
            "BWAS-Charging-Vection-Term"                         => "BroadSoft",
            "BWAS-Charging-Vector-Key"                           => "BroadSoft",
            "BWAS-Clear-Mwi-Fac-Result"                          => "BroadSoft",
            "BWAS-Clear-Mwi-Invoke-Time"                         => "BroadSoft",
            "BWAS-Clid-Blocking-Act-Fac-Result"                  => "BroadSoft",
            "BWAS-Clid-Blocking-Act-Invoke-Time"                 => "BroadSoft",
            "BWAS-Clid-Blocking-Deact-Fac-Result"                => "BroadSoft",
            "BWAS-Clid-Blocking-Deact-Invoke-Time"               => "BroadSoft",
            "BWAS-Clid-Blocking-Per-Call-Fac-Result"             => "BroadSoft",
            "BWAS-Clid-Blocking-Per-Call-Invoke-Time"            => "BroadSoft",
            "BWAS-Clid-Delivery-Per-Call-Fac-Result"             => "BroadSoft",
            "BWAS-Clid-Delivery-Per-Call-Invoke-Time"            => "BroadSoft",
            "BWAS-CLID-Permitted"                                => "BroadSoft",
            "BWAS-Codec"                                         => "BroadSoft",
            "BWAS-Codec-Usage"                                   => "BroadSoft",
            "BWAS-Conf-Id"                                       => "BroadSoft",
            "BWAS-Conf-Start-Time"                               => "BroadSoft",
            "BWAS-Conf-Stop-Time"                                => "BroadSoft",
            "BWAS-Conf-Type"                                     => "BroadSoft",
            "BWAS-Conference-Bridge"                             => "BroadSoft",
            "BWAS-Conference-Callid"                             => "BroadSoft",
            "BWAS-Conference-From"                               => "BroadSoft",
            "BWAS-Conference-Id"                                 => "BroadSoft",
            "BWAS-Conference-Invoke-Time"                        => "BroadSoft",
            "BWAS-Conference-Owner"                              => "BroadSoft",
            "BWAS-Conference-Owner-Dn"                           => "BroadSoft",
            "BWAS-Conference-Project-Code"                       => "BroadSoft",
            "BWAS-Conference-Role"                               => "BroadSoft",
            "BWAS-Conference-Title"                              => "BroadSoft",
            "BWAS-Conference-To"                                 => "BroadSoft",
            "BWAS-Configurable-CLID"                             => "BroadSoft",
            "BWAS-Cot-Fac-Result"                                => "BroadSoft",
            "BWAS-Cot-Invoke-Time"                               => "BroadSoft",
            "BWAS-CustomRingback-Invoke-Time"                    => "BroadSoft",
            "BWAS-CustomRingback-Media-Selection"                => "BroadSoft",
            "BWAS-Department"                                    => "BroadSoft",
            "BWAS-Dialed-Digits"                                 => "BroadSoft",
            "BWAS-Dialed-Digits-Context"                         => "BroadSoft",
            "BWAS-Direct-Vm-Xfer-Fac-Result"                     => "BroadSoft",
            "BWAS-Direct-Vm-Xfer-Invoke-Time"                    => "BroadSoft",
            "BWAS-Directed-Call-Pickup-Fac-Result"               => "BroadSoft",
            "BWAS-Directed-Call-Pickup-Invoke-Time"              => "BroadSoft",
            "BWAS-Direction"                                     => "BroadSoft",
            "BWAS-Diversion-Inhibitor-Fac-Result"                => "BroadSoft",
            "BWAS-Diversion-Inhibitor-Invoke-time"               => "BroadSoft",
            "BWAS-Dnd-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Dnd-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Dnd-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Dnd-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Dpubi-Fac-Result"                              => "BroadSoft",
            "BWAS-Dpubi-Invoke-Time"                             => "BroadSoft",
            "BWAS-Early-Media-Initiator-Flag"                    => "BroadSoft",
            "BWAS-Early-Media-SDP"                               => "BroadSoft",
            "BWAS-Failover-Correlation-Id"                       => "BroadSoft",
            "BWAS-Fax-Messaging"                                 => "BroadSoft",
            "BWAS-Flash-Call-Hold-Fac-Result"                    => "BroadSoft",
            "BWAS-Flash-Call-Hold-Invoke-Time"                   => "BroadSoft",
            "BWAS-Group"                                         => "BroadSoft",
            "BWAS-Group-Number"                                  => "BroadSoft",
            "BWAS-Hoteling-Group"                                => "BroadSoft",
            "BWAS-Hoteling-Group-Number"                         => "BroadSoft",
            "BWAS-Hoteling-Invoke-Time"                          => "BroadSoft",
            "BWAS-Hoteling-User-Number"                          => "BroadSoft",
            "BWAS-Hoteling-UserId"                               => "BroadSoft",
            "BWAS-InstantGroupCall-Invoke-Time"                  => "BroadSoft",
            "BWAS-InstantGroupCall-PushToTalk"                   => "BroadSoft",
            "BWAS-InstantGroupCall-Related-Callid"               => "BroadSoft",
            "BWAS-Last-Number-Redial-Fac-Result"                 => "BroadSoft",
            "BWAS-Last-Number-Redial-Invoke-Time"                => "BroadSoft",
            "BWAS-Local-Callid"                                  => "BroadSoft",
            "BWAS-Location-Control-Act-Result"                   => "BroadSoft",
            "BWAS-Location-Control-Deact-Result"                 => "BroadSoft",
            "BWAS-Media-Initiator-Flag"                          => "BroadSoft",
            "BWAS-Moh-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Network-Call-Type"                             => "BroadSoft",
            "BWAS-Network-Callid"                                => "BroadSoft",
            "BWAS-Network-Translated-Group"                      => "BroadSoft",
            "BWAS-Network-Translated-Number"                     => "BroadSoft",
            "BWAS-Network-Translated-Number-Context"             => "BroadSoft",
            "BWAS-Network-Type"                                  => "BroadSoft",
            "BWAS-No-Answer-Set-Fac-Result"                      => "BroadSoft",
            "BWAS-No-Answer-Set-Invoke-Time"                     => "BroadSoft",
            "BWAS-Original-Called-Number"                        => "BroadSoft",
            "BWAS-Original-Called-Number-Context"                => "BroadSoft",
            "BWAS-Original-Called-Presentation-Indic"            => "BroadSoft",
            "BWAS-Original-Called-Reason"                        => "BroadSoft",
            "BWAS-Origination-Method"                            => "BroadSoft",
            "BWAS-Other-Party-Name"                              => "BroadSoft",
            "BWAS-Other-Party-Name-Pres-Indic"                   => "BroadSoft",
            "BWAS-OtherInfoInPCV"                                => "BroadSoft",
            "BWAS-Outside-Access-Code"                           => "BroadSoft",
            "BWAS-Prepaid-Status"                                => "BroadSoft",
            "BWAS-Primary-Device-Line-Port"                      => "BroadSoft",
            "BWAS-Push-to-Talk-Fac-Result"                       => "BroadSoft",
            "BWAS-Push-to-Talk-Invoke-Time"                      => "BroadSoft",
            "BWAS-Q850-Cause"                                    => "BroadSoft",
            "BWAS-Recall-Type"                                   => "BroadSoft",
            "BWAS-Received-Calling-Number"                       => "BroadSoft",
            "BWAS-Record-id"                                     => "BroadSoft",
            "BWAS-Redirecting-Number"                            => "BroadSoft",
            "BWAS-Redirecting-Number-Context"                    => "BroadSoft",
            "BWAS-Redirecting-Presentation-Indic"                => "BroadSoft",
            "BWAS-Redirecting-Reason"                            => "BroadSoft",
            "BWAS-Related-CallId"                                => "BroadSoft",
            "BWAS-Related-CallId-Reason"                         => "BroadSoft",
            "BWAS-Release-Time"                                  => "BroadSoft",
            "BWAS-Releasing-Party"                               => "BroadSoft",
            "BWAS-Remote-Callid"                                 => "BroadSoft",
            "BWAS-Return-Call-Fac-Result"                        => "BroadSoft",
            "BWAS-Return-Call-Invoke-Time"                       => "BroadSoft",
            "BWAS-Return-Call-Number-Deletion-Fac-Result"        => "BroadSoft",
            "BWAS-Return-Call-Number-Deletion-Invoke-Time"       => "BroadSoft",
            "BWAS-Route"                                         => "BroadSoft",
            "BWAS-Routing-Number"                                => "BroadSoft",
            "BWAS-Sac-Lock-Fac-Result"                           => "BroadSoft",
            "BWAS-Sac-Lock-Invoke-Time"                          => "BroadSoft",
            "BWAS-Sac-Unlock-Fac-Result"                         => "BroadSoft",
            "BWAS-Sac-Unlock-Invoke-Time"                        => "BroadSoft",
            "BWAS-Scf-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Scf-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Scf-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Scf-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Sd100-Programming-Fac-Result"                  => "BroadSoft",
            "BWAS-Sd100-Programming-Invoke-Time"                 => "BroadSoft",
            "BWAS-Sd8-Programming-Fac-Result"                    => "BroadSoft",
            "BWAS-Sd8-Programming-Invoke-Time"                   => "BroadSoft",
            "BWAS-SDP"                                           => "BroadSoft",
            "BWAS-SDP-Answer-Timestamp"                          => "BroadSoft",
            "BWAS-SDP-Offer-Timestamp"                           => "BroadSoft",
            "BWAS-Service-provider"                              => "BroadSoft",
            "BWAS-SIP-Error-Code"                                => "BroadSoft",
            "BWAS-Spare-136"                                     => "BroadSoft",
            "BWAS-Spare-29"                                      => "BroadSoft",
            "BWAS-Spare-31"                                      => "BroadSoft",
            "BWAS-Start-Time"                                    => "BroadSoft",
            "BWAS-Termination-Cause"                             => "BroadSoft",
            "BWAS-Transfer-Invoke-Time"                          => "BroadSoft",
            "BWAS-Transfer-Related-CallId"                       => "BroadSoft",
            "BWAS-Transfer-Result"                               => "BroadSoft",
            "BWAS-Transfer-Type"                                 => "BroadSoft",
            "BWAS-Trunk-Group-Info"                              => "BroadSoft",
            "BWAS-Trunk-Group-Name"                              => "BroadSoft",
            "BWAS-TSD-Digits"                                    => "BroadSoft",
            "BWAS-Type"                                          => "BroadSoft",
            "BWAS-Type-Of-Network"                               => "BroadSoft",
            "BWAS-User-Number"                                   => "BroadSoft",
            "BWAS-User-Timezone"                                 => "BroadSoft",
            "BWAS-UserId"                                        => "BroadSoft",
            "BWAS-Vma-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Vma-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Vma-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Vma-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Vmb-Act-Fac-Result"                            => "BroadSoft",
            "BWAS-Vmb-Act-Invoke-Time"                           => "BroadSoft",
            "BWAS-Vmb-Deact-Fac-Result"                          => "BroadSoft",
            "BWAS-Vmb-Deact-Invoke-Time"                         => "BroadSoft",
            "BWAS-Vmna-Act-Fac-Result"                           => "BroadSoft",
            "BWAS-Vmna-Act-Invoke-Time"                          => "BroadSoft",
            "BWAS-Vmna-Deact-Fac-Result"                         => "BroadSoft",
            "BWAS-Vmna-Deact-Invoke-Time"                        => "BroadSoft",
            "BWAS-VP-Calling-Invoke-Time"                        => "BroadSoft",
            "CableLabs-Account-Code"                             => "CableLabs",
            "CableLabs-Alerting-Signal"                          => "CableLabs",
            "CableLabs-AM-Opaque-Data"                           => "CableLabs",
            "CableLabs-Application-Manager-ID"                   => "CableLabs",
            "CableLabs-Authorization-Code"                       => "CableLabs",
            "CableLabs-Call-Termination-Cause"                   => "CableLabs",
            "CableLabs-Called-Party-Number"                      => "CableLabs",
            "CableLabs-Calling-Party-Number"                     => "CableLabs",
            "CableLabs-Carrier-Identification-Code"              => "CableLabs",
            "CableLabs-CCC-ID"                                   => "CableLabs",
            "CableLabs-Channel-State"                            => "CableLabs",
            "CableLabs-Charge-Number"                            => "CableLabs",
            "CableLabs-Database-ID"                              => "CableLabs",
            "CableLabs-Dial-Around-Code"                         => "CableLabs",
            "CableLabs-Dialed-Digits"                            => "CableLabs",
            "CableLabs-Direction-indicator"                      => "CableLabs",
            "CableLabs-El-Surveillance-DF-Security"              => "CableLabs",
            "CableLabs-Electronic-Surveillance-Ind"              => "CableLabs",
            "CableLabs-Element-Requesting-QoS"                   => "CableLabs",
            "CableLabs-Error-Description"                        => "CableLabs",
            "CableLabs-Event-Message"                            => "CableLabs",
            "CableLabs-Financial-Entity-ID"                      => "CableLabs",
            "CableLabs-First-Call-Calling-Party-Num"             => "CableLabs",
            "CableLabs-Flow-Direction"                           => "CableLabs",
            "CableLabs-Forwarded-Number"                         => "CableLabs",
            "CableLabs-Gate-Time-Info"                           => "CableLabs",
            "CableLabs-Gate-Usage-Info"                          => "CableLabs",
            "CableLabs-Intl-Code"                                => "CableLabs",
            "CableLabs-Location-Routing-Number"                  => "CableLabs",
            "CableLabs-Misc-Signaling-Information"               => "CableLabs",
            "CableLabs-MTA-Endpoint-Name"                        => "CableLabs",
            "CableLabs-MTA-UDP-Portnum"                          => "CableLabs",
            "CableLabs-Policy-Decision-Status"                   => "CableLabs",
            "CableLabs-Policy-Deleted-Reason"                    => "CableLabs",
            "CableLabs-Policy-Denied-Reason"                     => "CableLabs",
            "CableLabs-Policy-Update-Reason"                     => "CableLabs",
            "CableLabs-QoS-Descriptor"                           => "CableLabs",
            "CableLabs-QoS-Release-Reason"                       => "CableLabs",
            "CableLabs-Query-Type"                               => "CableLabs",
            "CableLabs-Redirected-From-Info"                     => "CableLabs",
            "CableLabs-Redirected-From-Party-Number"             => "CableLabs",
            "CableLabs-Redirected-To-Party-Number"               => "CableLabs",
            "CableLabs-Related-Call-Billing-Crl-ID"              => "CableLabs",
            "CableLabs-Reserved"                                 => "CableLabs",
            "CableLabs-Returned-Number"                          => "CableLabs",
            "CableLabs-Routing-Number"                           => "CableLabs",
            "CableLabs-SDP-Downstream"                           => "CableLabs",
            "CableLabs-SDP-Upstream"                             => "CableLabs",
            "CableLabs-Second-Call-Calling-Party-Num"            => "CableLabs",
            "CableLabs-Service-Name"                             => "CableLabs",
            "CableLabs-SF-ID"                                    => "CableLabs",
            "CableLabs-Signal-Type"                              => "CableLabs",
            "CableLabs-Subject-Audible-Signal"                   => "CableLabs",
            "CableLabs-Subscriber-ID"                            => "CableLabs",
            "CableLabs-Switch-Hook-Flash"                        => "CableLabs",
            "CableLabs-Terminal-Display-Info"                    => "CableLabs",
            "CableLabs-Time-Adjustment"                          => "CableLabs",
            "CableLabs-Time-Usage-Limit"                         => "CableLabs",
            "CableLabs-Translation-Input"                        => "CableLabs",
            "CableLabs-Trunk-Group-ID"                           => "CableLabs",
            "CableLabs-User-Input"                               => "CableLabs",
            "CableLabs-Volume-Usage-Limit"                       => "CableLabs",
            "Cabletron-Protocol-Callable"                        => "Cabletron",
            "Cabletron-Protocol-Enable"                          => "Cabletron",
            "Cajun-Service-Type"                             => "Cajun_p330",
            "call-id"                                        => "Cisco",
            "Cambium-Acct-Class-Name"                        => "Cambium",
            "Cambium-Acct-Input-Octets"                      => "Cambium",
            "Cambium-Acct-Input-Packets"                     => "Cambium",
            "Cambium-Acct-Output-Octets"                     => "Cambium",
            "Cambium-Acct-Output-Packets"                    => "Cambium",
            "Cambium-Auth-Role"                              => "Cambium",
            "Cambium-Authorize-Bytes-Left"                   => "Cambium",
            "Cambium-Authorize-Class-Name"                   => "Cambium",
            "Cambium-Authorize-Classes"                      => "Cambium",
            "Cambium-ePMP-Data-VLAN-Id"                      => "Cambium",
            "Cambium-ePMP-Data-VLAN-Priority"                => "Cambium",
            "Cambium-ePMP-Management-VLAN-Id"                => "Cambium",
            "Cambium-ePMP-Management-VLAN-Priority"          => "Cambium",
            "Cambium-ePMP-Max-Burst-Downlink-Rate"           => "Cambium",
            "Cambium-ePMP-Max-Burst-Uplink-Rate"             => "Cambium",
            "Cambium-ePMP-Multicast-VLAN-Id"                 => "Cambium",
            "Cambium-ePMP-Separate-Management-VLAN-Id"       => "Cambium",
            "Cambium-ePMP-Separate-Management-VLAN-Priority" => "Cambium",
            "Cambium-ePMP-SM-Priority"                       => "Cambium",
            "Cambium-ePMP-UserLevel"                         => "Cambium",
            "Cambium-ePMP-VLAN-Mapping"                      => "Cambium",
            "Cambium-ePMP-VLAN-Membersip-Set"                => "Cambium",
            "Cambium-Traffic-Classes-Acct"                   => "Cambium",
            "Cambium-Traffic-Quota-Limit-Down"               => "Cambium",
            "Cambium-Traffic-Quota-Limit-Down-Gigwords"      => "Cambium",
            "Cambium-Traffic-Quota-Limit-Total"              => "Cambium",
            "Cambium-Traffic-Quota-Limit-Total-Gigwords"     => "Cambium",
            "Cambium-Traffic-Quota-Limit-Up"                 => "Cambium",
            "Cambium-Traffic-Quota-Limit-Up-Gigwords"        => "Cambium",
            "Cambium-VLAN-Pool-Id"                           => "Cambium",
            "Cambium-Walled-Garden-State"                    => "Cambium",
            "Camiant-MI-role"                                => "Camiant",
            "Camiant-MI-scope"                               => "Camiant",
            "Camiant-SUI-role"                               => "Camiant",
            "CBBSM-Bandwidth"                                => "Cisco-BBSM",
            "Centec-Exec-Privilege"                          => "Centec",
            "CES-Group"                                      => "Bay-Networks",
            "Charging-Group-ID"                     => "VerizonWireless",
            "ChilliSpot-Bandwidth-Max-Down"         => "ChilliSpot",
            "ChilliSpot-Bandwidth-Max-Up"           => "ChilliSpot",
            "ChilliSpot-Config"                     => "ChilliSpot",
            "ChilliSpot-Interval"                   => "ChilliSpot",
            "ChilliSpot-Lang"                       => "ChilliSpot",
            "ChilliSpot-MAC-Allowed"                => "ChilliSpot",
            "ChilliSpot-Max-Input-Octets"           => "ChilliSpot",
            "ChilliSpot-Max-Output-Octets"          => "ChilliSpot",
            "ChilliSpot-Max-Total-Octets"           => "ChilliSpot",
            "ChilliSpot-OriginalURL"                => "ChilliSpot",
            "ChilliSpot-UAM-Allowed"                => "ChilliSpot",
            "ChilliSpot-Version"                    => "ChilliSpot",
            "Ciena-BP-Role"                         => "Ciena",
            "Ciena-CES-Priv-Level"                  => "Ciena",
            "Ciena-CN4200-Priv-Level"               => "Ciena",
            "Ciena-CS-Acc-Level"                    => "Ciena",
            "Ciena-CS-Client-IP"                    => "Ciena",
            "Ciena-CS-Priv-Level"                   => "Ciena",
            "Ciena-NCS-Role"                        => "Ciena",
            "Ciena-OC-Role"                         => "Ciena",
            "Circuit-Group-Member"                  => "Ericsson-AB",
            "Circuit-Protocol-Encap"                => "Ericsson-AB",
            "Cisco-Abort-Cause"                     => "Cisco",
            "Cisco-Account-Info"                    => "Cisco",
            "Cisco-Assign-IP-Pool"                  => "Cisco",
            "Cisco-AVPair"                          => "Cisco",
            "Cisco-Call-Filter"                     => "Cisco",
            "Cisco-Call-Type"                       => "Cisco",
            "Cisco-Command-Code"                    => "Cisco",
            "Cisco-Control-Info"                    => "Cisco",
            "Cisco-Data-Filter"                     => "Cisco",
            "Cisco-Data-Rate"                       => "Cisco",
            "Cisco-DHCP-Relay-GiAddr"               => "Cisco",
            "Cisco-DHCP-Subscriber-Id"              => "Cisco",
            "Cisco-DHCP-User-Class"                 => "Cisco",
            "Cisco-DHCP-Vendor-Class"               => "Cisco",
            "Cisco-DHCPv6-Link-Address"             => "Cisco",
            "Cisco-Disconnect-Cause"                => "Cisco",
            "Cisco-Email-Server-Ack-Flag"           => "Cisco",
            "Cisco-Email-Server-Address"            => "Cisco",
            "Cisco-Fax-Account-Id-Origin"           => "Cisco",
            "Cisco-Fax-Auth-Status"                 => "Cisco",
            "Cisco-Fax-Connect-Speed"               => "Cisco",
            "Cisco-Fax-Coverpage-Flag"              => "Cisco",
            "Cisco-Fax-Dsn-Address"                 => "Cisco",
            "Cisco-Fax-Dsn-Flag"                    => "Cisco",
            "Cisco-Fax-Mdn-Address"                 => "Cisco",
            "Cisco-Fax-Mdn-Flag"                    => "Cisco",
            "Cisco-Fax-Modem-Time"                  => "Cisco",
            "Cisco-Fax-Msg-Id"                      => "Cisco",
            "Cisco-Fax-Pages"                       => "Cisco",
            "Cisco-Fax-Process-Abort-Flag"          => "Cisco",
            "Cisco-Fax-Recipient-Count"             => "Cisco",
            "Cisco-Gateway-Id"                      => "Cisco",
            "Cisco-Idle-Limit"                      => "Cisco",
            "Cisco-In-ACL"                          => "Cisco",
            "Cisco-IP-Direct"                       => "Cisco",
            "Cisco-IP-Pool-Definition"              => "Cisco",
            "Cisco-IPv6-In-ACL"                     => "Cisco",
            "Cisco-IPv6-Out-ACL"                    => "Cisco",
            "Cisco-Link-Compression"                => "Cisco",
            "Cisco-Maximum-Channels"                => "Cisco",
            "Cisco-Maximum-Time"                    => "Cisco",
            "Cisco-Multilink-ID"                    => "Cisco",
            "Cisco-NAS-Port"                        => "Cisco",
            "Cisco-Num-In-Multilink"                => "Cisco",
            "Cisco-Out-ACL"                         => "Cisco",
            "Cisco-Parent-Session-Id"               => "Cisco",
            "Cisco-Policy-Down"                     => "Cisco",
            "Cisco-Policy-Up"                       => "Cisco",
            "Cisco-Port-Used"                       => "Cisco",
            "Cisco-PPP-Async-Map"                   => "Cisco",
            "Cisco-PPP-VJ-Slot-Comp"                => "Cisco",
            "Cisco-Pre-Input-Octets"                => "Cisco",
            "Cisco-Pre-Input-Packets"               => "Cisco",
            "Cisco-Pre-Output-Octets"               => "Cisco",
            "Cisco-Pre-Output-Packets"              => "Cisco",
            "Cisco-PreSession-Time"                 => "Cisco",
            "Cisco-PW-Lifetime"                     => "Cisco",
            "Cisco-Relay-Information-Option"        => "Cisco",
            "Cisco-Route-IP"                        => "Cisco",
            "Cisco-Service-Info"                    => "Cisco",
            "Cisco-Service-Name"                    => "Cisco",
            "Cisco-Sub-Activate-Service"            => "Cisco",
            "Cisco-Sub-Deactivate-Service"          => "Cisco",
            "Cisco-Sub-PBR-Policy-In"               => "Cisco",
            "Cisco-Sub-QoS-Pol-In"                  => "Cisco",
            "Cisco-Sub-QoS-Pol-Out"                 => "Cisco",
            "Cisco-Subscriber-Password"             => "Cisco",
            "Cisco-Target-Util"                     => "Cisco",
            "Cisco-Xmit-Rate"                       => "Cisco",
            "Citrix-GID"                            => "Citrix",
            "Citrix-Group-Ids"                      => "Citrix",
            "Citrix-Group-Names"                    => "Citrix",
            "Citrix-Home"                           => "Citrix",
            "Citrix-Shell"                          => "Citrix",
            "Citrix-UID"                            => "Citrix",
            "Citrix-User-Groups"                    => "Citrix",
            "CL-APDB-Version"                       => "Boingo",
            "CL-Brand"                              => "Boingo",
            "CL-Method-Version"                     => "Boingo",
            "CL-Reg-Number"                         => "Boingo",
            "CL-Software-Version"                   => "Boingo",
            "CL-SSC"                                => "Boingo",
            "CL-Token-Version"                      => "Boingo",
            "CL-User-Agent"                         => "Boingo",
            "Class-Volume-In-Counter"               => "Ericsson-AB",
            "Class-Volume-limit"                    => "Ericsson-AB",
            "Class-Volume-Out-Counter"              => "Ericsson-AB",
            "Clavister-User-Group"                  => "Clavister",
            "Client-DNS-Pri"                        => "Ericsson-AB",
            "Client-DNS-Sec"                        => "Ericsson-AB",
            "Client-NBNS-Pri"                       => "Ericsson-AB",
            "Client-NBNS-Sec"                       => "Ericsson-AB",
            "Cluster-Partition-ID"                  => "Ericsson-AB",
            "Colubris-AVPair"                       => "Colubris",
            "Colubris-Intercept"                    => "Colubris",
            "Commands"                              => "Bay-Networks",
            "Compatible-Echo"                       => "Compatible",
            "Compatible-Tunnel-Delay"               => "Compatible",
            "Compatible-Tunnel-Group-Info"          => "Compatible",
            "Compatible-Tunnel-IPX"                 => "Compatible",
            "Compatible-Tunnel-Password"            => "Compatible",
            "Compatible-Tunnel-Server-Endpoint"     => "Compatible",
            "Compatible-Tunnel-Throughput"          => "Compatible",
            "Context-Name"                          => "Ericsson-AB",
            "Cosine-Address-Pool-Name"              => "Cosine",
            "Cosine-CLI-User-Permission-ID"         => "Cosine",
            "Cosine-Connection-Profile-Name"        => "Cosine",
            "Cosine-DLCI"                           => "Cosine",
            "Cosine-DS-Byte"                        => "Cosine",
            "Cosine-Enterprise-ID"                  => "Cosine",
            "Cosine-LNS-IP-Address"                 => "Cosine",
            "Cosine-VPI-VCI"                        => "Cosine",
            "Covaro-Inhibit-Dbchg"                  => "Covaro",
            "Covaro-Inhibit-Message"                => "Covaro",
            "Covaro-Inhibit-Pmrept"                 => "Covaro",
            "Covaro-Max-Sessions"                   => "Covaro",
            "Covaro-Session-Timeout"                => "Covaro",
            "Covaro-User-Privilege"                 => "Covaro",
            "CP-Gaia-SuperUser-Access"              => "CheckPoint",
            "CP-Gaia-User-Role"                     => "CheckPoint",
            "CVPN5000-Client-Assigned-IP"           => "Cisco-VPN5000",
            "CVPN5000-Client-Assigned-IPX"          => "Cisco-VPN5000",
            "CVPN5000-Client-Real-IP"               => "Cisco-VPN5000",
            "CVPN5000-Echo"                         => "Cisco-VPN5000",
            "CVPN5000-Tunnel-Throughput"            => "Cisco-VPN5000",
            "CVPN5000-VPN-GroupInfo"                => "Cisco-VPN5000",
            "CVPN5000-VPN-Password"                 => "Cisco-VPN5000",
            "CVX-Assign-IP-Pool"                    => "Aptis",
            "CVX-Client-Assign-DNS"                 => "Aptis",
            "CVX-Data-Filter"                       => "Aptis",
            "CVX-Data-Rate"                         => "Aptis",
            "CVX-Disconnect-Cause"                  => "Aptis",
            "CVX-Identification"                    => "Aptis",
            "CVX-Idle-Limit"                        => "Aptis",
            "CVX-IPSVC-AZNLVL"                      => "Aptis",
            "CVX-IPSVC-Mask"                        => "Aptis",
            "CVX-Maximum-Channels"                  => "Aptis",
            "CVX-Modem-Begin-Modulation"            => "Aptis",
            "CVX-Modem-Begin-Recv-Line-Lvl"         => "Aptis",
            "CVX-Modem-Data-Compression"            => "Aptis",
            "CVX-Modem-End-Modulation"              => "Aptis",
            "CVX-Modem-End-Recv-Line-Lvl"           => "Aptis",
            "CVX-Modem-Error-Correction"            => "Aptis",
            "CVX-Modem-Local-Rate-Negs"             => "Aptis",
            "CVX-Modem-Local-Retrains"              => "Aptis",
            "CVX-Modem-Remote-Rate-Negs"            => "Aptis",
            "CVX-Modem-Remote-Retrains"             => "Aptis",
            "CVX-Modem-ReTx-Packets"                => "Aptis",
            "CVX-Modem-SNR"                         => "Aptis",
            "CVX-Modem-Tx-Packets"                  => "Aptis",
            "CVX-Multicast-Client"                  => "Aptis",
            "CVX-Multicast-Rate-Limit"              => "Aptis",
            "CVX-Multilink-Group-Number"            => "Aptis",
            "CVX-Multilink-Match-Info"              => "Aptis",
            "CVX-PPP-Address"                       => "Aptis",
            "CVX-PPP-Log-Mask"                      => "Aptis",
            "CVX-PreSession-Time"                   => "Aptis",
            "CVX-Primary-DNS"                       => "Aptis",
            "CVX-Radius-Redirect"                   => "Aptis",
            "CVX-Reject-Reason"                     => "Aptis",
            "CVX-Secondary-DNS"                     => "Aptis",
            "CVX-SS7-Session-ID-Type"               => "Aptis",
            "CVX-Terminate-Cause"                   => "Aptis",
            "CVX-Terminate-Component"               => "Aptis",
            "CVX-VPOP-ID"                           => "Aptis",
            "CVX-Xmit-Rate"                         => "Aptis",
            "CW-Account-Id"                         => "USR",
            "CW-Acct-Balance-Decr-Curr"             => "USR",
            "CW-Acct-Balance-Start-Amt"             => "USR",
            "CW-Acct-Balance-Start-Curr"            => "USR",
            "CW-Acct-Balance-Start-Dec"             => "USR",
            "CW-Acct-Identification-Code"           => "USR",
            "CW-Acct-Type"                          => "USR",
            "CW-ARQ-Token"                          => "USR",
            "CW-Audio-Bytes-In-Frame"               => "USR",
            "CW-Audio-Packets-In-Frame"             => "USR",
            "CW-Audio-Packets-Lost"                 => "USR",
            "CW-Audio-Packets-Received"             => "USR",
            "CW-Audio-Packets-Sent"                 => "USR",
            "CW-Audio-Signal-In-Packet"             => "USR",
            "CW-Authentication-Fail-Cnt"            => "USR",
            "CW-Call-Durn-Connect-Disc"             => "USR",
            "CW-Call-End-Time-Msec"                 => "USR",
            "CW-Call-End-Time-Sec"                  => "USR",
            "CW-Call-Identifier"                    => "USR",
            "CW-Call-Model"                         => "USR",
            "CW-Call-Plan-Id"                       => "USR",
            "CW-Call-Start-Ingr-GW-Msec"            => "USR",
            "CW-Call-Start-Ingr-GW-Sec"             => "USR",
            "CW-Call-Start-Time-Ans-Msec"           => "USR",
            "CW-Call-Start-Time-Ans-Sec"            => "USR",
            "CW-Call-Termination-Cause"             => "USR",
            "CW-Call-Type"                          => "USR",
            "CW-Cld-Party-E164-Number"              => "USR",
            "CW-Cld-Party-E164-Type"                => "USR",
            "CW-Cld-Party-Trans-DNS"                => "USR",
            "CW-Cld-Party-Trans-IP"                 => "USR",
            "CW-Cld-Party-Trans-Port"               => "USR",
            "CW-Cld-Party-Trans-Protocol"           => "USR",
            "CW-Clg-Party-E164-Number"              => "USR",
            "CW-Clg-Party-E164-Type"                => "USR",
            "CW-Clg-Party-Trans-DNS"                => "USR",
            "CW-Clg-Party-Trans-IP"                 => "USR",
            "CW-Clg-Party-Trans-Port"               => "USR",
            "CW-Clg-Party-Trans-Protocol"           => "USR",
            "CW-Codec-Type"                         => "USR",
            "CW-Egr-Gtkpr-Trans-DNS"                => "USR",
            "CW-Egr-Gtkpr-Trans-IP"                 => "USR",
            "CW-Egr-Gtkpr-Trans-Port"               => "USR",
            "CW-Egr-Gtkpr-Trans-Protocol"           => "USR",
            "CW-Egr-Gway-Trans-DNS"                 => "USR",
            "CW-Egr-Gway-Trans-IP"                  => "USR",
            "CW-Egr-Gway-Trans-Port"                => "USR",
            "CW-Egr-Gway-Trans-Protocol"            => "USR",
            "CW-Ingr-Gtkpr-Trans-DNS"               => "USR",
            "CW-Ingr-Gtkpr-Trans-IP"                => "USR",
            "CW-Ingr-Gtkpr-Trans-Port"              => "USR",
            "CW-Ingr-Gtkpr-Trans-Protocol"          => "USR",
            "CW-Ingr-Gway-E164-Number"              => "USR",
            "CW-Ingr-Gway-E164-Type"                => "USR",
            "CW-Ingr-Gway-Trans-DNS"                => "USR",
            "CW-Ingr-Gway-Trans-IP"                 => "USR",
            "CW-Ingr-Gway-Trans-Port"               => "USR",
            "CW-Ingr-Gway-Trans-Protocol"           => "USR",
            "CW-Local-MG-RTP-DNS"                   => "USR",
            "CW-Local-MG-RTP-IP"                    => "USR",
            "CW-Local-MG-RTP-Port"                  => "USR",
            "CW-Local-MG-RTP-Protocol"              => "USR",
            "CW-Local-Sig-Trans-DNS"                => "USR",
            "CW-Local-Sig-Trans-IP"                 => "USR",
            "CW-Local-Sig-Trans-Port"               => "USR",
            "CW-Local-Sig-Trans-Protocol"           => "USR",
            "CW-LRQ-Token"                          => "USR",
            "CW-MG-Id"                              => "USR",
            "CW-MGC-Id"                             => "USR",
            "CW-Num-Call-Attempt-Session"           => "USR",
            "CW-Orig-Line-Identifier"               => "USR",
            "CW-OSP-Source-Device"                  => "USR",
            "CW-Port-Id-For-Call"                   => "USR",
            "CW-Protocol-Transport"                 => "USR",
            "CW-PSTN-Interface-Number"              => "USR",
            "CW-Rate-Plan-Id"                       => "USR",
            "CW-Remote-MG-RTP-DNS"                  => "USR",
            "CW-Remote-MG-RTP-IP"                   => "USR",
            "CW-Remote-MG-RTP-Port"                 => "USR",
            "CW-Remote-MG-RTP-Protocol"             => "USR",
            "CW-Remote-Sig-Trans-DNS"               => "USR",
            "CW-Remote-Sig-Trans-IP"                => "USR",
            "CW-Remote-Sig-Trans-Port"              => "USR",
            "CW-Remote-Sig-Trans-Protocol"          => "USR",
            "CW-Service-Type"                       => "USR",
            "CW-Session-Id"                         => "USR",
            "CW-Session-Sequence-End"               => "USR",
            "CW-Session-Sequence-Num"               => "USR",
            "CW-Signaling-Protocol"                 => "USR",
            "CW-Slot-Id-For-Call"                   => "USR",
            "CW-Source-Identifier"                  => "USR",
            "CW-SS7-CIC"                            => "USR",
            "CW-SS7-Destn-Ptcode-Address"           => "USR",
            "CW-SS7-Destn-Ptcode-Type"              => "USR",
            "CW-SS7-Orig-Ptcode-Address"            => "USR",
            "CW-SS7-Orig-Ptcode-Type"               => "USR",
            "CW-Token-Status"                       => "USR",
            "CW-Trans-Cld-Party-E164-Num"           => "USR",
            "CW-Trans-Cld-Party-E164-Type"          => "USR",
            "CW-Version-Id"                         => "USR",
            "Deactivate-Service-Name"               => "Ericsson-AB",
            "Default-TTL"                           => "DANTE",
            "Delegated-Max-Prefix"                  => "Ericsson-AB",
            "DellEMC-AVpair"                        => "DellEMC",
            "DellEMC-Group-Name"                    => "DellEMC",
            "DHCP-Field"                            => "Ericsson-AB",
            "DHCP-Max-Leases"                       => "Ericsson-AB",
            "DHCP-Option"                           => "Ericsson-AB",
            "DHCP-Vendor-Class-ID"                  => "Ericsson-AB",
            "DHCP-Vendor-Encap-Option"              => "Ericsson-AB",
            "Dlink-1p-Priority"                     => "Dlink",
            "Dlink-ACL-Profile"                     => "Dlink",
            "Dlink-ACL-Rule"                        => "Dlink",
            "Dlink-ACL-Script"                      => "Dlink",
            "Dlink-Egress-Bandwidth-Assignment"     => "Dlink",
            "Dlink-Ingress-Bandwidth-Assignment"    => "Dlink",
            "Dlink-User-Level"                      => "Dlink",
            "Dlink-VLAN-ID"                         => "Dlink",
            "Dlink-VLAN-Name"                       => "Dlink",
            "Double-Authentication"                 => "Ericsson-AB",
            "DragonWave-Privilege-Level"            => "DragonWave",
            "DSL-Actual-Inter-Delay-Down"           => "Ericsson-AB",
            "DSL-Actual-Inter-Delay-Up"             => "Ericsson-AB",
            "DSL-Actual-Rate-Down"                  => "Ericsson-AB",
            "DSL-Actual-Rate-Down-Factor"           => "Ericsson-AB",
            "DSL-Actual-Rate-Up"                    => "Ericsson-AB",
            "DSL-Attainable-Rate-Down"              => "Ericsson-AB",
            "DSL-Attainable-Rate-Up"                => "Ericsson-AB",
            "DSL-Combined-Line-Info"                => "Ericsson-AB",
            "DSL-L2-Encapsulation"                  => "Ericsson-AB",
            "DSL-Line-State"                        => "Ericsson-AB",
            "DSL-Max-Inter-Delay-Down"              => "Ericsson-AB",
            "DSL-Max-Inter-Delay-Up"                => "Ericsson-AB",
            "DSL-Max-Rate-Down"                     => "Ericsson-AB",
            "DSL-Max-Rate-Up"                       => "Ericsson-AB",
            "DSL-Min-Low-Power-Rate-Down"           => "Ericsson-AB",
            "DSL-Min-Low-Power-Rate-Up"             => "Ericsson-AB",
            "DSL-Min-Rate-Down"                     => "Ericsson-AB",
            "DSL-Min-Rate-Up"                       => "Ericsson-AB",
            "DSL-PPPOA-PPPOE-Inter-Work-Flag"       => "Ericsson-AB",
            "DSL-Transmission-System"               => "Ericsson-AB",
            "dsp-id"                                => "Cisco",
            "Dynamic-Address-Flag"                  => "VerizonWireless",
            "Dynamic-Policy-Filter"                 => "Ericsson-AB",
            "Dynamic-QoS-Param"                     => "Ericsson-AB",
            "EAP-Channel-Binding-Message"           => "UKERNA",
            "Eduroam-Monitoring-Inflate"            => "TERENA",
            "Eduroam-SP-Country"                    => "TERENA",
            "EfficientIP-Admin-Group"               => "EfficientIP",
            "EfficientIP-Email"                     => "EfficientIP",
            "EfficientIP-Extra-Blob"                => "EfficientIP",
            "EfficientIP-First-Login-Path"          => "EfficientIP",
            "EfficientIP-First-Name"                => "EfficientIP",
            "EfficientIP-Groups"                    => "EfficientIP",
            "EfficientIP-Identity-Type"             => "EfficientIP",
            "EfficientIP-IP-Host"                   => "EfficientIP",
            "EfficientIP-Last-Name"                 => "EfficientIP",
            "EfficientIP-Maintainer-Group"          => "EfficientIP",
            "EfficientIP-Pseudonym"                 => "EfficientIP",
            "EfficientIP-Service-Class"             => "EfficientIP",
            "EfficientIP-Version"                   => "EfficientIP",
            "Eltex-AVPair"                          => "Eltex",
            "Eltex-Disconnect-Code-Local"           => "Eltex",
            "Epygi-AccessType"                      => "Epygi",
            "Epygi-AVPair"                          => "Epygi",
            "Epygi-CallDisconnectReason"            => "Epygi",
            "Epygi-CalledPartyNumber"               => "Epygi",
            "Epygi-CallInfo"                        => "Epygi",
            "Epygi-CallingPartyNumber"              => "Epygi",
            "Epygi-CallRedirectReason"              => "Epygi",
            "Epygi-CallType"                        => "Epygi",
            "Epygi-DateTimeConnect"                 => "Epygi",
            "Epygi-DateTimeDisconnect"              => "Epygi",
            "Epygi-DateTimeOrigination"             => "Epygi",
            "Epygi-DestIpAddr"                      => "Epygi",
            "Epygi-DestIpPort"                      => "Epygi",
            "Epygi-DeviceName"                      => "Epygi",
            "Epygi-Duration"                        => "Epygi",
            "Epygi-FiadID"                          => "Epygi",
            "Epygi-h323-billing-model"              => "Epygi",
            "Epygi-h323-call-origin"                => "Epygi",
            "Epygi-h323-call-type"                  => "Epygi",
            "Epygi-h323-conf-id"                    => "Epygi",
            "Epygi-h323-connect-time"               => "Epygi",
            "Epygi-h323-credit-amount"              => "Epygi",
            "Epygi-h323-credit-time"                => "Epygi",
            "Epygi-h323-currency"                   => "Epygi",
            "Epygi-h323-disconnect-cause"           => "Epygi",
            "Epygi-h323-disconnect-time"            => "Epygi",
            "Epygi-h323-gw-id"                      => "Epygi",
            "Epygi-h323-incoming-conf-id"           => "Epygi",
            "Epygi-h323-preferred-lang"             => "Epygi",
            "Epygi-h323-prompt-id"                  => "Epygi",
            "Epygi-h323-redirect-ip-address"        => "Epygi",
            "Epygi-h323-redirect-number"            => "Epygi",
            "Epygi-h323-remote-address"             => "Epygi",
            "Epygi-h323-return-code"                => "Epygi",
            "Epygi-h323-setup-time"                 => "Epygi",
            "Epygi-h323-time-and-day"               => "Epygi",
            "Epygi-h323-voice-quality"              => "Epygi",
            "Epygi-InDestRTP_IP"                    => "Epygi",
            "Epygi-InDestRTP_port"                  => "Epygi",
            "Epygi-InRTP_Jitter"                    => "Epygi",
            "Epygi-InRTP_Latency"                   => "Epygi",
            "Epygi-InRTP_Octets"                    => "Epygi",
            "Epygi-InRTP_Packets"                   => "Epygi",
            "Epygi-InRTP_PacketsDupl"               => "Epygi",
            "Epygi-InRTP_PacketSize"                => "Epygi",
            "Epygi-InRTP_PacketsLost"               => "Epygi",
            "Epygi-InRTP_Payload"                   => "Epygi",
            "Epygi-InSourceRTP_IP"                  => "Epygi",
            "Epygi-InSourceRTP_port"                => "Epygi",
            "Epygi-InterfaceName"                   => "Epygi",
            "Epygi-InterfaceNumber"                 => "Epygi",
            "Epygi-NAS-Port"                        => "Epygi",
            "Epygi-OrigCallID"                      => "Epygi",
            "Epygi-OrigIpAddr"                      => "Epygi",
            "Epygi-OrigIpPort"                      => "Epygi",
            "Epygi-OutDestRTP_IP"                   => "Epygi",
            "Epygi-OutDestRTP_port"                 => "Epygi",
            "Epygi-OutRTP_Octets"                   => "Epygi",
            "Epygi-OutRTP_Packets"                  => "Epygi",
            "Epygi-OutRTP_PacketSize"               => "Epygi",
            "Epygi-OutRTP_Payload"                  => "Epygi",
            "Epygi-OutSourceRTP_IP"                 => "Epygi",
            "Epygi-OutSourceRTP_port"               => "Epygi",
            "Epygi-ParentCallID"                    => "Epygi",
            "Epygi-PortID"                          => "Epygi",
            "Epygi-RegExpDate"                      => "Epygi",
            "Epygi-TimeslotNumber"                  => "Epygi",
            "Equallogic-Admin-Account-Type"         => "Equallogic",
            "Equallogic-Admin-Email"                => "Equallogic",
            "Equallogic-Admin-Full-Name"            => "Equallogic",
            "Equallogic-Admin-Mobile"               => "Equallogic",
            "Equallogic-Admin-Phone"                => "Equallogic",
            "Equallogic-Admin-Pool-Access"          => "Equallogic",
            "Equallogic-Admin-Repl-Site-Access"     => "Equallogic",
            "Equallogic-EQL-Admin-Privilege"        => "Equallogic",
            "Equallogic-Poll-Interval"              => "Equallogic",
            "Ericsson-ViG-Access-Agent-IP-Address"  => "Ericsson",
            "Ericsson-ViG-Access-Agent-name"        => "Ericsson",
            "Ericsson-ViG-Access-Group-name"        => "Ericsson",
            "Ericsson-ViG-Access-type"              => "Ericsson",
            "Ericsson-ViG-Account-error-reason"     => "Ericsson",
            "Ericsson-ViG-Alive-Indicator"          => "Ericsson",
            "Ericsson-ViG-Allowed-bandwidth"        => "Ericsson",
            "Ericsson-ViG-Auth-DataRequest"         => "Ericsson",
            "Ericsson-ViG-Authentication-type"      => "Ericsson",
            "Ericsson-ViG-Balance"                  => "Ericsson",
            "Ericsson-ViG-Business-Agreement-Name"  => "Ericsson",
            "Ericsson-ViG-Call-Role"                => "Ericsson",
            "Ericsson-ViG-Called-ID"                => "Ericsson",
            "Ericsson-ViG-Called-Usr-Group-ID"      => "Ericsson",
            "Ericsson-ViG-Called-Usr-Sub-Group-ID"  => "Ericsson",
            "Ericsson-ViG-Calling-e164-number"      => "Ericsson",
            "Ericsson-ViG-Calling-Email-address"    => "Ericsson",
            "Ericsson-ViG-Calling-H323Id"           => "Ericsson",
            "Ericsson-ViG-Calling-ID"               => "Ericsson",
            "Ericsson-ViG-Calling-User-Group-ID"    => "Ericsson",
            "Ericsson-ViG-Calling-Usr-Sub-Group-ID" => "Ericsson",
            "Ericsson-ViG-Charging-Case"            => "Ericsson",
            "Ericsson-ViG-Codec"                    => "Ericsson",
            "Ericsson-ViG-CPN-digits"               => "Ericsson",
            "Ericsson-ViG-CPN-NP"                   => "Ericsson",
            "Ericsson-ViG-CPN-PI"                   => "Ericsson",
            "Ericsson-ViG-CPN-SI"                   => "Ericsson",
            "Ericsson-ViG-CPN-TON"                  => "Ericsson",
            "Ericsson-ViG-Currency"                 => "Ericsson",
            "Ericsson-ViG-Currency-Quote"           => "Ericsson",
            "Ericsson-ViG-Data-media-rec-backward"  => "Ericsson",
            "Ericsson-ViG-Data-media-rec-forward"   => "Ericsson",
            "Ericsson-ViG-Dialled-e164-number"      => "Ericsson",
            "Ericsson-ViG-Dialled-Email-address"    => "Ericsson",
            "Ericsson-ViG-Dialled-H323Id"           => "Ericsson",
            "Ericsson-ViG-Dialled-num-digits"       => "Ericsson",
            "Ericsson-ViG-Dialled-num-NP"           => "Ericsson",
            "Ericsson-ViG-Dialled-num-TON"          => "Ericsson",
            "Ericsson-ViG-Digest-Attributes"        => "Ericsson",
            "Ericsson-ViG-Digest-Response"          => "Ericsson",
            "Ericsson-ViG-Emergency-Call-Indicator" => "Ericsson",
            "Ericsson-ViG-Endpoint-Type"            => "Ericsson",
            "Ericsson-ViG-Fax-media-rec-backward"   => "Ericsson",
            "Ericsson-ViG-Fax-media-rec-forward"    => "Ericsson",
            "Ericsson-ViG-Global-unique-call-ID"    => "Ericsson",
            "Ericsson-ViG-Global-unique-service-ID" => "Ericsson",
            "Ericsson-ViG-Interim-interval"         => "Ericsson",
            "Ericsson-ViG-Internal-Rel-reason-orig" => "Ericsson",
            "Ericsson-ViG-Internal-Rel-reason-val"  => "Ericsson",
            "Ericsson-ViG-IPT-Time-Stamp"           => "Ericsson",
            "Ericsson-ViG-Layer-identity"           => "Ericsson",
            "Ericsson-ViG-Major-protocol-version"   => "Ericsson",
            "Ericsson-ViG-Media-channel-count"      => "Ericsson",
            "Ericsson-ViG-Minor-protocol-version"   => "Ericsson",
            "Ericsson-ViG-Proxy-IP-Address"         => "Ericsson",
            "Ericsson-ViG-QoS-Class"                => "Ericsson",
            "Ericsson-ViG-Re-selection-counter"     => "Ericsson",
            "Ericsson-ViG-Redirecting-num-digits"   => "Ericsson",
            "Ericsson-ViG-Redirecting-num-NP"       => "Ericsson",
            "Ericsson-ViG-Redirecting-num-PI"       => "Ericsson",
            "Ericsson-ViG-Redirecting-num-RFD"      => "Ericsson",
            "Ericsson-ViG-Redirecting-num-TON"      => "Ericsson",
            "Ericsson-ViG-Rel-cause-class"          => "Ericsson",
            "Ericsson-ViG-Rel-cause-coding-std"     => "Ericsson",
            "Ericsson-ViG-Rel-cause-location"       => "Ericsson",
            "Ericsson-ViG-Rel-cause-value"          => "Ericsson",
            "Ericsson-ViG-Rel-reason"               => "Ericsson",
            "Ericsson-ViG-Remote-SK-UA-IP-Address"  => "Ericsson",
            "Ericsson-ViG-Requested-bandwidth"      => "Ericsson",
            "Ericsson-ViG-Routed-e164-number"       => "Ericsson",
            "Ericsson-ViG-Routed-Email-address"     => "Ericsson",
            "Ericsson-ViG-Routed-H323Id"            => "Ericsson",
            "Ericsson-ViG-Routing-num-digits"       => "Ericsson",
            "Ericsson-ViG-Routing-num-NP"           => "Ericsson",
            "Ericsson-ViG-Routing-num-TON"          => "Ericsson",
            "Ericsson-ViG-Routing-tariff"           => "Ericsson",
            "Ericsson-ViG-SA-IP-address"            => "Ericsson",
            "Ericsson-ViG-Sequence-Number"          => "Ericsson",
            "Ericsson-ViG-Service-Description"      => "Ericsson",
            "Ericsson-ViG-Service-Duration"         => "Ericsson",
            "Ericsson-ViG-Service-Exe-Rslt-Desc"    => "Ericsson",
            "Ericsson-ViG-Service-Execution-Result" => "Ericsson",
            "Ericsson-ViG-Service-ID"               => "Ericsson",
            "Ericsson-ViG-Service-Name"             => "Ericsson",
            "Ericsson-ViG-Service-Specific-Info"    => "Ericsson",
            "Ericsson-ViG-Session-ringing-duration" => "Ericsson",
            "Ericsson-ViG-Session-routing-duration" => "Ericsson",
            "Ericsson-ViG-Site"                     => "Ericsson",
            "Ericsson-ViG-SiteKeeper-name"          => "Ericsson",
            "Ericsson-ViG-SK-IP-address"            => "Ericsson",
            "Ericsson-ViG-Terminal-Type"            => "Ericsson",
            "Ericsson-ViG-Test-Call-Indicator"      => "Ericsson",
            "Ericsson-ViG-Time-stamp-DST"           => "Ericsson",
            "Ericsson-ViG-Time-stamp-TZ"            => "Ericsson",
            "Ericsson-ViG-Time-stamp-UTC"           => "Ericsson",
            "Ericsson-ViG-Translated-ID"            => "Ericsson",
            "Ericsson-ViG-Trusted-access"           => "Ericsson",
            "Ericsson-ViG-TTL-Absolute"             => "Ericsson",
            "Ericsson-ViG-TTL-relative"             => "Ericsson",
            "Ericsson-ViG-TTL-Start-Event"          => "Ericsson",
            "Ericsson-ViG-UA-IP-address"            => "Ericsson",
            "Ericsson-ViG-User-agent-group-name"    => "Ericsson",
            "Ericsson-ViG-User-agent-name"          => "Ericsson",
            "Ericsson-ViG-User-ID"                  => "Ericsson",
            "Ericsson-ViG-User-name"                => "Ericsson",
            "Ericsson-ViG-User-Name-Info"           => "Ericsson",
            "Ericsson-ViG-Video-media-rec-backward" => "Ericsson",
            "Ericsson-ViG-Video-media-rec-forward"  => "Ericsson",
            "Ericsson-ViG-Voice-media-rec-backward" => "Ericsson",
            "Ericsson-ViG-Voice-media-rec-forward"  => "Ericsson",
            "ERX-Acc-Aggr-Cir-Id-Asc"               => "ERX",
            "ERX-Acc-Aggr-Cir-Id-Bin"               => "ERX",
            "ERX-Acc-Loop-Cir-Id"                   => "ERX",
            "ERX-Acc-Loop-Encap"                    => "ERX",
            "ERX-Acc-Loop-Remote-Id"                => "ERX",
            "ERX-Acct-Request-Reason"               => "ERX",
            "ERX-Act-Data-Rate-Dn"                  => "ERX",
            "ERX-Act-Data-Rate-Up"                  => "ERX",
            "ERX-Act-Interlv-Delay-Dn"              => "ERX",
            "ERX-Act-Interlv-Delay-Up"              => "ERX",
            "ERX-Action-Reason"                     => "ERX",
            "ERX-Address-Pool-Name"                 => "ERX",
            "ERX-Adv-Pcef-Profile-Name"             => "ERX",
            "ERX-Adv-Pcef-Rule-Name"                => "ERX",
            "ERX-Alternate-Cli-Access-Level"        => "ERX",
            "ERX-Alternate-Cli-Vrouter-Name"        => "ERX",
            "ERX-APN-Name"                          => "ERX",
            "ERX-Atm-MBS"                           => "ERX",
            "ERX-Atm-PCR"                           => "ERX",
            "ERX-Atm-SCR"                           => "ERX",
            "ERX-Atm-Service-Category"              => "ERX",
            "ERX-Att-Data-Rate-Dn"                  => "ERX",
            "ERX-Att-Data-Rate-Up"                  => "ERX",
            "ERX-Attainable-Expected-Throughput-Downstream"  => "ERX",
            "ERX-Attainable-Expected-Throughput-Upstream"    => "ERX",
            "ERX-Attainable-Gamma-Data-Rate-Downstream"      => "ERX",
            "ERX-Attainable-Gamma-Data-Rate-Upstream"        => "ERX",
            "ERX-Backup-Address-Pool"                        => "ERX",
            "ERX-Bearer-Type"                                => "ERX",
            "ERX-Bulk-CoA-Identifier"                        => "ERX",
            "ERX-Bulk-CoA-Transaction-Id"                    => "ERX",
            "ERX-Cli-Allow-All-VR-Access"                    => "ERX",
            "ERX-Cli-Initial-Access-Level"                   => "ERX",
            "ERX-Client-Profile-Name"                        => "ERX",
            "ERX-Core-Facing-Interface"                      => "ERX",
            "ERX-CoS-Scheduler-Pmt-Type"                     => "ERX",
            "ERX-CoS-Shaping-Pmt-Type"                       => "ERX",
            "ERX-Cos-Shaping-Rate"                           => "ERX",
            "ERX-DF-Bit"                                     => "ERX",
            "ERX-DHCP-First-Relay-IPv4-Address"              => "ERX",
            "ERX-DHCP-First-Relay-IPv6-Address"              => "ERX",
            "ERX-Dhcp-Gi-Address"                            => "ERX",
            "ERX-DHCP-Guided-Relay-Server"                   => "ERX",
            "ERX-DHCP-Header"                                => "ERX",
            "ERX-Dhcp-Mac-Addr"                              => "ERX",
            "ERX-Dhcp-Option-82"                             => "ERX",
            "ERX-Dhcp-Options"                               => "ERX",
            "ERX-DHCPv6-Guided-Relay-Server"                 => "ERX",
            "ERX-DHCPv6-Header"                              => "ERX",
            "ERX-DHCPv6-Options"                             => "ERX",
            "ERX-Dial-Out-Number"                            => "ERX",
            "ERX-DownStream-Calc-Rate"                       => "ERX",
            "ERX-DSL-Line-State"                             => "ERX",
            "ERX-DSL-Type"                                   => "ERX",
            "ERX-Egress-Policy-Name"                         => "ERX",
            "ERX-Egress-Statistics"                          => "ERX",
            "ERX-Expected-Throughput-Downstream"             => "ERX",
            "ERX-Expected-Throughput-Upstream"               => "ERX",
            "ERX-Framed-Ip-Route-Tag"                        => "ERX",
            "ERX-Gamma-Data-Rate-Downstream"                 => "ERX",
            "ERX-Gamma-Data-Rate-Upstream"                   => "ERX",
            "ERX-Hybrid-Access-DSL-Downstream-Speed"         => "ERX",
            "ERX-Hybrid-Access-LTE-Downstream-Speed"         => "ERX",
            "ERX-ICR-Partition-Id"                           => "ERX",
            "ERX-IGMP-Access-Name"                           => "ERX",
            "ERX-IGMP-Access-Src-Name"                       => "ERX",
            "ERX-Igmp-Enable"                                => "ERX",
            "ERX-IGMP-Explicit-Tracking"                     => "ERX",
            "ERX-IGMP-Immediate-Leave"                       => "ERX",
            "ERX-IGMP-Max-Resp-Time"                         => "ERX",
            "ERX-IGMP-No-Tracking-V2-Grps"                   => "ERX",
            "ERX-IGMP-OIF-Map-Name"                          => "ERX",
            "ERX-IGMP-Query-Interval"                        => "ERX",
            "ERX-IGMP-Version"                               => "ERX",
            "ERX-Ingress-Policy-Name"                        => "ERX",
            "ERX-Ingress-Statistics"                         => "ERX",
            "ERX-Inner-Tag-Protocol-Id"                      => "ERX",
            "ERX-Inner-Vlan-Map-Id"                          => "ERX",
            "ERX-Input-Gigapkts"                             => "ERX",
            "ERX-Input-Interface-Filter"                     => "ERX",
            "ERX-Interface-Desc"                             => "ERX",
            "ERX-Interface-Set-Targeting-Weight"             => "ERX",
            "ERX-Interface-Targeting-Weight"                 => "ERX",
            "ERX-IP-Block-Multicast"                         => "ERX",
            "ERX-IP-Mcast-Adm-Bw-Limit"                      => "ERX",
            "ERX-IPv4-Input-Service-Filter"                  => "ERX",
            "ERX-IPv4-Input-Service-Set"                     => "ERX",
            "ERX-IPv4-Output-Service-Filter"                 => "ERX",
            "ERX-IPv4-Output-Service-Set"                    => "ERX",
            "ERX-IPv6-Acct-Input-Gigawords"                  => "ERX",
            "ERX-IPv6-Acct-Input-Octets"                     => "ERX",
            "ERX-IPv6-Acct-Input-Packets"                    => "ERX",
            "ERX-IPv6-Acct-Output-Gigawords"                 => "ERX",
            "ERX-IPv6-Acct-Output-Octets"                    => "ERX",
            "ERX-IPv6-Acct-Output-Packets"                   => "ERX",
            "ERX-IPv6-Delegated-Pool-Name"                   => "ERX",
            "ERX-IPv6-Egress-Policy-Name"                    => "ERX",
            "ERX-IPv6-Ingress-Policy-Name"                   => "ERX",
            "ERX-IPv6-Input-Service-Filter"                  => "ERX",
            "ERX-IPv6-Input-Service-Set"                     => "ERX",
            "ERX-IpV6-Local-Interface"                       => "ERX",
            "ERX-IPv6-Mcast-Adm-Bw-Limit"                    => "ERX",
            "ERX-IPv6-NdRa-Pool-Name"                        => "ERX",
            "ERX-IPv6-NdRa-Prefix"                           => "ERX",
            "ERX-IPv6-Output-Service-Filter"                 => "ERX",
            "ERX-IPv6-Output-Service-Set"                    => "ERX",
            "ERX-Ipv6-Primary-Dns"                           => "ERX",
            "ERX-Ipv6-Secondary-Dns"                         => "ERX",
            "ERX-IpV6-Virtual-Router"                        => "ERX",
            "ERX-L2c-Down-Stream-Data"                       => "ERX",
            "ERX-L2c-Up-Stream-Data"                         => "ERX",
            "ERX-L2tp-Recv-Window-Size"                      => "ERX",
            "ERX-L2TP-Resynch-Method"                        => "ERX",
            "ERX-LI-Action"                                  => "ERX",
            "ERX-Local-Loopback-Interface"                   => "ERX",
            "ERX-Max-Clients-Per-Interface"                  => "ERX",
            "ERX-Max-Data-Rate-Dn"                           => "ERX",
            "ERX-Max-Data-Rate-Up"                           => "ERX",
            "ERX-Max-Interlv-Delay-Dn"                       => "ERX",
            "ERX-Max-Interlv-Delay-Up"                       => "ERX",
            "ERX-Maximum-BPS"                                => "ERX",
            "ERX-Med-Dev-Handle"                             => "ERX",
            "ERX-Med-Ip-Address"                             => "ERX",
            "ERX-Med-Port-Number"                            => "ERX",
            "ERX-Min-Data-Rate-Dn"                           => "ERX",
            "ERX-Min-Data-Rate-Up"                           => "ERX",
            "ERX-Min-LP-Data-Rate-Dn"                        => "ERX",
            "ERX-Min-LP-Data-Rate-Up"                        => "ERX",
            "ERX-Minimum-BPS"                                => "ERX",
            "ERX-MLD-Access-Name"                            => "ERX",
            "ERX-MLD-Access-Src-Name"                        => "ERX",
            "ERX-MLD-Explicit-Tracking"                      => "ERX",
            "ERX-MLD-Immediate-Leave"                        => "ERX",
            "ERX-MLD-Max-Resp-Time"                          => "ERX",
            "ERX-MLD-No-Tracking-V1-Grps"                    => "ERX",
            "ERX-MLD-OIF-Map-Name"                           => "ERX",
            "ERX-MLD-Query-Interval"                         => "ERX",
            "ERX-MLD-Version"                                => "ERX",
            "ERX-MLPPP-Bundle-Name"                          => "ERX",
            "ERX-Mobile-IP-Access-Control"                   => "ERX",
            "ERX-Mobile-IP-Algorithm"                        => "ERX",
            "ERX-Mobile-IP-Key"                              => "ERX",
            "ERX-Mobile-IP-Lifetime"                         => "ERX",
            "ERX-Mobile-IP-Replay"                           => "ERX",
            "ERX-Mobile-IP-SPI"                              => "ERX",
            "ERX-ONT-ONU-Assured-Data-Rate-Upstream"         => "ERX",
            "ERX-ONT-ONU-Average-Data-Rate-Downstream"       => "ERX",
            "ERX-ONT-ONU-Maximum-Data-Rate-Upstream"         => "ERX",
            "ERX-ONT-ONU-Peak-Data-Rate-Downstream"          => "ERX",
            "ERX-Output-Gigapkts"                            => "ERX",
            "ERX-Output-Interface-Filter"                    => "ERX",
            "ERX-Pim-Enable"                                 => "ERX",
            "ERX-PON-Access-Type"                            => "ERX",
            "ERX-PON-Tree-Maximum-Data-Rate-Downstream"      => "ERX",
            "ERX-PON-Tree-Maximum-Data-Rate-Upstream"        => "ERX",
            "ERX-PPP-Auth-Protocol"                          => "ERX",
            "ERX-PPP-Monitor-Ingress-Only"                   => "ERX",
            "ERX-PPP-Password"                               => "ERX",
            "ERX-PPP-Username"                               => "ERX",
            "ERX-Pppoe-Description"                          => "ERX",
            "ERX-Pppoe-Max-Sessions"                         => "ERX",
            "ERX-PppoE-Padn"                                 => "ERX",
            "ERX-Pppoe-Url"                                  => "ERX",
            "ERX-Primary-Dns"                                => "ERX",
            "ERX-Primary-Wins"                               => "ERX",
            "ERX-Qos-Parameters"                             => "ERX",
            "ERX-Qos-Profile-Interface-Type"                 => "ERX",
            "ERX-Qos-Profile-Name"                           => "ERX",
            "ERX-Qos-Set-Name"                               => "ERX",
            "ERX-Radius-Client-Address"                      => "ERX",
            "ERX-Re-Authentication-Catalyst"                 => "ERX",
            "ERX-Redirect-GW-Address"                        => "ERX",
            "ERX-Redirect-VR-Name"                           => "ERX",
            "ERX-Routing-Services"                           => "ERX",
            "ERX-Rx-Connect-Speed"                           => "ERX",
            "ERX-Sa-Validate"                                => "ERX",
            "ERX-Secondary-Dns"                              => "ERX",
            "ERX-Secondary-Wins"                             => "ERX",
            "ERX-Service-Acct-Interval"                      => "ERX",
            "ERX-Service-Activate"                           => "ERX",
            "ERX-Service-Activate-Type"                      => "ERX",
            "ERX-Service-Bundle"                             => "ERX",
            "ERX-Service-Deactivate"                         => "ERX",
            "ERX-Service-Description"                        => "ERX",
            "ERX-Service-Session"                            => "ERX",
            "ERX-Service-Statistics"                         => "ERX",
            "ERX-Service-Timeout"                            => "ERX",
            "ERX-Service-Volume"                             => "ERX",
            "ERX-Service-Volume-Gigawords"                   => "ERX",
            "ERX-Tunnel-Group"                               => "ERX",
            "ERX-Tunnel-Interface-Id"                        => "ERX",
            "ERX-Tunnel-Maximum-Sessions"                    => "ERX",
            "ERX-Tunnel-Nas-Port-Method"                     => "ERX",
            "ERX-Tunnel-Password"                            => "ERX",
            "ERX-Tunnel-Switch-Profile"                      => "ERX",
            "ERX-Tunnel-Tos"                                 => "ERX",
            "ERX-Tunnel-Tx-Speed-Method"                     => "ERX",
            "ERX-Tunnel-Virtual-Router"                      => "ERX",
            "ERX-Tx-Connect-Speed"                           => "ERX",
            "ERX-Update-Service"                             => "ERX",
            "ERX-UpStream-Calc-Rate"                         => "ERX",
            "ERX-Virtual-Router-Name"                        => "ERX",
            "ERX-Vlan-Map-Id"                                => "ERX",
            "Extreme-Auth-Source"                            => "Aerohive",
            "Extreme-AVPair"                                 => "Aerohive",
            "Extreme-CLI-Authorization"                      => "Extreme",
            "Extreme-Client-Monitor-Problem"                 => "Aerohive",
            "Extreme-Client-Monitor-Session"                 => "Aerohive",
            "Extreme-Data-Usage-Limit"                       => "Aerohive",
            "Extreme-Daylight-Saving-Offset"                 => "Aerohive",
            "Extreme-IDM-Message"                            => "Aerohive",
            "Extreme-IDM-Redirect-URL"                       => "Aerohive",
            "Extreme-Libsip-Action"                          => "Aerohive",
            "Extreme-Libsip-Additional-Message"              => "Aerohive",
            "Extreme-Libsip-Patron-Info"                     => "Aerohive",
            "Extreme-MGT-MAC-Address"                        => "Aerohive",
            "Extreme-Netlogin-Extended-Vlan"                 => "Extreme",
            "Extreme-Netlogin-Only"                          => "Extreme",
            "Extreme-Netlogin-Url"                           => "Extreme",
            "Extreme-Netlogin-Url-Desc"                      => "Extreme",
            "Extreme-Netlogin-Vlan"                          => "Extreme",
            "Extreme-Netlogin-Vlan-Tag"                      => "Extreme",
            "Extreme-NT-Identity"                            => "Aerohive",
            "Extreme-PPSK-PMK"                               => "Aerohive",
            "Extreme-PPSK-Request"                           => "Aerohive",
            "Extreme-Radius-Code"                            => "Aerohive",
            "Extreme-Security-Profile"                       => "Extreme",
            "Extreme-Shell-Command"                          => "Extreme",
            "Extreme-Time-Zone-Offset"                       => "Aerohive",
            "Extreme-User-Language"                          => "Aerohive",
            "Extreme-User-Location"                          => "Extreme",
            "Extreme-User-Profile-Attribute"                 => "Aerohive",
            "Extreme-User-Vlan"                              => "Aerohive",
            "Extreme-VM-IP-Addr"                             => "Extreme",
            "Extreme-VM-Name"                                => "Extreme",
            "Extreme-VM-VLAN-ID"                             => "Extreme",
            "Extreme-VM-VPP-Name"                            => "Extreme",
            "Extreme-VM-VR-Name"                             => "Extreme",
            "F5-LTM-Audit-Msg"                               => "F5",
            "F5-LTM-User-Console"                            => "F5",
            "F5-LTM-User-Context-1"                          => "F5",
            "F5-LTM-User-Context-2"                          => "F5",
            "F5-LTM-User-Info-1"                             => "F5",
            "F5-LTM-User-Info-2"                             => "F5",
            "F5-LTM-User-Partition"                          => "F5",
            "F5-LTM-User-Role"                               => "F5",
            "F5-LTM-User-Role-Universal"                     => "F5",
            "F5-LTM-User-Shell"                              => "F5",
            "Fabric-Attach-Client-Id"                        => "Nortel",
            "Fabric-Attach-Client-PSK"                       => "Nortel",
            "Fabric-Attach-Client-Trust"                     => "Nortel",
            "Fabric-Attach-Client-Trusted-Binding"           => "Nortel",
            "Fabric-Attach-Client-Type"                      => "Nortel",
            "Fabric-Attach-Service-Request"                  => "Nortel",
            "Fabric-Attach-Switch-Mode"                      => "Nortel",
            "Fabric-Attach-VLAN-Create"                      => "Nortel",
            "Fabric-Attach-VLAN-ISID"                        => "Nortel",
            "Fabric-Attach-VLAN-PVID"                        => "Nortel",
            "fdXtended-Bandwidth-Down"                       => "fdXtended",
            "fdXtended-Bandwidth-Up"                         => "fdXtended",
            "fdXtended-BytesDown"                            => "fdXtended",
            "fdXtended-BytesUp"                              => "fdXtended",
            "fdXtended-ContentFilter"                        => "fdXtended",
            "fdXtended-Expiration"                           => "fdXtended",
            "fdXtended-NetworkPolicy"                        => "fdXtended",
            "fdXtended-One2onenat-IP"                        => "fdXtended",
            "fdXtended-PostAuthURL"                          => "fdXtended",
            "fdXtended-SessionTimeout"                       => "fdXtended",
            "fdXtended-Wan-Interface"                        => "fdXtended",
            "Flow-FAC-Profile"                               => "Ericsson-AB",
            "Flow-IP-Profile"                                => "Ericsson-AB",
            "Force10-AVPair"                                 => "Force10",
            "Fortinet-Access-Profile"                        => "Fortinet",
            "Fortinet-AP-Name"                               => "Fortinet",
            "Fortinet-AppCtrl-Category-Allow"                => "Fortinet",
            "Fortinet-AppCtrl-Category-Block"                => "Fortinet",
            "Fortinet-AppCtrl-Risk-Allow"                    => "Fortinet",
            "Fortinet-AppCtrl-Risk-Block"                    => "Fortinet",
            "Fortinet-Client-IP-Address"                     => "Fortinet",
            "Fortinet-Client-IPv6-Address"                   => "Fortinet",
            "Fortinet-FAC-Auth-Status"                       => "Fortinet",
            "Fortinet-FAC-Challenge-Code"                    => "Fortinet",
            "Fortinet-FAC-Token-ID"                          => "Fortinet",
            "Fortinet-FDD-Access-Profile"                    => "Fortinet",
            "Fortinet-FDD-Allow-API-Access"                  => "Fortinet",
            "Fortinet-FDD-Is-SPP-Admin"                      => "Fortinet",
            "Fortinet-FDD-Is-System-Admin"                   => "Fortinet",
            "Fortinet-FDD-SPP-Name"                          => "Fortinet",
            "Fortinet-FDD-SPP-Policy-Group"                  => "Fortinet",
            "Fortinet-FDD-Trusted-Hosts"                     => "Fortinet",
            "Fortinet-FortiWAN-AVPair"                       => "Fortinet",
            "Fortinet-Fpc-User-Role"                         => "Fortinet",
            "Fortinet-Group-Name"                            => "Fortinet",
            "Fortinet-Host-Port-AVPair"                      => "Fortinet",
            "Fortinet-Interface-Name"                        => "Fortinet",
            "Fortinet-SSID"                                  => "Fortinet",
            "Fortinet-Tenant-Identification"                 => "Fortinet",
            "Fortinet-Vdom-Name"                             => "Fortinet",
            "Fortinet-Webfilter-Category-Allow"              => "Fortinet",
            "Fortinet-Webfilter-Category-Block"              => "Fortinet",
            "Fortinet-Webfilter-Category-Monitor"            => "Fortinet",
            "Fortinet-WirelessController-Assoc-Time"         => "Fortinet",
            "Fortinet-WirelessController-Device-MAC"         => "Fortinet",
            "Fortinet-WirelessController-WTP-ID"             => "Fortinet",
            "Forward-Policy"                                 => "Ericsson-AB",
            "Foundry-802.1x-Valid-Lookup"                    => "Foundry",
            "Foundry-Access-List"                            => "Foundry",
            "Foundry-COA-Command"                            => "Foundry",
            "Foundry-Command-Exception-Flag"                 => "Foundry",
            "Foundry-Command-String"                         => "Foundry",
            "Foundry-INM-Privilege"                          => "Foundry",
            "Foundry-INM-Role-Aor-List"                      => "Foundry",
            "Foundry-MAC-Authent-needs-802.1x"               => "Foundry",
            "Foundry-MAC-Based-Vlan-QoS"                     => "Foundry",
            "Foundry-Privilege-Level"                        => "Foundry",
            "Foundry-SI-Context-Role"                        => "Foundry",
            "Foundry-SI-Role-Template"                       => "Foundry",
            "Foundry-Voice-Phone-Config"                     => "Foundry",
            "FreeRADIUS-802.1X-Anonce"                       => "FreeRADIUS",
            "FreeRADIUS-802.1X-EAPoL-Key-Msg"                => "FreeRADIUS",
            "FreeRADIUS-Acct-Session-Start-Time"             => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Crypto-Binding"             => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-EAP-Payload"                => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Error"                      => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Intermediate-Result"        => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-NAK"                        => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC"                        => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-A-ID"                   => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-A-ID-Info"              => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Acknowledge"            => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-I-ID"                   => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-A-ID"              => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-A-ID-Info"         => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-I-ID"              => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-PAC-Lifetime"      => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-PAC-Type"          => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Info-TLV"               => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Key"                    => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Lifetime"               => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Opaque-I-ID"            => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Opaque-PAC-Key"         => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Opaque-PAC-Lifetime"    => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Opaque-PAC-Type"        => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Opaque-TLV"             => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PAC-Type"                   => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-PKCS"                       => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Request-Action"             => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Result"                     => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-TLV"                        => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Trusted-Root"               => "FreeRADIUS",
            "FreeRADIUS-EAP-FAST-Vendor-Specific"            => "FreeRADIUS",
            "FreeRADIUS-Proxied-To"                          => "FreeRADIUS",
            "FreeRADIUS-Queue-Len-Acct"                      => "FreeRADIUS",
            "FreeRADIUS-Queue-Len-Auth"                      => "FreeRADIUS",
            "FreeRADIUS-Queue-Len-Detail"                    => "FreeRADIUS",
            "FreeRADIUS-Queue-Len-Internal"                  => "FreeRADIUS",
            "FreeRADIUS-Queue-Len-Proxy"                     => "FreeRADIUS",
            "FreeRADIUS-Queue-PPS-In"                        => "FreeRADIUS",
            "FreeRADIUS-Queue-PPS-Out"                       => "FreeRADIUS",
            "FreeRADIUS-Queue-Use-Percentage"                => "FreeRADIUS",
            "FreeRADIUS-Server-EMA-USEC-Window-1"            => "FreeRADIUS",
            "FreeRADIUS-Server-EMA-USEC-Window-10"           => "FreeRADIUS",
            "FreeRADIUS-Server-EMA-Window"                   => "FreeRADIUS",
            "FreeRADIUS-Statistics-Type"                     => "FreeRADIUS",
            "FreeRADIUS-Stats-Client-IP-Address"             => "FreeRADIUS",
            "FreeRADIUS-Stats-Client-IPv6-Address"           => "FreeRADIUS",
            "FreeRADIUS-Stats-Client-Netmask"                => "FreeRADIUS",
            "FreeRADIUS-Stats-Client-Number"                 => "FreeRADIUS",
            "FreeRADIUS-Stats-Error"                         => "FreeRADIUS",
            "FreeRADIUS-Stats-HUP-Time"                      => "FreeRADIUS",
            "FreeRADIUS-Stats-Last-Packet-Recv"              => "FreeRADIUS",
            "FreeRADIUS-Stats-Last-Packet-Sent"              => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-IP-Address"             => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-IPv6-Address"           => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-Outstanding-Requests"   => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-Port"                   => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-State"                  => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-Time-Of-Death"          => "FreeRADIUS",
            "FreeRADIUS-Stats-Server-Time-Of-Life"           => "FreeRADIUS",
            "FreeRADIUS-Stats-Start-Time"                    => "FreeRADIUS",
            "FreeRADIUS-Total-Access-Accepts"                => "FreeRADIUS",
            "FreeRADIUS-Total-Access-Challenges"             => "FreeRADIUS",
            "FreeRADIUS-Total-Access-Rejects"                => "FreeRADIUS",
            "FreeRADIUS-Total-Access-Requests"               => "FreeRADIUS",
            "FreeRADIUS-Total-Accounting-Requests"           => "FreeRADIUS",
            "FreeRADIUS-Total-Accounting-Responses"          => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Conflicts"                => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Dropped-Requests"         => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Duplicate-Requests"       => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Invalid-Requests"         => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Malformed-Requests"       => "FreeRADIUS",
            "FreeRADIUS-Total-Acct-Unknown-Types"            => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Conflicts"                => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Dropped-Requests"         => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Duplicate-Requests"       => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Invalid-Requests"         => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Malformed-Requests"       => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Responses"                => "FreeRADIUS",
            "FreeRADIUS-Total-Auth-Unknown-Types"            => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Access-Accepts"          => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Access-Challenges"       => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Access-Rejects"          => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Access-Requests"         => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Accounting-Requests"     => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Accounting-Responses"    => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Acct-Dropped-Requests"   => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Acct-Duplicate-Requests" => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Acct-Invalid-Requests"   => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Acct-Malformed-Requests" => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Acct-Unknown-Types"      => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Dropped-Requests"   => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Duplicate-Requests" => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Invalid-Requests"   => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Malformed-Requests" => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Responses"          => "FreeRADIUS",
            "FreeRADIUS-Total-Proxy-Auth-Unknown-Types"      => "FreeRADIUS",
            "Freeswitch-AMAFlags"                            => "Freeswitch",
            "Freeswitch-Ani"                                 => "Freeswitch",
            "Freeswitch-Aniii"                               => "Freeswitch",
            "Freeswitch-AVPair"                              => "Freeswitch",
            "Freeswitch-Billusec"                            => "Freeswitch",
            "Freeswitch-Callanswerdate"                      => "Freeswitch",
            "Freeswitch-Callenddate"                         => "Freeswitch",
            "Freeswitch-Callstartdate"                       => "Freeswitch",
            "Freeswitch-Calltransferdate"                    => "Freeswitch",
            "Freeswitch-CLID"                                => "Freeswitch",
            "Freeswitch-Context"                             => "Freeswitch",
            "Freeswitch-Dialplan"                            => "Freeswitch",
            "Freeswitch-Disposition"                         => "Freeswitch",
            "Freeswitch-Dst"                                 => "Freeswitch",
            "Freeswitch-Dst-Channel"                         => "Freeswitch",
            "Freeswitch-Hangupcause"                         => "Freeswitch",
            "Freeswitch-Lastapp"                             => "Freeswitch",
            "Freeswitch-Lastdata"                            => "Freeswitch",
            "Freeswitch-RDNIS"                               => "Freeswitch",
            "Freeswitch-Signalbond"                          => "Freeswitch",
            "Freeswitch-Source"                              => "Freeswitch",
            "Freeswitch-Src"                                 => "Freeswitch",
            "Freeswitch-Src-Channel"                         => "Freeswitch",
            "Gandalf-Around-The-Corner"                      => "Gandalf",
            "Gandalf-Authentication-String"                  => "Gandalf",
            "Gandalf-Calling-Line-ID-1"                      => "Gandalf",
            "Gandalf-Calling-Line-ID-2"                      => "Gandalf",
            "Gandalf-Channel-Group-Name-1"                   => "Gandalf",
            "Gandalf-Channel-Group-Name-2"                   => "Gandalf",
            "Gandalf-Compression-Status"                     => "Gandalf",
            "Gandalf-Dial-Prefix-Name-1"                     => "Gandalf",
            "Gandalf-Dial-Prefix-Name-2"                     => "Gandalf",
            "Gandalf-Fwd-Broadcast-In"                       => "Gandalf",
            "Gandalf-Fwd-Broadcast-Out"                      => "Gandalf",
            "Gandalf-Fwd-Multicast-In"                       => "Gandalf",
            "Gandalf-Fwd-Multicast-Out"                      => "Gandalf",
            "Gandalf-Fwd-Unicast-In"                         => "Gandalf",
            "Gandalf-Fwd-Unicast-Out"                        => "Gandalf",
            "Gandalf-Hunt-Group"                             => "Gandalf",
            "Gandalf-IPX-Spoofing-State"                     => "Gandalf",
            "Gandalf-IPX-Watchdog-Spoof"                     => "Gandalf",
            "Gandalf-Min-Outgoing-Bearer"                    => "Gandalf",
            "Gandalf-Modem-Mode"                             => "Gandalf",
            "Gandalf-Modem-Required-1"                       => "Gandalf",
            "Gandalf-Modem-Required-2"                       => "Gandalf",
            "Gandalf-Operational-Modes"                      => "Gandalf",
            "Gandalf-Phone-Number-1"                         => "Gandalf",
            "Gandalf-Phone-Number-2"                         => "Gandalf",
            "Gandalf-PPP-Authentication"                     => "Gandalf",
            "Gandalf-PPP-NCP-Type"                           => "Gandalf",
            "Gandalf-Remote-LAN-Name"                        => "Gandalf",
            "Gandalf-SAP-Group-Name-1"                       => "Gandalf",
            "Gandalf-SAP-Group-Name-2"                       => "Gandalf",
            "Gandalf-SAP-Group-Name-3"                       => "Gandalf",
            "Gandalf-SAP-Group-Name-4"                       => "Gandalf",
            "Gandalf-SAP-Group-Name-5"                       => "Gandalf",
            "Garderos-Location-Name"                         => "Garderos",
            "Garderos-MSISDN"                                => "Garderos",
            "Garderos-Proxy"                                 => "Garderos",
            "Garderos-Service-Name"                          => "Garderos",
            "gw-final-xlated-cdn"                            => "Cisco",
            "gw-final-xlated-cgn"                            => "Cisco",
            "gw-rxd-cdn"                                     => "Cisco",
            "gw-rxd-cgn"                                     => "Cisco",
            "h323-billing-model"                             => "Cisco",
            "h323-call-origin"                               => "Cisco",
            "h323-call-type"                                 => "Cisco",
            "h323-conf-id"                                   => "Cisco",
            "h323-connect-time"                              => "Cisco",
            "h323-credit-amount"                             => "Cisco",
            "h323-credit-time"                               => "Cisco",
            "h323-currency"                                  => "Cisco",
            "h323-disconnect-cause"                          => "Cisco",
            "h323-disconnect-time"                           => "Cisco",
            "h323-gw-id"                                     => "Cisco",
            "h323-incoming-conf-id"                          => "Cisco",
            "h323-preferred-lang"                            => "Cisco",
            "h323-prompt-id"                                 => "Cisco",
            "h323-redirect-ip-address"                       => "Cisco",
            "h323-redirect-number"                           => "Cisco",
            "h323-remote-address"                            => "Cisco",
            "h323-return-code"                               => "Cisco",
            "h323-setup-time"                                => "Cisco",
            "h323-time-and-day"                              => "Cisco",
            "h323-voice-quality"                             => "Cisco",
            "H3C-Accounting-Level"                           => "H3C",
            "H3C-Acct-IPv6-Input-Gigawords"                  => "H3C",
            "H3C-Acct-IPv6-Input-Octets"                     => "H3C",
            "H3C-Acct-IPv6-Input-Packets"                    => "H3C",
            "H3C-Acct-IPv6-Output-Gigawords"                 => "H3C",
            "H3C-Acct-IPv6-Output-Octets"                    => "H3C",
            "H3C-Acct-IPv6-Output-Packets"                   => "H3C",
            "H3C-ANCP-Profile"                               => "H3C",
            "H3C-Auth-Detail-Result"                         => "H3C",
            "H3C-Authentication-Type"                        => "H3C",
            "H3C-Av-Pair"                                    => "H3C",
            "H3C-Backup-NAS-IP"                              => "H3C",
            "H3C-Client-Primary-DNS"                         => "H3C",
            "H3C-Client-Secondary-DNS"                       => "H3C",
            "H3C-Command"                                    => "H3C",
            "H3C-Connect_Id"                                 => "H3C",
            "H3C-Control-Identifier"                         => "H3C",
            "H3C-Down-Priority"                              => "H3C",
            "H3C-Exec-Privilege"                             => "H3C",
            "H3C-Ftp-Directory"                              => "H3C",
            "H3C-IGMP-Access-Limit"                          => "H3C",
            "H3C-Input-Average-Rate"                         => "H3C",
            "H3C-Input-Basic-Rate"                           => "H3C",
            "H3C-Input-Committed-Burst-Size"                 => "H3C",
            "H3C-Input-Interval-Gigawords"                   => "H3C",
            "H3C-Input-Interval-Octets"                      => "H3C",
            "H3C-Input-Interval-Packets"                     => "H3C",
            "H3C-Input-Peak-Rate"                            => "H3C",
            "H3C-Ip-Host-Addr"                               => "H3C",
            "H3C-IPv4-Multicast-Receive-Group"               => "H3C",
            "H3C-IPv6-Multicast-Receive-Group"               => "H3C",
            "H3C-ISP-ID"                                     => "H3C",
            "H3C-Ita-Policy"                                 => "H3C",
            "H3C-L2TP-Local-Name"                            => "H3C",
            "H3C-Longitude-Latitude"                         => "H3C",
            "H3C-MLD-Access-Limit"                           => "H3C",
            "H3C-NAS-Port-Name"                              => "H3C",
            "H3C-NAS-Startup-Timestamp"                      => "H3C",
            "H3C-NAT-End-Port"                               => "H3C",
            "H3C-NAT-IP-Address"                             => "H3C",
            "H3C-NAT-Start-Port"                             => "H3C",
            "H3C-Output-Average-Rate"                        => "H3C",
            "H3C-Output-Basic-Rate"                          => "H3C",
            "H3C-Output-Committed-Burst-Size"                => "H3C",
            "H3C-Output-Interval-Gigawords"                  => "H3C",
            "H3C-Output-Interval-Octets"                     => "H3C",
            "H3C-Output-Interval-Packets"                    => "H3C",
            "H3C-Output-Peak-Rate"                           => "H3C",
            "H3C-Portal-URL"                                 => "H3C",
            "H3C-Product-ID"                                 => "H3C",
            "H3C-Remanent-Volume"                            => "H3C",
            "H3C-Result-Code"                                => "H3C",
            "H3C-Security-Level"                             => "H3C",
            "H3C-Subscriber-ID"                              => "H3C",
            "H3C-Subscriber-Profile"                         => "H3C",
            "H3C-Up-Priority"                                => "H3C",
            "H3C-User-Group"                                 => "H3C",
            "H3C-User-HeartBeat"                             => "H3C",
            "H3C-User-Notify"                                => "H3C",
            "H3C-User-Role"                                  => "H3C",
            "H3C-VPN-Instance"                               => "H3C",
            "H3C-WEB-URL"                                    => "H3C",
            "Hillstone-User-Admin-Privilege"                 => "Hillstone",
            "Hillstone-User-Login-Type"                      => "Hillstone",
            "Hillstone-User-Mobile-Number"                   => "Hillstone",
            "Hillstone-User-Mobile-Operator"                 => "Hillstone",
            "Hillstone-User-Policy-dst-ip-begin"             => "Hillstone",
            "Hillstone-User-Policy-dst-ip-end"               => "Hillstone",
            "Hillstone-User-Role-Bame"                       => "Hillstone",
            "Hillstone-User-Type"                            => "Hillstone",
            "Hillstone-User-vsys-id"                         => "Hillstone",
            "Hillstone-VPN-DHCP-Gateway"                     => "Hillstone",
            "Hillstone-VPN-DHCP-Mask"                        => "Hillstone",
            "Hillstone-VPN-DHCP-Pool"                        => "Hillstone",
            "Hillstone-VPN-DNS"                              => "Hillstone",
            "Hillstone-VPN-SNAT"                             => "Hillstone",
            "Hillstone-VPN-Split-Route"                      => "Hillstone",
            "Hillstone-VPN-Tunnel-IP"                        => "Hillstone",
            "Hillstone-VPN-WINS"                             => "Hillstone",
            "HP-Access-Profile"                              => "HP",
            "HP-Bandwidth-Max-Egress"                        => "HP",
            "HP-Bandwidth-Max-Ingress"                       => "HP",
            "HP-Bonjour-Inbound-Profile"                     => "HP",
            "HP-Bonjour-Outbound-Profile"                    => "HP",
            "HP-Capability-Advert"                           => "HP",
            "HP-Captive-Portal-URL"                          => "HP",
            "HP-Command-Exception"                           => "HP",
            "HP-Command-String"                              => "HP",
            "HP-Cos"                                         => "HP",
            "HP-CPPM-Role"                                   => "HP",
            "HP-CPPM-Secondary-Role"                         => "HP",
            "HP-Egress-VLAN-Name"                            => "HP",
            "HP-Egress-VLANID"                               => "HP",
            "HP-Ip-Filter-Raw"                               => "HP",
            "HP-Management-Protocol"                         => "HP",
            "HP-Nas-Filter-Rule"                             => "HP",
            "HP-Nas-Rules-IPv6"                              => "HP",
            "HP-Port-Auth-Mode-Dot1x"                        => "HP",
            "HP-Port-Bounce-Host"                            => "HP",
            "HP-Port-Client-Limit-Dot1x"                     => "HP",
            "HP-Port-Client-Limit-MA"                        => "HP",
            "HP-Port-Client-Limit-WA"                        => "HP",
            "HP-Port-MA-Port-Mode"                           => "HP",
            "HP-Port-Priority-Regeneration-Table"            => "HP",
            "HP-Privilege-Level"                             => "HP",
            "HP-URI-Access"                                  => "HP",
            "HP-URI-Exception"                               => "HP",
            "HP-URI-Json-String"                             => "HP",
            "HP-URI-String"                                  => "HP",
            "HP-User-Role"                                   => "HP",
            "HP-VC-groups"                                   => "HP",
            "HS20-AP-Version"                                => "WiFi-Alliance",
            "HS20-Deauthentication-Request"                  => "WiFi-Alliance",
            "HS20-Mobile-Device-Version"                     => "WiFi-Alliance",
            "HS20-Session-Information-URL"                   => "WiFi-Alliance",
            "HS20-Subscription-Remediation-Needed"           => "WiFi-Alliance",
            "HTTP-Redirect-Profile-Name"                     => "Ericsson-AB",
            "HTTP-Redirect-URL"                              => "Ericsson-AB",
            "Huawei-Access-Num"                              => "Huawei",
            "Huawei-Access-Service"                          => "Huawei",
            "Huawei-Account-Info"                            => "Huawei",
            "Huawei-Accounting-Level"                        => "Huawei",
            "Huawei-Acct-Connection-Time"                    => "Huawei",
            "Huawei-Acct-IPv6-Input-Gigawords"               => "Huawei",
            "Huawei-Acct-IPv6-Input-Octets"                  => "Huawei",
            "Huawei-Acct-IPv6-Input-Packets"                 => "Huawei",
            "Huawei-Acct-IPv6-Output-Gigawords"              => "Huawei",
            "Huawei-Acct-IPv6-Output-Octets"                 => "Huawei",
            "Huawei-Acct-IPv6-Output-Packets"                => "Huawei",
            "Huawei-Acct-Packet-Type"                        => "Huawei",
            "Huawei-Acct-Terminate-Subcause"                 => "Huawei",
            "Huawei-Acct-Update-Address"                     => "Huawei",
            "Huawei-ACS-Url"                                 => "Huawei",
            "Huawei-ANCP-Profile"                            => "Huawei",
            "Huawei-Application-Scene"                       => "Huawei",
            "Huawei-Application-Type"                        => "Huawei",
            "Huawei-Auth-Type"                               => "Huawei",
            "Huawei-AVpair"                                  => "Huawei",
            "Huawei-Call-Reference"                          => "Huawei",
            "Huawei-Codec-Type"                              => "Huawei",
            "Huawei-Command"                                 => "Huawei",
            "Huawei-Command-Mode"                            => "Huawei",
            "Huawei-Connect-ID"                              => "Huawei",
            "Huawei-Control-Identifier"                      => "Huawei",
            "Huawei-Data-Filter"                             => "Huawei",
            "Huawei-Delegated-IPv6-Prefix-Pool"              => "Huawei",
            "Huawei-Destnation-IP-Addr"                      => "Huawei",
            "Huawei-Destnation-Volume"                       => "Huawei",
            "Huawei-DHCP-Option"                             => "Huawei",
            "Huawei-DHCP-Server-IP"                          => "Huawei",
            "Huawei-DHCPv4-Option121"                        => "Huawei",
            "Huawei-DHCPv4-Option43"                         => "Huawei",
            "Huawei-DHCPv6-Option37"                         => "Huawei",
            "Huawei-DHCPv6-Option38"                         => "Huawei",
            "Huawei-DNS-Server-IPv6-address"                 => "Huawei",
            "Huawei-Domain-Name"                             => "Huawei",
            "Huawei-Down-Priority"                           => "Huawei",
            "Huawei-Down-QOS-Profile-Name"                   => "Huawei",
            "Huawei-DPI-Policy-Name"                         => "Huawei",
            "Huawei-DS-Lite-Tunnel-Name"                     => "Huawei",
            "Huawei-Dst-GK-ipaddr"                           => "Huawei",
            "Huawei-Dst-GW-ipaddr"                           => "Huawei",
            "Huawei-Error-Reason"                            => "Huawei",
            "Huawei-Exec-Privilege"                          => "Huawei",
            "Huawei-Ext-Specific"                            => "Huawei",
            "Huawei-Flow-Id"                                 => "Huawei",
            "Huawei-Flow-Info"                               => "Huawei",
            "Huawei-Framed-IPv6-Address"                     => "Huawei",
            "Huawei-Framed-Pool"                             => "Huawei",
            "Huawei-Framed-Pool-Group"                       => "Huawei",
            "Huawei-FTP-Directory"                           => "Huawei",
            "Huawei-Gateway-Address"                         => "Huawei",
            "Huawei-GGSN-Vendor"                             => "Huawei",
            "Huawei-GGSN-Version"                            => "Huawei",
            "Huawei-HTTP-Redirect-URL"                       => "Huawei",
            "Huawei-IGMP-Enable"                             => "Huawei",
            "Huawei-In-Kb-After-T-Switch"                    => "Huawei",
            "Huawei-In-Kb-Before-T-Switch"                   => "Huawei",
            "Huawei-In-Pkt-After-T-Switch"                   => "Huawei",
            "Huawei-In-Pkt-Before-T-Switch"                  => "Huawei",
            "Huawei-Indication-Flag"                         => "Huawei",
            "Huawei-Input-Average-Rate"                      => "Huawei",
            "Huawei-Input-Burst-Size"                        => "Huawei",
            "Huawei-Input-Peak-Burst-Size"                   => "Huawei",
            "Huawei-Input-Peak-Rate"                         => "Huawei",
            "Huawei-IP-Address"                              => "Huawei",
            "Huawei-IPHost-Addr"                             => "Huawei",
            "Huawei-IPv6-Address-Lease"                      => "Huawei",
            "Huawei-IPv6-Policy-Route"                       => "Huawei",
            "Huawei-IPv6-Prefix-Lease"                       => "Huawei",
            "Huawei-ISP-ID"                                  => "Huawei",
            "Huawei-L2TP-Terminate-Cause"                    => "Huawei",
            "Huawei-Layer4-Session-Limit"                    => "Huawei",
            "Huawei-Lease-Time"                              => "Huawei",
            "Huawei-LI-ID"                                   => "Huawei",
            "Huawei-LI-Md-Address"                           => "Huawei",
            "Huawei-LI-Md-Port"                              => "Huawei",
            "Huawei-LI-Md-VpnInstance"                       => "Huawei",
            "Huawei-Loopback-Address"                        => "Huawei",
            "Huawei-Max-List-Num"                            => "Huawei",
            "Huawei-Max-Users-Per-Logic-Port"                => "Huawei",
            "Huawei-MNG-IPv6"                                => "Huawei",
            "Huawei-MS-Maximum-MAC-Study-Number"             => "Huawei",
            "Huawei-Multi-Account-Mode"                      => "Huawei",
            "Huawei-Multicast-Profile"                       => "Huawei",
            "Huawei-Multicast-Receive-Group"                 => "Huawei",
            "Huawei-Multicast-Source-Group"                  => "Huawei",
            "Huawei-NAT-End-Port"                            => "Huawei",
            "Huawei-NAT-Policy-Name"                         => "Huawei",
            "Huawei-NAT-Port-Forwarding"                     => "Huawei",
            "Huawei-NAT-Port-Range-Update"                   => "Huawei",
            "Huawei-NAT-Public-Address"                      => "Huawei",
            "Huawei-NAT-Start-Port"                          => "Huawei",
            "Huawei-New-User-Name"                           => "Huawei",
            "Huawei-ONLY-Account-Type"                       => "Huawei",
            "Huawei-Org-GK-ipaddr"                           => "Huawei",
            "Huawei-Org-GW-ipaddr"                           => "Huawei",
            "Huawei-Original_NAS-IP_Address"                 => "Huawei",
            "Huawei-Out-Kb-After-T-Switch"                   => "Huawei",
            "Huawei-Out-Kb-Before-T-Switch"                  => "Huawei",
            "Huawei-Out-Pkt-After-T-Switch"                  => "Huawei",
            "Huawei-Out-Pkt-Before-T-Switch"                 => "Huawei",
            "Huawei-Output-Average-Rate"                     => "Huawei",
            "Huawei-Output-Burst-Size"                       => "Huawei",
            "Huawei-Output-Peak-Burst-Size"                  => "Huawei",
            "Huawei-Output-Peak-Rate"                        => "Huawei",
            "Huawei-PCP-Server-Name"                         => "Huawei",
            "Huawei-Policy-Name"                             => "Huawei",
            "huawei-Policy-Route"                            => "Huawei",
            "Huawei-Port-Mirror"                             => "Huawei",
            "Huawei-Portal-Mode"                             => "Huawei",
            "Huawei-PortalURL"                               => "Huawei",
            "Huawei-PPP-NCP-Type"                            => "Huawei",
            "Huawei-Primary-DNS"                             => "Huawei",
            "Huawei-Primary-WINS"                            => "Huawei",
            "Huawei-Priority"                                => "Huawei",
            "Huawei-Product-ID"                              => "Huawei",
            "Huawei-Provision-Code"                          => "Huawei",
            "Huawei-PSTN-Port"                               => "Huawei",
            "Huawei-Public-IP-Addr-State"                    => "Huawei",
            "Huawei-Qos-Profile-Name"                        => "Huawei",
            "Huawei-QoS-Profile-Type"                        => "Huawei",
            "Huawei-Queue-Profile"                           => "Huawei",
            "Huawei-Rebinding-Time"                          => "Huawei",
            "Huawei-Reduced-CIR"                             => "Huawei",
            "Huawei-Reduced-PIR"                             => "Huawei",
            "Huawei-Remain-Monney"                           => "Huawei",
            "Huawei-Remain-Time"                             => "Huawei",
            "Huawei-Remanent-Volume"                         => "Huawei",
            "Huawei-Renewal-Time"                            => "Huawei",
            "Huawei-Result-Code"                             => "Huawei",
            "Huawei-Secondary-DNS"                           => "Huawei",
            "Huawei-Secondary-WINS"                          => "Huawei",
            "Huawei-Service-Chg-Cmd"                         => "Huawei",
            "Huawei-Service-Info"                            => "Huawei",
            "Huawei-SIP-Server"                              => "Huawei",
            "Huawei-Startup-Stamp"                           => "Huawei",
            "Huawei-Subnet-Mask"                             => "Huawei",
            "Huawei-Tariff-Switch-Interval"                  => "Huawei",
            "Huawei-Transfer-Num"                            => "Huawei",
            "Huawei-Transfer-Station-Id"                     => "Huawei",
            "Huawei-Tunnel-Group-Name"                       => "Huawei",
            "Huawei-Tunnel-Session-Limit"                    => "Huawei",
            "Huawei-Tunnel-VPN-Instance"                     => "Huawei",
            "Huawei-Up-Priority"                             => "Huawei",
            "Huawei-User-Class"                              => "Huawei",
            "Huawei-User-Date"                               => "Huawei",
            "Huawei-User-Mac"                                => "Huawei",
            "Huawei-User-Multicast-Type"                     => "Huawei",
            "Huawei-User-Password"                           => "Huawei",
            "Huawei-User-Priority"                           => "Huawei",
            "Huawei-Version"                                 => "Huawei",
            "Huawei-Voip-Service-Type"                       => "Huawei",
            "Huawei-VPN-Instance"                            => "Huawei",
            "Huawei-VSI-Name"                                => "Huawei",
            "Huawei-VT-Name"                                 => "Huawei",
            "Huawei-Web-URL"                                 => "Huawei",
            "Huawei-Zone-Name"                               => "Huawei",
            "Idle-Timeout-Threshold"                         => "Ericsson-AB",
            "IGMP-Service-Profile-Name"                      => "Ericsson-AB",
            "incoming-req-uri"                               => "Cisco",
            "Infinera-ENM-User-Category"                     => "Infinera",
            "Infinera-User-Category"                         => "Infinera",
            "Infoblox-Group-Info"                            => "Infoblox",
            "Infoblox-Product-Name"                          => "Infoblox",
            "Infoblox-variable-1"                            => "Infoblox",
            "Infoblox-variable-2"                            => "Infoblox",
            "Infoblox-variable-3"                            => "Infoblox",
            "Infoblox-variable-4"                            => "Infoblox",
            "Infoblox-variable-5"                            => "Infoblox",
            "Infoblox-Version"                               => "Infoblox",
            "Infoblox-windows-group"                         => "Infoblox",
            "Infonet-Account-Number"                         => "infonet",
            "Infonet-Config"                                 => "infonet",
            "Infonet-LoginHost-Dest"                         => "infonet",
            "Infonet-MCS-Country"                            => "infonet",
            "Infonet-MCS-Off-Peak"                           => "infonet",
            "Infonet-MCS-Overflow"                           => "infonet",
            "Infonet-MCS-Port"                               => "infonet",
            "Infonet-MCS-Port-Count"                         => "infonet",
            "Infonet-MCS-Region"                             => "infonet",
            "Infonet-NAS-Location"                           => "infonet",
            "Infonet-Pool-Request"                           => "infonet",
            "Infonet-Proxy"                                  => "infonet",
            "Infonet-Random-IP-Pool"                         => "infonet",
            "Infonet-Realm-Type"                             => "infonet",
            "Infonet-Surcharge-Type"                         => "infonet",
            "Infonet-Tunnel-Decision-IP"                     => "infonet",
            "Infonet-Type"                                   => "infonet",
            "Initial-Modulation-Type"                        => "USR",
            "Ip-Address-Pool-Name"                           => "Ericsson-AB",
            "Ip-Host-Addr"                                   => "Ericsson-AB",
            "IP-Interface-Name"                              => "Ericsson-AB",
            "IP-TOS-Field"                                   => "Ericsson-AB",
            "IPU-IKE-Auth"                                   => "ipUnplugged",
            "IPU-IKE-Cmd"                                    => "ipUnplugged",
            "IPU-IKE-Conf-Name"                              => "ipUnplugged",
            "IPU-IKE-Local-Addr"                             => "ipUnplugged",
            "IPU-IKE-Remote-Addr"                            => "ipUnplugged",
            "IPU-MIP-Alg-Mode"                               => "ipUnplugged",
            "IPU-MIP-Alg-Type"                               => "ipUnplugged",
            "IPU-MIP-Key"                                    => "ipUnplugged",
            "IPU-MIP-Replay-Prot"                            => "ipUnplugged",
            "IPU-MIP-Spi"                                    => "ipUnplugged",
            "IPv4-Address-Release-Control"                   => "Ericsson-AB",
            "Issanni-Interface-Name"                         => "Issanni",
            "Issanni-IP-Pool-Name"                           => "Issanni",
            "Issanni-NAT-Support"                            => "Issanni",
            "Issanni-NAT-Type"                               => "Issanni",
            "Issanni-PPPoE-MOTM"                             => "Issanni",
            "Issanni-PPPoE-URL"                              => "Issanni",
            "Issanni-Pri-DNS"                                => "Issanni",
            "Issanni-Pri-NBNS"                               => "Issanni",
            "Issanni-QOS-Class"                              => "Issanni",
            "Issanni-Routing-Context"                        => "Issanni",
            "Issanni-Sec-DNS"                                => "Issanni",
            "Issanni-Sec-NBNS"                               => "Issanni",
            "Issanni-Service"                                => "Issanni",
            "Issanni-SoftFlow-Template"                      => "Issanni",
            "Issanni-Traffic-Class"                          => "Issanni",
            "Issanni-Tunnel-Name"                            => "Issanni",
            "Issanni-Tunnel-Type"                            => "Issanni",
            "ITK-Acct-Serv-IP"                               => "ITK",
            "ITK-Acct-Serv-Prot"                             => "ITK",
            "ITK-Auth-Req-Type"                              => "ITK",
            "ITK-Auth-Serv-IP"                               => "ITK",
            "ITK-Auth-Serv-Prot"                             => "ITK",
            "ITK-Banner"                                     => "ITK",
            "ITK-Channel-Binding"                            => "ITK",
            "ITK-DDI"                                        => "ITK",
            "ITK-Dest-No"                                    => "ITK",
            "ITK-Dialout-Type"                               => "ITK",
            "ITK-Filter-Rule"                                => "ITK",
            "ITK-Ftp-Auth-IP"                                => "ITK",
            "ITK-IP-Pool"                                    => "ITK",
            "ITK-ISDN-Prot"                                  => "ITK",
            "ITK-Modem-Init-String"                          => "ITK",
            "ITK-Modem-Pool-Id"                              => "ITK",
            "ITK-NAS-Name"                                   => "ITK",
            "ITK-Password-Prompt"                            => "ITK",
            "ITK-PPP-Auth-Type"                              => "ITK",
            "ITK-PPP-Client-Server-Mode"                     => "ITK",
            "ITK-PPP-Compression-Prot"                       => "ITK",
            "ITK-Prompt"                                     => "ITK",
            "ITK-Provider-Id"                                => "ITK",
            "ITK-Start-Delay"                                => "ITK",
            "ITK-Tunnel-IP"                                  => "ITK",
            "ITK-Tunnel-Prot"                                => "ITK",
            "ITK-Usergroup"                                  => "ITK",
            "ITK-Username"                                   => "ITK",
            "ITK-Username-Prompt"                            => "ITK",
            "ITK-Users-Default-Entry"                        => "ITK",
            "ITK-Users-Default-Pw"                           => "ITK",
            "ITK-Welcome-Message"                            => "ITK",
            "IWF-Session"                                    => "ADSL-Forum",
            "Juniper-Allow-Commands"                         => "Juniper",
            "Juniper-Allow-Configuration"                    => "Juniper",
            "Juniper-AV-Pair"                                => "Juniper",
            "Juniper-cell-overhead"                          => "Juniper",
            "Juniper-Configuration-Change"                   => "Juniper",
            "Juniper-CoS-Parameter"                          => "Juniper",
            "Juniper-CoS-Traffic-Control-Profile"            => "Juniper",
            "Juniper-CTP-Group"                              => "Juniper",
            "Juniper-CTPView-APP-Group"                      => "Juniper",
            "Juniper-CTPView-OS-Group"                       => "Juniper",
            "Juniper-CWA-Redirect"                           => "Juniper",
            "Juniper-Deny-Commands"                          => "Juniper",
            "Juniper-Deny-Configuration"                     => "Juniper",
            "Juniper-DHCPv4-Options"                         => "Juniper",
            "Juniper-DHCPv4-Packet-Header"                   => "Juniper",
            "Juniper-DHCPv6-Options"                         => "Juniper",
            "Juniper-DHCPv6-Packet-Header"                   => "Juniper",
            "Juniper-encapsulation-overhead"                 => "Juniper",
            "Juniper-Firewall-filter-name"                   => "Juniper",
            "Juniper-Interactive-Command"                    => "Juniper",
            "Juniper-Interface-id"                           => "Juniper",
            "Juniper-Ip-Pool-Name"                           => "Juniper",
            "Juniper-Junosspace-Profile"                     => "Juniper",
            "Juniper-Junosspace-Profiles"                    => "Juniper",
            "Juniper-Keep-Alive"                             => "Juniper",
            "Juniper-Local-Group-Name"                       => "Juniper",
            "Juniper-Local-Interface"                        => "Juniper",
            "Juniper-Local-User-Name"                        => "Juniper",
            "Juniper-Policer-Parameter"                      => "Juniper",
            "Juniper-Primary-Dns"                            => "Juniper",
            "Juniper-Primary-Wins"                           => "Juniper",
            "Juniper-rx-connect-speed"                       => "Juniper",
            "Juniper-Secondary-Dns"                          => "Juniper",
            "Juniper-Secondary-Wins"                         => "Juniper",
            "Juniper-Switching-Filter"                       => "Juniper",
            "Juniper-tx-connect-speed"                       => "Juniper",
            "Juniper-User-Permissions"                       => "Juniper",
            "Juniper-VoIP-Vlan"                              => "Juniper",
            "KarlNet-TurboCell-Name"                         => "KarlNet",
            "KarlNet-TurboCell-OpMode"                       => "KarlNet",
            "KarlNet-TurboCell-OpState"                      => "KarlNet",
            "KarlNet-TurboCell-TxRate"                       => "KarlNet",
            "Kineto-Billing-Rate-Indicator"                  => "Kineto",
            "Kineto-Hand-In-Control-Flag"                    => "Kineto",
            "Kineto-Hand-Out-Control-Flag"                   => "Kineto",
            "Kineto-Location-Key"                            => "Kineto",
            "Kineto-Service-Area-Code"                       => "Kineto",
            "Kineto-UMA-3G-Cell-Identity"                    => "Kineto",
            "Kineto-UMA-AP-Location"                         => "Kineto",
            "Kineto-UMA-AP-Radio-Identity"                   => "Kineto",
            "Kineto-UMA-AP-Service-Name"                     => "Kineto",
            "Kineto-UMA-Cell-Identity"                       => "Kineto",
            "Kineto-UMA-Classmark"                           => "Kineto",
            "Kineto-UMA-Coverage-Indicator"                  => "Kineto",
            "Kineto-UMA-Discovery-Reject-Cause"              => "Kineto",
            "Kineto-UMA-Geographical-Location"               => "Kineto",
            "Kineto-UMA-Location-Area-Identification"        => "Kineto",
            "Kineto-UMA-Location-Blacklist-Indicator"        => "Kineto",
            "Kineto-UMA-Location-Status"                     => "Kineto",
            "Kineto-UMA-MS-Radio-Identity"                   => "Kineto",
            "Kineto-UMA-Redirection-Counter"                 => "Kineto",
            "Kineto-UMA-Register-Reject-Cause"               => "Kineto",
            "Kineto-UMA-Registration-Indicators"             => "Kineto",
            "Kineto-UMA-Release-Indicator"                   => "Kineto",
            "Kineto-UMA-Required-UMA-Services"               => "Kineto",
            "Kineto-UMA-Routing-Area-Code"                   => "Kineto",
            "Kineto-UMA-RRC-State"                           => "Kineto",
            "Kineto-UMA-Service-Zone-Information"            => "Kineto",
            "Kineto-UMA-Serving-UNC-Table-Indicator"         => "Kineto",
            "Kineto-UMA-SGW-FQDN"                            => "Kineto",
            "Kineto-UMA-SGW-IP-Address"                      => "Kineto",
            "Kineto-UMA-UMA-PLMN-List"                       => "Kineto",
            "Kineto-UMA-UNC-FQDN"                            => "Kineto",
            "Kineto-UMA-UNC-IP-Address"                      => "Kineto",
            "Kineto-UMA-Utran-Cell-Identity"                 => "Kineto",
            "Kineto-UP-Client-Remote-Address"                => "Kineto",
            "Kineto-URR-Transaction-Type"                    => "Kineto",
            "KW-HNB-CELL-ACCESS-MODE"                        => "Kineto",
            "KW-HNB-CELL-ID"                                 => "Kineto",
            "KW-HNB-CSG-ID"                                  => "Kineto",
            "KW-HNB-IDENTITY"                                => "Kineto",
            "KW-HNB-LAC"                                     => "Kineto",
            "KW-HNB-LOC-INFO-ALTITUDE-Direction"             => "Kineto",
            "KW-HNB-LOC-INFO-GEO-COORDINATES"                => "Kineto",
            "KW-HNB-LOC-INFO-GERAN-CELL-ID"                  => "Kineto",
            "KW-HNB-LOC-INFO-IP-ADDRESS"                     => "Kineto",
            "KW-HNB-LOC-INFO-MACRO-COVERAGE-IND"             => "Kineto",
            "KW-HNB-LOC-INFO-UTRAN-CELL-ID"                  => "Kineto",
            "KW-HNB-LOCATION-AREA-IND"                       => "Kineto",
            "KW-HNB-LOCATION-BLACKLIST-IND"                  => "Kineto",
            "KW-HNB-PLMN-ID"                                 => "Kineto",
            "KW-HNB-RAC"                                     => "Kineto",
            "KW-HNB-REMOTE-ADDRESS"                          => "Kineto",
            "KW-HNB-SAC"                                     => "Kineto",
            "KW-IUH-BILLING-RATE-INDICATOR"                  => "Kineto",
            "KW-IUH-MESSAGE-TYPE"                            => "Kineto",
            "KW-REGISTRATION-REJECT-CAUSE"                   => "Kineto",
            "KW-UE-Capabilities"                             => "Kineto",
            "KW-UE-MEMBERSHIP-STATUS"                        => "Kineto",
            "LAC-Port"                                       => "Ericsson-AB",
            "LAC-Port-Type"                                  => "Ericsson-AB",
            "LAC-Real-Port"                                  => "Ericsson-AB",
            "LAC-Real-Port-Type"                             => "Ericsson-AB",
            "Lantronix-User-Attributes"                      => "Lantronix",
            "LCS-Access-Rights"                              => "Lancom",
            "LCS-Account-End"                                => "Lancom",
            "LCS-Advertisement-Interval"                     => "Lancom",
            "LCS-Advertisement-URL"                          => "Lancom",
            "LCS-Comment"                                    => "Lancom",
            "LCS-DNS-Server-IPv4-Address"                    => "Lancom",
            "LCS-Function-Rights"                            => "Lancom",
            "LCS-IKEv2-DNS-Domain"                           => "Lancom",
            "LCS-IKEv2-IPv4-Route"                           => "Lancom",
            "LCS-IKEv2-IPv6-Route"                           => "Lancom",
            "LCS-IKEv2-Local-Password"                       => "Lancom",
            "LCS-IKEv2-Remote-Password"                      => "Lancom",
            "LCS-Load-Balancer"                              => "Lancom",
            "LCS-Mac-Address"                                => "Lancom",
            "LCS-Orig-NAS-Identifier"                        => "Lancom",
            "LCS-Orig-NAS-IP-Address"                        => "Lancom",
            "LCS-Orig-NAS-IPv6-Address"                      => "Lancom",
            "LCS-PbSpotUserName"                             => "Lancom",
            "LCS-Redirection-URL"                            => "Lancom",
            "LCS-Routing-Tag"                                => "Lancom",
            "LCS-RxRateLimit"                                => "Lancom",
            "LCS-Traffic-Limit"                              => "Lancom",
            "LCS-Traffic-Limit-Gigawords"                    => "Lancom",
            "LCS-TxRateLimit"                                => "Lancom",
            "LCS-VPN-IPv4-Rule"                              => "Lancom",
            "LCS-VPN-IPv6-Rule"                              => "Lancom",
            "LCS-WPA-Passphrase"                             => "Lancom",
            "LE-Admin-Group"                                 => "Livingston",
            "LE-Advice-of-Charge"                            => "Livingston",
            "LE-Connect-Detail"                              => "Livingston",
            "LE-IP-Gateway"                                  => "Livingston",
            "LE-IP-Pool"                                     => "Livingston",
            "LE-IPSec-Active-Profile"                        => "Livingston",
            "LE-IPSec-Deny-Action"                           => "Livingston",
            "LE-IPSec-Log-Options"                           => "Livingston",
            "LE-IPSec-Outsource-Profile"                     => "Livingston",
            "LE-IPSec-Passive-Profile"                       => "Livingston",
            "LE-Modem-Info"                                  => "Livingston",
            "LE-Multicast-Client"                            => "Livingston",
            "LE-NAT-Inmap"                                   => "Livingston",
            "LE-NAT-Log-Options"                             => "Livingston",
            "LE-NAT-Other-Session-Timeout"                   => "Livingston",
            "LE-NAT-Outmap"                                  => "Livingston",
            "LE-NAT-Outsource-Inmap"                         => "Livingston",
            "LE-NAT-Outsource-Outmap"                        => "Livingston",
            "LE-NAT-Sess-Dir-Fail-Action"                    => "Livingston",
            "LE-NAT-TCP-Session-Timeout"                     => "Livingston",
            "LE-Terminate-Detail"                            => "Livingston",
            "LI-Action"                                      => "Ericsson-AB",
            "LI-Id"                                          => "Ericsson-AB",
            "LI-Md-Address"                                  => "Ericsson-AB",
            "LI-Md-Port"                                     => "Ericsson-AB",
            "LI-Profile"                                     => "Ericsson-AB",
            "Local-Seq-Number"                         => "VerizonWireless",
            "Local-Web-Acct-Duration"                  => "Local-Web",
            "Local-Web-Acct-Interim-Rx-Bytes"          => "Local-Web",
            "Local-Web-Acct-Interim-Rx-Gigawords"      => "Local-Web",
            "Local-Web-Acct-Interim-Rx-Mgmt"           => "Local-Web",
            "Local-Web-Acct-Interim-Tx-Bytes"          => "Local-Web",
            "Local-Web-Acct-Interim-Tx-Gigawords"      => "Local-Web",
            "Local-Web-Acct-Interim-Tx-Mgmt"           => "Local-Web",
            "Local-Web-Acct-Rx-Mgmt"                   => "Local-Web",
            "Local-Web-Acct-Time"                      => "Local-Web",
            "Local-Web-Acct-Tx-Mgmt"                   => "Local-Web",
            "Local-Web-Border-Router"                  => "Local-Web",
            "Local-Web-Client-Ip"                      => "Local-Web",
            "Local-Web-Reauth-Counter"                 => "Local-Web",
            "Local-Web-Rx-Limit"                       => "Local-Web",
            "Local-Web-Tx-Limit"                       => "Local-Web",
            "Lucent-Absolute-Time"                     => "Lucent",
            "Lucent-Access-Intercept-LEA"              => "Lucent",
            "Lucent-Access-Intercept-Log"              => "Lucent",
            "Lucent-Add-Seconds"                       => "Lucent",
            "Lucent-Appletalk-Peer-Mode"               => "Lucent",
            "Lucent-Appletalk-Route"                   => "Lucent",
            "Lucent-Ara-PW"                            => "Lucent",
            "Lucent-Assign-IP-Client"                  => "Lucent",
            "Lucent-Assign-IP-Global-Pool"             => "Lucent",
            "Lucent-Assign-IP-Pool"                    => "Lucent",
            "Lucent-Assign-IP-Server"                  => "Lucent",
            "Lucent-AT-Answer-String"                  => "Lucent",
            "Lucent-ATM-Circuit-Name"                  => "Lucent",
            "Lucent-ATM-Connect-Group"                 => "Lucent",
            "Lucent-ATM-Connect-Vci"                   => "Lucent",
            "Lucent-ATM-Connect-Vpi"                   => "Lucent",
            "Lucent-ATM-Direct"                        => "Lucent",
            "Lucent-ATM-Direct-Profile"                => "Lucent",
            "Lucent-ATM-Fault-Management"              => "Lucent",
            "Lucent-ATM-Group"                         => "Lucent",
            "Lucent-ATM-Loopback-Cell-Loss"            => "Lucent",
            "Lucent-ATM-Vci"                           => "Lucent",
            "Lucent-ATM-Vpi"                           => "Lucent",
            "Lucent-Auth-Delay"                        => "Lucent",
            "Lucent-Auth-Type"                         => "Lucent",
            "Lucent-Authen-Alias"                      => "Lucent",
            "Lucent-Backup"                            => "Lucent",
            "Lucent-BACP-Enable"                       => "Lucent",
            "Lucent-Base-Channel-Count"                => "Lucent",
            "Lucent-Bi-Directional-Auth"               => "Lucent",
            "Lucent-Billing-Number"                    => "Lucent",
            "Lucent-BIR-Bridge-Group"                  => "Lucent",
            "Lucent-BIR-Enable"                        => "Lucent",
            "Lucent-BIR-Proxy"                         => "Lucent",
            "Lucent-Bridge"                            => "Lucent",
            "Lucent-Bridge-Address"                    => "Lucent",
            "Lucent-Bridge-Non-PPPoE"                  => "Lucent",
            "Lucent-Cache-Refresh"                     => "Lucent",
            "Lucent-Cache-Time"                        => "Lucent",
            "Lucent-Call-Attempt-Limit"                => "Lucent",
            "Lucent-Call-Block-Duration"               => "Lucent",
            "Lucent-Call-By-Call"                      => "Lucent",
            "Lucent-Call-Direction"                    => "Lucent",
            "Lucent-Call-Filter"                       => "Lucent",
            "Lucent-Call-Type"                         => "Lucent",
            "Lucent-Callback"                          => "Lucent",
            "Lucent-Callback-Delay"                    => "Lucent",
            "Lucent-Calling-Id-Numbering-Plan"         => "Lucent",
            "Lucent-Calling-Id-Presentation"           => "Lucent",
            "Lucent-Calling-Id-Screening"              => "Lucent",
            "Lucent-Calling-Id-Type-Of-Number"         => "Lucent",
            "Lucent-Calling-Subaddress"                => "Lucent",
            "Lucent-CBCP-Delay"                        => "Lucent",
            "Lucent-CBCP-Enable"                       => "Lucent",
            "Lucent-CBCP-Mode"                         => "Lucent",
            "Lucent-CBCP-Trunk-Group"                  => "Lucent",
            "Lucent-CIR-Timer"                         => "Lucent",
            "Lucent-Ckt-Type"                          => "Lucent",
            "Lucent-Client-Assign-DNS"                 => "Lucent",
            "Lucent-Client-Assign-WINS"                => "Lucent",
            "Lucent-Client-Gateway"                    => "Lucent",
            "Lucent-Client-Primary-DNS"                => "Lucent",
            "Lucent-Client-Primary-WINS"               => "Lucent",
            "Lucent-Client-Secondary-DNS"              => "Lucent",
            "Lucent-Client-Secondary-WINS"             => "Lucent",
            "Lucent-Compression-Protocol"              => "Lucent",
            "Lucent-Configured-Rate-Dn-Max"            => "Lucent",
            "Lucent-Configured-Rate-Dn-Min"            => "Lucent",
            "Lucent-Configured-Rate-Up-Max"            => "Lucent",
            "Lucent-Configured-Rate-Up-Min"            => "Lucent",
            "Lucent-Connect-Progress"                  => "Lucent",
            "Lucent-Connection-Time"                   => "Lucent",
            "Lucent-Cumulative-Hold-Time"              => "Lucent",
            "Lucent-Current-Line-Quality"              => "Lucent",
            "Lucent-Current-Recv-Level"                => "Lucent",
            "Lucent-Current-SNR"                       => "Lucent",
            "Lucent-Current-Xmit-Level"                => "Lucent",
            "Lucent-Data-Filter"                       => "Lucent",
            "Lucent-Data-Rate"                         => "Lucent",
            "Lucent-Data-Svc"                          => "Lucent",
            "Lucent-DBA-Monitor"                       => "Lucent",
            "Lucent-Dec-Channel-Count"                 => "Lucent",
            "Lucent-Destination-NAS-Port"              => "Lucent",
            "Lucent-DHCP-Maximum-Leases"               => "Lucent",
            "Lucent-DHCP-Pool-Number"                  => "Lucent",
            "Lucent-DHCP-Reply"                        => "Lucent",
            "Lucent-Dial-Number"                       => "Lucent",
            "Lucent-Dialed-Number"                     => "Lucent",
            "Lucent-Dialout-Allowed"                   => "Lucent",
            "Lucent-Disconnect-Cause"                  => "Lucent",
            "Lucent-Dropped-Octets"                    => "Lucent",
            "Lucent-Dropped-Packets"                   => "Lucent",
            "Lucent-Ds3-CCVs"                          => "Lucent",
            "Lucent-Ds3-CESs"                          => "Lucent",
            "Lucent-Ds3-CSESs"                         => "Lucent",
            "Lucent-Ds3-F-Bit-Err"                     => "Lucent",
            "Lucent-Ds3-LCVs"                          => "Lucent",
            "Lucent-Ds3-LESs"                          => "Lucent",
            "Lucent-Ds3-P-Bit-Err"                     => "Lucent",
            "Lucent-Ds3-PCVs"                          => "Lucent",
            "Lucent-Ds3-PESs"                          => "Lucent",
            "Lucent-Ds3-PSESs"                         => "Lucent",
            "Lucent-Ds3-SEFs"                          => "Lucent",
            "Lucent-Ds3-UASs"                          => "Lucent",
            "Lucent-Dsl-Atuc-Chan-Corrected-Blks"      => "Lucent",
            "Lucent-Dsl-Atuc-Chan-Recd-Blks"           => "Lucent",
            "Lucent-Dsl-Atuc-Chan-Uncorrect-Blks"      => "Lucent",
            "Lucent-Dsl-Atuc-Chan-Xmit-Blks"           => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Atn-Dn"              => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Atn-Up"              => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Attainable-Rate-Dn"  => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Attainable-Rate-Up"  => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Output-Pwr-Dn"       => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Output-Pwr-Up"       => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Snr-Mgn-D"           => "Lucent",
            "Lucent-Dsl-Atuc-Curr-Snr-Mgn-Up"          => "Lucent",
            "Lucent-Dsl-Atuc-Perf-ESs"                 => "Lucent",
            "Lucent-Dsl-Atuc-Perf-Inits"               => "Lucent",
            "Lucent-Dsl-Atuc-Perf-Lofs"                => "Lucent",
            "Lucent-Dsl-Atuc-Perf-Lols"                => "Lucent",
            "Lucent-Dsl-Atuc-Perf-Loss"                => "Lucent",
            "Lucent-Dsl-Atuc-Perf-Lprs"                => "Lucent",
            "Lucent-Dsl-Atuc-PS-Failed-Fast-Retrains"  => "Lucent",
            "Lucent-Dsl-Atuc-PS-Fast-Retrains"         => "Lucent",
            "Lucent-Dsl-CIR-Recv-Limit"                => "Lucent",
            "Lucent-Dsl-CIR-Xmit-Limit"                => "Lucent",
            "Lucent-Dsl-Code-Violations"               => "Lucent",
            "Lucent-Dsl-Curr-Dn-Rate"                  => "Lucent",
            "Lucent-Dsl-Curr-Up-Rate"                  => "Lucent",
            "Lucent-Dsl-Downstream-Limit"              => "Lucent",
            "Lucent-Dsl-If-Index"                      => "Lucent",
            "Lucent-Dsl-Oper-Status"                   => "Lucent",
            "Lucent-Dsl-Physical-Channel"              => "Lucent",
            "Lucent-Dsl-Physical-Line"                 => "Lucent",
            "Lucent-Dsl-Physical-Slot"                 => "Lucent",
            "Lucent-Dsl-Rate-Mode"                     => "Lucent",
            "Lucent-Dsl-Rate-Type"                     => "Lucent",
            "Lucent-Dsl-Related-If-Index"              => "Lucent",
            "Lucent-Dsl-Related-Port"                  => "Lucent",
            "Lucent-Dsl-Related-Slot"                  => "Lucent",
            "Lucent-Dsl-Sparing-Role"                  => "Lucent",
            "Lucent-Dsl-Upstream-Limit"                => "Lucent",
            "Lucent-Egress-Enabled"                    => "Lucent",
            "Lucent-Endpoint-Disc"                     => "Lucent",
            "Lucent-Error-Correction-Protocol"         => "Lucent",
            "Lucent-Event-Type"                        => "Lucent",
            "Lucent-Expect-Callback"                   => "Lucent",
            "Lucent-FCP-Parameter"                     => "Lucent",
            "Lucent-Filter"                            => "Lucent",
            "Lucent-Filter-Required"                   => "Lucent",
            "Lucent-First-Dest"                        => "Lucent",
            "Lucent-First-Level-User"                  => "Lucent",
            "Lucent-Force-56"                          => "Lucent",
            "Lucent-FR-08-Mode"                        => "Lucent",
            "Lucent-FR-Circuit-Name"                   => "Lucent",
            "Lucent-FR-DCE-N392"                       => "Lucent",
            "Lucent-FR-DCE-N393"                       => "Lucent",
            "Lucent-FR-Direct"                         => "Lucent",
            "Lucent-FR-Direct-DLCI"                    => "Lucent",
            "Lucent-FR-Direct-Profile"                 => "Lucent",
            "Lucent-FR-DLCI"                           => "Lucent",
            "Lucent-FR-DTE-N392"                       => "Lucent",
            "Lucent-FR-DTE-N393"                       => "Lucent",
            "Lucent-FR-Link-Mgt"                       => "Lucent",
            "Lucent-FR-Link-Status-DLCI"               => "Lucent",
            "Lucent-FR-LinkUp"                         => "Lucent",
            "Lucent-FR-N391"                           => "Lucent",
            "Lucent-FR-Nailed-Grp"                     => "Lucent",
            "Lucent-FR-Profile-Name"                   => "Lucent",
            "Lucent-FR-SVC-Addr"                       => "Lucent",
            "Lucent-FR-T391"                           => "Lucent",
            "Lucent-FR-T392"                           => "Lucent",
            "Lucent-FR-Type"                           => "Lucent",
            "Lucent-Fr05-Enabled"                      => "Lucent",
            "Lucent-Fr05-Traffic-Shaper"               => "Lucent",
            "Lucent-Fr05-Vci"                          => "Lucent",
            "Lucent-Fr05-Vpi"                          => "Lucent",
            "Lucent-FT1-Caller"                        => "Lucent",
            "Lucent-Global-Call-Id"                    => "Lucent",
            "Lucent-Group"                             => "Lucent",
            "Lucent-H323-Conference-Id"                => "Lucent",
            "Lucent-H323-Destination-NAS-ID"           => "Lucent",
            "Lucent-H323-Dialed-Time"                  => "Lucent",
            "Lucent-H323-Gatekeeper"                   => "Lucent",
            "Lucent-Handle-IPX"                        => "Lucent",
            "Lucent-History-Weigh-Type"                => "Lucent",
            "Lucent-Home-Agent-IP-Addr"                => "Lucent",
            "Lucent-Home-Agent-Password"               => "Lucent",
            "Lucent-Home-Agent-UDP-Port"               => "Lucent",
            "Lucent-Home-Network-Name"                 => "Lucent",
            "Lucent-Host-Info"                         => "Lucent",
            "Lucent-Http-Redirect-Port"                => "Lucent",
            "Lucent-Http-Redirect-URL"                 => "Lucent",
            "Lucent-Idle-Limit"                        => "Lucent",
            "Lucent-IF-Netmask"                        => "Lucent",
            "Lucent-Inc-Channel-Count"                 => "Lucent",
            "Lucent-Inter-Arrival-Jitter"              => "Lucent",
            "Lucent-IP-Direct"                         => "Lucent",
            "Lucent-IP-DSCP"                           => "Lucent",
            "Lucent-IP-OUTGOING-DSCP"                  => "Lucent",
            "Lucent-IP-OUTGOING-TOS"                   => "Lucent",
            "Lucent-IP-OUTGOING-TOS-Precedence"        => "Lucent",
            "Lucent-IP-Pool-Chaining"                  => "Lucent",
            "Lucent-IP-Pool-Definition"                => "Lucent",
            "Lucent-IP-Source-If"                      => "Lucent",
            "Lucent-IP-TOS"                            => "Lucent",
            "Lucent-IP-TOS-Apply-To"                   => "Lucent",
            "Lucent-IP-TOS-Precedence"                 => "Lucent",
            "Lucent-IPSEC-Profile"                     => "Lucent",
            "Lucent-IPX-Alias"                         => "Lucent",
            "Lucent-IPX-Header-Compression"            => "Lucent",
            "Lucent-IPX-Node-Addr"                     => "Lucent",
            "Lucent-IPX-Peer-Mode"                     => "Lucent",
            "Lucent-IPX-Route"                         => "Lucent",
            "Lucent-L2TP-DCI-Direction"                => "Lucent",
            "Lucent-L2TP-DCI-Disconnect-Code"          => "Lucent",
            "Lucent-L2TP-DCI-Message"                  => "Lucent",
            "Lucent-L2TP-DCI-Protocol-Number"          => "Lucent",
            "Lucent-L2TP-Disconnect-Scenario"          => "Lucent",
            "Lucent-L2TP-Peer-Connect-Progress"        => "Lucent",
            "Lucent-L2TP-Peer-Disconnect-Cause"        => "Lucent",
            "Lucent-L2TP-Q931-Advisory-Message"        => "Lucent",
            "Lucent-L2TP-Q931-Cause-Code"              => "Lucent",
            "Lucent-L2TP-Q931-Cause-Message"           => "Lucent",
            "Lucent-L2TP-RC-Error-Code"                => "Lucent",
            "Lucent-L2TP-RC-Error-Message"             => "Lucent",
            "Lucent-L2TP-RC-Result-Code"               => "Lucent",
            "Lucent-LCP-Keepalive-Missed-Limit"        => "Lucent",
            "Lucent-LCP-Keepalive-Period"              => "Lucent",
            "Lucent-Line-Type"                         => "Lucent",
            "Lucent-Link-Compression"                  => "Lucent",
            "Lucent-Local-Retrain-Requested"           => "Lucent",
            "Lucent-Max-Recv-Rate"                     => "Lucent",
            "Lucent-Max-RTP-Delay"                     => "Lucent",
            "Lucent-Max-Shared-Users"                  => "Lucent",
            "Lucent-Max-SNR"                           => "Lucent",
            "Lucent-Max-Xmit-Rate"                     => "Lucent",
            "Lucent-Maximum-Call-Duration"             => "Lucent",
            "Lucent-Maximum-Channels"                  => "Lucent",
            "Lucent-Maximum-Time"                      => "Lucent",
            "Lucent-Menu-Item"                         => "Lucent",
            "Lucent-Menu-Selector"                     => "Lucent",
            "Lucent-Metric"                            => "Lucent",
            "Lucent-Min-Recv-Rate"                     => "Lucent",
            "Lucent-Min-SNR"                           => "Lucent",
            "Lucent-Min-Xmit-Rate"                     => "Lucent",
            "Lucent-Minimum-Channels"                  => "Lucent",
            "Lucent-Modem-Disconnect-Reason"           => "Lucent",
            "Lucent-Modem-Modulation"                  => "Lucent",
            "Lucent-Modem-PortNo"                      => "Lucent",
            "Lucent-Modem-ShelfNo"                     => "Lucent",
            "Lucent-Modem-SlotNo"                      => "Lucent",
            "Lucent-Modulation"                        => "Lucent",
            "Lucent-MOH-Timeout"                       => "Lucent",
            "Lucent-MPP-Idle-Percent"                  => "Lucent",
            "Lucent-MTU"                               => "Lucent",
            "Lucent-Multi-Packet-Separator"            => "Lucent",
            "Lucent-Multicast-Client"                  => "Lucent",
            "Lucent-Multicast-Filter-Active"           => "Lucent",
            "Lucent-Multicast-Filter-Address"          => "Lucent",
            "Lucent-Multicast-GLeave-Delay"            => "Lucent",
            "Lucent-Multicast-Max-Groups"              => "Lucent",
            "Lucent-Multicast-Rate-Limit"              => "Lucent",
            "Lucent-Multicast-Service-Active"          => "Lucent",
            "Lucent-Multicast-Service-Filter-Type"     => "Lucent",
            "Lucent-Multicast-Service-Name"            => "Lucent",
            "Lucent-Multicast-Service-Profile-Name"    => "Lucent",
            "Lucent-Multicast-Service-Snmp-Trap"       => "Lucent",
            "Lucent-Multilink-ID"                      => "Lucent",
            "Lucent-NAS-Port-Format"                   => "Lucent",
            "Lucent-Netware-timeout"                   => "Lucent",
            "Lucent-No-High-Prio-Pkt-Duratio"          => "Lucent",
            "Lucent-Num-In-Multilink"                  => "Lucent",
            "Lucent-Num-Moh-Sessions"                  => "Lucent",
            "Lucent-Number-Sessions"                   => "Lucent",
            "Lucent-Numbering-Plan-ID"                 => "Lucent",
            "Lucent-Owner-IP-Addr"                     => "Lucent",
            "Lucent-Packet-Classification"             => "Lucent",
            "Lucent-Port-Redir-Portnum"                => "Lucent",
            "Lucent-Port-Redir-Protocol"               => "Lucent",
            "Lucent-Port-Redir-Server"                 => "Lucent",
            "Lucent-PPP-Address"                       => "Lucent",
            "Lucent-PPP-Async-Map"                     => "Lucent",
            "Lucent-PPP-Circuit"                       => "Lucent",
            "Lucent-PPP-Circuit-Name"                  => "Lucent",
            "Lucent-PPP-VJ-1172"                       => "Lucent",
            "Lucent-PPP-VJ-Slot-Comp"                  => "Lucent",
            "Lucent-PPPoE-Enable"                      => "Lucent",
            "Lucent-Pre-Input-Octets"                  => "Lucent",
            "Lucent-Pre-Input-Packets"                 => "Lucent",
            "Lucent-Pre-Output-Octets"                 => "Lucent",
            "Lucent-Pre-Output-Packets"                => "Lucent",
            "Lucent-Preempt-Limit"                     => "Lucent",
            "Lucent-PreSession-Time"                   => "Lucent",
            "Lucent-PRI-Number-Type"                   => "Lucent",
            "Lucent-Primary-Home-Agent"                => "Lucent",
            "Lucent-Priority-For-PPP"                  => "Lucent",
            "Lucent-Private-Route"                     => "Lucent",
            "Lucent-Private-Route-Required"            => "Lucent",
            "Lucent-Private-Route-Table-ID"            => "Lucent",
            "Lucent-PW-Lifetime"                       => "Lucent",
            "Lucent-PW-Warntime"                       => "Lucent",
            "Lucent-QOS-Downstream"                    => "Lucent",
            "Lucent-QOS-Upstream"                      => "Lucent",
            "Lucent-QuickConnect-Attempted"            => "Lucent",
            "Lucent-Receive-Secret"                    => "Lucent",
            "Lucent-Recv-Name"                         => "Lucent",
            "Lucent-Recv-Symbol-Rate"                  => "Lucent",
            "Lucent-Redirect-Number"                   => "Lucent",
            "Lucent-Remote-Addr"                       => "Lucent",
            "Lucent-Remote-FW"                         => "Lucent",
            "Lucent-Remote-Retrain-Requested"          => "Lucent",
            "Lucent-Remove-Seconds"                    => "Lucent",
            "Lucent-Require-Auth"                      => "Lucent",
            "Lucent-Retrain-Reason"                    => "Lucent",
            "Lucent-Reverse-Path-Check"                => "Lucent",
            "Lucent-Route-Appletalk"                   => "Lucent",
            "Lucent-Route-IP"                          => "Lucent",
            "Lucent-Route-IPX"                         => "Lucent",
            "Lucent-Route-Preference"                  => "Lucent",
            "Lucent-Rtp-Local-Bytes-Sent"              => "Lucent",
            "Lucent-Rtp-Local-Delay-Maximum"           => "Lucent",
            "Lucent-Rtp-Local-Delay-Mean"              => "Lucent",
            "Lucent-Rtp-Local-Delay-Minimum"           => "Lucent",
            "Lucent-Rtp-Local-Delay-Variance"          => "Lucent",
            "Lucent-Rtp-Local-Jitter-Maximum"          => "Lucent",
            "Lucent-Rtp-Local-Jitter-Mean"             => "Lucent",
            "Lucent-Rtp-Local-Jitter-Minimum"          => "Lucent",
            "Lucent-Rtp-Local-Jitter-Variance"         => "Lucent",
            "Lucent-Rtp-Local-Number-Of-Samples"       => "Lucent",
            "Lucent-Rtp-Local-Packets-Late"            => "Lucent",
            "Lucent-Rtp-Local-Packets-Lost"            => "Lucent",
            "Lucent-Rtp-Local-Packets-Sent"            => "Lucent",
            "Lucent-Rtp-Local-Silence-Percent"         => "Lucent",
            "Lucent-RTP-Port-Range"                    => "Lucent",
            "Lucent-Rtp-Remote-Bytes-Sent"             => "Lucent",
            "Lucent-Rtp-Remote-Delay-Maximum"          => "Lucent",
            "Lucent-Rtp-Remote-Delay-Mean"             => "Lucent",
            "Lucent-Rtp-Remote-Delay-Minimum"          => "Lucent",
            "Lucent-Rtp-Remote-Delay-Variance"         => "Lucent",
            "Lucent-Rtp-Remote-Jitter-Maximum"         => "Lucent",
            "Lucent-Rtp-Remote-Jitter-Mean"            => "Lucent",
            "Lucent-Rtp-Remote-Jitter-Minimum"         => "Lucent",
            "Lucent-Rtp-Remote-Jitter-Variance"        => "Lucent",
            "Lucent-Rtp-Remote-Number-Of-Samples"      => "Lucent",
            "Lucent-Rtp-Remote-Packets-Late"           => "Lucent",
            "Lucent-Rtp-Remote-Packets-Lost"           => "Lucent",
            "Lucent-Rtp-Remote-Packets-Sent"           => "Lucent",
            "Lucent-Rtp-Remote-Silence-Percent"        => "Lucent",
            "Lucent-Secondary-Home-Agent"              => "Lucent",
            "Lucent-Seconds-Of-History"                => "Lucent",
            "Lucent-Send-Auth"                         => "Lucent",
            "Lucent-Send-Passwd"                       => "Lucent",
            "Lucent-Send-Secret"                       => "Lucent",
            "Lucent-Service-Type"                      => "Lucent",
            "Lucent-Session-Svr-Key"                   => "Lucent",
            "Lucent-Session-Type"                      => "Lucent",
            "Lucent-Shared-Profile-Enable"             => "Lucent",
            "Lucent-Sonet-Line-CVs-Far"                => "Lucent",
            "Lucent-Sonet-Line-CVs-Near"               => "Lucent",
            "Lucent-Sonet-Line-ESs-Far"                => "Lucent",
            "Lucent-Sonet-Line-ESs-Near"               => "Lucent",
            "Lucent-Sonet-Line-SESs-Far"               => "Lucent",
            "Lucent-Sonet-Line-SESs-Near"              => "Lucent",
            "Lucent-Sonet-Line-USs-Far"                => "Lucent",
            "Lucent-Sonet-Line-USs-Near"               => "Lucent",
            "Lucent-Sonet-Path-CVs-Far"                => "Lucent",
            "Lucent-Sonet-Path-CVs-Near"               => "Lucent",
            "Lucent-Sonet-Path-ESs-Far"                => "Lucent",
            "Lucent-Sonet-Path-ESs-Near"               => "Lucent",
            "Lucent-Sonet-Path-SESs-Far"               => "Lucent",
            "Lucent-Sonet-Path-SESs-Near"              => "Lucent",
            "Lucent-Sonet-Path-USs-Far"                => "Lucent",
            "Lucent-Sonet-Path-USs-Near"               => "Lucent",
            "Lucent-Sonet-Section-CVs"                 => "Lucent",
            "Lucent-Sonet-Section-ESs"                 => "Lucent",
            "Lucent-Sonet-Section-SEFSs"               => "Lucent",
            "Lucent-Sonet-Section-SESs"                => "Lucent",
            "Lucent-Source-Auth"                       => "Lucent",
            "Lucent-Source-IP-Check"                   => "Lucent",
            "Lucent-SVC-Enabled"                       => "Lucent",
            "Lucent-Target-Util"                       => "Lucent",
            "Lucent-Telnet-Profile"                    => "Lucent",
            "Lucent-TermSrv-Login-Prompt"              => "Lucent",
            "Lucent-Third-Prompt"                      => "Lucent",
            "Lucent-Token-Expiry"                      => "Lucent",
            "Lucent-Token-Idle"                        => "Lucent",
            "Lucent-Token-Immediate"                   => "Lucent",
            "Lucent-TOS-Copying"                       => "Lucent",
            "Lucent-Traffic-Shaper"                    => "Lucent",
            "Lucent-Transit-Number"                    => "Lucent",
            "Lucent-TS-Idle-Limit"                     => "Lucent",
            "Lucent-TS-Idle-Mode"                      => "Lucent",
            "Lucent-Tunnel-Auth-Type"                  => "Lucent",
            "Lucent-Tunnel-Auth-Type2"                 => "Lucent",
            "Lucent-Tunnel-DSCP"                       => "Lucent",
            "Lucent-Tunnel-TOS"                        => "Lucent",
            "Lucent-Tunnel-TOS-Copy"                   => "Lucent",
            "Lucent-Tunnel-TOS-Filter"                 => "Lucent",
            "Lucent-Tunnel-TOS-Precedence"             => "Lucent",
            "Lucent-Tunnel-VRouter-Name"               => "Lucent",
            "Lucent-Tunneling-Protocol"                => "Lucent",
            "Lucent-User-Acct-Base"                    => "Lucent",
            "Lucent-User-Acct-Expiration"              => "Lucent",
            "Lucent-User-Acct-Host"                    => "Lucent",
            "Lucent-User-Acct-Key"                     => "Lucent",
            "Lucent-User-Acct-Port"                    => "Lucent",
            "Lucent-User-Acct-Time"                    => "Lucent",
            "Lucent-User-Acct-Type"                    => "Lucent",
            "Lucent-User-Login-Level"                  => "Lucent",
            "Lucent-User-Priority"                     => "Lucent",
            "Lucent-UU-Info"                           => "Lucent",
            "Lucent-VRouter-Name"                      => "Lucent",
            "Lucent-X25-Cug"                           => "Lucent",
            "Lucent-X25-Nui"                           => "Lucent",
            "Lucent-X25-Nui-Password-Prompt"           => "Lucent",
            "Lucent-X25-Nui-Prompt"                    => "Lucent",
            "Lucent-X25-Pad-Alias-1"                   => "Lucent",
            "Lucent-X25-Pad-Alias-2"                   => "Lucent",
            "Lucent-X25-Pad-Alias-3"                   => "Lucent",
            "Lucent-X25-Pad-Banner"                    => "Lucent",
            "Lucent-X25-Pad-Prompt"                    => "Lucent",
            "Lucent-X25-Pad-X3-Parameters"             => "Lucent",
            "Lucent-X25-Pad-X3-Profile"                => "Lucent",
            "Lucent-X25-Profile-Name"                  => "Lucent",
            "Lucent-X25-Reverse-Charging"              => "Lucent",
            "Lucent-X25-Rpoa"                          => "Lucent",
            "Lucent-X25-X121-Address"                  => "Lucent",
            "Lucent-X25-X121-Source-Address"           => "Lucent",
            "Lucent-Xmit-Rate"                         => "Lucent",
            "Lucent-Xmit-Symbol-Rate"                  => "Lucent",
            "Mac-Addr"                                 => "Ericsson-AB",
            "Manzara-ECP-Session-Key"                  => "Manzara",
            "Manzara-Full-Login-String"                => "Manzara",
            "Manzara-Map-Error"                        => "Manzara",
            "Manzara-Map-Key"                          => "Manzara",
            "Manzara-Map-Name"                         => "Manzara",
            "Manzara-Map-Value"                        => "Manzara",
            "Manzara-PPP-Addr-String"                  => "Manzara",
            "Manzara-Service-Type"                     => "Manzara",
            "Manzara-Tariff-Type"                      => "Manzara",
            "Manzara-Tariff-Units"                     => "Manzara",
            "Manzara-User-GID"                         => "Manzara",
            "Manzara-User-Home"                        => "Manzara",
            "Manzara-User-Shell"                       => "Manzara",
            "Manzara-User-UID"                         => "Manzara",
            "Maximum-Data-Rate-Downstream"             => "ADSL-Forum",
            "Maximum-Data-Rate-Upstream"               => "ADSL-Forum",
            "Maximum-Interleaving-Delay-Downstream"    => "ADSL-Forum",
            "Maximum-Interleaving-Delay-Upstream"      => "ADSL-Forum",
            "MBG-Management-Privilege-Level"           => "Meinberg",
            "Mcast-MaxGroups"                          => "Ericsson-AB",
            "Mcast-Receive"                            => "Ericsson-AB",
            "Mcast-Send"                               => "Ericsson-AB",
            "Medium-Type"                              => "Ericsson-AB",
            "Mellanox-Local-User-Name"                 => "Mellanox",
            "Meraki-Ap-Name"                           => "Meraki",
            "Meraki-Ap-Tags"                           => "Meraki",
            "Meraki-Device-Name"                       => "Meraki",
            "Meraki-Network-Name"                      => "Meraki",
            "Merit-Proxy-Action"                       => "Merit",
            "Merit-User-Id"                            => "Merit",
            "Merit-User-Realm"                         => "Merit",
            "Meru-Access-Point-Id"                     => "Meru",
            "Meru-Access-Point-Name"                   => "Meru",
            "method"                                   => "Cisco",
            "Microsemi-Fallback-User-Group"            => "Microsemi",
            "Microsemi-Network-Element-Group"          => "Microsemi",
            "Microsemi-User-Email"                     => "Microsemi",
            "Microsemi-User-Full-Name"                 => "Microsemi",
            "Microsemi-User-Group"                     => "Microsemi",
            "Microsemi-User-Initials"                  => "Microsemi",
            "Microsemi-User-Name"                      => "Microsemi",
            "Mikrotik-Address-List"                    => "Mikrotik",
            "Mikrotik-Advertise-Interval"              => "Mikrotik",
            "Mikrotik-Advertise-URL"                   => "Mikrotik",
            "Mikrotik-Delegated-IPv6-Pool"             => "Mikrotik",
            "Mikrotik-DHCP-Option-Param-STR1"          => "Mikrotik",
            "Mikrotik-DHCP-Option-Param-STR2"          => "Mikrotik",
            "Mikrotik-DHCP-Option-ParamSTR2"           => "Mikrotik",
            "Mikrotik-DHCP-Option-Set"                 => "Mikrotik",
            "Mikrotik-Group"                           => "Mikrotik",
            "Mikrotik-Host-IP"                         => "Mikrotik",
            "Mikrotik-Mark-Id"                         => "Mikrotik",
            "Mikrotik-Rate-Limit"                      => "Mikrotik",
            "Mikrotik-Realm"                           => "Mikrotik",
            "Mikrotik-Recv-Limit"                      => "Mikrotik",
            "Mikrotik-Recv-Limit-Gigawords"            => "Mikrotik",
            "Mikrotik-Switching-Filter"                => "Mikrotik",
            "Mikrotik-Total-Limit"                     => "Mikrotik",
            "Mikrotik-Total-Limit-Gigawords"           => "Mikrotik",
            "Mikrotik-Wireless-Comment"                => "Mikrotik",
            "Mikrotik-Wireless-Enc-Algo"               => "Mikrotik",
            "Mikrotik-Wireless-Enc-Key"                => "Mikrotik",
            "Mikrotik-Wireless-Forward"                => "Mikrotik",
            "Mikrotik-Wireless-Maxsignal"              => "Mikrotik",
            "Mikrotik-Wireless-Minsignal"              => "Mikrotik",
            "Mikrotik-Wireless-MPKey"                  => "Mikrotik",
            "Mikrotik-Wireless-PSK"                    => "Mikrotik",
            "Mikrotik-Wireless-Skip-Dot1x"             => "Mikrotik",
            "Mikrotik-Wireless-VLANID"                 => "Mikrotik",
            "Mikrotik-Wireless-VLANID-Type"            => "Mikrotik",
            "Mikrotik-Wireless-VLANIDtype"             => "Mikrotik",
            "Mikrotik-Xmit-Limit"                      => "Mikrotik",
            "Mikrotik-Xmit-Limit-Gigawords"            => "Mikrotik",
            "Mimosa-CloudManagement-Parameter"         => "Mimosa",
            "Mimosa-Device-Configuration-Parameter"    => "Mimosa",
            "Mimosa-DeviceName-Parameter"              => "Mimosa",
            "Mimosa-DNS1-Parameter"                    => "Mimosa",
            "Mimosa-DNS2-Parameter"                    => "Mimosa",
            "Mimosa-EnableHTTPS-Parameter"             => "Mimosa",
            "Mimosa-EnableSNMP-Parameter"              => "Mimosa",
            "Mimosa-EnableSyslog-Parameter"            => "Mimosa",
            "Mimosa-EthernetPortSpeed-Parameter"       => "Mimosa",
            "Mimosa-FirmwareLocation-Parameter"        => "Mimosa",
            "Mimosa-FirmwareVersion-Parameter"         => "Mimosa",
            "Mimosa-HTTPPort-Parameter"                => "Mimosa",
            "Mimosa-HTTPSPort-Parameter"               => "Mimosa",
            "Mimosa-ManagementIPAddress-Parameter"     => "Mimosa",
            "Mimosa-ManagementIPAddressMode-Parameter" => "Mimosa",
            "Mimosa-ManagementIPGateway-Parameter"     => "Mimosa",
            "Mimosa-ManagementIPNetmask-Parameter"     => "Mimosa",
            "Mimosa-ManagementPassword-Parameter"      => "Mimosa",
            "Mimosa-ManagementVlan-Parameter"          => "Mimosa",
            "Mimosa-ManagementVlanStatus-Parameter"    => "Mimosa",
            "Mimosa-NTPServerAddress-Parameter"        => "Mimosa",
            "Mimosa-SNMPCommunityString-Parameter"     => "Mimosa",
            "Mimosa-SNMPTrapServer-Parameter"          => "Mimosa",
            "Mimosa-SyslogPort-Parameter"              => "Mimosa",
            "Mimosa-SyslogProtocol-Parameter"          => "Mimosa",
            "Mimosa-SyslogServerAddress-Parameter"     => "Mimosa",
            "Mimosa-TrafficShapingCommitted-Parameter" => "Mimosa",
            "Mimosa-TrafficShapingPeak-Parameter"      => "Mimosa",
            "Mimosa-WirelessProtocol-Parameter"        => "Mimosa",
            "Minimum-Data-Rate-Downstream"             => "ADSL-Forum",
            "Minimum-Data-Rate-Downstream-Low-Power"   => "ADSL-Forum",
            "Minimum-Data-Rate-Upstream"               => "ADSL-Forum",
            "Minimum-Data-Rate-Upstream-Low-Power"     => "ADSL-Forum",
            "Moonshot-Host-TargetedId"                 => "UKERNA",
            "Moonshot-MSTID-GSS-Acceptor"              => "UKERNA",
            "Moonshot-MSTID-Namespace"                 => "UKERNA",
            "Moonshot-MSTID-TargetedId"                => "UKERNA",
            "Moonshot-OTP-Secret"                      => "UKERNA",
            "Moonshot-Realm-TargetedId"                => "UKERNA",
            "Moonshot-TR-COI-TargetedId"               => "UKERNA",
            "Motorola-Accounting-Message"              => "Motorola",
            "Motorola-Canopy-BCASTMIR"                 => "Motorola",
            "Motorola-Canopy-DLBL"                     => "Motorola",
            "Motorola-Canopy-DLBR"                     => "Motorola",
            "Motorola-Canopy-HPDLCIR"                  => "Motorola",
            "Motorola-Canopy-HPENABLE"                 => "Motorola",
            "Motorola-Canopy-HPULCIR"                  => "Motorola",
            "Motorola-Canopy-LPDLCIR"                  => "Motorola",
            "Motorola-Canopy-LPULCIR"                  => "Motorola",
            "Motorola-Canopy-ULBL"                     => "Motorola",
            "Motorola-Canopy-ULBR"                     => "Motorola",
            "Motorola-Canopy-UserLevel"                => "Motorola",
            "Motorola-Canopy-VLAGETO"                  => "Motorola",
            "Motorola-Canopy-VLFRAMES"                 => "Motorola",
            "Motorola-Canopy-VLIDSET"                  => "Motorola",
            "Motorola-Canopy-VLIGVID"                  => "Motorola",
            "Motorola-Canopy-VLLEARNEN"                => "Motorola",
            "Motorola-Canopy-VLMGVID"                  => "Motorola",
            "Motorola-Canopy-VLSMMGPASS"               => "Motorola",
            "Motorola-WiMAX-Convergence-Sublayer"      => "Motorola",
            "Motorola-WiMAX-DNS-Server-IP-Address"     => "Motorola",
            "Motorola-WiMAX-EMS-Address"               => "Motorola",
            "Motorola-WiMAX-HO-SVC-CLASS"              => "Motorola",
            "Motorola-WiMAX-Home-BTS"                  => "Motorola",
            "Motorola-WiMAX-Maximum-Commit-Bandwidth"  => "Motorola",
            "Motorola-WiMAX-Maximum-Total-Bandwidth"   => "Motorola",
            "Motorola-WiMAX-MIP-KEY"                   => "Motorola",
            "Motorola-WiMAX-MIP-MN-HOME-ADDRESS"       => "Motorola",
            "Motorola-WiMAX-MIP-SPI"                   => "Motorola",
            "Motorola-WiMAX-MN-HA"                     => "Motorola",
            "Motorola-WiMAX-Network-Domain-Name"       => "Motorola",
            "Motorola-WiMAX-NTP-Server"                => "Motorola",
            "Motorola-WiMAX-Provisioning-Server"       => "Motorola",
            "Motorola-WiMAX-Service-Flows"             => "Motorola",
            "Motorola-WiMAX-User-NAI"                  => "Motorola",
            "Motorola-WiMAX-VLAN-ID"                   => "Motorola",
            "MS-Acct-Auth-Type"                        => "Microsoft",
            "MS-Acct-EAP-Type"                         => "Microsoft",
            "MS-AFW-Protection-Level"                  => "Microsoft",
            "MS-AFW-Zone"                              => "Microsoft",
            "MS-ARAP-PW-Change-Reason"                 => "Microsoft",
            "MS-BAP-Usage"                             => "Microsoft",
            "MS-CHAP-Challenge"                        => "Microsoft",
            "MS-CHAP-CPW-1"                            => "Microsoft",
            "MS-CHAP-CPW-2"                            => "Microsoft",
            "MS-CHAP-Domain"                           => "Microsoft",
            "MS-CHAP-Error"                            => "Microsoft",
            "MS-CHAP-LM-Enc-PW"                        => "Microsoft",
            "MS-CHAP-MPPE-Keys"                        => "Microsoft",
            "MS-CHAP-NT-Enc-PW"                        => "Microsoft",
            "MS-CHAP-Response"                         => "Microsoft",
            "MS-CHAP2-CPW"                             => "Microsoft",
            "MS-CHAP2-Response"                        => "Microsoft",
            "MS-CHAP2-Success"                         => "Microsoft",
            "MS-Extended-Quarantine-State"             => "Microsoft",
            "MS-Filter"                                => "Microsoft",
            "MS-HCAP-Location-Group-Name"              => "Microsoft",
            "MS-HCAP-User-Groups"                      => "Microsoft",
            "MS-HCAP-User-Name"                        => "Microsoft",
            "MS-Identity-Type"                         => "Microsoft",
            "MS-IPv4-Remediation-Servers"              => "Microsoft",
            "MS-IPv6-Filter"                           => "Microsoft",
            "MS-IPv6-Remediation-Servers"              => "Microsoft",
            "MS-Link-Drop-Time-Limit"                  => "Microsoft",
            "MS-Link-Utilization-Threshold"            => "Microsoft",
            "MS-Machine-Name"                          => "Microsoft",
            "MS-MPPE-Encryption-Policy"                => "Microsoft",
            "MS-MPPE-Encryption-Type"                  => "Microsoft",
            "MS-MPPE-Encryption-Types"                 => "Microsoft",
            "MS-MPPE-Recv-Key"                         => "Microsoft",
            "MS-MPPE-Send-Key"                         => "Microsoft",
            "MS-Network-Access-Server-Type"            => "Microsoft",
            "MS-New-ARAP-Password"                     => "Microsoft",
            "MS-Old-ARAP-Password"                     => "Microsoft",
            "MS-Primary-DNS-Server"                    => "Microsoft",
            "MS-Primary-NBNS-Server"                   => "Microsoft",
            "MS-Quarantine-Grace-Time"                 => "Microsoft",
            "MS-Quarantine-IPFilter"                   => "Microsoft",
            "MS-Quarantine-Session-Timeout"            => "Microsoft",
            "MS-Quarantine-SOH"                        => "Microsoft",
            "MS-Quarantine-State"                      => "Microsoft",
            "MS-Quarantine-User-Class"                 => "Microsoft",
            "MS-RAS-Client-Name"                       => "Microsoft",
            "MS-RAS-Client-Version"                    => "Microsoft",
            "MS-RAS-Correlation"                       => "Microsoft",
            "MS-RAS-Vendor"                            => "Microsoft",
            "MS-RAS-Version"                           => "Microsoft",
            "MS-RNAP-Not-Quarantine-Capable"           => "Microsoft",
            "MS-Secondary-DNS-Server"                  => "Microsoft",
            "MS-Secondary-NBNS-Server"                 => "Microsoft",
            "MS-Service-Class"                         => "Microsoft",
            "MS-TSG-Device-Redirection"                => "Microsoft",
            "MS-User-IPv4-Address"                     => "Microsoft",
            "MS-User-IPv6-Address"                     => "Microsoft",
            "MS-User-Security-Identity"                => "Microsoft",
            "NAS-Real-Port"                            => "Ericsson-AB",
            "NAT-Policy-Name"                          => "Ericsson-AB",
            "Navini-AVPair"                            => "Navini",
            "NET-Abort-Cause"                          => "NET",
            "NET-Alert-Time"                           => "NET",
            "NET-Bwd-Flow-In-Dst-Addr"                 => "NET",
            "NET-Bwd-Flow-In-Dst-Port"                 => "NET",
            "NET-Bwd-Flow-In-Realm"                    => "NET",
            "NET-Bwd-Flow-In-Src-Addr"                 => "NET",
            "NET-Bwd-Flow-In-Src-Port"                 => "NET",
            "NET-Bwd-Flow-Out-Dst-Addr"                => "NET",
            "NET-Bwd-Flow-Out-Dst-Port"                => "NET",
            "NET-Bwd-Flow-Out-Realm"                   => "NET",
            "NET-Bwd-Flow-Out-Src-Addr"                => "NET",
            "NET-Bwd-Flow-Out-Src-Port"                => "NET",
            "NET-Bwd-Octets"                           => "NET",
            "NET-Bwd-Packets"                          => "NET",
            "NET-Bwd-RTCP-Avg-Jitter"                  => "NET",
            "NET-Bwd-RTCP-MaxJitter"                   => "NET",
            "NET-Bwd-RTCP-Packets-Lost"                => "NET",
            "NET-Bwd-RTP-Avg-Jitter"                   => "NET",
            "NET-Bwd-RTP-Avg-Latency"                  => "NET",
            "NET-Bwd-RTP-MaxJitter"                    => "NET",
            "NET-Bwd-RTP-MaxLatency"                   => "NET",
            "NET-Bwd-RTP-Packets-Lost"                 => "NET",
            "NET-Call-Duration"                        => "NET",
            "NET-Call-Number-Type"                     => "NET",
            "NET-Call-Origin"                          => "NET",
            "NET-Call-Plan"                            => "NET",
            "NET-Call-Priority"                        => "NET",
            "NET-Call-Type"                            => "NET",
            "NET-Called-Name"                          => "NET",
            "NET-Called-Number"                        => "NET",
            "NET-Calling-Name"                         => "NET",
            "NET-Calling-Number"                       => "NET",
            "NET-Connect-Time"                         => "NET",
            "NET-Disconnect-Cause"                     => "NET",
            "NET-Disconnect-Initiator"                 => "NET",
            "NET-Disconnect-Time"                      => "NET",
            "NET-Egress-Channel-Id"                    => "NET",
            "NET-Egress-Channel-Number"                => "NET",
            "NET-Egress-Final-Routing-Num"             => "NET",
            "NET-Egress-Local-Addr"                    => "NET",
            "NET-Egress-Net-Interface-Id"              => "NET",
            "NET-Egress-Remote-Addr"                   => "NET",
            "NET-Egress-Signaling-Group"               => "NET",
            "NET-Egress-Signaling-Port-Num"            => "NET",
            "NET-Firmware-Version"                     => "NET",
            "NET-Fwd-Flow-In-Dst-Addr"                 => "NET",
            "NET-Fwd-Flow-In-Dst-Port"                 => "NET",
            "NET-Fwd-Flow-In-Realm"                    => "NET",
            "NET-Fwd-Flow-In-Src-Addr"                 => "NET",
            "NET-Fwd-Flow-In-Src-Port"                 => "NET",
            "NET-Fwd-Flow-Media-Type"                  => "NET",
            "NET-Fwd-Flow-Out-Dst-Addr"                => "NET",
            "NET-Fwd-Flow-Out-Dst-Port"                => "NET",
            "NET-Fwd-Flow-Out-Realm"                   => "NET",
            "NET-Fwd-Flow-Out-Src-Addr"                => "NET",
            "NET-Fwd-Flow-Out-Src-Port"                => "NET",
            "NET-Fwd-Flow-PTime"                       => "NET",
            "NET-Fwd-Octets"                           => "NET",
            "NET-Fwd-Packets"                          => "NET",
            "NET-Fwd-RTCP-Avg-Jitter"                  => "NET",
            "NET-Fwd-RTCP-MaxJitter"                   => "NET",
            "NET-Fwd-RTCP-Packets-Lost"                => "NET",
            "NET-Fwd-RTP-Avg-Jitter"                   => "NET",
            "NET-Fwd-RTP-Avg-Latency"                  => "NET",
            "NET-Fwd-RTP-MaxJitter"                    => "NET",
            "NET-Fwd-RTP-MaxLatency"                   => "NET",
            "NET-Fwd-RTP-Packets-Lost"                 => "NET",
            "NET-Gw-Id"                                => "NET",
            "NET-Inbound-Seize-Time"                   => "NET",
            "NET-Ingress-Channel-Id"                   => "NET",
            "NET-Ingress-Channel-Number"               => "NET",
            "NET-Ingress-Local-Addr"                   => "NET",
            "NET-Ingress-Net-Interface-Id"             => "NET",
            "NET-Ingress-Remote-Addr"                  => "NET",
            "NET-Ingress-Signaling-Group"              => "NET",
            "NET-Ingress-Signaling-Port-Num"           => "NET",
            "NET-Local-Time-Zone"                      => "NET",
            "NET-Log-Time"                             => "NET",
            "NET-Namespace"                            => "NET",
            "NET-Original-Called-Number"               => "NET",
            "NET-Original-Called-Plan"                 => "NET",
            "NET-Original-Called-Type"                 => "NET",
            "NET-Outbound-Seize-Time"                  => "NET",
            "NET-P-Asserted-ID"                        => "NET",
            "NET-P-Preferred-ID"                       => "NET",
            "NET-Post-Dial-Delay"                      => "NET",
            "NET-Precedence"                           => "NET",
            "NET-Presentation"                         => "NET",
            "NET-Primary-Routing-Number"               => "NET",
            "NET-Redirect-Ip-Address"                  => "NET",
            "NET-Redirect-Number"                      => "NET",
            "NET-Refer-Call-Transfer-Id"               => "NET",
            "NET-Replaced-Header"                      => "NET",
            "NET-Routing-Table-Number"                 => "NET",
            "NET-Screening"                            => "NET",
            "NET-Session-Egress-CallId"                => "NET",
            "NET-Session-Egress-Realm"                 => "NET",
            "NET-Session-Forked-Call-Id"               => "NET",
            "NET-Session-Generic-Id"                   => "NET",
            "NET-Session-Ingress-CallId"               => "NET",
            "NET-Session-Ingress-Realm"                => "NET",
            "NET-Setup-Time"                           => "NET",
            "NET-SIP-Diversion"                        => "NET",
            "NET-Time-And-Day"                         => "NET",
            "NET-Transfer-Capability"                  => "NET",
            "NET-Transfer-Mode"                        => "NET",
            "NET-Transfer-Rate"                        => "NET",
            "NET-Transport-Type"                       => "NET",
            "NET-User-Rate"                            => "NET",
            "NetBorder-AMAFlags"                       => "NetBorder",
            "NetBorder-Ani"                            => "NetBorder",
            "NetBorder-Aniii"                          => "NetBorder",
            "NetBorder-AVPair"                         => "NetBorder",
            "NetBorder-Billusec"                       => "NetBorder",
            "NetBorder-Callanswerdate"                 => "NetBorder",
            "NetBorder-Callenddate"                    => "NetBorder",
            "NetBorder-Callstartdate"                  => "NetBorder",
            "NetBorder-Calltransferdate"               => "NetBorder",
            "NetBorder-CLID"                           => "NetBorder",
            "NetBorder-Context"                        => "NetBorder",
            "NetBorder-Dialplan"                       => "NetBorder",
            "NetBorder-Disposition"                    => "NetBorder",
            "NetBorder-Dst"                            => "NetBorder",
            "NetBorder-Dst-Channel"                    => "NetBorder",
            "NetBorder-Hangupcause"                    => "NetBorder",
            "NetBorder-Lastapp"                        => "NetBorder",
            "NetBorder-Lastdata"                       => "NetBorder",
            "NetBorder-RDNIS"                          => "NetBorder",
            "NetBorder-Signalbond"                     => "NetBorder",
            "NetBorder-Source"                         => "NetBorder",
            "NetBorder-Src"                            => "NetBorder",
            "NetBorder-Src-Channel"                    => "NetBorder",
            "NetElastic-Acct-IPv6-Input-Gigawords"     => "NetElastic",
            "NetElastic-Acct-IPv6-Input-Octets"        => "NetElastic",
            "NetElastic-Acct-IPv6-Input-Packets"       => "NetElastic",
            "NetElastic-Acct-IPv6-Output-Gigawords"    => "NetElastic",
            "NetElastic-Acct-IPv6-Output-Octets"       => "NetElastic",
            "NetElastic-Acct-IPv6-Output-Packets"      => "NetElastic",
            "NetElastic-Data-Filter"                   => "NetElastic",
            "NetElastic-Domain-Name"                   => "NetElastic",
            "NetElastic-Framed-IPv6-Address"           => "NetElastic",
            "NetElastic-HTTP-Redirect-URL"             => "NetElastic",
            "NetElastic-Input-Average-Rate"            => "NetElastic",
            "NetElastic-Input-Burst-Size"              => "NetElastic",
            "NetElastic-Input-Peak-Burst-Size"         => "NetElastic",
            "NetElastic-Input-Peak-Rate"               => "NetElastic",
            "NetElastic-ISP-ID"                        => "NetElastic",
            "NetElastic-Lease-Time"                    => "NetElastic",
            "NetElastic-NAT-End-Port"                  => "NetElastic",
            "NetElastic-NAT-Public-Address"            => "NetElastic",
            "NetElastic-NAT-Start-Port"                => "NetElastic",
            "NetElastic-Output-Average-Rate"           => "NetElastic",
            "NetElastic-Output-Burst-Size"             => "NetElastic",
            "NetElastic-Output-Peak-Burst-Size"        => "NetElastic",
            "NetElastic-Output-Peak-Rate"              => "NetElastic",
            "NetElastic-Policy-Name"                   => "NetElastic",
            "NetElastic-Portal-Mode"                   => "NetElastic",
            "NetElastic-PortalURL"                     => "NetElastic",
            "NetElastic-Primary-DNS"                   => "NetElastic",
            "NetElastic-Qos-Profile-Name"              => "NetElastic",
            "NetElastic-Remanent-Volume"               => "NetElastic",
            "NetElastic-Remanent-Volume-Type"          => "NetElastic",
            "NetElastic-Secondary-DNS"                 => "NetElastic",
            "NetElastic-Tariff-Input-Gigawords"        => "NetElastic",
            "NetElastic-Tariff-Input-Octets"           => "NetElastic",
            "NetElastic-Tariff-Output-Gigawords"       => "NetElastic",
            "NetElastic-Tariff-Output-Octets"          => "NetElastic",
            "NetElastic-User-Mac"                      => "NetElastic",
            "NetElastic-Web-COA"                       => "NetElastic",
            "NetSensory-Privilege"                     => "NetworkPhysics",
            "Nexans-Port-Default-VLAN-ID"              => "Nexans",
            "Nexans-Port-Voice-VLAN-ID"                => "Nexans",
            "next-hop-dn"                              => "Cisco",
            "next-hop-ip"                              => "Cisco",
            "Nile-AVPair"                              => "Nile",
            "Nile-Netseg"                              => "Nile",
            "Nile-Redirect-URL"                        => "Nile",
            "NN-Data-Rate"                             => "Bristol",
            "NN-Data-Rate-Ceiling"                     => "Bristol",
            "NN-Homenode"                              => "Bristol",
            "NN-Homeservice"                           => "Bristol",
            "NN-Homeservice-Name"                      => "Bristol",
            "Nokia-AVPair"                             => "Nokia",
            "Nokia-OCS-ID1"                            => "Nokia",
            "Nokia-OCS-ID2"                            => "Nokia",
            "Nokia-Requested-APN"                      => "Nokia",
            "Nokia-Service-Charging-Type"              => "Nokia",
            "Nokia-Service-Encrypted-Password"         => "Nokia",
            "Nokia-Service-Id"                         => "Nokia",
            "Nokia-Service-Name"                       => "Nokia",
            "Nokia-Service-Password"                   => "Nokia",
            "Nokia-Service-Primary-Indicator"          => "Nokia",
            "Nokia-Service-Username"                   => "Nokia",
            "Nokia-Session-Access-Method"              => "Nokia",
            "Nokia-Session-Charging-Type"              => "Nokia",
            "Nokia-TREC-Index"                         => "Nokia",
            "Nokia-User-Profile"                       => "Nokia",
            "Nomadix-Bw-Down"                          => "Nomadix",
            "Nomadix-Bw-Up"                            => "Nomadix",
            "Nomadix-Centralized-Mgmt"                 => "Nomadix",
            "Nomadix-Config-URL"                       => "Nomadix",
            "Nomadix-EndofSession"                     => "Nomadix",
            "Nomadix-Expiration"                       => "Nomadix",
            "Nomadix-Goodbye-URL"                      => "Nomadix",
            "Nomadix-Group-Bw-Max-Down"                => "Nomadix",
            "Nomadix-Group-Bw-Max-Up"                  => "Nomadix",
            "Nomadix-Group-Policy-Id"                  => "Nomadix",
            "Nomadix-IP-Upsell"                        => "Nomadix",
            "Nomadix-Logoff-URL"                       => "Nomadix",
            "Nomadix-MaxBytesDown"                     => "Nomadix",
            "Nomadix-MaxBytesUp"                       => "Nomadix",
            "Nomadix-Net-VLAN"                         => "Nomadix",
            "Nomadix-Qos-Policy"                       => "Nomadix",
            "Nomadix-SMTP-Redirect"                    => "Nomadix",
            "Nomadix-Subnet"                           => "Nomadix",
            "Nomadix-URL-Redirection"                  => "Nomadix",
            "Nortel-Privilege-Level"                   => "Nortel",
            "Nortel-User-Role"                         => "Nortel",
            "NS-Admin-Privilege"                       => "Netscreen",
            "NS-NSM-User-Domain-Name"                  => "Netscreen",
            "NS-NSM-User-Role-Mapping"                 => "Netscreen",
            "NS-Primary-DNS"                           => "Netscreen",
            "NS-Primary-WINS"                          => "Netscreen",
            "NS-Secondary-DNS"                         => "Netscreen",
            "NS-Secondary-WINS"                        => "Netscreen",
            "NS-User-Group"                            => "Netscreen",
            "NS-VSYS-Name"                             => "Netscreen",
            "OS-Version"                               => "Ericsson-AB",
            "outgoing-req-uri"                         => "Cisco",
            "Packeteer-AVPair"                         => "Packeteer",
            "Packeteer-PC-AVPair"                      => "Packeteer",
            "PacketFence-Authorization-Status"         => "Inverse",
            "PacketFence-AutoReg"                      => "Inverse",
            "PacketFence-Computer-Name"                => "Inverse",
            "PacketFence-Connection-Type"              => "Inverse",
            "PacketFence-ConnectorID"                  => "Inverse",
            "PacketFence-Domain"                       => "Inverse",
            "PacketFence-Eap-Type"                     => "Inverse",
            "PacketFence-Handled"                      => "Inverse",
            "PacketFence-IfIndex"                      => "Inverse",
            "PacketFence-IsPhone"                      => "Inverse",
            "PacketFence-KeyBalanced"                  => "Inverse",
            "PacketFence-Mac"                          => "Inverse",
            "PacketFence-NasName"                      => "Inverse",
            "PacketFence-NTCacheHash"                  => "Inverse",
            "PacketFence-NTLM-Auth-Host"               => "Inverse",
            "PacketFence-NTLM-Auth-Port"               => "Inverse",
            "PacketFence-NTLMv2-Only"                  => "Inverse",
            "PacketFence-Outer-User"                   => "Inverse",
            "PacketFence-Profile"                      => "Inverse",
            "PacketFence-Proxied-From"                 => "Inverse",
            "PacketFence-Proxied-To"                   => "Inverse",
            "PacketFence-Radius-Ip"                    => "Inverse",
            "PacketFence-reply-insert"                 => "Inverse",
            "PacketFence-Request-Time"                 => "Inverse",
            "PacketFence-Role"                         => "Inverse",
            "PacketFence-RPC-Pass"                     => "Inverse",
            "PacketFence-RPC-Port"                     => "Inverse",
            "PacketFence-RPC-Proto"                    => "Inverse",
            "PacketFence-RPC-Server"                   => "Inverse",
            "PacketFence-RPC-User"                     => "Inverse",
            "PacketFence-ShortName"                    => "Inverse",
            "PacketFence-Source"                       => "Inverse",
            "PacketFence-SSID"                         => "Inverse",
            "PacketFence-Status"                       => "Inverse",
            "PacketFence-Switch-Id"                    => "Inverse",
            "PacketFence-Switch-Ip-Address"            => "Inverse",
            "PacketFence-Switch-Mac"                   => "Inverse",
            "PacketFence-UserDN"                       => "Inverse",
            "PacketFence-UserName"                     => "Inverse",
            "PacketFence-UserNameAttribute"            => "Inverse",
            "PacketFence-UserPassword"                 => "Inverse",
            "PaloAlto-Admin-Access-Domain"             => "PaloAlto",
            "PaloAlto-Admin-Role"                      => "PaloAlto",
            "PaloAlto-Client-Hostname"                 => "PaloAlto",
            "PaloAlto-Client-OS"                       => "PaloAlto",
            "PaloAlto-Client-Source-IP"                => "PaloAlto",
            "PaloAlto-GlobalProtect-Client-Version"    => "PaloAlto",
            "PaloAlto-Panorama-Admin-Access-Domain"    => "PaloAlto",
            "PaloAlto-Panorama-Admin-Role"             => "PaloAlto",
            "PaloAlto-User-Domain"                     => "PaloAlto",
            "PaloAlto-User-Group"                      => "PaloAlto",
            "Passport-Access-Priority"                 => "Bay-Networks",
            "Passport-Allowed-Access"                  => "Nortel",
            "Passport-AllowedOut-Access"               => "Nortel",
            "Passport-Command-Impact"                  => "Nortel",
            "Passport-Command-Scope"                   => "Nortel",
            "Passport-Customer-Identifier"             => "Nortel",
            "Passport-Login-Directory"                 => "Nortel",
            "Passport-Role"                            => "Nortel",
            "Passport-Timeout-Protocol"                => "Nortel",
            "Patton-Called-Codec"                      => "Patton",
            "Patton-Called-IP-Address"                 => "Patton",
            "Patton-Called-Local-Udp-Port"             => "Patton",
            "Patton-Called-MOS"                        => "Patton",
            "Patton-Called-Name"                       => "Patton",
            "Patton-Called-Numbering-Plan"             => "Patton",
            "Patton-Called-Qos"                        => "Patton",
            "Patton-Called-Remote-Ip"                  => "Patton",
            "Patton-Called-Remote-Udp-Port"            => "Patton",
            "Patton-Called-Round-Trip-Time"            => "Patton",
            "Patton-Called-Rx-Jitter"                  => "Patton",
            "Patton-Called-Rx-Lost-Packets"            => "Patton",
            "Patton-Called-Rx-Octets"                  => "Patton",
            "Patton-Called-Rx-Packets"                 => "Patton",
            "Patton-Called-Station-Id"                 => "Patton",
            "Patton-Called-Tx-Jitter"                  => "Patton",
            "Patton-Called-Tx-Lost-Packets"            => "Patton",
            "Patton-Called-Tx-Octets"                  => "Patton",
            "Patton-Called-Tx-Packets"                 => "Patton",
            "Patton-Called-Type-Of-Number"             => "Patton",
            "Patton-Called-Unique-Id"                  => "Patton",
            "Patton-Calling-Codec"                     => "Patton",
            "Patton-Calling-IP-Address"                => "Patton",
            "Patton-Calling-Local-Udp-Port"            => "Patton",
            "Patton-Calling-Lost-Rx-Packets"           => "Patton",
            "Patton-Calling-Lost-Tx-Packets"           => "Patton",
            "Patton-Calling-MOS"                       => "Patton",
            "Patton-Calling-Name"                      => "Patton",
            "Patton-Calling-Numbering-Plan"            => "Patton",
            "Patton-Calling-Presentation-Indicator"    => "Patton",
            "Patton-Calling-Qos"                       => "Patton",
            "Patton-Calling-Remote-Ip"                 => "Patton",
            "Patton-Calling-Remote-Udp-Port"           => "Patton",
            "Patton-Calling-Round-Trip-Time"           => "Patton",
            "Patton-Calling-Rx-Jitter"                 => "Patton",
            "Patton-Calling-Rx-Octets"                 => "Patton",
            "Patton-Calling-Rx-Packets"                => "Patton",
            "Patton-Calling-Screening-Indicator"       => "Patton",
            "Patton-Calling-Station-Id"                => "Patton",
            "Patton-Calling-Tx-Jitter"                 => "Patton",
            "Patton-Calling-Tx-Octets"                 => "Patton",
            "Patton-Calling-Tx-Packets"                => "Patton",
            "Patton-Calling-Type-Of-Number"            => "Patton",
            "Patton-Calling-Unique-Id"                 => "Patton",
            "Patton-Connect-Time"                      => "Patton",
            "Patton-Disconnect-Cause"                  => "Patton",
            "Patton-Disconnect-Reason"                 => "Patton",
            "Patton-Disconnect-Source"                 => "Patton",
            "Patton-Disconnect-Time"                   => "Patton",
            "Patton-Group"                             => "Patton",
            "Patton-Protocol"                          => "Patton",
            "Patton-Setup-Time"                        => "Patton",
            "Patton-Web-Privilege-Level"               => "Patton",
            "Perle-Clustered-Port-Access"              => "Perle",
            "Perle-Line-Access-Port-1"                 => "Perle",
            "Perle-Line-Access-Port-10"                => "Perle",
            "Perle-Line-Access-Port-11"                => "Perle",
            "Perle-Line-Access-Port-12"                => "Perle",
            "Perle-Line-Access-Port-13"                => "Perle",
            "Perle-Line-Access-Port-14"                => "Perle",
            "Perle-Line-Access-Port-15"                => "Perle",
            "Perle-Line-Access-Port-16"                => "Perle",
            "Perle-Line-Access-Port-17"                => "Perle",
            "Perle-Line-Access-Port-18"                => "Perle",
            "Perle-Line-Access-Port-19"                => "Perle",
            "Perle-Line-Access-Port-2"                 => "Perle",
            "Perle-Line-Access-Port-20"                => "Perle",
            "Perle-Line-Access-Port-21"                => "Perle",
            "Perle-Line-Access-Port-22"                => "Perle",
            "Perle-Line-Access-Port-23"                => "Perle",
            "Perle-Line-Access-Port-24"                => "Perle",
            "Perle-Line-Access-Port-25"                => "Perle",
            "Perle-Line-Access-Port-26"                => "Perle",
            "Perle-Line-Access-Port-27"                => "Perle",
            "Perle-Line-Access-Port-28"                => "Perle",
            "Perle-Line-Access-Port-29"                => "Perle",
            "Perle-Line-Access-Port-3"                 => "Perle",
            "Perle-Line-Access-Port-30"                => "Perle",
            "Perle-Line-Access-Port-31"                => "Perle",
            "Perle-Line-Access-Port-32"                => "Perle",
            "Perle-Line-Access-Port-33"                => "Perle",
            "Perle-Line-Access-Port-34"                => "Perle",
            "Perle-Line-Access-Port-35"                => "Perle",
            "Perle-Line-Access-Port-36"                => "Perle",
            "Perle-Line-Access-Port-37"                => "Perle",
            "Perle-Line-Access-Port-38"                => "Perle",
            "Perle-Line-Access-Port-39"                => "Perle",
            "Perle-Line-Access-Port-4"                 => "Perle",
            "Perle-Line-Access-Port-40"                => "Perle",
            "Perle-Line-Access-Port-41"                => "Perle",
            "Perle-Line-Access-Port-42"                => "Perle",
            "Perle-Line-Access-Port-43"                => "Perle",
            "Perle-Line-Access-Port-44"                => "Perle",
            "Perle-Line-Access-Port-45"                => "Perle",
            "Perle-Line-Access-Port-46"                => "Perle",
            "Perle-Line-Access-Port-47"                => "Perle",
            "Perle-Line-Access-Port-48"                => "Perle",
            "Perle-Line-Access-Port-49"                => "Perle",
            "Perle-Line-Access-Port-5"                 => "Perle",
            "Perle-Line-Access-Port-6"                 => "Perle",
            "Perle-Line-Access-Port-7"                 => "Perle",
            "Perle-Line-Access-Port-8"                 => "Perle",
            "Perle-Line-Access-Port-9"                 => "Perle",
            "Perle-User-Level"                         => "Perle",
            "pfSense-Bandwidth-Max-Down"               => "pfSense",
            "pfSense-Bandwidth-Max-Up"                 => "pfSense",
            "pfSense-Max-Total-Octets"                 => "pfSense",
            "Pica8-AVPair"                             => "Pica8",
            "Pica8-IP-Downloadable-ACL-Name"           => "Pica8",
            "Pica8-IP-Downloadable-ACL-Rule"           => "Pica8",
            "Pica8-Redirect-URL"                       => "Pica8",
            "Platform-Type"                            => "Ericsson-AB",
            "Police-Burst"                             => "Ericsson-AB",
            "Police-Excess-Burst"                      => "Ericsson-AB",
            "Police-Rate"                              => "Ericsson-AB",
            "PPP-Compression"                          => "Ericsson-AB",
            "PPPoE-IP-Route-Add"                       => "Ericsson-AB",
            "PPPOE-MOTM"                               => "Ericsson-AB",
            "PPPOE-URL"                                => "Ericsson-AB",
            "prev-hop-ip"                              => "Cisco",
            "prev-hop-via"                             => "Cisco",
            "Propel-Accelerate"                        => "Propel",
            "Propel-Client-IP-Address"                 => "Propel",
            "Propel-Client-NAS-IP-Address"             => "Propel",
            "Propel-Client-Source-ID"                  => "Propel",
            "Propel-Content-Filter-ID"                 => "Propel",
            "Propel-Dialed-Digits"                     => "Propel",
            "Prosoft-ATM-Interface"                    => "Prosoft",
            "Prosoft-ATM-VCI"                          => "Prosoft",
            "Prosoft-ATM-VPI"                          => "Prosoft",
            "Prosoft-Auth-Role"                        => "Prosoft",
            "Prosoft-Authentication-Reason"            => "Prosoft",
            "Prosoft-Default-Gateway"                  => "Prosoft",
            "Prosoft-Home-Agent-Address"               => "Prosoft",
            "Prosoft-MAC-Address"                      => "Prosoft",
            "Prosoft-NPM-Identifier"                   => "Prosoft",
            "Prosoft-NPM-IP"                           => "Prosoft",
            "Prosoft-Primary-DNS"                      => "Prosoft",
            "Prosoft-RSC-Identifier"                   => "Prosoft",
            "Prosoft-Secondary-DNS"                    => "Prosoft",
            "Prosoft-Sector-ID"                        => "Prosoft",
            "Prosoft-Security-Key"                     => "Prosoft",
            "Prosoft-Security-Parameter-Index"         => "Prosoft",
            "Proxim_E1_Access_VLAN_ID"                 => "Proxim",
            "Proxim_E1_Access_VLAN_Pri"                => "Proxim",
            "Proxim_E1_Allow_Untag"                    => "Proxim",
            "Proxim_E1_Port_VLAN_ID"                   => "Proxim",
            "Proxim_E1_Port_VLAN_Pri"                  => "Proxim",
            "Proxim_E1_SU_Allow_Untag_Mgmt"            => "Proxim",
            "Proxim_E1_TrunkID_01"                     => "Proxim",
            "Proxim_E1_TrunkID_02"                     => "Proxim",
            "Proxim_E1_TrunkID_03"                     => "Proxim",
            "Proxim_E1_TrunkID_04"                     => "Proxim",
            "Proxim_E1_TrunkID_05"                     => "Proxim",
            "Proxim_E1_TrunkID_06"                     => "Proxim",
            "Proxim_E1_TrunkID_07"                     => "Proxim",
            "Proxim_E1_TrunkID_08"                     => "Proxim",
            "Proxim_E1_TrunkID_09"                     => "Proxim",
            "Proxim_E1_TrunkID_10"                     => "Proxim",
            "Proxim_E1_TrunkID_11"                     => "Proxim",
            "Proxim_E1_TrunkID_12"                     => "Proxim",
            "Proxim_E1_TrunkID_13"                     => "Proxim",
            "Proxim_E1_TrunkID_14"                     => "Proxim",
            "Proxim_E1_TrunkID_15"                     => "Proxim",
            "Proxim_E1_TrunkID_16"                     => "Proxim",
            "Proxim_E1_VLAN_MODE"                      => "Proxim",
            "Proxim_E2_Access_VLAN_ID"                 => "Proxim",
            "Proxim_E2_Access_VLAN_Pri"                => "Proxim",
            "Proxim_E2_Allow_Untag"                    => "Proxim",
            "Proxim_E2_Port_VLAN_ID"                   => "Proxim",
            "Proxim_E2_Port_VLAN_Pri"                  => "Proxim",
            "Proxim_E2_SU_Allow_Untag_Mgmt"            => "Proxim",
            "Proxim_E2_TrunkID_01"                     => "Proxim",
            "Proxim_E2_TrunkID_02"                     => "Proxim",
            "Proxim_E2_TrunkID_03"                     => "Proxim",
            "Proxim_E2_TrunkID_04"                     => "Proxim",
            "Proxim_E2_TrunkID_05"                     => "Proxim",
            "Proxim_E2_TrunkID_06"                     => "Proxim",
            "Proxim_E2_TrunkID_07"                     => "Proxim",
            "Proxim_E2_TrunkID_08"                     => "Proxim",
            "Proxim_E2_TrunkID_09"                     => "Proxim",
            "Proxim_E2_TrunkID_10"                     => "Proxim",
            "Proxim_E2_TrunkID_11"                     => "Proxim",
            "Proxim_E2_TrunkID_12"                     => "Proxim",
            "Proxim_E2_TrunkID_13"                     => "Proxim",
            "Proxim_E2_TrunkID_14"                     => "Proxim",
            "Proxim_E2_TrunkID_15"                     => "Proxim",
            "Proxim_E2_TrunkID_16"                     => "Proxim",
            "Proxim_E2_VLAN_MODE"                      => "Proxim",
            "Proxim_Mgmt_VLAN_ID"                      => "Proxim",
            "Proxim_Mgmt_VLAN_Pri"                     => "Proxim",
            "Proxim_QinQ_Status"                       => "Proxim",
            "Proxim_QoS_Class_Index"                   => "Proxim",
            "Proxim_QoS_Class_SU_Status"               => "Proxim",
            "Proxim_Service_VLAN_ID"                   => "Proxim",
            "Proxim_Service_VLAN_Pri"                  => "Proxim",
            "Proxim_Service_VLAN_TPID"                 => "Proxim",
            "Proxim_SU_VLAN_NAME"                      => "Proxim",
            "Proxim_SU_VLAN_Table_Status"              => "Proxim",
            "Purewave-Client-Profile"                  => "Purewave",
            "Purewave-CS-Type"                         => "Purewave",
            "Purewave-IP-Address"                      => "Purewave",
            "Purewave-IP-Netmask"                      => "Purewave",
            "Purewave-Max-Downlink-Rate"               => "Purewave",
            "Purewave-Max-Uplink-Rate"                 => "Purewave",
            "Purewave-Service-Enable"                  => "Purewave",
            "PVC-Circuit-Padding"                      => "Ericsson-AB",
            "PVC-Encapsulation-Type"                   => "Ericsson-AB",
            "PVC-Profile-Name"                         => "Ericsson-AB",
            "Qos-Metering-Profile-Name"                => "Ericsson-AB",
            "Qos-Policing-Profile-Name"                => "Ericsson-AB",
            "Qos-Policy-Queuing"                       => "Ericsson-AB",
            "Qos-Profile-Overhead"                     => "Ericsson-AB",
            "Qos-Rate"                                 => "Ericsson-AB",
            "QOS-Rate-Inbound"                         => "Ericsson-AB",
            "QOS-Rate-Outbound"                        => "Ericsson-AB",
            "QOS-Reference"                            => "Ericsson-AB",
            "Quiconnect-AVPair"                        => "Quiconnect",
            "Quiconnect-HSP-Information"               => "Quiconnect",
            "Quiconnect-VNP-Information"               => "Quiconnect",
            "Quintum-AVPair"                           => "Quintum",
            "Quintum-h323-billing-model"               => "Quintum",
            "Quintum-h323-call-origin"                 => "Quintum",
            "Quintum-h323-call-type"                   => "Quintum",
            "Quintum-h323-conf-id"                     => "Quintum",
            "Quintum-h323-connect-time"                => "Quintum",
            "Quintum-h323-credit-amount"               => "Quintum",
            "Quintum-h323-credit-time"                 => "Quintum",
            "Quintum-h323-currency-type"               => "Quintum",
            "Quintum-h323-disconnect-cause"            => "Quintum",
            "Quintum-h323-disconnect-time"             => "Quintum",
            "Quintum-h323-gw-id"                       => "Quintum",
            "Quintum-h323-incoming-conf-id"            => "Quintum",
            "Quintum-h323-preferred-lang"              => "Quintum",
            "Quintum-h323-prompt-id"                   => "Quintum",
            "Quintum-h323-redirect-ip-address"         => "Quintum",
            "Quintum-h323-redirect-number"             => "Quintum",
            "Quintum-h323-remote-address"              => "Quintum",
            "Quintum-h323-return-code"                 => "Quintum",
            "Quintum-h323-setup-time"                  => "Quintum",
            "Quintum-h323-time-and-day"                => "Quintum",
            "Quintum-h323-voice-quality"               => "Quintum",
            "Quintum-NAS-Port"                         => "Quintum",
            "Quintum-Trunkid-In"                       => "Quintum",
            "Quintum-Trunkid-Out"                      => "Quintum",
            "Radius-Throttle-Watermark"                => "Ericsson-AB",
            "Rate-Limit-Burst"                         => "Ericsson-AB",
            "Rate-Limit-Excess-Burst"                  => "Ericsson-AB",
            "Rate-Limit-Rate"                          => "Ericsson-AB",
            "RB-IPV6-DNS"                              => "Ericsson-AB",
            "RB-IPv6-Option"                           => "Ericsson-AB",
            "RB-NPM-Service-Id"                        => "Ericsson-AB",
            "RCNTEC-RPCM-Group"                        => "RCNTEC",
            "RCNTEC-RPCM-Session-Expire"               => "RCNTEC",
            "Reauth"                                   => "Ericsson-AB",
            "Reauth-More"                              => "Ericsson-AB",
            "Reauth-Service-Name"                      => "Ericsson-AB",
            "Reauth-Session-Id"                        => "Ericsson-AB",
            "Redback-Reason"                           => "Ericsson-AB",
            "RedCreek-Tunneled-DNS-Server"             => "RedCreek",
            "RedCreek-Tunneled-DomainName"             => "RedCreek",
            "RedCreek-Tunneled-Gateway"                => "RedCreek",
            "RedCreek-Tunneled-HostName"               => "RedCreek",
            "RedCreek-Tunneled-IP-Addr"                => "RedCreek",
            "RedCreek-Tunneled-IP-Netmask"             => "RedCreek",
            "RedCreek-Tunneled-Search-List"            => "RedCreek",
            "RedCreek-Tunneled-WINS-Server1"           => "RedCreek",
            "RedCreek-Tunneled-WINS-Server2"           => "RedCreek",
            "release-source"                           => "Cisco",
            "remote-media-address"                     => "Cisco",
            "Remote-Port"                              => "Ericsson-AB",
            "Riverbed-Local-User"                      => "Riverbed",
            "Riverstone-Command"                       => "Riverstone",
            "Riverstone-SNMP-Config-Change"            => "Riverstone",
            "Riverstone-System-Event"                  => "Riverstone",
            "Riverstone-User-Level"                    => "Riverstone",
            "Route-Tag"                                => "Ericsson-AB",
            "RP-Downstream-Speed-Limit"                => "Roaring-Penguin",
            "RP-HURL"                                  => "Roaring-Penguin",
            "RP-Max-Sessions-Per-User"                 => "Roaring-Penguin",
            "RP-MOTM"                                  => "Roaring-Penguin",
            "RP-Upstream-Speed-Limit"                  => "Roaring-Penguin",
            "Ruckus-AAA-Id"                            => "Ruckus",
            "Ruckus-AAA-IP"                            => "Ruckus",
            "Ruckus-Accept-Enhancement-Reason"         => "Ruckus",
            "Ruckus-Accounting-Status"                 => "Ruckus",
            "Ruckus-Acct-Ctrs_Input-Octets"            => "Ruckus",
            "Ruckus-Acct-Ctrs_Input-Packets"           => "Ruckus",
            "Ruckus-Acct-Ctrs_Output-Octets"           => "Ruckus",
            "Ruckus-Acct-Ctrs_Output-Packets"          => "Ruckus",
            "Ruckus-Acct-Ctrs_TC-Name"                 => "Ruckus",
            "Ruckus-AP-Roamed"                         => "Ruckus",
            "Ruckus-APN-NI"                            => "Ruckus",
            "Ruckus-APN-OI"                            => "Ruckus",
            "Ruckus-APN-Resolution-Req"                => "Ruckus",
            "Ruckus-Area-Code"                         => "Ruckus",
            "Ruckus-Auth-Server-Id"                    => "Ruckus",
            "Ruckus-Auth-Type"                         => "Ruckus",
            "Ruckus-Brand-Code"                        => "Ruckus",
            "Ruckus-BSSID"                             => "Ruckus",
            "Ruckus-CDR-TYPE"                          => "Ruckus",
            "Ruckus-Cell-Identifier"                   => "Ruckus",
            "Ruckus-Charging-Charac"                   => "Ruckus",
            "Ruckus-ChCh-Selection-Mode"               => "Ruckus",
            "Ruckus-Client-Host-Name"                  => "Ruckus",
            "Ruckus-Client-Local-IP"                   => "Ruckus",
            "Ruckus-Client-Os-Class"                   => "Ruckus",
            "Ruckus-Client-Os-Type"                    => "Ruckus",
            "Ruckus-CP-Token"                          => "Ruckus",
            "Ruckus-Dpsk"                              => "Ruckus",
            "Ruckus-DPSK"                              => "Ruckus",
            "Ruckus-DPSK-AKM-Suite"                    => "Ruckus",
            "Ruckus-DPSK-Anonce"                       => "Ruckus",
            "Ruckus-DPSK-Cipher"                       => "Ruckus",
            "Ruckus-DPSK-EAPOL-Key-Frame"              => "Ruckus",
            "Ruckus-DPSK-Params"                       => "Ruckus",
            "Ruckus-Dynamic-Address-Flag"              => "Ruckus",
            "Ruckus-Eth-Profile-Id"                    => "Ruckus",
            "Ruckus-FlexAuth-AVP"                      => "Ruckus",
            "Ruckus-Gn-User-Name"                      => "Ruckus",
            "Ruckus-Grace-Period"                      => "Ruckus",
            "Ruckus-IMSI"                              => "Ruckus",
            "Ruckus-Location"                          => "Ruckus",
            "Ruckus-Max-DL-UL-Quota"                   => "Ruckus",
            "Ruckus-MSISDN"                            => "Ruckus",
            "Ruckus-NAS-Type"                          => "Ruckus",
            "Ruckus-Nat-Pool-Name"                     => "Ruckus",
            "Ruckus-PDP-Type"                          => "Ruckus",
            "Ruckus-Policy-Name"                       => "Ruckus",
            "Ruckus-QoS"                               => "Ruckus",
            "Ruckus-Read-Preference"                   => "Ruckus",
            "Ruckus-SCG-CBlade-IP"                     => "Ruckus",
            "Ruckus-SCG-DBlade-IP"                     => "Ruckus",
            "Ruckus-SCI-Resource-Group"                => "Ruckus",
            "Ruckus-SCI-Role"                          => "Ruckus",
            "Ruckus-Selection-Mode"                    => "Ruckus",
            "Ruckus-Session-Type"                      => "Ruckus",
            "Ruckus-SGSN-IP"                           => "Ruckus",
            "Ruckus-SGSN-Number"                       => "Ruckus",
            "Ruckus-SSID"                              => "Ruckus",
            "Ruckus-Sta-Expiration"                    => "Ruckus",
            "Ruckus-Sta-Inner-Id"                      => "Ruckus",
            "Ruckus-Sta-RSSI"                          => "Ruckus",
            "Ruckus-Sta-SVlan-Id"                      => "Ruckus",
            "Ruckus-Sta-UUID"                          => "Ruckus",
            "Ruckus-Start-Time"                        => "Ruckus",
            "Ruckus-Status"                            => "Ruckus",
            "Ruckus-TC-Acct-Ctrs"                      => "Ruckus",
            "Ruckus-TC-Attr-Ids-With-Quota"            => "Ruckus",
            "Ruckus-TC-Name-Quota"                     => "Ruckus",
            "Ruckus-TC-Quota"                          => "Ruckus",
            "Ruckus-Traffic-Class-Attribute-Ids"       => "Ruckus",
            "Ruckus-Triplets"                          => "Ruckus",
            "Ruckus-User-Groups"                       => "Ruckus",
            "Ruckus-Utp-Id"                            => "Ruckus",
            "Ruckus-VLAN-ID"                           => "Ruckus",
            "Ruckus-Vlan-Pool"                         => "Ruckus",
            "Ruckus-Wispr-Redirect-Policy"             => "Ruckus",
            "Ruckus-Wlan-Id"                           => "Ruckus",
            "Ruckus-Wlan-Name"                         => "Ruckus",
            "Ruckus-WSG-User"                          => "Ruckus",
            "Ruckus-Zone-Id"                           => "Ruckus",
            "Ruckus-Zone-Name"                         => "Ruckus",
            "RuggedCom-Privilege-level"                => "RuggedCom",
            "SAML-AAA-Assertion"                       => "UKERNA",
            "SBC-Adjacency"                            => "Ericsson-AB",
            "Sdx-Service-Name"                         => "ERX",
            "Sdx-Session-Volume-Quota"                 => "ERX",
            "Sdx-Tunnel-Disconnect-Cause-Info"         => "ERX",
            "Security-Service"                         => "Ericsson-AB",
            "Service-Action"                           => "Ericsson-AB",
            "Service-Data-Container"                   => "VerizonWireless",
            "Service-Data-Container-Bin"               => "VerizonWireless",
            "Service-Error-Cause"                      => "Ericsson-AB",
            "Service-Name"                             => "Ericsson-AB",
            "Service-Parameter"                        => "Ericsson-AB",
            "Session-Error-Code"                       => "Ericsson-AB",
            "Session-Error-Msg"                        => "Ericsson-AB",
            "session-protocol"                         => "Cisco",
            "Session-Traffic-Limit"                    => "Ericsson-AB",
            "SG-Accounting"                            => "SG",
            "SG-Acl-Data-Quota"                        => "SG",
            "SG-Acl-Data-Quota-Used"                   => "SG",
            "SG-Acl-Down-Mean-Rate"                    => "SG",
            "SG-Acl-Eds-Action"                        => "SG",
            "SG-Acl-Idle-Ignore"                       => "SG",
            "SG-Acl-Next-Hop"                          => "SG",
            "SG-Acl-Packet-Quota"                      => "SG",
            "SG-Acl-Packet-Quota-Used"                 => "SG",
            "SG-Acl-Priority"                          => "SG",
            "SG-Acl-Tcp-Nat-Redirect"                  => "SG",
            "SG-Acl-Up-Mean-Rate"                      => "SG",
            "SG-Action"                                => "SG",
            "SG-Advertise-Protocol"                    => "SG",
            "SG-Auth-Source"                           => "SG",
            "SG-Auth-Type"                             => "SG",
            "SG-Auto-Service-Name"                     => "SG",
            "SG-Burst-Size"                            => "SG",
            "SG-Class"                                 => "SG",
            "SG-Cos"                                   => "SG",
            "SG-Data-Quota"                            => "SG",
            "SG-Data-Quota-Used"                       => "SG",
            "SG-Dhcp-Server"                           => "SG",
            "SG-Discover-Action"                       => "SG",
            "SG-Down-Mean-Rate"                        => "SG",
            "SG-Eds-Cookie"                            => "SG",
            "SG-Eds-Enc-Key"                           => "SG",
            "SG-Filter-Redirect-Gw"                    => "SG",
            "SG-Fixed-Ip-Address"                      => "SG",
            "SG-Forward-Addr"                          => "SG",
            "SG-Ip-Address"                            => "SG",
            "SG-Ip-Primary"                            => "SG",
            "SG-Ip-Secondary"                          => "SG",
            "SG-Ip-Tunnel"                             => "SG",
            "SG-L2tp-Tunnel-Password"                  => "SG",
            "SG-Lease-Time"                            => "SG",
            "SG-Mac-Address"                           => "SG",
            "SG-Max-Allowed-Nodes"                     => "SG",
            "SG-Max-Allowed-Sessions"                  => "SG",
            "SG-Nativeip"                              => "SG",
            "SG-Next-Hop"                              => "SG",
            "SG-Next-Service-Name"                     => "SG",
            "SG-Nip-Pipe-Next-Hop"                     => "SG",
            "SG-Node-Acct-Username"                    => "SG",
            "SG-Node-Default-Service"                  => "SG",
            "SG-Node-Dynamic-Service"                  => "SG",
            "SG-Node-Fixed-Ip-Address"                 => "SG",
            "SG-Node-Group"                            => "SG",
            "SG-Opt82-Relay-Remote-Id"                 => "SG",
            "SG-Orig-Name"                             => "SG",
            "SG-Original-Url-Prefix"                   => "SG",
            "SG-Parent-User-Name"                      => "SG",
            "SG-Personal-Site"                         => "SG",
            "SG-Protocol-Type"                         => "SG",
            "SG-Release-Action"                        => "SG",
            "SG-Remote-Filter-Redirect-Gw"             => "SG",
            "SG-Roaming"                               => "SG",
            "SG-Service-Acl-Quota-Ignore"              => "SG",
            "SG-Service-Acl-Quota-Indication"          => "SG",
            "SG-Service-Cache"                         => "SG",
            "SG-Service-Name"                          => "SG",
            "SG-Service-Quota-Ignore"                  => "SG",
            "SG-Service-Timeout"                       => "SG",
            "SG-SSC-Host"                              => "SG",
            "SG-Tunnel-Assignment-Id"                  => "SG",
            "SG-Tunnel-Client-Ip-Address"              => "SG",
            "SG-Tunnel-Id"                             => "SG",
            "SG-Up-Mean-Rate"                          => "SG",
            "SG-User-Group"                            => "SG",
            "SG-Wimax-Acl-ARQ-Enable"                  => "SG",
            "SG-Wimax-Acl-Maximum-Latency"             => "SG",
            "SG-Wimax-Acl-Maximum-Traffic-Burst"       => "SG",
            "SG-Wimax-Acl-Min-Reserved-Traffic-Rate"   => "SG",
            "SG-Wimax-Acl-Schedule-Type"               => "SG",
            "SG-Wimax-Acl-Sdu-Size"                    => "SG",
            "SG-Wimax-Acl-Tolerated-Jitter"            => "SG",
            "SG-Wimax-Acl-Unsolicited-Grant-Int"       => "SG",
            "SG-Wimax-Acl-Unsolicited-Polling-Int"     => "SG",
            "SG-Wimax-Bsid-Next-Hop"                   => "SG",
            "SG-Wimax-DM-Action-Code"                  => "SG",
            "SG-Wimax-Mobility-Features-Supported"     => "SG",
            "SG-Wimax-MSK-Lifetime"                    => "SG",
            "SG-Wimax-Node-Disconnect"                 => "SG",
            "SG-Wimax-Reduced-Resources"               => "SG",
            "SG-Wimax-Service-Flow-Down"               => "SG",
            "SG-Wimax-Service-Flow-Modification"       => "SG",
            "Shaping-Profile-Name"                     => "Ericsson-AB",
            "Shasta-Service-Profile"                   => "Shasta",
            "Shasta-User-Privilege"                    => "Shasta",
            "Shasta-VPN-Name"                          => "Shasta",
            "Shiva-Acct-Serv-Switch"                   => "Shiva",
            "Shiva-Bak-Key"                            => "Shiva",
            "Shiva-Bandwidth-Trap"                     => "Shiva",
            "Shiva-Break-Key"                          => "Shiva",
            "Shiva-Call-Durn-Trap"                     => "Shiva",
            "Shiva-Called-Number"                      => "Shiva",
            "Shiva-Calling-Number"                     => "Shiva",
            "Shiva-Circuit-Type"                       => "Shiva",
            "Shiva-Compression"                        => "Shiva",
            "Shiva-Compression-Type"                   => "Shiva",
            "Shiva-Connect-Reason"                     => "Shiva",
            "Shiva-Customer-Id"                        => "Shiva",
            "Shiva-Default-Host"                       => "Shiva",
            "Shiva-DHCP-Leasetime"                     => "Shiva",
            "Shiva-Dial-Timeout"                       => "Shiva",
            "Shiva-Dialback-Delay"                     => "Shiva",
            "Shiva-Disconnect-Reason"                  => "Shiva",
            "Shiva-Event-Flags"                        => "Shiva",
            "Shiva-Function"                           => "Shiva",
            "Shiva-Fwd-Key"                            => "Shiva",
            "Shiva-LAT-Groups"                         => "Shiva",
            "Shiva-LAT-Port"                           => "Shiva",
            "Shiva-Link-Protocol"                      => "Shiva",
            "Shiva-Link-Speed"                         => "Shiva",
            "Shiva-Links-In-Bundle"                    => "Shiva",
            "Shiva-Max-VCs"                            => "Shiva",
            "Shiva-Menu-Name"                          => "Shiva",
            "Shiva-Minimum-Call"                       => "Shiva",
            "Shiva-Network-Protocols"                  => "Shiva",
            "Shiva-RTC-Timestamp"                      => "Shiva",
            "Shiva-Session-Id"                         => "Shiva",
            "Shiva-Termtype"                           => "Shiva",
            "Shiva-Type-Of-Service"                    => "Shiva",
            "Shiva-User-Attributes"                    => "Shiva",
            "Shiva-User-Flags"                         => "Shiva",
            "SID-Auth"                                 => "BT",
            "Siemens-AP-Name"                          => "Siemens",
            "Siemens-AP-Serial"                        => "Siemens",
            "Siemens-BSS-MAC"                          => "Siemens",
            "Siemens-Egress-RC-Name"                   => "Siemens",
            "Siemens-Ingress-RC-Name"                  => "Siemens",
            "Siemens-Policy-Name"                      => "Siemens",
            "Siemens-SSID"                             => "Siemens",
            "Siemens-Topology-Name"                    => "Siemens",
            "Siemens-URL-Redirection"                  => "Siemens",
            "Siemens-VNS-Name"                         => "Siemens",
            "sip-conf-id"                              => "Cisco",
            "Sip-From"                                 => "Columbia-University",
            "sip-hdr"                                  => "Cisco",
            "Sip-Method"                               => "Columbia-University",
            "Sip-To"                                   => "Columbia-University",
            "Sip-Translated-Request-URI"               => "Columbia-University",
            "Sky-Wifi-AP-ID"                           => "BSkyB",
            "Sky-Wifi-Billing-Class"                   => "BSkyB",
            "Sky-Wifi-Credentials"                     => "BSkyB",
            "Sky-Wifi-Filter-Profile"                  => "BSkyB",
            "Sky-Wifi-Protocol-Restriction"            => "BSkyB",
            "Sky-Wifi-Provider-ID"                     => "BSkyB",
            "Sky-Wifi-Replicated-Packet"               => "BSkyB",
            "Sky-Wifi-Service-ID"                      => "BSkyB",
            "Slipstream-Auth"                          => "Slipstream",
            "SN-Access-link-IP-Frag"                   => "Starent",
            "SN-Acct-Input-Giga-Dropped"               => "Starent",
            "SN-Acct-Input-Octets-Dropped"             => "Starent",
            "SN-Acct-Input-Packets-Dropped"            => "Starent",
            "SN-Acct-Output-Giga-Dropped"              => "Starent",
            "SN-Acct-Output-Octets-Dropped"            => "Starent",
            "SN-Acct-Output-Packets-Dropped"           => "Starent",
            "SN-Acs-Credit-Control-Group"              => "Starent",
            "SN-Admin-Expiry"                          => "Starent",
            "SN-Admin-Permission"                      => "Starent",
            "SN-ANID"                                  => "Starent",
            "SN-Assigned-VLAN-ID"                      => "Starent",
            "SN-Authorised-Qos"                        => "Starent",
            "SN-Bandwidth-Policy"                      => "Starent",
            "SN-Call-Id"                               => "Starent",
            "SN-Cause-Code"                            => "Starent",
            "SN-Cause-For-Rec-Closing"                 => "Starent",
            "SN-CBB-Policy"                            => "Starent",
            "SN-CF-Call-International"                 => "Starent",
            "SN-CF-Call-Local"                         => "Starent",
            "SN-CF-Call-LongDistance"                  => "Starent",
            "SN-CF-Call-Premium"                       => "Starent",
            "SN-CF-Call-RoamingInternatnl"             => "Starent",
            "SN-CF-Call-Transfer"                      => "Starent",
            "SN-CF-Call-Waiting"                       => "Starent",
            "SN-CF-CId-Display"                        => "Starent",
            "SN-CF-CId-Display-Blocked"                => "Starent",
            "SN-CF-Follow-Me"                          => "Starent",
            "SN-CF-Forward-Busy-Line"                  => "Starent",
            "SN-CF-Forward-No-Answer"                  => "Starent",
            "SN-CF-Forward-Not-Regd"                   => "Starent",
            "SN-CF-Forward-Unconditional"              => "Starent",
            "SN-CFPolicy-ID"                           => "Starent",
            "SN-Change-Condition"                      => "Starent",
            "SN-Charging-VPN-Name"                     => "Starent",
            "SN-Chrg-Char-Selection-Mode"              => "Starent",
            "SN-Congestion-Mgmt-Policy"                => "Starent",
            "SN-Content-Disposition"                   => "Starent",
            "SN-Content-Length"                        => "Starent",
            "SN-Content-Type"                          => "Starent",
            "SN-CR-International-Cid"                  => "Starent",
            "SN-CR-LongDistance-Cid"                   => "Starent",
            "SN-CSCF-App-Server-Info"                  => "Starent",
            "SN-CSCF-Rf-SDP-Media-Components"          => "Starent",
            "SN-Cscf-Subscriber-Ip-Address"            => "Starent",
            "SN-Data-Tunnel-Ignore-DF-Bit"             => "Starent",
            "SN-DHCP-Lease-Expiry-Policy"              => "Starent",
            "SN-DHCP-Options"                          => "Starent",
            "SN-Direction"                             => "Starent",
            "SN-Disconnect-Reason"                     => "Starent",
            "SN-DNS-Proxy-Intercept-List"              => "Starent",
            "SN-DNS-Proxy-Use-Subscr-Addr"             => "Starent",
            "SN-Dynamic-Addr-Alloc-Ind-Flag"           => "Starent",
            "SN-Ecs-Data-Volume"                       => "Starent",
            "SN-Enable-QoS-Renegotiation"              => "Starent",
            "SN-Event"                                 => "Starent",
            "SN-Ext-Inline-Srvr-Context"               => "Starent",
            "SN-Ext-Inline-Srvr-Down-Addr"             => "Starent",
            "SN-Ext-Inline-Srvr-Down-VLAN"             => "Starent",
            "SN-Ext-Inline-Srvr-Preference"            => "Starent",
            "SN-Ext-Inline-Srvr-Up-Addr"               => "Starent",
            "SN-Ext-Inline-Srvr-Up-VLAN"               => "Starent",
            "SN-Fast-Reauth-Username"                  => "Starent",
            "SN-Firewall-Enabled"                      => "Starent",
            "SN-Firewall-Policy"                       => "Starent",
            "SN-FMC-Location"                          => "Starent",
            "SN-GGSN-Address"                          => "Starent",
            "SN-GGSN-MIP-Required"                     => "Starent",
            "SN-Gratuitous-ARP-Aggressive"             => "Starent",
            "SN-GTP-Version"                           => "Starent",
            "SN-HA-Send-DNS-ADDRESS"                   => "Starent",
            "SN-Handoff-Indicator"                     => "Starent",
            "SN-Home-Behavior"                         => "Starent",
            "SN-Home-Profile"                          => "Starent",
            "SN-Home-Sub-Use-GGSN"                     => "Starent",
            "SN-IMS-AM-Address"                        => "Starent",
            "SN-IMS-AM-Domain-Name"                    => "Starent",
            "SN-IMS-Charging-Identifier"               => "Starent",
            "SN-IMSI"                                  => "Starent",
            "SN-Internal-SM-Index"                     => "Starent",
            "SN-IP-Alloc-Method"                       => "Starent",
            "SN-IP-Filter-In"                          => "Starent",
            "SN-IP-Filter-Out"                         => "Starent",
            "SN-IP-Header-Compression"                 => "Starent",
            "SN-IP-Hide-Service-Address"               => "Starent",
            "SN-IP-In-ACL"                             => "Starent",
            "SN-IP-In-Plcy-Grp"                        => "Starent",
            "SN-IP-Out-ACL"                            => "Starent",
            "SN-IP-Out-Plcy-Grp"                       => "Starent",
            "SN-IP-Pool-Name"                          => "Starent",
            "SN-IP-Source-Validation"                  => "Starent",
            "SN-IP-Source-Violate-No-Acct"             => "Starent",
            "SN-IP-Src-Validation-Drop-Limit"          => "Starent",
            "SN-IPv6-Alloc-Method"                     => "Starent",
            "SN-IPv6-DNS-Proxy"                        => "Starent",
            "SN-IPv6-Egress-Filtering"                 => "Starent",
            "SN-IPv6-Min-Link-MTU"                     => "Starent",
            "SN-IPv6-num-rtr-advt"                     => "Starent",
            "SN-IPv6-Primary-DNS"                      => "Starent",
            "SN-IPv6-rtr-advt-interval"                => "Starent",
            "SN-IPv6-Sec-Pool"                         => "Starent",
            "SN-IPv6-Sec-Prefix"                       => "Starent",
            "SN-IPv6-Secondary-DNS"                    => "Starent",
            "SN-Is-Unregistered-Subscriber"            => "Starent",
            "SN-ISC-Template-Name"                     => "Starent",
            "SN-L3-to-L2-Tun-Addr-Policy"              => "Starent",
            "SN-Local-IP-Address"                      => "Starent",
            "SN-Long-Duration-Action"                  => "Starent",
            "SN-Long-Duration-Notification"            => "Starent",
            "SN-Long-Duration-Timeout"                 => "Starent",
            "SN-Max-Sec-Contexts-Per-Subs"             => "Starent",
            "SN-Mediation-Acct-Rsp-Action"             => "Starent",
            "SN-Mediation-Enabled"                     => "Starent",
            "SN-Mediation-No-Interims"                 => "Starent",
            "SN-Mediation-VPN-Name"                    => "Starent",
            "SN-Min-Compress-Size"                     => "Starent",
            "SN-MIP-AAA-Assign-Addr"                   => "Starent",
            "SN-MIP-ANCID"                             => "Starent",
            "SN-MIP-Dual-Anchor"                       => "Starent",
            "SN-MIP-HA-Assignment-Table"               => "Starent",
            "SN-MIP-Match-AAA-Assign-Addr"             => "Starent",
            "SN-MIP-Reg-Lifetime-Realm"                => "Starent",
            "SN-MIP-Send-Ancid"                        => "Starent",
            "SN-MIP-Send-Correlation-Info"             => "Starent",
            "SN-MIP-Send-Imsi"                         => "Starent",
            "SN-MIP-Send-Term-Verification"            => "Starent",
            "SN-MN-HA-Hash-Algorithm"                  => "Starent",
            "SN-MN-HA-Timestamp-Tolerance"             => "Starent",
            "SN-Mode"                                  => "Starent",
            "SN-MS-ISDN"                               => "Starent",
            "SN-NAI-Construction-Domain"               => "Starent",
            "SN-NAT-IP-Address"                        => "Starent",
            "SN-Node-Functionality"                    => "Starent",
            "SN-NPU-Qos-Priority"                      => "Starent",
            "SN-Ntk-Initiated-Ctx-Ind-Flag"            => "Starent",
            "SN-Ntk-Session-Disconnect-Flag"           => "Starent",
            "SN-Nw-Reachability-Server-Name"           => "Starent",
            "SN-Originating-IOI"                       => "Starent",
            "SN-Overload-Disc-Connect-Time"            => "Starent",
            "SN-Overload-Disconnect"                   => "Starent",
            "SN-PDG-TTG-Required"                      => "Starent",
            "SN-PDIF-MIP-Release-TIA"                  => "Starent",
            "SN-PDIF-MIP-Required"                     => "Starent",
            "SN-PDIF-MIP-Simple-IP-Fallback"           => "Starent",
            "SN-PDSN-Correlation-Id"                   => "Starent",
            "SN-PDSN-Handoff-Req-IP-Addr"              => "Starent",
            "SN-PDSN-NAS-Id"                           => "Starent",
            "SN-PDSN-NAS-IP-Address"                   => "Starent",
            "SN-Permit-User-Mcast-PDUs"                => "Starent",
            "SN-PPP-Accept-Peer-v6Ifid"                => "Starent",
            "SN-PPP-Always-On-Vse"                     => "Starent",
            "SN-PPP-Data-Compression"                  => "Starent",
            "SN-PPP-Data-Compression-Mode"             => "Starent",
            "SN-PPP-Keepalive"                         => "Starent",
            "SN-PPP-NW-Layer-IPv4"                     => "Starent",
            "SN-PPP-NW-Layer-IPv6"                     => "Starent",
            "SN-PPP-Outbound-Password"                 => "Starent",
            "SN-PPP-Outbound-Username"                 => "Starent",
            "SN-PPP-Progress-Code"                     => "Starent",
            "SN-PPP-Reneg-Disc"                        => "Starent",
            "SN-Prepaid"                               => "Starent",
            "SN-Prepaid-Compressed-Count"              => "Starent",
            "SN-Prepaid-Final-Duration-Alg"            => "Starent",
            "SN-Prepaid-Inbound-Octets"                => "Starent",
            "SN-Prepaid-Outbound-Octets"               => "Starent",
            "SN-Prepaid-Preference"                    => "Starent",
            "SN-Prepaid-Timeout"                       => "Starent",
            "SN-Prepaid-Total-Octets"                  => "Starent",
            "SN-Prepaid-Watermark"                     => "Starent",
            "SN-Primary-DCCA-Peer"                     => "Starent",
            "SN-Primary-DNS-Server"                    => "Starent",
            "SN-Primary-NBNS-Server"                   => "Starent",
            "SN-Proxy-MIP"                             => "Starent",
            "SN-Proxy-MIPV6"                           => "Starent",
            "SN-Pseudonym-Username"                    => "Starent",
            "SN-QoS-Background-Class"                  => "Starent",
            "SN-QoS-Class-Background-PHB"              => "Starent",
            "SN-QoS-Class-Conversational-PHB"          => "Starent",
            "SN-QoS-Class-Interactive-1-PHB"           => "Starent",
            "SN-QoS-Class-Interactive-2-PHB"           => "Starent",
            "SN-QoS-Class-Interactive-3-PHB"           => "Starent",
            "SN-QoS-Class-Streaming-PHB"               => "Starent",
            "SN-QoS-Conversation-Class"                => "Starent",
            "SN-QOS-HLR-Profile"                       => "Starent",
            "SN-QoS-Interactive1-Class"                => "Starent",
            "SN-QoS-Interactive2-Class"                => "Starent",
            "SN-QoS-Interactive3-Class"                => "Starent",
            "SN-QoS-Negotiated"                        => "Starent",
            "SN-QoS-Renegotiation-Timeout"             => "Starent",
            "SN-QoS-Streaming-Class"                   => "Starent",
            "SN-QoS-Tp-Dnlk"                           => "Starent",
            "SN-QoS-Tp-Uplk"                           => "Starent",
            "SN-QoS-Traffic-Policy"                    => "Starent",
            "SN-Rad-APN-Name"                          => "Starent",
            "SN-Radius-Returned-Username"              => "Starent",
            "SN-Re-CHAP-Interval"                      => "Starent",
            "SN-Roaming-Behavior"                      => "Starent",
            "SN-Roaming-Profile"                       => "Starent",
            "SN-Roaming-Sub-Use-GGSN"                  => "Starent",
            "SN-ROHC-Flow-Marking-Mode"                => "Starent",
            "SN-ROHC-Profile-Name"                     => "Starent",
            "SN-Role-Of-Node"                          => "Starent",
            "SN-Routing-Area-Id"                       => "Starent",
            "SN-Rulebase"                              => "Starent",
            "SN-SDP-Session-Description"               => "Starent",
            "SN-Sec-IP-Pool-Name"                      => "Starent",
            "SN-Secondary-DCCA-Peer"                   => "Starent",
            "SN-Secondary-DNS-Server"                  => "Starent",
            "SN-Secondary-NBNS-Server"                 => "Starent",
            "SN-Service-Address"                       => "Starent",
            "SN-Service-Type"                          => "Starent",
            "SN-Session-Id"                            => "Starent",
            "SN-Simultaneous-SIP-MIP"                  => "Starent",
            "SN-SIP-Method"                            => "Starent",
            "SN-SIP-Request-Time-Stamp"                => "Starent",
            "SN-SIP-Response-Time-Stamp"               => "Starent",
            "SN-Software-Version"                      => "Starent",
            "SN-Subs-Acc-Flow-Traffic-Valid"           => "Starent",
            "SN-Subs-IMSA-Service-Name"                => "Starent",
            "SN-Subs-VJ-Slotid-Cmp-Neg-Mode"           => "Starent",
            "SN-Subscriber-Accounting"                 => "Starent",
            "SN-Subscriber-Acct-Interim"               => "Starent",
            "SN-Subscriber-Acct-Mode"                  => "Starent",
            "SN-Subscriber-Acct-Rsp-Action"            => "Starent",
            "SN-Subscriber-Acct-Start"                 => "Starent",
            "SN-Subscriber-Acct-Stop"                  => "Starent",
            "SN-Subscriber-Class"                      => "Starent",
            "SN-Subscriber-IP-Hdr-Neg-Mode"            => "Starent",
            "SN-Subscriber-IP-TOS-Copy"                => "Starent",
            "SN-Subscriber-Nexthop-Address"            => "Starent",
            "SN-Subscriber-No-Interims"                => "Starent",
            "SN-Subscriber-Permission"                 => "Starent",
            "SN-Subscriber-Template-Name"              => "Starent",
            "SN-Terminating-IOI"                       => "Starent",
            "SN-Tp-Dnlk-Burst-Size"                    => "Starent",
            "SN-Tp-Dnlk-Committed-Data-Rate"           => "Starent",
            "SN-Tp-Dnlk-Exceed-Action"                 => "Starent",
            "SN-Tp-Dnlk-Peak-Data-Rate"                => "Starent",
            "SN-Tp-Dnlk-Violate-Action"                => "Starent",
            "SN-Tp-Uplk-Burst-Size"                    => "Starent",
            "SN-Tp-Uplk-Committed-Data-Rate"           => "Starent",
            "SN-Tp-Uplk-Exceed-Action"                 => "Starent",
            "SN-Tp-Uplk-Peak-Data-Rate"                => "Starent",
            "SN-Tp-Uplk-Violate-Action"                => "Starent",
            "SN-Traffic-Group"                         => "Starent",
            "SN-TrafficSelector-Class"                 => "Starent",
            "SN-Transparent-Data"                      => "Starent",
            "SN-Tun-Addr-Policy"                       => "Starent",
            "SN-Tunnel-Gn"                             => "Starent",
            "SN-Tunnel-ISAKMP-Crypto-Map"              => "Starent",
            "SN-Tunnel-ISAKMP-Secret"                  => "Starent",
            "SN-Tunnel-Load-Balancing"                 => "Starent",
            "SN-Tunnel-Password"                       => "Starent",
            "SN-Unclassify-List-Name"                  => "Starent",
            "SN-User-Privilege"                        => "Starent",
            "SN-Virtual-APN-Name"                      => "Starent",
            "SN-Visiting-Behavior"                     => "Starent",
            "SN-Visiting-Profile"                      => "Starent",
            "SN-Visiting-Sub-Use-GGSN"                 => "Starent",
            "SN-Voice-Push-List-Name"                  => "Starent",
            "SN-VPN-ID"                                => "Starent",
            "SN-VPN-Name"                              => "Starent",
            "SN-WiMAX-Auth-Only"                       => "Starent",
            "SN-WLAN-AP-Identifier"                    => "Starent",
            "SN-WLAN-UE-Identifier"                    => "Starent",
            "SN-WSG-MIP-Release-TIA"                   => "Starent",
            "SN-WSG-MIP-Required"                      => "Starent",
            "SN-WSG-MIP-Simple-IP-Fallback"            => "Starent",
            "SNA-Input-Gigawords"                      => "Starent",
            "SNA-Output-Gigawords"                     => "Starent",
            "SNA-PPP-Bad-Addr"                         => "Starent",
            "SNA-PPP-Bad-Ctrl"                         => "Starent",
            "SNA-PPP-Bad-FCS"                          => "Starent",
            "SNA-PPP-Ctrl-Input-Octets"                => "Starent",
            "SNA-PPP-Ctrl-Input-Packets"               => "Starent",
            "SNA-PPP-Ctrl-Output-Octets"               => "Starent",
            "SNA-PPP-Ctrl-Output-Packets"              => "Starent",
            "SNA-PPP-Discards-Input"                   => "Starent",
            "SNA-PPP-Discards-Output"                  => "Starent",
            "SNA-PPP-Echo-Req-Input"                   => "Starent",
            "SNA-PPP-Echo-Req-Output"                  => "Starent",
            "SNA-PPP-Echo-Rsp-Input"                   => "Starent",
            "SNA-PPP-Echo-Rsp-Output"                  => "Starent",
            "SNA-PPP-Errors-Input"                     => "Starent",
            "SNA-PPP-Errors-Output"                    => "Starent",
            "SNA-PPP-Framed-Input-Octets"              => "Starent",
            "SNA-PPP-Framed-Output-Octets"             => "Starent",
            "SNA-PPP-Packet-Too-Long"                  => "Starent",
            "SNA-PPP-Unfr-Data-In-Gig"                 => "Starent",
            "SNA-PPP-Unfr-data-In-Oct"                 => "Starent",
            "SNA-PPP-Unfr-Data-Out-Gig"                => "Starent",
            "SNA-PPP-Unfr-data-Out-Oct"                => "Starent",
            "SNA-RP-Reg-Reply-Sent-Acc-Dereg"          => "Starent",
            "SNA-RP-Reg-Reply-Sent-Acc-Reg"            => "Starent",
            "SNA-RP-Reg-Reply-Sent-Bad-Req"            => "Starent",
            "SNA-RP-Reg-Reply-Sent-Denied"             => "Starent",
            "SNA-RP-Reg-Reply-Sent-Mis-ID"             => "Starent",
            "SNA-RP-Reg-Reply-Sent-Send-Err"           => "Starent",
            "SNA-RP-Reg-Reply-Sent-Total"              => "Starent",
            "SNA-RP-Reg-Upd-Re-Sent"                   => "Starent",
            "SNA-RP-Reg-Upd-Send-Err"                  => "Starent",
            "SNA-RP-Reg-Upd-Sent"                      => "Starent",
            "SNA-RPRAK-Rcvd-Acc-Ack"                   => "Starent",
            "SNA-RPRAK-Rcvd-Mis-ID"                    => "Starent",
            "SNA-RPRAK-Rcvd-Msg-Auth-Fail"             => "Starent",
            "SNA-RPRAK-Rcvd-Total"                     => "Starent",
            "SNA-RPRRQ-Rcvd-Acc-Dereg"                 => "Starent",
            "SNA-RPRRQ-Rcvd-Acc-Reg"                   => "Starent",
            "SNA-RPRRQ-Rcvd-Badly-Formed"              => "Starent",
            "SNA-RPRRQ-Rcvd-Mis-ID"                    => "Starent",
            "SNA-RPRRQ-Rcvd-Msg-Auth-Fail"             => "Starent",
            "SNA-RPRRQ-Rcvd-T-Bit-Not-Set"             => "Starent",
            "SNA-RPRRQ-Rcvd-Total"                     => "Starent",
            "SNA-RPRRQ-Rcvd-VID-Unsupported"           => "Starent",
            "SofaWare-Admin"                           => "SofaWare",
            "SofaWare-Hotspot"                         => "SofaWare",
            "SofaWare-UFP"                             => "SofaWare",
            "SofaWare-VPN"                             => "SofaWare",
            "SoftBank-BB-Unit-HW-Revision"             => "SoftBank",
            "SoftBank-BB-Unit-MAC"                     => "SoftBank",
            "SoftBank-BB-Unit-Manufacturer"            => "SoftBank",
            "SoftBank-BB-Unit-Model"                   => "SoftBank",
            "SoftBank-DNS-IPv6-Primary"                => "SoftBank",
            "SoftBank-DNS-IPv6-Secondary"              => "SoftBank",
            "SoftBank-IPv4-Tunnel-Endpoint"            => "SoftBank",
            "SoftBank-IPv4-Tunnel-Local-Address"       => "SoftBank",
            "SoftBank-RouteInfo-Server"                => "SoftBank",
            "SoftBank-SNTP-Server"                     => "SoftBank",
            "SoftBank-Syslog-Server"                   => "SoftBank",
            "SoftBank-TFTP-Config-File"                => "SoftBank",
            "SoftBank-TFTP-Config-Server"              => "SoftBank",
            "SonicWall-User-Group"                     => "SonicWall",
            "SonicWall-User-Privilege"                 => "SonicWall",
            "Source-Validation"                        => "Ericsson-AB",
            "SS3-Firewall-User-Privilege"              => "SonicWall",
            "ST-Acct-VC-Connection-Id"                 => "SpringTide",
            "ST-IPSec-Client-Firewall"                 => "SpringTide",
            "ST-IPSec-Client-Subnet"                   => "SpringTide",
            "ST-IPSec-Pfs-Group"                       => "SpringTide",
            "ST-Physical-Port"                         => "SpringTide",
            "ST-Physical-Slot"                         => "SpringTide",
            "ST-Policy-Name"                           => "SpringTide",
            "ST-Primary-DNS-Server"                    => "SpringTide",
            "ST-Primary-NBNS-Server"                   => "SpringTide",
            "ST-Realm-Name"                            => "SpringTide",
            "ST-Secondary-DNS-Server"                  => "SpringTide",
            "ST-Secondary-NBNS-Server"                 => "SpringTide",
            "ST-Service-Domain"                        => "SpringTide",
            "ST-Service-Name"                          => "SpringTide",
            "ST-Virtual-Circuit-ID"                    => "SpringTide",
            "ST-Virtual-Path-ID"                       => "SpringTide",
            "subscriber"                               => "Cisco",
            "Subscriber-Profile-Name"                  => "Ericsson-AB",
            "Suggested-Rule-Space"           => "Ericsson-Packet-Core-Networks",
            "Suggested-Secondary-Rule-Space" => "Ericsson-Packet-Core-Networks",
            "Surfnet-AVPair"                 => "Surfnet",
            "Surfnet-Service-Identifier"     => "Surfnet",
            "Surfnet-Service-Provider"       => "Surfnet",
            "Symbol-Admin-Role"              => "Symbol",
            "Symbol-Allowed-ESSID"           => "Symbol",
            "Symbol-Allowed-Radio"           => "Symbol",
            "Symbol-Current-ESSID"           => "Symbol",
            "Symbol-Downlink-Limit"          => "Symbol",
            "Symbol-Expiry-Date-Time"        => "Symbol",
            "Symbol-Login-Source"            => "Symbol",
            "Symbol-Posture-Status"          => "Symbol",
            "Symbol-QoS-Profile"             => "Symbol",
            "Symbol-Start-Date-Time"         => "Symbol",
            "Symbol-Uplink-Limit"            => "Symbol",
            "Symbol-User-Group"              => "Symbol",
            "Symbol-WLAN-Index"              => "Symbol",
            "T-Systems-Nova-Bandwidth-Max-Down"       => "T-Systems-Nova",
            "T-Systems-Nova-Bandwidth-Max-Up"         => "T-Systems-Nova",
            "T-Systems-Nova-Bandwidth-Min-Down"       => "T-Systems-Nova",
            "T-Systems-Nova-Bandwidth-Min-Up"         => "T-Systems-Nova",
            "T-Systems-Nova-Billing-Class-Of-Service" => "T-Systems-Nova",
            "T-Systems-Nova-Location-ID"              => "T-Systems-Nova",
            "T-Systems-Nova-Location-Name"            => "T-Systems-Nova",
            "T-Systems-Nova-Logoff-URL"               => "T-Systems-Nova",
            "T-Systems-Nova-Price-Of-Service"         => "T-Systems-Nova",
            "T-Systems-Nova-Redirection-URL"          => "T-Systems-Nova",
            "T-Systems-Nova-Service-Name"             => "T-Systems-Nova",
            "T-Systems-Nova-Session-Terminate-EoD"    => "T-Systems-Nova",
            "T-Systems-Nova-Session-Terminate-Time"   => "T-Systems-Nova",
            "T-Systems-Nova-UnknownAVP"               => "T-Systems-Nova",
            "T-Systems-Nova-Visiting-Provider-Code"   => "T-Systems-Nova",
            "Telebit-Accounting-Info"                 => "Telebit",
            "Telebit-Activate-Command"                => "Telebit",
            "Telebit-Login-Command"                   => "Telebit",
            "Telebit-Login-Option"                    => "Telebit",
            "Telebit-Port-Name"                       => "Telebit",
            "Telkom-Access-Type"                      => "Telkom",
            "Telkom-Degrade-Token"                    => "Telkom",
            "Telkom-Service-Type"                     => "Telkom",
            "Telrad-C-VLAN-ID"                        => "Telrad",
            "Telrad-C-VLAN-ID-Retag"                  => "Telrad",
            "Telrad-Item-Identity"                    => "Telrad",
            "Telrad-Reference-QOS-Profile-Name"       => "Telrad",
            "Telrad-Reference-VPWS-PDN-Name"          => "Telrad",
            "Telrad-S-VLAN-ID"                        => "Telrad",
            "Telrad-TSDF-Parameters"                  => "Telrad",
            "Telrad-TSDF-Table"                       => "Telrad",
            "Time-First-Usage"                        => "VerizonWireless",
            "Time-Last-Usage"                         => "VerizonWireless",
            "Timetra-Access"             => "Alcatel-Lucent-Service-Router",
            "Timetra-Action"             => "Alcatel-Lucent-Service-Router",
            "Timetra-Cmd"                => "Alcatel-Lucent-Service-Router",
            "Timetra-Default-Action"     => "Alcatel-Lucent-Service-Router",
            "Timetra-Exec-File"          => "Alcatel-Lucent-Service-Router",
            "Timetra-Home-Directory"     => "Alcatel-Lucent-Service-Router",
            "Timetra-Profile"            => "Alcatel-Lucent-Service-Router",
            "Timetra-Restrict-To-Home"   => "Alcatel-Lucent-Service-Router",
            "TP-Access-Class-Id"         => "Travelping",
            "TP-Access-Group"            => "Travelping",
            "TP-Access-Rule"             => "Travelping",
            "TP-Auth-Reply"              => "Travelping",
            "TP-CAPWAP-Boot-Version"     => "Travelping",
            "TP-CAPWAP-GPS-Altitude"     => "Travelping",
            "TP-CAPWAP-GPS-Hdop"         => "Travelping",
            "TP-CAPWAP-GPS-Latitude"     => "Travelping",
            "TP-CAPWAP-GPS-Longitude"    => "Travelping",
            "TP-CAPWAP-GPS-Timestamp"    => "Travelping",
            "TP-CAPWAP-Hardware-Version" => "Travelping",
            "TP-CAPWAP-Max-WIFI-Clients" => "Travelping",
            "TP-CAPWAP-Other-Software-Version"             => "Travelping",
            "TP-CAPWAP-POWER-SAVE-BUSY-TIMEOUT"            => "Travelping",
            "TP-CAPWAP-POWER-SAVE-IDLE-TIMEOUT"            => "Travelping",
            "TP-CAPWAP-Radio-Id"                           => "Travelping",
            "TP-CAPWAP-Session-Id"                         => "Travelping",
            "TP-CAPWAP-Software-Version"                   => "Travelping",
            "TP-CAPWAP-SSID"                               => "Travelping",
            "TP-CAPWAP-Timestamp"                          => "Travelping",
            "TP-CAPWAP-Walled-Garden"                      => "Travelping",
            "TP-CAPWAP-WTP-Version"                        => "Travelping",
            "TP-CAPWAP-WWAN-Cell-Id"                       => "Travelping",
            "TP-CAPWAP-WWAN-CREG"                          => "Travelping",
            "TP-CAPWAP-WWAN-Id"                            => "Travelping",
            "TP-CAPWAP-WWAN-LAC"                           => "Travelping",
            "TP-CAPWAP-WWAN-Latency"                       => "Travelping",
            "TP-CAPWAP-WWAN-MCC"                           => "Travelping",
            "TP-CAPWAP-WWAN-MNC"                           => "Travelping",
            "TP-CAPWAP-WWAN-RAT"                           => "Travelping",
            "TP-CAPWAP-WWAN-RSSi"                          => "Travelping",
            "TP-DHCP-Client-Id"                            => "Travelping",
            "TP-DHCP-Parameter-Request-List"               => "Travelping",
            "TP-DHCP-Request-Option-List"                  => "Travelping",
            "TP-DHCP-Vendor-Class-Id"                      => "Travelping",
            "TP-ENC-IV"                                    => "Travelping",
            "TP-Exit-Access-Class-Id"                      => "Travelping",
            "TP-Firmware-Variant"                          => "Travelping",
            "TP-Firmware-Version"                          => "Travelping",
            "TP-Gateway-Config"                            => "Travelping",
            "TP-Gateway-Version"                           => "Travelping",
            "TP-Host-Name"                                 => "Travelping",
            "TP-Keep-Alive-Timeout"                        => "Travelping",
            "TP-Location-Id"                               => "Travelping",
            "TP-Max-Input-Octets"                          => "Travelping",
            "TP-Max-Output-Octets"                         => "Travelping",
            "TP-Max-Total-Octets"                          => "Travelping",
            "TP-Monitor-Id"                                => "Travelping",
            "TP-Monitor-Session-Id"                        => "Travelping",
            "TP-NAT-IP-Address"                            => "Travelping",
            "TP-NAT-Pool-Id"                               => "Travelping",
            "TP-NAT-Port-End"                              => "Travelping",
            "TP-NAT-Port-Start"                            => "Travelping",
            "TP-Password"                                  => "Travelping",
            "TP-Related-Session-Id"                        => "Travelping",
            "TP-TLS-Auth-Type"                             => "Travelping",
            "TP-TLS-Pre-Shared-Key"                        => "Travelping",
            "TP-User-Agent"                                => "Travelping",
            "TP-Zone-Id"                                   => "Travelping",
            "Trapeze-Audit"                                => "Trapeze",
            "Trapeze-CoA-Username"                         => "Trapeze",
            "Trapeze-Encryption-Type"                      => "Trapeze",
            "Trapeze-End-Date"                             => "Trapeze",
            "Trapeze-Mobility-Profile"                     => "Trapeze",
            "Trapeze-QoS-Profile"                          => "Trapeze",
            "Trapeze-Simultaneous-Logins"                  => "Trapeze",
            "Trapeze-SSID"                                 => "Trapeze",
            "Trapeze-Start-Date"                           => "Trapeze",
            "Trapeze-Time-Of-Day"                          => "Trapeze",
            "Trapeze-URL"                                  => "Trapeze",
            "Trapeze-User-Group-Name"                      => "Trapeze",
            "Trapeze-VLAN-Name"                            => "Trapeze",
            "TrippLite-Authorization"                      => "TrippLite",
            "TrippLite-Message"                            => "TrippLite",
            "TrippLite-Outlet-Realms"                      => "TrippLite",
            "TrippLite-User-Role"                          => "TrippLite",
            "Tropos-Average-RSSI"                          => "Tropos",
            "Tropos-Capability-Info"                       => "Tropos",
            "Tropos-Cell-Location"                         => "Tropos",
            "Tropos-Cell-Name"                             => "Tropos",
            "Tropos-Channel"                               => "Tropos",
            "Tropos-Class-Mult"                            => "Tropos",
            "Tropos-Input-Cap"                             => "Tropos",
            "Tropos-Latitude"                              => "Tropos",
            "Tropos-Layer2-Input-Drops"                    => "Tropos",
            "Tropos-Layer2-Input-Frames"                   => "Tropos",
            "Tropos-Layer2-Input-Octets"                   => "Tropos",
            "Tropos-Layer2-Output-Frames"                  => "Tropos",
            "Tropos-Layer2-Output-Octets"                  => "Tropos",
            "Tropos-Longitude"                             => "Tropos",
            "Tropos-Noise-Floor"                           => "Tropos",
            "Tropos-Noise-Upper-Bound"                     => "Tropos",
            "Tropos-Output-Cap"                            => "Tropos",
            "Tropos-Rates-Received"                        => "Tropos",
            "Tropos-Rates-Sent"                            => "Tropos",
            "Tropos-Release"                               => "Tropos",
            "Tropos-Retries-Sent"                          => "Tropos",
            "Tropos-Retry-Bits"                            => "Tropos",
            "Tropos-Routed-Time"                           => "Tropos",
            "Tropos-Routless-Since"                        => "Tropos",
            "Tropos-Secondary-IP"                          => "Tropos",
            "Tropos-Serial-Number"                         => "Tropos",
            "Tropos-Terminate-Cause"                       => "Tropos",
            "Tropos-Unicast-Cipher"                        => "Tropos",
            "Trust-Router-APC"                             => "UKERNA",
            "Trust-Router-COI"                             => "UKERNA",
            "TTY-Level-Max"                                => "Ericsson-AB",
            "TTY-Level-Start"                              => "Ericsson-AB",
            "Tunnel-Algorithm"                             => "Ericsson-AB",
            "Tunnel-Checksum"                              => "Ericsson-AB",
            "Tunnel-Client-Int-Addr"                       => "Ericsson-AB",
            "Tunnel-Client-Rhost"                          => "Ericsson-AB",
            "Tunnel-Client-VPN"                            => "Ericsson-AB",
            "Tunnel-Cmd-Timeout"                           => "Ericsson-AB",
            "Tunnel-Context"                               => "Ericsson-AB",
            "Tunnel-Deadtime"                              => "Ericsson-AB",
            "Tunnel-DNIS"                                  => "Ericsson-AB",
            "Tunnel-Domain"                                => "Ericsson-AB",
            "Tunnel-Flow-Control"                          => "Ericsson-AB",
            "Tunnel-Function"                              => "Ericsson-AB",
            "Tunnel-Group"                                 => "Ericsson-AB",
            "Tunnel-Hello-Timer"                           => "Ericsson-AB",
            "Tunnel-L2F-Second-Password"                   => "Ericsson-AB",
            "Tunnel-Local-Name"                            => "Ericsson-AB",
            "Tunnel-Max-Sessions"                          => "Ericsson-AB",
            "Tunnel-Max-Tunnels"                           => "Ericsson-AB",
            "Tunnel-Police-Burst"                          => "Ericsson-AB",
            "Tunnel-Police-Excess-Burst"                   => "Ericsson-AB",
            "Tunnel-Police-Rate"                           => "Ericsson-AB",
            "Tunnel-Profile"                               => "Ericsson-AB",
            "Tunnel-Rate-Limit-Burst"                      => "Ericsson-AB",
            "Tunnel-Rate-Limit-Excess-Burst"               => "Ericsson-AB",
            "Tunnel-Rate-Limit-Rate"                       => "Ericsson-AB",
            "Tunnel-Remote-Name"                           => "Ericsson-AB",
            "Tunnel-Retransmit"                            => "Ericsson-AB",
            "Tunnel-Server-Int-Addr"                       => "Ericsson-AB",
            "Tunnel-Server-Rhost"                          => "Ericsson-AB",
            "Tunnel-Server-VPN"                            => "Ericsson-AB",
            "Tunnel-Session-Auth"                          => "Ericsson-AB",
            "Tunnel-Session-Auth-Ctx"                      => "Ericsson-AB",
            "Tunnel-Session-Auth-Service-Grp"              => "Ericsson-AB",
            "Tunnel-Static"                                => "Ericsson-AB",
            "Tunnel-Window"                                => "Ericsson-AB",
            "UE-Info-Type"                                 => "VerizonWireless",
            "UE-Info-Value"                                => "VerizonWireless",
            "UKERNA-GSS-Acceptor-Host-Name"                => "UKERNA",
            "UKERNA-GSS-Acceptor-Realm-Name"               => "UKERNA",
            "UKERNA-GSS-Acceptor-Service-Name"             => "UKERNA",
            "UKERNA-GSS-Acceptor-Service-Specific"         => "UKERNA",
            "Unix-FTP-GID"                                 => "Unix",
            "Unix-FTP-Group-Ids"                           => "Unix",
            "Unix-FTP-Group-Names"                         => "Unix",
            "Unix-FTP-Home"                                => "Unix",
            "Unix-FTP-Shell"                               => "Unix",
            "Unix-FTP-UID"                                 => "Unix",
            "UserLogon-Acct-TerminateCause"                => "NTUA",
            "UserLogon-DriveNames"                         => "NTUA",
            "UserLogon-Expiration"                         => "NTUA",
            "UserLogon-Gid"                                => "NTUA",
            "UserLogon-GroupNames"                         => "NTUA",
            "UserLogon-HomeDir"                            => "NTUA",
            "UserLogon-LogoffTask"                         => "NTUA",
            "UserLogon-LogonTask"                          => "NTUA",
            "UserLogon-QuotaBytes"                         => "NTUA",
            "UserLogon-QuotaFiles"                         => "NTUA",
            "UserLogon-Restriction"                        => "NTUA",
            "UserLogon-Shell"                              => "NTUA",
            "UserLogon-Type"                               => "NTUA",
            "UserLogon-Uid"                                => "NTUA",
            "UserLogon-UserDescription"                    => "NTUA",
            "UserLogon-UserDomain"                         => "NTUA",
            "UserLogon-UserFullName"                       => "NTUA",
            "UserLogon-UserProfile"                        => "NTUA",
            "USR-ACCM-Type"                                => "USR",
            "USR-Acct-Reason-Code"                         => "USR",
            "USR-Actual-Voltage"                           => "USR",
            "USR-Agent"                                    => "USR",
            "USR-Appletalk"                                => "USR",
            "USR-Appletalk-Network-Range"                  => "USR",
            "USR-AT-Call-Input-Filter"                     => "USR",
            "USR-AT-Call-Output-Filter"                    => "USR",
            "USR-AT-Input-Filter"                          => "USR",
            "USR-AT-Output-Filter"                         => "USR",
            "USR-AT-RTMP-Input-Filter"                     => "USR",
            "USR-AT-RTMP-Output-Filter"                    => "USR",
            "USR-AT-Zip-Input-Filter"                      => "USR",
            "USR-AT-Zip-Output-Filter"                     => "USR",
            "USR-Auth-Mode"                                => "USR",
            "USR-Auth-Next-Server-Address"                 => "USR",
            "USR-Back-Channel-Data-Rate"                   => "USR",
            "USR-Bearer-Capabilities"                      => "USR",
            "USR-Block-Error-Count-Limit"                  => "USR",
            "USR-Blocks-Received"                          => "USR",
            "USR-Blocks-Resent"                            => "USR",
            "USR-Blocks-Sent"                              => "USR",
            "USR-Bridging"                                 => "USR",
            "USR-Bytes-RX-Remain"                          => "USR",
            "USR-Bytes-TX-Remain"                          => "USR",
            "USR-Call-Arrival-in-GMT"                      => "USR",
            "USR-Call-Arrival-Time"                        => "USR",
            "USR-Call-Connect-in-GMT"                      => "USR",
            "USR-Call-Connecting-Time"                     => "USR",
            "USR-Call-End-Date-Time"                       => "USR",
            "USR-Call-End-Time"                            => "USR",
            "USR-Call-Error-Code"                          => "USR",
            "USR-Call-Event-Code"                          => "USR",
            "USR-Call-Reference-Number"                    => "USR",
            "USR-Call-Start-Date-Time"                     => "USR",
            "USR-Call-Terminate-in-GMT"                    => "USR",
            "USR-Call-Type"                                => "USR",
            "USR-Callback-Type"                            => "USR",
            "USR-Called-Party-Number"                      => "USR",
            "USR-Calling-Party-Number"                     => "USR",
            "USR-Card-Type"                                => "USR",
            "USR-CCP-Algorithm"                            => "USR",
            "USR-CDMA-Call-Reference-Number"               => "USR",
            "USR-CDMA-PktData-Network-ID"                  => "USR",
            "USR-Channel"                                  => "USR",
            "USR-Channel-Connected-To"                     => "USR",
            "USR-Channel-Decrement"                        => "USR",
            "USR-Channel-Expansion"                        => "USR",
            "USR-Characters-Received"                      => "USR",
            "USR-Characters-Sent"                          => "USR",
            "USR-Chassis-Call-Channel"                     => "USR",
            "USR-Chassis-Call-Slot"                        => "USR",
            "USR-Chassis-Call-Span"                        => "USR",
            "USR-Chassis-Slot"                             => "USR",
            "USR-Chassis-Temp-Threshold"                   => "USR",
            "USR-Chassis-Temperature"                      => "USR",
            "USR-Chat-Script-Name"                         => "USR",
            "USR-Compression-Algorithm"                    => "USR",
            "USR-Compression-Reset-Mode"                   => "USR",
            "USR-Compression-Type"                         => "USR",
            "USR-Connect-Speed"                            => "USR",
            "USR-Connect-Term-Reason"                      => "USR",
            "USR-Connect-Time"                             => "USR",
            "USR-Connect-Time-Limit"                       => "USR",
            "USR-CUSR-hat-Script-Rules"                    => "USR",
            "USR-Default-DTE-Data-Rate"                    => "USR",
            "USR-Device-Connected-To"                      => "USR",
            "USR-Disconnect-Cause-Indicator"               => "USR",
            "USR-DNIS-ReAuthentication"                    => "USR",
            "USR-DS0"                                      => "USR",
            "USR-DS0s"                                     => "USR",
            "USR-DTE-Data-Idle-Timout"                     => "USR",
            "USR-DTE-Ring-No-Answer-Limit"                 => "USR",
            "USR-DTR-False-Timeout"                        => "USR",
            "USR-DTR-True-Timeout"                         => "USR",
            "USR-Dvmrp-Advertised-Metric"                  => "USR",
            "USR-Dvmrp-Initial-Flooding"                   => "USR",
            "USR-Dvmrp-Input-Filter"                       => "USR",
            "USR-Dvmrp-Non-Pruners"                        => "USR",
            "USR-Dvmrp-Output-Filter"                      => "USR",
            "USR-Dvmrp-Prune-Lifetime"                     => "USR",
            "USR-Dvmrp-Retransmit-Prunes"                  => "USR",
            "USR-Dvmrp-Route-Transit"                      => "USR",
            "USR-End-Time"                                 => "USR",
            "USR-Equalization-Type"                        => "USR",
            "USR-ESN"                                      => "USR",
            "USR-ET-Bridge-Call-Output-Filte"              => "USR",
            "USR-ET-Bridge-Input-Filter"                   => "USR",
            "USR-ET-Bridge-Output-Filter"                  => "USR",
            "USR-Event-Date-Time"                          => "USR",
            "USR-Event-Id"                                 => "USR",
            "USR-Expansion-Algorithm"                      => "USR",
            "USR-Expected-Voltage"                         => "USR",
            "USR-Failure-to-Connect-Reason"                => "USR",
            "USR-Fallback-Enabled"                         => "USR",
            "USR-Fallback-Limit"                           => "USR",
            "USR-Filter-Zones"                             => "USR",
            "USR-Final-Rx-Link-Data-Rate"                  => "USR",
            "USR-Final-Tx-Link-Data-Rate"                  => "USR",
            "USR-FQ-Default-Priority"                      => "USR",
            "USR-Framed-IPX-Route"                         => "USR",
            "USR-Framed_IP_Address_Pool_Name"              => "USR",
            "USR-Gateway-IP-Address"                       => "USR",
            "USR-HARC-Disconnect-Code"                     => "USR",
            "USR-Host-Type"                                => "USR",
            "USR-IDS0-Call-Type"                           => "USR",
            "USR-IGMP-Maximum-Response-Time"               => "USR",
            "USR-IGMP-Query-Interval"                      => "USR",
            "USR-IGMP-Robustness"                          => "USR",
            "USR-IGMP-Routing"                             => "USR",
            "USR-IGMP-Version"                             => "USR",
            "USR-IMSI"                                     => "USR",
            "USR-Init-Reg-Server-Addr"                     => "USR",
            "USR-Initial-Rx-Link-Data-Rate"                => "USR",
            "USR-Initial-Tx-Link-Data-Rate"                => "USR",
            "USR-Interface-Index"                          => "USR",
            "USR-IP"                                       => "USR",
            "USR-IP-Call-Input-Filter"                     => "USR",
            "USR-IP-Call-Output-Filter"                    => "USR",
            "USR-IP-Default-Route-Option"                  => "USR",
            "USR-IP-RIP-Input-Filter"                      => "USR",
            "USR-IP-RIP-Output-Filter"                     => "USR",
            "USR-IP-RIP-Policies"                          => "USR",
            "USR-IP-RIP-Simple-Auth-Password"              => "USR",
            "USR-IP-SAA-Filter"                            => "USR",
            "USR-IPP-Enable"                               => "USR",
            "USR-IPX"                                      => "USR",
            "USR-IPX-Call-Input-Filter"                    => "USR",
            "USR-IPX-Call-Output-Filter"                   => "USR",
            "USR-IPX-RIP-Input-Filter"                     => "USR",
            "USR-IPX-RIP-Output-Filter"                    => "USR",
            "USR-IPX-Routing"                              => "USR",
            "USR-IPX-WAN"                                  => "USR",
            "USR-IWF-Call-Identifier"                      => "USR",
            "USR-IWF-IP-Address"                           => "USR",
            "USR-Keep-Alive-Interval"                      => "USR",
            "USR-Keypress-Timeout"                         => "USR",
            "USR-Last-Callers-Number-ANI"                  => "USR",
            "USR-Last-Number-Dialed-In-DNIS"               => "USR",
            "USR-Last-Number-Dialed-Out"                   => "USR",
            "USR-Line-Reversals"                           => "USR",
            "USR-Local-Framed-IP-Addr"                     => "USR",
            "USR-Local-IP-Address"                         => "USR",
            "USR-Log-Filter-Packets"                       => "USR",
            "USR-Max-Channels"                             => "USR",
            "USR-Mbi_Ct_BChannel_Used"                     => "USR",
            "USR-Mbi_Ct_PRI_Card_Slot"                     => "USR",
            "USR-Mbi_Ct_PRI_Card_Span_Line"                => "USR",
            "USR-Mbi_Ct_TDM_Time_Slot"                     => "USR",
            "USR-MIC"                                      => "USR",
            "USR-Min-Compression-Size"                     => "USR",
            "USR-MIP-NAI"                                  => "USR",
            "USR-MLPPP-Fragmentation-Threshld"             => "USR",
            "USR-Mobile-Accounting-Type"                   => "USR",
            "USR-Mobile-IP-Address"                        => "USR",
            "USR-Mobile-NumBytes-Rxed"                     => "USR",
            "USR-Mobile-NumBytes-Txed"                     => "USR",
            "USR-Mobile-Service-Option"                    => "USR",
            "USR-Mobile-Session-ID"                        => "USR",
            "USR-MobileIP-Home-Agent-Address"              => "USR",
            "USR-Modem-Group"                              => "USR",
            "USR-Modem-Setup-Time"                         => "USR",
            "USR-Modem-Training-Time"                      => "USR",
            "USR-Modulation-Type"                          => "USR",
            "USR-MP-EDO"                                   => "USR",
            "USR-MP-EDO-HIPER"                             => "USR",
            "USR-MP-MRRU"                                  => "USR",
            "USR-MPIP-Tunnel-Originator"                   => "USR",
            "USR-Multicast-Forwarding"                     => "USR",
            "USR-Multicast-Proxy"                          => "USR",
            "USR-Multicast-Receive"                        => "USR",
            "USR-Nailed-B-Channel-Indicator"               => "USR",
            "USR-NAS-Type"                                 => "USR",
            "USR-NFAS-ID"                                  => "USR",
            "USR-Num-Fax-Pages-Processed"                  => "USR",
            "USR-Number-of-Blers"                          => "USR",
            "USR-Number-Of-Characters-Lost"                => "USR",
            "USR-Number-of-Fallbacks"                      => "USR",
            "USR-Number-of-Link-NAKs"                      => "USR",
            "USR-Number-of-Link-Timeouts"                  => "USR",
            "USR-Number-of-Rings-Limit"                    => "USR",
            "USR-Number-of-Upshifts"                       => "USR",
            "USR-Orig-NAS-Type"                            => "USR",
            "USR-Originate-Answer-Mode"                    => "USR",
            "USR-OSPF-Addressless-Index"                   => "USR",
            "USR-Packet-Bus-Session"                       => "USR",
            "USR-Physical-State"                           => "USR",
            "USR-Policy-Access"                            => "USR",
            "USR-Policy-Configuration"                     => "USR",
            "USR-Policy-Filename"                          => "USR",
            "USR-Policy-Type"                              => "USR",
            "USR-Port-Tap"                                 => "USR",
            "USR-Port-Tap-Address"                         => "USR",
            "USR-Port-Tap-Facility"                        => "USR",
            "USR-Port-Tap-Format"                          => "USR",
            "USR-Port-Tap-Output"                          => "USR",
            "USR-Port-Tap-Priority"                        => "USR",
            "USR-Power-Supply-Number"                      => "USR",
            "USR-PQ-Default-Priority"                      => "USR",
            "USR-PQ-Parameters"                            => "USR",
            "USR-Pre-Paid-Enabled"                         => "USR",
            "USR-Pre-Shared-MN-Key"                        => "USR",
            "USR-Primary_DNS_Server"                       => "USR",
            "USR-Primary_NBNS_Server"                      => "USR",
            "USR-PW_Cutoff"                                => "USR",
            "USR-PW_Framed_Routing_V2"                     => "USR",
            "USR-PW_Index"                                 => "USR",
            "USR-PW_Packet"                                => "USR",
            "USR-PW_Tunnel_Authentication"                 => "USR",
            "USR-PW_USR_IFilter_IP"                        => "USR",
            "USR-PW_USR_IFilter_IPX"                       => "USR",
            "USR-PW_USR_OFilter_IP"                        => "USR",
            "USR-PW_USR_OFilter_IPX"                       => "USR",
            "USR-PW_USR_OFilter_SAP"                       => "USR",
            "USR-PW_VPN_Gateway"                           => "USR",
            "USR-PW_VPN_ID"                                => "USR",
            "USR-PW_VPN_Name"                              => "USR",
            "USR-PW_VPN_Neighbor"                          => "USR",
            "USR-Q931-Call-Reference-Value"                => "USR",
            "USR-QNC1-Service-Destination"                 => "USR",
            "USR-QoS-Queuing-Mehtod"                       => "USR",
            "USR-Rad-Dvmrp-Metric"                         => "USR",
            "USR-Rad-IP-Pool-Definition"                   => "USR",
            "USR-Rad-Location-Type"                        => "USR",
            "USR-Rad-Multicast-Routing-Bound"              => "USR",
            "USR-Rad-Multicast-Routing-Proto"              => "USR",
            "USR-Rad-Multicast-Routing-RtLim"              => "USR",
            "USR-Rad-Multicast-Routing-Ttl"                => "USR",
            "USR-Rad-NMC-Blocks_RX"                        => "USR",
            "USR-Rad-NMC-Call-Progress-Status"             => "USR",
            "USR-Re-Chap-Timeout"                          => "USR",
            "USR-Re-Reg-Server-Addr"                       => "USR",
            "USR-Receive-Acc-Map"                          => "USR",
            "USR-Redirect"                                 => "USR",
            "USR-Reg-Server-Prov-Timeout"                  => "USR",
            "USR-Reply-Script1"                            => "USR",
            "USR-Reply-Script2"                            => "USR",
            "USR-Reply-Script3"                            => "USR",
            "USR-Reply-Script4"                            => "USR",
            "USR-Reply-Script5"                            => "USR",
            "USR-Reply-Script6"                            => "USR",
            "USR-Request-Type"                             => "USR",
            "USR-Retrains-Granted"                         => "USR",
            "USR-Retrains-Requested"                       => "USR",
            "USR-RMMIE-Firmware-Build-Date"                => "USR",
            "USR-RMMIE-Firmware-Version"                   => "USR",
            "USR-RMMIE-Last-Update-Event"                  => "USR",
            "USR-RMMIE-Last-Update-Time"                   => "USR",
            "USR-RMMIE-Manufacturer-ID"                    => "USR",
            "USR-RMMIE-Num-Of-Updates"                     => "USR",
            "USR-RMMIE-Planned-Disconnect"                 => "USR",
            "USR-RMMIE-Product-Code"                       => "USR",
            "USR-RMMIE-PwrLvl-FarEcho-Canc"                => "USR",
            "USR-RMMIE-PwrLvl-NearEcho-Canc"               => "USR",
            "USR-RMMIE-PwrLvl-Noise-Lvl"                   => "USR",
            "USR-RMMIE-PwrLvl-Xmit-Lvl"                    => "USR",
            "USR-RMMIE-Rcv-PwrLvl-3300Hz"                  => "USR",
            "USR-RMMIE-Rcv-PwrLvl-3750Hz"                  => "USR",
            "USR-RMMIE-Rcv-Tot-PwrLvl"                     => "USR",
            "USR-RMMIE-Serial-Number"                      => "USR",
            "USR-RMMIE-Status"                             => "USR",
            "USR-RMMIE-x2-Status"                          => "USR",
            "USR-Routing-Protocol"                         => "USR",
            "USR-SAP-Filter-In"                            => "USR",
            "USR-Secondary_DNS_Server"                     => "USR",
            "USR-Secondary_NBNS_Server"                    => "USR",
            "USR-Security-Login-Limit"                     => "USR",
            "USR-Security-Resp-Limit"                      => "USR",
            "USR-Send-Name"                                => "USR",
            "USR-Send-Password"                            => "USR",
            "USR-Send-Script1"                             => "USR",
            "USR-Send-Script2"                             => "USR",
            "USR-Send-Script3"                             => "USR",
            "USR-Send-Script4"                             => "USR",
            "USR-Send-Script5"                             => "USR",
            "USR-Send-Script6"                             => "USR",
            "USR-Server-Time"                              => "USR",
            "USR-Service-Option"                           => "USR",
            "USR-Session-Time-Remain"                      => "USR",
            "USR-Simplified-MNP-Levels"                    => "USR",
            "USR-Simplified-V42bis-Usage"                  => "USR",
            "USR-Slot-Connected-To"                        => "USR",
            "USR-Special-Xon-Xoff-Flow"                    => "USR",
            "USR-Speed-Of-Connection"                      => "USR",
            "USR-Spoofing"                                 => "USR",
            "USR-Start-Time"                               => "USR",
            "USR-Supports-Tags"                            => "USR",
            "USR-Sync-Async-Mode"                          => "USR",
            "USR-Syslog-Tap"                               => "USR",
            "USR-Telnet-Options"                           => "USR",
            "USR-Terminal-Type"                            => "USR",
            "USR-Traffic-Threshold"                        => "USR",
            "USR-Transmit-Acc-Map"                         => "USR",
            "USR-Tunnel-Auth-Hostname"                     => "USR",
            "USR-Tunnel-Challenge-Outgoing"                => "USR",
            "USR-Tunnel-Security"                          => "USR",
            "USR-Tunnel-Switch-Endpoint"                   => "USR",
            "USR-Tunneled-MLPP"                            => "USR",
            "USR-Unauthenticated-Time"                     => "USR",
            "USR-Unnumbered-Local-IP-Address"              => "USR",
            "USR-User-PPP-AODI-Type"                       => "USR",
            "USR-VLAN-Tag"                                 => "USR",
            "USR-VPN-Encrypter"                            => "USR",
            "USR-VPN-GW-Location-Id"                       => "USR",
            "USR-VTS-Session-Key"                          => "USR",
            "USR-Wallclock-Timestamp"                      => "USR",
            "USR-X25-Acct-Input-Segment-Count"             => "USR",
            "USR-X25-Acct-Output-Segment-Coun"             => "USR",
            "USR-X25-Acct-Segment-Size"                    => "USR",
            "USR-X25-Acct-Termination-Code"                => "USR",
            "USR-X25-SVC-Call-Attributes"                  => "USR",
            "USR-X25-SVC-Logical-Channel-Numb"             => "USR",
            "USR-X25-Trunk-Profile"                        => "USR",
            "UTStarcom-Act-Input-Frames"                   => "UTStarcom",
            "UTStarcom-Act-Input-Octets"                   => "UTStarcom",
            "UTStarcom-Act-Output-Frames"                  => "UTStarcom",
            "UTStarcom-Act-Output-Octets"                  => "UTStarcom",
            "UTStarcom-CLI-Access-Level"                   => "UTStarcom",
            "UTStarcom-CommittedBandwidth"                 => "UTStarcom",
            "UTStarcom-Default-Gateway"                    => "UTStarcom",
            "UTStarcom-DeviceId"                           => "UTStarcom",
            "UTStarcom-Error-Reason"                       => "UTStarcom",
            "UTStarcom-Logical-Port-No"                    => "UTStarcom",
            "UTStarcom-MaxBandwidth"                       => "UTStarcom",
            "UTStarcom-MaxBurstSize"                       => "UTStarcom",
            "UTStarcom-MaxDelay"                           => "UTStarcom",
            "UTStarcom-MaxJitter"                          => "UTStarcom",
            "UTStarcom-Module-Id"                          => "UTStarcom",
            "UTStarcom-ONU-Admin_status"                   => "UTStarcom",
            "UTStarcom-ONU-FW-SC-Upgrade"                  => "UTStarcom",
            "UTStarcom-Onu-MC-Filter-Enable"               => "UTStarcom",
            "UTStarcom-Port-No"                            => "UTStarcom",
            "UTStarcom-PrimaryDNS"                         => "UTStarcom",
            "UTStarcom-Priority"                           => "UTStarcom",
            "UTStarcom-SecondaryDNS"                       => "UTStarcom",
            "UTStarcom-UNI-Auto-Negotiation"               => "UTStarcom",
            "UTStarcom-UNI-Duplex"                         => "UTStarcom",
            "UTStarcom-UNI-MAX-MAC"                        => "UTStarcom",
            "UTStarcom-UNI-Speed"                          => "UTStarcom",
            "UTStarcom-VLAN-ID"                            => "UTStarcom",
            "VasExperts-Acct-Traffic-Class-Input-Octets"   => "VasExperts",
            "VasExperts-Acct-Traffic-Class-Input-Packets"  => "VasExperts",
            "VasExperts-Acct-Traffic-Class-Name"           => "VasExperts",
            "VasExperts-Acct-Traffic-Class-Output-Octets"  => "VasExperts",
            "VasExperts-Acct-Traffic-Class-Output-Packets" => "VasExperts",
            "VasExperts-ARP-SourceIP"                      => "VasExperts",
            "VasExperts-ARP-TargetIP"                      => "VasExperts",
            "VasExperts-BOOTP-File"                        => "VasExperts",
            "VasExperts-BOOTP-SName"                       => "VasExperts",
            "VasExperts-Command-Code"                      => "VasExperts",
            "VasExperts-DHCP-ClassId"                      => "VasExperts",
            "VasExperts-DHCP-ClientId"                     => "VasExperts",
            "VasExperts-DHCP-ClientIP"                     => "VasExperts",
            "VasExperts-DHCP-DNS"                          => "VasExperts",
            "VasExperts-DHCP-Gateway"                      => "VasExperts",
            "VasExperts-DHCP-Hostname"                     => "VasExperts",
            "VasExperts-DHCP-Option"                       => "VasExperts",
            "VasExperts-DHCP-Option-Bin"                   => "VasExperts",
            "VasExperts-DHCP-Option-IP"                    => "VasExperts",
            "VasExperts-DHCP-Option-IPv6"                  => "VasExperts",
            "VasExperts-DHCP-Option-IPv6-Prefix"           => "VasExperts",
            "VasExperts-DHCP-Option-Num"                   => "VasExperts",
            "VasExperts-DHCP-Option-String"                => "VasExperts",
            "VasExperts-DHCP-RelayCircuitId"               => "VasExperts",
            "VasExperts-DHCP-RelayInfo"                    => "VasExperts",
            "VasExperts-DHCP-RelayRemoteId"                => "VasExperts",
            "VasExperts-DHCP-Request"                      => "VasExperts",
            "VasExperts-DHCP6-Option-Bin"                  => "VasExperts",
            "VasExperts-DHCP6-Option-Num"                  => "VasExperts",
            "VasExperts-DHCP6-Option-String"               => "VasExperts",
            "VasExperts-DHCPv6-Delegated"                  => "VasExperts",
            "VasExperts-DHCPv6-RemoteId"                   => "VasExperts",
            "VasExperts-DHCPv6-Request"                    => "VasExperts",
            "VasExperts-DHCPv6-SubsId"                     => "VasExperts",
            "VasExperts-DHCPv6-UserClass"                  => "VasExperts",
            "VasExperts-DHCPv6-VendorClass"                => "VasExperts",
            "VasExperts-Enable-Interconnect"               => "VasExperts",
            "VasExperts-Enable-Service"                    => "VasExperts",
            "VasExperts-Multi-IP-User"                     => "VasExperts",
            "VasExperts-NAT-IP"                            => "VasExperts",
            "VasExperts-OutMAC"                            => "VasExperts",
            "VasExperts-OutVLAN"                           => "VasExperts",
            "VasExperts-Policing-Profile"                  => "VasExperts",
            "VasExperts-Restrict-User"                     => "VasExperts",
            "VasExperts-Service-Profile"                   => "VasExperts",
            "VasExperts-Service-Type"                      => "VasExperts",
            "VasExperts-UserName"                          => "VasExperts",
            "Versanet-Termination-Cause"                   => "Versanet",
            "Vlan-Source-Info"                             => "Ericsson-AB",
            "VNC-PPPoE-CBQ-RX"                           => "ValemountNetworks",
            "VNC-PPPoE-CBQ-RX-Fallback"                  => "ValemountNetworks",
            "VNC-PPPoE-CBQ-TX"                           => "ValemountNetworks",
            "VNC-PPPoE-CBQ-TX-Fallback"                  => "ValemountNetworks",
            "VNC-Splash"                                 => "ValemountNetworks",
            "Waverider-Authentication-Key"               => "Waverider",
            "Waverider-Current-Password"                 => "Waverider",
            "Waverider-Grade-Of-Service"                 => "Waverider",
            "Waverider-Max-Customers"                    => "Waverider",
            "Waverider-New-Password"                     => "Waverider",
            "Waverider-Priority-Enabled"                 => "Waverider",
            "Waverider-Radio-Frequency"                  => "Waverider",
            "Waverider-Rf-Power"                         => "Waverider",
            "Waverider-SNMP-Contact"                     => "Waverider",
            "Waverider-SNMP-Location"                    => "Waverider",
            "Waverider-SNMP-Name"                        => "Waverider",
            "Waverider-SNMP-Read-Community"              => "Waverider",
            "Waverider-SNMP-Trap-Server"                 => "Waverider",
            "Waverider-SNMP-Write-Community"             => "Waverider",
            "WB-Auth-Accum-BW"                           => "Walabi",
            "WB-Auth-BW-Count"                           => "Walabi",
            "WB-Auth-BW-Quota"                           => "Walabi",
            "WB-Auth-BW-Usage"                           => "Walabi",
            "WB-Auth-Download-Limit"                     => "Walabi",
            "WB-Auth-Login-Time"                         => "Walabi",
            "WB-Auth-Logout-Time"                        => "Walabi",
            "WB-Auth-Time-Diff"                          => "Walabi",
            "WB-AUTH-Time-Left"                          => "Walabi",
            "WB-Auth-Upload-Limit"                       => "Walabi",
            "Wichorus-Policy-Name"                       => "Wichorus",
            "Wichorus-User-Privilege"                    => "Wichorus",
            "WiMAX-802.1p"                               => "WiMAX",
            "WiMAX-AAA-Session-Id"                       => "WiMAX",
            "WiMAX-Accounting-Capabilities"              => "WiMAX",
            "WiMAX-Acct-Input-Packets-Gigaword"          => "WiMAX",
            "WiMAX-Acct-Output-Packets-Gigaword"         => "WiMAX",
            "WiMAX-Activation-Trigger"                   => "WiMAX",
            "WiMAX-Active-Time-Duration"                 => "WiMAX",
            "WiMAX-AE-Command-Code"                      => "WiMAX",
            "WiMAX-Age-Of-Location-Information"          => "WiMAX",
            "WiMAX-ASN-Ethernet-Service-Capabilities"    => "WiMAX",
            "WiMAX-ASN-IP-Service-Capabilities"          => "WiMAX",
            "WiMAX-Authentication-Info"                  => "WiMAX",
            "WiMAX-Authorized-Anchor-Locations"          => "WiMAX",
            "WiMAX-Authorized-Ethernet-Services"         => "WiMAX",
            "WiMAX-Authorized-IP-Services"               => "WiMAX",
            "WiMAX-Available-In-Client"                  => "WiMAX",
            "WiMAX-Beginning-Of-Session"                 => "WiMAX",
            "WiMAX-Blu-Coa-IPv6"                         => "WiMAX",
            "WiMAX-BS-Id"                                => "WiMAX",
            "WiMAX-BS-Location"                          => "WiMAX",
            "WiMAX-Cancellation-Type"                    => "WiMAX",
            "WiMAX-Capability"                           => "WiMAX",
            "WiMAX-Check-Balance-Result"                 => "WiMAX",
            "WiMAX-Classifer-Direction"                  => "WiMAX",
            "WiMAX-Classifer-Priority"                   => "WiMAX",
            "WiMAX-Classifer-Protocol"                   => "WiMAX",
            "WiMAX-Classifier"                           => "WiMAX",
            "WiMAX-ClassifierID"                         => "WiMAX",
            "WiMAX-Control-Octets-In"                    => "WiMAX",
            "WiMAX-Control-Octets-Out"                   => "WiMAX",
            "WiMAX-Control-Packets-In"                   => "WiMAX",
            "WiMAX-Control-Packets-Out"                  => "WiMAX",
            "WiMAX-Cost-Information-AVP"                 => "WiMAX",
            "WiMAX-Count-Type"                           => "WiMAX",
            "WiMAX-Current-Location-Retrieved"           => "WiMAX",
            "WiMAX-Destination-Assigned"                 => "WiMAX",
            "WiMAX-Destination-Inverted"                 => "WiMAX",
            "WiMAX-Destination-IPAddress"                => "WiMAX",
            "WiMAX-Destination-IPAddressRange"           => "WiMAX",
            "WiMAX-Destination-Port"                     => "WiMAX",
            "WiMAX-Destination-Port-Range"               => "WiMAX",
            "WiMAX-Destination-Specification"            => "WiMAX",
            "WiMAX-Device-Authentication-Indicator"      => "WiMAX",
            "WiMAX-DGW-IPv4-addr"                        => "WiMAX",
            "WiMAX-DHCP-Msg-Server-IP"                   => "WiMAX",
            "WiMAX-DHCP-Option"                          => "WiMAX",
            "WiMAX-DHCP-Option-Container"                => "WiMAX",
            "WiMAX-DHCP-RK"                              => "WiMAX",
            "WiMAX-DHCP-RK-Key-Id"                       => "WiMAX",
            "WiMAX-DHCP-RK-Lifetime"                     => "WiMAX",
            "WiMAX-Direction"                            => "WiMAX",
            "WiMAX-DM-Action-Code"                       => "WiMAX",
            "WiMAX-Downlink-Classifier"                  => "WiMAX",
            "WiMAX-Downlink-Flow-Description"            => "WiMAX",
            "WiMAX-Downlink-Granted-QoS"                 => "WiMAX",
            "WiMAX-Downlink-QOS-Id"                      => "WiMAX",
            "WiMAX-Duration-Quota"                       => "WiMAX",
            "WiMAX-Duration-Threshold"                   => "WiMAX",
            "WiMAX-E-UTRAN-Cell-Global-Identity"         => "WiMAX",
            "WiMAX-E-UTRAN-Vector"                       => "WiMAX",
            "WiMAX-E-UTRAN-Vector-AUTN"                  => "WiMAX",
            "WiMAX-E-UTRAN-Vector-Item-Number"           => "WiMAX",
            "WiMAX-E-UTRAN-Vector-KASME"                 => "WiMAX",
            "WiMAX-E-UTRAN-Vector-RAND"                  => "WiMAX",
            "WiMAX-E-UTRAN-Vector-XRES"                  => "WiMAX",
            "WiMAX-EPS-Location-Information"             => "WiMAX",
            "WiMAX-FA-RK-Key"                            => "WiMAX",
            "WiMAX-FA-RK-SPI"                            => "WiMAX",
            "WiMAX-Flow-Descriptor-v2"                   => "WiMAX",
            "WiMAX-Geodetic-Information"                 => "WiMAX",
            "WiMAX-Geographical-Information"             => "WiMAX",
            "WiMAX-Global-Service-Class-Name"            => "WiMAX",
            "WiMAX-GMT-Timezone-offset"                  => "WiMAX",
            "WiMAX-HA-RK-Key"                            => "WiMAX",
            "WiMAX-HA-RK-Key-Requested"                  => "WiMAX",
            "WiMAX-HA-RK-Lifetime"                       => "WiMAX",
            "WiMAX-HA-RK-SPI"                            => "WiMAX",
            "WiMAX-hDHCP-DHCP-RK"                        => "WiMAX",
            "WiMAX-hDHCP-DHCP-RK-Key-Id"                 => "WiMAX",
            "WiMAX-hDHCP-DHCP-RK-Lifetime"               => "WiMAX",
            "WiMAX-hDHCP-DHCPv4-Address"                 => "WiMAX",
            "WiMAX-hDHCP-DHCPv6-Address"                 => "WiMAX",
            "WiMAX-hDHCP-Server-Parameters"              => "WiMAX",
            "WiMAX-hHA-IP-MIP4"                          => "WiMAX",
            "WiMAX-hHA-IP-MIP6"                          => "WiMAX",
            "WiMAX-hLMA-IPv4-PMIP6"                      => "WiMAX",
            "WiMAX-hLMA-IPv6-PMIP6"                      => "WiMAX",
            "WiMAX-Home-HNP-PMIP6"                       => "WiMAX",
            "WiMAX-Home-Interface-Id-PMIP6"              => "WiMAX",
            "WiMAX-Home-IPv4-HoA-PMIP6"                  => "WiMAX",
            "WiMAX-Hotline-Indicator"                    => "WiMAX",
            "WiMAX-Hotline-Profile-Id"                   => "WiMAX",
            "WiMAX-Hotline-Session-Timer"                => "WiMAX",
            "WiMAX-Hotlining-Capabilities"               => "WiMAX",
            "WiMAX-HTTP-Redirection-Rule"                => "WiMAX",
            "WiMAX-Idle-Mode-Notification-Cap"           => "WiMAX",
            "WiMAX-Idle-Mode-Transition"                 => "WiMAX",
            "WiMAX-IMEI"                                 => "WiMAX",
            "WiMAX-Immediate-Response-Preferred"         => "WiMAX",
            "WiMAX-IP-Redirection-Rule"                  => "WiMAX",
            "WiMAX-IP-Technology"                        => "WiMAX",
            "WiMAX-IP-TOS/DSCP-Range-and-Mask"           => "WiMAX",
            "WiMAX-IPv4-addr"                            => "WiMAX",
            "WiMAX-IPv4-Netmask"                         => "WiMAX",
            "WiMAX-Location"                             => "WiMAX",
            "WiMAX-Maximum-Latency"                      => "WiMAX",
            "WiMAX-Maximum-Sustained-Traffic-Rate"       => "WiMAX",
            "WiMAX-Maximum-Traffic-Burst"                => "WiMAX",
            "WiMAX-Media-Flow-Description-SDP"           => "WiMAX",
            "WiMAX-Media-Flow-Type"                      => "WiMAX",
            "WiMAX-Minimum-Reserved-Traffic-Rate"        => "WiMAX",
            "WiMAX-MIP-Authorization-Status"             => "WiMAX",
            "WiMAX-MN-hHA-MIP4-Key"                      => "WiMAX",
            "WiMAX-MN-hHA-MIP4-SPI"                      => "WiMAX",
            "WiMAX-MN-hHA-MIP6-Key"                      => "WiMAX",
            "WiMAX-MN-hHA-MIP6-SPI"                      => "WiMAX",
            "WiMAX-MN-vHA-MIP4-SPI"                      => "WiMAX",
            "WiMAX-MN-vHA-MIP6-Key"                      => "WiMAX",
            "WiMAX-MN-vHA-MIP6-SPI"                      => "WiMAX",
            "WiMAX-MS-Authenticated"                     => "WiMAX",
            "WiMAX-MSK"                                  => "WiMAX",
            "WiMAX-NAP-Id"                               => "WiMAX",
            "WiMAX-NSP-Id"                               => "WiMAX",
            "WiMAX-Number-Of-Requested-Vectors"          => "WiMAX",
            "WiMAX-Packet-Data-Flow-Id"                  => "WiMAX",
            "WiMAX-Packet-Flow-Descriptor"               => "WiMAX",
            "WiMAX-Packet-Flow-Descriptor-v2"            => "WiMAX",
            "WiMAX-PDFID"                                => "WiMAX",
            "WiMAX-PFDv2-Activation-Trigger"             => "WiMAX",
            "WiMAX-PFDv2-Classifier"                     => "WiMAX",
            "WiMAX-PFDv2-Classifier-Action"              => "WiMAX",
            "WiMAX-PFDv2-Classifier-Dest-Spec"           => "WiMAX",
            "WiMAX-PFDv2-Classifier-Direction"           => "WiMAX",
            "WiMAX-PFDv2-Classifier-Eth-Option"          => "WiMAX",
            "WiMAX-PFDv2-Classifier-Id"                  => "WiMAX",
            "WiMAX-PFDv2-Classifier-IP-ToS-DSCP"         => "WiMAX",
            "WiMAX-PFDv2-Classifier-Priority"            => "WiMAX",
            "WiMAX-PFDv2-Classifier-Protocol"            => "WiMAX",
            "WiMAX-PFDv2-Classifier-Source-Spec"         => "WiMAX",
            "WiMAX-PFDv2-Direction"                      => "WiMAX",
            "WiMAX-PFDv2-Downlink-QoS-Id"                => "WiMAX",
            "WiMAX-PFDv2-Eth-Priority-Range"             => "WiMAX",
            "WiMAX-PFDv2-Eth-Priority-Range-High"        => "WiMAX",
            "WiMAX-PFDv2-Eth-Priority-Range-Low"         => "WiMAX",
            "WiMAX-PFDv2-Eth-Proto-Type"                 => "WiMAX",
            "WiMAX-PFDv2-Eth-Proto-Type-DSAP"            => "WiMAX",
            "WiMAX-PFDv2-Eth-Proto-Type-Ethertype"       => "WiMAX",
            "WiMAX-PFDv2-Eth-VLAN-Id"                    => "WiMAX",
            "WiMAX-PFDv2-Eth-VLAN-Id-C-VID"              => "WiMAX",
            "WiMAX-PFDv2-Eth-VLAN-Id-S-VID"              => "WiMAX",
            "WiMAX-PFDv2-Packet-Data-Flow-Id"            => "WiMAX",
            "WiMAX-PFDv2-Paging-Preference"              => "WiMAX",
            "WiMAX-PFDv2-Service-Data-Flow-Id"           => "WiMAX",
            "WiMAX-PFDv2-Service-Profile-Id"             => "WiMAX",
            "WiMAX-PFDv2-Src-Assigned"                   => "WiMAX",
            "WiMAX-PFDv2-Src-Inverted"                   => "WiMAX",
            "WiMAX-PFDv2-Src-IP-Address-Range"           => "WiMAX",
            "WiMAX-PFDv2-Src-MAC-Address"                => "WiMAX",
            "WiMAX-PFDv2-Src-MAC-Mask"                   => "WiMAX",
            "WiMAX-PFDv2-Src-Port"                       => "WiMAX",
            "WiMAX-PFDv2-Src-Port-Range"                 => "WiMAX",
            "WiMAX-PFDv2-Transport-Type"                 => "WiMAX",
            "WiMAX-PFDv2-Uplink-QoS-Id"                  => "WiMAX",
            "WiMAX-PFDv2-VLAN-Tag-Rule-Id"               => "WiMAX",
            "WiMAX-PMIP-Authenticated-Network-Identity"  => "WiMAX",
            "WiMAX-PMIP6-RK-Key"                         => "WiMAX",
            "WiMAX-PMIP6-RK-SPI"                         => "WiMAX",
            "WiMAX-PMIP6-Service-Info"                   => "WiMAX",
            "WiMAX-Pool-Id"                              => "WiMAX",
            "WiMAX-Pool-Multiplier"                      => "WiMAX",
            "WiMAX-PPAC"                                 => "WiMAX",
            "WiMAX-PPAQ"                                 => "WiMAX",
            "WiMAX-PPAQ-Quota-Identifier"                => "WiMAX",
            "WiMAX-Prepaid-Indicator"                    => "WiMAX",
            "WiMAX-Prepaid-Quota-Identifier"             => "WiMAX",
            "WiMAX-Prepaid-Tariff-Switching"             => "WiMAX",
            "WiMAX-QoS-Descriptor"                       => "WiMAX",
            "WiMAX-QoS-Id"                               => "WiMAX",
            "WiMAX-R3-IF-Descriptor"                     => "WiMAX",
            "WiMAX-R3-IF-ID"                             => "WiMAX",
            "WiMAX-R3-IF-Name"                           => "WiMAX",
            "WiMAX-RAT-Type"                             => "WiMAX",
            "WiMAX-Rating-Group-Id"                      => "WiMAX",
            "WiMAX-Re-synchronization-Info"              => "WiMAX",
            "WiMAX-Reduced-Resources-Code"               => "WiMAX",
            "WiMAX-Ref-R3-IF-Name"                       => "WiMAX",
            "WiMAX-Release"                              => "WiMAX",
            "WiMAX-Requested-Action"                     => "WiMAX",
            "WiMAX-Requested-EUTRAN-Authentication-Info" => "WiMAX",
            "WiMAX-Resource-Quota"                       => "WiMAX",
            "WiMAX-Resource-Threshold"                   => "WiMAX",
            "WiMAX-RRQ-MN-HA-Key"                        => "WiMAX",
            "WiMAX-RRQ-MN-HA-SPI"                        => "WiMAX",
            "WiMAX-Schedule-Type"                        => "WiMAX",
            "WiMAX-SDFID"                                => "WiMAX",
            "WiMAX-SDU-Size"                             => "WiMAX",
            "WiMAX-Service-Class-Name"                   => "WiMAX",
            "WiMAX-Service-Data-Flow-Id"                 => "WiMAX",
            "WiMAX-Service-Id"                           => "WiMAX",
            "WiMAX-Service-Profile-Id"                   => "WiMAX",
            "WiMAX-Service-Selection"                    => "WiMAX",
            "WiMAX-Session-Continue"                     => "WiMAX",
            "WiMAX-Session-Termination-Capability"       => "WiMAX",
            "WiMAX-Software-Version"                     => "WiMAX",
            "WiMAX-Source-Assigned"                      => "WiMAX",
            "WiMAX-Source-Inverted"                      => "WiMAX",
            "WiMAX-Source-IPAddress"                     => "WiMAX",
            "WiMAX-Source-IPAddressRange"                => "WiMAX",
            "WiMAX-Source-Port"                          => "WiMAX",
            "WiMAX-Source-Port-Range"                    => "WiMAX",
            "WiMAX-Source-Specification"                 => "WiMAX",
            "WiMAX-Subscription-Data"                    => "WiMAX",
            "WiMAX-Tariff-Switch-Interval"               => "WiMAX",
            "WiMAX-Terminal-Information"                 => "WiMAX",
            "WiMAX-Termination-Action"                   => "WiMAX",
            "WiMAX-Time-Interval-After"                  => "WiMAX",
            "WiMAX-Tolerated-Jitter"                     => "WiMAX",
            "WiMAX-Tracking-Area-Identity"               => "WiMAX",
            "WiMAX-Traffic-Priority"                     => "WiMAX",
            "WiMAX-Transport-Type"                       => "WiMAX",
            "WiMAX-UE-AMBR-DL"                           => "WiMAX",
            "WiMAX-UE-AMBR-UL"                           => "WiMAX",
            "WiMAX-Unsolicited-Grant-Interval"           => "WiMAX",
            "WiMAX-Unsolicited-Polling-Interval"         => "WiMAX",
            "WiMAX-Update-Reason"                        => "WiMAX",
            "WiMAX-Uplink-Classifier"                    => "WiMAX",
            "WiMAX-Uplink-Flow-Description"              => "WiMAX",
            "WiMAX-Uplink-Granted-QoS"                   => "WiMAX",
            "WiMAX-Uplink-QOS-Id"                        => "WiMAX",
            "WiMAX-VCSN-Ethernet-Service-Capabilities"   => "WiMAX",
            "WiMAX-VCSN-IP-Service-Capabilities"         => "WiMAX",
            "WiMAX-vDHCP-DHCP-RK"                        => "WiMAX",
            "WiMAX-vDHCP-DHCP-RK-Key-Id"                 => "WiMAX",
            "WiMAX-vDHCP-DHCP-RK-Lifetime"               => "WiMAX",
            "WiMAX-vDHCP-DHCPv4-Address"                 => "WiMAX",
            "WiMAX-vDHCP-DHCPv6-Address"                 => "WiMAX",
            "WiMAX-vDHCP-RK"                             => "WiMAX",
            "WiMAX-vDHCP-RK-Key-ID"                      => "WiMAX",
            "WiMAX-vDHCP-RK-Lifetime"                    => "WiMAX",
            "WiMAX-vDHCP-Server-Parameters"              => "WiMAX",
            "WiMAX-vDHCPv4-Server"                       => "WiMAX",
            "WiMAX-vDHCPv6-Server"                       => "WiMAX",
            "WiMAX-vHA-IP-MIP4"                          => "WiMAX",
            "WiMAX-vHA-IP-MIP6"                          => "WiMAX",
            "WiMAX-vHA-MIP4-Key"                         => "WiMAX",
            "WiMAX-vHA-RK-Key"                           => "WiMAX",
            "WiMAX-vHA-RK-Lifetime"                      => "WiMAX",
            "WiMAX-vHA-RK-SPI"                           => "WiMAX",
            "WiMAX-Visited-Framed-Interface-Id"          => "WiMAX",
            "WiMAX-Visited-Framed-IP-Address"            => "WiMAX",
            "WiMAX-Visited-Framed-IPv6-Prefix"           => "WiMAX",
            "WiMAX-Visited-HNP-PMIP6"                    => "WiMAX",
            "WiMAX-Visited-Interface-Id-PMIP6"           => "WiMAX",
            "WiMAX-Visited-IPv4-HoA-PMIP6"               => "WiMAX",
            "WiMAX-Visited-IPv4-HoA-PMIP6-2"             => "WiMAX",
            "WiMAX-Visited-PLMN-ID"                      => "WiMAX",
            "WiMAX-VLAN-ID"                              => "WiMAX",
            "WiMAX-VLAN-Tag-C-S-VLAN-Id-Mapping"         => "WiMAX",
            "WiMAX-VLAN-Tag-C-VLAN-Id"                   => "WiMAX",
            "WiMAX-VLAN-Tag-C-VLAN-Priority"             => "WiMAX",
            "WiMAX-VLAN-Tag-Local-Config-Info"           => "WiMAX",
            "WiMAX-VLAN-Tag-Processing-Descriptor"       => "WiMAX",
            "WiMAX-VLAN-Tag-Rule-Id"                     => "WiMAX",
            "WiMAX-VLAN-Tag-S-VLAN-Id"                   => "WiMAX",
            "WiMAX-VLAN-Tag-VLAN-Id-Assignment"          => "WiMAX",
            "WiMAX-vLMA-IPv4-PMIP6"                      => "WiMAX",
            "WiMAX-vLMA-IPv6-PMIP6"                      => "WiMAX",
            "WiMAX-Volume-Quota"                         => "WiMAX",
            "WiMAX-Volume-Threshold"                     => "WiMAX",
            "WiMAX-Volume-Used-After"                    => "WiMAX",
            "WiMAX-XXX"                                  => "WiMAX",
            "WISPr-Bandwidth-Max-Down"                   => "WISPr",
            "WISPr-Bandwidth-Max-Up"                     => "WISPr",
            "WISPr-Bandwidth-Min-Down"                   => "WISPr",
            "WISPr-Bandwidth-Min-Up"                     => "WISPr",
            "WISPr-Billing-Class-Of-Service"             => "WISPr",
            "WISPr-Location-ID"                          => "WISPr",
            "WISPr-Location-Name"                        => "WISPr",
            "WISPr-Logoff-URL"                           => "WISPr",
            "WISPr-Redirection-URL"                      => "WISPr",
            "WISPr-Session-Terminate-End-Of-Day"         => "WISPr",
            "WISPr-Session-Terminate-Time"               => "WISPr",
            "Xedia-Address-Pool"                         => "Xedia",
            "Xedia-Client-Access-Network"                => "Xedia",
            "Xedia-Client-Firewall-Setting"              => "Xedia",
            "Xedia-DNS-Server"                           => "Xedia",
            "Xedia-NetBios-Server"                       => "Xedia",
            "Xedia-PPP-Echo-Interval"                    => "Xedia",
            "Xedia-Save-Password"                        => "Xedia",
            "Xedia-SSH-Privileges"                       => "Xedia",
            "Xylan-Acce-Priv-F-R1"                       => "Xylan",
            "Xylan-Acce-Priv-F-R2"                       => "Xylan",
            "Xylan-Acce-Priv-F-W1"                       => "Xylan",
            "Xylan-Acce-Priv-F-W2"                       => "Xylan",
            "Xylan-Acce-Priv-G1"                         => "Xylan",
            "Xylan-Acce-Priv-G2"                         => "Xylan",
            "Xylan-Acce-Priv-R1"                         => "Xylan",
            "Xylan-Acce-Priv-R2"                         => "Xylan",
            "Xylan-Acce-Priv-W1"                         => "Xylan",
            "Xylan-Acce-Priv-W2"                         => "Xylan",
            "Xylan-Access-Priv"                          => "Xylan",
            "Xylan-Asa-Access"                           => "Xylan",
            "Xylan-Auth-Group"                           => "Xylan",
            "Xylan-Auth-Group-Protocol"                  => "Xylan",
            "Xylan-Client-IP-Addr"                       => "Xylan",
            "Xylan-Device-Location"                      => "Xylan",
            "Xylan-Device-Name"                          => "Xylan",
            "Xylan-End-User-Profile"                     => "Xylan",
            "Xylan-Group-Desc"                           => "Xylan",
            "Xylan-Home-Agent-Password"                  => "Xylan",
            "Xylan-Home-Network-Name"                    => "Xylan",
            "Xylan-Nms-Description"                      => "Xylan",
            "Xylan-Nms-First-Name"                       => "Xylan",
            "Xylan-Nms-Group"                            => "Xylan",
            "Xylan-Nms-Last-Name"                        => "Xylan",
            "Xylan-Policy-List"                          => "Xylan",
            "Xylan-Port-Desc"                            => "Xylan",
            "Xylan-Primary-Home-Agent"                   => "Xylan",
            "Xylan-Profil-Numb"                          => "Xylan",
            "Xylan-Redirect-Url"                         => "Xylan",
            "Xylan-Secondary-Home-Agent"                 => "Xylan",
            "Xylan-Slot-Port"                            => "Xylan",
            "Xylan-Time-of-Day"                          => "Xylan",
            "Yubikey-Counter"                            => "Yubico",
            "Yubikey-Key"                                => "Yubico",
            "Yubikey-OTP"                                => "Yubico",
            "Yubikey-Private-ID"                         => "Yubico",
            "Yubikey-Public-ID"                          => "Yubico",
            "Yubikey-Random"                             => "Yubico",
            "Yubikey-Timestamp"                          => "Yubico",
            "Zeus-ZXTM-Group"                            => "Zeus",
            "ZTE-Access-Domain"                          => "ZTE",
            "ZTE-Access-Type"                            => "ZTE",
            "ZTE-Client-DNS-Pri"                         => "ZTE",
            "ZTE-Client-DNS-Sec"                         => "ZTE",
            "ZTE-Context-Name"                           => "ZTE",
            "ZTE-IGMP-Service-Profile-Num"               => "ZTE",
            "ZTE-Mcast-MaxGroups"                        => "ZTE",
            "ZTE-Mcast-Receive"                          => "ZTE",
            "ZTE-Mcast-Send"                             => "ZTE",
            "ZTE-PPP-Sservice-Type"                      => "ZTE",
            "ZTE-PPPOE-MOTM"                             => "ZTE",
            "ZTE-PPPOE-URL"                              => "ZTE",
            "ZTE-Priority-Level"                         => "ZTE",
            "ZTE-QoS-Profile-Down"                       => "ZTE",
            "ZTE-QoS-Profile-Down-v6"                    => "ZTE",
            "ZTE-QOS-Profile-Up"                         => "ZTE",
            "ZTE-QoS-Profile-Up-v6"                      => "ZTE",
            "ZTE-QoS-Type"                               => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Down"                   => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Down-v6"                => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Max-Down"               => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Max-Down-v6"            => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Max-Up"                 => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Max-Up-v6"              => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Up"                     => "ZTE",
            "ZTE-Rate-Ctrl-Burst-Up-v6"                  => "ZTE",
            "ZTE-Rate-Ctrl-PBS-Down"                     => "ZTE",
            "ZTE-Rate-Ctrl-PBS-Down-v6"                  => "ZTE",
            "ZTE-Rate-Ctrl-PBS-Up"                       => "ZTE",
            "ZTE-Rate-Ctrl-PBS-Up-v6"                    => "ZTE",
            "ZTE-Rate-Ctrl-PCR"                          => "ZTE",
            "ZTE-Rate-Ctrl-SCR-Down"                     => "ZTE",
            "ZTE-Rate-Ctrl-SCR-Down-v6"                  => "ZTE",
            "ZTE-Rate-Ctrl-SCR-Up"                       => "ZTE",
            "ZTE-Rate-Ctrl-SCR-Up-v6"                    => "ZTE",
            "ZTE-SW-Privilege"                           => "ZTE",
            "ZTE-TCP-Limit-Mode"                         => "ZTE",
            "ZTE-TCP-Limit-Num"                          => "ZTE",
            "ZTE-TCP-Syn-Rate"                           => "ZTE",
            "ZTE-Tunnel-Algorithm"                       => "ZTE",
            "ZTE-Tunnel-Cmd-Timeout"                     => "ZTE",
            "ZTE-Tunnel-Deadtime"                        => "ZTE",
            "ZTE-Tunnel-Max-Sessions"                    => "ZTE",
            "ZTE-Tunnel-Max-Tunnels"                     => "ZTE",
            "ZTE-Tunnel-Retransmit"                      => "ZTE",
            "ZTE-Tunnel-Window"                          => "ZTE",
            "ZTE-VPN-ID"                                 => "ZTE",
            "ZTE_Rate-Bust-DPIR"                         => "ZTE",
            "ZTE_Rate-Bust-UPIR"                         => "ZTE",
            "Zyxel-Callback-Option"                      => "Zyxel",
            "Zyxel-Callback-Phone-Source"                => "Zyxel",
            "Zyxel-Privilege-AVPair"                     => "Zyxel",
        },
        rattr => {
            1    => [ "User-Name",                              "string" ],
            2    => [ "User-Password",                          "string" ],
            3    => [ "CHAP-Password",                          "octets" ],
            4    => [ "NAS-IP-Address",                         "ipaddr" ],
            5    => [ "NAS-Port",                               "integer" ],
            6    => [ "Service-Type",                           "integer" ],
            7    => [ "Framed-Protocol",                        "integer" ],
            8    => [ "Framed-IP-Address",                      "ipaddr" ],
            9    => [ "Framed-IP-Netmask",                      "ipaddr" ],
            10   => [ "Framed-Routing",                         "integer" ],
            11   => [ "Filter-Id",                              "string" ],
            12   => [ "Framed-MTU",                             "integer" ],
            13   => [ "Framed-Compression",                     "integer" ],
            14   => [ "Login-IP-Host",                          "ipaddr" ],
            15   => [ "Login-Service",                          "integer" ],
            16   => [ "Login-TCP-Port",                         "integer" ],
            17   => [ "Old-Password",                           "string" ],
            18   => [ "Reply-Message",                          "string" ],
            19   => [ "Callback-Number",                        "string" ],
            20   => [ "Callback-Id",                            "string" ],
            22   => [ "Framed-Route",                           "string" ],
            23   => [ "Framed-IPX-Network",                     "ipaddr" ],
            24   => [ "State",                                  "octets" ],
            25   => [ "Class",                                  "octets" ],
            26   => [ "Vendor-Specific",                        "vsa" ],
            27   => [ "Session-Timeout",                        "integer" ],
            28   => [ "Idle-Timeout",                           "integer" ],
            29   => [ "Termination-Action",                     "integer" ],
            30   => [ "Called-Station-Id",                      "string" ],
            31   => [ "Calling-Station-Id",                     "string" ],
            32   => [ "NAS-Identifier",                         "string" ],
            33   => [ "Proxy-State",                            "octets" ],
            34   => [ "Login-LAT-Service",                      "string" ],
            35   => [ "Login-LAT-Node",                         "string" ],
            36   => [ "Login-LAT-Group",                        "octets" ],
            37   => [ "Framed-AppleTalk-Link",                  "integer" ],
            38   => [ "Framed-AppleTalk-Network",               "integer" ],
            39   => [ "Framed-AppleTalk-Zone",                  "string" ],
            40   => [ "Acct-Status-Type",                       "integer" ],
            41   => [ "Acct-Delay-Time",                        "integer" ],
            42   => [ "Acct-Input-Octets",                      "integer" ],
            43   => [ "Acct-Output-Octets",                     "integer" ],
            44   => [ "Acct-Session-Id",                        "string" ],
            45   => [ "Acct-Authentic",                         "integer" ],
            46   => [ "Acct-Session-Time",                      "integer" ],
            47   => [ "Acct-Input-Packets",                     "integer" ],
            48   => [ "Acct-Output-Packets",                    "integer" ],
            49   => [ "Acct-Terminate-Cause",                   "integer" ],
            50   => [ "Acct-Multi-Session-Id",                  "string" ],
            51   => [ "Acct-Link-Count",                        "integer" ],
            52   => [ "Acct-Input-Gigawords",                   "integer" ],
            53   => [ "Acct-Output-Gigawords",                  "integer" ],
            55   => [ "Event-Timestamp",                        "date" ],
            56   => [ "Egress-VLANID",                          "integer" ],
            57   => [ "Ingress-Filters",                        "integer" ],
            58   => [ "Egress-VLAN-Name",                       "string" ],
            59   => [ "User-Priority-Table",                    "octets" ],
            60   => [ "CHAP-Challenge",                         "octets" ],
            61   => [ "NAS-Port-Type",                          "integer" ],
            62   => [ "Port-Limit",                             "integer" ],
            63   => [ "Login-LAT-Port",                         "string" ],
            64   => [ "Tunnel-Type",                            "integer" ],
            65   => [ "Tunnel-Medium-Type",                     "integer" ],
            66   => [ "Tunnel-Client-Endpoint",                 "string" ],
            67   => [ "Tunnel-Server-Endpoint",                 "string" ],
            68   => [ "Acct-Tunnel-Connection",                 "string" ],
            69   => [ "Tunnel-Password",                        "string" ],
            70   => [ "ARAP-Password",                          "octets" ],
            71   => [ "ARAP-Features",                          "octets" ],
            72   => [ "ARAP-Zone-Access",                       "integer" ],
            73   => [ "ARAP-Security",                          "integer" ],
            74   => [ "ARAP-Security-Data",                     "string" ],
            75   => [ "Password-Retry",                         "integer" ],
            76   => [ "Prompt",                                 "integer" ],
            77   => [ "Connect-Info",                           "string" ],
            78   => [ "Configuration-Token",                    "string" ],
            79   => [ "EAP-Message",                            "octets" ],
            80   => [ "Message-Authenticator",                  "octets" ],
            81   => [ "Tunnel-Private-Group-Id",                "string" ],
            82   => [ "Tunnel-Assignment-Id",                   "string" ],
            83   => [ "Tunnel-Preference",                      "integer" ],
            84   => [ "ARAP-Challenge-Response",                "octets" ],
            85   => [ "Acct-Interim-Interval",                  "integer" ],
            86   => [ "Acct-Tunnel-Packets-Lost",               "integer" ],
            87   => [ "NAS-Port-Id",                            "string" ],
            88   => [ "Framed-Pool",                            "string" ],
            89   => [ "Chargeable-User-Identity",               "octets" ],
            90   => [ "Tunnel-Client-Auth-Id",                  "string" ],
            91   => [ "Tunnel-Server-Auth-Id",                  "string" ],
            92   => [ "NAS-Filter-Rule",                        "string" ],
            94   => [ "Originating-Line-Info",                  "octets" ],
            95   => [ "NAS-IPv6-Address",                       "ipv6addr" ],
            96   => [ "Framed-Interface-Id",                    "ifid" ],
            97   => [ "Framed-IPv6-Prefix",                     "ipv6prefix" ],
            98   => [ "Login-IPv6-Host",                        "ipv6addr" ],
            99   => [ "Framed-IPv6-Route",                      "string" ],
            100  => [ "Framed-IPv6-Pool",                       "string" ],
            101  => [ "Error-Cause",                            "integer" ],
            102  => [ "EAP-Key-Name",                           "octets" ],
            119  => [ "X-Ascend-FCP-Parameter",                 "string" ],
            120  => [ "X-Ascend-Modem-PortNo",                  "integer" ],
            121  => [ "X-Ascend-Modem-SlotNo",                  "integer" ],
            122  => [ "X-Ascend-Modem-ShelfNo",                 "integer" ],
            123  => [ "Delegated-IPv6-Prefix",                  "ipv6prefix" ],
            124  => [ "MIP6-Feature-Vector",                    "integer64" ],
            125  => [ "MIP6-Home-Link-Prefix",                  "octets" ],
            126  => [ "Operator-Name",                          "string" ],
            127  => [ "Location-Information",                   "octets" ],
            128  => [ "Location-Data",                          "octets" ],
            129  => [ "Basic-Location-Policy-Rules",            "octets" ],
            130  => [ "Extended-Location-Policy-Rules",         "string" ],
            131  => [ "Location-Capable",                       "integer" ],
            132  => [ "Requested-Location-Info",                "integer" ],
            133  => [ "Framed-Management",                      "integer" ],
            134  => [ "Management-Transport-Protection",        "integer" ],
            135  => [ "Management-Policy-Id",                   "string" ],
            136  => [ "Management-Privilege-Level",             "integer" ],
            137  => [ "PKM-SS-Cert",                            "octets" ],
            138  => [ "PKM-CA-Cert",                            "octets" ],
            139  => [ "PKM-Config-Settings",                    "octets" ],
            140  => [ "PKM-Cryptosuite-List",                   "octets" ],
            141  => [ "PKM-SAID",                               "short" ],
            142  => [ "PKM-SA-Descriptor",                      "octets" ],
            143  => [ "PKM-Auth-Key",                           "octets" ],
            144  => [ "DS-Lite-Tunnel-Name",                    "octets" ],
            145  => [ "Mobile-Node-Identifier",                 "octets" ],
            146  => [ "Service-Selection",                      "string" ],
            147  => [ "PMIP6-Home-LMA-IPv6-Address",            "ipv6addr" ],
            148  => [ "PMIP6-Visited-LMA-IPv6-Address",         "ipv6addr" ],
            149  => [ "PMIP6-Home-LMA-IPv4-Address",            "ipaddr" ],
            150  => [ "PMIP6-Visited-LMA-IPv4-Address",         "ipaddr" ],
            151  => [ "PMIP6-Home-HN-Prefix",                   "ipv6prefix" ],
            152  => [ "PMIP6-Visited-HN-Prefix",                "ipv6prefix" ],
            153  => [ "PMIP6-Home-Interface-ID",                "ifid" ],
            154  => [ "PMIP6-Visited-Interface-ID",             "ifid" ],
            155  => [ "PMIP6-Home-IPv4-HoA",                    "ipv4prefix" ],
            156  => [ "PMIP6-Visited-IPv4-HoA",                 "ipv4prefix" ],
            157  => [ "PMIP6-Home-DHCP4-Server-Address",        "ipaddr" ],
            158  => [ "PMIP6-Visited-DHCP4-Server-Address",     "ipaddr" ],
            159  => [ "PMIP6-Home-DHCP6-Server-Address",        "ipv6addr" ],
            160  => [ "PMIP6-Visited-DHCP6-Server-Address",     "ipv6addr" ],
            161  => [ "PMIP6-Home-IPv4-Gateway",                "ipaddr" ],
            162  => [ "PMIP6-Visited-IPv4-Gateway",             "ipaddr" ],
            163  => [ "EAP-Lower-Layer",                        "integer" ],
            164  => [ "GSS-Acceptor-Service-Name",              "string" ],
            165  => [ "GSS-Acceptor-Host-Name",                 "string" ],
            166  => [ "GSS-Acceptor-Service-Specifics",         "string" ],
            167  => [ "GSS-Acceptor-Realm-Name",                "string" ],
            168  => [ "Framed-IPv6-Address",                    "ipv6addr" ],
            169  => [ "DNS-Server-IPv6-Address",                "ipv6addr" ],
            170  => [ "Route-IPv6-Information",                 "ipv6prefix" ],
            171  => [ "Delegated-IPv6-Prefix-Pool",             "string" ],
            172  => [ "Stateful-IPv6-Address-Pool",             "string" ],
            173  => [ "IPv6-6rd-BR-IPv4-Address",               "ipaddr" ],
            174  => [ "Allowed-Called-Station-Id",              "string" ],
            175  => [ "EAP-Peer-Id",                            "octets" ],
            176  => [ "EAP-Server-Id",                          "octets" ],
            177  => [ "Mobility-Domain-Id",                     "integer" ],
            178  => [ "Preauth-Timeout",                        "integer" ],
            179  => [ "Network-Id-Name",                        "octets" ],
            180  => [ "EAPoL-Announcement",                     "octets" ],
            181  => [ "WLAN-HESSID",                            "string" ],
            182  => [ "WLAN-Venue-Info",                        "integer" ],
            183  => [ "WLAN-Venue-Language",                    "octets" ],
            184  => [ "WLAN-Venue-Name",                        "string" ],
            185  => [ "WLAN-Reason-Code",                       "integer" ],
            186  => [ "WLAN-Pairwise-Cipher",                   "integer" ],
            187  => [ "WLAN-Group-Cipher",                      "integer" ],
            188  => [ "WLAN-AKM-Suite",                         "integer" ],
            189  => [ "WLAN-Group-Mgmt-Cipher",                 "integer" ],
            190  => [ "WLAN-RF-Band",                           "integer" ],
            191  => [ "X-Ascend-Pre-Output-Octets",             "integer" ],
            192  => [ "X-Ascend-Pre-Input-Packets",             "integer" ],
            193  => [ "X-Ascend-Pre-Output-Packets",            "integer" ],
            194  => [ "X-Ascend-Maximum-Time",                  "integer" ],
            195  => [ "X-Ascend-Disconnect-Cause",              "integer" ],
            196  => [ "X-Ascend-Connect-Progress",              "integer" ],
            197  => [ "X-Ascend-Data-Rate",                     "integer" ],
            198  => [ "X-Ascend-PreSession-Time",               "integer" ],
            199  => [ "X-Ascend-Token-Idle",                    "integer" ],
            200  => [ "X-Ascend-Token-Immediate",               "integer" ],
            201  => [ "X-Ascend-Require-Auth",                  "integer" ],
            202  => [ "X-Ascend-Number-Sessions",               "string" ],
            203  => [ "X-Ascend-Authen-Alias",                  "string" ],
            204  => [ "X-Ascend-Token-Expiry",                  "integer" ],
            205  => [ "X-Ascend-Menu-Selector",                 "string" ],
            206  => [ "Digest-Response",                        "string" ],
            207  => [ "Digest-Attributes",                      "octets" ],
            208  => [ "X-Ascend-PW-Lifetime",                   "integer" ],
            209  => [ "X-Ascend-IP-Direct",                     "ipaddr" ],
            210  => [ "X-Ascend-PPP-VJ-Slot-Comp",              "integer" ],
            211  => [ "X-Ascend-PPP-VJ-1172",                   "integer" ],
            212  => [ "X-Ascend-PPP-Async-Map",                 "integer" ],
            213  => [ "X-Ascend-Third-Prompt",                  "string" ],
            214  => [ "X-Ascend-Send-Secret",                   "string" ],
            215  => [ "X-Ascend-Receive-Secret",                "string" ],
            216  => [ "X-Ascend-IPX-Peer-Mode",                 "integer" ],
            217  => [ "X-Ascend-IP-Pool-Definition",            "string" ],
            218  => [ "X-Ascend-Assign-IP-Pool",                "integer" ],
            219  => [ "X-Ascend-FR-Direct",                     "integer" ],
            220  => [ "Calix-CMS-User-Group",                   "string" ],
            221  => [ "Calix-CMS-Alarm-Filter",                 "integer" ],
            222  => [ "Calix-CMS-Event-Filter",                 "integer" ],
            223  => [ "Calix-CMS-Threshold-Event-Filter",       "integer" ],
            224  => [ "X-Ascend-IPX-Alias",                     "integer" ],
            225  => [ "X-Ascend-Metric",                        "integer" ],
            226  => [ "X-Ascend-PRI-Number-Type",               "integer" ],
            227  => [ "X-Ascend-Dial-Number",                   "string" ],
            228  => [ "X-Ascend-Route-IP",                      "integer" ],
            229  => [ "X-Ascend-Route-IPX",                     "integer" ],
            230  => [ "X-Ascend-Bridge",                        "integer" ],
            231  => [ "X-Ascend-Send-Auth",                     "integer" ],
            232  => [ "X-Ascend-Send-Passwd",                   "string" ],
            233  => [ "X-Ascend-Link-Compression",              "integer" ],
            234  => [ "X-Ascend-Target-Util",                   "integer" ],
            235  => [ "X-Ascend-Maximum-Channels",              "integer" ],
            236  => [ "X-Ascend-Inc-Channel-Count",             "integer" ],
            237  => [ "X-Ascend-Dec-Channel-Count",             "integer" ],
            238  => [ "X-Ascend-Seconds-Of-History",            "integer" ],
            239  => [ "X-Ascend-History-Weigh-Type",            "integer" ],
            240  => [ "X-Ascend-Add-Seconds",                   "integer" ],
            241  => [ "Operator-NAS-Identifier",                "octets" ],
            242  => [ "X-Ascend-Data-Filter",                   "abinary" ],
            243  => [ "X-Ascend-Call-Filter",                   "abinary" ],
            244  => [ "X-Ascend-Idle-Limit",                    "integer" ],
            245  => [ "X-Ascend-Preempt-Limit",                 "integer" ],
            246  => [ "X-Ascend-Callback",                      "integer" ],
            247  => [ "X-Ascend-Data-Svc",                      "integer" ],
            248  => [ "X-Ascend-Force-56",                      "integer" ],
            249  => [ "X-Ascend-Billing-Number",                "string" ],
            250  => [ "X-Ascend-Call-By-Call",                  "integer" ],
            251  => [ "X-Ascend-Transit-Number",                "string" ],
            252  => [ "X-Ascend-Host-Info",                     "string" ],
            253  => [ "X-Ascend-PPP-Address",                   "ipaddr" ],
            254  => [ "X-Ascend-MPP-Idle-Percent",              "integer" ],
            255  => [ "X-Ascend-Xmit-Rate",                     "integer" ],
            500  => [ "Fall-Through",                           "integer" ],
            501  => [ "Relax-Filter",                           "integer" ],
            502  => [ "Exec-Program",                           "string" ],
            503  => [ "Exec-Program-Wait",                      "string" ],
            1000 => [ "Auth-Type",                              "integer" ],
            1001 => [ "Menu",                                   "string" ],
            1002 => [ "Termination-Menu",                       "string" ],
            1003 => [ "Prefix",                                 "string" ],
            1004 => [ "Suffix",                                 "string" ],
            1005 => [ "Group",                                  "string" ],
            1006 => [ "Crypt-Password",                         "string" ],
            1008 => [ "Add-Prefix",                             "string" ],
            1009 => [ "Add-Suffix",                             "string" ],
            1010 => [ "Expiration",                             "date" ],
            1011 => [ "Autz-Type",                              "integer" ],
            1012 => [ "Acct-Type",                              "integer" ],
            1013 => [ "Session-Type",                           "integer" ],
            1014 => [ "Post-Auth-Type",                         "integer" ],
            1015 => [ "Pre-Proxy-Type",                         "integer" ],
            1016 => [ "Post-Proxy-Type",                        "integer" ],
            1017 => [ "Pre-Acct-Type",                          "integer" ],
            1018 => [ "EAP-Type",                               "integer" ],
            1019 => [ "EAP-TLS-Require-Client-Cert",            "integer" ],
            1020 => [ "EAP-Id",                                 "integer" ],
            1021 => [ "EAP-Code",                               "integer" ],
            1022 => [ "EAP-MD5-Password",                       "string" ],
            1023 => [ "PEAP-Version",                           "integer" ],
            1024 => [ "Client-Shortname",                       "string" ],
            1025 => [ "Load-Balance-Key",                       "string" ],
            1026 => [ "Raw-Attribute",                          "octets" ],
            1027 => [ "TNC-VLAN-Access",                        "string" ],
            1028 => [ "TNC-VLAN-Isolate",                       "string" ],
            1029 => [ "User-Category",                          "string" ],
            1030 => [ "Group-Name",                             "string" ],
            1031 => [ "Huntgroup-Name",                         "string" ],
            1034 => [ "Simultaneous-Use",                       "integer" ],
            1035 => [ "Strip-User-Name",                        "integer" ],
            1040 => [ "Hint",                                   "string" ],
            1041 => [ "Pam-Auth",                               "string" ],
            1042 => [ "Login-Time",                             "string" ],
            1043 => [ "Stripped-User-Name",                     "string" ],
            1044 => [ "Current-Time",                           "string" ],
            1045 => [ "Realm",                                  "string" ],
            1046 => [ "No-Such-Attribute",                      "string" ],
            1047 => [ "Packet-Type",                            "integer" ],
            1048 => [ "Proxy-To-Realm",                         "string" ],
            1049 => [ "Replicate-To-Realm",                     "string" ],
            1050 => [ "Acct-Session-Start-Time",                "date" ],
            1051 => [ "Acct-Unique-Session-Id",                 "string" ],
            1052 => [ "Client-IP-Address",                      "ipaddr" ],
            1053 => [ "LDAP-UserDN",                            "string" ],
            1054 => [ "NS-MTA-MD5-Password",                    "string" ],
            1055 => [ "SQL-User-Name",                          "string" ],
            1057 => [ "LM-Password",                            "octets" ],
            1058 => [ "NT-Password",                            "octets" ],
            1059 => [ "SMB-Account-CTRL",                       "integer" ],
            1061 => [ "SMB-Account-CTRL-TEXT",                  "string" ],
            1062 => [ "User-Profile",                           "string" ],
            1063 => [ "Digest-Realm",                           "string" ],
            1064 => [ "Digest-Nonce",                           "string" ],
            1065 => [ "Digest-Method",                          "string" ],
            1066 => [ "Digest-URI",                             "string" ],
            1067 => [ "Digest-QOP",                             "string" ],
            1068 => [ "Digest-Algorithm",                       "string" ],
            1069 => [ "Digest-Body-Digest",                     "string" ],
            1070 => [ "Digest-CNonce",                          "string" ],
            1071 => [ "Digest-Nonce-Count",                     "string" ],
            1072 => [ "Digest-User-Name",                       "string" ],
            1073 => [ "Pool-Name",                              "string" ],
            1075 => [ "Module-Success-Message",                 "string" ],
            1076 => [ "Module-Failure-Message",                 "string" ],
            1078 => [ "Rewrite-Rule",                           "string" ],
            1080 => [ "Response-Packet-Type",                   "integer" ],
            1081 => [ "Digest-HA1",                             "string" ],
            1082 => [ "MS-CHAP-Use-NTLM-Auth",                  "integer" ],
            1083 => [ "MS-CHAP-User-Name",                      "string" ],
            1084 => [ "Packet-Src-IP-Address",                  "ipaddr" ],
            1085 => [ "Packet-Dst-IP-Address",                  "ipaddr" ],
            1086 => [ "Packet-Src-Port",                        "integer" ],
            1087 => [ "Packet-Dst-Port",                        "integer" ],
            1088 => [ "Packet-Authentication-Vector",           "octets" ],
            1089 => [ "Time-Of-Day",                            "string" ],
            1090 => [ "Request-Processing-Stage",               "string" ],
            1092 => [ "SHA2-Password",                          "octets" ],
            1093 => [ "SHA1-Password",                          "octets" ],
            1094 => [ "SSHA1-Password",                         "octets" ],
            1095 => [ "MD5-Password",                           "octets" ],
            1096 => [ "SMD5-Password",                          "octets" ],
            1097 => [ "Packet-Src-IPv6-Address",                "ipv6addr" ],
            1098 => [ "Packet-Dst-IPv6-Address",                "ipv6addr" ],
            1099 => [ "Virtual-Server",                         "string" ],
            1100 => [ "Cleartext-Password",                     "string" ],
            1101 => [ "Password-With-Header",                   "string" ],
            1102 => [ "Inner-Tunnel-User-Name",                 "string" ],
            1103 => [ "EAP-IKEv2-IDType",                       "integer" ],
            1104 => [ "EAP-IKEv2-ID",                           "string" ],
            1105 => [ "EAP-IKEv2-Secret",                       "string" ],
            1106 => [ "EAP-IKEv2-AuthType",                     "integer" ],
            1107 => [ "Send-CoA-Request",                       "integer" ],
            1108 => [ "Module-Return-Code",                     "integer" ],
            1109 => [ "Packet-Original-Timestamp",              "date" ],
            1110 => [ "SQL-Table-Name",                         "string" ],
            1111 => [ "Home-Server-Pool",                       "string" ],
            1112 => [ "Attribute-Map",                          "string" ],
            1113 => [ "CoA-Packet-Type",                        "string" ],
            1114 => [ "CoA-Packet-DST-IP-Address",              "ipaddr" ],
            1115 => [ "CoA-Packet-DST-Port",                    "integer" ],
            1116 => [ "CoA-Acct-Session-Id",                    "string" ],
            1117 => [ "CoA-Packet-DST-IPv6-Address",            "ipv6addr" ],
            1120 => [ "FreeRADIUS-Client-IP-Address",           "ipaddr" ],
            1121 => [ "FreeRADIUS-Client-IPv6-Address",         "ipv6addr" ],
            1122 => [ "FreeRADIUS-Client-Require-MA",           "integer" ],
            1123 => [ "FreeRADIUS-Client-Secret",               "string" ],
            1124 => [ "FreeRADIUS-Client-Shortname",            "string" ],
            1125 => [ "FreeRADIUS-Client-NAS-Type",             "string" ],
            1126 => [ "FreeRADIUS-Client-Virtual-Server",       "string" ],
            1127 => [ "Allow-Session-Resumption",               "integer" ],
            1128 => [ "EAP-Session-Resumed",                    "integer" ],
            1129 => [ "EAP-MSK",                                "octets" ],
            1130 => [ "EAP-EMSK",                               "octets" ],
            1131 => [ "Recv-CoA-Type",                          "integer" ],
            1132 => [ "Send-CoA-Type",                          "integer" ],
            1133 => [ "MS-CHAP-Password",                       "string" ],
            1134 => [ "Packet-Transmit-Counter",                "integer" ],
            1135 => [ "Cached-Session-Policy",                  "string" ],
            1136 => [ "MS-CHAP-New-Cleartext-Password",         "string" ],
            1137 => [ "MS-CHAP-New-NT-Password",                "octets" ],
            1138 => [ "Stripped-User-Domain",                   "string" ],
            1139 => [ "Called-Station-SSID",                    "string" ],
            1145 => [ "OTP-Challenge",                          "string" ],
            1146 => [ "EAP-Session-Id",                         "octets" ],
            1147 => [ "Chbind-Response-Code",                   "integer" ],
            1148 => [ "Acct-Input-Octets64",                    "integer64" ],
            1149 => [ "Acct-Output-Octets64",                   "integer64" ],
            1150 => [ "FreeRADIUS-Client-IP-Prefix",            "ipv4prefix" ],
            1151 => [ "FreeRADIUS-Client-IPv6-Prefix",          "ipv6prefix" ],
            1152 => [ "FreeRADIUS-Response-Delay",              "integer" ],
            1153 => [ "FreeRADIUS-Client-Src-IP-Address",       "ipaddr" ],
            1154 => [ "FreeRADIUS-Client-Src-IPv6-Address",     "ipv6addr" ],
            1155 => [ "FreeRADIUS-Response-Delay-USec",         "integer" ],
            1160 => [ "REST-HTTP-Header",                       "string" ],
            1161 => [ "REST-HTTP-Body",                         "string" ],
            1162 => [ "REST-HTTP-Status-Code",                  "integer" ],
            1170 => [ "Cache-Expires",                          "date" ],
            1171 => [ "Cache-Created",                          "date" ],
            1172 => [ "Cache-TTL",                              "signed" ],
            1173 => [ "Cache-Status-Only",                      "integer" ],
            1174 => [ "Cache-Merge",                            "integer" ],
            1175 => [ "Cache-Entry-Hits",                       "integer" ],
            1176 => [ "Cache-Read-Only",                        "integer" ],
            1177 => [ "SSHA2-224-Password",                     "octets" ],
            1178 => [ "SSHA2-256-Password",                     "octets" ],
            1179 => [ "SSHA2-384-Password",                     "octets" ],
            1180 => [ "SSHA2-512-Password",                     "octets" ],
            1181 => [ "PBKDF2-Password",                        "octets" ],
            1182 => [ "SSHA3-224-Password",                     "octets" ],
            1183 => [ "SSHA3-256-Password",                     "octets" ],
            1184 => [ "SSHA3-384-Password",                     "octets" ],
            1185 => [ "SSHA3-512-Password",                     "octets" ],
            1192 => [ "MS-CHAP-Peer-Challenge",                 "octets" ],
            1193 => [ "Home-Server-Name",                       "string" ],
            1194 => [ "TOTP-Secret",                            "string" ],
            1195 => [ "TOTP-Key",                               "octets" ],
            1196 => [ "TOTP-Password",                          "string" ],
            1197 => [ "Proxy-Tunneled-Request-As-EAP",          "integer" ],
            1198 => [ "Temp-Home-Server-String",                "string" ],
            1200 => [ "EAP-Sim-Subtype",                        "integer" ],
            1201 => [ "EAP-Sim-Rand1",                          "octets" ],
            1202 => [ "EAP-Sim-Rand2",                          "octets" ],
            1203 => [ "EAP-Sim-Rand3",                          "octets" ],
            1204 => [ "EAP-Sim-SRES1",                          "octets" ],
            1205 => [ "EAP-Sim-SRES2",                          "octets" ],
            1206 => [ "EAP-Sim-SRES3",                          "octets" ],
            1207 => [ "EAP-Sim-State",                          "integer" ],
            1208 => [ "EAP-Sim-IMSI",                           "string" ],
            1209 => [ "EAP-Sim-HMAC",                           "string" ],
            1210 => [ "EAP-Sim-KEY",                            "octets" ],
            1211 => [ "EAP-Sim-EXTRA",                          "octets" ],
            1212 => [ "EAP-Sim-KC1",                            "octets" ],
            1213 => [ "EAP-Sim-KC2",                            "octets" ],
            1214 => [ "EAP-Sim-KC3",                            "octets" ],
            1215 => [ "EAP-Sim-Ki",                             "octets" ],
            1216 => [ "EAP-Sim-Algo-Version",                   "integer" ],
            1218 => [ "Outer-Realm-Name",                       "string" ],
            1219 => [ "Inner-Realm-Name",                       "string" ],
            1220 => [ "EAP-Pwd-Password-Hash",                  "octets" ],
            1221 => [ "EAP-Pwd-Password-Salt",                  "octets" ],
            1222 => [ "EAP-Pwd-Password-Prep",                  "byte" ],
            1280 => [ "EAP-Type-None",                          "octets" ],
            1281 => [ "EAP-Type-Identity",                      "octets" ],
            1282 => [ "EAP-Type-Notification",                  "octets" ],
            1283 => [ "EAP-Type-NAK",                           "octets" ],
            1284 => [ "EAP-Type-MD5-Challenge",                 "octets" ],
            1285 => [ "EAP-Type-One-Time-Password",             "octets" ],
            1286 => [ "EAP-Type-Generic-Token-Card",            "octets" ],
            1289 => [ "EAP-Type-RSA-Public-Key",                "octets" ],
            1290 => [ "EAP-Type-DSS-Unilateral",                "octets" ],
            1291 => [ "EAP-Type-KEA",                           "octets" ],
            1292 => [ "EAP-Type-KEA-Validate",                  "octets" ],
            1293 => [ "EAP-Type-EAP-TLS",                       "octets" ],
            1294 => [ "EAP-Type-Defender-Token",                "octets" ],
            1295 => [ "EAP-Type-RSA-SecurID-EAP",               "octets" ],
            1296 => [ "EAP-Type-Arcot-Systems-EAP",             "octets" ],
            1297 => [ "EAP-Type-Cisco-LEAP",                    "octets" ],
            1298 => [ "EAP-Type-SIM",                           "octets" ],
            1299 => [ "EAP-Type-SRP-SHA1",                      "octets" ],
            1301 => [ "EAP-Type-EAP-TTLS",                      "octets" ],
            1302 => [ "EAP-Type-Remote-Access-Service",         "octets" ],
            1303 => [ "EAP-Type-AKA",                           "octets" ],
            1304 => [ "EAP-Type-EAP-3Com-Wireless",             "octets" ],
            1305 => [ "EAP-Type-PEAP",                          "octets" ],
            1306 => [ "EAP-Type-MS-CHAP-V2",                    "octets" ],
            1307 => [ "EAP-Type-MAKE",                          "octets" ],
            1308 => [ "EAP-Type-CRYPTOCard",                    "octets" ],
            1309 => [ "EAP-Type-Cisco-MS-CHAPv2",               "octets" ],
            1310 => [ "EAP-Type-DynamID",                       "octets" ],
            1311 => [ "EAP-Type-Rob-EAP",                       "octets" ],
            1312 => [ "EAP-Type-SecurID-EAP",                   "octets" ],
            1313 => [ "EAP-Type-MS-Authentication-TLV",         "octets" ],
            1314 => [ "EAP-Type-SentriNET",                     "octets" ],
            1315 => [ "EAP-Type-EAP-Actiontec-Wireless",        "octets" ],
            1316 => [ "EAP-Type-Cogent-Biomentric-EAP",         "octets" ],
            1317 => [ "EAP-Type-AirFortress-EAP",               "octets" ],
            1318 => [ "EAP-Type-EAP-HTTP-Digest",               "octets" ],
            1319 => [ "EAP-Type-SecuriSuite-EAP",               "octets" ],
            1320 => [ "EAP-Type-DeviceConnect-EAP",             "octets" ],
            1321 => [ "EAP-Type-EAP-SPEKE",                     "octets" ],
            1322 => [ "EAP-Type-EAP-MOBAC",                     "octets" ],
            1323 => [ "EAP-Type-EAP-FAST",                      "octets" ],
            1324 => [ "EAP-Type-Zonelabs",                      "octets" ],
            1325 => [ "EAP-Type-EAP-Link",                      "octets" ],
            1326 => [ "EAP-Type-EAP-PAX",                       "octets" ],
            1327 => [ "EAP-Type-EAP-PSK",                       "octets" ],
            1328 => [ "EAP-Type-EAP-SAKE",                      "octets" ],
            1329 => [ "EAP-Type-EAP-IKEv2",                     "octets" ],
            1330 => [ "EAP-Type-EAP-AKA2",                      "octets" ],
            1331 => [ "EAP-Type-EAP-GPSK",                      "octets" ],
            1332 => [ "EAP-Type-EAP-PWD",                       "octets" ],
            1333 => [ "EAP-Type-EAP-EVEv1",                     "octets" ],
            1536 => [ "EAP_Sim-Base",                           "octets" ],
            1537 => [ "EAP-Sim-RAND",                           "octets" ],
            1542 => [ "EAP-Sim-PADDING",                        "octets" ],
            1543 => [ "EAP-Sim-NONCE_MT",                       "octets" ],
            1546 => [ "EAP-Sim-PERMANENT_ID_REQ",               "octets" ],
            1547 => [ "EAP-Sim-MAC",                            "octets" ],
            1548 => [ "EAP-Sim-NOTIFICATION",                   "octets" ],
            1549 => [ "EAP-Sim-ANY_ID_REQ",                     "octets" ],
            1550 => [ "EAP-Sim-IDENTITY",                       "octets" ],
            1551 => [ "EAP-Sim-VERSION_LIST",                   "octets" ],
            1552 => [ "EAP-Sim-SELECTED_VERSION",               "octets" ],
            1553 => [ "EAP-Sim-FULLAUTH_ID_REQ",                "octets" ],
            1555 => [ "EAP-Sim-COUNTER",                        "octets" ],
            1556 => [ "EAP-Sim-COUNTER_TOO_SMALL",              "octets" ],
            1557 => [ "EAP-Sim-NONCE_S",                        "octets" ],
            1665 => [ "EAP-Sim-IV",                             "octets" ],
            1666 => [ "EAP-Sim-ENCR_DATA",                      "octets" ],
            1668 => [ "EAP-Sim-NEXT_PSEUDONUM",                 "octets" ],
            1669 => [ "EAP-Sim-NEXT_REAUTH_ID",                 "octets" ],
            1670 => [ "EAP-Sim-CHECKCODE",                      "octets" ],
            1800 => [ "Tmp-String-0",                           "string" ],
            1801 => [ "Tmp-String-1",                           "string" ],
            1802 => [ "Tmp-String-2",                           "string" ],
            1803 => [ "Tmp-String-3",                           "string" ],
            1804 => [ "Tmp-String-4",                           "string" ],
            1805 => [ "Tmp-String-5",                           "string" ],
            1806 => [ "Tmp-String-6",                           "string" ],
            1807 => [ "Tmp-String-7",                           "string" ],
            1808 => [ "Tmp-String-8",                           "string" ],
            1809 => [ "Tmp-String-9",                           "string" ],
            1810 => [ "Tmp-Integer-0",                          "integer" ],
            1811 => [ "Tmp-Integer-1",                          "integer" ],
            1812 => [ "Tmp-Integer-2",                          "integer" ],
            1813 => [ "Tmp-Integer-3",                          "integer" ],
            1814 => [ "Tmp-Integer-4",                          "integer" ],
            1815 => [ "Tmp-Integer-5",                          "integer" ],
            1816 => [ "Tmp-Integer-6",                          "integer" ],
            1817 => [ "Tmp-Integer-7",                          "integer" ],
            1818 => [ "Tmp-Integer-8",                          "integer" ],
            1819 => [ "Tmp-Integer-9",                          "integer" ],
            1820 => [ "Tmp-IP-Address-0",                       "ipaddr" ],
            1821 => [ "Tmp-IP-Address-1",                       "ipaddr" ],
            1822 => [ "Tmp-IP-Address-2",                       "ipaddr" ],
            1823 => [ "Tmp-IP-Address-3",                       "ipaddr" ],
            1824 => [ "Tmp-IP-Address-4",                       "ipaddr" ],
            1825 => [ "Tmp-IP-Address-5",                       "ipaddr" ],
            1826 => [ "Tmp-IP-Address-6",                       "ipaddr" ],
            1827 => [ "Tmp-IP-Address-7",                       "ipaddr" ],
            1828 => [ "Tmp-IP-Address-8",                       "ipaddr" ],
            1829 => [ "Tmp-IP-Address-9",                       "ipaddr" ],
            1830 => [ "Tmp-Octets-0",                           "octets" ],
            1831 => [ "Tmp-Octets-1",                           "octets" ],
            1832 => [ "Tmp-Octets-2",                           "octets" ],
            1833 => [ "Tmp-Octets-3",                           "octets" ],
            1834 => [ "Tmp-Octets-4",                           "octets" ],
            1835 => [ "Tmp-Octets-5",                           "octets" ],
            1836 => [ "Tmp-Octets-6",                           "octets" ],
            1837 => [ "Tmp-Octets-7",                           "octets" ],
            1838 => [ "Tmp-Octets-8",                           "octets" ],
            1839 => [ "Tmp-Octets-9",                           "octets" ],
            1840 => [ "Tmp-Date-0",                             "date" ],
            1841 => [ "Tmp-Date-1",                             "date" ],
            1842 => [ "Tmp-Date-2",                             "date" ],
            1843 => [ "Tmp-Date-3",                             "date" ],
            1844 => [ "Tmp-Date-4",                             "date" ],
            1845 => [ "Tmp-Date-5",                             "date" ],
            1846 => [ "Tmp-Date-6",                             "date" ],
            1847 => [ "Tmp-Date-7",                             "date" ],
            1848 => [ "Tmp-Date-8",                             "date" ],
            1849 => [ "Tmp-Date-9",                             "date" ],
            1851 => [ "Tmp-Cast-String",                        "string" ],
            1852 => [ "Tmp-Cast-Integer",                       "integer" ],
            1853 => [ "Tmp-Cast-Ipaddr",                        "ipaddr" ],
            1854 => [ "Tmp-Cast-Date",                          "date" ],
            1855 => [ "Tmp-Cast-Abinary",                       "abinary" ],
            1856 => [ "Tmp-Cast-Octets",                        "octets" ],
            1857 => [ "Tmp-Cast-Ifid",                          "ifid" ],
            1858 => [ "Tmp-Cast-IPv6Addr",                      "ipv6addr" ],
            1859 => [ "Tmp-Cast-IPv6Prefix",                    "ipv6prefix" ],
            1860 => [ "Tmp-Cast-Byte",                          "byte" ],
            1861 => [ "Tmp-Cast-Short",                         "short" ],
            1862 => [ "Tmp-Cast-Ethernet",                      "ether" ],
            1863 => [ "Tmp-Cast-Signed",                        "signed" ],
            1869 => [ "Tmp-Cast-Integer64",                     "integer64" ],
            1870 => [ "Tmp-Cast-IPv4Prefix",                    "ipv4prefix" ],
            1871 => [ "Tmp-Integer64-0",                        "integer64" ],
            1872 => [ "Tmp-Integer64-1",                        "integer64" ],
            1873 => [ "Tmp-Integer64-2",                        "integer64" ],
            1874 => [ "Tmp-Integer64-3",                        "integer64" ],
            1875 => [ "Tmp-Integer64-4",                        "integer64" ],
            1876 => [ "Tmp-Integer64-5",                        "integer64" ],
            1877 => [ "Tmp-Integer64-6",                        "integer64" ],
            1878 => [ "Tmp-Integer64-7",                        "integer64" ],
            1879 => [ "Tmp-Integer64-8",                        "integer64" ],
            1880 => [ "Tmp-Integer64-9",                        "integer64" ],
            1900 => [ "WiMAX-MN-NAI",                           "string" ],
            1901 => [ "WiMAX-SIM-Ki",                           "octets" ],
            1902 => [ "WiMAX-SIM-OPc",                          "octets" ],
            1903 => [ "WiMAX-SIM-AMF",                          "octets" ],
            1904 => [ "WiMAX-SIM-SQN",                          "octets" ],
            1905 => [ "WiMAX-SIM-RAND",                         "octets" ],
            1910 => [ "TLS-Cert-Serial",                        "string" ],
            1911 => [ "TLS-Cert-Expiration",                    "string" ],
            1912 => [ "TLS-Cert-Issuer",                        "string" ],
            1913 => [ "TLS-Cert-Subject",                       "string" ],
            1914 => [ "TLS-Cert-Common-Name",                   "string" ],
            1915 => [ "TLS-Cert-Subject-Alt-Name-Email",        "string" ],
            1916 => [ "TLS-Cert-Subject-Alt-Name-Dns",          "string" ],
            1917 => [ "TLS-Cert-Subject-Alt-Name-Upn",          "string" ],
            1918 => [ "TLS-Cert-Valid-Since",                   "string" ],
            1919 => [ "TLS-Session-Information",                "string" ],
            1920 => [ "TLS-Client-Cert-Serial",                 "string" ],
            1921 => [ "TLS-Client-Cert-Expiration",             "string" ],
            1922 => [ "TLS-Client-Cert-Issuer",                 "string" ],
            1923 => [ "TLS-Client-Cert-Subject",                "string" ],
            1924 => [ "TLS-Client-Cert-Common-Name",            "string" ],
            1925 => [ "TLS-Client-Cert-Filename",               "string" ],
            1926 => [ "TLS-Client-Cert-Subject-Alt-Name-Email", "string" ],
            1927 => [ "TLS-Client-Cert-X509v3-Extended-Key-Usage", "string" ],
            1928 =>
              [ "TLS-Client-Cert-X509v3-Subject-Key-Identifier", "string" ],
            1929 =>
              [ "TLS-Client-Cert-X509v3-Authority-Key-Identifier", "string" ],
            1930 => [ "TLS-Client-Cert-X509v3-Basic-Constraints", "string" ],
            1931 => [ "TLS-Client-Cert-Subject-Alt-Name-Dns",     "string" ],
            1932 => [ "TLS-Client-Cert-Subject-Alt-Name-Upn",     "string" ],
            1933 => [ "TLS-PSK-Identity",                         "string" ],
            1936 =>
              [ "TLS-Client-Cert-X509v3-Extended-Key-Usage-OID", "string" ],
            1937 => [ "TLS-Client-Cert-Valid-Since", "string" ],
            1938 => [ "TLS-Cache-Method",            "integer" ],
            1939 => [ "TLS-Client-Cert-X509v3-Certificate-Policies", "string" ],
            1940 => [ "TLS-Session-ID",                              "octets" ],
            1942 => [ "TLS-Session-Data",                            "octets" ],
            1943 => [ "TLS-OCSP-Cert-Valid",               "integer" ],
            1946 => [ "TLS-Cache-Filename",                "string" ],
            1947 => [ "TLS-Session-Version",               "string" ],
            1948 => [ "TLS-Session-Cipher-Suite",          "string" ],
            1949 => [ "TLS-Session-Cert-File",             "string" ],
            1950 => [ "TLS-Session-Cert-Private-Key-File", "string" ],
            1951 => [ "TLS-Server-Name-Indication",        "string" ],
            2100 => [ "SoH-MS-Machine-OS-vendor",          "integer" ],
            2101 => [ "SoH-MS-Machine-OS-version",         "integer" ],
            2102 => [ "SoH-MS-Machine-OS-release",         "integer" ],
            2103 => [ "SoH-MS-Machine-OS-build",           "integer" ],
            2104 => [ "SoH-MS-Machine-SP-version",         "integer" ],
            2105 => [ "SoH-MS-Machine-SP-release",         "integer" ],
            2106 => [ "SoH-MS-Machine-Processor",          "integer" ],
            2107 => [ "SoH-MS-Machine-Name",               "string" ],
            2108 => [ "SoH-MS-Correlation-Id",             "octets" ],
            2109 => [ "SoH-MS-Machine-Role",               "integer" ],
            2119 => [ "SoH-Supported",                     "integer" ],
            2120 => [ "SoH-MS-Windows-Health-Status",      "string" ],
            2129 => [ "SoH-MS-Health-Other",               "string" ],
            2200 => [ "Radclient-Test-Name",               "string" ],
            3000 => [ "OAuth2-Password-Last-Modified",     "date" ],
            3001 => [ "OAuth2-Group",                      "string" ],
            3003 => [ "AD-Samaccountname",                 "string" ],
        },
        rval => {
            6 => {
                1         => "Login-User",
                2         => "Framed-User",
                3         => "Callback-Login-User",
                4         => "Callback-Framed-User",
                5         => "Outbound-User",
                6         => "Administrative-User",
                7         => "NAS-Prompt-User",
                8         => "Authenticate-Only",
                9         => "Callback-NAS-Prompt",
                10        => "Call-Check",
                11        => "Callback-Administrative",
                12        => "Sip-session",
                13        => "Fax",
                14        => "Modem-Relay",
                15        => "IAPP-Register",
                16        => "IAPP-AP-Check",
                17        => "Authorize-Only",
                18        => "Framed-Management",
                103809025 => "Annex-Authorize-Only",
                103809026 => "Annex-Framed-Tunnel",
            },
            7 => {
                1        => "PPP",
                2        => "SLIP",
                3        => "ARAP",
                4        => "Gandalf-SLML",
                5        => "Xylogics-IPX-SLIP",
                6        => "X.75-Synchronous",
                7        => "GPRS-PDP-Context",
                9        => "PPTP",
                17825794 => "Bintec-X25",
                17825795 => "Bintec-X25-PPP",
                17825796 => "Bintec-IP-LAPB",
                17825798 => "Bintec-IP-HDLC",
                17825799 => "Bintec-MPR-LAPB",
                17825800 => "Bintec-MPR-HDLC",
                17825801 => "Bintec-FRAME-RELAY",
                17825802 => "Bintec-X31-BCHAN",
                17825803 => "Bintec-X75-PPP",
                17825804 => "Bintec-X75BTX-PPP",
                17825805 => "Bintec-X25-NOSIG",
                17825806 => "Bintec-X25-PPP-OPT",
            },
            10 => {
                "0" => "None",
                "1" => "Broadcast",
                "2" => "Listen",
                "3" => "Broadcast-Listen",
            },
            13 => {
                "0" => "None",
                "1" => "Van-Jacobson-TCP-IP",
                "2" => "IPX-Header-Compression",
                "3" => "Stac-LZS",
            },
            15 => {
                "0" => "Telnet",
                "1" => "Rlogin",
                "2" => "TCP-Clear",
                "3" => "PortMaster",
                "4" => "LAT",
                "5" => "X25-PAD",
                "6" => "X25-T3POS",
                "8" => "TCP-Clear-Quiet",
            },
            16 => { 23 => "Telnet", 513 => "Rlogin", 514 => "Rsh" },
            29 => {
                "0" => "Default",
                "1" => "RADIUS-Request",
                "2" => "Manage-Resources"
            },
            40 => {
                1         => "Start",
                2         => "Stop",
                3         => "Interim-Update",
                4         => "Modem-Start",
                5         => "Modem-Stop",
                6         => "Cancel",
                7         => "Accounting-On",
                8         => "Accounting-Off",
                9         => "Tunnel-Start",
                10        => "Tunnel-Stop",
                11        => "Tunnel-Reject",
                12        => "Tunnel-Link-Start",
                13        => "Tunnel-Link-Stop",
                14        => "Tunnel-Link-Reject",
                15        => "Failed",
                18        => "Subsystem-On",
                19        => "Subsystem-Off",
                217       => "WB-Login",
                218       => "WB-Logout",
                219       => "WB-WRitelog",
                103809025 => "Annex-User-Reject",
                103809026 => "Annex-Call-Reject",
                103809027 => "Annex-IPCP-Start",
                103809028 => "Annex-IPXCP-Start",
                103809029 => "Annex-ATCP-Start",
                103809030 => "Annex-Accounting-Restart",
                103809031 => "Annex-Accounting-Shutoff",
                103809032 => "Annex-Tunnel-Start",
                103809033 => "Annex-Tunnel-Stop",
                103809034 => "Annex-Tunnel-Reject",
                103809035 => "Annex-Tunnel-Link-Start",
                103809036 => "Annex-Tunnel-Link-Stop",
                103809037 => "Annex-MP-Start",
                103809038 => "Annex-MP-Stop",
                103809039 => "Annex-Line-Seizure",
                103809040 => "Annex-Rlogin-Start",
                103809041 => "Annex-Rlogin-Stop",
            },
            45 =>
              { 1 => "RADIUS", 2 => "Local", 3 => "Remote", 4 => "Diameter" },
            49 => {
                1  => "User-Request",
                2  => "Lost-Carrier",
                3  => "Lost-Service",
                4  => "Idle-Timeout",
                5  => "Session-Timeout",
                6  => "Admin-Reset",
                7  => "Admin-Reboot",
                8  => "Port-Error",
                9  => "NAS-Error",
                10 => "NAS-Request",
                11 => "NAS-Reboot",
                12 => "Port-Unneeded",
                13 => "Port-Preempted",
                14 => "Port-Suspended",
                15 => "Service-Unavailable",
                16 => "Callback",
                17 => "User-Error",
                18 => "Host-Request",
                19 => "Supplicant-Restart",
                20 => "Reauthentication-Failure",
                21 => "Port-Reinit",
                22 => "Port-Disabled",
            },
            57 => { 1 => "Enabled", 2 => "Disabled" },
            61 => {
                "0"  => "Async",
                "1"  => "Sync",
                "2"  => "ISDN",
                "3"  => "ISDN-V120",
                "4"  => "ISDN-V110",
                "5"  => "Virtual",
                "6"  => "PIAFS",
                "7"  => "HDLC-Clear-Channel",
                "8"  => "X.25",
                "9"  => "X.75",
                "10" => "G.3-Fax",
                "11" => "SDSL",
                "12" => "ADSL-CAP",
                "13" => "ADSL-DMT",
                "14" => "IDSL",
                "15" => "Ethernet",
                "16" => "xDSL",
                "17" => "Cable",
                "18" => "Wireless-Other",
                "19" => "Wireless-802.11",
                "20" => "Token-Ring",
                "21" => "FDDI",
                "22" => "Wireless-CDMA2000",
                "23" => "Wireless-UMTS",
                "24" => "Wireless-1X-EV",
                "25" => "IAPP",
                "26" => "FTTP",
                "27" => "Wireless-802.16",
                "28" => "Wireless-802.20",
                "29" => "Wireless-802.22",
                "30" => "PPPoA",
                "31" => "PPPoEoA",
                "32" => "PPPoEoE",
                "33" => "PPPoEoVLAN",
                "34" => "PPPoEoQinQ",
                "35" => "xPON",
                "36" => "Wireless-XGP",
            },
            64 => {
                1  => "PPTP",
                2  => "L2F",
                3  => "L2TP",
                4  => "ATMP",
                5  => "VTP",
                6  => "AH",
                7  => "IP",
                8  => "MIN-IP",
                9  => "ESP",
                10 => "GRE",
                11 => "DVS",
                12 => "IP-in-IP",
                13 => "VLAN",
            },
            65 => {
                1  => "IPv4",
                2  => "IPv6",
                3  => "NSAP",
                4  => "HDLC",
                5  => "BBN-1822",
                6  => "IEEE-802",
                7  => "E.163",
                8  => "E.164",
                9  => "F.69",
                10 => "X.121",
                11 => "IPX",
                12 => "Appletalk",
                13 => "DecNet-IV",
                14 => "Banyan-Vines",
                15 => "E.164-NSAP",
            },
            72 => {
                1 => "Default-Zone",
                2 => "Zone-Filter-Inclusive",
                4 => "Zone-Filter-Exclusive",
            },
            76  => { "0" => "No-Echo", "1" => "Echo" },
            101 => {
                201 => "Residual-Context-Removed",
                202 => "Invalid-EAP-Packet",
                401 => "Unsupported-Attribute",
                402 => "Missing-Attribute",
                403 => "NAS-Identification-Mismatch",
                404 => "Invalid-Request",
                405 => "Unsupported-Service",
                406 => "Unsupported-Extension",
                407 => "Invalid-Attribute-Value",
                501 => "Administratively-Prohibited",
                502 => "Proxy-Request-Not-Routable",
                503 => "Session-Context-Not-Found",
                504 => "Session-Context-Not-Removable",
                505 => "Proxy-Processing-Error",
                506 => "Resources-Unavailable",
                507 => "Request-Initiated",
                508 => "Multiple-Session-Selection-Unsupported",
            },
            126 => { "0" => "Temp-Rtes-No",      "1" => "Temp-Rtes-Yes" },
            127 => { "0" => "ATMP-Tunnel",       "1" => "VTP-Tunnel" },
            128 => { "0" => "Shared-Profile-No", "1" => "Shared-Profile-Yes" },
            131 => {
                "0" => "Dialout-Not-Allowed",
                "1" => "Civic-Location",
                "2" => "Geo-Location",
                "4" => "Users-Location",
                "8" => "NAS-Location",
            },
            132 => {
                1  => "Civic-Location",
                2  => "Geo-Location",
                4  => "Users-Location",
                8  => "NAS-Location",
                16 => "Future-Requests",
                32 => "None",
            },
            133 => {
                "0" => "BACP-No",
                "1" => "SNMP",
                "2" => "Web-Based",
                "3" => "Netconf",
                "4" => "FTP",
                "5" => "TFTP",
                "6" => "SFTP",
                "7" => "RCP",
                "8" => "SCP",
            },
            134 => {
                1 => "No-Protection",
                2 => "Integrity-Protection",
                3 => "Integrity-Confidentiality-Protection",
            },
            137 => { "0" => "DNS-Assign-No", "1" => "DNS-Assign-Yes" },
            138 => {
                "0" => "Ascend-User-Acct-None",
                "1" => "Ascend-User-Acct-User",
                "2" => "Ascend-User-Acct-User-Default",
            },
            142 => { "0" => "Base-10",       "1" => "Base-16" },
            147 => { "0" => "DHCP-Reply-No", "1" => "DHCP-Reply-Yes" },
            149 =>
              { "0" => "Expect-Callback-No", "1" => "Expect-Callback-Yes" },
            150 => { 1   => "Ascend-ColdStart", 2   => "Ascend-Session-Event" },
            155 => { "0" => "Multicast-No",     "1" => "Multicast-Yes" },
            157 => {
                "0" => "Ascend-LinkUp-Default",
                "1" => "Ascend-LinkUp-AlwaysUp"
            },
            159 => {
                "0" => "Ascend-FR-DTE",
                "1" => "Ascend-FR-DCE",
                "2" => "Ascend-FR-NNI"
            },
            160 => {
                "0" => "Ascend-FR-No-Link-Mgt",
                "1" => "Ascend-FR-T1-617D",
                "2" => "Ascend-FR-Q-933A",
            },
            163 => {
                1 => "Wired-IEEE-802.1X",
                2 => "IEEE-802.1X-No-Preauth",
                3 => "IEEE-802.1X-Preauth",
                4 => "IEEE-802.16e",
                5 => "IKEv2",
                6 => "PPP",
                7 => "PANA-No-Preauth",
                8 => "GSS-API",
                9 => "PANA-Preauth",
            },
            170 => {
                "0" => "TS-Idle-None",
                "1" => "TS-Idle-Input",
                "2" => "TS-Idle-Input-Output",
            },
            171 => {
                "0" => "DBA-Transmit",
                "1" => "DBA-Transmit-Recv",
                "2" => "DBA-None"
            },
            175 => { "0" => "FT1-No", "1" => "FT1-Yes" },
            177 => {
                "0" => "Switched",
                "1" => "Nailed",
                "2" => "Nailed/Mpp",
                "3" => "Perm/Switched",
                "6" => "AO/DI",
                "7" => "MegaMax",
            },
            195 => {
                "0"   => "No-Reason",
                "1"   => "Not-Applicable",
                "2"   => "Unknown",
                "3"   => "Call-Disconnected",
                "4"   => "CLID-Authentication-Failed",
                "5"   => "CLID-RADIUS-Timeout",
                "10"  => "Modem-No-DCD",
                "11"  => "DCD-Detected-Then-Inactive",
                "12"  => "Modem-Invalid-Result-Codes",
                "20"  => "TermSrv-User-Quit",
                "21"  => "TermSrv-Idle-Timeout",
                "22"  => "TermSrv-Exit-Telnet",
                "23"  => "TermSrv-No-IPaddr",
                "24"  => "TermSrv-Exit-Raw-TCP",
                "25"  => "TermSrv-Exit-Login-Failed",
                "26"  => "TermSrv-Exit-Raw-TCP-Disabled",
                "27"  => "TermSrv-CTRL-C-In-Login",
                "28"  => "TermSrv-Destroyed",
                "29"  => "TermSrv-User-Closed-VCon",
                "30"  => "TermSrv-VCon-Destroyed",
                "31"  => "TermSrv-Exit-Rlogin",
                "32"  => "TermSrv-Bad-Rlogin-Option",
                "33"  => "TermSrv-Not-Enough-Resources",
                "35"  => "MPP-No-NULL-Msg-Timeout",
                "40"  => "PPP-LCP-Timeout",
                "41"  => "PPP-LCP-Negotion-Failed",
                "42"  => "PPP-PAP-Auth-Failed",
                "43"  => "PPP-CHAP-Auth-Failed",
                "44"  => "PPP-Rmt-Auth-Failed",
                "45"  => "PPP-Rcv-Terminate-Req",
                "46"  => "PPP-Rcv-Close-Event",
                "47"  => "PPP-No-NCPs-Open",
                "48"  => "PPP-MP-Bundle-Unknown",
                "49"  => "PPP-LCP-Close-MP-Add-Fail",
                "50"  => "Session-Table-Full",
                "51"  => "Out-Of-Resources",
                "52"  => "Invalid-IP-Address",
                "53"  => "Hostname-Resolution-Failed",
                "54"  => "Bad-Or-Missing-Port-Number",
                "60"  => "Host-Reset",
                "61"  => "Connection-Refused",
                "62"  => "Connection-Timeout",
                "63"  => "Connection-Closed",
                "64"  => "Network-Unreachable",
                "65"  => "Host-Unreachable",
                "66"  => "Network-Unreachable-Admin",
                "67"  => "Host-Unreachable-Admin",
                "68"  => "Port-Unreachable",
                "100" => "Session-Timeout",
                "101" => "Invalid-Incoming-User",
                "102" => "Disconnect-Due-To-Callback",
                "120" => "Proto-Disabled-Or-Unsupported",
                "150" => "Disconnect-Req-By-RADIUS",
                "151" => "Disconnect-Req-By-Local-Admin",
                "160" => "V110-Timeout-Sync-Retry-Exceed",
                "170" => "PPP-Auth-Timeout-Exceeded",
                "180" => "User-Executed-Do-Hangup",
                "185" => "Remote-End-Hung-Up",
                "190" => "Resource-Has-Been-Quiesced",
                "195" => "Max-Call-Duration-Reached",
            },
            196 => {
                "0"  => "No-Progress",
                "10" => "Call-Up",
                "30" => "Modem-Up",
                "31" => "Modem-Awaiting-DCD",
                "32" => "Modem-Awaiting-Codes",
                "40" => "TermSrv-Started",
                "41" => "TermSrv-Raw-TCP-Started",
                "42" => "TermSrv-Telnet-Started",
                "43" => "TermSrv-Raw-TCP-Connected",
                "44" => "TermSrv-Telnet-Connected",
                "45" => "TermSrv-Rlogin-Started",
                "46" => "TermSrv-Rlogin-Connected",
                "50" => "Modem-Outdial-Call-Up",
                "60" => "LAN-Session-Up",
                "61" => "LCP-Opening",
                "62" => "CCP-Opening",
                "63" => "IPNCP-Opening",
                "64" => "BNCP-Opening",
                "65" => "LCP-Opened",
                "66" => "CCP-Opened",
                "67" => "IPNCP-Opened",
                "68" => "BNCP-Opened",
                "69" => "LCP-State-Initial",
                "70" => "LCP-State-Starting",
                "71" => "LCP-State-Closed",
                "72" => "LCP-State-Stopped",
                "73" => "LCP-State-Closing",
                "74" => "LCP-State-Stopping",
                "75" => "LCP-State-Request-Sent",
                "76" => "LCP-State-Ack-Received",
                "77" => "LCP-State-Ack-Sent",
                "80" => "IPXNCP-Opened",
                "81" => "ATNCP-Opened",
                "82" => "BACP-Opening",
                "83" => "BACP-Opened",
                "90" => "V110-Up",
                "91" => "V110-State-Opened",
                "92" => "V110-State-Carrier",
                "93" => "V110-State-Reset",
                "94" => "V110-State-Closed",
            },
            200 => { "0" => "Tok-Imm-No",       "1" => "Tok-Imm-Yes" },
            201 => { "0" => "Not-Require-Auth", "1" => "Require-Auth" },
            207 => { "0" => "Days-Of-Warning" },
            208 => { "0" => "Lifetime-In-Days" },
            210 => { 1   => "VJ-Slot-Comp-No" },
            211 => { 1   => "PPP-VJ-1172" },
            216 => { "0" => "IPX-Peer-Router", "1" => "IPX-Peer-Dialin" },
            219 => { "0" => "FR-Direct-No",    "1" => "FR-Direct-Yes" },
            221 => { "0" => "Disabled",        "1" => "Enabled" },
            222 => {
                "0" => "Disabled",
                "1" => "Enabled",
                "2" => "Handle-IPX-Server"
            },
            223 => { "0" => "Disabled", "1" => "Enabled" },
            226 => {
                "0" => "Unknown-Number",
                "1" => "Intl-Number",
                "2" => "National-Number",
                "3" => "Net-Specific-Number",
                "4" => "Local-Number",
                "5" => "Abbrev-Number",
            },
            228 => { "0" => "Route-IP-No",  "1" => "Route-IP-Yes" },
            229 => { "0" => "Route-IPX-No", "1" => "Route-IPX-Yes" },
            230 => { "0" => "Bridge-No",    "1" => "Bridge-Yes" },
            231 => {
                "0" => "Send-Auth-None",
                "1" => "Send-Auth-PAP",
                "2" => "Send-Auth-CHAP",
                "3" => "Send-Auth-MS-CHAP",
            },
            233 => {
                "0" => "Link-Comp-None",
                "1" => "Link-Comp-Stac",
                "2" => "Link-Comp-Stac-Draft-9",
                "3" => "Link-Comp-MS-Stac",
            },
            239 => {
                "0" => "History-Constant",
                "1" => "History-Linear",
                "2" => "History-Quadratic",
            },
            241 => {
                "0" => "Reserved",
                "1" => "Allocation",
                "2" => "Deallocation",
                "3" => "More-Data-Request",
            },
            246 => { "0" => "Callback-No", "1" => "Callback-Yes" },
            247 => {
                "0"  => "Switched-Voice-Bearer",
                "1"  => "Nailed-56KR",
                "2"  => "Nailed-64K",
                "3"  => "Switched-64KR",
                "4"  => "Switched-56K",
                "5"  => "Switched-384KR",
                "6"  => "Switched-384K",
                "7"  => "Switched-1536K",
                "8"  => "Switched-1536KR",
                "9"  => "Switched-128K",
                "10" => "Switched-192K",
                "11" => "Switched-256K",
                "12" => "Switched-320K",
                "13" => "Switched-384K-MR",
                "14" => "Switched-448K",
                "15" => "Switched-512K",
                "16" => "Switched-576K",
                "17" => "Switched-640K",
                "18" => "Switched-704K",
                "19" => "Switched-768K",
                "20" => "Switched-832K",
                "21" => "Switched-896K",
                "22" => "Switched-960K",
                "23" => "Switched-1024K",
                "24" => "Switched-1088K",
                "25" => "Switched-1152K",
                "26" => "Switched-1216K",
                "27" => "Switched-1280K",
                "28" => "Switched-1344K",
                "29" => "Switched-1408K",
                "30" => "Switched-1472K",
                "31" => "Switched-1600K",
                "32" => "Switched-1664K",
                "33" => "Switched-1728K",
                "34" => "Switched-1792K",
                "35" => "Switched-1856K",
                "36" => "Switched-1920K",
                "37" => "Switched-inherited",
                "38" => "Switched-restricted-bearer-x30",
                "39" => "Switched-clear-bearer-v110",
                "40" => "Switched-restricted-64-x30",
                "41" => "Switched-clear-56-v110",
                "42" => "Switched-modem",
                "43" => "Switched-atmodem",
                "45" => "Switched-V110-24-56",
                "46" => "Switched-V110-48-56",
                "47" => "Switched-V110-96-56",
                "48" => "Switched-V110-192-56",
                "49" => "Switched-V110-384-56",
                "50" => "Switched-V110-24-56R",
                "51" => "Switched-V110-48-56R",
                "52" => "Switched-V110-96-56R",
                "53" => "Switched-V110-192-56R",
                "54" => "Switched-V110-384-56R",
                "55" => "Switched-V110-24-64",
                "56" => "Switched-V110-48-64",
                "57" => "Switched-V110-96-64",
                "58" => "Switched-V110-192-64",
                "59" => "Switched-V110-384-64",
                "60" => "Switched-V110-24-64R",
                "61" => "Switched-V110-48-64R",
                "62" => "Switched-V110-96-64R",
                "63" => "Switched-V110-192-64R",
                "64" => "Switched-V110-384-64R",
                "68" => "Switched-Pots",
                "69" => "Switched-ATM",
                "70" => "Switched-FR",
            },
            248  => { "0" => "Force-56-No", "1" => "Force-56-Yes" },
            500  => { "0" => "No",          "1" => "Yes" },
            501  => { "0" => "No",          "1" => "Yes" },
            1000 => { 1   => "Local",       4   => "Reject", 254 => "Accept" },
            1011 => { 1   => "Local" },
            1012 => { 1   => "Local" },
            1013 => { 1   => "Local" },
            1014 => {
                1 => "Local",
                2 => "Reject",
                3 => "Challenge",
                4 => "Client-Lost"
            },
            1016 => {
                1 => "Fail",
                2 => "Fail-Authentication",
                3 => "Fail-Accounting",
                4 => "Fail-CoA",
                5 => "Fail-Disconnect",
            },
            1018 => {
                "0"  => "None",
                "1"  => "Identity",
                "2"  => "Notification",
                "3"  => "NAK",
                "4"  => "MD5",
                "5"  => "OTP",
                "6"  => "GTC",
                "9"  => "RSA-Public-Key",
                "10" => "DSS-Unilateral",
                "11" => "KEA",
                "12" => "KEA-Validate",
                "13" => "TLS",
                "14" => "Defender-Token",
                "15" => "RSA-SecurID-EAP",
                "16" => "Arcot-Systems-EAP",
                "17" => "LEAP",
                "18" => "SIM",
                "19" => "SRP-SHA1",
                "21" => "TTLS",
                "22" => "Remote-Access-Service",
                "23" => "AKA",
                "24" => "3Com-Wireless",
                "25" => "PEAP",
                "26" => "MSCHAPv2",
                "27" => "MAKE",
                "28" => "CRYPTOCard",
                "29" => "Cisco-MS-CHAPv2",
                "30" => "DynamID",
                "31" => "Rob-EAP",
                "32" => "SecurID-EAP",
                "33" => "MS-Authentication-TLV",
                "34" => "SentriNET",
                "35" => "Actiontec-Wireless",
                "36" => "Cogent-Biomentric-EAP",
                "37" => "AirFortress-EAP",
                "38" => "TNC",
                "39" => "SecuriSuite-EAP",
                "40" => "DeviceConnect-EAP",
                "41" => "SPEKE",
                "42" => "MOBAC",
                "43" => "FAST",
                "44" => "Zonelabs",
                "45" => "Link",
                "46" => "PAX",
                "47" => "PSK",
                "48" => "SAKE",
                "49" => "IKEv2",
                "50" => "AKA2",
                "51" => "GPSK",
                "52" => "PWD",
                "53" => "EKEv1",
            },
            1019 => { "0" => "No", "1" => "Yes" },
            1021 => {
                1 => "Request",
                2 => "Response",
                3 => "Success",
                4 => "Failure"
            },
            1035 => { "0" => "No", "1" => "Yes" },
            1047 => {
                1  => "Access-Request",
                2  => "Access-Accept",
                3  => "Access-Reject",
                4  => "Accounting-Request",
                5  => "Accounting-Response",
                6  => "Accounting-Status",
                7  => "Password-Request",
                8  => "Password-Accept",
                9  => "Password-Reject",
                10 => "Accounting-Message",
                11 => "Access-Challenge",
                12 => "Status-Server",
                13 => "Status-Client",
                21 => "Resource-Free-Request",
                22 => "Resource-Free-Response",
                23 => "Resource-Query-Request",
                24 => "Resource-Query-Response",
                25 => "Alternate-Resource-Reclaim-Request",
                26 => "NAS-Reboot-Request",
                27 => "NAS-Reboot-Response",
                29 => "Next-Passcode",
                30 => "New-Pin",
                31 => "Terminate-Session",
                32 => "Password-Expired",
                33 => "Event-Request",
                34 => "Event-Response",
                40 => "Disconnect-Request",
                41 => "Disconnect-ACK",
                42 => "Disconnect-NAK",
                43 => "CoA-Request",
                44 => "CoA-ACK",
                45 => "CoA-NAK",
                50 => "IP-Address-Allocate",
                51 => "IP-Address-Release",
            },
            1080 => {
                1   => "Access-Request",
                2   => "Access-Accept",
                3   => "Access-Reject",
                4   => "Accounting-Request",
                5   => "Accounting-Response",
                6   => "Accounting-Status",
                7   => "Password-Request",
                8   => "Password-Accept",
                9   => "Password-Reject",
                10  => "Accounting-Message",
                11  => "Access-Challenge",
                12  => "Status-Server",
                13  => "Status-Client",
                40  => "Disconnect-Request",
                41  => "Disconnect-ACK",
                42  => "Disconnect-NAK",
                43  => "CoA-Request",
                44  => "CoA-ACK",
                45  => "CoA-NAK",
                256 => "Do-Not-Respond",
            },
            1082 => { "0" => "No", "1" => "Yes" },
            1103 => {
                1  => "IPV4_ADDR",
                2  => "FQDN",
                3  => "RFC822_ADDR",
                5  => "IPV6_ADDR",
                9  => "DER_ASN1_DN",
                10 => "DER_ASN1_GN",
                11 => "KEY_ID",
            },
            1106 =>
              { "0" => "none", "1" => "secret", "2" => "cert", "3" => "both" },
            1107 => { "0" => "No", "1" => "Yes" },
            1108 => {
                "0" => "reject",
                "1" => "fail",
                "2" => "ok",
                "3" => "handled",
                "4" => "invalid",
                "5" => "userlock",
                "6" => "notfound",
                "7" => "noop",
                "8" => "updated",
            },
            1122 => { "0" => "no",      "1" => "yes" },
            1127 => { "0" => "no",      "1" => "yes" },
            1128 => { "0" => "no",      "1" => "yes" },
            1147 => { 2   => "success", 3   => "failure" },
            1173 => { "0" => "no",      "1" => "yes" },
            1174 => { "0" => "no",      "1" => "yes" },
            1176 => { "0" => "no",      "1" => "yes" },
            1197 => { "0" => "No",      "1" => "Yes" },
            1200 => {
                10 => "Start",
                11 => "Challenge",
                12 => "Notification",
                13 => "Re-authentication",
            },
            1938 => { 1 => "save", 2 => "load", 3 => "clear", 4 => "refresh" },
            1943 =>
              { "0" => "no", "1" => "yes", "2" => "skipped", "3" => "unknown" },
            2100 => { 311 => "Microsoft" },
            2106 => { "0" => "x86",    "6" => "i64", "9" => "x86_64" },
            2109 => { 1   => "client", 2   => "dc",  3   => "server" },
            2119 => { "0" => "no",     "1" => "yes" },
        },
        rvsattr => {
            4 => {
                10 => [ "Unix-FTP-UID",         "integer" ],
                11 => [ "Unix-FTP-GID",         "integer" ],
                12 => [ "Unix-FTP-Home",        "string" ],
                13 => [ "Unix-FTP-Shell",       "string" ],
                14 => [ "Unix-FTP-Group-Names", "string" ],
                15 => [ "Unix-FTP-Group-Ids",   "string" ],
            },
            5 => {
                1  => [ "Acc-Reason-Code",              "integer" ],
                2  => [ "Acc-Ccp-Option",               "integer" ],
                3  => [ "Acc-Input-Errors",             "integer" ],
                4  => [ "Acc-Output-Errors",            "integer" ],
                5  => [ "Acc-Access-Partition",         "string" ],
                6  => [ "Acc-Customer-Id",              "string" ],
                7  => [ "Acc-Ip-Gateway-Pri",           "ipaddr" ],
                8  => [ "Acc-Ip-Gateway-Sec",           "ipaddr" ],
                9  => [ "Acc-Route-Policy",             "integer" ],
                10 => [ "Acc-ML-MLX-Admin-State",       "integer" ],
                11 => [ "Acc-ML-Call-Threshold",        "integer" ],
                12 => [ "Acc-ML-Clear-Threshold",       "integer" ],
                13 => [ "Acc-ML-Damping-Factor",        "integer" ],
                14 => [ "Acc-Tunnel-Secret",            "string" ],
                15 => [ "Acc-Clearing-Cause",           "integer" ],
                16 => [ "Acc-Clearing-Location",        "integer" ],
                17 => [ "Acc-Service-Profile",          "string" ],
                18 => [ "Acc-Request-Type",             "integer" ],
                19 => [ "Acc-Bridging-Support",         "integer" ],
                20 => [ "Acc-Apsm-Oversubscribed",      "integer" ],
                21 => [ "Acc-Acct-On-Off-Reason",       "integer" ],
                22 => [ "Acc-Tunnel-Port",              "integer" ],
                23 => [ "Acc-Dns-Server-Pri",           "ipaddr" ],
                24 => [ "Acc-Dns-Server-Sec",           "ipaddr" ],
                25 => [ "Acc-Nbns-Server-Pri",          "ipaddr" ],
                26 => [ "Acc-Nbns-Server-Sec",          "ipaddr" ],
                27 => [ "Acc-Dial-Port-Index",          "integer" ],
                28 => [ "Acc-Ip-Compression",           "integer" ],
                29 => [ "Acc-Ipx-Compression",          "integer" ],
                30 => [ "Acc-Connect-Tx-Speed",         "integer" ],
                31 => [ "Acc-Connect-Rx-Speed",         "integer" ],
                32 => [ "Acc-Modem-Modulation-Type",    "string" ],
                33 => [ "Acc-Modem-Error-Protocol",     "string" ],
                34 => [ "Acc-Callback-Delay",           "integer" ],
                35 => [ "Acc-Callback-Num-Valid",       "string" ],
                36 => [ "Acc-Callback-Mode",            "integer" ],
                37 => [ "Acc-Callback-CBCP-Type",       "integer" ],
                38 => [ "Acc-Dialout-Auth-Mode",        "integer" ],
                39 => [ "Acc-Dialout-Auth-Password",    "string" ],
                40 => [ "Acc-Dialout-Auth-Username",    "string" ],
                42 => [ "Acc-Access-Community",         "integer" ],
                43 => [ "Acc-Vpsm-Reject-Cause",        "integer" ],
                44 => [ "Acc-Ace-Token",                "string" ],
                45 => [ "Acc-Ace-Token-Ttl",            "integer" ],
                46 => [ "Acc-Ip-Pool-Name",             "string" ],
                47 => [ "Acc-Igmp-Admin-State",         "integer" ],
                48 => [ "Acc-Igmp-Version",             "integer" ],
                73 => [ "Acc-MN-HA-Secret",             "string" ],
                98 => [ "Acc-Location-Id",              "string" ],
                99 => [ "Acc-Calling-Station-Category", "integer" ],
            },
            9 => {
                1   => [ "Cisco-AVPair",                   "string" ],
                2   => [ "Cisco-NAS-Port",                 "string" ],
                3   => [ "Cisco-Fax-Account-Id-Origin",    "string" ],
                4   => [ "Cisco-Fax-Msg-Id",               "string" ],
                5   => [ "Cisco-Fax-Pages",                "string" ],
                6   => [ "Cisco-Fax-Coverpage-Flag",       "string" ],
                7   => [ "Cisco-Fax-Modem-Time",           "string" ],
                8   => [ "Cisco-Fax-Connect-Speed",        "string" ],
                9   => [ "Cisco-Fax-Recipient-Count",      "string" ],
                10  => [ "Cisco-Fax-Process-Abort-Flag",   "string" ],
                11  => [ "Cisco-Fax-Dsn-Address",          "string" ],
                12  => [ "Cisco-Fax-Dsn-Flag",             "string" ],
                13  => [ "Cisco-Fax-Mdn-Address",          "string" ],
                14  => [ "Cisco-Fax-Mdn-Flag",             "string" ],
                15  => [ "Cisco-Fax-Auth-Status",          "string" ],
                16  => [ "Cisco-Email-Server-Address",     "string" ],
                17  => [ "Cisco-Email-Server-Ack-Flag",    "string" ],
                18  => [ "Cisco-Gateway-Id",               "string" ],
                19  => [ "Cisco-Call-Type",                "string" ],
                20  => [ "Cisco-Port-Used",                "string" ],
                21  => [ "Cisco-Abort-Cause",              "string" ],
                23  => [ "h323-remote-address",            "string" ],
                24  => [ "h323-conf-id",                   "string" ],
                25  => [ "h323-setup-time",                "string" ],
                26  => [ "h323-call-origin",               "string" ],
                27  => [ "h323-call-type",                 "string" ],
                28  => [ "h323-connect-time",              "string" ],
                29  => [ "h323-disconnect-time",           "string" ],
                30  => [ "h323-disconnect-cause",          "string" ],
                31  => [ "h323-voice-quality",             "string" ],
                33  => [ "h323-gw-id",                     "string" ],
                35  => [ "h323-incoming-conf-id",          "string" ],
                37  => [ "Cisco-Policy-Up",                "string" ],
                38  => [ "Cisco-Policy-Down",              "string" ],
                46  => [ "Cisco-Relay-Information-Option", "string" ],
                47  => [ "Cisco-DHCP-User-Class",          "string" ],
                48  => [ "Cisco-DHCP-Vendor-Class",        "string" ],
                50  => [ "Cisco-DHCP-Relay-GiAddr",        "string" ],
                51  => [ "Cisco-Service-Name",             "string" ],
                52  => [ "Cisco-Parent-Session-Id",        "string" ],
                55  => [ "Cisco-Sub-QoS-Pol-In",           "string" ],
                56  => [ "Cisco-Sub-QoS-Pol-Out",          "string" ],
                57  => [ "Cisco-In-ACL",                   "string" ],
                58  => [ "Cisco-Out-ACL",                  "string" ],
                59  => [ "Cisco-Sub-PBR-Policy-In",        "string" ],
                60  => [ "Cisco-Sub-Activate-Service",     "string" ],
                61  => [ "Cisco-IPv6-In-ACL",              "string" ],
                62  => [ "Cisco-IPv6-Out-ACL",             "string" ],
                63  => [ "Cisco-Sub-Deactivate-Service",   "string" ],
                65  => [ "Cisco-DHCP-Subscriber-Id",       "string" ],
                66  => [ "Cisco-DHCPv6-Link-Address",      "string" ],
                100 => [ "sip-conf-id",                    "string" ],
                101 => [ "h323-credit-amount",             "string" ],
                102 => [ "h323-credit-time",               "string" ],
                103 => [ "h323-return-code",               "string" ],
                104 => [ "h323-prompt-id",                 "string" ],
                105 => [ "h323-time-and-day",              "string" ],
                106 => [ "h323-redirect-number",           "string" ],
                107 => [ "h323-preferred-lang",            "string" ],
                108 => [ "h323-redirect-ip-address",       "string" ],
                109 => [ "h323-billing-model",             "string" ],
                110 => [ "h323-currency",                  "string" ],
                111 => [ "subscriber",                     "string" ],
                112 => [ "gw-rxd-cdn",                     "string" ],
                113 => [ "gw-final-xlated-cdn",            "string" ],
                114 => [ "remote-media-address",           "string" ],
                115 => [ "release-source",                 "string" ],
                116 => [ "gw-rxd-cgn",                     "string" ],
                117 => [ "gw-final-xlated-cgn",            "string" ],
                141 => [ "call-id",                        "string" ],
                142 => [ "session-protocol",               "string" ],
                143 => [ "method",                         "string" ],
                144 => [ "prev-hop-via",                   "string" ],
                145 => [ "prev-hop-ip",                    "string" ],
                146 => [ "incoming-req-uri",               "string" ],
                147 => [ "outgoing-req-uri",               "string" ],
                148 => [ "next-hop-ip",                    "string" ],
                149 => [ "next-hop-dn",                    "string" ],
                150 => [ "sip-hdr",                        "string" ],
                151 => [ "dsp-id",                         "string" ],
                187 => [ "Cisco-Multilink-ID",             "integer" ],
                188 => [ "Cisco-Num-In-Multilink",         "integer" ],
                190 => [ "Cisco-Pre-Input-Octets",         "integer" ],
                191 => [ "Cisco-Pre-Output-Octets",        "integer" ],
                192 => [ "Cisco-Pre-Input-Packets",        "integer" ],
                193 => [ "Cisco-Pre-Output-Packets",       "integer" ],
                194 => [ "Cisco-Maximum-Time",             "integer" ],
                195 => [ "Cisco-Disconnect-Cause",         "integer" ],
                197 => [ "Cisco-Data-Rate",                "integer" ],
                198 => [ "Cisco-PreSession-Time",          "integer" ],
                208 => [ "Cisco-PW-Lifetime",              "integer" ],
                209 => [ "Cisco-IP-Direct",                "integer" ],
                210 => [ "Cisco-PPP-VJ-Slot-Comp",         "integer" ],
                212 => [ "Cisco-PPP-Async-Map",            "integer" ],
                217 => [ "Cisco-IP-Pool-Definition",       "string" ],
                218 => [ "Cisco-Assign-IP-Pool",           "integer" ],
                228 => [ "Cisco-Route-IP",                 "integer" ],
                233 => [ "Cisco-Link-Compression",         "integer" ],
                234 => [ "Cisco-Target-Util",              "integer" ],
                235 => [ "Cisco-Maximum-Channels",         "integer" ],
                242 => [ "Cisco-Data-Filter",              "integer" ],
                243 => [ "Cisco-Call-Filter",              "integer" ],
                244 => [ "Cisco-Idle-Limit",               "integer" ],
                249 => [ "Cisco-Subscriber-Password",      "string" ],
                250 => [ "Cisco-Account-Info",             "string" ],
                251 => [ "Cisco-Service-Info",             "string" ],
                252 => [ "Cisco-Command-Code",             "string" ],
                253 => [ "Cisco-Control-Info",             "string" ],
                255 => [ "Cisco-Xmit-Rate",                "integer" ],
            },
            11 => {
                1   => [ "HP-Privilege-Level",          "integer" ],
                2   => [ "HP-Command-String",           "string" ],
                3   => [ "HP-Command-Exception",        "integer" ],
                10  => [ "HP-Port-Client-Limit-Dot1x",  "integer" ],
                11  => [ "HP-Port-Client-Limit-MA",     "integer" ],
                12  => [ "HP-Port-Client-Limit-WA",     "integer" ],
                13  => [ "HP-Port-Auth-Mode-Dot1x",     "integer" ],
                14  => [ "HP-Port-MA-Port-Mode",        "integer" ],
                23  => [ "HP-Port-Bounce-Host",         "integer" ],
                24  => [ "HP-Captive-Portal-URL",       "string" ],
                25  => [ "HP-User-Role",                "string" ],
                26  => [ "HP-Management-Protocol",      "integer" ],
                27  => [ "HP-CPPM-Role",                "string" ],
                28  => [ "HP-CPPM-Secondary-Role",      "string" ],
                40  => [ "HP-Cos",                      "string" ],
                46  => [ "HP-Bandwidth-Max-Ingress",    "integer" ],
                48  => [ "HP-Bandwidth-Max-Egress",     "integer" ],
                61  => [ "HP-Nas-Filter-Rule",          "string" ],
                62  => [ "HP-Access-Profile",           "string" ],
                63  => [ "HP-Nas-Rules-IPv6",           "integer" ],
                64  => [ "HP-Egress-VLANID",            "integer" ],
                65  => [ "HP-Egress-VLAN-Name",         "string" ],
                66  => [ "HP-Bonjour-Inbound-Profile",  "string" ],
                67  => [ "HP-Bonjour-Outbound-Profile", "string" ],
                80  => [ "HP-URI-String",               "string" ],
                81  => [ "HP-URI-Json-String",          "string" ],
                82  => [ "HP-URI-Access",               "string" ],
                83  => [ "HP-URI-Exception",            "integer" ],
                192 => [ "HP-VC-groups",                "string" ],
                255 => [ "HP-Capability-Advert",        "octets" ],
            },
            43 => {
                1   => [ "3Com-User-Access-Level",     "integer" ],
                2   => [ "3Com-VLAN-Name",             "string" ],
                3   => [ "3Com-Mobility-Profile",      "string" ],
                4   => [ "3Com-Encryption-Type",       "string" ],
                5   => [ "3Com-Time-Of-Day",           "string" ],
                6   => [ "3Com-SSID",                  "string" ],
                7   => [ "3Com-End-Date",              "string" ],
                8   => [ "3Com-URL",                   "string" ],
                26  => [ "3Com-Connect_Id",            "integer" ],
                59  => [ "3Com-NAS-Startup-Timestamp", "integer" ],
                60  => [ "3Com-Ip-Host-Addr",          "string" ],
                255 => [ "3Com-Product-ID",            "string" ],
            },
            52 => {
                201 => [ "Cabletron-Protocol-Enable",   "integer" ],
                202 => [ "Cabletron-Protocol-Callable", "integer" ],
            },
            61 => {
                211 => [ "Merit-Proxy-Action", "string" ],
                222 => [ "Merit-User-Id",      "string" ],
                223 => [ "Merit-User-Realm",   "string" ],
            },
            64 => {
                "0"  => [ "Gandalf-Remote-LAN-Name",       "string" ],
                "1"  => [ "Gandalf-Operational-Modes",     "integer" ],
                "2"  => [ "Gandalf-Compression-Status",    "integer" ],
                "3"  => [ "Gandalf-Min-Outgoing-Bearer",   "integer" ],
                "5"  => [ "Gandalf-Authentication-String", "string" ],
                "6"  => [ "Gandalf-PPP-Authentication",    "integer" ],
                "7"  => [ "Gandalf-PPP-NCP-Type",          "integer" ],
                "8"  => [ "Gandalf-Fwd-Multicast-In",      "integer" ],
                "9"  => [ "Gandalf-Fwd-Broadcast-In",      "integer" ],
                "10" => [ "Gandalf-Fwd-Unicast-In",        "integer" ],
                "11" => [ "Gandalf-Fwd-Multicast-Out",     "integer" ],
                "12" => [ "Gandalf-Fwd-Broadcast-Out",     "integer" ],
                "13" => [ "Gandalf-Fwd-Unicast-Out",       "integer" ],
                "14" => [ "Gandalf-Around-The-Corner",     "integer" ],
                "15" => [ "Gandalf-Channel-Group-Name-1",  "string" ],
                "16" => [ "Gandalf-Dial-Prefix-Name-1",    "string" ],
                "17" => [ "Gandalf-Phone-Number-1",        "string" ],
                "18" => [ "Gandalf-Calling-Line-ID-1",     "string" ],
                "19" => [ "Gandalf-Channel-Group-Name-2",  "string" ],
                "20" => [ "Gandalf-Dial-Prefix-Name-2",    "string" ],
                "21" => [ "Gandalf-Phone-Number-2",        "string" ],
                "22" => [ "Gandalf-Calling-Line-ID-2",     "string" ],
                "23" => [ "Gandalf-IPX-Spoofing-State",    "integer" ],
                "24" => [ "Gandalf-IPX-Watchdog-Spoof",    "integer" ],
                "25" => [ "Gandalf-SAP-Group-Name-1",      "string" ],
                "26" => [ "Gandalf-SAP-Group-Name-2",      "string" ],
                "27" => [ "Gandalf-SAP-Group-Name-3",      "string" ],
                "28" => [ "Gandalf-SAP-Group-Name-4",      "string" ],
                "29" => [ "Gandalf-SAP-Group-Name-5",      "string" ],
                "30" => [ "Gandalf-Hunt-Group",            "string" ],
                "31" => [ "Gandalf-Modem-Mode",            "integer" ],
                "32" => [ "Gandalf-Modem-Required-1",      "integer" ],
                "33" => [ "Gandalf-Modem-Required-2",      "integer" ],
            },
            66 => {
                10 => [ "Citrix-UID",         "integer" ],
                11 => [ "Citrix-GID",         "integer" ],
                12 => [ "Citrix-Home",        "string" ],
                13 => [ "Citrix-Shell",       "string" ],
                14 => [ "Citrix-Group-Names", "string" ],
                15 => [ "Citrix-Group-Ids",   "string" ],
                16 => [ "Citrix-User-Groups", "string" ],
            },
            94 => {
                1  => [ "Nokia-AVPair",                     "string" ],
                2  => [ "Nokia-User-Profile",               "string" ],
                3  => [ "Nokia-Service-Name",               "octets" ],
                4  => [ "Nokia-Service-Id",                 "octets" ],
                5  => [ "Nokia-Service-Username",           "octets" ],
                6  => [ "Nokia-Service-Password",           "octets" ],
                7  => [ "Nokia-Service-Primary-Indicator",  "octets" ],
                8  => [ "Nokia-Service-Charging-Type",      "octets" ],
                9  => [ "Nokia-Service-Encrypted-Password", "octets" ],
                10 => [ "Nokia-Session-Access-Method",      "octets" ],
                11 => [ "Nokia-Session-Charging-Type",      "octets" ],
                12 => [ "Nokia-OCS-ID1",                    "integer" ],
                13 => [ "Nokia-OCS-ID2",                    "integer" ],
                14 => [ "Nokia-TREC-Index",                 "integer" ],
                15 => [ "Nokia-Requested-APN",              "string" ],
            },
            117 => {
                1 => [ "Telebit-Login-Command",    "string" ],
                2 => [ "Telebit-Port-Name",        "string" ],
                3 => [ "Telebit-Activate-Command", "string" ],
                4 => [ "Telebit-Accounting-Info",  "string" ],
                5 => [ "Telebit-Login-Option",     "string" ],
            },
            161 => {
                1  => [ "Motorola-Canopy-LPULCIR",                 "integer" ],
                2  => [ "Motorola-Canopy-LPDLCIR",                 "integer" ],
                3  => [ "Motorola-Canopy-HPULCIR",                 "integer" ],
                4  => [ "Motorola-Canopy-HPDLCIR",                 "integer" ],
                5  => [ "Motorola-Canopy-HPENABLE",                "integer" ],
                6  => [ "Motorola-Canopy-ULBR",                    "integer" ],
                7  => [ "Motorola-Canopy-ULBL",                    "integer" ],
                8  => [ "Motorola-Canopy-DLBR",                    "integer" ],
                9  => [ "Motorola-Canopy-DLBL",                    "integer" ],
                10 => [ "Motorola-WiMAX-MIP-MN-HOME-ADDRESS",      "ipaddr" ],
                11 => [ "Motorola-WiMAX-MIP-KEY",                  "string" ],
                12 => [ "Motorola-WiMAX-MIP-SPI",                  "integer" ],
                13 => [ "Motorola-WiMAX-MN-HA",                    "ipaddr" ],
                14 => [ "Motorola-Canopy-VLLEARNEN",               "integer" ],
                15 => [ "Motorola-Canopy-VLFRAMES",                "integer" ],
                16 => [ "Motorola-Canopy-VLIDSET",                 "integer" ],
                20 => [ "Motorola-WiMAX-DNS-Server-IP-Address",    "octets" ],
                21 => [ "Motorola-Canopy-VLIGVID",                 "integer" ],
                22 => [ "Motorola-WiMAX-User-NAI",                 "string" ],
                23 => [ "Motorola-Canopy-VLSMMGPASS",              "integer" ],
                24 => [ "Motorola-Canopy-BCASTMIR",                "integer" ],
                30 => [ "Motorola-WiMAX-Network-Domain-Name",      "string" ],
                31 => [ "Motorola-WiMAX-EMS-Address",              "ipaddr" ],
                32 => [ "Motorola-WiMAX-Provisioning-Server",      "string" ],
                34 => [ "Motorola-WiMAX-NTP-Server",               "octets" ],
                35 => [ "Motorola-WiMAX-HO-SVC-CLASS",             "octets" ],
                50 => [ "Motorola-WiMAX-Home-BTS",                 "octets" ],
                60 => [ "Motorola-WiMAX-Maximum-Total-Bandwidth",  "octets" ],
                61 => [ "Motorola-WiMAX-Maximum-Commit-Bandwidth", "octets" ],
                63 => [ "Motorola-WiMAX-Convergence-Sublayer",     "octets" ],
                64 => [ "Motorola-WiMAX-Service-Flows",            "string" ],
                65 => [ "Motorola-WiMAX-VLAN-ID",                  "octets" ],
                80 => [ "Motorola-Accounting-Message",             "string" ],
            },
            166 => {
                1   => [ "Shiva-User-Attributes",   "string" ],
                30  => [ "Shiva-Compression",       "integer" ],
                31  => [ "Shiva-Dialback-Delay",    "integer" ],
                32  => [ "Shiva-Call-Durn-Trap",    "integer" ],
                33  => [ "Shiva-Bandwidth-Trap",    "integer" ],
                34  => [ "Shiva-Minimum-Call",      "integer" ],
                35  => [ "Shiva-Default-Host",      "string" ],
                36  => [ "Shiva-Menu-Name",         "string" ],
                37  => [ "Shiva-User-Flags",        "string" ],
                38  => [ "Shiva-Termtype",          "string" ],
                39  => [ "Shiva-Break-Key",         "string" ],
                40  => [ "Shiva-Fwd-Key",           "string" ],
                41  => [ "Shiva-Bak-Key",           "string" ],
                42  => [ "Shiva-Dial-Timeout",      "integer" ],
                43  => [ "Shiva-LAT-Port",          "string" ],
                44  => [ "Shiva-Max-VCs",           "integer" ],
                45  => [ "Shiva-DHCP-Leasetime",    "integer" ],
                46  => [ "Shiva-LAT-Groups",        "string" ],
                60  => [ "Shiva-RTC-Timestamp",     "integer" ],
                61  => [ "Shiva-Circuit-Type",      "integer" ],
                90  => [ "Shiva-Called-Number",     "string" ],
                91  => [ "Shiva-Calling-Number",    "string" ],
                92  => [ "Shiva-Customer-Id",       "string" ],
                93  => [ "Shiva-Type-Of-Service",   "integer" ],
                94  => [ "Shiva-Link-Speed",        "integer" ],
                95  => [ "Shiva-Links-In-Bundle",   "integer" ],
                96  => [ "Shiva-Compression-Type",  "integer" ],
                97  => [ "Shiva-Link-Protocol",     "integer" ],
                98  => [ "Shiva-Network-Protocols", "integer" ],
                99  => [ "Shiva-Session-Id",        "integer" ],
                100 => [ "Shiva-Disconnect-Reason", "integer" ],
                101 => [ "Shiva-Acct-Serv-Switch",  "ipaddr" ],
                102 => [ "Shiva-Event-Flags",       "integer" ],
                103 => [ "Shiva-Function",          "integer" ],
                104 => [ "Shiva-Connect-Reason",    "integer" ],
            },
            171 => {
                1  => [ "Dlink-User-Level",                   "integer" ],
                2  => [ "Dlink-Ingress-Bandwidth-Assignment", "integer" ],
                3  => [ "Dlink-Egress-Bandwidth-Assignment",  "integer" ],
                4  => [ "Dlink-1p-Priority",                  "integer" ],
                10 => [ "Dlink-VLAN-Name",                    "string" ],
                11 => [ "Dlink-VLAN-ID",                      "string" ],
                12 => [ "Dlink-ACL-Profile",                  "string" ],
                13 => [ "Dlink-ACL-Rule",                     "string" ],
                14 => [ "Dlink-ACL-Script",                   "string" ],
            },
            177 => {
                11  => [ "NET-Fwd-Flow-In-Realm",          "string" ],
                12  => [ "NET-Fwd-Flow-In-Src-Addr",       "string" ],
                13  => [ "NET-Fwd-Flow-In-Src-Port",       "integer" ],
                14  => [ "NET-Fwd-Flow-In-Dst-Addr",       "string" ],
                15  => [ "NET-Fwd-Flow-In-Dst-Port",       "integer" ],
                16  => [ "NET-Fwd-Flow-Out-Realm",         "string" ],
                17  => [ "NET-Fwd-Flow-Out-Src-Addr",      "string" ],
                18  => [ "NET-Fwd-Flow-Out-Src-Port",      "integer" ],
                19  => [ "NET-Fwd-Flow-Out-Dst-Addr",      "string" ],
                20  => [ "NET-Fwd-Flow-Out-Dst-Port",      "integer" ],
                21  => [ "NET-Bwd-Flow-In-Realm",          "string" ],
                22  => [ "NET-Bwd-Flow-In-Src-Addr",       "string" ],
                23  => [ "NET-Bwd-Flow-In-Src-Port",       "integer" ],
                24  => [ "NET-Bwd-Flow-In-Dst-Addr",       "string" ],
                25  => [ "NET-Bwd-Flow-In-Dst-Port",       "integer" ],
                26  => [ "NET-Bwd-Flow-Out-Realm",         "string" ],
                27  => [ "NET-Bwd-Flow-Out-Src-Addr",      "string" ],
                28  => [ "NET-Bwd-Flow-Out-Src-Port",      "integer" ],
                29  => [ "NET-Bwd-Flow-Out-Dst-Addr",      "string" ],
                30  => [ "NET-Bwd-Flow-Out-Dst-Port",      "integer" ],
                31  => [ "NET-Fwd-Flow-Media-Type",        "string" ],
                32  => [ "NET-Fwd-Flow-PTime",             "integer" ],
                33  => [ "NET-Fwd-Octets",                 "integer" ],
                34  => [ "NET-Fwd-Packets",                "integer" ],
                35  => [ "NET-Fwd-RTCP-Packets-Lost",      "integer" ],
                36  => [ "NET-Fwd-RTCP-Avg-Jitter",        "integer" ],
                37  => [ "NET-Fwd-RTP-Avg-Latency",        "integer" ],
                38  => [ "NET-Fwd-RTCP-MaxJitter",         "integer" ],
                39  => [ "NET-Fwd-RTP-MaxLatency",         "integer" ],
                40  => [ "NET-Fwd-RTP-Packets-Lost",       "integer" ],
                41  => [ "NET-Fwd-RTP-Avg-Jitter",         "integer" ],
                42  => [ "NET-Fwd-RTP-MaxJitter",          "integer" ],
                43  => [ "NET-Bwd-Octets",                 "integer" ],
                44  => [ "NET-Bwd-Packets",                "integer" ],
                45  => [ "NET-Bwd-RTCP-Packets-Lost",      "integer" ],
                46  => [ "NET-Bwd-RTCP-Avg-Jitter",        "integer" ],
                47  => [ "NET-Bwd-RTP-Avg-Latency",        "integer" ],
                48  => [ "NET-Bwd-RTCP-MaxJitter",         "integer" ],
                49  => [ "NET-Bwd-RTP-MaxLatency",         "integer" ],
                50  => [ "NET-Bwd-RTP-Packets-Lost",       "integer" ],
                51  => [ "NET-Bwd-RTP-Avg-Jitter",         "integer" ],
                52  => [ "NET-Bwd-RTP-MaxJitter",          "integer" ],
                60  => [ "NET-Session-Ingress-CallId",     "integer" ],
                61  => [ "NET-Session-Egress-CallId",      "integer" ],
                62  => [ "NET-Session-Generic-Id",         "integer" ],
                63  => [ "NET-Routing-Table-Number",       "integer" ],
                64  => [ "NET-Ingress-Signaling-Group",    "integer" ],
                65  => [ "NET-Egress-Signaling-Group",     "integer" ],
                66  => [ "NET-Primary-Routing-Number",     "string" ],
                67  => [ "NET-Egress-Final-Routing-Num",   "string" ],
                68  => [ "NET-Ingress-Channel-Number",     "integer" ],
                69  => [ "NET-Egress-Channel-Number",      "integer" ],
                70  => [ "NET-Call-Type",                  "integer" ],
                71  => [ "NET-Call-Origin",                "integer" ],
                72  => [ "NET-Calling-Number",             "string" ],
                73  => [ "NET-Called-Number",              "string" ],
                74  => [ "NET-Calling-Name",               "string" ],
                75  => [ "NET-Disconnect-Cause",           "integer" ],
                76  => [ "NET-Abort-Cause",                "integer" ],
                77  => [ "NET-Ingress-Channel-Id",         "string" ],
                78  => [ "NET-Egress-Channel-Id",          "string" ],
                79  => [ "NET-Call-Priority",              "string" ],
                90  => [ "NET-Call-Number-Type",           "string" ],
                91  => [ "NET-Call-Plan",                  "string" ],
                92  => [ "NET-Original-Called-Number",     "string" ],
                93  => [ "NET-Original-Called-Type",       "string" ],
                94  => [ "NET-Original-Called-Plan",       "string" ],
                95  => [ "NET-Called-Name",                "string" ],
                96  => [ "NET-Namespace",                  "string" ],
                97  => [ "NET-Precedence",                 "string" ],
                98  => [ "NET-Presentation",               "string" ],
                99  => [ "NET-Screening",                  "string" ],
                100 => [ "NET-Transfer-Capability",        "string" ],
                101 => [ "NET-Transfer-Mode",              "string" ],
                102 => [ "NET-Transfer-Rate",              "string" ],
                103 => [ "NET-User-Rate",                  "string" ],
                110 => [ "NET-Setup-Time",                 "string" ],
                111 => [ "NET-Alert-Time",                 "string" ],
                112 => [ "NET-Connect-Time",               "string" ],
                113 => [ "NET-Disconnect-Time",            "string" ],
                114 => [ "NET-Inbound-Seize-Time",         "string" ],
                115 => [ "NET-Outbound-Seize-Time",        "string" ],
                116 => [ "NET-Call-Duration",              "integer" ],
                117 => [ "NET-Post-Dial-Delay",            "integer" ],
                118 => [ "NET-Disconnect-Initiator",       "integer" ],
                130 => [ "NET-P-Asserted-ID",              "string" ],
                131 => [ "NET-SIP-Diversion",              "string" ],
                132 => [ "NET-Ingress-Local-Addr",         "string" ],
                133 => [ "NET-Ingress-Remote-Addr",        "string" ],
                134 => [ "NET-Egress-Local-Addr",          "string" ],
                135 => [ "NET-Egress-Remote-Addr",         "string" ],
                136 => [ "NET-Ingress-Net-Interface-Id",   "integer" ],
                137 => [ "NET-Egress-Net-Interface-Id",    "integer" ],
                138 => [ "NET-Refer-Call-Transfer-Id",     "string" ],
                139 => [ "NET-Session-Forked-Call-Id",     "string" ],
                140 => [ "NET-Redirect-Number",            "string" ],
                141 => [ "NET-Redirect-Ip-Address",        "string" ],
                142 => [ "NET-Session-Ingress-Realm",      "string" ],
                143 => [ "NET-Session-Egress-Realm",       "string" ],
                144 => [ "NET-Ingress-Signaling-Port-Num", "integer" ],
                145 => [ "NET-Egress-Signaling-Port-Num",  "integer" ],
                146 => [ "NET-Transport-Type",             "integer" ],
                147 => [ "NET-P-Preferred-ID",             "string" ],
                148 => [ "NET-Replaced-Header",            "string" ],
                160 => [ "NET-Firmware-Version",           "string" ],
                161 => [ "NET-Local-Time-Zone",            "string" ],
                162 => [ "NET-Gw-Id",                      "string" ],
                163 => [ "NET-Time-And-Day",               "string" ],
                164 => [ "NET-Log-Time",                   "string" ],
            },
            193 => {
                3   => [ "Ericsson-ViG-Balance",                  "integer" ],
                4   => [ "Ericsson-ViG-Codec",                    "integer" ],
                5   => [ "Ericsson-ViG-Currency",                 "string" ],
                6   => [ "Ericsson-ViG-Currency-Quote",           "string" ],
                8   => [ "Ericsson-ViG-Endpoint-Type",            "integer" ],
                9   => [ "Ericsson-ViG-Sequence-Number",          "integer" ],
                11  => [ "Ericsson-ViG-Access-Agent-IP-Address",  "ipaddr" ],
                12  => [ "Ericsson-ViG-QoS-Class",                "integer" ],
                14  => [ "Ericsson-ViG-Digest-Response",          "string" ],
                15  => [ "Ericsson-ViG-Digest-Attributes",        "octets" ],
                16  => [ "Ericsson-ViG-Business-Agreement-Name",  "string" ],
                17  => [ "Ericsson-ViG-Call-Role",                "integer" ],
                20  => [ "Ericsson-ViG-Remote-SK-UA-IP-Address",  "ipaddr" ],
                23  => [ "Ericsson-ViG-Site",                     "string" ],
                32  => [ "Ericsson-ViG-TTL-relative",             "integer" ],
                33  => [ "Ericsson-ViG-Account-error-reason",     "integer" ],
                34  => [ "Ericsson-ViG-Layer-identity",           "integer" ],
                35  => [ "Ericsson-ViG-Major-protocol-version",   "integer" ],
                36  => [ "Ericsson-ViG-Minor-protocol-version",   "integer" ],
                37  => [ "Ericsson-ViG-Authentication-type",      "integer" ],
                38  => [ "Ericsson-ViG-Trusted-access",           "integer" ],
                39  => [ "Ericsson-ViG-User-name",                "string" ],
                40  => [ "Ericsson-ViG-Global-unique-call-ID",    "string" ],
                41  => [ "Ericsson-ViG-Global-unique-service-ID", "string" ],
                42  => [ "Ericsson-ViG-Interim-interval",         "integer" ],
                43  => [ "Ericsson-ViG-Alive-Indicator",          "integer" ],
                44  => [ "Ericsson-ViG-TTL-Absolute",             "integer" ],
                45  => [ "Ericsson-ViG-TTL-Start-Event",          "integer" ],
                46  => [ "Ericsson-ViG-SK-IP-address",            "ipaddr" ],
                47  => [ "Ericsson-ViG-UA-IP-address",            "ipaddr" ],
                48  => [ "Ericsson-ViG-SA-IP-address",            "ipaddr" ],
                49  => [ "Ericsson-ViG-Calling-e164-number",      "string" ],
                50  => [ "Ericsson-ViG-Calling-H323Id",           "string" ],
                51  => [ "Ericsson-ViG-Calling-Email-address",    "string" ],
                52  => [ "Ericsson-ViG-Dialled-e164-number",      "string" ],
                53  => [ "Ericsson-ViG-Dialled-H323Id",           "string" ],
                54  => [ "Ericsson-ViG-Dialled-Email-address",    "string" ],
                55  => [ "Ericsson-ViG-Routed-e164-number",       "string" ],
                56  => [ "Ericsson-ViG-Routed-H323Id",            "string" ],
                57  => [ "Ericsson-ViG-Routed-Email-address",     "string" ],
                58  => [ "Ericsson-ViG-SiteKeeper-name",          "string" ],
                59  => [ "Ericsson-ViG-Access-Group-name",        "string" ],
                60  => [ "Ericsson-ViG-Access-Agent-name",        "string" ],
                61  => [ "Ericsson-ViG-User-agent-group-name",    "string" ],
                62  => [ "Ericsson-ViG-User-agent-name",          "string" ],
                63  => [ "Ericsson-ViG-Routing-tariff",           "integer" ],
                64  => [ "Ericsson-ViG-Re-selection-counter",     "integer" ],
                65  => [ "Ericsson-ViG-CPN-digits",               "string" ],
                66  => [ "Ericsson-ViG-CPN-TON",                  "integer" ],
                67  => [ "Ericsson-ViG-CPN-NP",                   "integer" ],
                68  => [ "Ericsson-ViG-CPN-PI",                   "integer" ],
                69  => [ "Ericsson-ViG-CPN-SI",                   "integer" ],
                70  => [ "Ericsson-ViG-Dialled-num-digits",       "string" ],
                71  => [ "Ericsson-ViG-Dialled-num-TON",          "integer" ],
                72  => [ "Ericsson-ViG-Dialled-num-NP",           "integer" ],
                73  => [ "Ericsson-ViG-Routing-num-digits",       "string" ],
                74  => [ "Ericsson-ViG-Routing-num-TON",          "integer" ],
                75  => [ "Ericsson-ViG-Routing-num-NP",           "integer" ],
                76  => [ "Ericsson-ViG-Redirecting-num-digits",   "string" ],
                77  => [ "Ericsson-ViG-Redirecting-num-TON",      "integer" ],
                78  => [ "Ericsson-ViG-Redirecting-num-NP",       "integer" ],
                79  => [ "Ericsson-ViG-Redirecting-num-PI",       "integer" ],
                80  => [ "Ericsson-ViG-Redirecting-num-RFD",      "integer" ],
                81  => [ "Ericsson-ViG-Time-stamp-UTC",           "integer" ],
                82  => [ "Ericsson-ViG-Time-stamp-TZ",            "integer" ],
                83  => [ "Ericsson-ViG-Time-stamp-DST",           "integer" ],
                84  => [ "Ericsson-ViG-Session-routing-duration", "integer" ],
                85  => [ "Ericsson-ViG-Session-ringing-duration", "integer" ],
                86  => [ "Ericsson-ViG-Access-type",              "integer" ],
                87  => [ "Ericsson-ViG-Requested-bandwidth",      "integer" ],
                88  => [ "Ericsson-ViG-Allowed-bandwidth",        "integer" ],
                89  => [ "Ericsson-ViG-Media-channel-count",      "integer" ],
                90  => [ "Ericsson-ViG-Voice-media-rec-forward",  "string" ],
                91  => [ "Ericsson-ViG-Voice-media-rec-backward", "string" ],
                92  => [ "Ericsson-ViG-Video-media-rec-forward",  "string" ],
                93  => [ "Ericsson-ViG-Video-media-rec-backward", "string" ],
                94  => [ "Ericsson-ViG-Fax-media-rec-forward",    "string" ],
                95  => [ "Ericsson-ViG-Fax-media-rec-backward",   "string" ],
                96  => [ "Ericsson-ViG-Data-media-rec-forward",   "string" ],
                97  => [ "Ericsson-ViG-Data-media-rec-backward",  "string" ],
                98  => [ "Ericsson-ViG-Charging-Case",            "integer" ],
                99  => [ "Ericsson-ViG-Rel-cause-coding-std",     "integer" ],
                100 => [ "Ericsson-ViG-Rel-cause-location",       "integer" ],
                101 => [ "Ericsson-ViG-Rel-cause-class",          "integer" ],
                102 => [ "Ericsson-ViG-Rel-cause-value",          "integer" ],
                103 => [ "Ericsson-ViG-Rel-reason",               "integer" ],
                104 => [ "Ericsson-ViG-Internal-Rel-reason-val",  "integer" ],
                105 => [ "Ericsson-ViG-Internal-Rel-reason-orig", "integer" ],
                106 => [ "Ericsson-ViG-Service-ID",               "integer" ],
                107 => [ "Ericsson-ViG-User-ID",                  "string" ],
                108 => [ "Ericsson-ViG-Service-Name",             "string" ],
                109 => [ "Ericsson-ViG-Test-Call-Indicator",      "integer" ],
                110 => [ "Ericsson-ViG-Emergency-Call-Indicator", "integer" ],
                111 => [ "Ericsson-ViG-Calling-ID",               "string" ],
                112 => [ "Ericsson-ViG-Called-ID",                "string" ],
                113 => [ "Ericsson-ViG-Translated-ID",            "string" ],
                114 => [ "Ericsson-ViG-Calling-User-Group-ID",    "string" ],
                115 => [ "Ericsson-ViG-Calling-Usr-Sub-Group-ID", "string" ],
                116 => [ "Ericsson-ViG-Called-Usr-Group-ID",      "string" ],
                117 => [ "Ericsson-ViG-Called-Usr-Sub-Group-ID",  "string" ],
                118 => [ "Ericsson-ViG-Terminal-Type",            "string" ],
                119 => [ "Ericsson-ViG-Service-Duration",         "integer" ],
                120 => [ "Ericsson-ViG-Service-Execution-Result", "integer" ],
                121 => [ "Ericsson-ViG-Service-Exe-Rslt-Desc",    "string" ],
                122 => [ "Ericsson-ViG-Service-Description",      "string" ],
                123 => [ "Ericsson-ViG-Service-Specific-Info",    "string" ],
                124 => [ "Ericsson-ViG-Proxy-IP-Address",         "ipaddr" ],
                125 => [ "Ericsson-ViG-Auth-DataRequest",         "integer" ],
                126 => [ "Ericsson-ViG-IPT-Time-Stamp",           "integer" ],
                127 => [ "Ericsson-ViG-User-Name-Info",           "integer" ],
            },
            244 => { 1 => [ "Lantronix-User-Attributes", "string" ] },
            255 => {},
            266 => {
                1 => [ "Nexans-Port-Default-VLAN-ID", "integer" ],
                2 => [ "Nexans-Port-Voice-VLAN-ID",   "integer" ],
            },
            272 => {
                224 => [ "BinTec-biboPPPTable",        "string" ],
                225 => [ "BinTec-biboDialTable",       "string" ],
                226 => [ "BinTec-ipExtIfTable",        "string" ],
                227 => [ "BinTec-ipRouteTable",        "string" ],
                228 => [ "BinTec-ipExtRtTable",        "string" ],
                229 => [ "BinTec-ipNatPresetTable",    "string" ],
                230 => [ "BinTec-ipxCircTable",        "string" ],
                231 => [ "BinTec-ripCircTable",        "string" ],
                232 => [ "BinTec-sapCircTable",        "string" ],
                233 => [ "BinTec-ipxStaticRouteTable", "string" ],
                234 => [ "BinTec-ipxStaticServTable",  "string" ],
                235 => [ "BinTec-ospfIfTable",         "string" ],
                236 => [ "BinTec-pppExtIfTable",       "string" ],
                237 => [ "BinTec-ipFilterTable",       "string" ],
                238 => [ "BinTec-ipQoSTable",          "string" ],
                239 => [ "BinTec-qosIfTable",          "string" ],
                240 => [ "BinTec-qosPolicyTable",      "string" ],
            },
            307 => {
                2  => [ "LE-Terminate-Detail",          "string" ],
                3  => [ "LE-Advice-of-Charge",          "string" ],
                4  => [ "LE-Connect-Detail",            "string" ],
                6  => [ "LE-IP-Pool",                   "string" ],
                7  => [ "LE-IP-Gateway",                "ipaddr" ],
                8  => [ "LE-Modem-Info",                "string" ],
                9  => [ "LE-IPSec-Log-Options",         "integer" ],
                10 => [ "LE-IPSec-Deny-Action",         "integer" ],
                11 => [ "LE-IPSec-Active-Profile",      "string" ],
                12 => [ "LE-IPSec-Outsource-Profile",   "string" ],
                13 => [ "LE-IPSec-Passive-Profile",     "string" ],
                14 => [ "LE-NAT-TCP-Session-Timeout",   "integer" ],
                15 => [ "LE-NAT-Other-Session-Timeout", "integer" ],
                16 => [ "LE-NAT-Log-Options",           "integer" ],
                17 => [ "LE-NAT-Sess-Dir-Fail-Action",  "integer" ],
                18 => [ "LE-NAT-Inmap",                 "string" ],
                19 => [ "LE-NAT-Outmap",                "string" ],
                20 => [ "LE-NAT-Outsource-Inmap",       "string" ],
                21 => [ "LE-NAT-Outsource-Outmap",      "string" ],
                22 => [ "LE-Admin-Group",               "string" ],
                23 => [ "LE-Multicast-Client",          "integer" ],
            },
            311 => {
                1  => [ "MS-CHAP-Response",               "octets" ],
                2  => [ "MS-CHAP-Error",                  "string" ],
                3  => [ "MS-CHAP-CPW-1",                  "octets" ],
                4  => [ "MS-CHAP-CPW-2",                  "octets" ],
                5  => [ "MS-CHAP-LM-Enc-PW",              "octets" ],
                6  => [ "MS-CHAP-NT-Enc-PW",              "octets" ],
                7  => [ "MS-MPPE-Encryption-Policy",      "integer" ],
                8  => [ "MS-MPPE-Encryption-Types",       "integer" ],
                9  => [ "MS-RAS-Vendor",                  "integer" ],
                10 => [ "MS-CHAP-Domain",                 "string" ],
                11 => [ "MS-CHAP-Challenge",              "octets" ],
                12 => [ "MS-CHAP-MPPE-Keys",              "octets" ],
                13 => [ "MS-BAP-Usage",                   "integer" ],
                14 => [ "MS-Link-Utilization-Threshold",  "integer" ],
                15 => [ "MS-Link-Drop-Time-Limit",        "integer" ],
                16 => [ "MS-MPPE-Send-Key",               "octets" ],
                17 => [ "MS-MPPE-Recv-Key",               "octets" ],
                18 => [ "MS-RAS-Version",                 "string" ],
                19 => [ "MS-Old-ARAP-Password",           "octets" ],
                20 => [ "MS-New-ARAP-Password",           "octets" ],
                21 => [ "MS-ARAP-PW-Change-Reason",       "integer" ],
                22 => [ "MS-Filter",                      "octets" ],
                23 => [ "MS-Acct-Auth-Type",              "integer" ],
                24 => [ "MS-Acct-EAP-Type",               "integer" ],
                25 => [ "MS-CHAP2-Response",              "octets" ],
                26 => [ "MS-CHAP2-Success",               "octets" ],
                27 => [ "MS-CHAP2-CPW",                   "octets" ],
                28 => [ "MS-Primary-DNS-Server",          "ipaddr" ],
                29 => [ "MS-Secondary-DNS-Server",        "ipaddr" ],
                30 => [ "MS-Primary-NBNS-Server",         "ipaddr" ],
                31 => [ "MS-Secondary-NBNS-Server",       "ipaddr" ],
                34 => [ "MS-RAS-Client-Name",             "string" ],
                35 => [ "MS-RAS-Client-Version",          "string" ],
                36 => [ "MS-Quarantine-IPFilter",         "octets" ],
                37 => [ "MS-Quarantine-Session-Timeout",  "integer" ],
                40 => [ "MS-User-Security-Identity",      "string" ],
                41 => [ "MS-Identity-Type",               "integer" ],
                42 => [ "MS-Service-Class",               "string" ],
                44 => [ "MS-Quarantine-User-Class",       "string" ],
                45 => [ "MS-Quarantine-State",            "integer" ],
                46 => [ "MS-Quarantine-Grace-Time",       "integer" ],
                47 => [ "MS-Network-Access-Server-Type",  "integer" ],
                48 => [ "MS-AFW-Zone",                    "integer" ],
                49 => [ "MS-AFW-Protection-Level",        "integer" ],
                50 => [ "MS-Machine-Name",                "string" ],
                51 => [ "MS-IPv6-Filter",                 "octets" ],
                52 => [ "MS-IPv4-Remediation-Servers",    "octets" ],
                53 => [ "MS-IPv6-Remediation-Servers",    "octets" ],
                54 => [ "MS-RNAP-Not-Quarantine-Capable", "integer" ],
                55 => [ "MS-Quarantine-SOH",              "octets" ],
                56 => [ "MS-RAS-Correlation",             "octets" ],
                57 => [ "MS-Extended-Quarantine-State",   "integer" ],
                58 => [ "MS-HCAP-User-Groups",            "string" ],
                59 => [ "MS-HCAP-Location-Group-Name",    "string" ],
                60 => [ "MS-HCAP-User-Name",              "string" ],
                61 => [ "MS-User-IPv4-Address",           "ipaddr" ],
                62 => [ "MS-User-IPv6-Address",           "ipv6addr" ],
                63 => [ "MS-TSG-Device-Redirection",      "integer" ],
            },
            318 => {
                1  => [ "APC-Service-Type",  "integer" ],
                2  => [ "APC-Outlets",       "string" ],
                3  => [ "APC-Perms",         "string" ],
                4  => [ "APC-Username",      "string" ],
                5  => [ "APC-Contact",       "string" ],
                6  => [ "APC-ACCPX-Doors",   "string" ],
                7  => [ "APC-ACCPX-Status",  "string" ],
                8  => [ "APC-ACCPX-Access1", "string" ],
                9  => [ "APC-ACCPX-Access2", "string" ],
                10 => [ "APC-ACCPX-Access3", "string" ],
                11 => [ "APC-ACCPX-Access4", "string" ],
                12 => [ "APC-ACCPX-Access5", "string" ],
                13 => [ "APC-ACCPX-Access6", "string" ],
                14 => [ "APC-ACCPX-Access7", "string" ],
            },
            388 => {
                1   => [ "Symbol-Admin-Role",       "integer" ],
                2   => [ "Symbol-Current-ESSID",    "string" ],
                3   => [ "Symbol-Allowed-ESSID",    "string" ],
                4   => [ "Symbol-WLAN-Index",       "integer" ],
                5   => [ "Symbol-QoS-Profile",      "integer" ],
                6   => [ "Symbol-Allowed-Radio",    "string" ],
                7   => [ "Symbol-Expiry-Date-Time", "string" ],
                8   => [ "Symbol-Start-Date-Time",  "string" ],
                9   => [ "Symbol-Posture-Status",   "string" ],
                10  => [ "Symbol-Downlink-Limit",   "string" ],
                11  => [ "Symbol-Uplink-Limit",     "string" ],
                12  => [ "Symbol-User-Group",       "string" ],
                100 => [ "Symbol-Login-Source",     "integer" ],
            },
            429 => {
                72    => [ "USR-DTE-Data-Idle-Timout",         "integer" ],
                94    => [ "USR-Default-DTE-Data-Rate",        "integer" ],
                102   => [ "USR-Last-Number-Dialed-Out",       "string" ],
                103   => [ "USR-Sync-Async-Mode",              "integer" ],
                104   => [ "USR-Originate-Answer-Mode",        "integer" ],
                105   => [ "USR-Failure-to-Connect-Reason",    "integer" ],
                106   => [ "USR-Initial-Tx-Link-Data-Rate",    "integer" ],
                107   => [ "USR-Final-Tx-Link-Data-Rate",      "integer" ],
                108   => [ "USR-Modulation-Type",              "integer" ],
                111   => [ "USR-Equalization-Type",            "integer" ],
                112   => [ "USR-Fallback-Enabled",             "integer" ],
                113   => [ "USR-Characters-Sent",              "integer" ],
                114   => [ "USR-Characters-Received",          "integer" ],
                117   => [ "USR-Blocks-Sent",                  "integer" ],
                118   => [ "USR-Blocks-Received",              "integer" ],
                119   => [ "USR-Blocks-Resent",                "integer" ],
                120   => [ "USR-Retrains-Requested",           "integer" ],
                121   => [ "USR-Retrains-Granted",             "integer" ],
                122   => [ "USR-Line-Reversals",               "integer" ],
                123   => [ "USR-Number-Of-Characters-Lost",    "integer" ],
                124   => [ "USR-Back-Channel-Data-Rate",       "integer" ],
                125   => [ "USR-Number-of-Blers",              "integer" ],
                126   => [ "USR-Number-of-Link-Timeouts",      "integer" ],
                127   => [ "USR-Number-of-Fallbacks",          "integer" ],
                128   => [ "USR-Number-of-Upshifts",           "integer" ],
                129   => [ "USR-Number-of-Link-NAKs",          "integer" ],
                153   => [ "USR-Simplified-MNP-Levels",        "integer" ],
                155   => [ "USR-Connect-Term-Reason",          "integer" ],
                190   => [ "USR-DTR-False-Timeout",            "integer" ],
                191   => [ "USR-Fallback-Limit",               "integer" ],
                192   => [ "USR-Block-Error-Count-Limit",      "integer" ],
                199   => [ "USR-Simplified-V42bis-Usage",      "integer" ],
                218   => [ "USR-DTR-True-Timeout",             "integer" ],
                232   => [ "USR-Last-Number-Dialed-In-DNIS",   "string" ],
                233   => [ "USR-Last-Callers-Number-ANI",      "string" ],
                387   => [ "USR-CDMA-Call-Reference-Number",   "integer" ],
                388   => [ "USR-Mbi_Ct_PRI_Card_Slot",         "integer" ],
                389   => [ "USR-Mbi_Ct_TDM_Time_Slot",         "integer" ],
                390   => [ "USR-Mbi_Ct_PRI_Card_Span_Line",    "integer" ],
                391   => [ "USR-Mbi_Ct_BChannel_Used",         "integer" ],
                461   => [ "USR-RMMIE-Status",                 "integer" ],
                462   => [ "USR-RMMIE-Num-Of-Updates",         "integer" ],
                479   => [ "USR-RMMIE-Manufacturer-ID",        "integer" ],
                480   => [ "USR-RMMIE-Product-Code",           "string" ],
                481   => [ "USR-RMMIE-Serial-Number",          "string" ],
                482   => [ "USR-RMMIE-Firmware-Version",       "string" ],
                483   => [ "USR-RMMIE-Firmware-Build-Date",    "string" ],
                1012  => [ "USR-IWF-IP-Address",               "ipaddr" ],
                2190  => [ "USR-Mobile-IP-Address",            "ipaddr" ],
                2191  => [ "USR-Calling-Party-Number",         "string" ],
                2192  => [ "USR-Called-Party-Number",          "string" ],
                2193  => [ "USR-Call-Type",                    "integer" ],
                2194  => [ "USR-ESN",                          "string" ],
                2195  => [ "USR-IWF-Call-Identifier",          "integer" ],
                2196  => [ "USR-IMSI",                         "string" ],
                2197  => [ "USR-Service-Option",               "integer" ],
                2198  => [ "USR-Disconnect-Cause-Indicator",   "integer" ],
                2199  => [ "USR-Mobile-NumBytes-Txed",         "integer" ],
                2200  => [ "USR-Mobile-NumBytes-Rxed",         "integer" ],
                2201  => [ "USR-Num-Fax-Pages-Processed",      "integer" ],
                2202  => [ "USR-Compression-Type",             "integer" ],
                2203  => [ "USR-Call-Error-Code",              "integer" ],
                2204  => [ "USR-Modem-Setup-Time",             "integer" ],
                2205  => [ "USR-Call-Connecting-Time",         "integer" ],
                2206  => [ "USR-Connect-Time",                 "integer" ],
                2292  => [ "USR-QNC1-Service-Destination",     "ipaddr" ],
                2304  => [ "USR-RMMIE-Last-Update-Time",       "integer" ],
                2305  => [ "USR-RMMIE-Last-Update-Event",      "integer" ],
                2306  => [ "USR-RMMIE-Rcv-Tot-PwrLvl",         "integer" ],
                2307  => [ "USR-RMMIE-Rcv-PwrLvl-3300Hz",      "integer" ],
                2308  => [ "USR-RMMIE-Rcv-PwrLvl-3750Hz",      "integer" ],
                2309  => [ "USR-RMMIE-PwrLvl-NearEcho-Canc",   "integer" ],
                2310  => [ "USR-RMMIE-PwrLvl-FarEcho-Canc",    "integer" ],
                2311  => [ "USR-RMMIE-PwrLvl-Noise-Lvl",       "integer" ],
                2312  => [ "USR-RMMIE-PwrLvl-Xmit-Lvl",        "integer" ],
                2313  => [ "USR-RMMIE-x2-Status",              "integer" ],
                2314  => [ "USR-RMMIE-Planned-Disconnect",     "integer" ],
                2339  => [ "Initial-Modulation-Type",          "integer" ],
                32768 => [ "CW-Version-Id",                    "integer" ],
                32769 => [ "CW-Account-Id",                    "string" ],
                32770 => [ "CW-Acct-Type",                     "integer" ],
                32771 => [ "CW-Acct-Identification-Code",      "integer" ],
                32772 => [ "CW-Service-Type",                  "integer" ],
                32773 => [ "CW-Rate-Plan-Id",                  "integer" ],
                32774 => [ "CW-Source-Identifier",             "integer" ],
                32775 => [ "CW-Session-Id",                    "string" ],
                32776 => [ "CW-Num-Call-Attempt-Session",      "integer" ],
                32777 => [ "CW-Session-Sequence-Num",          "integer" ],
                32778 => [ "CW-Session-Sequence-End",          "integer" ],
                32779 => [ "CW-Authentication-Fail-Cnt",       "integer" ],
                32780 => [ "CW-Clg-Party-E164-Type",           "integer" ],
                32781 => [ "CW-Clg-Party-E164-Number",         "string" ],
                32782 => [ "CW-Clg-Party-Trans-Protocol",      "integer" ],
                32783 => [ "CW-Clg-Party-Trans-Port",          "integer" ],
                32784 => [ "CW-Clg-Party-Trans-IP",            "ipaddr" ],
                32785 => [ "CW-Clg-Party-Trans-DNS",           "string" ],
                32786 => [ "CW-Cld-Party-E164-Type",           "integer" ],
                32787 => [ "CW-Cld-Party-E164-Number",         "string" ],
                32788 => [ "CW-Cld-Party-Trans-Protocol",      "integer" ],
                32789 => [ "CW-Cld-Party-Trans-Port",          "integer" ],
                32790 => [ "CW-Cld-Party-Trans-IP",            "ipaddr" ],
                32791 => [ "CW-Cld-Party-Trans-DNS",           "string" ],
                32792 => [ "CW-Orig-Line-Identifier",          "integer" ],
                32793 => [ "CW-PSTN-Interface-Number",         "integer" ],
                32794 => [ "CW-Ingr-Gway-E164-Type",           "integer" ],
                32795 => [ "CW-Ingr-Gway-E164-Number",         "string" ],
                32796 => [ "CW-Ingr-Gway-Trans-Protocol",      "integer" ],
                32797 => [ "CW-Ingr-Gway-Trans-Port",          "integer" ],
                32798 => [ "CW-Ingr-Gway-Trans-IP",            "ipaddr" ],
                32799 => [ "CW-Ingr-Gway-Trans-DNS",           "string" ],
                32800 => [ "CW-Egr-Gway-Trans-Protocol",       "integer" ],
                32801 => [ "CW-Egr-Gway-Trans-Port",           "integer" ],
                32802 => [ "CW-Egr-Gway-Trans-IP",             "ipaddr" ],
                32803 => [ "CW-Egr-Gway-Trans-DNS",            "string" ],
                32804 => [ "CW-Ingr-Gtkpr-Trans-Protocol",     "integer" ],
                32805 => [ "CW-Ingr-Gtkpr-Trans-Port",         "integer" ],
                32806 => [ "CW-Ingr-Gtkpr-Trans-IP",           "ipaddr" ],
                32807 => [ "CW-Ingr-Gtkpr-Trans-DNS",          "string" ],
                32808 => [ "CW-Egr-Gtkpr-Trans-Protocol",      "integer" ],
                32809 => [ "CW-Egr-Gtkpr-Trans-Port",          "integer" ],
                32810 => [ "CW-Egr-Gtkpr-Trans-IP",            "ipaddr" ],
                32811 => [ "CW-Egr-Gtkpr-Trans-DNS",           "string" ],
                32812 => [ "CW-Call-Identifier",               "string" ],
                32813 => [ "CW-Call-Type",                     "integer" ],
                32814 => [ "CW-Call-Start-Ingr-GW-Sec",        "string" ],
                32815 => [ "CW-Call-Start-Ingr-GW-Msec",       "integer" ],
                32816 => [ "CW-Call-Start-Time-Ans-Sec",       "string" ],
                32817 => [ "CW-Call-Start-Time-Ans-Msec",      "integer" ],
                32818 => [ "CW-Call-End-Time-Sec",             "string" ],
                32819 => [ "CW-Call-End-Time-Msec",            "integer" ],
                32820 => [ "CW-Call-Durn-Connect-Disc",        "integer" ],
                32821 => [ "CW-Codec-Type",                    "integer" ],
                32822 => [ "CW-Call-Termination-Cause",        "integer" ],
                32823 => [ "CW-Audio-Packets-Sent",            "integer" ],
                32824 => [ "CW-Audio-Packets-Received",        "integer" ],
                32825 => [ "CW-Audio-Packets-Lost",            "integer" ],
                32826 => [ "CW-Audio-Packets-In-Frame",        "integer" ],
                32827 => [ "CW-Audio-Bytes-In-Frame",          "integer" ],
                32828 => [ "CW-Audio-Signal-In-Packet",        "integer" ],
                32829 => [ "CW-Port-Id-For-Call",              "integer" ],
                32830 => [ "CW-Slot-Id-For-Call",              "integer" ],
                32831 => [ "CW-Acct-Balance-Start-Curr",       "integer" ],
                32832 => [ "CW-Acct-Balance-Start-Amt",        "integer" ],
                32833 => [ "CW-Acct-Balance-Start-Dec",        "integer" ],
                32834 => [ "CW-Acct-Balance-Decr-Curr",        "integer" ],
                32835 => [ "CW-LRQ-Token",                     "string" ],
                32836 => [ "CW-ARQ-Token",                     "string" ],
                32837 => [ "CW-Token-Status",                  "integer" ],
                32838 => [ "CW-SS7-Destn-Ptcode-Type",         "integer" ],
                32839 => [ "CW-SS7-Destn-Ptcode-Address",      "integer" ],
                32840 => [ "CW-SS7-Orig-Ptcode-Type",          "integer" ],
                32841 => [ "CW-SS7-Orig-Ptcode-Address",       "integer" ],
                32842 => [ "CW-SS7-CIC",                       "integer" ],
                32843 => [ "CW-MGC-Id",                        "integer" ],
                32844 => [ "CW-MG-Id",                         "integer" ],
                32845 => [ "CW-Signaling-Protocol",            "integer" ],
                32846 => [ "CW-Protocol-Transport",            "integer" ],
                32847 => [ "CW-Local-Sig-Trans-Protocol",      "integer" ],
                32848 => [ "CW-Local-Sig-Trans-Port",          "integer" ],
                32849 => [ "CW-Local-Sig-Trans-IP",            "ipaddr" ],
                32850 => [ "CW-Local-Sig-Trans-DNS",           "string" ],
                32851 => [ "CW-Remote-Sig-Trans-Protocol",     "integer" ],
                32852 => [ "CW-Remote-Sig-Trans-Port",         "integer" ],
                32853 => [ "CW-Remote-Sig-Trans-IP",           "ipaddr" ],
                32854 => [ "CW-Remote-Sig-Trans-DNS",          "string" ],
                32855 => [ "CW-Local-MG-RTP-Protocol",         "integer" ],
                32856 => [ "CW-Local-MG-RTP-Port",             "integer" ],
                32857 => [ "CW-Local-MG-RTP-IP",               "ipaddr" ],
                32858 => [ "CW-Local-MG-RTP-DNS",              "string" ],
                32859 => [ "CW-Remote-MG-RTP-Protocol",        "integer" ],
                32860 => [ "CW-Remote-MG-RTP-Port",            "integer" ],
                32861 => [ "CW-Remote-MG-RTP-IP",              "ipaddr" ],
                32862 => [ "CW-Remote-MG-RTP-DNS",             "string" ],
                32863 => [ "CW-Call-Model",                    "integer" ],
                32864 => [ "CW-Call-Plan-Id",                  "integer" ],
                32865 => [ "CW-Trans-Cld-Party-E164-Type",     "integer" ],
                32866 => [ "CW-Trans-Cld-Party-E164-Num",      "string" ],
                32867 => [ "CW-OSP-Source-Device",             "string" ],
                36864 => [ "USR-PW_USR_IFilter_IP",            "string" ],
                36865 => [ "USR-PW_USR_IFilter_IPX",           "string" ],
                36866 => [ "USR-SAP-Filter-In",                "string" ],
                36867 => [ "USR-PW_USR_OFilter_IP",            "string" ],
                36868 => [ "USR-PW_USR_OFilter_IPX",           "string" ],
                36869 => [ "USR-PW_USR_OFilter_SAP",           "string" ],
                36870 => [ "USR-PW_VPN_ID",                    "string" ],
                36871 => [ "USR-PW_VPN_Name",                  "string" ],
                36872 => [ "USR-PW_VPN_Neighbor",              "ipaddr" ],
                36873 => [ "USR-PW_Framed_Routing_V2",         "string" ],
                36874 => [ "USR-PW_VPN_Gateway",               "string" ],
                36875 => [ "USR-PW_Tunnel_Authentication",     "string" ],
                36876 => [ "USR-PW_Index",                     "string" ],
                36877 => [ "USR-PW_Cutoff",                    "string" ],
                36878 => [ "USR-PW_Packet",                    "string" ],
                36879 => [ "USR-Primary_DNS_Server",           "ipaddr" ],
                36880 => [ "USR-Secondary_DNS_Server",         "ipaddr" ],
                36881 => [ "USR-Primary_NBNS_Server",          "ipaddr" ],
                36882 => [ "USR-Secondary_NBNS_Server",        "ipaddr" ],
                36883 => [ "USR-Syslog-Tap",                   "integer" ],
                36884 => [ "USR-MIC",                          "string" ],
                36887 => [ "USR-Log-Filter-Packets",           "string" ],
                36889 => [ "USR-Chassis-Call-Slot",            "integer" ],
                36890 => [ "USR-Chassis-Call-Span",            "integer" ],
                36891 => [ "USR-Chassis-Call-Channel",         "integer" ],
                36892 => [ "USR-Keypress-Timeout",             "integer" ],
                36893 => [ "USR-Unauthenticated-Time",         "integer" ],
                36894 => [ "USR-VPN-Encrypter",                "integer" ],
                36895 => [ "USR-VPN-GW-Location-Id",           "string" ],
                36896 => [ "USR-Re-Chap-Timeout",              "integer" ],
                36897 => [ "USR-CCP-Algorithm",                "integer" ],
                36898 => [ "USR-ACCM-Type",                    "integer" ],
                36899 => [ "USR-Connect-Speed",                "integer" ],
                36900 => [ "USR-Framed_IP_Address_Pool_Name",  "string" ],
                36901 => [ "USR-MP-EDO",                       "string" ],
                36902 => [ "USR-Local-Framed-IP-Addr",         "ipaddr" ],
                36903 => [ "USR-Framed-IPX-Route",             "ipaddr" ],
                36904 => [ "USR-MPIP-Tunnel-Originator",       "ipaddr" ],
                38912 => [ "USR-Bearer-Capabilities",          "integer" ],
                38913 => [ "USR-Speed-Of-Connection",          "integer" ],
                38914 => [ "USR-Max-Channels",                 "integer" ],
                38915 => [ "USR-Channel-Expansion",            "integer" ],
                38916 => [ "USR-Channel-Decrement",            "integer" ],
                38917 => [ "USR-Expansion-Algorithm",          "integer" ],
                38918 => [ "USR-Compression-Algorithm",        "integer" ],
                38919 => [ "USR-Receive-Acc-Map",              "integer" ],
                38920 => [ "USR-Transmit-Acc-Map",             "integer" ],
                38922 => [ "USR-Compression-Reset-Mode",       "integer" ],
                38923 => [ "USR-Min-Compression-Size",         "integer" ],
                38924 => [ "USR-IP",                           "integer" ],
                38925 => [ "USR-IPX",                          "integer" ],
                38926 => [ "USR-Filter-Zones",                 "integer" ],
                38927 => [ "USR-Appletalk",                    "integer" ],
                38928 => [ "USR-Bridging",                     "integer" ],
                38929 => [ "USR-Spoofing",                     "integer" ],
                38930 => [ "USR-Host-Type",                    "integer" ],
                38931 => [ "USR-Send-Name",                    "string" ],
                38932 => [ "USR-Send-Password",                "string" ],
                38933 => [ "USR-Start-Time",                   "integer" ],
                38934 => [ "USR-End-Time",                     "integer" ],
                38935 => [ "USR-Send-Script1",                 "string" ],
                38936 => [ "USR-Reply-Script1",                "string" ],
                38937 => [ "USR-Send-Script2",                 "string" ],
                38938 => [ "USR-Reply-Script2",                "string" ],
                38939 => [ "USR-Send-Script3",                 "string" ],
                38940 => [ "USR-Reply-Script3",                "string" ],
                38941 => [ "USR-Send-Script4",                 "string" ],
                38942 => [ "USR-Reply-Script4",                "string" ],
                38943 => [ "USR-Send-Script5",                 "string" ],
                38944 => [ "USR-Reply-Script5",                "string" ],
                38945 => [ "USR-Send-Script6",                 "string" ],
                38946 => [ "USR-Reply-Script6",                "string" ],
                38947 => [ "USR-Terminal-Type",                "string" ],
                38948 => [ "USR-Appletalk-Network-Range",      "integer" ],
                38949 => [ "USR-Local-IP-Address",             "string" ],
                38950 => [ "USR-Routing-Protocol",             "integer" ],
                38951 => [ "USR-Modem-Group",                  "integer" ],
                38952 => [ "USR-IPX-Routing",                  "integer" ],
                38953 => [ "USR-IPX-WAN",                      "integer" ],
                38954 => [ "USR-IP-RIP-Policies",              "integer" ],
                38955 => [ "USR-IP-RIP-Simple-Auth-Password",  "string" ],
                38956 => [ "USR-IP-RIP-Input-Filter",          "string" ],
                38957 => [ "USR-IP-Call-Input-Filter",         "string" ],
                38958 => [ "USR-IPX-RIP-Input-Filter",         "string" ],
                38959 => [ "USR-MP-MRRU",                      "integer" ],
                38960 => [ "USR-IPX-Call-Input-Filter",        "string" ],
                38961 => [ "USR-AT-Input-Filter",              "string" ],
                38962 => [ "USR-AT-RTMP-Input-Filter",         "string" ],
                38963 => [ "USR-AT-Zip-Input-Filter",          "string" ],
                38964 => [ "USR-AT-Call-Input-Filter",         "string" ],
                38965 => [ "USR-ET-Bridge-Input-Filter",       "string" ],
                38966 => [ "USR-IP-RIP-Output-Filter",         "string" ],
                38967 => [ "USR-IP-Call-Output-Filter",        "string" ],
                38968 => [ "USR-IPX-RIP-Output-Filter",        "string" ],
                38969 => [ "USR-IPX-Call-Output-Filter",       "string" ],
                38970 => [ "USR-AT-Output-Filter",             "string" ],
                38971 => [ "USR-AT-RTMP-Output-Filter",        "string" ],
                38972 => [ "USR-AT-Zip-Output-Filter",         "string" ],
                38973 => [ "USR-AT-Call-Output-Filter",        "string" ],
                38974 => [ "USR-ET-Bridge-Output-Filter",      "string" ],
                38975 => [ "USR-ET-Bridge-Call-Output-Filte",  "string" ],
                38976 => [ "USR-IP-Default-Route-Option",      "integer" ],
                38977 => [ "USR-MP-EDO-HIPER",                 "string" ],
                38978 => [ "USR-Modem-Training-Time",          "integer" ],
                38979 => [ "USR-Interface-Index",              "integer" ],
                38980 => [ "USR-Tunnel-Security",              "integer" ],
                38981 => [ "USR-Port-Tap",                     "integer" ],
                38982 => [ "USR-Port-Tap-Format",              "integer" ],
                38983 => [ "USR-Port-Tap-Output",              "integer" ],
                38984 => [ "USR-Port-Tap-Facility",            "integer" ],
                38985 => [ "USR-Port-Tap-Priority",            "integer" ],
                38986 => [ "USR-Port-Tap-Address",             "ipaddr" ],
                38987 => [ "USR-MobileIP-Home-Agent-Address",  "ipaddr" ],
                38988 => [ "USR-Tunneled-MLPP",                "integer" ],
                38989 => [ "USR-Multicast-Proxy",              "integer" ],
                38990 => [ "USR-Multicast-Receive",            "integer" ],
                38992 => [ "USR-Multicast-Forwarding",         "integer" ],
                38993 => [ "USR-IGMP-Query-Interval",          "integer" ],
                38994 => [ "USR-IGMP-Maximum-Response-Time",   "integer" ],
                38995 => [ "USR-IGMP-Robustness",              "integer" ],
                38996 => [ "USR-IGMP-Version",                 "integer" ],
                38997 => [ "USR-IGMP-Routing",                 "integer" ],
                38998 => [ "USR-VTS-Session-Key",              "string" ],
                38999 => [ "USR-Orig-NAS-Type",                "string" ],
                39000 => [ "USR-Call-Arrival-Time",            "integer" ],
                39001 => [ "USR-Call-End-Time",                "integer" ],
                39008 => [ "USR-Rad-Multicast-Routing-Ttl",    "integer" ],
                39009 => [ "USR-Rad-Multicast-Routing-RtLim",  "integer" ],
                39010 => [ "USR-Rad-Multicast-Routing-Proto",  "integer" ],
                39011 => [ "USR-Rad-Multicast-Routing-Bound",  "string" ],
                39012 => [ "USR-Rad-Dvmrp-Metric",             "integer" ],
                39013 => [ "USR-Chat-Script-Name",             "string" ],
                39014 => [ "USR-CUSR-hat-Script-Rules",        "string" ],
                39015 => [ "USR-Rad-Location-Type",            "integer" ],
                39016 => [ "USR-Tunnel-Switch-Endpoint",       "string" ],
                39017 => [ "USR-OSPF-Addressless-Index",       "integer" ],
                39018 => [ "USR-Callback-Type",                "integer" ],
                39019 => [ "USR-Tunnel-Auth-Hostname",         "string" ],
                39020 => [ "USR-Acct-Reason-Code",             "integer" ],
                39021 => [ "USR-QoS-Queuing-Mehtod",           "integer" ],
                39022 => [ "USR-PQ-Default-Priority",          "integer" ],
                39024 => [ "USR-IP-SAA-Filter",                "integer" ],
                39025 => [ "USR-FQ-Default-Priority",          "integer" ],
                39026 => [ "USR-IPP-Enable",                   "integer" ],
                39027 => [ "USR-Pre-Shared-MN-Key",            "string" ],
                39028 => [ "USR-MIP-NAI",                      "integer" ],
                39029 => [ "USR-DNIS-ReAuthentication",        "integer" ],
                39030 => [ "USR-Agent",                        "integer" ],
                39031 => [ "USR-PQ-Parameters",                "integer" ],
                39032 => [ "USR-Dvmrp-Prune-Lifetime",         "integer" ],
                39033 => [ "USR-Special-Xon-Xoff-Flow",        "integer" ],
                39034 => [ "USR-Dvmrp-Advertised-Metric",      "integer" ],
                39035 => [ "USR-Dvmrp-Retransmit-Prunes",      "integer" ],
                39036 => [ "USR-Dvmrp-Non-Pruners",            "integer" ],
                39037 => [ "USR-Dvmrp-Route-Transit",          "integer" ],
                39038 => [ "USR-Dvmrp-Input-Filter",           "string" ],
                39040 => [ "USR-Dvmrp-Output-Filter",          "string" ],
                39041 => [ "USR-Policy-Access",                "integer" ],
                39042 => [ "USR-Policy-Configuration",         "integer" ],
                39043 => [ "USR-Policy-Filename",              "string" ],
                39044 => [ "USR-Policy-Type",                  "integer" ],
                39045 => [ "USR-Mobile-Session-ID",            "integer" ],
                39046 => [ "USR-Mobile-Accounting-Type",       "integer" ],
                39047 => [ "USR-Mobile-Service-Option",        "integer" ],
                39048 => [ "USR-Wallclock-Timestamp",          "integer" ],
                39049 => [ "USR-Supports-Tags",                "integer" ],
                39050 => [ "USR-Dvmrp-Initial-Flooding",       "integer" ],
                39051 => [ "USR-HARC-Disconnect-Code",         "integer" ],
                39052 => [ "USR-Telnet-Options",               "integer" ],
                39053 => [ "USR-CDMA-PktData-Network-ID",      "integer" ],
                39054 => [ "USR-Auth-Next-Server-Address",     "ipaddr" ],
                39055 => [ "USR-User-PPP-AODI-Type",           "integer" ],
                39056 => [ "USR-MLPPP-Fragmentation-Threshld", "integer" ],
                39057 => [ "USR-Unnumbered-Local-IP-Address",  "ipaddr" ],
                39058 => [ "USR-Traffic-Threshold",            "integer" ],
                39059 => [ "USR-Keep-Alive-Interval",          "integer" ],
                39060 => [ "USR-Tunnel-Challenge-Outgoing",    "integer" ],
                39061 => [ "USR-X25-Trunk-Profile",            "string" ],
                39062 => [ "USR-X25-Acct-Input-Segment-Count", "integer" ],
                39063 => [ "USR-X25-Acct-Output-Segment-Coun", "integer" ],
                39064 => [ "USR-X25-Acct-Segment-Size",        "integer" ],
                39065 => [ "USR-X25-Acct-Termination-Code",    "integer" ],
                39066 => [ "USR-X25-SVC-Logical-Channel-Numb", "integer" ],
                39067 => [ "USR-Nailed-B-Channel-Indicator",   "integer" ],
                39068 => [ "USR-X25-SVC-Call-Attributes",      "integer" ],
                39069 => [ "USR-Init-Reg-Server-Addr",         "ipaddr" ],
                39070 => [ "USR-Re-Reg-Server-Addr",           "ipaddr" ],
                39071 => [ "USR-Bytes-TX-Remain",              "integer" ],
                39072 => [ "USR-Bytes-RX-Remain",              "integer" ],
                39073 => [ "USR-Session-Time-Remain",          "integer" ],
                39074 => [ "USR-Pre-Paid-Enabled",             "integer" ],
                39075 => [ "USR-Reg-Server-Prov-Timeout",      "integer" ],
                39076 => [ "USR-Redirect",                     "integer" ],
                39077 => [ "USR-VLAN-Tag",                     "integer" ],
                39078 => [ "USR-Rad-IP-Pool-Definition",       "string" ],
                39079 => [ "USR-Rad-NMC-Call-Progress-Status", "integer" ],
                39080 => [ "USR-Rad-NMC-Blocks_RX",            "integer" ],
                48719 => [ "USR-IDS0-Call-Type",               "integer" ],
                48720 => [ "USR-Call-Terminate-in-GMT",        "date" ],
                48721 => [ "USR-Call-Connect-in-GMT",          "date" ],
                48722 => [ "USR-Call-Arrival-in-GMT",          "date" ],
                48733 => [ "USR-Channel-Connected-To",         "integer" ],
                48734 => [ "USR-Slot-Connected-To",            "integer" ],
                48735 => [ "USR-Device-Connected-To",          "integer" ],
                48736 => [ "USR-NFAS-ID",                      "integer" ],
                48737 => [ "USR-Q931-Call-Reference-Value",    "integer" ],
                48738 => [ "USR-Call-Event-Code",              "integer" ],
                48739 => [ "USR-DS0",                          "integer" ],
                48740 => [ "USR-DS0s",                         "string" ],
                48742 => [ "USR-Gateway-IP-Address",           "ipaddr" ],
                48759 => [ "USR-Physical-State",               "integer" ],
                48765 => [ "USR-Call-Reference-Number",        "integer" ],
                48772 => [ "USR-Chassis-Temp-Threshold",       "integer" ],
                48773 => [ "USR-Card-Type",                    "integer" ],
                48862 => [ "USR-Security-Login-Limit",         "integer" ],
                48890 => [ "USR-Security-Resp-Limit",          "integer" ],
                48916 => [ "USR-Packet-Bus-Session",           "integer" ],
                48919 => [ "USR-DTE-Ring-No-Answer-Limit",     "integer" ],
                48940 => [ "USR-Final-Rx-Link-Data-Rate",      "integer" ],
                48941 => [ "USR-Initial-Rx-Link-Data-Rate",    "integer" ],
                48943 => [ "USR-Event-Date-Time",              "date" ],
                48945 => [ "USR-Chassis-Temperature",          "integer" ],
                48946 => [ "USR-Actual-Voltage",               "integer" ],
                48947 => [ "USR-Expected-Voltage",             "integer" ],
                48948 => [ "USR-Power-Supply-Number",          "integer" ],
                48952 => [ "USR-Channel",                      "integer" ],
                48953 => [ "USR-Chassis-Slot",                 "integer" ],
                49086 => [ "USR-Event-Id",                     "integer" ],
                49126 => [ "USR-Number-of-Rings-Limit",        "integer" ],
                49127 => [ "USR-Connect-Time-Limit",           "integer" ],
                49142 => [ "USR-Call-End-Date-Time",           "date" ],
                49143 => [ "USR-Call-Start-Date-Time",         "date" ],
                61440 => [ "USR-Server-Time",                  "date" ],
                61441 => [ "USR-Request-Type",                 "integer" ],
                61442 => [ "USR-NAS-Type",                     "integer" ],
                61443 => [ "USR-Auth-Mode",                    "integer" ],
            },
            529 => {
                2   => [ "Ascend-Max-Shared-Users",        "integer" ],
                7   => [ "Ascend-UU-Info",                 "string" ],
                9   => [ "Ascend-CIR-Timer",               "integer" ],
                10  => [ "Ascend-FR-08-Mode",              "integer" ],
                11  => [ "Ascend-Destination-Nas-Port",    "integer" ],
                12  => [ "Ascend-FR-SVC-Addr",             "string" ],
                13  => [ "Ascend-NAS-Port-Format",         "integer" ],
                14  => [ "Ascend-ATM-Fault-Management",    "integer" ],
                15  => [ "Ascend-ATM-Loopback-Cell-Loss",  "integer" ],
                16  => [ "Ascend-Ckt-Type",                "integer" ],
                17  => [ "Ascend-SVC-Enabled",             "integer" ],
                18  => [ "Ascend-Session-Type",            "integer" ],
                19  => [ "Ascend-H323-Gatekeeper",         "ipaddr" ],
                20  => [ "Ascend-Global-Call-Id",          "string" ],
                21  => [ "Ascend-H323-Conference-Id",      "integer" ],
                22  => [ "Ascend-H323-Fegw-Address",       "ipaddr" ],
                23  => [ "Ascend-H323-Dialed-Time",        "integer" ],
                24  => [ "Ascend-Dialed-Number",           "string" ],
                25  => [ "Ascend-Inter-Arrival-Jitter",    "integer" ],
                26  => [ "Ascend-Dropped-Octets",          "integer" ],
                27  => [ "Ascend-Dropped-Packets",         "integer" ],
                28  => [ "Ascend-Auth-Delay",              "integer" ],
                29  => [ "Ascend-X25-Pad-X3-Profile",      "integer" ],
                30  => [ "Ascend-X25-Pad-X3-Parameters",   "string" ],
                31  => [ "Ascend-Tunnel-VRouter-Name",     "string" ],
                32  => [ "Ascend-X25-Reverse-Charging",    "integer" ],
                33  => [ "Ascend-X25-Nui-Prompt",          "string" ],
                34  => [ "Ascend-X25-Nui-Password-Prompt", "string" ],
                35  => [ "Ascend-X25-Cug",                 "string" ],
                36  => [ "Ascend-X25-Pad-Alias-1",         "string" ],
                37  => [ "Ascend-X25-Pad-Alias-2",         "string" ],
                38  => [ "Ascend-X25-Pad-Alias-3",         "string" ],
                39  => [ "Ascend-X25-X121-Address",        "string" ],
                40  => [ "Ascend-X25-Nui",                 "string" ],
                41  => [ "Ascend-X25-Rpoa",                "string" ],
                42  => [ "Ascend-X25-Pad-Prompt",          "string" ],
                43  => [ "Ascend-X25-Pad-Banner",          "string" ],
                44  => [ "Ascend-X25-Profile-Name",        "string" ],
                45  => [ "Ascend-Recv-Name",               "string" ],
                46  => [ "Ascend-Bi-Directional-Auth",     "integer" ],
                47  => [ "Ascend-MTU",                     "integer" ],
                48  => [ "Ascend-Call-Direction",          "integer" ],
                49  => [ "Ascend-Service-Type",            "integer" ],
                50  => [ "Ascend-Filter-Required",         "integer" ],
                51  => [ "Ascend-Traffic-Shaper",          "integer" ],
                52  => [ "Ascend-Access-Intercept-LEA",    "string" ],
                53  => [ "Ascend-Access-Intercept-Log",    "string" ],
                54  => [ "Ascend-Private-Route-Table-ID",  "string" ],
                55  => [ "Ascend-Private-Route-Required",  "integer" ],
                56  => [ "Ascend-Cache-Refresh",           "integer" ],
                57  => [ "Ascend-Cache-Time",              "integer" ],
                58  => [ "Ascend-Egress-Enabled",          "integer" ],
                59  => [ "Ascend-QOS-Upstream",            "string" ],
                60  => [ "Ascend-QOS-Downstream",          "string" ],
                61  => [ "Ascend-ATM-Connect-Vpi",         "integer" ],
                62  => [ "Ascend-ATM-Connect-Vci",         "integer" ],
                63  => [ "Ascend-ATM-Connect-Group",       "integer" ],
                64  => [ "Ascend-ATM-Group",               "integer" ],
                65  => [ "Ascend-IPX-Header-Compression",  "integer" ],
                66  => [ "Ascend-Calling-Id-Type-Of-Num",  "integer" ],
                67  => [ "Ascend-Calling-Id-Number-Plan",  "integer" ],
                68  => [ "Ascend-Calling-Id-Presentatn",   "integer" ],
                69  => [ "Ascend-Calling-Id-Screening",    "integer" ],
                70  => [ "Ascend-BIR-Enable",              "integer" ],
                71  => [ "Ascend-BIR-Proxy",               "integer" ],
                72  => [ "Ascend-BIR-Bridge-Group",        "integer" ],
                73  => [ "Ascend-IPSEC-Profile",           "string" ],
                74  => [ "Ascend-PPPoE-Enable",            "integer" ],
                75  => [ "Ascend-Bridge-Non-PPPoE",        "integer" ],
                76  => [ "Ascend-ATM-Direct",              "integer" ],
                77  => [ "Ascend-ATM-Direct-Profile",      "string" ],
                78  => [ "Ascend-Client-Primary-WINS",     "ipaddr" ],
                79  => [ "Ascend-Client-Secondary-WINS",   "ipaddr" ],
                80  => [ "Ascend-Client-Assign-WINS",      "integer" ],
                81  => [ "Ascend-Auth-Type",               "integer" ],
                82  => [ "Ascend-Port-Redir-Protocol",     "integer" ],
                83  => [ "Ascend-Port-Redir-Portnum",      "integer" ],
                84  => [ "Ascend-Port-Redir-Server",       "ipaddr" ],
                85  => [ "Ascend-IP-Pool-Chaining",        "integer" ],
                86  => [ "Ascend-Owner-IP-Addr",           "ipaddr" ],
                87  => [ "Ascend-IP-TOS",                  "integer" ],
                88  => [ "Ascend-IP-TOS-Precedence",       "integer" ],
                89  => [ "Ascend-IP-TOS-Apply-To",         "integer" ],
                90  => [ "Ascend-Filter",                  "string" ],
                91  => [ "Ascend-Telnet-Profile",          "string" ],
                92  => [ "Ascend-Dsl-Rate-Type",           "integer" ],
                93  => [ "Ascend-Redirect-Number",         "string" ],
                94  => [ "Ascend-ATM-Vpi",                 "integer" ],
                95  => [ "Ascend-ATM-Vci",                 "integer" ],
                96  => [ "Ascend-Source-IP-Check",         "integer" ],
                97  => [ "Ascend-Dsl-Rate-Mode",           "integer" ],
                98  => [ "Ascend-Dsl-Upstream-Limit",      "integer" ],
                99  => [ "Ascend-Dsl-Downstream-Limit",    "integer" ],
                100 => [ "Ascend-Dsl-CIR-Recv-Limit",      "integer" ],
                101 => [ "Ascend-Dsl-CIR-Xmit-Limit",      "integer" ],
                102 => [ "Ascend-VRouter-Name",            "string" ],
                103 => [ "Ascend-Source-Auth",             "string" ],
                104 => [ "Ascend-Private-Route",           "string" ],
                105 => [ "Ascend-Numbering-Plan-ID",       "integer" ],
                106 => [ "Ascend-FR-Link-Status-DLCI",     "integer" ],
                107 => [ "Ascend-Calling-Subaddress",      "string" ],
                108 => [ "Ascend-Callback-Delay",          "integer" ],
                109 => [ "Ascend-Endpoint-Disc",           "string" ],
                110 => [ "Ascend-Remote-FW",               "string" ],
                111 => [ "Ascend-Multicast-GLeave-Delay",  "integer" ],
                112 => [ "Ascend-CBCP-Enable",             "integer" ],
                113 => [ "Ascend-CBCP-Mode",               "integer" ],
                114 => [ "Ascend-CBCP-Delay",              "integer" ],
                115 => [ "Ascend-CBCP-Trunk-Group",        "integer" ],
                116 => [ "Ascend-Appletalk-Route",         "string" ],
                117 => [ "Ascend-Appletalk-Peer-Mode",     "integer" ],
                118 => [ "Ascend-Route-Appletalk",         "integer" ],
                119 => [ "Ascend-FCP-Parameter",           "string" ],
                120 => [ "Ascend-Modem-PortNo",            "integer" ],
                121 => [ "Ascend-Modem-SlotNo",            "integer" ],
                122 => [ "Ascend-Modem-ShelfNo",           "integer" ],
                123 => [ "Ascend-Call-Attempt-Limit",      "integer" ],
                124 => [ "Ascend-Call-Block-Duration",     "integer" ],
                125 => [ "Ascend-Maximum-Call-Duration",   "integer" ],
                126 => [ "Ascend-Temporary-Rtes",          "integer" ],
                127 => [ "Ascend-Tunneling-Protocol",      "integer" ],
                128 => [ "Ascend-Shared-Profile-Enable",   "integer" ],
                129 => [ "Ascend-Primary-Home-Agent",      "string" ],
                130 => [ "Ascend-Secondary-Home-Agent",    "string" ],
                131 => [ "Ascend-Dialout-Allowed",         "integer" ],
                132 => [ "Ascend-Client-Gateway",          "ipaddr" ],
                133 => [ "Ascend-BACP-Enable",             "integer" ],
                134 => [ "Ascend-DHCP-Maximum-Leases",     "integer" ],
                135 => [ "Ascend-Client-Primary-DNS",      "ipaddr" ],
                136 => [ "Ascend-Client-Secondary-DNS",    "ipaddr" ],
                137 => [ "Ascend-Client-Assign-DNS",       "integer" ],
                138 => [ "Ascend-User-Acct-Type",          "integer" ],
                139 => [ "Ascend-User-Acct-Host",          "ipaddr" ],
                140 => [ "Ascend-User-Acct-Port",          "integer" ],
                141 => [ "Ascend-User-Acct-Key",           "string" ],
                142 => [ "Ascend-User-Acct-Base",          "integer" ],
                143 => [ "Ascend-User-Acct-Time",          "integer" ],
                144 => [ "Ascend-Assign-IP-Client",        "ipaddr" ],
                145 => [ "Ascend-Assign-IP-Server",        "ipaddr" ],
                146 => [ "Ascend-Assign-IP-Global-Pool",   "string" ],
                147 => [ "Ascend-DHCP-Reply",              "integer" ],
                148 => [ "Ascend-DHCP-Pool-Number",        "integer" ],
                149 => [ "Ascend-Expect-Callback",         "integer" ],
                150 => [ "Ascend-Event-Type",              "integer" ],
                151 => [ "Ascend-Session-Svr-Key",         "string" ],
                152 => [ "Ascend-Multicast-Rate-Limit",    "integer" ],
                153 => [ "Ascend-IF-Netmask",              "ipaddr" ],
                154 => [ "Ascend-Remote-Addr",             "ipaddr" ],
                155 => [ "Ascend-Multicast-Client",        "integer" ],
                156 => [ "Ascend-FR-Circuit-Name",         "string" ],
                157 => [ "Ascend-FR-LinkUp",               "integer" ],
                158 => [ "Ascend-FR-Nailed-Grp",           "integer" ],
                159 => [ "Ascend-FR-Type",                 "integer" ],
                160 => [ "Ascend-FR-Link-Mgt",             "integer" ],
                161 => [ "Ascend-FR-N391",                 "integer" ],
                162 => [ "Ascend-FR-DCE-N392",             "integer" ],
                163 => [ "Ascend-FR-DTE-N392",             "integer" ],
                164 => [ "Ascend-FR-DCE-N393",             "integer" ],
                165 => [ "Ascend-FR-DTE-N393",             "integer" ],
                166 => [ "Ascend-FR-T391",                 "integer" ],
                167 => [ "Ascend-FR-T392",                 "integer" ],
                168 => [ "Ascend-Bridge-Address",          "string" ],
                169 => [ "Ascend-TS-Idle-Limit",           "integer" ],
                170 => [ "Ascend-TS-Idle-Mode",            "integer" ],
                171 => [ "Ascend-DBA-Monitor",             "integer" ],
                172 => [ "Ascend-Base-Channel-Count",      "integer" ],
                173 => [ "Ascend-Minimum-Channels",        "integer" ],
                174 => [ "Ascend-IPX-Route",               "string" ],
                175 => [ "Ascend-FT1-Caller",              "integer" ],
                176 => [ "Ascend-Backup",                  "string" ],
                177 => [ "Ascend-Call-Type",               "integer" ],
                178 => [ "Ascend-Group",                   "string" ],
                179 => [ "Ascend-FR-DLCI",                 "integer" ],
                180 => [ "Ascend-FR-Profile-Name",         "string" ],
                181 => [ "Ascend-Ara-PW",                  "string" ],
                182 => [ "Ascend-IPX-Node-Addr",           "string" ],
                183 => [ "Ascend-Home-Agent-IP-Addr",      "ipaddr" ],
                184 => [ "Ascend-Home-Agent-Password",     "string" ],
                185 => [ "Ascend-Home-Network-Name",       "string" ],
                186 => [ "Ascend-Home-Agent-UDP-Port",     "integer" ],
                187 => [ "Ascend-Multilink-ID",            "integer" ],
                188 => [ "Ascend-Num-In-Multilink",        "integer" ],
                189 => [ "Ascend-First-Dest",              "ipaddr" ],
                190 => [ "Ascend-Pre-Input-Octets",        "integer" ],
                191 => [ "Ascend-Pre-Output-Octets",       "integer" ],
                192 => [ "Ascend-Pre-Input-Packets",       "integer" ],
                193 => [ "Ascend-Pre-Output-Packets",      "integer" ],
                194 => [ "Ascend-Maximum-Time",            "integer" ],
                195 => [ "Ascend-Disconnect-Cause",        "integer" ],
                196 => [ "Ascend-Connect-Progress",        "integer" ],
                197 => [ "Ascend-Data-Rate",               "integer" ],
                198 => [ "Ascend-PreSession-Time",         "integer" ],
                199 => [ "Ascend-Token-Idle",              "integer" ],
                200 => [ "Ascend-Token-Immediate",         "integer" ],
                201 => [ "Ascend-Require-Auth",            "integer" ],
                202 => [ "Ascend-Number-Sessions",         "string" ],
                203 => [ "Ascend-Authen-Alias",            "string" ],
                204 => [ "Ascend-Token-Expiry",            "integer" ],
                205 => [ "Ascend-Menu-Selector",           "string" ],
                206 => [ "Ascend-Menu-Item",               "string" ],
                207 => [ "Ascend-PW-Warntime",             "integer" ],
                208 => [ "Ascend-PW-Lifetime",             "integer" ],
                209 => [ "Ascend-IP-Direct",               "ipaddr" ],
                210 => [ "Ascend-PPP-VJ-Slot-Comp",        "integer" ],
                211 => [ "Ascend-PPP-VJ-1172",             "integer" ],
                212 => [ "Ascend-PPP-Async-Map",           "integer" ],
                213 => [ "Ascend-Third-Prompt",            "string" ],
                214 => [ "Ascend-Send-Secret",             "string" ],
                215 => [ "Ascend-Receive-Secret",          "string" ],
                216 => [ "Ascend-IPX-Peer-Mode",           "integer" ],
                217 => [ "Ascend-IP-Pool-Definition",      "string" ],
                218 => [ "Ascend-Assign-IP-Pool",          "integer" ],
                219 => [ "Ascend-FR-Direct",               "integer" ],
                220 => [ "Ascend-FR-Direct-Profile",       "string" ],
                221 => [ "Ascend-FR-Direct-DLCI",          "integer" ],
                222 => [ "Ascend-Handle-IPX",              "integer" ],
                223 => [ "Ascend-Netware-timeout",         "integer" ],
                224 => [ "Ascend-IPX-Alias",               "integer" ],
                225 => [ "Ascend-Metric",                  "integer" ],
                226 => [ "Ascend-PRI-Number-Type",         "integer" ],
                227 => [ "Ascend-Dial-Number",             "string" ],
                228 => [ "Ascend-Route-IP",                "integer" ],
                229 => [ "Ascend-Route-IPX",               "integer" ],
                230 => [ "Ascend-Bridge",                  "integer" ],
                231 => [ "Ascend-Send-Auth",               "integer" ],
                232 => [ "Ascend-Send-Passwd",             "string" ],
                233 => [ "Ascend-Link-Compression",        "integer" ],
                234 => [ "Ascend-Target-Util",             "integer" ],
                235 => [ "Ascend-Maximum-Channels",        "integer" ],
                236 => [ "Ascend-Inc-Channel-Count",       "integer" ],
                237 => [ "Ascend-Dec-Channel-Count",       "integer" ],
                238 => [ "Ascend-Seconds-Of-History",      "integer" ],
                239 => [ "Ascend-History-Weigh-Type",      "integer" ],
                240 => [ "Ascend-Add-Seconds",             "integer" ],
                241 => [ "Ascend-Remove-Seconds",          "integer" ],
                242 => [ "Ascend-Data-Filter",             "abinary" ],
                243 => [ "Ascend-Call-Filter",             "abinary" ],
                244 => [ "Ascend-Idle-Limit",              "integer" ],
                245 => [ "Ascend-Preempt-Limit",           "integer" ],
                246 => [ "Ascend-Callback",                "integer" ],
                247 => [ "Ascend-Data-Svc",                "integer" ],
                248 => [ "Ascend-Force-56",                "integer" ],
                249 => [ "Ascend-Billing-Number",          "string" ],
                250 => [ "Ascend-Call-By-Call",            "integer" ],
                251 => [ "Ascend-Transit-Number",          "string" ],
                252 => [ "Ascend-Host-Info",               "string" ],
                253 => [ "Ascend-PPP-Address",             "ipaddr" ],
                254 => [ "Ascend-MPP-Idle-Percent",        "integer" ],
                255 => [ "Ascend-Xmit-Rate",               "integer" ],
            },
            562 => {
                110 => [ "Nortel-User-Role",                     "string" ],
                166 => [ "Nortel-Privilege-Level",               "integer" ],
                170 => [ "Fabric-Attach-VLAN-Create",            "integer" ],
                171 => [ "Fabric-Attach-VLAN-ISID",              "string" ],
                172 => [ "Fabric-Attach-VLAN-PVID",              "integer" ],
                180 => [ "Fabric-Attach-Switch-Mode",            "integer" ],
                181 => [ "Fabric-Attach-Client-Id",              "string" ],
                182 => [ "Fabric-Attach-Client-Type",            "string" ],
                183 => [ "Fabric-Attach-Client-PSK",             "integer" ],
                184 => [ "Fabric-Attach-Client-Trust",           "integer" ],
                185 => [ "Fabric-Attach-Client-Trusted-Binding", "string" ],
                186 => [ "Fabric-Attach-Service-Request",        "string" ],
                200 => [ "Passport-Command-Scope",               "integer" ],
                201 => [ "Passport-Command-Impact",              "integer" ],
                202 => [ "Passport-Customer-Identifier",         "integer" ],
                203 => [ "Passport-Allowed-Access",              "integer" ],
                204 => [ "Passport-AllowedOut-Access",           "integer" ],
                205 => [ "Passport-Login-Directory",             "string" ],
                206 => [ "Passport-Timeout-Protocol",            "integer" ],
                207 => [ "Passport-Role",                        "string" ],
            },
            594 => { 1 => [ "SID-Auth", "string" ] },
            637 => {
                1536 => [ "A-AL-Maintenance",           "integer" ],
                1537 => [ "A-AL-Provisioning",          "integer" ],
                1538 => [ "A-AL-TL1-Security",          "integer" ],
                1539 => [ "A-AL-Test",                  "integer" ],
                1792 => [ "A-ESAM-VRF-Name",            "string" ],
                1793 => [ "A-ESAM-Vlan-Id",             "integer" ],
                1794 => [ "A-ESAM-QOS-Profile-Name",    "string" ],
                1795 => [ "A-ESAM-QOS-Params",          "string" ],
                1796 => [ "A-ESAM-Termination-Cause",   "integer" ],
                1797 => [ "A-AL-MAINTENANCE-BACKWARD",  "integer" ],
                1798 => [ "A-AL-PROVISIONING-BACKWARD", "integer" ],
                1799 => [ "A-AL-TL1-SECURITY-BACKWARD", "integer" ],
                1800 => [ "A-AL-TEST-BACKWARD",         "integer" ],
                1801 => [ "A-AL-AAA",                   "integer" ],
                1802 => [ "A-AL-ATM",                   "integer" ],
                1803 => [ "A-AL-Alarm",                 "integer" ],
                1804 => [ "A-AL-DHCP",                  "integer" ],
                1805 => [ "A-AL-EQP",                   "integer" ],
                1806 => [ "A-AL-IGMP",                  "integer" ],
                1807 => [ "A-AL-CPEProxy",              "integer" ],
                1808 => [ "A-AL-IP",                    "integer" ],
                1809 => [ "A-AL-PPPoE",                 "integer" ],
                1810 => [ "A-AL-QoS",                   "integer" ],
                1811 => [ "A-AL-SWMgt",                 "integer" ],
                1812 => [ "A-AL-Transport",             "integer" ],
                1813 => [ "A-AL-VLAN",                  "integer" ],
                1814 => [ "A-AL-XDSL",                  "integer" ],
                1815 => [ "A-AL-Security",              "integer" ],
                1816 => [ "A-AL-Cluster",               "integer" ],
                1817 => [ "A-AL-Prompt",                "string" ],
                1818 => [ "A-AL-Pwd-Timeout",           "integer" ],
                1819 => [ "A-AL-Description",           "string" ],
                1820 => [ "A-AL-SLOT-NUMBERING",        "integer" ],
            },
            664 => {
                100 => [ "Adtran-AP-Name",     "string" ],
                101 => [ "Adtran-AP-IP",       "ipaddr" ],
                102 => [ "Adtran-AP-Template", "string" ],
                103 => [ "Adtran-SSID",        "string" ],
                104 => [ "Adtran-Role",        "string" ],
            },
            674 => {
                1 => [ "DellEMC-AVpair",     "string" ],
                2 => [ "DellEMC-Group-Name", "string" ],
            },
            762 => {
                151 => [ "KarlNet-TurboCell-Name",    "string" ],
                152 => [ "KarlNet-TurboCell-TxRate",  "integer" ],
                153 => [ "KarlNet-TurboCell-OpState", "integer" ],
                154 => [ "KarlNet-TurboCell-OpMode",  "integer" ],
            },
            800 => {
                1   => [ "Xylan-Auth-Group",           "integer" ],
                2   => [ "Xylan-Slot-Port",            "string" ],
                3   => [ "Xylan-Time-of-Day",          "string" ],
                4   => [ "Xylan-Client-IP-Addr",       "ipaddr" ],
                5   => [ "Xylan-Group-Desc",           "string" ],
                6   => [ "Xylan-Port-Desc",            "string" ],
                7   => [ "Xylan-Profil-Numb",          "integer" ],
                8   => [ "Xylan-Auth-Group-Protocol",  "string" ],
                9   => [ "Xylan-Asa-Access",           "string" ],
                10  => [ "Xylan-End-User-Profile",     "integer" ],
                12  => [ "Xylan-Primary-Home-Agent",   "string" ],
                13  => [ "Xylan-Secondary-Home-Agent", "string" ],
                14  => [ "Xylan-Home-Agent-Password",  "string" ],
                15  => [ "Xylan-Home-Network-Name",    "string" ],
                16  => [ "Xylan-Access-Priv",          "integer" ],
                20  => [ "Xylan-Nms-Group",            "string" ],
                21  => [ "Xylan-Nms-First-Name",       "string" ],
                22  => [ "Xylan-Nms-Last-Name",        "string" ],
                23  => [ "Xylan-Nms-Description",      "string" ],
                33  => [ "Xylan-Acce-Priv-R1",         "octets" ],
                34  => [ "Xylan-Acce-Priv-R2",         "octets" ],
                35  => [ "Xylan-Acce-Priv-W1",         "octets" ],
                36  => [ "Xylan-Acce-Priv-W2",         "octets" ],
                37  => [ "Xylan-Acce-Priv-G1",         "octets" ],
                38  => [ "Xylan-Acce-Priv-G2",         "octets" ],
                39  => [ "Xylan-Acce-Priv-F-R1",       "octets" ],
                40  => [ "Xylan-Acce-Priv-F-R2",       "octets" ],
                41  => [ "Xylan-Acce-Priv-F-W1",       "octets" ],
                42  => [ "Xylan-Acce-Priv-F-W2",       "octets" ],
                100 => [ "Xylan-Policy-List",          "string" ],
                101 => [ "Xylan-Redirect-Url",         "string" ],
                152 => [ "Xylan-Device-Name",          "string" ],
                153 => [ "Xylan-Device-Location",      "string" ],
            },
            831 => {
                1   => [ "ALU-AAA-Access-Rule",                "string" ],
                2   => [ "ALU-AAA-AV-Pair",                    "string" ],
                3   => [ "ALU-AAA-GSM-Triplets-Needed",        "integer" ],
                4   => [ "ALU-AAA-GSM-Triplet",                "octets" ],
                5   => [ "ALU-AAA-AKA-Quintets-Needed",        "integer" ],
                6   => [ "ALU-AAA-AKA-Quintet",                "octets" ],
                7   => [ "ALU-AAA-AKA-RAND",                   "octets" ],
                8   => [ "ALU-AAA-AKA-AUTS",                   "octets" ],
                9   => [ "ALU-AAA-Service-Profile",            "string" ],
                10  => [ "ALU-AAA-Lawful-Intercept-Status",    "byte" ],
                11  => [ "ALU-AAA-DF-CC-Address",              "ipaddr" ],
                12  => [ "ALU-AAA-DF-CC-Port",                 "short" ],
                13  => [ "ALU-AAA-Client-Program",             "string" ],
                14  => [ "ALU-AAA-Client-Error-Action",        "integer" ],
                15  => [ "ALU-AAA-Client-OS",                  "string" ],
                16  => [ "ALU-AAA-Client-Version",             "string" ],
                17  => [ "ALU-AAA-Nonce",                      "octets" ],
                18  => [ "ALU-AAA-Femto-Public-Key-Hash",      "octets" ],
                19  => [ "ALU-AAA-Femto-Associated-User-Name", "string" ],
                100 => [ "ALU-AAA-String-0",                   "string" ],
                101 => [ "ALU-AAA-String-1",                   "string" ],
                102 => [ "ALU-AAA-String-2",                   "string" ],
                103 => [ "ALU-AAA-String-3",                   "string" ],
                104 => [ "ALU-AAA-Integer-0",                  "integer" ],
                105 => [ "ALU-AAA-Integer-1",                  "integer" ],
                106 => [ "ALU-AAA-Integer-2",                  "integer" ],
                107 => [ "ALU-AAA-Integer-3",                  "integer" ],
                112 => [ "ALU-AAA-Value-0",                    "octets" ],
                113 => [ "ALU-AAA-Value-1",                    "octets" ],
                114 => [ "ALU-AAA-Value-2",                    "octets" ],
                115 => [ "ALU-AAA-Value-3",                    "octets" ],
                116 => [ "ALU-AAA-Key-0",                      "octets" ],
                117 => [ "ALU-AAA-Key-1",                      "octets" ],
                118 => [ "ALU-AAA-Key-2",                      "octets" ],
                119 => [ "ALU-AAA-Key-3",                      "octets" ],
                120 => [ "ALU-AAA-Opaque-0",                   "octets" ],
                121 => [ "ALU-AAA-Opaque-1",                   "octets" ],
                122 => [ "ALU-AAA-Opaque-2",                   "octets" ],
                123 => [ "ALU-AAA-Opaque-3",                   "octets" ],
                124 => [ "ALU-AAA-Eval-0",                     "string" ],
                125 => [ "ALU-AAA-Eval-1",                     "string" ],
                126 => [ "ALU-AAA-Eval-2",                     "string" ],
                127 => [ "ALU-AAA-Eval-3",                     "string" ],
                128 => [ "ALU-AAA-Exec-0",                     "string" ],
                129 => [ "ALU-AAA-Exec-1",                     "string" ],
                130 => [ "ALU-AAA-Exec-2",                     "string" ],
                131 => [ "ALU-AAA-Exec-3",                     "string" ],
                199 => [ "ALU-AAA-Original-Receipt-Time",      "octets" ],
                201 => [ "ALU-AAA-Reply-Message",              "string" ],
                202 => [ "ALU-AAA-Called-Station-Id",          "string" ],
                203 => [ "ALU-AAA-NAS-IP-Address",             "ipaddr" ],
                204 => [ "ALU-AAA-NAS-Port",                   "integer" ],
                205 => [ "ALU-AAA-Old-State",                  "string" ],
                206 => [ "ALU-AAA-New-State",                  "string" ],
                207 => [ "ALU-AAA-Event",                      "string" ],
                208 => [ "ALU-AAA-Old-Timestamp",              "date" ],
                209 => [ "ALU-AAA-New-Timestamp",              "date" ],
                210 => [ "ALU-AAA-Delta-Session",              "integer" ],
                211 => [ "ALU-AAA-Civic-Location",             "octets" ],
                212 => [ "ALU-AAA-Geospatial-Location",        "octets" ],
            },
            838 => {
                1 => [ "Xedia-DNS-Server",              "ipaddr" ],
                2 => [ "Xedia-NetBios-Server",          "ipaddr" ],
                3 => [ "Xedia-Address-Pool",            "string" ],
                4 => [ "Xedia-PPP-Echo-Interval",       "integer" ],
                5 => [ "Xedia-SSH-Privileges",          "integer" ],
                6 => [ "Xedia-Client-Access-Network",   "string" ],
                7 => [ "Xedia-Client-Firewall-Setting", "integer" ],
                8 => [ "Xedia-Save-Password",           "integer" ],
            },
            841 => {
                4  => [ "Proxim_E1_VLAN_MODE",           "integer" ],
                5  => [ "Proxim_SU_VLAN_NAME",           "string" ],
                6  => [ "Proxim_E1_Access_VLAN_ID",      "integer" ],
                7  => [ "Proxim_E1_Access_VLAN_Pri",     "integer" ],
                8  => [ "Proxim_Mgmt_VLAN_ID",           "integer" ],
                9  => [ "Proxim_Mgmt_VLAN_Pri",          "integer" ],
                10 => [ "Proxim_E1_TrunkID_01",          "integer" ],
                11 => [ "Proxim_E1_TrunkID_02",          "integer" ],
                12 => [ "Proxim_E1_TrunkID_03",          "integer" ],
                13 => [ "Proxim_E1_TrunkID_04",          "integer" ],
                14 => [ "Proxim_E1_TrunkID_05",          "integer" ],
                15 => [ "Proxim_E1_TrunkID_06",          "integer" ],
                16 => [ "Proxim_E1_TrunkID_07",          "integer" ],
                17 => [ "Proxim_E1_TrunkID_08",          "integer" ],
                18 => [ "Proxim_E1_TrunkID_09",          "integer" ],
                19 => [ "Proxim_E1_TrunkID_10",          "integer" ],
                20 => [ "Proxim_E1_TrunkID_11",          "integer" ],
                21 => [ "Proxim_E1_TrunkID_12",          "integer" ],
                22 => [ "Proxim_E1_TrunkID_13",          "integer" ],
                23 => [ "Proxim_E1_TrunkID_14",          "integer" ],
                24 => [ "Proxim_E1_TrunkID_15",          "integer" ],
                25 => [ "Proxim_E1_TrunkID_16",          "integer" ],
                26 => [ "Proxim_SU_VLAN_Table_Status",   "integer" ],
                32 => [ "Proxim_Service_VLAN_ID",        "integer" ],
                33 => [ "Proxim_Service_VLAN_Pri",       "integer" ],
                34 => [ "Proxim_QoS_Class_Index",        "integer" ],
                35 => [ "Proxim_QoS_Class_SU_Status",    "integer" ],
                40 => [ "Proxim_E2_VLAN_MODE",           "integer" ],
                41 => [ "Proxim_E2_Access_VLAN_ID",      "integer" ],
                42 => [ "Proxim_E2_Access_VLAN_Pri",     "integer" ],
                43 => [ "Proxim_E2_TrunkID_01",          "integer" ],
                44 => [ "Proxim_E2_TrunkID_02",          "integer" ],
                45 => [ "Proxim_E2_TrunkID_03",          "integer" ],
                46 => [ "Proxim_E2_TrunkID_04",          "integer" ],
                47 => [ "Proxim_E2_TrunkID_05",          "integer" ],
                48 => [ "Proxim_E2_TrunkID_06",          "integer" ],
                49 => [ "Proxim_E2_TrunkID_07",          "integer" ],
                50 => [ "Proxim_E2_TrunkID_08",          "integer" ],
                51 => [ "Proxim_E2_TrunkID_09",          "integer" ],
                52 => [ "Proxim_E2_TrunkID_10",          "integer" ],
                53 => [ "Proxim_E2_TrunkID_11",          "integer" ],
                54 => [ "Proxim_E2_TrunkID_12",          "integer" ],
                55 => [ "Proxim_E2_TrunkID_13",          "integer" ],
                56 => [ "Proxim_E2_TrunkID_14",          "integer" ],
                57 => [ "Proxim_E2_TrunkID_15",          "integer" ],
                58 => [ "Proxim_E2_TrunkID_16",          "integer" ],
                59 => [ "Proxim_QinQ_Status",            "integer" ],
                60 => [ "Proxim_Service_VLAN_TPID",      "integer" ],
                61 => [ "Proxim_E1_Port_VLAN_ID",        "integer" ],
                62 => [ "Proxim_E1_Port_VLAN_Pri",       "integer" ],
                63 => [ "Proxim_E1_Allow_Untag",         "integer" ],
                64 => [ "Proxim_E2_Port_VLAN_ID",        "integer" ],
                65 => [ "Proxim_E2_Port_VLAN_Pri",       "integer" ],
                66 => [ "Proxim_E2_Allow_Untag",         "integer" ],
                68 => [ "Proxim_E1_SU_Allow_Untag_Mgmt", "integer" ],
                69 => [ "Proxim_E2_SU_Allow_Untag_Mgmt", "integer" ],
            },
            850 => {
                1 => [ "TrippLite-Authorization", "string" ],
                2 => [ "TrippLite-Outlet-Realms", "string" ],
                3 => [ "TrippLite-Message",       "string" ],
                4 => [ "TrippLite-User-Role",     "string" ],
            },
            890 => {
                3   => [ "Zyxel-Privilege-AVPair",      "string" ],
                192 => [ "Zyxel-Callback-Option",       "integer" ],
                193 => [ "Zyxel-Callback-Phone-Source", "integer" ],
            },
            969 => {
                10 => [ "UserLogon-Uid",                 "integer" ],
                11 => [ "UserLogon-Gid",                 "integer" ],
                12 => [ "UserLogon-HomeDir",             "string" ],
                13 => [ "UserLogon-Type",                "integer" ],
                14 => [ "UserLogon-QuotaBytes",          "integer" ],
                15 => [ "UserLogon-QuotaFiles",          "integer" ],
                16 => [ "UserLogon-Shell",               "string" ],
                17 => [ "UserLogon-Restriction",         "integer" ],
                18 => [ "UserLogon-GroupNames",          "string" ],
                19 => [ "UserLogon-DriveNames",          "string" ],
                20 => [ "UserLogon-UserDescription",     "string" ],
                21 => [ "UserLogon-UserFullName",        "string" ],
                22 => [ "UserLogon-UserDomain",          "string" ],
                23 => [ "UserLogon-LogonTask",           "string" ],
                24 => [ "UserLogon-LogoffTask",          "string" ],
                25 => [ "UserLogon-Expiration",          "string" ],
                26 => [ "UserLogon-UserProfile",         "string" ],
                50 => [ "UserLogon-Acct-TerminateCause", "string" ],
            },
            1076 => {
                1 => [ "Surfnet-AVPair",             "string" ],
                2 => [ "Surfnet-Service-Identifier", "string" ],
                3 => [ "Surfnet-Service-Provider",   "string" ],
            },
            1195 => {
                100 => [ "ITK-Auth-Serv-IP",           "ipaddr" ],
                101 => [ "ITK-Auth-Serv-Prot",         "integer" ],
                102 => [ "ITK-Provider-Id",            "integer" ],
                103 => [ "ITK-Usergroup",              "integer" ],
                104 => [ "ITK-Banner",                 "string" ],
                105 => [ "ITK-Username-Prompt",        "string" ],
                106 => [ "ITK-Password-Prompt",        "string" ],
                107 => [ "ITK-Welcome-Message",        "string" ],
                108 => [ "ITK-Prompt",                 "string" ],
                109 => [ "ITK-IP-Pool",                "integer" ],
                110 => [ "ITK-Tunnel-IP",              "ipaddr" ],
                111 => [ "ITK-Tunnel-Prot",            "integer" ],
                112 => [ "ITK-Acct-Serv-IP",           "ipaddr" ],
                113 => [ "ITK-Acct-Serv-Prot",         "integer" ],
                114 => [ "ITK-Filter-Rule",            "string" ],
                115 => [ "ITK-Channel-Binding",        "integer" ],
                116 => [ "ITK-Start-Delay",            "integer" ],
                117 => [ "ITK-NAS-Name",               "string" ],
                118 => [ "ITK-ISDN-Prot",              "integer" ],
                119 => [ "ITK-PPP-Auth-Type",          "integer" ],
                120 => [ "ITK-Dialout-Type",           "integer" ],
                121 => [ "ITK-Ftp-Auth-IP",            "ipaddr" ],
                122 => [ "ITK-Users-Default-Entry",    "string" ],
                123 => [ "ITK-Users-Default-Pw",       "string" ],
                124 => [ "ITK-Auth-Req-Type",          "string" ],
                125 => [ "ITK-Modem-Pool-Id",          "integer" ],
                126 => [ "ITK-Modem-Init-String",      "string" ],
                127 => [ "ITK-PPP-Client-Server-Mode", "integer" ],
                128 => [ "ITK-PPP-Compression-Prot",   "string" ],
                129 => [ "ITK-Username",               "string" ],
                130 => [ "ITK-Dest-No",                "string" ],
                131 => [ "ITK-DDI",                    "string" ],
            },
            1271 => {
                1   => [ "Ciena-CN4200-Priv-Level", "integer" ],
                10  => [ "Ciena-CES-Priv-Level",    "integer" ],
                220 => [ "Ciena-BP-Role",           "string" ],
                240 => [ "Ciena-NCS-Role",          "integer" ],
                250 => [ "Ciena-OC-Role",           "string" ],
                253 => [ "Ciena-CS-Client-IP",      "ipaddr" ],
                254 => [ "Ciena-CS-Acc-Level",      "integer" ],
                255 => [ "Ciena-CS-Priv-Level",     "integer" ],
            },
            1431 => {
                1   => [ "Telkom-Access-Type",   "string" ],
                2   => [ "Telkom-Service-Type",  "string" ],
                200 => [ "Telkom-Degrade-Token", "string" ],
            },
            1584 => {
                28  => [ "Annex-Filter",                   "string" ],
                29  => [ "Annex-CLI-Command",              "string" ],
                30  => [ "Annex-CLI-Filter",               "string" ],
                31  => [ "Annex-Host-Restrict",            "string" ],
                32  => [ "Annex-Host-Allow",               "string" ],
                33  => [ "Annex-Product-Name",             "string" ],
                34  => [ "Annex-SW-Version",               "string" ],
                35  => [ "Annex-Local-IP-Address",         "ipaddr" ],
                36  => [ "Annex-Callback-Portlist",        "integer" ],
                37  => [ "Annex-Sec-Profile-Index",        "integer" ],
                38  => [ "Annex-Tunnel-Authen-Type",       "integer" ],
                39  => [ "Annex-Tunnel-Authen-Mode",       "integer" ],
                40  => [ "Annex-Authen-Servers",           "string" ],
                41  => [ "Annex-Acct-Servers",             "string" ],
                42  => [ "Annex-User-Server-Location",     "integer" ],
                43  => [ "Annex-Local-Username",           "string" ],
                44  => [ "Annex-System-Disc-Reason",       "integer" ],
                45  => [ "Annex-Modem-Disc-Reason",        "integer" ],
                46  => [ "Annex-Disconnect-Reason",        "integer" ],
                47  => [ "Annex-Addr-Resolution-Protocol", "integer" ],
                48  => [ "Annex-Addr-Resolution-Servers",  "string" ],
                49  => [ "Annex-Domain-Name",              "string" ],
                50  => [ "Annex-Transmit-Speed",           "integer" ],
                51  => [ "Annex-Receive-Speed",            "integer" ],
                52  => [ "Annex-Input-Filter",             "string" ],
                53  => [ "Annex-Output-Filter",            "string" ],
                54  => [ "Annex-Primary-DNS-Server",       "ipaddr" ],
                55  => [ "Annex-Secondary-DNS-Server",     "ipaddr" ],
                56  => [ "Annex-Primary-NBNS-Server",      "ipaddr" ],
                57  => [ "Annex-Secondary-NBNS-Server",    "ipaddr" ],
                58  => [ "Annex-Syslog-Tap",               "integer" ],
                59  => [ "Annex-Keypress-Timeout",         "integer" ],
                60  => [ "Annex-Unauthenticated-Time",     "integer" ],
                61  => [ "Annex-Re-CHAP-Timeout",          "integer" ],
                62  => [ "Annex-MRRU",                     "integer" ],
                63  => [ "Annex-EDO",                      "string" ],
                64  => [ "Annex-PPP-Trace-Level",          "integer" ],
                65  => [ "Annex-Pre-Input-Octets",         "integer" ],
                66  => [ "Annex-Pre-Output-Octets",        "integer" ],
                67  => [ "Annex-Pre-Input-Packets",        "integer" ],
                68  => [ "Annex-Pre-Output-Packets",       "integer" ],
                69  => [ "Annex-Connect-Progress",         "integer" ],
                73  => [ "Annex-Multicast-Rate-Limit",     "integer" ],
                74  => [ "Annex-Maximum-Call-Duration",    "integer" ],
                75  => [ "Annex-Multilink-Id",             "integer" ],
                76  => [ "Annex-Num-In-Multilink",         "integer" ],
                79  => [ "Annex-Secondary-Srv-Endpoint",   "string" ],
                80  => [ "Annex-Gwy-Selection-Mode",       "integer" ],
                81  => [ "Annex-Logical-Channel-Number",   "integer" ],
                82  => [ "Annex-Wan-Number",               "integer" ],
                83  => [ "Annex-Port",                     "integer" ],
                85  => [ "Annex-Pool-Id",                  "integer" ],
                86  => [ "Annex-Compression-Protocol",     "string" ],
                87  => [ "Annex-Transmitted-Packets",      "integer" ],
                88  => [ "Annex-Retransmitted-Packets",    "integer" ],
                89  => [ "Annex-Signal-to-Noise-Ratio",    "integer" ],
                90  => [ "Annex-Retrain-Requests-Sent",    "integer" ],
                91  => [ "Annex-Retrain-Requests-Rcvd",    "integer" ],
                92  => [ "Annex-Rate-Reneg-Req-Sent",      "integer" ],
                93  => [ "Annex-Rate-Reneg-Req-Rcvd",      "integer" ],
                94  => [ "Annex-Begin-Receive-Line-Level", "integer" ],
                95  => [ "Annex-End-Receive-Line-Level",   "integer" ],
                96  => [ "Annex-Begin-Modulation",         "string" ],
                97  => [ "Annex-Error-Correction-Prot",    "string" ],
                98  => [ "Annex-End-Modulation",           "string" ],
                100 => [ "Annex-User-Level",               "integer" ],
                101 => [ "Annex-Audit-Level",              "integer" ],
                102 => [ "CES-Group",                      "string" ],
                192 => [ "Passport-Access-Priority",       "integer" ],
                193 => [ "Annex-Cli-Commands",             "string" ],
                194 => [ "Annex-Command-Access",           "integer" ],
                195 => [ "Commands",                       "string" ],
            },
            1588 => {
                1 => [ "Brocade-Auth-Role",         "string" ],
                2 => [ "Brocade-AVPairs1",          "string" ],
                3 => [ "Brocade-AVPairs2",          "string" ],
                4 => [ "Brocade-AVPairs3",          "string" ],
                5 => [ "Brocade-AVPairs4",          "string" ],
                6 => [ "Brocade-Passwd-ExpiryDate", "string" ],
                7 => [ "Brocade-Passwd-WarnPeriod", "string" ],
            },
            1768 => {
                16  => [ "Patton-Protocol",                       "string" ],
                17  => [ "Patton-Group",                          "string" ],
                18  => [ "Patton-Web-Privilege-Level",            "string" ],
                32  => [ "Patton-Setup-Time",                     "string" ],
                33  => [ "Patton-Connect-Time",                   "string" ],
                34  => [ "Patton-Disconnect-Time",                "string" ],
                35  => [ "Patton-Disconnect-Cause",               "integer" ],
                36  => [ "Patton-Disconnect-Source",              "string" ],
                37  => [ "Patton-Disconnect-Reason",              "string" ],
                48  => [ "Patton-Called-Unique-Id",               "string" ],
                49  => [ "Patton-Called-IP-Address",              "ipaddr" ],
                50  => [ "Patton-Called-Numbering-Plan",          "string" ],
                51  => [ "Patton-Called-Type-Of-Number",          "string" ],
                52  => [ "Patton-Called-Name",                    "string" ],
                53  => [ "Patton-Called-Station-Id",              "string" ],
                64  => [ "Patton-Called-Rx-Octets",               "integer" ],
                65  => [ "Patton-Called-Tx-Octets",               "integer" ],
                66  => [ "Patton-Called-Rx-Packets",              "integer" ],
                67  => [ "Patton-Called-Tx-Packets",              "integer" ],
                68  => [ "Patton-Called-Rx-Lost-Packets",         "integer" ],
                69  => [ "Patton-Called-Tx-Lost-Packets",         "integer" ],
                70  => [ "Patton-Called-Rx-Jitter",               "integer" ],
                71  => [ "Patton-Called-Tx-Jitter",               "integer" ],
                72  => [ "Patton-Called-Codec",                   "string" ],
                73  => [ "Patton-Called-Remote-Ip",               "integer" ],
                74  => [ "Patton-Called-Remote-Udp-Port",         "integer" ],
                75  => [ "Patton-Called-Local-Udp-Port",          "integer" ],
                76  => [ "Patton-Called-Qos",                     "integer" ],
                77  => [ "Patton-Called-MOS",                     "integer" ],
                78  => [ "Patton-Called-Round-Trip-Time",         "integer" ],
                80  => [ "Patton-Calling-Unique-Id",              "string" ],
                81  => [ "Patton-Calling-IP-Address",             "ipaddr" ],
                82  => [ "Patton-Calling-Numbering-Plan",         "string" ],
                83  => [ "Patton-Calling-Type-Of-Number",         "string" ],
                84  => [ "Patton-Calling-Name",                   "string" ],
                85  => [ "Patton-Calling-Station-Id",             "string" ],
                88  => [ "Patton-Calling-Presentation-Indicator", "string" ],
                89  => [ "Patton-Calling-Screening-Indicator",    "string" ],
                96  => [ "Patton-Calling-Rx-Octets",              "integer" ],
                97  => [ "Patton-Calling-Tx-Octets",              "integer" ],
                98  => [ "Patton-Calling-Rx-Packets",             "integer" ],
                99  => [ "Patton-Calling-Tx-Packets",             "integer" ],
                100 => [ "Patton-Calling-Lost-Tx-Packets",        "integer" ],
                101 => [ "Patton-Calling-Lost-Rx-Packets",        "integer" ],
                102 => [ "Patton-Calling-Rx-Jitter",              "integer" ],
                103 => [ "Patton-Calling-Tx-Jitter",              "integer" ],
                104 => [ "Patton-Calling-Codec",                  "string" ],
                105 => [ "Patton-Calling-Remote-Ip",              "integer" ],
                106 => [ "Patton-Calling-Remote-Udp-Port",        "integer" ],
                107 => [ "Patton-Calling-Local-Udp-Port",         "integer" ],
                108 => [ "Patton-Calling-Qos",                    "integer" ],
                109 => [ "Patton-Calling-MOS",                    "integer" ],
                110 => [ "Patton-Calling-Round-Trip-Time",        "integer" ],
            },
            1872 => {
                1  => [ "Alteon-Group-Mapping",         "string" ],
                3  => [ "Alteon-VPN-Id",                "integer" ],
                4  => [ "Alteon-Client-IP-Address",     "ipaddr" ],
                5  => [ "Alteon-Client-Netmask",        "ipaddr" ],
                6  => [ "Alteon-Primary-NBNS-Server",   "ipaddr" ],
                7  => [ "Alteon-Secondary-NBNS-Server", "ipaddr" ],
                8  => [ "Alteon-Primary-DNS-Server",    "ipaddr" ],
                9  => [ "Alteon-Secondary-DNS-Server",  "ipaddr" ],
                10 => [ "Alteon-Domain-Name",           "string" ],
                26 => [ "Alteon-Service-Type",          "integer" ],
            },
            1916 => {
                201 => [ "Extreme-CLI-Authorization",      "integer" ],
                202 => [ "Extreme-Shell-Command",          "string" ],
                203 => [ "Extreme-Netlogin-Vlan",          "string" ],
                204 => [ "Extreme-Netlogin-Url",           "string" ],
                205 => [ "Extreme-Netlogin-Url-Desc",      "string" ],
                206 => [ "Extreme-Netlogin-Only",          "integer" ],
                208 => [ "Extreme-User-Location",          "string" ],
                209 => [ "Extreme-Netlogin-Vlan-Tag",      "integer" ],
                211 => [ "Extreme-Netlogin-Extended-Vlan", "string" ],
                212 => [ "Extreme-Security-Profile",       "string" ],
                213 => [ "Extreme-VM-Name",                "string" ],
                214 => [ "Extreme-VM-VPP-Name",            "string" ],
                215 => [ "Extreme-VM-IP-Addr",             "ipaddr" ],
                216 => [ "Extreme-VM-VLAN-ID",             "integer" ],
                217 => [ "Extreme-VM-VR-Name",             "string" ],
            },
            1958 => {
                5  => [ "RedCreek-Tunneled-IP-Addr",      "ipaddr" ],
                6  => [ "RedCreek-Tunneled-IP-Netmask",   "ipaddr" ],
                7  => [ "RedCreek-Tunneled-Gateway",      "ipaddr" ],
                8  => [ "RedCreek-Tunneled-DNS-Server",   "string" ],
                9  => [ "RedCreek-Tunneled-WINS-Server1", "string" ],
                10 => [ "RedCreek-Tunneled-WINS-Server2", "string" ],
                11 => [ "RedCreek-Tunneled-HostName",     "string" ],
                12 => [ "RedCreek-Tunneled-DomainName",   "string" ],
                13 => [ "RedCreek-Tunneled-Search-List",  "string" ],
            },
            1966 => {
                99  => [ "Perle-Clustered-Port-Access", "integer" ],
                100 => [ "Perle-User-Level",            "integer" ],
                101 => [ "Perle-Line-Access-Port-1",    "integer" ],
                102 => [ "Perle-Line-Access-Port-2",    "integer" ],
                103 => [ "Perle-Line-Access-Port-3",    "integer" ],
                104 => [ "Perle-Line-Access-Port-4",    "integer" ],
                105 => [ "Perle-Line-Access-Port-5",    "integer" ],
                106 => [ "Perle-Line-Access-Port-6",    "integer" ],
                107 => [ "Perle-Line-Access-Port-7",    "integer" ],
                108 => [ "Perle-Line-Access-Port-8",    "integer" ],
                109 => [ "Perle-Line-Access-Port-9",    "integer" ],
                110 => [ "Perle-Line-Access-Port-10",   "integer" ],
                111 => [ "Perle-Line-Access-Port-11",   "integer" ],
                112 => [ "Perle-Line-Access-Port-12",   "integer" ],
                113 => [ "Perle-Line-Access-Port-13",   "integer" ],
                114 => [ "Perle-Line-Access-Port-14",   "integer" ],
                115 => [ "Perle-Line-Access-Port-15",   "integer" ],
                116 => [ "Perle-Line-Access-Port-16",   "integer" ],
                117 => [ "Perle-Line-Access-Port-17",   "integer" ],
                118 => [ "Perle-Line-Access-Port-18",   "integer" ],
                119 => [ "Perle-Line-Access-Port-19",   "integer" ],
                120 => [ "Perle-Line-Access-Port-20",   "integer" ],
                121 => [ "Perle-Line-Access-Port-21",   "integer" ],
                122 => [ "Perle-Line-Access-Port-22",   "integer" ],
                123 => [ "Perle-Line-Access-Port-23",   "integer" ],
                124 => [ "Perle-Line-Access-Port-24",   "integer" ],
                125 => [ "Perle-Line-Access-Port-25",   "integer" ],
                126 => [ "Perle-Line-Access-Port-26",   "integer" ],
                127 => [ "Perle-Line-Access-Port-27",   "integer" ],
                128 => [ "Perle-Line-Access-Port-28",   "integer" ],
                129 => [ "Perle-Line-Access-Port-29",   "integer" ],
                130 => [ "Perle-Line-Access-Port-30",   "integer" ],
                131 => [ "Perle-Line-Access-Port-31",   "integer" ],
                132 => [ "Perle-Line-Access-Port-32",   "integer" ],
                133 => [ "Perle-Line-Access-Port-33",   "integer" ],
                134 => [ "Perle-Line-Access-Port-34",   "integer" ],
                135 => [ "Perle-Line-Access-Port-35",   "integer" ],
                136 => [ "Perle-Line-Access-Port-36",   "integer" ],
                137 => [ "Perle-Line-Access-Port-37",   "integer" ],
                138 => [ "Perle-Line-Access-Port-38",   "integer" ],
                139 => [ "Perle-Line-Access-Port-39",   "integer" ],
                140 => [ "Perle-Line-Access-Port-40",   "integer" ],
                141 => [ "Perle-Line-Access-Port-41",   "integer" ],
                142 => [ "Perle-Line-Access-Port-42",   "integer" ],
                143 => [ "Perle-Line-Access-Port-43",   "integer" ],
                144 => [ "Perle-Line-Access-Port-44",   "integer" ],
                145 => [ "Perle-Line-Access-Port-45",   "integer" ],
                146 => [ "Perle-Line-Access-Port-46",   "integer" ],
                147 => [ "Perle-Line-Access-Port-47",   "integer" ],
                148 => [ "Perle-Line-Access-Port-48",   "integer" ],
                149 => [ "Perle-Line-Access-Port-49",   "integer" ],
            },
            1991 => {
                1  => [ "Foundry-Privilege-Level",          "integer" ],
                2  => [ "Foundry-Command-String",           "string" ],
                3  => [ "Foundry-Command-Exception-Flag",   "integer" ],
                4  => [ "Foundry-INM-Privilege",            "integer" ],
                5  => [ "Foundry-Access-List",              "string" ],
                6  => [ "Foundry-MAC-Authent-needs-802.1x", "integer" ],
                7  => [ "Foundry-802.1x-Valid-Lookup",      "integer" ],
                8  => [ "Foundry-MAC-Based-Vlan-QoS",       "integer" ],
                9  => [ "Foundry-INM-Role-Aor-List",        "string" ],
                10 => [ "Foundry-COA-Command",              "string" ],
                11 => [ "Foundry-Voice-Phone-Config",       "string" ],
            },
            2004 => {
                1  => [ "WB-AUTH-Time-Left",      "integer" ],
                2  => [ "WB-Auth-Accum-BW",       "integer" ],
                3  => [ "WB-Auth-BW-Quota",       "integer" ],
                4  => [ "WB-Auth-BW-Count",       "integer" ],
                5  => [ "WB-Auth-Upload-Limit",   "integer" ],
                6  => [ "WB-Auth-Download-Limit", "integer" ],
                7  => [ "WB-Auth-Login-Time",     "integer" ],
                8  => [ "WB-Auth-Logout-Time",    "integer" ],
                9  => [ "WB-Auth-Time-Diff",      "integer" ],
                10 => [ "WB-Auth-BW-Usage",       "integer" ],
            },
            2011 => {
                1   => [ "Huawei-Input-Burst-Size",            "integer" ],
                2   => [ "Huawei-Input-Average-Rate",          "integer" ],
                3   => [ "Huawei-Input-Peak-Rate",             "integer" ],
                4   => [ "Huawei-Output-Burst-Size",           "integer" ],
                5   => [ "Huawei-Output-Average-Rate",         "integer" ],
                6   => [ "Huawei-Output-Peak-Rate",            "integer" ],
                7   => [ "Huawei-In-Kb-Before-T-Switch",       "integer" ],
                8   => [ "Huawei-Out-Kb-Before-T-Switch",      "integer" ],
                9   => [ "Huawei-In-Pkt-Before-T-Switch",      "integer" ],
                10  => [ "Huawei-Out-Pkt-Before-T-Switch",     "integer" ],
                11  => [ "Huawei-In-Kb-After-T-Switch",        "integer" ],
                12  => [ "Huawei-Out-Kb-After-T-Switch",       "integer" ],
                13  => [ "Huawei-In-Pkt-After-T-Switch",       "integer" ],
                14  => [ "Huawei-Out-Pkt-After-T-Switch",      "integer" ],
                15  => [ "Huawei-Remanent-Volume",             "integer" ],
                16  => [ "Huawei-Tariff-Switch-Interval",      "integer" ],
                17  => [ "Huawei-ISP-ID",                      "string" ],
                18  => [ "Huawei-Max-Users-Per-Logic-Port",    "integer" ],
                20  => [ "Huawei-Command",                     "integer" ],
                22  => [ "Huawei-Priority",                    "integer" ],
                24  => [ "Huawei-Control-Identifier",          "integer" ],
                25  => [ "Huawei-Result-Code",                 "integer" ],
                26  => [ "Huawei-Connect-ID",                  "integer" ],
                27  => [ "Huawei-PortalURL",                   "string" ],
                28  => [ "Huawei-FTP-Directory",               "string" ],
                29  => [ "Huawei-Exec-Privilege",              "integer" ],
                30  => [ "Huawei-IP-Address",                  "integer" ],
                31  => [ "Huawei-Qos-Profile-Name",            "string" ],
                32  => [ "Huawei-SIP-Server",                  "string" ],
                33  => [ "Huawei-User-Password",               "string" ],
                34  => [ "Huawei-Command-Mode",                "string" ],
                35  => [ "Huawei-Renewal-Time",                "integer" ],
                36  => [ "Huawei-Rebinding-Time",              "integer" ],
                37  => [ "Huawei-IGMP-Enable",                 "integer" ],
                39  => [ "Huawei-Destnation-IP-Addr",          "string" ],
                40  => [ "Huawei-Destnation-Volume",           "string" ],
                59  => [ "Huawei-Startup-Stamp",               "integer" ],
                60  => [ "Huawei-IPHost-Addr",                 "string" ],
                61  => [ "Huawei-Up-Priority",                 "integer" ],
                62  => [ "Huawei-Down-Priority",               "integer" ],
                63  => [ "Huawei-Tunnel-VPN-Instance",         "string" ],
                64  => [ "Huawei-VT-Name",                     "integer" ],
                65  => [ "Huawei-User-Date",                   "string" ],
                66  => [ "Huawei-User-Class",                  "string" ],
                70  => [ "Huawei-PPP-NCP-Type",                "integer" ],
                71  => [ "Huawei-VSI-Name",                    "string" ],
                72  => [ "Huawei-Subnet-Mask",                 "ipaddr" ],
                73  => [ "Huawei-Gateway-Address",             "ipaddr" ],
                74  => [ "Huawei-Lease-Time",                  "integer" ],
                75  => [ "Huawei-Primary-WINS",                "ipaddr" ],
                76  => [ "Huawei-Secondary-WINS",              "ipaddr" ],
                77  => [ "Huawei-Input-Peak-Burst-Size",       "integer" ],
                78  => [ "Huawei-Output-Peak-Burst-Size",      "integer" ],
                79  => [ "Huawei-Reduced-CIR",                 "integer" ],
                80  => [ "Huawei-Tunnel-Session-Limit",        "integer" ],
                81  => [ "Huawei-Zone-Name",                   "string" ],
                82  => [ "Huawei-Data-Filter",                 "string" ],
                83  => [ "Huawei-Access-Service",              "string" ],
                84  => [ "Huawei-Accounting-Level",            "integer" ],
                85  => [ "Huawei-Portal-Mode",                 "integer" ],
                86  => [ "Huawei-DPI-Policy-Name",             "string" ],
                87  => [ "huawei-Policy-Route",                "ipaddr" ],
                88  => [ "Huawei-Framed-Pool",                 "string" ],
                89  => [ "Huawei-L2TP-Terminate-Cause",        "string" ],
                90  => [ "Huawei-Multi-Account-Mode",          "integer" ],
                91  => [ "Huawei-Queue-Profile",               "string" ],
                92  => [ "Huawei-Layer4-Session-Limit",        "integer" ],
                93  => [ "Huawei-Multicast-Profile",           "string" ],
                94  => [ "Huawei-VPN-Instance",                "string" ],
                95  => [ "Huawei-Policy-Name",                 "string" ],
                96  => [ "Huawei-Tunnel-Group-Name",           "string" ],
                97  => [ "Huawei-Multicast-Source-Group",      "string" ],
                98  => [ "Huawei-Multicast-Receive-Group",     "ipaddr" ],
                99  => [ "Huawei-User-Multicast-Type",         "integer" ],
                100 => [ "Huawei-Reduced-PIR",                 "integer" ],
                101 => [ "Huawei-LI-ID",                       "string" ],
                102 => [ "Huawei-LI-Md-Address",               "ipaddr" ],
                103 => [ "Huawei-LI-Md-Port",                  "integer" ],
                104 => [ "Huawei-LI-Md-VpnInstance",           "string" ],
                105 => [ "Huawei-Service-Chg-Cmd",             "integer" ],
                106 => [ "Huawei-Acct-Packet-Type",            "integer" ],
                107 => [ "Huawei-Call-Reference",              "integer" ],
                108 => [ "Huawei-PSTN-Port",                   "integer" ],
                109 => [ "Huawei-Voip-Service-Type",           "integer" ],
                110 => [ "Huawei-Acct-Connection-Time",        "integer" ],
                112 => [ "Huawei-Error-Reason",                "integer" ],
                113 => [ "Huawei-Remain-Monney",               "integer" ],
                123 => [ "Huawei-Org-GK-ipaddr",               "ipaddr" ],
                124 => [ "Huawei-Org-GW-ipaddr",               "ipaddr" ],
                125 => [ "Huawei-Dst-GK-ipaddr",               "ipaddr" ],
                126 => [ "Huawei-Dst-GW-ipaddr",               "ipaddr" ],
                127 => [ "Huawei-Access-Num",                  "string" ],
                128 => [ "Huawei-Remain-Time",                 "integer" ],
                131 => [ "Huawei-Codec-Type",                  "integer" ],
                132 => [ "Huawei-Transfer-Num",                "string" ],
                133 => [ "Huawei-New-User-Name",               "string" ],
                134 => [ "Huawei-Transfer-Station-Id",         "string" ],
                135 => [ "Huawei-Primary-DNS",                 "ipaddr" ],
                136 => [ "Huawei-Secondary-DNS",               "ipaddr" ],
                137 => [ "Huawei-ONLY-Account-Type",           "integer" ],
                138 => [ "Huawei-Domain-Name",                 "string" ],
                139 => [ "Huawei-ANCP-Profile",                "string" ],
                140 => [ "Huawei-HTTP-Redirect-URL",           "string" ],
                141 => [ "Huawei-Loopback-Address",            "string" ],
                142 => [ "Huawei-QoS-Profile-Type",            "integer" ],
                143 => [ "Huawei-Max-List-Num",                "integer" ],
                144 => [ "Huawei-Acct-IPv6-Input-Octets",      "integer" ],
                145 => [ "Huawei-Acct-IPv6-Output-Octets",     "integer" ],
                146 => [ "Huawei-Acct-IPv6-Input-Packets",     "integer" ],
                147 => [ "Huawei-Acct-IPv6-Output-Packets",    "integer" ],
                148 => [ "Huawei-Acct-IPv6-Input-Gigawords",   "integer" ],
                149 => [ "Huawei-Acct-IPv6-Output-Gigawords",  "integer" ],
                150 => [ "Huawei-DHCPv6-Option37",             "string" ],
                151 => [ "Huawei-DHCPv6-Option38",             "string" ],
                153 => [ "Huawei-User-Mac",                    "string" ],
                154 => [ "Huawei-DNS-Server-IPv6-address",     "ipv6addr" ],
                155 => [ "Huawei-DHCPv4-Option121",            "string" ],
                156 => [ "Huawei-DHCPv4-Option43",             "string" ],
                157 => [ "Huawei-Framed-Pool-Group",           "string" ],
                158 => [ "Huawei-Framed-IPv6-Address",         "ipv6addr" ],
                159 => [ "Huawei-Acct-Update-Address",         "integer" ],
                160 => [ "Huawei-NAT-Policy-Name",             "string" ],
                161 => [ "Huawei-NAT-Public-Address",          "ipaddr" ],
                162 => [ "Huawei-NAT-Start-Port",              "integer" ],
                163 => [ "Huawei-NAT-End-Port",                "integer" ],
                164 => [ "Huawei-NAT-Port-Forwarding",         "integer" ],
                165 => [ "Huawei-NAT-Port-Range-Update",       "integer" ],
                166 => [ "Huawei-DS-Lite-Tunnel-Name",         "string" ],
                167 => [ "Huawei-PCP-Server-Name",             "string" ],
                168 => [ "Huawei-Public-IP-Addr-State",        "integer" ],
                180 => [ "Huawei-Auth-Type",                   "integer" ],
                181 => [ "Huawei-Acct-Terminate-Subcause",     "string" ],
                182 => [ "Huawei-Down-QOS-Profile-Name",       "string" ],
                183 => [ "Huawei-Port-Mirror",                 "integer" ],
                184 => [ "Huawei-Account-Info",                "string" ],
                185 => [ "Huawei-Service-Info",                "string" ],
                187 => [ "Huawei-DHCP-Option",                 "octets" ],
                188 => [ "Huawei-AVpair",                      "string" ],
                191 => [ "Huawei-Delegated-IPv6-Prefix-Pool",  "string" ],
                192 => [ "Huawei-IPv6-Prefix-Lease",           "octets" ],
                193 => [ "Huawei-IPv6-Address-Lease",          "octets" ],
                194 => [ "Huawei-IPv6-Policy-Route",           "ipv6prefix" ],
                196 => [ "Huawei-MNG-IPv6",                    "integer" ],
                211 => [ "Huawei-Flow-Info",                   "string" ],
                212 => [ "Huawei-Flow-Id",                     "integer" ],
                214 => [ "Huawei-DHCP-Server-IP",              "ipaddr" ],
                215 => [ "Huawei-Application-Type",            "integer" ],
                216 => [ "Huawei-Indication-Flag",             "octets" ],
                217 => [ "Huawei-Original_NAS-IP_Address",     "ipaddr" ],
                218 => [ "Huawei-User-Priority",               "integer" ],
                219 => [ "Huawei-ACS-Url",                     "string" ],
                220 => [ "Huawei-Provision-Code",              "string" ],
                221 => [ "Huawei-Application-Scene",           "octets" ],
                222 => [ "Huawei-MS-Maximum-MAC-Study-Number", "octets" ],
                232 => [ "Huawei-GGSN-Vendor",                 "string" ],
                233 => [ "Huawei-GGSN-Version",                "string" ],
                238 => [ "Huawei-Ext-Specific",                "string" ],
                253 => [ "Huawei-Web-URL",                     "string" ],
                254 => [ "Huawei-Version",                     "string" ],
                255 => [ "Huawei-Product-ID",                  "string" ],
            },
            2167 => {
                1  => [ "Cajun-Service-Type",      "integer" ],
                12 => [ "Avaya-StaticVlan-Type",   "string" ],
                13 => [ "Avaya-PortPriority-Type", "integer" ],
            },
            2180 => { 1 => [ "Versanet-Termination-Cause", "integer" ] },
            2334 => {
                1 => [ "Packeteer-AVPair",    "string" ],
                2 => [ "Packeteer-PC-AVPair", "string" ],
            },
            2352 => {
                1   => [ "Client-DNS-Pri",                  "ipaddr" ],
                2   => [ "Client-DNS-Sec",                  "ipaddr" ],
                3   => [ "DHCP-Max-Leases",                 "integer" ],
                4   => [ "Context-Name",                    "string" ],
                5   => [ "Bridge-Group",                    "string" ],
                6   => [ "BG-Aging-Time",                   "string" ],
                7   => [ "BG-Path-Cost",                    "string" ],
                8   => [ "BG-Span-Dis",                     "string" ],
                9   => [ "BG-Trans-BPDU",                   "string" ],
                10  => [ "Rate-Limit-Rate",                 "integer" ],
                11  => [ "Rate-Limit-Burst",                "integer" ],
                12  => [ "Police-Rate",                     "integer" ],
                13  => [ "Police-Burst",                    "integer" ],
                14  => [ "Source-Validation",               "integer" ],
                15  => [ "Tunnel-Domain",                   "integer" ],
                16  => [ "Tunnel-Local-Name",               "string" ],
                17  => [ "Tunnel-Remote-Name",              "string" ],
                18  => [ "Tunnel-Function",                 "integer" ],
                19  => [ "Tunnel-Flow-Control",             "integer" ],
                20  => [ "Tunnel-Static",                   "integer" ],
                21  => [ "Tunnel-Max-Sessions",             "integer" ],
                22  => [ "Tunnel-Max-Tunnels",              "integer" ],
                23  => [ "Tunnel-Session-Auth",             "integer" ],
                24  => [ "Tunnel-Window",                   "integer" ],
                25  => [ "Tunnel-Retransmit",               "integer" ],
                26  => [ "Tunnel-Cmd-Timeout",              "integer" ],
                27  => [ "PPPOE-URL",                       "string" ],
                28  => [ "PPPOE-MOTM",                      "string" ],
                29  => [ "Tunnel-Group",                    "integer" ],
                30  => [ "Tunnel-Context",                  "string" ],
                31  => [ "Tunnel-Algorithm",                "integer" ],
                32  => [ "Tunnel-Deadtime",                 "integer" ],
                33  => [ "Mcast-Send",                      "integer" ],
                34  => [ "Mcast-Receive",                   "integer" ],
                35  => [ "Mcast-MaxGroups",                 "integer" ],
                36  => [ "Ip-Address-Pool-Name",            "string" ],
                37  => [ "Tunnel-DNIS",                     "integer" ],
                38  => [ "Medium-Type",                     "integer" ],
                39  => [ "PVC-Encapsulation-Type",          "integer" ],
                40  => [ "PVC-Profile-Name",                "string" ],
                41  => [ "PVC-Circuit-Padding",             "integer" ],
                42  => [ "Bind-Type",                       "integer" ],
                43  => [ "Bind-Auth-Protocol",              "integer" ],
                44  => [ "Bind-Auth-Max-Sessions",          "integer" ],
                45  => [ "Bind-Bypass-Bypass",              "string" ],
                46  => [ "Bind-Auth-Context",               "string" ],
                47  => [ "Bind-Auth-Service-Grp",           "string" ],
                48  => [ "Bind-Bypass-Context",             "string" ],
                49  => [ "Bind-Int-Context",                "string" ],
                50  => [ "Bind-Tun-Context",                "string" ],
                51  => [ "Bind-Ses-Context",                "string" ],
                52  => [ "Bind-Dot1q-Slot",                 "integer" ],
                53  => [ "Bind-Dot1q-Port",                 "integer" ],
                54  => [ "Bind-Dot1q-Vlan-Tag-Id",          "integer" ],
                55  => [ "Bind-Int-Interface-Name",         "string" ],
                56  => [ "Bind-L2TP-Tunnel-Name",           "string" ],
                57  => [ "Bind-L2TP-Flow-Control",          "integer" ],
                58  => [ "Bind-Sub-User-At-Context",        "string" ],
                59  => [ "Bind-Sub-Password",               "string" ],
                60  => [ "Ip-Host-Addr",                    "string" ],
                61  => [ "IP-TOS-Field",                    "integer" ],
                62  => [ "NAS-Real-Port",                   "integer" ],
                63  => [ "Tunnel-Session-Auth-Ctx",         "string" ],
                64  => [ "Tunnel-Session-Auth-Service-Grp", "string" ],
                65  => [ "Tunnel-Rate-Limit-Rate",          "integer" ],
                66  => [ "Tunnel-Rate-Limit-Burst",         "integer" ],
                67  => [ "Tunnel-Police-Rate",              "integer" ],
                68  => [ "Tunnel-Police-Burst",             "integer" ],
                69  => [ "Tunnel-L2F-Second-Password",      "string" ],
                70  => [ "ACL-Definition",                  "string" ],
                71  => [ "PPPoE-IP-Route-Add",              "string" ],
                72  => [ "TTY-Level-Max",                   "integer" ],
                73  => [ "TTY-Level-Start",                 "integer" ],
                74  => [ "Tunnel-Checksum",                 "integer" ],
                75  => [ "Tunnel-Profile",                  "string" ],
                78  => [ "Tunnel-Client-VPN",               "string" ],
                79  => [ "Tunnel-Server-VPN",               "string" ],
                80  => [ "Tunnel-Client-Rhost",             "string" ],
                81  => [ "Tunnel-Server-Rhost",             "string" ],
                82  => [ "Tunnel-Client-Int-Addr",          "ipaddr" ],
                83  => [ "Tunnel-Server-Int-Addr",          "ipaddr" ],
                84  => [ "PPP-Compression",                 "integer" ],
                85  => [ "Tunnel-Hello-Timer",              "integer" ],
                86  => [ "Redback-Reason",                  "integer" ],
                87  => [ "Qos-Policing-Profile-Name",       "string" ],
                88  => [ "Qos-Metering-Profile-Name",       "string" ],
                89  => [ "Qos-Policy-Queuing",              "string" ],
                90  => [ "IGMP-Service-Profile-Name",       "string" ],
                91  => [ "Subscriber-Profile-Name",         "string" ],
                92  => [ "Forward-Policy",                  "string" ],
                93  => [ "Remote-Port",                     "string" ],
                94  => [ "Reauth",                          "string" ],
                95  => [ "Reauth-More",                     "integer" ],
                96  => [ "Agent-Remote-Id",                 "octets" ],
                97  => [ "Agent-Circuit-Id",                "octets" ],
                98  => [ "Platform-Type",                   "integer" ],
                99  => [ "Client-NBNS-Pri",                 "ipaddr" ],
                100 => [ "Client-NBNS-Sec",                 "ipaddr" ],
                101 => [ "Shaping-Profile-Name",            "string" ],
                103 => [ "BG-Cct-Addr-Max",                 "integer" ],
                104 => [ "IP-Interface-Name",               "string" ],
                105 => [ "NAT-Policy-Name",                 "string" ],
                106 => [ "RB-NPM-Service-Id",               "string" ],
                107 => [ "HTTP-Redirect-Profile-Name",      "string" ],
                108 => [ "Bind-Auto-Sub-User",              "string" ],
                109 => [ "Bind-Auto-Sub-Context",           "string" ],
                110 => [ "Bind-Auto-Sub-Password",          "string" ],
                111 => [ "Circuit-Protocol-Encap",          "integer" ],
                112 => [ "OS-Version",                      "string" ],
                113 => [ "Session-Traffic-Limit",           "string" ],
                114 => [ "QOS-Reference",                   "string" ],
                121 => [ "Rate-Limit-Excess-Burst",         "octets" ],
                122 => [ "Police-Excess-Burst",             "octets" ],
                123 => [ "Tunnel-Rate-Limit-Excess-Burst",  "octets" ],
                124 => [ "Tunnel-Police-Excess-Burst",      "octets" ],
                125 => [ "DHCP-Vendor-Class-ID",            "string" ],
                126 => [ "Qos-Rate",                        "string" ],
                127 => [ "DHCP-Vendor-Encap-Option",        "string" ],
                128 => [ "Acct-Input-Octets-64",            "integer64" ],
                129 => [ "Acct-Output-Octets-64",           "integer64" ],
                130 => [ "Acct-Input-Packets-64",           "integer64" ],
                131 => [ "Acct-Output-Packets-64",          "integer64" ],
                132 => [ "Assigned-IP-Address",             "ipaddr" ],
                133 => [ "Acct-Mcast-In-Octets-64",         "integer64" ],
                134 => [ "Acct-Mcast-Out-Octets-64",        "integer64" ],
                135 => [ "Acct-Mcast-In-Packets-64",        "integer64" ],
                136 => [ "Acct-Mcast-Out-Packets-64",       "integer64" ],
                137 => [ "LAC-Port",                        "integer" ],
                138 => [ "LAC-Real-Port",                   "integer" ],
                139 => [ "LAC-Port-Type",                   "integer" ],
                140 => [ "LAC-Real-Port-Type",              "integer" ],
                141 => [ "Acct-Dyn-Ac-Ent",                 "string" ],
                142 => [ "Session-Error-Code",              "integer" ],
                143 => [ "Session-Error-Msg",               "string" ],
                144 => [ "Acct-Update-Reason",              "integer" ],
                145 => [ "Mac-Addr",                        "string" ],
                146 => [ "Vlan-Source-Info",                "string" ],
                147 => [ "Acct-Mcast-In-Octets",            "integer" ],
                148 => [ "Acct-Mcast-Out-Octets",           "integer" ],
                149 => [ "Acct-Mcast-In-Packets",           "integer" ],
                150 => [ "Acct-Mcast-Out-Packets",          "integer" ],
                151 => [ "Reauth-Session-Id",               "string" ],
                156 => [ "QOS-Rate-Inbound",                "string" ],
                157 => [ "QOS-Rate-Outbound",               "string" ],
                158 => [ "Route-Tag",                       "integer" ],
                159 => [ "LI-Id",                           "integer" ],
                160 => [ "LI-Md-Address",                   "ipaddr" ],
                161 => [ "LI-Md-Port",                      "integer" ],
                162 => [ "LI-Action",                       "integer" ],
                163 => [ "LI-Profile",                      "string" ],
                164 => [ "Dynamic-Policy-Filter",           "string" ],
                165 => [ "HTTP-Redirect-URL",               "string" ],
                166 => [ "DSL-Actual-Rate-Up",              "integer" ],
                167 => [ "DSL-Actual-Rate-Down",            "integer" ],
                168 => [ "DSL-Min-Rate-Up",                 "integer" ],
                169 => [ "DSL-Min-Rate-Down",               "integer" ],
                170 => [ "DSL-Attainable-Rate-Up",          "integer" ],
                171 => [ "DSL-Attainable-Rate-Down",        "integer" ],
                172 => [ "DSL-Max-Rate-Up",                 "integer" ],
                173 => [ "DSL-Max-Rate-Down",               "integer" ],
                174 => [ "DSL-Min-Low-Power-Rate-Up",       "integer" ],
                175 => [ "DSL-Min-Low-Power-Rate-Down",     "integer" ],
                176 => [ "DSL-Max-Inter-Delay-Up",          "integer" ],
                177 => [ "DSL-Actual-Inter-Delay-Up",       "integer" ],
                178 => [ "DSL-Max-Inter-Delay-Down",        "integer" ],
                179 => [ "DSL-Actual-Inter-Delay-Down",     "integer" ],
                180 => [ "DSL-Line-State",                  "integer" ],
                181 => [ "DSL-L2-Encapsulation",            "integer" ],
                182 => [ "DSL-Transmission-System",         "integer" ],
                183 => [ "DSL-PPPOA-PPPOE-Inter-Work-Flag", "integer" ],
                184 => [ "DSL-Combined-Line-Info",          "string" ],
                185 => [ "DSL-Actual-Rate-Down-Factor",     "integer" ],
                186 => [ "Class-Volume-limit",              "string" ],
                187 => [ "Class-Volume-In-Counter",         "string" ],
                188 => [ "Class-Volume-Out-Counter",        "string" ],
                189 => [ "Flow-FAC-Profile",                "string" ],
                190 => [ "Service-Name",                    "string" ],
                191 => [ "Service-Action",                  "integer" ],
                192 => [ "Service-Parameter",               "string" ],
                193 => [ "Service-Error-Cause",             "integer" ],
                194 => [ "Deactivate-Service-Name",         "string" ],
                195 => [ "Qos-Profile-Overhead",            "string" ],
                196 => [ "Dynamic-QoS-Param",               "string" ],
                197 => [ "Acct-Alt-Session-ID",             "string" ],
                198 => [ "Idle-Timeout-Threshold",          "integer" ],
                199 => [ "Double-Authentication",           "integer" ],
                200 => [ "SBC-Adjacency",                   "string" ],
                201 => [ "DHCP-Field",                      "octets" ],
                202 => [ "DHCP-Option",                     "octets" ],
                203 => [ "Security-Service",                "string" ],
                204 => [ "Reauth-Service-Name",             "string" ],
                205 => [ "Flow-IP-Profile",                 "string" ],
                206 => [ "Radius-Throttle-Watermark",       "integer" ],
                207 => [ "RB-IPV6-DNS",                     "string" ],
                208 => [ "RB-IPv6-Option",                  "string" ],
                209 => [ "Cluster-Partition-ID",            "string" ],
                210 => [ "Circuit-Group-Member",            "string" ],
                212 => [ "Delegated-Max-Prefix",            "integer" ],
                213 => [ "IPv4-Address-Release-Control",    "string" ],
                214 => [ "Acct-Input-IPv4-Octets",          "integer" ],
                215 => [ "Acct-Output-IPv4-Octets",         "integer" ],
                216 => [ "Acct-Input-IPv4-Packets",         "integer" ],
                217 => [ "Acct-Output-IPv4-Packets",        "integer" ],
                218 => [ "Acct-Input-IPv4-Gigawords",       "integer" ],
                219 => [ "Acct-Output-IPv4-Gigawords",      "integer" ],
                220 => [ "Acct-Input-IPv6-Octets",          "integer" ],
                221 => [ "Acct-Output-IPv6-Octets",         "integer" ],
                222 => [ "Acct-Input-IPv6-Packets",         "integer" ],
                223 => [ "Acct-Output-IPv6-Packets",        "integer" ],
                224 => [ "Acct-Input-IPv6-Gigawords",       "integer" ],
                225 => [ "Acct-Output-IPv6-Gigawords",      "integer" ],
            },
            2356 => {
                1  => [ "LCS-Traffic-Limit",           "integer" ],
                2  => [ "LCS-Mac-Address",             "string" ],
                3  => [ "LCS-Redirection-URL",         "string" ],
                4  => [ "LCS-Comment",                 "string" ],
                5  => [ "LCS-Account-End",             "integer" ],
                6  => [ "LCS-WPA-Passphrase",          "string" ],
                7  => [ "LCS-PbSpotUserName",          "string" ],
                8  => [ "LCS-TxRateLimit",             "integer" ],
                9  => [ "LCS-RxRateLimit",             "integer" ],
                11 => [ "LCS-Access-Rights",           "integer" ],
                12 => [ "LCS-Function-Rights",         "integer" ],
                13 => [ "LCS-Advertisement-URL",       "string" ],
                14 => [ "LCS-Advertisement-Interval",  "integer" ],
                15 => [ "LCS-Traffic-Limit-Gigawords", "integer" ],
                16 => [ "LCS-Orig-NAS-Identifier",     "string" ],
                17 => [ "LCS-Orig-NAS-IP-Address",     "ipaddr" ],
                18 => [ "LCS-Orig-NAS-IPv6-Address",   "ipv6addr" ],
                19 => [ "LCS-IKEv2-Local-Password",    "string" ],
                20 => [ "LCS-IKEv2-Remote-Password",   "string" ],
                21 => [ "LCS-DNS-Server-IPv4-Address", "ipaddr" ],
                22 => [ "LCS-VPN-IPv4-Rule",           "string" ],
                23 => [ "LCS-VPN-IPv6-Rule",           "string" ],
                24 => [ "LCS-Routing-Tag",             "integer" ],
                25 => [ "LCS-IKEv2-IPv4-Route",        "string" ],
                26 => [ "LCS-IKEv2-IPv6-Route",        "string" ],
                27 => [ "LCS-IKEv2-DNS-Domain",        "string" ],
                28 => [ "LCS-Load-Balancer",           "string" ],
            },
            2440 => {
                1  => [ "EfficientIP-Version",          "integer" ],
                2  => [ "EfficientIP-Service-Class",    "integer" ],
                3  => [ "EfficientIP-Identity-Type",    "integer" ],
                16 => [ "EfficientIP-First-Name",       "string" ],
                17 => [ "EfficientIP-Last-Name",        "string" ],
                18 => [ "EfficientIP-Pseudonym",        "string" ],
                19 => [ "EfficientIP-IP-Host",          "string" ],
                20 => [ "EfficientIP-Email",            "string" ],
                32 => [ "EfficientIP-First-Login-Path", "string" ],
                33 => [ "EfficientIP-Maintainer-Group", "string" ],
                34 => [ "EfficientIP-Groups",           "string" ],
                35 => [ "EfficientIP-Admin-Group",      "string" ],
                64 => [ "EfficientIP-Extra-Blob",       "string" ],
            },
            2454 => {
                1   => [ "SG-Filter-Redirect-Gw",                  "ipaddr" ],
                10  => [ "SG-Accounting",                          "integer" ],
                12  => [ "SG-Orig-Name",                           "string" ],
                13  => [ "SG-Auth-Type",                           "integer" ],
                14  => [ "SG-Action",                              "integer" ],
                15  => [ "SG-SSC-Host",                            "ipaddr" ],
                16  => [ "SG-Service-Name",                        "string" ],
                17  => [ "SG-Personal-Site",                       "string" ],
                18  => [ "SG-Mac-Address",                         "string" ],
                19  => [ "SG-User-Group",                          "integer" ],
                20  => [ "SG-Max-Allowed-Sessions",                "integer" ],
                21  => [ "SG-Class",                               "string" ],
                22  => [ "SG-Eds-Enc-Key",                         "string" ],
                23  => [ "SG-Eds-Cookie",                          "string" ],
                24  => [ "SG-Original-Url-Prefix",                 "string" ],
                25  => [ "SG-Max-Allowed-Nodes",                   "integer" ],
                26  => [ "SG-Parent-User-Name",                    "string" ],
                27  => [ "SG-Node-Group",                          "integer" ],
                28  => [ "SG-Node-Default-Service",                "string" ],
                29  => [ "SG-Node-Dynamic-Service",                "string" ],
                30  => [ "SG-Dhcp-Server",                         "ipaddr" ],
                31  => [ "SG-Opt82-Relay-Remote-Id",               "string" ],
                32  => [ "SG-Discover-Action",                     "integer" ],
                33  => [ "SG-Release-Action",                      "integer" ],
                34  => [ "SG-Fixed-Ip-Address",                    "string" ],
                35  => [ "SG-Node-Fixed-Ip-Address",               "string" ],
                36  => [ "SG-Lease-Time",                          "integer" ],
                40  => [ "SG-Protocol-Type",                       "integer" ],
                50  => [ "SG-Service-Timeout",                     "integer" ],
                51  => [ "SG-Next-Service-Name",                   "string" ],
                52  => [ "SG-Auto-Service-Name",                   "string" ],
                53  => [ "SG-Auth-Source",                         "integer" ],
                54  => [ "SG-Data-Quota",                          "string" ],
                55  => [ "SG-Acl-Data-Quota",                      "string" ],
                56  => [ "SG-Service-Cache",                       "integer" ],
                57  => [ "SG-Data-Quota-Used",                     "string" ],
                58  => [ "SG-Acl-Data-Quota-Used",                 "string" ],
                59  => [ "SG-Acl-Packet-Quota",                    "string" ],
                60  => [ "SG-Acl-Packet-Quota-Used",               "string" ],
                61  => [ "SG-Roaming",                             "integer" ],
                62  => [ "SG-Acl-Eds-Action",                      "string" ],
                63  => [ "SG-Acl-Idle-Ignore",                     "string" ],
                65  => [ "SG-Service-Quota-Ignore",                "string" ],
                66  => [ "SG-Service-Acl-Quota-Ignore",            "string" ],
                67  => [ "SG-Service-Acl-Quota-Indication",        "string" ],
                70  => [ "SG-Remote-Filter-Redirect-Gw",           "string" ],
                71  => [ "SG-Next-Hop",                            "ipaddr" ],
                72  => [ "SG-Nip-Pipe-Next-Hop",                   "ipaddr" ],
                73  => [ "SG-Advertise-Protocol",                  "integer" ],
                74  => [ "SG-Forward-Addr",                        "ipaddr" ],
                75  => [ "SG-Acl-Tcp-Nat-Redirect",                "string" ],
                76  => [ "SG-Acl-Next-Hop",                        "string" ],
                80  => [ "SG-Tunnel-Id",                           "string" ],
                81  => [ "SG-L2tp-Tunnel-Password",                "string" ],
                82  => [ "SG-Ip-Address",                          "string" ],
                83  => [ "SG-Tunnel-Assignment-Id",                "integer" ],
                84  => [ "SG-Tunnel-Client-Ip-Address",            "ipaddr" ],
                85  => [ "SG-Nativeip",                            "integer" ],
                86  => [ "SG-Ip-Tunnel",                           "string" ],
                90  => [ "SG-Up-Mean-Rate",                        "string" ],
                91  => [ "SG-Down-Mean-Rate",                      "string" ],
                92  => [ "SG-Acl-Up-Mean-Rate",                    "string" ],
                93  => [ "SG-Acl-Down-Mean-Rate",                  "string" ],
                94  => [ "SG-Cos",                                 "string" ],
                95  => [ "SG-Acl-Priority",                        "string" ],
                96  => [ "SG-Burst-Size",                          "integer" ],
                100 => [ "SG-Ip-Primary",                          "ipaddr" ],
                101 => [ "SG-Ip-Secondary",                        "ipaddr" ],
                110 => [ "SG-Wimax-Reduced-Resources",             "integer" ],
                111 => [ "SG-Wimax-Acl-Schedule-Type",             "string" ],
                112 => [ "SG-Wimax-Acl-Min-Reserved-Traffic-Rate", "string" ],
                113 => [ "SG-Wimax-Acl-Maximum-Traffic-Burst",     "string" ],
                114 => [ "SG-Wimax-Acl-Tolerated-Jitter",          "string" ],
                115 => [ "SG-Wimax-Acl-Maximum-Latency",           "string" ],
                116 => [ "SG-Wimax-Acl-Unsolicited-Grant-Int",     "string" ],
                117 => [ "SG-Wimax-Acl-Sdu-Size",                  "string" ],
                118 => [ "SG-Wimax-Acl-Unsolicited-Polling-Int",   "string" ],
                119 => [ "SG-Wimax-MSK-Lifetime",                  "integer" ],
                120 => [ "SG-Wimax-DM-Action-Code",                "integer" ],
                121 => [ "SG-Wimax-Acl-ARQ-Enable",                "string" ],
                122 => [ "SG-Wimax-Bsid-Next-Hop",                 "ipaddr" ],
                123 => [ "SG-Wimax-Mobility-Features-Supported",   "integer" ],
                124 => [ "SG-Wimax-Node-Disconnect",               "integer" ],
                125 => [ "SG-Wimax-Service-Flow-Modification",     "integer" ],
                126 => [ "SG-Wimax-Service-Flow-Down",             "string" ],
                130 => [ "SG-Node-Acct-Username",                  "string" ],
            },
            2544 => {
                100 => [ "Adva-User-Level",     "integer" ],
                101 => [ "Adva-Auth-Level-NM",  "string" ],
                102 => [ "Adva-UUM-User-Level", "integer" ],
            },
            2620 => {
                229 => [ "CP-Gaia-User-Role",        "string" ],
                230 => [ "CP-Gaia-SuperUser-Access", "integer" ],
            },
            2636 => {
                1   => [ "Juniper-Local-User-Name",             "string" ],
                2   => [ "Juniper-Allow-Commands",              "string" ],
                3   => [ "Juniper-Deny-Commands",               "string" ],
                4   => [ "Juniper-Allow-Configuration",         "string" ],
                5   => [ "Juniper-Deny-Configuration",          "string" ],
                8   => [ "Juniper-Interactive-Command",         "string" ],
                9   => [ "Juniper-Configuration-Change",        "string" ],
                10  => [ "Juniper-User-Permissions",            "string" ],
                11  => [ "Juniper-Junosspace-Profiles",         "string" ],
                21  => [ "Juniper-CTP-Group",                   "integer" ],
                22  => [ "Juniper-CTPView-APP-Group",           "integer" ],
                23  => [ "Juniper-CTPView-OS-Group",            "integer" ],
                31  => [ "Juniper-Primary-Dns",                 "ipaddr" ],
                32  => [ "Juniper-Primary-Wins",                "ipaddr" ],
                33  => [ "Juniper-Secondary-Dns",               "ipaddr" ],
                34  => [ "Juniper-Secondary-Wins",              "ipaddr" ],
                35  => [ "Juniper-Interface-id",                "string" ],
                36  => [ "Juniper-Ip-Pool-Name",                "string" ],
                37  => [ "Juniper-Keep-Alive",                  "integer" ],
                38  => [ "Juniper-CoS-Traffic-Control-Profile", "string" ],
                39  => [ "Juniper-CoS-Parameter",               "string" ],
                40  => [ "Juniper-encapsulation-overhead",      "integer" ],
                41  => [ "Juniper-cell-overhead",               "integer" ],
                42  => [ "Juniper-tx-connect-speed",            "integer" ],
                43  => [ "Juniper-rx-connect-speed",            "integer" ],
                44  => [ "Juniper-Firewall-filter-name",        "string" ],
                45  => [ "Juniper-Policer-Parameter",           "string" ],
                46  => [ "Juniper-Local-Group-Name",            "string" ],
                47  => [ "Juniper-Local-Interface",             "string" ],
                48  => [ "Juniper-Switching-Filter",            "string" ],
                49  => [ "Juniper-VoIP-Vlan",                   "string" ],
                50  => [ "Juniper-CWA-Redirect",                "string" ],
                52  => [ "Juniper-AV-Pair",                     "string" ],
                55  => [ "Juniper-DHCPv4-Options",              "octets" ],
                207 => [ "Juniper-DHCPv6-Options",              "octets" ],
                208 => [ "Juniper-DHCPv4-Packet-Header",        "octets" ],
                209 => [ "Juniper-DHCPv6-Packet-Header",        "octets" ],
            },
            2637 => {
                1   => [ "CVX-Identification",            "string" ],
                2   => [ "CVX-VPOP-ID",                   "integer" ],
                3   => [ "CVX-SS7-Session-ID-Type",       "integer" ],
                4   => [ "CVX-Radius-Redirect",           "integer" ],
                5   => [ "CVX-IPSVC-AZNLVL",              "integer" ],
                6   => [ "CVX-IPSVC-Mask",                "integer" ],
                7   => [ "CVX-Multilink-Match-Info",      "integer" ],
                8   => [ "CVX-Multilink-Group-Number",    "integer" ],
                9   => [ "CVX-PPP-Log-Mask",              "integer" ],
                10  => [ "CVX-Modem-Begin-Modulation",    "string" ],
                11  => [ "CVX-Modem-End-Modulation",      "string" ],
                12  => [ "CVX-Modem-Error-Correction",    "string" ],
                13  => [ "CVX-Modem-Data-Compression",    "string" ],
                14  => [ "CVX-Modem-Tx-Packets",          "integer" ],
                15  => [ "CVX-Modem-ReTx-Packets",        "integer" ],
                16  => [ "CVX-Modem-SNR",                 "integer" ],
                17  => [ "CVX-Modem-Local-Retrains",      "integer" ],
                18  => [ "CVX-Modem-Remote-Retrains",     "integer" ],
                19  => [ "CVX-Modem-Local-Rate-Negs",     "integer" ],
                20  => [ "CVX-Modem-Remote-Rate-Negs",    "integer" ],
                21  => [ "CVX-Modem-Begin-Recv-Line-Lvl", "integer" ],
                22  => [ "CVX-Modem-End-Recv-Line-Lvl",   "integer" ],
                23  => [ "CVX-Terminate-Component",       "integer" ],
                24  => [ "CVX-Terminate-Cause",           "integer" ],
                25  => [ "CVX-Reject-Reason",             "integer" ],
                135 => [ "CVX-Primary-DNS",               "ipaddr" ],
                136 => [ "CVX-Secondary-DNS",             "ipaddr" ],
                137 => [ "CVX-Client-Assign-DNS",         "integer" ],
                152 => [ "CVX-Multicast-Rate-Limit",      "integer" ],
                155 => [ "CVX-Multicast-Client",          "integer" ],
                195 => [ "CVX-Disconnect-Cause",          "integer" ],
                197 => [ "CVX-Data-Rate",                 "integer" ],
                198 => [ "CVX-PreSession-Time",           "integer" ],
                218 => [ "CVX-Assign-IP-Pool",            "integer" ],
                235 => [ "CVX-Maximum-Channels",          "integer" ],
                242 => [ "CVX-Data-Filter",               "string" ],
                244 => [ "CVX-Idle-Limit",                "integer" ],
                253 => [ "CVX-PPP-Address",               "ipaddr" ],
                255 => [ "CVX-Xmit-Rate",                 "integer" ],
            },
            2979 => {
                1  => [ "Waverider-Grade-Of-Service",     "integer" ],
                2  => [ "Waverider-Priority-Enabled",     "integer" ],
                3  => [ "Waverider-Authentication-Key",   "string" ],
                5  => [ "Waverider-Current-Password",     "string" ],
                6  => [ "Waverider-New-Password",         "string" ],
                7  => [ "Waverider-Radio-Frequency",      "integer" ],
                8  => [ "Waverider-SNMP-Read-Community",  "string" ],
                9  => [ "Waverider-SNMP-Write-Community", "string" ],
                10 => [ "Waverider-SNMP-Trap-Server",     "string" ],
                11 => [ "Waverider-SNMP-Contact",         "string" ],
                12 => [ "Waverider-SNMP-Location",        "string" ],
                13 => [ "Waverider-SNMP-Name",            "string" ],
                14 => [ "Waverider-Max-Customers",        "integer" ],
                15 => [ "Waverider-Rf-Power",             "integer" ],
            },
            3041 => {
                5   => [ "AAT-Client-Primary-DNS",         "ipaddr" ],
                6   => [ "AAT-Client-Primary-WINS-NBNS",   "ipaddr" ],
                7   => [ "AAT-Client-Secondary-WINS-NBNS", "ipaddr" ],
                8   => [ "AAT-Client-Secondary-DNS",       "ipaddr" ],
                9   => [ "AAT-PPP-Address",                "ipaddr" ],
                10  => [ "AAT-PPP-Netmask",                "ipaddr" ],
                12  => [ "AAT-Primary-Home-Agent",         "string" ],
                13  => [ "AAT-Secondary-Home-Agent",       "string" ],
                14  => [ "AAT-Home-Agent-Password",        "string" ],
                15  => [ "AAT-Home-Network-Name",          "string" ],
                16  => [ "AAT-Home-Agent-UDP-Port",        "integer" ],
                17  => [ "AAT-IP-Direct",                  "ipaddr" ],
                18  => [ "AAT-FR-Direct",                  "integer" ],
                19  => [ "AAT-FR-Direct-Profile",          "string" ],
                20  => [ "AAT-FR-Direct-DLCI",             "integer" ],
                21  => [ "AAT-ATM-Direct",                 "string" ],
                22  => [ "AAT-IP-TOS",                     "integer" ],
                23  => [ "AAT-IP-TOS-Precedence",          "integer" ],
                24  => [ "AAT-IP-TOS-Apply-To",            "integer" ],
                27  => [ "AAT-MCast-Client",               "integer" ],
                28  => [ "AAT-Modem-Port-No",              "integer" ],
                29  => [ "AAT-Modem-Slot-No",              "integer" ],
                30  => [ "AAT-Modem-Shelf-No",             "integer" ],
                60  => [ "AAT-Filter",                     "string" ],
                61  => [ "AAT-Vrouter-Name",               "string" ],
                62  => [ "AAT-Require-Auth",               "integer" ],
                63  => [ "AAT-IP-Pool-Definition",         "string" ],
                64  => [ "AAT-Assign-IP-Pool",             "integer" ],
                65  => [ "AAT-Data-Filter",                "string" ],
                66  => [ "AAT-Source-IP-Check",            "integer" ],
                67  => [ "AAT-Modem-Answer-String",        "string" ],
                68  => [ "AAT-Auth-Type",                  "integer" ],
                70  => [ "AAT-Qos",                        "integer" ],
                71  => [ "AAT-Qoa",                        "integer" ],
                72  => [ "AAT-Client-Assign-DNS",          "integer" ],
                128 => [ "AAT-ATM-VPI",                    "integer" ],
                129 => [ "AAT-ATM-VCI",                    "integer" ],
                130 => [ "AAT-Input-Octets-Diff",          "integer" ],
                131 => [ "AAT-Output-Octets-Diff",         "integer" ],
                132 => [ "AAT-User-MAC-Address",           "string" ],
                133 => [ "AAT-ATM-Traffic-Profile",        "string" ],
            },
            3076 => {},
            3085 => {
                1 => [ "Cosine-Connection-Profile-Name", "string" ],
                2 => [ "Cosine-Enterprise-ID",           "string" ],
                3 => [ "Cosine-Address-Pool-Name",       "string" ],
                4 => [ "Cosine-DS-Byte",                 "integer" ],
                5 => [ "Cosine-VPI-VCI",                 "octets" ],
                6 => [ "Cosine-DLCI",                    "integer" ],
                7 => [ "Cosine-LNS-IP-Address",          "ipaddr" ],
                8 => [ "Cosine-CLI-User-Permission-ID",  "string" ],
            },
            3199 => {
                1 => [ "Shasta-User-Privilege",  "integer" ],
                2 => [ "Shasta-Service-Profile", "string" ],
                3 => [ "Shasta-VPN-Name",        "string" ],
            },
            3224 => {
                1   => [ "NS-Admin-Privilege",       "integer" ],
                2   => [ "NS-VSYS-Name",             "string" ],
                3   => [ "NS-User-Group",            "string" ],
                4   => [ "NS-Primary-DNS",           "ipaddr" ],
                5   => [ "NS-Secondary-DNS",         "ipaddr" ],
                6   => [ "NS-Primary-WINS",          "ipaddr" ],
                7   => [ "NS-Secondary-WINS",        "ipaddr" ],
                220 => [ "NS-NSM-User-Domain-Name",  "string" ],
                221 => [ "NS-NSM-User-Role-Mapping", "string" ],
            },
            3309 => {
                1  => [ "Nomadix-Bw-Up",             "integer" ],
                2  => [ "Nomadix-Bw-Down",           "integer" ],
                3  => [ "Nomadix-URL-Redirection",   "string" ],
                4  => [ "Nomadix-IP-Upsell",         "integer" ],
                5  => [ "Nomadix-Expiration",        "string" ],
                6  => [ "Nomadix-Subnet",            "string" ],
                7  => [ "Nomadix-MaxBytesUp",        "integer" ],
                8  => [ "Nomadix-MaxBytesDown",      "integer" ],
                9  => [ "Nomadix-EndofSession",      "integer" ],
                10 => [ "Nomadix-Logoff-URL",        "string" ],
                11 => [ "Nomadix-Net-VLAN",          "integer" ],
                12 => [ "Nomadix-Config-URL",        "string" ],
                13 => [ "Nomadix-Goodbye-URL",       "string" ],
                14 => [ "Nomadix-Qos-Policy",        "string" ],
                17 => [ "Nomadix-SMTP-Redirect",     "integer" ],
                18 => [ "Nomadix-Centralized-Mgmt",  "string" ],
                19 => [ "Nomadix-Group-Policy-Id",   "integer" ],
                20 => [ "Nomadix-Group-Bw-Max-Up",   "integer" ],
                21 => [ "Nomadix-Group-Bw-Max-Down", "integer" ],
            },
            3375 => {
                1  => [ "F5-LTM-User-Role",           "integer" ],
                2  => [ "F5-LTM-User-Role-Universal", "integer" ],
                3  => [ "F5-LTM-User-Partition",      "string" ],
                4  => [ "F5-LTM-User-Console",        "integer" ],
                5  => [ "F5-LTM-User-Shell",          "string" ],
                10 => [ "F5-LTM-User-Context-1",      "integer" ],
                11 => [ "F5-LTM-User-Context-2",      "integer" ],
                12 => [ "F5-LTM-User-Info-1",         "string" ],
                13 => [ "F5-LTM-User-Info-2",         "string" ],
                14 => [ "F5-LTM-Audit-Msg",           "string" ],
            },
            3551 => {
                1  => [ "ST-Acct-VC-Connection-Id", "string" ],
                2  => [ "ST-Service-Name",          "string" ],
                3  => [ "ST-Service-Domain",        "integer" ],
                4  => [ "ST-Policy-Name",           "string" ],
                5  => [ "ST-Primary-DNS-Server",    "ipaddr" ],
                6  => [ "ST-Secondary-DNS-Server",  "ipaddr" ],
                7  => [ "ST-Primary-NBNS-Server",   "ipaddr" ],
                8  => [ "ST-Secondary-NBNS-Server", "ipaddr" ],
                9  => [ "ST-Physical-Port",         "integer" ],
                10 => [ "ST-Physical-Slot",         "integer" ],
                11 => [ "ST-Virtual-Path-ID",       "integer" ],
                12 => [ "ST-Virtual-Circuit-ID",    "integer" ],
                13 => [ "ST-Realm-Name",            "string" ],
                14 => [ "ST-IPSec-Pfs-Group",       "integer" ],
                15 => [ "ST-IPSec-Client-Firewall", "integer" ],
                16 => [ "ST-IPSec-Client-Subnet",   "string" ],
            },
            3561 => {
                1   => [ "ADSL-Agent-Circuit-Id",                  "octets" ],
                2   => [ "ADSL-Agent-Remote-Id",                   "octets" ],
                129 => [ "Actual-Data-Rate-Upstream",              "integer" ],
                130 => [ "Actual-Data-Rate-Downstream",            "integer" ],
                131 => [ "Minimum-Data-Rate-Upstream",             "integer" ],
                132 => [ "Minimum-Data-Rate-Downstream",           "integer" ],
                133 => [ "Attainable-Data-Rate-Upstream",          "integer" ],
                134 => [ "Attainable-Data-Rate-Downstream",        "integer" ],
                135 => [ "Maximum-Data-Rate-Upstream",             "integer" ],
                136 => [ "Maximum-Data-Rate-Downstream",           "integer" ],
                137 => [ "Minimum-Data-Rate-Upstream-Low-Power",   "integer" ],
                138 => [ "Minimum-Data-Rate-Downstream-Low-Power", "integer" ],
                139 => [ "Maximum-Interleaving-Delay-Upstream",    "integer" ],
                140 => [ "Actual-Interleaving-Delay-Upstream",     "integer" ],
                141 => [ "Maximum-Interleaving-Delay-Downstream",  "integer" ],
                142 => [ "Actual-Interleaving-Delay-Downstream",   "integer" ],
                144 => [ "Access-Loop-Encapsulation",              "octets" ],
                254 => [ "IWF-Session",                            "octets" ],
                255 => [ "ADSL-Forum-Gateway-Manufacturer-OUI",    "octets" ],
            },
            3902 => {
                1   => [ "ZTE-Client-DNS-Pri",              "string" ],
                2   => [ "ZTE-Client-DNS-Sec",              "string" ],
                4   => [ "ZTE-Context-Name",                "string" ],
                21  => [ "ZTE-Tunnel-Max-Sessions",         "integer" ],
                22  => [ "ZTE-Tunnel-Max-Tunnels",          "integer" ],
                24  => [ "ZTE-Tunnel-Window",               "integer" ],
                25  => [ "ZTE-Tunnel-Retransmit",           "integer" ],
                26  => [ "ZTE-Tunnel-Cmd-Timeout",          "integer" ],
                27  => [ "ZTE-PPPOE-URL",                   "string" ],
                28  => [ "ZTE-PPPOE-MOTM",                  "string" ],
                31  => [ "ZTE-Tunnel-Algorithm",            "integer" ],
                32  => [ "ZTE-Tunnel-Deadtime",             "integer" ],
                33  => [ "ZTE-Mcast-Send",                  "integer" ],
                34  => [ "ZTE-Mcast-Receive",               "integer" ],
                35  => [ "ZTE-Mcast-MaxGroups",             "integer" ],
                74  => [ "ZTE-Access-Type",                 "integer" ],
                81  => [ "ZTE-QoS-Type",                    "integer" ],
                82  => [ "ZTE-QoS-Profile-Down",            "string" ],
                83  => [ "ZTE-Rate-Ctrl-SCR-Down",          "integer" ],
                84  => [ "ZTE-Rate-Ctrl-Burst-Down",        "integer" ],
                86  => [ "ZTE-Rate-Ctrl-PCR",               "integer" ],
                88  => [ "ZTE-TCP-Syn-Rate",                "integer" ],
                89  => [ "ZTE-Rate-Ctrl-SCR-Up",            "integer" ],
                90  => [ "ZTE-Priority-Level",              "integer" ],
                91  => [ "ZTE-Rate-Ctrl-Burst-Up",          "integer" ],
                92  => [ "ZTE-Rate-Ctrl-Burst-Max-Down",    "integer" ],
                93  => [ "ZTE-Rate-Ctrl-Burst-Max-Up",      "integer" ],
                94  => [ "ZTE-QOS-Profile-Up",              "string" ],
                95  => [ "ZTE-TCP-Limit-Num",               "integer" ],
                96  => [ "ZTE-TCP-Limit-Mode",              "integer" ],
                97  => [ "ZTE-IGMP-Service-Profile-Num",    "integer" ],
                101 => [ "ZTE-PPP-Sservice-Type",           "integer" ],
                104 => [ "ZTE-SW-Privilege",                "integer" ],
                151 => [ "ZTE-Access-Domain",               "string" ],
                190 => [ "ZTE-VPN-ID",                      "string" ],
                191 => [ "ZTE_Rate-Bust-DPIR",              "integer" ],
                192 => [ "ZTE_Rate-Bust-UPIR",              "integer" ],
                202 => [ "ZTE-Rate-Ctrl-PBS-Down",          "integer" ],
                203 => [ "ZTE-Rate-Ctrl-PBS-Up",            "integer" ],
                228 => [ "ZTE-Rate-Ctrl-SCR-Up-v6",         "integer" ],
                229 => [ "ZTE-Rate-Ctrl-Burst-Up-v6",       "integer" ],
                230 => [ "ZTE-Rate-Ctrl-Burst-Max-Up-v6",   "integer" ],
                231 => [ "ZTE-Rate-Ctrl-PBS-Up-v6",         "integer" ],
                232 => [ "ZTE-QoS-Profile-Up-v6",           "string" ],
                233 => [ "ZTE-Rate-Ctrl-SCR-Down-v6",       "integer" ],
                234 => [ "ZTE-Rate-Ctrl-Burst-Down-v6",     "integer" ],
                235 => [ "ZTE-Rate-Ctrl-Burst-Max-Down-v6", "integer" ],
                236 => [ "ZTE-Rate-Ctrl-PBS-Down-v6",       "integer" ],
                237 => [ "ZTE-QoS-Profile-Down-v6",         "string" ],
            },
            4329 => {
                1  => [ "Siemens-URL-Redirection", "string" ],
                2  => [ "Siemens-AP-Name",         "string" ],
                3  => [ "Siemens-AP-Serial",       "string" ],
                4  => [ "Siemens-VNS-Name",        "string" ],
                5  => [ "Siemens-SSID",            "string" ],
                6  => [ "Siemens-BSS-MAC",         "string" ],
                7  => [ "Siemens-Policy-Name",     "string" ],
                8  => [ "Siemens-Topology-Name",   "string" ],
                9  => [ "Siemens-Ingress-RC-Name", "string" ],
                10 => [ "Siemens-Egress-RC-Name",  "string" ],
            },
            4363 => {
                1 => [ "NN-Data-Rate",         "integer" ],
                2 => [ "NN-Data-Rate-Ceiling", "integer" ],
                3 => [ "NN-Homenode",          "ipaddr" ],
                4 => [ "NN-Homeservice",       "ipaddr" ],
                5 => [ "NN-Homeservice-Name",  "string" ],
            },
            4453 => {
                238 => [ "Infonet-Proxy",              "string" ],
                239 => [ "Infonet-Config",             "string" ],
                240 => [ "Infonet-MCS-Country",        "string" ],
                241 => [ "Infonet-MCS-Region",         "string" ],
                242 => [ "Infonet-MCS-Off-Peak",       "string" ],
                243 => [ "Infonet-MCS-Overflow",       "string" ],
                244 => [ "Infonet-MCS-Port",           "string" ],
                245 => [ "Infonet-MCS-Port-Count",     "string" ],
                246 => [ "Infonet-Random-IP-Pool",     "string" ],
                247 => [ "Infonet-Account-Number",     "string" ],
                248 => [ "Infonet-Type",               "string" ],
                249 => [ "Infonet-Realm-Type",         "string" ],
                250 => [ "Infonet-LoginHost-Dest",     "string" ],
                251 => [ "Infonet-Tunnel-Decision-IP", "string" ],
                252 => [ "Infonet-Pool-Request",       "string" ],
                254 => [ "Infonet-Surcharge-Type",     "integer" ],
                255 => [ "Infonet-NAS-Location",       "string" ],
            },
            4491 => {
                "0"  => [ "CableLabs-Reserved",                     "octets" ],
                "1"  => [ "CableLabs-Event-Message",                "octets" ],
                "3"  => [ "CableLabs-MTA-Endpoint-Name",            "string" ],
                "4"  => [ "CableLabs-Calling-Party-Number",         "string" ],
                "5"  => [ "CableLabs-Called-Party-Number",          "string" ],
                "6"  => [ "CableLabs-Database-ID",                  "string" ],
                "7"  => [ "CableLabs-Query-Type",                   "integer" ],
                "9"  => [ "CableLabs-Returned-Number",              "string" ],
                "11" => [ "CableLabs-Call-Termination-Cause",       "octets" ],
                "13" => [ "CableLabs-Related-Call-Billing-Crl-ID",  "octets" ],
                "14" => [ "CableLabs-First-Call-Calling-Party-Num", "string" ],
                "15" => [ "CableLabs-Second-Call-Calling-Party-Num", "string" ],
                "16" => [ "CableLabs-Charge-Number",                 "string" ],
                "17" => [ "CableLabs-Forwarded-Number",              "string" ],
                "18" => [ "CableLabs-Service-Name",                  "string" ],
                "20" => [ "CableLabs-Intl-Code",                     "string" ],
                "21" => [ "CableLabs-Dial-Around-Code",              "string" ],
                "22" => [ "CableLabs-Location-Routing-Number",       "string" ],
                "23" => [ "CableLabs-Carrier-Identification-Code",   "string" ],
                "24" => [ "CableLabs-Trunk-Group-ID",                "octets" ],
                "25" => [ "CableLabs-Routing-Number",                "string" ],
                "26" => [ "CableLabs-MTA-UDP-Portnum",              "integer" ],
                "29" => [ "CableLabs-Channel-State",                "integer" ],
                "30" => [ "CableLabs-SF-ID",                        "integer" ],
                "31" => [ "CableLabs-Error-Description",            "string" ],
                "32" => [ "CableLabs-QoS-Descriptor",               "octets" ],
                "37" => [ "CableLabs-Direction-indicator",          "integer" ],
                "38" => [ "CableLabs-Time-Adjustment",              "octets" ],
                "39" => [ "CableLabs-SDP-Upstream",                 "string" ],
                "40" => [ "CableLabs-SDP-Downstream",               "string" ],
                "41" => [ "CableLabs-User-Input",                   "string" ],
                "42" => [ "CableLabs-Translation-Input",            "string" ],
                "43" => [ "CableLabs-Redirected-From-Info",         "octets" ],
                "44" => [ "CableLabs-Electronic-Surveillance-Ind",  "octets" ],
                "45" => [ "CableLabs-Redirected-From-Party-Number", "string" ],
                "46" => [ "CableLabs-Redirected-To-Party-Number",   "string" ],
                "47" => [ "CableLabs-El-Surveillance-DF-Security",  "octets" ],
                "48" => [ "CableLabs-CCC-ID",                       "octets" ],
                "49" => [ "CableLabs-Financial-Entity-ID",          "string" ],
                "50" => [ "CableLabs-Flow-Direction",               "integer" ],
                "51" => [ "CableLabs-Signal-Type",                  "integer" ],
                "52" => [ "CableLabs-Alerting-Signal",              "integer" ],
                "53" => [ "CableLabs-Subject-Audible-Signal",       "integer" ],
                "54" => [ "CableLabs-Terminal-Display-Info",        "octets" ],
                "55" => [ "CableLabs-Switch-Hook-Flash",            "string" ],
                "56" => [ "CableLabs-Dialed-Digits",                "string" ],
                "57" => [ "CableLabs-Misc-Signaling-Information",   "string" ],
                "61" => [ "CableLabs-AM-Opaque-Data",               "integer" ],
                "62" => [ "CableLabs-Subscriber-ID",                "integer" ],
                "63" => [ "CableLabs-Volume-Usage-Limit",           "integer" ],
                "64" => [ "CableLabs-Gate-Usage-Info",              "integer" ],
                "65" => [ "CableLabs-Element-Requesting-QoS",       "integer" ],
                "66" => [ "CableLabs-QoS-Release-Reason",           "integer" ],
                "67" => [ "CableLabs-Policy-Denied-Reason",         "integer" ],
                "68" => [ "CableLabs-Policy-Deleted-Reason",        "integer" ],
                "69" => [ "CableLabs-Policy-Update-Reason",         "integer" ],
                "70" => [ "CableLabs-Policy-Decision-Status",       "integer" ],
                "71" => [ "CableLabs-Application-Manager-ID",       "integer" ],
                "72" => [ "CableLabs-Time-Usage-Limit",             "integer" ],
                "73" => [ "CableLabs-Gate-Time-Info",               "integer" ],
                "80" => [ "CableLabs-Account-Code",                 "string" ],
                "81" => [ "CableLabs-Authorization-Code",           "string" ],
            },
            4735 => {
                "0"  => [ "Prosoft-Home-Agent-Address",       "ipaddr" ],
                "1"  => [ "Prosoft-Default-Gateway",          "ipaddr" ],
                "2"  => [ "Prosoft-Primary-DNS",              "ipaddr" ],
                "3"  => [ "Prosoft-Secondary-DNS",            "ipaddr" ],
                "4"  => [ "Prosoft-Security-Parameter-Index", "integer" ],
                "5"  => [ "Prosoft-Security-Key",             "string" ],
                "7"  => [ "Prosoft-MAC-Address",              "string" ],
                "8"  => [ "Prosoft-Authentication-Reason",    "integer" ],
                "9"  => [ "Prosoft-ATM-Interface",            "integer" ],
                "10" => [ "Prosoft-ATM-VPI",                  "integer" ],
                "11" => [ "Prosoft-ATM-VCI",                  "integer" ],
                "12" => [ "Prosoft-RSC-Identifier",           "string" ],
                "13" => [ "Prosoft-NPM-Identifier",           "string" ],
                "14" => [ "Prosoft-NPM-IP",                   "string" ],
                "15" => [ "Prosoft-Sector-ID",                "string" ],
                "16" => [ "Prosoft-Auth-Role",                "integer" ],
            },
            4846 => {
                2     => [ "Lucent-Max-Shared-Users",               "integer" ],
                3     => [ "Lucent-IP-DSCP",                        "integer" ],
                4     => [ "Lucent-X25-X121-Source-Address",        "string" ],
                5     => [ "Lucent-PPP-Circuit",                    "integer" ],
                6     => [ "Lucent-PPP-Circuit-Name",               "string" ],
                7     => [ "Lucent-UU-Info",                        "string" ],
                8     => [ "Lucent-User-Priority",                  "integer" ],
                9     => [ "Lucent-CIR-Timer",                      "integer" ],
                10    => [ "Lucent-FR-08-Mode",                     "integer" ],
                11    => [ "Lucent-Destination-NAS-Port",           "integer" ],
                12    => [ "Lucent-FR-SVC-Addr",                    "string" ],
                13    => [ "Lucent-NAS-Port-Format",                "integer" ],
                14    => [ "Lucent-ATM-Fault-Management",           "integer" ],
                15    => [ "Lucent-ATM-Loopback-Cell-Loss",         "integer" ],
                16    => [ "Lucent-Ckt-Type",                       "integer" ],
                17    => [ "Lucent-SVC-Enabled",                    "integer" ],
                18    => [ "Lucent-Session-Type",                   "integer" ],
                19    => [ "Lucent-H323-Gatekeeper",                "ipaddr" ],
                20    => [ "Lucent-Global-Call-Id",                 "string" ],
                21    => [ "Lucent-H323-Conference-Id",             "integer" ],
                22    => [ "Lucent-H323-Destination-NAS-ID",        "ipaddr" ],
                23    => [ "Lucent-H323-Dialed-Time",               "integer" ],
                24    => [ "Lucent-Dialed-Number",                  "string" ],
                25    => [ "Lucent-Inter-Arrival-Jitter",           "integer" ],
                26    => [ "Lucent-Dropped-Octets",                 "integer" ],
                27    => [ "Lucent-Dropped-Packets",                "integer" ],
                28    => [ "Lucent-Auth-Delay",                     "integer" ],
                29    => [ "Lucent-X25-Pad-X3-Profile",             "integer" ],
                30    => [ "Lucent-X25-Pad-X3-Parameters",          "string" ],
                31    => [ "Lucent-Tunnel-VRouter-Name",            "string" ],
                32    => [ "Lucent-X25-Reverse-Charging",           "integer" ],
                33    => [ "Lucent-X25-Nui-Prompt",                 "string" ],
                34    => [ "Lucent-X25-Nui-Password-Prompt",        "string" ],
                35    => [ "Lucent-X25-Cug",                        "string" ],
                36    => [ "Lucent-X25-Pad-Alias-1",                "string" ],
                37    => [ "Lucent-X25-Pad-Alias-2",                "string" ],
                38    => [ "Lucent-X25-Pad-Alias-3",                "string" ],
                39    => [ "Lucent-X25-X121-Address",               "string" ],
                40    => [ "Lucent-X25-Nui",                        "string" ],
                41    => [ "Lucent-X25-Rpoa",                       "string" ],
                42    => [ "Lucent-X25-Pad-Prompt",                 "string" ],
                43    => [ "Lucent-X25-Pad-Banner",                 "string" ],
                44    => [ "Lucent-X25-Profile-Name",               "string" ],
                45    => [ "Lucent-Recv-Name",                      "string" ],
                46    => [ "Lucent-Bi-Directional-Auth",            "integer" ],
                47    => [ "Lucent-MTU",                            "integer" ],
                48    => [ "Lucent-Call-Direction",                 "integer" ],
                49    => [ "Lucent-Service-Type",                   "integer" ],
                50    => [ "Lucent-Filter-Required",                "integer" ],
                51    => [ "Lucent-Traffic-Shaper",                 "integer" ],
                52    => [ "Lucent-Access-Intercept-LEA",           "string" ],
                53    => [ "Lucent-Access-Intercept-Log",           "string" ],
                54    => [ "Lucent-Private-Route-Table-ID",         "string" ],
                55    => [ "Lucent-Private-Route-Required",         "integer" ],
                56    => [ "Lucent-Cache-Refresh",                  "integer" ],
                57    => [ "Lucent-Cache-Time",                     "integer" ],
                58    => [ "Lucent-Egress-Enabled",                 "integer" ],
                59    => [ "Lucent-QOS-Upstream",                   "string" ],
                60    => [ "Lucent-QOS-Downstream",                 "string" ],
                61    => [ "Lucent-ATM-Connect-Vpi",                "integer" ],
                62    => [ "Lucent-ATM-Connect-Vci",                "integer" ],
                63    => [ "Lucent-ATM-Connect-Group",              "integer" ],
                64    => [ "Lucent-ATM-Group",                      "integer" ],
                65    => [ "Lucent-IPX-Header-Compression",         "integer" ],
                66    => [ "Lucent-Calling-Id-Type-Of-Number",      "integer" ],
                67    => [ "Lucent-Calling-Id-Numbering-Plan",      "integer" ],
                68    => [ "Lucent-Calling-Id-Presentation",        "integer" ],
                69    => [ "Lucent-Calling-Id-Screening",           "integer" ],
                70    => [ "Lucent-BIR-Enable",                     "integer" ],
                71    => [ "Lucent-BIR-Proxy",                      "integer" ],
                72    => [ "Lucent-BIR-Bridge-Group",               "integer" ],
                73    => [ "Lucent-IPSEC-Profile",                  "string" ],
                74    => [ "Lucent-PPPoE-Enable",                   "integer" ],
                75    => [ "Lucent-Bridge-Non-PPPoE",               "integer" ],
                76    => [ "Lucent-ATM-Direct",                     "integer" ],
                77    => [ "Lucent-ATM-Direct-Profile",             "string" ],
                78    => [ "Lucent-Client-Primary-WINS",            "ipaddr" ],
                79    => [ "Lucent-Client-Secondary-WINS",          "ipaddr" ],
                80    => [ "Lucent-Client-Assign-WINS",             "integer" ],
                81    => [ "Lucent-Auth-Type",                      "integer" ],
                82    => [ "Lucent-Port-Redir-Protocol",            "integer" ],
                83    => [ "Lucent-Port-Redir-Portnum",             "integer" ],
                84    => [ "Lucent-Port-Redir-Server",              "ipaddr" ],
                85    => [ "Lucent-IP-Pool-Chaining",               "integer" ],
                86    => [ "Lucent-Owner-IP-Addr",                  "ipaddr" ],
                87    => [ "Lucent-IP-TOS",                         "integer" ],
                88    => [ "Lucent-IP-TOS-Precedence",              "integer" ],
                89    => [ "Lucent-IP-TOS-Apply-To",                "integer" ],
                90    => [ "Lucent-Filter",                         "string" ],
                91    => [ "Lucent-Telnet-Profile",                 "string" ],
                92    => [ "Lucent-Dsl-Rate-Type",                  "integer" ],
                93    => [ "Lucent-Redirect-Number",                "string" ],
                94    => [ "Lucent-ATM-Vpi",                        "integer" ],
                95    => [ "Lucent-ATM-Vci",                        "integer" ],
                96    => [ "Lucent-Source-IP-Check",                "integer" ],
                97    => [ "Lucent-Dsl-Rate-Mode",                  "integer" ],
                98    => [ "Lucent-Dsl-Upstream-Limit",             "integer" ],
                99    => [ "Lucent-Dsl-Downstream-Limit",           "integer" ],
                100   => [ "Lucent-Dsl-CIR-Recv-Limit",             "integer" ],
                101   => [ "Lucent-Dsl-CIR-Xmit-Limit",             "integer" ],
                102   => [ "Lucent-VRouter-Name",                   "string" ],
                103   => [ "Lucent-Source-Auth",                    "string" ],
                104   => [ "Lucent-Private-Route",                  "string" ],
                105   => [ "Lucent-Numbering-Plan-ID",              "integer" ],
                106   => [ "Lucent-FR-Link-Status-DLCI",            "integer" ],
                107   => [ "Lucent-Calling-Subaddress",             "string" ],
                108   => [ "Lucent-Callback-Delay",                 "integer" ],
                109   => [ "Lucent-Endpoint-Disc",                  "octets" ],
                110   => [ "Lucent-Remote-FW",                      "string" ],
                111   => [ "Lucent-Multicast-GLeave-Delay",         "integer" ],
                112   => [ "Lucent-CBCP-Enable",                    "integer" ],
                113   => [ "Lucent-CBCP-Mode",                      "integer" ],
                114   => [ "Lucent-CBCP-Delay",                     "integer" ],
                115   => [ "Lucent-CBCP-Trunk-Group",               "integer" ],
                116   => [ "Lucent-Appletalk-Route",                "string" ],
                117   => [ "Lucent-Appletalk-Peer-Mode",            "integer" ],
                118   => [ "Lucent-Route-Appletalk",                "integer" ],
                119   => [ "Lucent-FCP-Parameter",                  "string" ],
                120   => [ "Lucent-Modem-PortNo",                   "integer" ],
                121   => [ "Lucent-Modem-SlotNo",                   "integer" ],
                122   => [ "Lucent-Modem-ShelfNo",                  "integer" ],
                123   => [ "Lucent-Call-Attempt-Limit",             "integer" ],
                124   => [ "Lucent-Call-Block-Duration",            "integer" ],
                125   => [ "Lucent-Maximum-Call-Duration",          "integer" ],
                126   => [ "Lucent-Route-Preference",               "integer" ],
                127   => [ "Lucent-Tunneling-Protocol",             "integer" ],
                128   => [ "Lucent-Shared-Profile-Enable",          "integer" ],
                129   => [ "Lucent-Primary-Home-Agent",             "string" ],
                130   => [ "Lucent-Secondary-Home-Agent",           "string" ],
                131   => [ "Lucent-Dialout-Allowed",                "integer" ],
                132   => [ "Lucent-Client-Gateway",                 "ipaddr" ],
                133   => [ "Lucent-BACP-Enable",                    "integer" ],
                134   => [ "Lucent-DHCP-Maximum-Leases",            "integer" ],
                135   => [ "Lucent-Client-Primary-DNS",             "ipaddr" ],
                136   => [ "Lucent-Client-Secondary-DNS",           "ipaddr" ],
                137   => [ "Lucent-Client-Assign-DNS",              "integer" ],
                138   => [ "Lucent-User-Acct-Type",                 "integer" ],
                139   => [ "Lucent-User-Acct-Host",                 "ipaddr" ],
                140   => [ "Lucent-User-Acct-Port",                 "integer" ],
                141   => [ "Lucent-User-Acct-Key",                  "string" ],
                142   => [ "Lucent-User-Acct-Base",                 "integer" ],
                143   => [ "Lucent-User-Acct-Time",                 "integer" ],
                144   => [ "Lucent-Assign-IP-Client",               "ipaddr" ],
                145   => [ "Lucent-Assign-IP-Server",               "ipaddr" ],
                146   => [ "Lucent-Assign-IP-Global-Pool",          "string" ],
                147   => [ "Lucent-DHCP-Reply",                     "integer" ],
                148   => [ "Lucent-DHCP-Pool-Number",               "integer" ],
                149   => [ "Lucent-Expect-Callback",                "integer" ],
                150   => [ "Lucent-Event-Type",                     "integer" ],
                151   => [ "Lucent-Session-Svr-Key",                "string" ],
                152   => [ "Lucent-Multicast-Rate-Limit",           "integer" ],
                153   => [ "Lucent-IF-Netmask",                     "ipaddr" ],
                154   => [ "Lucent-Remote-Addr",                    "ipaddr" ],
                155   => [ "Lucent-Multicast-Client",               "integer" ],
                156   => [ "Lucent-FR-Circuit-Name",                "string" ],
                157   => [ "Lucent-FR-LinkUp",                      "integer" ],
                158   => [ "Lucent-FR-Nailed-Grp",                  "integer" ],
                159   => [ "Lucent-FR-Type",                        "integer" ],
                160   => [ "Lucent-FR-Link-Mgt",                    "integer" ],
                161   => [ "Lucent-FR-N391",                        "integer" ],
                162   => [ "Lucent-FR-DCE-N392",                    "integer" ],
                163   => [ "Lucent-FR-DTE-N392",                    "integer" ],
                164   => [ "Lucent-FR-DCE-N393",                    "integer" ],
                165   => [ "Lucent-FR-DTE-N393",                    "integer" ],
                166   => [ "Lucent-FR-T391",                        "integer" ],
                167   => [ "Lucent-FR-T392",                        "integer" ],
                168   => [ "Lucent-Bridge-Address",                 "string" ],
                169   => [ "Lucent-TS-Idle-Limit",                  "integer" ],
                170   => [ "Lucent-TS-Idle-Mode",                   "integer" ],
                171   => [ "Lucent-DBA-Monitor",                    "integer" ],
                172   => [ "Lucent-Base-Channel-Count",             "integer" ],
                173   => [ "Lucent-Minimum-Channels",               "integer" ],
                174   => [ "Lucent-IPX-Route",                      "string" ],
                175   => [ "Lucent-FT1-Caller",                     "integer" ],
                176   => [ "Lucent-Backup",                         "string" ],
                177   => [ "Lucent-Call-Type",                      "integer" ],
                178   => [ "Lucent-Group",                          "string" ],
                179   => [ "Lucent-FR-DLCI",                        "integer" ],
                180   => [ "Lucent-FR-Profile-Name",                "string" ],
                181   => [ "Lucent-Ara-PW",                         "string" ],
                182   => [ "Lucent-IPX-Node-Addr",                  "string" ],
                183   => [ "Lucent-Home-Agent-IP-Addr",             "ipaddr" ],
                184   => [ "Lucent-Home-Agent-Password",            "string" ],
                185   => [ "Lucent-Home-Network-Name",              "string" ],
                186   => [ "Lucent-Home-Agent-UDP-Port",            "integer" ],
                187   => [ "Lucent-Multilink-ID",                   "integer" ],
                188   => [ "Lucent-Num-In-Multilink",               "integer" ],
                189   => [ "Lucent-First-Dest",                     "ipaddr" ],
                190   => [ "Lucent-Pre-Input-Octets",               "integer" ],
                191   => [ "Lucent-Pre-Output-Octets",              "integer" ],
                192   => [ "Lucent-Pre-Input-Packets",              "integer" ],
                193   => [ "Lucent-Pre-Output-Packets",             "integer" ],
                194   => [ "Lucent-Maximum-Time",                   "integer" ],
                195   => [ "Lucent-Disconnect-Cause",               "integer" ],
                196   => [ "Lucent-Connect-Progress",               "integer" ],
                197   => [ "Lucent-Data-Rate",                      "integer" ],
                198   => [ "Lucent-PreSession-Time",                "integer" ],
                199   => [ "Lucent-Token-Idle",                     "integer" ],
                200   => [ "Lucent-Token-Immediate",                "integer" ],
                201   => [ "Lucent-Require-Auth",                   "integer" ],
                202   => [ "Lucent-Number-Sessions",                "string" ],
                203   => [ "Lucent-Authen-Alias",                   "string" ],
                204   => [ "Lucent-Token-Expiry",                   "integer" ],
                205   => [ "Lucent-Menu-Selector",                  "string" ],
                206   => [ "Lucent-Menu-Item",                      "string" ],
                207   => [ "Lucent-PW-Warntime",                    "integer" ],
                208   => [ "Lucent-PW-Lifetime",                    "integer" ],
                209   => [ "Lucent-IP-Direct",                      "ipaddr" ],
                210   => [ "Lucent-PPP-VJ-Slot-Comp",               "integer" ],
                211   => [ "Lucent-PPP-VJ-1172",                    "integer" ],
                212   => [ "Lucent-PPP-Async-Map",                  "integer" ],
                213   => [ "Lucent-Third-Prompt",                   "string" ],
                214   => [ "Lucent-Send-Secret",                    "string" ],
                215   => [ "Lucent-Receive-Secret",                 "string" ],
                216   => [ "Lucent-IPX-Peer-Mode",                  "integer" ],
                217   => [ "Lucent-IP-Pool-Definition",             "string" ],
                218   => [ "Lucent-Assign-IP-Pool",                 "integer" ],
                219   => [ "Lucent-FR-Direct",                      "integer" ],
                220   => [ "Lucent-FR-Direct-Profile",              "string" ],
                221   => [ "Lucent-FR-Direct-DLCI",                 "integer" ],
                222   => [ "Lucent-Handle-IPX",                     "integer" ],
                223   => [ "Lucent-Netware-timeout",                "integer" ],
                224   => [ "Lucent-IPX-Alias",                      "integer" ],
                225   => [ "Lucent-Metric",                         "integer" ],
                226   => [ "Lucent-PRI-Number-Type",                "integer" ],
                227   => [ "Lucent-Dial-Number",                    "string" ],
                228   => [ "Lucent-Route-IP",                       "integer" ],
                229   => [ "Lucent-Route-IPX",                      "integer" ],
                230   => [ "Lucent-Bridge",                         "integer" ],
                231   => [ "Lucent-Send-Auth",                      "integer" ],
                232   => [ "Lucent-Send-Passwd",                    "string" ],
                233   => [ "Lucent-Link-Compression",               "integer" ],
                234   => [ "Lucent-Target-Util",                    "integer" ],
                235   => [ "Lucent-Maximum-Channels",               "integer" ],
                236   => [ "Lucent-Inc-Channel-Count",              "integer" ],
                237   => [ "Lucent-Dec-Channel-Count",              "integer" ],
                238   => [ "Lucent-Seconds-Of-History",             "integer" ],
                239   => [ "Lucent-History-Weigh-Type",             "integer" ],
                240   => [ "Lucent-Add-Seconds",                    "integer" ],
                241   => [ "Lucent-Remove-Seconds",                 "integer" ],
                242   => [ "Lucent-Data-Filter",                    "abinary" ],
                243   => [ "Lucent-Call-Filter",                    "abinary" ],
                244   => [ "Lucent-Idle-Limit",                     "integer" ],
                245   => [ "Lucent-Preempt-Limit",                  "integer" ],
                246   => [ "Lucent-Callback",                       "integer" ],
                247   => [ "Lucent-Data-Svc",                       "integer" ],
                248   => [ "Lucent-Force-56",                       "integer" ],
                249   => [ "Lucent-Billing-Number",                 "string" ],
                250   => [ "Lucent-Call-By-Call",                   "integer" ],
                251   => [ "Lucent-Transit-Number",                 "string" ],
                252   => [ "Lucent-Host-Info",                      "string" ],
                253   => [ "Lucent-PPP-Address",                    "ipaddr" ],
                254   => [ "Lucent-MPP-Idle-Percent",               "integer" ],
                255   => [ "Lucent-Xmit-Rate",                      "integer" ],
                256   => [ "Lucent-Fr05-Traffic-Shaper",            "integer" ],
                257   => [ "Lucent-Fr05-Vpi",                       "integer" ],
                258   => [ "Lucent-Fr05-Vci",                       "integer" ],
                259   => [ "Lucent-Fr05-Enabled",                   "integer" ],
                260   => [ "Lucent-Tunnel-Auth-Type",               "octets" ],
                261   => [ "Lucent-MOH-Timeout",                    "integer" ],
                262   => [ "Lucent-ATM-Circuit-Name",               "string" ],
                263   => [ "Lucent-Priority-For-PPP",               "integer" ],
                264   => [ "Lucent-Max-RTP-Delay",                  "integer" ],
                265   => [ "Lucent-RTP-Port-Range",                 "string" ],
                266   => [ "Lucent-TOS-Copying",                    "integer" ],
                267   => [ "Lucent-Packet-Classification",          "integer" ],
                268   => [ "Lucent-No-High-Prio-Pkt-Duratio",       "integer" ],
                269   => [ "Lucent-AT-Answer-String",               "string" ],
                270   => [ "Lucent-IP-OUTGOING-TOS",                "integer" ],
                271   => [ "Lucent-IP-OUTGOING-TOS-Precedence",     "integer" ],
                272   => [ "Lucent-IP-OUTGOING-DSCP",               "integer" ],
                273   => [ "Lucent-TermSrv-Login-Prompt",           "string" ],
                274   => [ "Lucent-Multicast-Service-Profile-Name", "string" ],
                275   => [ "Lucent-Multicast-Max-Groups",           "integer" ],
                276   => [ "Lucent-Multicast-Service-Name",         "string" ],
                277   => [ "Lucent-Multicast-Service-Active",       "integer" ],
                278   => [ "Lucent-Multicast-Service-Snmp-Trap",    "integer" ],
                279   => [ "Lucent-Multicast-Service-Filter-Type",  "integer" ],
                280   => [ "Lucent-Multicast-Filter-Active",        "integer" ],
                281   => [ "Lucent-Multicast-Filter-Address",       "ipaddr" ],
                282   => [ "Lucent-Tunnel-TOS",                     "integer" ],
                283   => [ "Lucent-Tunnel-TOS-Precedence",          "integer" ],
                284   => [ "Lucent-Tunnel-DSCP",                    "integer" ],
                285   => [ "Lucent-Tunnel-TOS-Filter",              "string" ],
                286   => [ "Lucent-Tunnel-TOS-Copy",                "integer" ],
                287   => [ "Lucent-Http-Redirect-URL",              "string" ],
                288   => [ "Lucent-Http-Redirect-Port",             "integer" ],
                289   => [ "Lucent-L2TP-DCI-Disconnect-Code",       "integer" ],
                290   => [ "Lucent-L2TP-DCI-Protocol-Number",       "integer" ],
                291   => [ "Lucent-L2TP-DCI-Direction",             "integer" ],
                292   => [ "Lucent-L2TP-DCI-Message",               "string" ],
                293   => [ "Lucent-L2TP-Q931-Cause-Code",           "integer" ],
                294   => [ "Lucent-L2TP-Q931-Cause-Message",        "integer" ],
                295   => [ "Lucent-L2TP-Q931-Advisory-Message",     "string" ],
                296   => [ "Lucent-L2TP-RC-Result-Code",            "integer" ],
                297   => [ "Lucent-L2TP-RC-Error-Code",             "integer" ],
                298   => [ "Lucent-L2TP-RC-Error-Message",          "string" ],
                299   => [ "Lucent-L2TP-Disconnect-Scenario",       "integer" ],
                300   => [ "Lucent-L2TP-Peer-Disconnect-Cause",     "integer" ],
                301   => [ "Lucent-L2TP-Peer-Connect-Progress",     "integer" ],
                302   => [ "Lucent-QuickConnect-Attempted",         "integer" ],
                303   => [ "Lucent-Num-Moh-Sessions",               "integer" ],
                304   => [ "Lucent-Cumulative-Hold-Time",           "integer" ],
                305   => [ "Lucent-Modem-Modulation",               "integer" ],
                306   => [ "Lucent-User-Acct-Expiration",           "date" ],
                307   => [ "Lucent-User-Login-Level",               "integer" ],
                308   => [ "Lucent-First-Level-User",               "string" ],
                309   => [ "Lucent-IP-Source-If",                   "string" ],
                310   => [ "Lucent-Reverse-Path-Check",             "integer" ],
                321   => [ "Lucent-LCP-Keepalive-Period",           "integer" ],
                322   => [ "Lucent-LCP-Keepalive-Missed-Limit",     "integer" ],
                10000 => [ "Lucent-Dsl-Atuc-Chan-Uncorrect-Blks",   "integer" ],
                10001 => [ "Lucent-Dsl-Atuc-Chan-Corrected-Blks",   "integer" ],
                10002 => [ "Lucent-Dsl-Atuc-Chan-Xmit-Blks",        "integer" ],
                10003 => [ "Lucent-Dsl-Atuc-Chan-Recd-Blks",        "integer" ],
                10004 => [ "Lucent-Dsl-Atuc-Perf-Inits",            "integer" ],
                10005 => [ "Lucent-Dsl-Atuc-Perf-ESs",              "integer" ],
                10006 => [ "Lucent-Dsl-Atuc-Perf-Lprs",             "integer" ],
                10007 => [ "Lucent-Dsl-Atuc-Perf-Lols",             "integer" ],
                10008 => [ "Lucent-Dsl-Atuc-Perf-Loss",             "integer" ],
                10009 => [ "Lucent-Dsl-Atuc-Perf-Lofs",             "integer" ],
                10010 =>
                  [ "Lucent-Dsl-Atuc-Curr-Attainable-Rate-Dn", "integer" ],
                10011 => [ "Lucent-Dsl-Atuc-Curr-Output-Pwr-Dn", "integer" ],
                10012 => [ "Lucent-Dsl-Atuc-Curr-Atn-Up",        "integer" ],
                10013 => [ "Lucent-Dsl-Atuc-Curr-Snr-Mgn-Up",    "integer" ],
                10014 => [ "Lucent-Dsl-Atuc-PS-Fast-Retrains",   "integer" ],
                10015 =>
                  [ "Lucent-Dsl-Atuc-PS-Failed-Fast-Retrains", "integer" ],
                10016 => [ "Lucent-Dsl-Code-Violations",  "integer" ],
                10017 => [ "Lucent-Line-Type",            "integer" ],
                10018 => [ "Lucent-Dsl-Curr-Up-Rate",     "integer" ],
                10019 => [ "Lucent-Dsl-Curr-Dn-Rate",     "integer" ],
                10020 => [ "Lucent-Dsl-Physical-Slot",    "integer" ],
                10021 => [ "Lucent-Dsl-Physical-Line",    "integer" ],
                10022 => [ "Lucent-Dsl-If-Index",         "integer" ],
                10023 => [ "Lucent-Dsl-Oper-Status",      "integer" ],
                10024 => [ "Lucent-Dsl-Related-If-Index", "integer" ],
                10025 =>
                  [ "Lucent-Dsl-Atuc-Curr-Attainable-Rate-Up", "integer" ],
                10026 => [ "Lucent-Dsl-Atuc-Curr-Output-Pwr-Up",  "integer" ],
                10027 => [ "Lucent-Dsl-Atuc-Curr-Atn-Dn",         "integer" ],
                10028 => [ "Lucent-Dsl-Atuc-Curr-Snr-Mgn-D",      "integer" ],
                10029 => [ "Lucent-Dsl-Related-Slot",             "integer" ],
                10030 => [ "Lucent-Dsl-Related-Port",             "integer" ],
                10031 => [ "Lucent-Dsl-Sparing-Role",             "integer" ],
                10032 => [ "Lucent-Absolute-Time",                "integer" ],
                10033 => [ "Lucent-Configured-Rate-Up-Min",       "integer" ],
                10034 => [ "Lucent-Configured-Rate-Up-Max",       "integer" ],
                10035 => [ "Lucent-Configured-Rate-Dn-Min",       "integer" ],
                10036 => [ "Lucent-Configured-Rate-Dn-Max",       "integer" ],
                10037 => [ "Lucent-Dsl-Physical-Channel",         "integer" ],
                10100 => [ "Lucent-Sonet-Section-ESs",            "integer" ],
                10101 => [ "Lucent-Sonet-Section-SESs",           "integer" ],
                10102 => [ "Lucent-Sonet-Section-SEFSs",          "integer" ],
                10103 => [ "Lucent-Sonet-Section-CVs",            "integer" ],
                10104 => [ "Lucent-Sonet-Line-ESs-Near",          "integer" ],
                10105 => [ "Lucent-Sonet-Line-SESs-Near",         "integer" ],
                10106 => [ "Lucent-Sonet-Line-CVs-Near",          "integer" ],
                10107 => [ "Lucent-Sonet-Line-USs-Near",          "integer" ],
                10108 => [ "Lucent-Sonet-Line-ESs-Far",           "integer" ],
                10109 => [ "Lucent-Sonet-Line-SESs-Far",          "integer" ],
                10110 => [ "Lucent-Sonet-Line-CVs-Far",           "integer" ],
                10111 => [ "Lucent-Sonet-Line-USs-Far",           "integer" ],
                10112 => [ "Lucent-Sonet-Path-ESs-Near",          "integer" ],
                10113 => [ "Lucent-Sonet-Path-SESs-Near",         "integer" ],
                10114 => [ "Lucent-Sonet-Path-CVs-Near",          "integer" ],
                10115 => [ "Lucent-Sonet-Path-USs-Near",          "integer" ],
                10116 => [ "Lucent-Sonet-Path-ESs-Far",           "integer" ],
                10117 => [ "Lucent-Sonet-Path-SESs-Far",          "integer" ],
                10118 => [ "Lucent-Sonet-Path-CVs-Far",           "integer" ],
                10119 => [ "Lucent-Sonet-Path-USs-Far",           "integer" ],
                10200 => [ "Lucent-Ds3-F-Bit-Err",                "integer" ],
                10201 => [ "Lucent-Ds3-P-Bit-Err",                "integer" ],
                10202 => [ "Lucent-Ds3-CCVs",                     "integer" ],
                10203 => [ "Lucent-Ds3-PESs",                     "integer" ],
                10204 => [ "Lucent-Ds3-PSESs",                    "integer" ],
                10205 => [ "Lucent-Ds3-SEFs",                     "integer" ],
                10206 => [ "Lucent-Ds3-UASs",                     "integer" ],
                10207 => [ "Lucent-Ds3-LCVs",                     "integer" ],
                10208 => [ "Lucent-Ds3-PCVs",                     "integer" ],
                10209 => [ "Lucent-Ds3-LESs",                     "integer" ],
                10210 => [ "Lucent-Ds3-CESs",                     "integer" ],
                10211 => [ "Lucent-Ds3-CSESs",                    "integer" ],
                10300 => [ "Lucent-Rtp-Local-Number-Of-Samples",  "integer" ],
                10301 => [ "Lucent-Rtp-Remote-Number-Of-Samples", "integer" ],
                10302 => [ "Lucent-Rtp-Local-Jitter-Minimum",     "integer" ],
                10303 => [ "Lucent-Rtp-Local-Jitter-Maximum",     "integer" ],
                10304 => [ "Lucent-Rtp-Local-Jitter-Mean",        "integer" ],
                10305 => [ "Lucent-Rtp-Local-Jitter-Variance",    "integer" ],
                10306 => [ "Lucent-Rtp-Local-Delay-Minimum",      "integer" ],
                10307 => [ "Lucent-Rtp-Local-Delay-Maximum",      "integer" ],
                10308 => [ "Lucent-Rtp-Local-Delay-Mean",         "integer" ],
                10309 => [ "Lucent-Rtp-Local-Delay-Variance",     "integer" ],
                10310 => [ "Lucent-Rtp-Local-Packets-Sent",       "integer" ],
                10311 => [ "Lucent-Rtp-Local-Packets-Lost",       "integer" ],
                10312 => [ "Lucent-Rtp-Local-Packets-Late",       "integer" ],
                10313 => [ "Lucent-Rtp-Local-Bytes-Sent",         "integer" ],
                10314 => [ "Lucent-Rtp-Local-Silence-Percent",    "integer" ],
                10315 => [ "Lucent-Rtp-Remote-Jitter-Minimum",    "integer" ],
                10316 => [ "Lucent-Rtp-Remote-Jitter-Maximum",    "integer" ],
                10317 => [ "Lucent-Rtp-Remote-Jitter-Mean",       "integer" ],
                10318 => [ "Lucent-Rtp-Remote-Jitter-Variance",   "integer" ],
                10319 => [ "Lucent-Rtp-Remote-Delay-Minimum",     "integer" ],
                10320 => [ "Lucent-Rtp-Remote-Delay-Maximum",     "integer" ],
                10321 => [ "Lucent-Rtp-Remote-Delay-Mean",        "integer" ],
                10322 => [ "Lucent-Rtp-Remote-Delay-Variance",    "integer" ],
                10323 => [ "Lucent-Rtp-Remote-Packets-Sent",      "integer" ],
                10324 => [ "Lucent-Rtp-Remote-Packets-Lost",      "integer" ],
                10325 => [ "Lucent-Rtp-Remote-Packets-Late",      "integer" ],
                10326 => [ "Lucent-Rtp-Remote-Bytes-Sent",        "integer" ],
                10327 => [ "Lucent-Rtp-Remote-Silence-Percent",   "integer" ],
                19999 => [ "Lucent-Tunnel-Auth-Type2",            "integer" ],
                20000 => [ "Lucent-Multi-Packet-Separator",       "integer" ],
                20100 => [ "Lucent-Min-Xmit-Rate",                "integer" ],
                20101 => [ "Lucent-Max-Xmit-Rate",                "integer" ],
                20102 => [ "Lucent-Min-Recv-Rate",                "integer" ],
                20103 => [ "Lucent-Max-Recv-Rate",                "integer" ],
                20104 => [ "Lucent-Error-Correction-Protocol",    "integer" ],
                20105 => [ "Lucent-Compression-Protocol",         "integer" ],
                20106 => [ "Lucent-Modulation",                   "integer" ],
                20107 => [ "Lucent-Xmit-Symbol-Rate",             "integer" ],
                20108 => [ "Lucent-Recv-Symbol-Rate",             "integer" ],
                20109 => [ "Lucent-Current-Xmit-Level",           "integer" ],
                20110 => [ "Lucent-Current-Recv-Level",           "integer" ],
                20111 => [ "Lucent-Current-Line-Quality",         "integer" ],
                20112 => [ "Lucent-Current-SNR",                  "integer" ],
                20113 => [ "Lucent-Min-SNR",                      "integer" ],
                20114 => [ "Lucent-Max-SNR",                      "integer" ],
                20115 => [ "Lucent-Local-Retrain-Requested",      "integer" ],
                20116 => [ "Lucent-Remote-Retrain-Requested",     "integer" ],
                20117 => [ "Lucent-Connection-Time",              "integer" ],
                20118 => [ "Lucent-Modem-Disconnect-Reason",      "integer" ],
                20119 => [ "Lucent-Retrain-Reason",               "integer" ],
            },
            4874 => {
                1   => [ "ERX-Virtual-Router-Name",            "string" ],
                2   => [ "ERX-Address-Pool-Name",              "string" ],
                3   => [ "ERX-Local-Loopback-Interface",       "string" ],
                4   => [ "ERX-Primary-Dns",                    "ipaddr" ],
                5   => [ "ERX-Secondary-Dns",                  "ipaddr" ],
                6   => [ "ERX-Primary-Wins",                   "ipaddr" ],
                7   => [ "ERX-Secondary-Wins",                 "ipaddr" ],
                8   => [ "ERX-Tunnel-Virtual-Router",          "string" ],
                9   => [ "ERX-Tunnel-Password",                "string" ],
                10  => [ "ERX-Ingress-Policy-Name",            "string" ],
                11  => [ "ERX-Egress-Policy-Name",             "string" ],
                12  => [ "ERX-Ingress-Statistics",             "integer" ],
                13  => [ "ERX-Egress-Statistics",              "integer" ],
                14  => [ "ERX-Atm-Service-Category",           "integer" ],
                15  => [ "ERX-Atm-PCR",                        "integer" ],
                16  => [ "ERX-Atm-SCR",                        "integer" ],
                17  => [ "ERX-Atm-MBS",                        "integer" ],
                18  => [ "ERX-Cli-Initial-Access-Level",       "string" ],
                19  => [ "ERX-Cli-Allow-All-VR-Access",        "integer" ],
                20  => [ "ERX-Alternate-Cli-Access-Level",     "string" ],
                21  => [ "ERX-Alternate-Cli-Vrouter-Name",     "string" ],
                22  => [ "ERX-Sa-Validate",                    "integer" ],
                23  => [ "ERX-Igmp-Enable",                    "integer" ],
                24  => [ "ERX-Pppoe-Description",              "string" ],
                25  => [ "ERX-Redirect-VR-Name",               "string" ],
                26  => [ "ERX-Qos-Profile-Name",               "string" ],
                27  => [ "ERX-Pppoe-Max-Sessions",             "integer" ],
                28  => [ "ERX-Pppoe-Url",                      "string" ],
                29  => [ "ERX-Qos-Profile-Interface-Type",     "integer" ],
                30  => [ "ERX-Tunnel-Nas-Port-Method",         "integer" ],
                31  => [ "ERX-Service-Bundle",                 "string" ],
                32  => [ "ERX-Tunnel-Tos",                     "integer" ],
                33  => [ "ERX-Tunnel-Maximum-Sessions",        "integer" ],
                34  => [ "ERX-Framed-Ip-Route-Tag",            "string" ],
                35  => [ "ERX-Dial-Out-Number",                "string" ],
                36  => [ "ERX-PPP-Username",                   "string" ],
                37  => [ "ERX-PPP-Password",                   "string" ],
                38  => [ "ERX-PPP-Auth-Protocol",              "integer" ],
                39  => [ "ERX-Minimum-BPS",                    "integer" ],
                40  => [ "ERX-Maximum-BPS",                    "integer" ],
                41  => [ "ERX-Bearer-Type",                    "integer" ],
                42  => [ "ERX-Input-Gigapkts",                 "integer" ],
                43  => [ "ERX-Output-Gigapkts",                "integer" ],
                44  => [ "ERX-Tunnel-Interface-Id",            "string" ],
                45  => [ "ERX-IpV6-Virtual-Router",            "string" ],
                46  => [ "ERX-IpV6-Local-Interface",           "string" ],
                47  => [ "ERX-Ipv6-Primary-Dns",               "ipv6addr" ],
                48  => [ "ERX-Ipv6-Secondary-Dns",             "ipv6addr" ],
                49  => [ "Sdx-Service-Name",                   "string" ],
                50  => [ "Sdx-Session-Volume-Quota",           "string" ],
                51  => [ "Sdx-Tunnel-Disconnect-Cause-Info",   "string" ],
                52  => [ "ERX-Radius-Client-Address",          "ipaddr" ],
                53  => [ "ERX-Service-Description",            "string" ],
                54  => [ "ERX-L2tp-Recv-Window-Size",          "integer" ],
                55  => [ "ERX-Dhcp-Options",                   "octets" ],
                56  => [ "ERX-Dhcp-Mac-Addr",                  "string" ],
                57  => [ "ERX-Dhcp-Gi-Address",                "ipaddr" ],
                58  => [ "ERX-LI-Action",                      "integer" ],
                59  => [ "ERX-Med-Dev-Handle",                 "octets" ],
                60  => [ "ERX-Med-Ip-Address",                 "ipaddr" ],
                61  => [ "ERX-Med-Port-Number",                "integer" ],
                62  => [ "ERX-MLPPP-Bundle-Name",              "string" ],
                63  => [ "ERX-Interface-Desc",                 "string" ],
                64  => [ "ERX-Tunnel-Group",                   "string" ],
                65  => [ "ERX-Service-Activate",               "string" ],
                66  => [ "ERX-Service-Deactivate",             "string" ],
                67  => [ "ERX-Service-Volume",                 "integer" ],
                68  => [ "ERX-Service-Timeout",                "integer" ],
                69  => [ "ERX-Service-Statistics",             "integer" ],
                70  => [ "ERX-DF-Bit",                         "integer" ],
                71  => [ "ERX-IGMP-Access-Name",               "string" ],
                72  => [ "ERX-IGMP-Access-Src-Name",           "string" ],
                73  => [ "ERX-IGMP-OIF-Map-Name",              "string" ],
                74  => [ "ERX-MLD-Access-Name",                "string" ],
                75  => [ "ERX-MLD-Access-Src-Name",            "string" ],
                76  => [ "ERX-MLD-OIF-Map-Name",               "string" ],
                77  => [ "ERX-MLD-Version",                    "integer" ],
                78  => [ "ERX-IGMP-Version",                   "integer" ],
                79  => [ "ERX-IP-Mcast-Adm-Bw-Limit",          "integer" ],
                80  => [ "ERX-IPv6-Mcast-Adm-Bw-Limit",        "integer" ],
                82  => [ "ERX-Qos-Parameters",                 "string" ],
                83  => [ "ERX-Service-Session",                "string" ],
                84  => [ "ERX-Mobile-IP-Algorithm",            "integer" ],
                85  => [ "ERX-Mobile-IP-SPI",                  "integer" ],
                86  => [ "ERX-Mobile-IP-Key",                  "string" ],
                87  => [ "ERX-Mobile-IP-Replay",               "integer" ],
                88  => [ "ERX-Mobile-IP-Access-Control",       "string" ],
                89  => [ "ERX-Mobile-IP-Lifetime",             "integer" ],
                90  => [ "ERX-L2TP-Resynch-Method",            "integer" ],
                91  => [ "ERX-Tunnel-Switch-Profile",          "string" ],
                92  => [ "ERX-L2c-Up-Stream-Data",             "string" ],
                93  => [ "ERX-L2c-Down-Stream-Data",           "string" ],
                94  => [ "ERX-Tunnel-Tx-Speed-Method",         "integer" ],
                95  => [ "ERX-IGMP-Query-Interval",            "integer" ],
                96  => [ "ERX-IGMP-Max-Resp-Time",             "integer" ],
                97  => [ "ERX-IGMP-Immediate-Leave",           "integer" ],
                98  => [ "ERX-MLD-Query-Interval",             "integer" ],
                99  => [ "ERX-MLD-Max-Resp-Time",              "integer" ],
                100 => [ "ERX-MLD-Immediate-Leave",            "integer" ],
                101 => [ "ERX-IP-Block-Multicast",             "integer" ],
                102 => [ "ERX-IGMP-Explicit-Tracking",         "integer" ],
                103 => [ "ERX-IGMP-No-Tracking-V2-Grps",       "integer" ],
                104 => [ "ERX-MLD-Explicit-Tracking",          "integer" ],
                105 => [ "ERX-MLD-No-Tracking-V1-Grps",        "integer" ],
                106 => [ "ERX-IPv6-Ingress-Policy-Name",       "string" ],
                107 => [ "ERX-IPv6-Egress-Policy-Name",        "string" ],
                108 => [ "ERX-CoS-Shaping-Pmt-Type",           "string" ],
                109 => [ "ERX-DHCP-Guided-Relay-Server",       "ipaddr" ],
                110 => [ "ERX-Acc-Loop-Cir-Id",                "string" ],
                111 => [ "ERX-Acc-Aggr-Cir-Id-Bin",            "octets" ],
                112 => [ "ERX-Acc-Aggr-Cir-Id-Asc",            "string" ],
                113 => [ "ERX-Act-Data-Rate-Up",               "integer" ],
                114 => [ "ERX-Act-Data-Rate-Dn",               "integer" ],
                115 => [ "ERX-Min-Data-Rate-Up",               "integer" ],
                116 => [ "ERX-Min-Data-Rate-Dn",               "integer" ],
                117 => [ "ERX-Att-Data-Rate-Up",               "integer" ],
                118 => [ "ERX-Att-Data-Rate-Dn",               "integer" ],
                119 => [ "ERX-Max-Data-Rate-Up",               "integer" ],
                120 => [ "ERX-Max-Data-Rate-Dn",               "integer" ],
                121 => [ "ERX-Min-LP-Data-Rate-Up",            "integer" ],
                122 => [ "ERX-Min-LP-Data-Rate-Dn",            "integer" ],
                123 => [ "ERX-Max-Interlv-Delay-Up",           "integer" ],
                124 => [ "ERX-Act-Interlv-Delay-Up",           "integer" ],
                125 => [ "ERX-Max-Interlv-Delay-Dn",           "integer" ],
                126 => [ "ERX-Act-Interlv-Delay-Dn",           "integer" ],
                127 => [ "ERX-DSL-Line-State",                 "integer" ],
                128 => [ "ERX-DSL-Type",                       "integer" ],
                129 => [ "ERX-IPv6-NdRa-Prefix",               "ipv6prefix" ],
                130 => [ "ERX-Qos-Set-Name",                   "string" ],
                140 => [ "ERX-Service-Acct-Interval",          "integer" ],
                141 => [ "ERX-DownStream-Calc-Rate",           "integer" ],
                142 => [ "ERX-UpStream-Calc-Rate",             "integer" ],
                143 => [ "ERX-Max-Clients-Per-Interface",      "integer" ],
                144 => [ "ERX-PPP-Monitor-Ingress-Only",       "integer" ],
                146 => [ "ERX-CoS-Scheduler-Pmt-Type",         "string" ],
                147 => [ "ERX-Backup-Address-Pool",            "string" ],
                150 => [ "ERX-ICR-Partition-Id",               "string" ],
                151 => [ "ERX-IPv6-Acct-Input-Octets",         "integer" ],
                152 => [ "ERX-IPv6-Acct-Output-Octets",        "integer" ],
                153 => [ "ERX-IPv6-Acct-Input-Packets",        "integer" ],
                154 => [ "ERX-IPv6-Acct-Output-Packets",       "integer" ],
                155 => [ "ERX-IPv6-Acct-Input-Gigawords",      "integer" ],
                156 => [ "ERX-IPv6-Acct-Output-Gigawords",     "integer" ],
                157 => [ "ERX-IPv6-NdRa-Pool-Name",            "string" ],
                158 => [ "ERX-PppoE-Padn",                     "string" ],
                159 => [ "ERX-Dhcp-Option-82",                 "octets" ],
                160 => [ "ERX-Vlan-Map-Id",                    "integer" ],
                161 => [ "ERX-IPv6-Delegated-Pool-Name",       "string" ],
                162 => [ "ERX-Tx-Connect-Speed",               "integer" ],
                163 => [ "ERX-Rx-Connect-Speed",               "integer" ],
                173 => [ "ERX-Service-Activate-Type",          "integer" ],
                174 => [ "ERX-Client-Profile-Name",            "string" ],
                175 => [ "ERX-Redirect-GW-Address",            "ipaddr" ],
                176 => [ "ERX-APN-Name",                       "string" ],
                177 => [ "ERX-Cos-Shaping-Rate",               "string" ],
                178 => [ "ERX-Action-Reason",                  "string" ],
                179 => [ "ERX-Service-Volume-Gigawords",       "integer" ],
                180 => [ "ERX-Update-Service",                 "string" ],
                181 => [ "ERX-DHCPv6-Guided-Relay-Server",     "ipv6addr" ],
                182 => [ "ERX-Acc-Loop-Remote-Id",             "string" ],
                183 => [ "ERX-Acc-Loop-Encap",                 "octets" ],
                184 => [ "ERX-Inner-Vlan-Map-Id",              "integer" ],
                185 => [ "ERX-Core-Facing-Interface",          "string" ],
                189 => [ "ERX-DHCP-First-Relay-IPv4-Address",  "ipaddr" ],
                190 => [ "ERX-DHCP-First-Relay-IPv6-Address",  "ipv6addr" ],
                191 => [ "ERX-Input-Interface-Filter",         "string" ],
                192 => [ "ERX-Output-Interface-Filter",        "string" ],
                193 => [ "ERX-Pim-Enable",                     "integer" ],
                194 => [ "ERX-Bulk-CoA-Transaction-Id",        "integer" ],
                195 => [ "ERX-Bulk-CoA-Identifier",            "integer" ],
                196 => [ "ERX-IPv4-Input-Service-Set",         "string" ],
                197 => [ "ERX-IPv4-Output-Service-Set",        "string" ],
                198 => [ "ERX-IPv4-Input-Service-Filter",      "string" ],
                199 => [ "ERX-IPv4-Output-Service-Filter",     "string" ],
                200 => [ "ERX-IPv6-Input-Service-Set",         "string" ],
                201 => [ "ERX-IPv6-Output-Service-Set",        "string" ],
                202 => [ "ERX-IPv6-Input-Service-Filter",      "string" ],
                203 => [ "ERX-IPv6-Output-Service-Filter",     "string" ],
                204 => [ "ERX-Adv-Pcef-Profile-Name",          "string" ],
                205 => [ "ERX-Adv-Pcef-Rule-Name",             "string" ],
                206 => [ "ERX-Re-Authentication-Catalyst",     "integer" ],
                207 => [ "ERX-DHCPv6-Options",                 "octets" ],
                208 => [ "ERX-DHCP-Header",                    "octets" ],
                209 => [ "ERX-DHCPv6-Header",                  "octets" ],
                210 => [ "ERX-Acct-Request-Reason",            "integer" ],
                211 => [ "ERX-Inner-Tag-Protocol-Id",          "string" ],
                212 => [ "ERX-Routing-Services",               "integer" ],
                213 => [ "ERX-Interface-Set-Targeting-Weight", "integer" ],
                214 => [ "ERX-Interface-Targeting-Weight",     "integer" ],
                216 => [ "ERX-Hybrid-Access-DSL-Downstream-Speed", "integer" ],
                217 => [ "ERX-Hybrid-Access-LTE-Downstream-Speed", "integer" ],
                219 => [ "ERX-PON-Access-Type",                    "integer" ],
                220 =>
                  [ "ERX-ONT-ONU-Average-Data-Rate-Downstream", "integer" ],
                221 => [ "ERX-ONT-ONU-Peak-Data-Rate-Downstream",   "integer" ],
                222 => [ "ERX-ONT-ONU-Maximum-Data-Rate-Upstream",  "integer" ],
                223 => [ "ERX-ONT-ONU-Assured-Data-Rate-Upstream",  "integer" ],
                224 => [ "ERX-PON-Tree-Maximum-Data-Rate-Upstream", "integer" ],
                225 =>
                  [ "ERX-PON-Tree-Maximum-Data-Rate-Downstream", "integer" ],
                226 => [ "ERX-Expected-Throughput-Upstream",   "integer" ],
                227 => [ "ERX-Expected-Throughput-Downstream", "integer" ],
                228 =>
                  [ "ERX-Attainable-Expected-Throughput-Upstream", "integer" ],
                229 => [
                    "ERX-Attainable-Expected-Throughput-Downstream", "integer"
                ],
                230 => [ "ERX-Gamma-Data-Rate-Upstream",            "integer" ],
                231 => [ "ERX-Gamma-Data-Rate-Downstream",          "integer" ],
                232 => [ "ERX-Attainable-Gamma-Data-Rate-Upstream", "integer" ],
                233 =>
                  [ "ERX-Attainable-Gamma-Data-Rate-Downstream", "integer" ],
            },
            5003 => { 35 => [ "ACL-Auth-Level",       "integer" ] },
            5089 => { 1  => [ "Clavister-User-Group", "string" ] },
            5263 => { 1  => [ "CBBSM-Bandwidth",      "integer" ] },
            5323 => { 1  => [ "Telrad-Reference-QOS-Profile-Name", "string" ] },
            5468 => { 1  => [ "Actelis-Privilege",                 "string" ] },
            5535 => {
                1  => [ "3GPP2-Ike-Preshared-Secret-Request",  "integer" ],
                2  => [ "3GPP2-Security-Level",                "integer" ],
                3  => [ "3GPP2-Pre-Shared-Secret",             "string" ],
                4  => [ "3GPP2-Reverse-Tunnel-Spec",           "integer" ],
                5  => [ "3GPP2-Diffserv-Class-Option",         "integer" ],
                6  => [ "3GPP2-Accounting-Container",          "octets" ],
                7  => [ "3GPP2-Home-Agent-IP-Address",         "ipaddr" ],
                8  => [ "3GPP2-KeyID",                         "string" ],
                9  => [ "3GPP2-PCF-IP-Address",                "ipaddr" ],
                10 => [ "3GPP2-BSID",                          "string" ],
                11 => [ "3GPP2-User-Id",                       "integer" ],
                12 => [ "3GPP2-Forward-FCH-Mux-Option",        "integer" ],
                13 => [ "3GPP2-Reverse-FCH-Mux-Option",        "integer" ],
                16 => [ "3GPP2-Service-Option",                "integer" ],
                17 => [ "3GPP2-Forward-Traffic-Type",          "integer" ],
                18 => [ "3GPP2-Reverse-Traffic-Type",          "integer" ],
                19 => [ "3GPP2-FCH-Frame-Size",                "integer" ],
                20 => [ "3GPP2-Forward-FCH-RC",                "integer" ],
                21 => [ "3GPP2-Reverse-FCH-RC",                "integer" ],
                22 => [ "3GPP2-IP-Technology",                 "integer" ],
                23 => [ "3GPP2-Compulsory-Tunnel-Indicator",   "integer" ],
                24 => [ "3GPP2-Release-Indicator",             "integer" ],
                25 => [ "3GPP2-Bad-PPP-Frame-Count",           "integer" ],
                30 => [ "3GPP2-Number-Active-Transitions",     "integer" ],
                31 => [ "3GPP2-Terminating-SDB-Octet-Count",   "integer" ],
                32 => [ "3GPP2-Originating-SDB-OCtet-Count",   "integer" ],
                33 => [ "3GPP2-Terminating-Number-SDBs",       "integer" ],
                34 => [ "3GPP2-Originating-Number-SDBs",       "integer" ],
                36 => [ "3GPP2-IP-QoS",                        "integer" ],
                39 => [ "3GPP2-Airlink-Priority",              "integer" ],
                40 => [ "3GPP2-Airlink-Record-Type",           "integer" ],
                42 => [ "3GPP2-Airlink-Sequence-Number",       "integer" ],
                43 => [ "3GPP2-Received-HDLC-Octets",          "integer" ],
                44 => [ "3GPP2-Correlation-Id",                "string" ],
                45 => [ "3GPP2-Module-Orig-Term-Indicator",    "octets" ],
                46 => [ "3GPP2-Inbound-Mobile-IP-Sig-Octets",  "integer" ],
                47 => [ "3GPP2-Outbound-Mobile-IP-Sig-Octets", "integer" ],
                48 => [ "3GPP2-Session-Continue",              "integer" ],
                49 => [ "3GPP2-Active-Time",                   "integer" ],
                50 => [ "3GPP2-DCCH-Frame-Size",               "integer" ],
                51 => [ "3GPP2-Begin-Session",                 "integer" ],
                52 => [ "3GPP2-ESN",                           "string" ],
                54 => [ "3GPP2-S-Key",                         "octets" ],
                55 => [ "3GPP2-S-Request",                     "integer" ],
                56 => [ "3GPP2-S-Lifetime",                    "date" ],
                57 => [ "3GPP2-MN-HA-SPI",                     "integer" ],
                58 => [ "3GPP2-MN-HA-Shared-Key",              "string" ],
                59 => [ "3GPP2-Remote-IP-Qualifier",           "short" ],
                70 => [ "3GPP2-Remote-IPv6-Address-Qualifier", "tlv" ],
                71 => [ "3GPP2-Remote-Address-Table-Index-Qualifier", "short" ],
                72 => [
                    "3GPP2-Remote-IPv4-Addr-Octet-Count-Reverse-Overflow",
                    "short",
                ],
                73 =>
                  [ "3GPP2-Allowed-Diffserv-Marking-Reverse-Runnel", "short" ],
                74 => [ "3GPP2-Service-Option-Profile-Option",   "short" ],
                75 => [ "3GPP2-DNS-Update-Required",             "integer" ],
                79 => [ "3GPP2-Foreign-Agent-Address",           "ipaddr" ],
                80 => [ "3GPP2-Last-User-Activity-Time",         "integer" ],
                81 => [ "3GPP2-MN-AAA-Removal-Indication",       "integer" ],
                82 => [ "3GPP2-RN-Packet-Data-Inactivity-Timer", "integer" ],
                83 => [ "3GPP2-Forward-PDCH-RC",                 "integer" ],
                84 => [ "3GPP2-Forward-DCCH-Mux-Option",         "integer" ],
                85 => [ "3GPP2-Reverse-DCCH-Mux-Option",         "integer" ],
                86 => [ "3GPP2-Forward-DCCH-RC",                 "integer" ],
                87 => [ "3GPP2-Reverse-DHHC-RC",                 "integer" ],
                88 => [ "3GPP2-Session-Termination-Capability",  "integer" ],
                89 => [ "3GPP2-Allowed-Persistent-TFTs",         "integer" ],
                90 => [ "3GPP2-Prepaid-Acct-Quota-UpdateReason", "short" ],
                91 => [ "3GPP2-Prepaid-acct-Capability",         "octets" ],
                92 => [ "3GPP2-MIP-Lifetime",                    "octets" ],
                93 => [ "3GPP2-Acct-Stop-Trigger",               "integer" ],
                94 => [ "3GPP2-Service-Reference-Main-SC-Indicator", "short" ],
                95 => [ "3GPP2-DNS-Update-Capability", "integer" ],
                96 => [ "3GPP2-Disconnect-Reason",     "integer" ],
                97 =>
                  [ "3GPP2-Remote-IPv6-Reverse-Octet-Count-Overflow", "short" ],
                98 => [
                    "3GPP2-Prepaid-Time-Interval-After-Tariff-Switch-Update",
                    "integer",
                ],
                116 => [ "3GPP2-MEID",                   "octets" ],
                117 => [ "3GPP2-DNS-Server-Entity-Type", "byte" ],
                142 => [ "3GPP2-Carrier-ID",             "string" ],
                143 => [ "3GPP2-GMT-Time-Zone-Offset",   "signed" ],
                168 => [ "3GPP2-HA-Request",             "integer" ],
                169 => [ "3GPP2-HA-Authorised",          "integer" ],
                172 => [ "3GPP2-IP-Ver-Authorised",      "integer" ],
                173 => [ "3GPP2-MIPv4-Mesg-Id",          "string" ],
            },
            5567 => {
                1 => [ "Riverstone-Command",            "string" ],
                2 => [ "Riverstone-System-Event",       "string" ],
                3 => [ "Riverstone-SNMP-Config-Change", "string" ],
                4 => [ "Riverstone-User-Level",         "integer" ],
            },
            5597 => { 1 => [ "MBG-Management-Privilege-Level", "integer" ] },
            5925 => {
                51 => [ "IPU-MIP-Spi",         "integer" ],
                52 => [ "IPU-MIP-Key",         "string" ],
                53 => [ "IPU-MIP-Alg-Type",    "integer" ],
                54 => [ "IPU-MIP-Alg-Mode",    "integer" ],
                55 => [ "IPU-MIP-Replay-Prot", "integer" ],
                61 => [ "IPU-IKE-Remote-Addr", "ipaddr" ],
                62 => [ "IPU-IKE-Local-Addr",  "ipaddr" ],
                63 => [ "IPU-IKE-Auth",        "string" ],
                64 => [ "IPU-IKE-Conf-Name",   "string" ],
                65 => [ "IPU-IKE-Cmd",         "string" ],
            },
            5948 => {
                1  => [ "Issanni-SoftFlow-Template", "string" ],
                2  => [ "Issanni-NAT-Support",       "string" ],
                3  => [ "Issanni-Routing-Context",   "string" ],
                4  => [ "Issanni-Tunnel-Name",       "string" ],
                5  => [ "Issanni-IP-Pool-Name",      "string" ],
                6  => [ "Issanni-PPPoE-URL",         "string" ],
                7  => [ "Issanni-PPPoE-MOTM",        "string" ],
                8  => [ "Issanni-Service",           "string" ],
                9  => [ "Issanni-Pri-DNS",           "ipaddr" ],
                10 => [ "Issanni-Sec-DNS",           "ipaddr" ],
                11 => [ "Issanni-Pri-NBNS",          "ipaddr" ],
                12 => [ "Issanni-Sec-NBNS",          "ipaddr" ],
                13 => [ "Issanni-Traffic-Class",     "string" ],
                14 => [ "Issanni-Tunnel-Type",       "integer" ],
                15 => [ "Issanni-NAT-Type",          "integer" ],
                16 => [ "Issanni-QOS-Class",         "string" ],
                17 => [ "Issanni-Interface-Name",    "string" ],
            },
            6027 => { 1 => [ "Force10-AVPair", "string" ] },
            6321 => {},
            6431 => {
                1   => [ "BWAS-Record-id",                          "string" ],
                2   => [ "BWAS-Service-provider",                   "string" ],
                3   => [ "BWAS-Type",                               "string" ],
                4   => [ "BWAS-User-Number",                        "string" ],
                5   => [ "BWAS-Group-Number",                       "string" ],
                6   => [ "BWAS-Direction",                          "string" ],
                7   => [ "BWAS-Calling-Number",                     "string" ],
                8   => [ "BWAS-Calling-Presentation-Indic",         "string" ],
                9   => [ "BWAS-Called-Number",                      "string" ],
                10  => [ "BWAS-Start-Time",                         "string" ],
                11  => [ "BWAS-User-Timezone",                      "string" ],
                12  => [ "BWAS-Answer-Indic",                       "string" ],
                13  => [ "BWAS-Answer-Time",                        "string" ],
                14  => [ "BWAS-Release-Time",                       "string" ],
                15  => [ "BWAS-Termination-Cause",                  "string" ],
                16  => [ "BWAS-Network-Type",                       "string" ],
                17  => [ "BWAS-Carrier-Identification-Code",        "string" ],
                18  => [ "BWAS-Dialed-Digits",                      "string" ],
                19  => [ "BWAS-Call-Category",                      "string" ],
                20  => [ "BWAS-Network-Call-Type",                  "string" ],
                21  => [ "BWAS-Network-Translated-Number",          "string" ],
                22  => [ "BWAS-Network-Translated-Group",           "string" ],
                23  => [ "BWAS-Releasing-Party",                    "string" ],
                24  => [ "BWAS-Route",                              "string" ],
                25  => [ "BWAS-Network-Callid",                     "string" ],
                26  => [ "BWAS-Codec",                              "string" ],
                27  => [ "BWAS-Access-Device-Address",              "string" ],
                28  => [ "BWAS-Access-Callid",                      "string" ],
                29  => [ "BWAS-Spare-29",                           "string" ],
                30  => [ "BWAS-Failover-Correlation-Id",            "string" ],
                31  => [ "BWAS-Spare-31",                           "string" ],
                32  => [ "BWAS-Group",                              "string" ],
                33  => [ "BWAS-Department",                         "string" ],
                34  => [ "BWAS-Account-Code",                       "string" ],
                35  => [ "BWAS-Authorization-Code",                 "string" ],
                36  => [ "BWAS-Original-Called-Number",             "string" ],
                37  => [ "BWAS-Original-Called-Presentation-Indic", "string" ],
                38  => [ "BWAS-Original-Called-Reason",             "string" ],
                39  => [ "BWAS-Redirecting-Number",                 "string" ],
                40  => [ "BWAS-Redirecting-Presentation-Indic",     "string" ],
                41  => [ "BWAS-Redirecting-Reason",                 "string" ],
                42  => [ "BWAS-Charge-Indic",                       "string" ],
                43  => [ "BWAS-Type-Of-Network",                    "string" ],
                44  => [ "BWAS-VP-Calling-Invoke-Time",             "string" ],
                45  => [ "BWAS-Local-Callid",                       "string" ],
                46  => [ "BWAS-Remote-Callid",                      "string" ],
                47  => [ "BWAS-Calling-Party-Category",             "string" ],
                48  => [ "BWAS-Conference-Invoke-Time",             "string" ],
                49  => [ "BWAS-Conference-Callid",                  "string" ],
                50  => [ "BWAS-Conference-To",                      "string" ],
                51  => [ "BWAS-Conference-From",                    "string" ],
                52  => [ "BWAS-Conference-Id",                      "string" ],
                53  => [ "BWAS-Conference-Role",                    "string" ],
                54  => [ "BWAS-Conference-Bridge",                  "string" ],
                55  => [ "BWAS-Conference-Owner",                   "string" ],
                56  => [ "BWAS-Conference-Owner-Dn",                "string" ],
                57  => [ "BWAS-Conference-Title",                   "string" ],
                58  => [ "BWAS-Conference-Project-Code",            "string" ],
                59  => [ "BWAS-Charging-Vector-Key",                "string" ],
                60  => [ "BWAS-Charging-Vection-Creator",           "string" ],
                61  => [ "BWAS-Charging-Vection-Orig",              "string" ],
                62  => [ "BWAS-Charging-Vection-Term",              "string" ],
                63  => [ "BWAS-Acc-Per-Call-Invoke-Time",           "string" ],
                64  => [ "BWAS-Acc-Per-Call-Fac-Result",            "string" ],
                65  => [ "BWAS-Acb-Act-Invoke-Time",                "string" ],
                66  => [ "BWAS-Acb-Act-Fac-Result",                 "string" ],
                67  => [ "BWAS-Acb-Deact-Invoke-Time",              "string" ],
                68  => [ "BWAS-Acb-Deact-Fac-Result",               "string" ],
                69  => [ "BWAS-Call-Park-Invoke-Time",              "string" ],
                70  => [ "BWAS-Call-Park-Fac-Result",               "string" ],
                71  => [ "BWAS-Call-Park-Retr-Invoke-Time",         "string" ],
                72  => [ "BWAS-Call-Park-Retr-Fac-Result",          "string" ],
                73  => [ "BWAS-Call-Pickup-Invoke-Time",            "string" ],
                74  => [ "BWAS-Call-Pickup-Fac-Result",             "string" ],
                75  => [ "BWAS-Directed-Call-Pickup-Invoke-Time",   "string" ],
                76  => [ "BWAS-Directed-Call-Pickup-Fac-Result",    "string" ],
                77  => [ "BWAS-Dpubi-Invoke-Time",                  "string" ],
                78  => [ "BWAS-Dpubi-Fac-Result",                   "string" ],
                79  => [ "BWAS-Cancel-Cwt-Per-Call-Invoke-Time",    "string" ],
                80  => [ "BWAS-Cancel-Cwt-Per-Call-Fac-Result",     "string" ],
                81  => [ "BWAS-Cfa-Act-Invoke-Time",                "string" ],
                82  => [ "BWAS-Cfa-Act-Fac-Result",                 "string" ],
                83  => [ "BWAS-Cfa-Deact-Invoke-Time",              "string" ],
                84  => [ "BWAS-Cfa-Deact-Fac-Result",               "string" ],
                85  => [ "BWAS-Cfb-Act-Invoke-Time",                "string" ],
                86  => [ "BWAS-Cfb-Act-Fac-Result",                 "string" ],
                87  => [ "BWAS-Cfb-Deact-Invoke-Time",              "string" ],
                88  => [ "BWAS-Cfb-Deact-Fac-Result",               "string" ],
                89  => [ "BWAS-Cfna-Act-Invoke-Time",               "string" ],
                90  => [ "BWAS-Cfna-Act-Fac-Result",                "string" ],
                91  => [ "BWAS-Cfna-Deact-Invoke-Time",             "string" ],
                92  => [ "BWAS-Cfna-Deact-Fac-Result",              "string" ],
                93  => [ "BWAS-Clid-Delivery-Per-Call-Invoke-Time", "string" ],
                94  => [ "BWAS-Clid-Delivery-Per-Call-Fac-Result",  "string" ],
                95  => [ "BWAS-Clid-Blocking-Per-Call-Invoke-Time", "string" ],
                96  => [ "BWAS-Clid-Blocking-Per-Call-Fac-Result",  "string" ],
                97  => [ "BWAS-Cot-Invoke-Time",                    "string" ],
                98  => [ "BWAS-Cot-Fac-Result",                     "string" ],
                99  => [ "BWAS-Direct-Vm-Xfer-Invoke-Time",         "string" ],
                100 => [ "BWAS-Direct-Vm-Xfer-Fac-Result",          "string" ],
                101 => [ "BWAS-Dnd-Act-Invoke-Time",                "string" ],
                102 => [ "BWAS-Dnd-Act-Fac-Result",                 "string" ],
                103 => [ "BWAS-Dnd-Deact-Invoke-Time",              "string" ],
                104 => [ "BWAS-Dnd-Deact-Fac-Result",               "string" ],
                105 => [ "BWAS-Sac-Lock-Invoke-Time",               "string" ],
                106 => [ "BWAS-Sac-Lock-Fac-Result",                "string" ],
                107 => [ "BWAS-Sac-Unlock-Invoke-Time",             "string" ],
                108 => [ "BWAS-Sac-Unlock-Fac-Result",              "string" ],
                109 => [ "BWAS-Flash-Call-Hold-Invoke-Time",        "string" ],
                110 => [ "BWAS-Flash-Call-Hold-Fac-Result",         "string" ],
                111 => [ "BWAS-Last-Number-Redial-Invoke-Time",     "string" ],
                112 => [ "BWAS-Last-Number-Redial-Fac-Result",      "string" ],
                113 => [ "BWAS-Return-Call-Invoke-Time",            "string" ],
                114 => [ "BWAS-Return-Call-Fac-Result",             "string" ],
                115 => [ "BWAS-Sd100-Programming-Invoke-Time",      "string" ],
                116 => [ "BWAS-Sd100-Programming-Fac-Result",       "string" ],
                117 => [ "BWAS-Sd8-Programming-Invoke-Time",        "string" ],
                118 => [ "BWAS-Sd8-Programming-Fac-Result",         "string" ],
                119 => [ "BWAS-Clear-Mwi-Invoke-Time",              "string" ],
                120 => [ "BWAS-Clear-Mwi-Fac-Result",               "string" ],
                121 => [ "BWAS-UserId",                             "string" ],
                122 => [ "BWAS-Other-Party-Name",                   "string" ],
                123 => [ "BWAS-Other-Party-Name-Pres-Indic",        "string" ],
                125 => [ "BWAS-Moh-Deact-Fac-Result",               "string" ],
                126 => [ "BWAS-Push-to-Talk-Invoke-Time",           "string" ],
                127 => [ "BWAS-Push-to-Talk-Fac-Result",            "string" ],
                128 => [ "BWAS-Hoteling-Invoke-Time",               "string" ],
                129 => [ "BWAS-Hoteling-Group",                     "string" ],
                130 => [ "BWAS-Hoteling-UserId",                    "string" ],
                131 => [ "BWAS-Hoteling-User-Number",               "string" ],
                132 => [ "BWAS-Hoteling-Group-Number",              "string" ],
                133 => [ "BWAS-Diversion-Inhibitor-Invoke-time",    "string" ],
                134 => [ "BWAS-Diversion-Inhibitor-Fac-Result",     "string" ],
                135 => [ "BWAS-Trunk-Group-Name",                   "string" ],
                136 => [ "BWAS-Spare-136",                          "string" ],
                137 => [ "BWAS-InstantGroupCall-Invoke-Time",       "string" ],
                138 => [ "BWAS-InstantGroupCall-PushToTalk",        "string" ],
                139 => [ "BWAS-InstantGroupCall-Related-Callid",    "string" ],
                140 => [ "BWAS-CustomRingback-Invoke-Time",         "string" ],
                141 => [ "BWAS-CLID-Permitted",                     "string" ],
                142 => [ "BWAS-AHR-Invoke-Time",                    "string" ],
                143 => [ "BWAS-AHR-Action",                         "string" ],
                144 => [ "BWAS-Access-Network-Info",                "string" ],
                145 => [ "BWAS-Charging-Function-Addresses",        "string" ],
                146 => [ "BWAS-Charge-Number",                      "string" ],
                147 => [ "BWAS-Related-CallId",                     "string" ],
                148 => [ "BWAS-Related-CallId-Reason",              "string" ],
                149 => [ "BWAS-Transfer-Invoke-Time",               "string" ],
                150 => [ "BWAS-Transfer-Result",                    "string" ],
                151 => [ "BWAS-Transfer-Related-CallId",            "string" ],
                152 => [ "BWAS-Transfer-Type",                      "string" ],
                153 => [ "BWAS-Conf-Start-Time",                    "string" ],
                154 => [ "BWAS-Conf-Stop-Time",                     "string" ],
                155 => [ "BWAS-Conf-Id",                            "string" ],
                156 => [ "BWAS-Conf-Type",                          "string" ],
                157 => [ "BWAS-Codec-Usage",                        "string" ],
                158 => [ "BWAS-Vmb-Act-Invoke-Time",                "string" ],
                159 => [ "BWAS-Vmb-Act-Fac-Result",                 "string" ],
                160 => [ "BWAS-Vmb-Deact-Invoke-Time",              "string" ],
                161 => [ "BWAS-Vmb-Deact-Fac-Result",               "string" ],
                162 => [ "BWAS-Vmna-Act-Invoke-Time",               "string" ],
                163 => [ "BWAS-Vmna-Act-Fac-Result",                "string" ],
                164 => [ "BWAS-Vmna-Deact-Invoke-Time",             "string" ],
                165 => [ "BWAS-Vmna-Deact-Fac-Result",              "string" ],
                166 => [ "BWAS-Vma-Act-Invoke-Time",                "string" ],
                167 => [ "BWAS-Vma-Act-Fac-Result",                 "string" ],
                168 => [ "BWAS-Vma-Deact-Invoke-Time",              "string" ],
                169 => [ "BWAS-Vma-Deact-Fac-Result",               "string" ],
                170 => [ "BWAS-No-Answer-Set-Invoke-Time",          "string" ],
                171 => [ "BWAS-No-Answer-Set-Fac-Result",           "string" ],
                172 => [ "BWAS-Clid-Blocking-Act-Invoke-Time",      "string" ],
                173 => [ "BWAS-Clid-Blocking-Act-Fac-Result",       "string" ],
                174 => [ "BWAS-Clid-Blocking-Deact-Invoke-Time",    "string" ],
                175 => [ "BWAS-Clid-Blocking-Deact-Fac-Result",     "string" ],
                176 => [ "BWAS-Call-Waiting-Act-Invoke-Time",       "string" ],
                177 => [ "BWAS-Call-Waiting-Act-Fac-Result",        "string" ],
                178 => [ "BWAS-Call-Waiting-Deact-Invoke-Time",     "string" ],
                179 => [ "BWAS-Call-Waiting-Deact-Fac-Result",      "string" ],
                180 => [ "BWAS-Fax-Messaging",                      "string" ],
                181 => [ "BWAS-TSD-Digits",                         "string" ],
                182 => [ "BWAS-Trunk-Group-Info",                   "string" ],
                183 => [ "BWAS-Recall-Type",                        "string" ],
                184 => [ "BWAS-Cfnrc-Act-Invoke-Time",              "string" ],
                185 => [ "BWAS-Cfnrc-Act-Fac-Result",               "string" ],
                186 => [ "BWAS-Cfnrc-Deact-Invoke-Time",            "string" ],
                187 => [ "BWAS-Cfnrc-Deact-Fac-Result",             "string" ],
                188 => [ "BWAS-Q850-Cause",                         "string" ],
                189 => [ "BWAS-Dialed-Digits-Context",              "string" ],
                190 => [ "BWAS-Called-Number-Context",              "string" ],
                191 => [ "BWAS-Network-Translated-Number-Context",  "string" ],
                192 => [ "BWAS-Calling-Number-Context",             "string" ],
                193 => [ "BWAS-Original-Called-Number-Context",     "string" ],
                194 => [ "BWAS-Redirecting-Number-Context",         "string" ],
                195 => [ "BWAS-Location-Control-Act-Result",        "string" ],
                196 => [ "BWAS-Location-Control-Deact-Result",      "string" ],
                197 => [ "BWAS-Call-Retrieve-Result",               "string" ],
                198 => [ "BWAS-Routing-Number",                     "string" ],
                199 => [ "BWAS-Origination-Method",                 "string" ],
                200 => [ "BWAS-Call-Parked-Invoke-Time",            "string" ],
                201 => [ "BWAS-BA-Related-Call-Id",                 "string" ],
                202 => [ "BWAS-Acr-Act-Invoke-Time",                "string" ],
                203 => [ "BWAS-Acr-Act-Fac-Result",                 "string" ],
                204 => [ "BWAS-Acr-Deact-Invoke-Time",              "string" ],
                205 => [ "BWAS-Acr-Deact-Fac-Result",               "string" ],
                206 => [ "BWAS-Outside-Access-Code",                "string" ],
                207 => [ "BWAS-Primary-Device-Line-Port",           "string" ],
                208 => [ "BWAS-Called-Asserted-Identity",           "string" ],
                209 => [ "BWAS-Called-Asserted-Pres-Indicator",     "string" ],
                210 => [ "BWAS-SDP",                                "string" ],
                211 => [ "BWAS-Media-Initiator-Flag",               "string" ],
                212 => [ "BWAS-SDP-Offer-Timestamp",                "string" ],
                213 => [ "BWAS-SDP-Answer-Timestamp",               "string" ],
                214 => [ "BWAS-Early-Media-SDP",                    "string" ],
                215 => [ "BWAS-Early-Media-Initiator-Flag",         "string" ],
                216 => [ "BWAS-Body-Content-Type",                  "string" ],
                217 => [ "BWAS-Body-Content-Length",                "string" ],
                218 => [ "BWAS-Body-Content-Disposition",           "string" ],
                219 => [ "BWAS-Body-Originator",                    "string" ],
                220 => [ "BWAS-SIP-Error-Code",                     "string" ],
                221 => [ "BWAS-OtherInfoInPCV",                     "string" ],
                222 => [ "BWAS-Received-Calling-Number",            "string" ],
                223 => [ "BWAS-CustomRingback-Media-Selection",     "string" ],
                224 => [ "BWAS-AOC-Type",                           "string" ],
                225 => [ "BWAS-AOC-Charge",                         "string" ],
                226 => [ "BWAS-AOC-Currency",                       "string" ],
                227 => [ "BWAS-AOC-Time",                           "string" ],
                228 => [ "BWAS-AOC-Sum",                            "string" ],
                229 => [ "BWAS-AOC-Activation-Time",                "string" ],
                230 => [ "BWAS-AOC-Result",                         "string" ],
                231 => [ "BWAS-AS-Call-Type",                       "string" ],
                232 => [ "BWAS-Scf-Act-Invoke-Time",                "string" ],
                233 => [ "BWAS-Scf-Act-Fac-Result",                 "string" ],
                234 => [ "BWAS-Scf-Deact-Invoke-Time",              "string" ],
                235 => [ "BWAS-Scf-Deact-Fac-Result",               "string" ],
                236 => [ "BWAS-Cfa-Inter-Invoke-Time",              "string" ],
                237 => [ "BWAS-Cfa-Inter-Fac-Result",               "string" ],
                238 => [ "BWAS-Cfna-Inter-Invoke-Time",             "string" ],
                239 => [ "BWAS-Cfna-Inter-Fac-Result",              "string" ],
                240 => [ "BWAS-Cfb-Inter-Invoke-Time",              "string" ],
                241 => [ "BWAS-Cfb-Inter-Fac-Result",               "string" ],
                242 => [ "BWAS-CBF-Auth-Code",                      "string" ],
                243 => [ "BWAS-Call-Bridge-Result",                 "string" ],
                244 =>
                  [ "BWAS-Return-Call-Number-Deletion-Invoke-Time", "string" ],
                245 =>
                  [ "BWAS-Return-Call-Number-Deletion-Fac-Result", "string" ],
                246 => [ "BWAS-Prepaid-Status",    "string" ],
                247 => [ "BWAS-Configurable-CLID", "string" ],
                248 =>
                  [ "BWAS-Call-Center-Night-Service-Act-Result", "string" ],
                249 =>
                  [ "BWAS-Call-Center-Night-Service-Deact-Result", "string" ],
                250 =>
                  [ "BWAS-Call-Center-Forced-Forwarding-Act-Result", "string" ],
                251 => [
                    "BWAS-Call-Center-Forced-Forwarding-Deact-Result", "string"
                ],
                252 =>
                  [ "BWAS-Call-Center-Outgoing-Call-Fac-Result", "string" ],
                253 => [
                    "BWAS-Call-Center-Outgoing-Personal-Call-Fac-Result",
                    "string",
                ],
                254 => [ "BWAS-Call-Center-Outgoing-Phone-Number", "string" ],
                255 => [ "BroadSoft-Attr-255",                     "string" ],
            },
            6504 => { 1 => [ "Navini-AVPair", "string" ] },
            6527 => {
                1   => [ "Timetra-Access",                         "integer" ],
                2   => [ "Timetra-Home-Directory",                 "string" ],
                3   => [ "Timetra-Restrict-To-Home",               "integer" ],
                4   => [ "Timetra-Profile",                        "string" ],
                5   => [ "Timetra-Default-Action",                 "integer" ],
                6   => [ "Timetra-Cmd",                            "string" ],
                7   => [ "Timetra-Action",                         "integer" ],
                8   => [ "Timetra-Exec-File",                      "string" ],
                9   => [ "Alc-Primary-Dns",                        "ipaddr" ],
                10  => [ "Alc-Secondary-Dns",                      "ipaddr" ],
                11  => [ "Alc-Subsc-ID-Str",                       "string" ],
                12  => [ "Alc-Subsc-Prof-Str",                     "string" ],
                13  => [ "Alc-SLA-Prof-Str",                       "string" ],
                14  => [ "Alc-Force-Renew",                        "string" ],
                15  => [ "Alc-Create-Host",                        "string" ],
                16  => [ "Alc-ANCP-Str",                           "string" ],
                17  => [ "Alc-Retail-Serv-Id",                     "integer" ],
                18  => [ "Alc-Default-Router",                     "ipaddr" ],
                19  => [ "Alc-Acct-I-Inprof-Octets-64",            "octets" ],
                20  => [ "Alc-Acct-I-Outprof-Octets-64",           "octets" ],
                21  => [ "Alc-Acct-O-Inprof-Octets-64",            "octets" ],
                22  => [ "Alc-Acct-O-Outprof-Octets-64",           "octets" ],
                23  => [ "Alc-Acct-I-Inprof-Pkts-64",              "octets" ],
                24  => [ "Alc-Acct-I-Outprof-Pkts-64",             "octets" ],
                25  => [ "Alc-Acct-O-Inprof-Pkts-64",              "octets" ],
                26  => [ "Alc-Acct-O-Outprof-Pkts-64",             "octets" ],
                27  => [ "Alc-Client-Hardware-Addr",               "string" ],
                28  => [ "Alc-Int-Dest-Id-Str",                    "string" ],
                29  => [ "Alc-Primary-Nbns",                       "ipaddr" ],
                30  => [ "Alc-Secondary-Nbns",                     "ipaddr" ],
                31  => [ "Alc-MSAP-Serv-Id",                       "integer" ],
                32  => [ "Alc-MSAP-Policy",                        "string" ],
                33  => [ "Alc-MSAP-Interface",                     "string" ],
                34  => [ "Alc-PPPoE-PADO-Delay",                   "integer" ],
                35  => [ "Alc-PPPoE-Service-Name",                 "string" ],
                36  => [ "Alc-DHCP-Vendor-Class-Id",               "string" ],
                37  => [ "Alc-Acct-OC-I-Inprof-Octets-64",         "octets" ],
                38  => [ "Alc-Acct-OC-I-Outprof-Octets-64",        "octets" ],
                39  => [ "Alc-Acct-OC-O-Inprof-Octets-64",         "octets" ],
                40  => [ "Alc-Acct-OC-O-Outprof-Octets-64",        "octets" ],
                41  => [ "Alc-Acct-OC-I-Inprof-Pkts-64",           "octets" ],
                42  => [ "Alc-Acct-OC-I-Outprof-Pkts-64",          "octets" ],
                43  => [ "Alc-Acct-OC-O-Inprof-Pkts-64",           "octets" ],
                44  => [ "Alc-Acct-OC-O-Outprof-Pkts-64",          "octets" ],
                45  => [ "Alc-App-Prof-Str",                       "string" ],
                46  => [ "Alc-Tunnel-Group",                       "string" ],
                47  => [ "Alc-Tunnel-Algorithm",                   "integer" ],
                48  => [ "Alc-Tunnel-Max-Sessions",                "integer" ],
                49  => [ "Alc-Tunnel-Idle-Timeout",                "integer" ],
                50  => [ "Alc-Tunnel-Hello-Interval",              "integer" ],
                51  => [ "Alc-Tunnel-Destruct-Timeout",            "integer" ],
                52  => [ "Alc-Tunnel-Max-Retries-Estab",           "integer" ],
                53  => [ "Alc-Tunnel-Max-Retries-Not-Estab",       "integer" ],
                54  => [ "Alc-Tunnel-AVP-Hiding",                  "integer" ],
                55  => [ "Alc-BGP-Policy",                         "string" ],
                56  => [ "Alc-BGP-Auth-Keychain",                  "string" ],
                57  => [ "Alc-BGP-Auth-Key",                       "octets" ],
                58  => [ "Alc-BGP-Export-Policy",                  "string" ],
                59  => [ "Alc-BGP-Import-Policy",                  "string" ],
                60  => [ "Alc-BGP-PeerAS",                         "integer" ],
                61  => [ "Alc-IPsec-Serv-Id",                      "integer" ],
                62  => [ "Alc-IPsec-Interface",                    "string" ],
                63  => [ "Alc-IPsec-Tunnel-Template-Id",           "integer" ],
                64  => [ "Alc-IPsec-SA-Lifetime",                  "integer" ],
                65  => [ "Alc-IPsec-SA-PFS-Group",                 "integer" ],
                66  => [ "Alc-IPsec-SA-Encr-Algorithm",            "integer" ],
                67  => [ "Alc-IPsec-SA-Auth-Algorithm",            "integer" ],
                68  => [ "Alc-IPsec-SA-Replay-Window",             "integer" ],
                69  => [ "Alc-Acct-I-High-Octets-Drop_64",         "octets" ],
                70  => [ "Alc-Acct-I-Low-Octets-Drop_64",          "octets" ],
                71  => [ "Alc-Acct-I-High-Pack-Drop_64",           "octets" ],
                72  => [ "Alc-Acct-I-Low-Pack-Drop_64",            "octets" ],
                73  => [ "Alc-Acct-I-High-Octets-Offer_64",        "octets" ],
                74  => [ "Alc-Acct-I-Low-Octets-Offer_64",         "octets" ],
                75  => [ "Alc-Acct-I-High-Pack-Offer_64",          "octets" ],
                76  => [ "Alc-Acct-I-Low-Pack-Offer_64",           "octets" ],
                77  => [ "Alc-Acct-I-Unc-Octets-Offer_64",         "octets" ],
                78  => [ "Alc-Acct-I-Unc-Pack-Offer_64",           "octets" ],
                79  => [ "Alc-Acct-I-All-Octets-Offer_64",         "octets" ],
                80  => [ "Alc-Acct-I-All-Pack-Offer_64",           "octets" ],
                81  => [ "Alc-Acct-O-Inprof-Pack-Drop_64",         "octets" ],
                82  => [ "Alc-Acct-O-Outprof-Pack-Drop_64",        "octets" ],
                83  => [ "Alc-Acct-O-Inprof-Octs-Drop_64",         "octets" ],
                84  => [ "Alc-Acct-O-Outprof-Octs-Drop_64",        "octets" ],
                85  => [ "Alc-Acct-OC-I-All-Octs-Offer_64",        "octets" ],
                86  => [ "Alc-Acct-OC-I-All-Pack-Offer_64",        "octets" ],
                87  => [ "Alc-Acct-OC-I-Inpr-Octs-Drop_64",        "octets" ],
                88  => [ "Alc-Acct-OC-I-Outpr-Octs-Drop_64",       "octets" ],
                89  => [ "Alc-Acct-OC-I-Inpr-Pack-Drop_64",        "octets" ],
                90  => [ "Alc-Acct-OC-I-Outpr-Pack-Drop_64",       "octets" ],
                91  => [ "Alc-Acct-OC-O-Inpr-Pack-Drop_64",        "octets" ],
                92  => [ "Alc-Acct-OC-O-Outpr-Pack-Drop_64",       "octets" ],
                93  => [ "Alc-Acct-OC-O-Inpr-Octs-Drop_64",        "octets" ],
                94  => [ "Alc-Acct-OC-O-Outpr-Octs-Drop_64",       "octets" ],
                95  => [ "Alc-Credit-Control-CategoryMap",         "string" ],
                96  => [ "Alc-Credit-Control-Quota",               "string" ],
                97  => [ "Alc-Tunnel-Challenge",                   "integer" ],
                98  => [ "Alc-Force-Nak",                          "string" ],
                99  => [ "Alc-Ipv6-Address",                       "ipv6addr" ],
                100 => [ "Alc-Serv-Id",                            "integer" ],
                101 => [ "Alc-Interface",                          "string" ],
                102 => [ "Alc-ToServer-Dhcp-Options",              "octets" ],
                103 => [ "Alc-ToClient-Dhcp-Options",              "octets" ],
                104 => [ "Alc-Tunnel-Serv-Id",                     "integer" ],
                105 => [ "Alc-Ipv6-Primary-Dns",                   "ipv6addr" ],
                106 => [ "Alc-Ipv6-Secondary-Dns",                 "ipv6addr" ],
                107 => [ "Alc-Acct-I-statmode",                    "string" ],
                108 => [ "Alc-Acct-I-Hiprio-Octets_64",            "octets" ],
                109 => [ "Alc-Acct-I-Lowprio-Octets_64",           "octets" ],
                110 => [ "Alc-Acct-O-Hiprio-Octets_64",            "octets" ],
                111 => [ "Alc-Acct-O-Lowprio-Octets_64",           "octets" ],
                112 => [ "Alc-Acct-I-Hiprio-Packets_64",           "octets" ],
                113 => [ "Alc-Acct-I-Lowprio-Packets_64",          "octets" ],
                114 => [ "Alc-Acct-O-Hiprio-Packets_64",           "octets" ],
                115 => [ "Alc-Acct-O-Lowprio-Packets_64",          "octets" ],
                116 => [ "Alc-Acct-I-All-Octets_64",               "octets" ],
                117 => [ "Alc-Acct-O-All-Octets_64",               "octets" ],
                118 => [ "Alc-Acct-I-All-Packets_64",              "octets" ],
                119 => [ "Alc-Acct-O-All-Packets_64",              "octets" ],
                120 => [ "Alc-Tunnel-Rx-Window-Size",              "integer" ],
                121 => [ "Alc-Nat-Port-Range",                     "string" ],
                122 => [ "Alc-LI-Action",                          "integer" ],
                123 => [ "Alc-LI-Destination",                     "string" ],
                124 => [ "Alc-LI-FC",                              "integer" ],
                125 => [ "Alc-LI-Direction",                       "integer" ],
                126 => [ "Alc-Subscriber-QoS-Override",            "string" ],
                127 => [ "Alc-Acct-O-statmode",                    "string" ],
                128 => [ "Alc-ATM-Ingress-TD-Profile",             "integer" ],
                129 => [ "Alc-ATM-Egress-TD-Profile",              "integer" ],
                130 => [ "Alc-AA-Transit-IP",                      "integer" ],
                131 => [ "Alc-Delegated-IPv6-Pool",                "string" ],
                132 => [ "Alc-Access-Loop-Rate-Down",              "integer" ],
                133 => [ "Alc-Access-Loop-Encap-Offset",           "octets" ],
                134 => [ "Alc-Subscriber-Filter",                  "string" ],
                135 => [ "Alc-PPP-Force-IPv6CP",                   "integer" ],
                136 => [ "Alc-Onetime-Http-Redirection-Filter-Id", "string" ],
                137 => [ "Alc-Authentication-Policy-Name",         "string" ],
                138 => [ "Alc-LI-Intercept-Id",                    "integer" ],
                139 => [ "Alc-LI-Session-Id",                      "integer" ],
                140 => [ "Alc-Nat-Outside-Serv-Id",                "integer" ],
                141 => [ "Alc-Nat-Outside-Ip-Addr",                "ipaddr" ],
                142 => [ "Alc-APN-Password",                       "string" ],
                143 => [ "Alc-APN-Name",                           "string" ],
                144 => [ "Alc-Tunnel-Acct-Policy",                 "string" ],
                145 => [ "Alc-Mgw-Interface-Type",                 "integer" ],
                146 => [ "Alc-Wlan-APN-Name",                      "string" ],
                147 => [ "Alc-MsIsdn",                             "string" ],
                148 => [ "Alc-RSSI",                               "integer" ],
                149 => [ "Alc-Num-Attached-UEs",                   "integer" ],
                150 => [ "Alc-Charging-Prof-ID",                   "integer" ],
                156 => [ "Alc-AA-Group-Partition-Isa-Id",          "string" ],
                157 => [ "Alc-AA-Peer-Identifier",                 "string" ],
                158 => [ "Alc-Nas-Filter-Rule-Shared",             "string" ],
                159 => [ "Alc-Ascend-Data-Filter-Host-Spec",       "abinary" ],
                160 => [ "Alc-Relative-Session-Timeout",           "integer" ],
                163 => [ "Alc-Acct-Triggered-Reason",              "integer" ],
                172 => [ "Alc-Wlan-Portal-Redirect",               "string" ],
                173 => [ "Alc-Wlan-Portal-Url",                    "string" ],
                174 => [ "Alc-Lease-Time",                         "integer" ],
                175 => [ "Alc-DSL-Line-State",                     "integer" ],
                176 => [ "Alc-DSL-Type",                           "integer" ],
                177 => [ "Alc-Portal-Url",                         "string" ],
                178 => [ "Alc-Ipv6-Portal-Url",                    "string" ],
                180 => [ "Alc-SAP-Session-Index",                  "integer" ],
                181 => [ "Alc-SLAAC-IPv6-Pool",                    "string" ],
                183 => [ "Alc-WPP-ErrorCode",                      "integer" ],
                185 => [ "Alc-Onetime-Http-Redirect-Reactivate",   "string" ],
                191 => [ "Alc-ToServer-Dhcp6-Options",             "octets" ],
                192 => [ "Alc-ToClient-Dhcp6-Options",             "octets" ],
                200 => [ "Alc-v6-Preferred-Lifetime",              "integer" ],
                201 => [ "Alc-v6-Valid-Lifetime",                  "integer" ],
                202 => [ "Alc-Dhcp6-Renew-Time",                   "integer" ],
                203 => [ "Alc-Dhcp6-Rebind-Time",                  "integer" ],
                206 => [ "Alc-Wlan-SSID-VLAN",                     "string" ],
                217 => [ "Alc-UPnP-Sub-Override-Policy",           "string" ],
                228 => [ "Alc-Trigger-Acct-Interim",               "string" ],
                232 => [ "Alc-Acct-Interim-Level",                 "integer" ],
                234 => [ "Alc-DNAT-Override",                      "string" ],
                238 => [ "Alc-Remove-Override",                    "string" ],
                242 => [ "Alc-Radius-Py",                          "octets" ],
                244 => [ "Alc-Force-DHCP-Relay",                   "string" ],
            },
            6618 => {
                1   => [ "Quintum-AVPair",                   "string" ],
                2   => [ "Quintum-NAS-Port",                 "string" ],
                23  => [ "Quintum-h323-remote-address",      "string" ],
                24  => [ "Quintum-h323-conf-id",             "string" ],
                25  => [ "Quintum-h323-setup-time",          "string" ],
                26  => [ "Quintum-h323-call-origin",         "string" ],
                27  => [ "Quintum-h323-call-type",           "string" ],
                28  => [ "Quintum-h323-connect-time",        "string" ],
                29  => [ "Quintum-h323-disconnect-time",     "string" ],
                30  => [ "Quintum-h323-disconnect-cause",    "string" ],
                31  => [ "Quintum-h323-voice-quality",       "string" ],
                33  => [ "Quintum-h323-gw-id",               "string" ],
                35  => [ "Quintum-h323-incoming-conf-id",    "string" ],
                101 => [ "Quintum-h323-credit-amount",       "string" ],
                102 => [ "Quintum-h323-credit-time",         "string" ],
                103 => [ "Quintum-h323-return-code",         "string" ],
                104 => [ "Quintum-h323-prompt-id",           "string" ],
                105 => [ "Quintum-h323-time-and-day",        "string" ],
                106 => [ "Quintum-h323-redirect-number",     "string" ],
                107 => [ "Quintum-h323-preferred-lang",      "string" ],
                108 => [ "Quintum-h323-redirect-ip-address", "string" ],
                109 => [ "Quintum-h323-billing-model",       "string" ],
                110 => [ "Quintum-h323-currency-type",       "string" ],
                230 => [ "Quintum-Trunkid-In",               "string" ],
                231 => [ "Quintum-Trunkid-Out",              "string" ],
            },
            6983 => {
                1 => [ "SofaWare-Admin",   "string" ],
                2 => [ "SofaWare-VPN",     "string" ],
                3 => [ "SofaWare-Hotspot", "string" ],
                4 => [ "SofaWare-UFP",     "string" ],
            },
            7000 => { 1 => [ "Slipstream-Auth", "string" ] },
            7064 => {
                140 => [ "UTStarcom-VLAN-ID",              "integer" ],
                142 => [ "UTStarcom-CommittedBandwidth",   "integer" ],
                143 => [ "UTStarcom-MaxBandwidth",         "integer" ],
                145 => [ "UTStarcom-Priority",             "integer" ],
                147 => [ "UTStarcom-Error-Reason",         "integer" ],
                152 => [ "UTStarcom-PrimaryDNS",           "integer" ],
                153 => [ "UTStarcom-SecondaryDNS",         "integer" ],
                161 => [ "UTStarcom-MaxBurstSize",         "integer" ],
                162 => [ "UTStarcom-MaxDelay",             "integer" ],
                163 => [ "UTStarcom-MaxJitter",            "integer" ],
                165 => [ "UTStarcom-DeviceId",             "string" ],
                166 => [ "UTStarcom-Module-Id",            "integer" ],
                167 => [ "UTStarcom-Port-No",              "integer" ],
                168 => [ "UTStarcom-Logical-Port-No",      "integer" ],
                169 => [ "UTStarcom-UNI-MAX-MAC",          "integer" ],
                170 => [ "UTStarcom-Default-Gateway",      "integer" ],
                171 => [ "UTStarcom-CLI-Access-Level",     "integer" ],
                180 => [ "UTStarcom-Act-Input-Octets",     "string" ],
                181 => [ "UTStarcom-Act-Output-Octets",    "string" ],
                182 => [ "UTStarcom-Act-Input-Frames",     "string" ],
                183 => [ "UTStarcom-Act-Output-Frames",    "string" ],
                184 => [ "UTStarcom-Onu-MC-Filter-Enable", "integer" ],
                185 => [ "UTStarcom-UNI-Auto-Negotiation", "integer" ],
                186 => [ "UTStarcom-UNI-Speed",            "integer" ],
                187 => [ "UTStarcom-UNI-Duplex",           "integer" ],
                188 => [ "UTStarcom-ONU-Admin_status",     "integer" ],
                189 => [ "UTStarcom-ONU-FW-SC-Upgrade",    "integer" ],
            },
            7119 => { 33 => [ "NetSensory-Privilege",       "string" ] },
            7146 => { 1  => [ "Zeus-ZXTM-Group",            "string" ] },
            7262 => { 1  => [ "DragonWave-Privilege-Level", "integer" ] },
            7751 => {
                1  => [ "Azaire-Triplets",           "octets" ],
                2  => [ "Azaire-IMSI",               "octets" ],
                3  => [ "Azaire-MSISDN",             "octets" ],
                4  => [ "Azaire-APN",                "string" ],
                5  => [ "Azaire-QoS",                "octets" ],
                6  => [ "Azaire-Selection-Mode",     "integer" ],
                7  => [ "Azaire-APN-Resolution-Req", "integer" ],
                8  => [ "Azaire-Start-Time",         "octets" ],
                9  => [ "Azaire-NAS-Type",           "integer" ],
                10 => [ "Azaire-Status",             "integer" ],
                11 => [ "Azaire-APN-OI",             "string" ],
                12 => [ "Azaire-Auth-Type",          "integer" ],
                13 => [ "Azaire-Gn-User-Name",       "string" ],
                14 => [ "Azaire-Brand-Code",         "string" ],
                15 => [ "Azaire-Policy-Name",        "string" ],
                16 => [ "Azaire-Client-Local-IP",    "ipaddr" ],
            },
            7779 => {
                1 => [ "Infoblox-windows-group", "string" ],
                2 => [ "Infoblox-variable-1",    "string" ],
                3 => [ "Infoblox-variable-2",    "string" ],
                4 => [ "Infoblox-variable-3",    "string" ],
                5 => [ "Infoblox-variable-4",    "string" ],
                6 => [ "Infoblox-variable-5",    "string" ],
                7 => [ "Infoblox-Version",       "string" ],
                8 => [ "Infoblox-Product-Name",  "string" ],
                9 => [ "Infoblox-Group-Info",    "string" ],
            },
            8164 => {
                1     => [ "SN-VPN-ID",                       "integer" ],
                2     => [ "SN-VPN-Name",                     "string" ],
                3     => [ "SN-Disconnect-Reason",            "integer" ],
                4     => [ "SN-PPP-Progress-Code",            "integer" ],
                5     => [ "SN-Primary-DNS-Server",           "ipaddr" ],
                6     => [ "SN-Secondary-DNS-Server",         "ipaddr" ],
                7     => [ "SN-Re-CHAP-Interval",             "integer" ],
                8     => [ "SN-IP-Pool-Name",                 "string" ],
                9     => [ "SN-PPP-Data-Compression",         "integer" ],
                10    => [ "SN-IP-Filter-In",                 "string" ],
                11    => [ "SN-IP-Filter-Out",                "string" ],
                13    => [ "SN-Local-IP-Address",             "ipaddr" ],
                14    => [ "SN-IP-Source-Validation",         "integer" ],
                15    => [ "SN-PPP-Outbound-Password",        "string" ],
                16    => [ "SN-PPP-Keepalive",                "integer" ],
                17    => [ "SN-IP-In-ACL",                    "string" ],
                18    => [ "SN-IP-Out-ACL",                   "string" ],
                19    => [ "SN-PPP-Data-Compression-Mode",    "integer" ],
                20    => [ "SN-Subscriber-Permission",        "integer" ],
                21    => [ "SN-Admin-Permission",             "integer" ],
                22    => [ "SN-Simultaneous-SIP-MIP",         "integer" ],
                23    => [ "SN-Min-Compress-Size",            "integer" ],
                24    => [ "SN-Service-Type",                 "integer" ],
                25    => [ "SN-DNS-Proxy-Use-Subscr-Addr",    "integer" ],
                26    => [ "SN-Tunnel-Password",              "octets" ],
                27    => [ "SN-Tunnel-Load-Balancing",        "integer" ],
                30    => [ "SN-MN-HA-Timestamp-Tolerance",    "integer" ],
                31    => [ "SN-Prepaid-Compressed-Count",     "integer" ],
                32    => [ "SN-Prepaid-Inbound-Octets",       "integer" ],
                33    => [ "SN-Prepaid-Outbound-Octets",      "integer" ],
                34    => [ "SN-Prepaid-Total-Octets",         "integer" ],
                35    => [ "SN-Prepaid-Timeout",              "integer" ],
                36    => [ "SN-Prepaid-Watermark",            "integer" ],
                37    => [ "SN-NAI-Construction-Domain",      "string" ],
                38    => [ "SN-Tunnel-ISAKMP-Crypto-Map",     "string" ],
                39    => [ "SN-Tunnel-ISAKMP-Secret",         "string" ],
                41    => [ "SN-Ext-Inline-Srvr-Context",      "string" ],
                43    => [ "SN-L3-to-L2-Tun-Addr-Policy",     "integer" ],
                44    => [ "SN-Long-Duration-Timeout",        "integer" ],
                45    => [ "SN-Long-Duration-Action",         "integer" ],
                46    => [ "SN-PDSN-Handoff-Req-IP-Addr",     "integer" ],
                47    => [ "SN-HA-Send-DNS-ADDRESS",          "integer" ],
                48    => [ "SN-MIP-Send-Term-Verification",   "integer" ],
                49    => [ "SN-Data-Tunnel-Ignore-DF-Bit",    "integer" ],
                50    => [ "SN-MIP-AAA-Assign-Addr",          "integer" ],
                51    => [ "SN-MIP-Match-AAA-Assign-Addr",    "integer" ],
                52    => [ "SN-Proxy-MIP",                    "integer" ],
                53    => [ "SN-IP-Alloc-Method",              "integer" ],
                54    => [ "SN-Gratuitous-ARP-Aggressive",    "integer" ],
                55    => [ "SN-Ext-Inline-Srvr-Up-Addr",      "ipaddr" ],
                56    => [ "SN-Ext-Inline-Srvr-Down-Addr",    "ipaddr" ],
                57    => [ "SN-Ext-Inline-Srvr-Preference",   "integer" ],
                58    => [ "SN-Ext-Inline-Srvr-Up-VLAN",      "octets" ],
                59    => [ "SN-Ext-Inline-Srvr-Down-VLAN",    "octets" ],
                60    => [ "SN-IP-Hide-Service-Address",      "integer" ],
                61    => [ "SN-PPP-Outbound-Username",        "string" ],
                62    => [ "SN-GTP-Version",                  "integer" ],
                63    => [ "SN-Access-link-IP-Frag",          "integer" ],
                64    => [ "SN-Subscriber-Accounting",        "integer" ],
                65    => [ "SN-Nw-Reachability-Server-Name",  "string" ],
                67    => [ "SN-Subscriber-IP-Hdr-Neg-Mode",   "integer" ],
                68    => [ "SN-GGSN-MIP-Required",            "integer" ],
                69    => [ "SN-Subscriber-Acct-Start",        "integer" ],
                70    => [ "SN-Subscriber-Acct-Interim",      "integer" ],
                71    => [ "SN-Subscriber-Acct-Stop",         "integer" ],
                73    => [ "SN-QoS-Tp-Dnlk",                  "integer" ],
                74    => [ "SN-Tp-Dnlk-Committed-Data-Rate",  "integer" ],
                75    => [ "SN-Tp-Dnlk-Peak-Data-Rate",       "integer" ],
                76    => [ "SN-Tp-Dnlk-Burst-Size",           "integer" ],
                77    => [ "SN-Tp-Dnlk-Exceed-Action",        "integer" ],
                78    => [ "SN-Tp-Dnlk-Violate-Action",       "integer" ],
                79    => [ "SN-QoS-Tp-Uplk",                  "integer" ],
                80    => [ "SN-Tp-Uplk-Committed-Data-Rate",  "integer" ],
                81    => [ "SN-Tp-Uplk-Peak-Data-Rate",       "integer" ],
                82    => [ "SN-Tp-Uplk-Burst-Size",           "integer" ],
                83    => [ "SN-Tp-Uplk-Exceed-Action",        "integer" ],
                84    => [ "SN-Tp-Uplk-Violate-Action",       "integer" ],
                85    => [ "SN-Subscriber-IP-TOS-Copy",       "integer" ],
                86    => [ "SN-QoS-Conversation-Class",       "octets" ],
                87    => [ "SN-QoS-Streaming-Class",          "octets" ],
                88    => [ "SN-QoS-Interactive1-Class",       "octets" ],
                89    => [ "SN-QoS-Interactive2-Class",       "octets" ],
                90    => [ "SN-QoS-Interactive3-Class",       "octets" ],
                91    => [ "SN-QoS-Background-Class",         "octets" ],
                92    => [ "SN-PPP-NW-Layer-IPv4",            "integer" ],
                93    => [ "SN-PPP-NW-Layer-IPv6",            "integer" ],
                94    => [ "SN-Virtual-APN-Name",             "string" ],
                95    => [ "SN-PPP-Accept-Peer-v6Ifid",       "integer" ],
                96    => [ "SN-IPv6-rtr-advt-interval",       "integer" ],
                97    => [ "SN-IPv6-num-rtr-advt",            "integer" ],
                98    => [ "SN-NPU-Qos-Priority",             "integer" ],
                99    => [ "SN-MN-HA-Hash-Algorithm",         "integer" ],
                100   => [ "SN-Subscriber-Acct-Rsp-Action",   "integer" ],
                101   => [ "SN-IPv6-Primary-DNS",             "ipv6addr" ],
                102   => [ "SN-IPv6-Secondary-DNS",           "octets" ],
                103   => [ "SN-IPv6-Egress-Filtering",        "integer" ],
                104   => [ "SN-Mediation-VPN-Name",           "string" ],
                105   => [ "SN-Mediation-Acct-Rsp-Action",    "integer" ],
                106   => [ "SN-Home-Sub-Use-GGSN",            "integer" ],
                107   => [ "SN-Visiting-Sub-Use-GGSN",        "integer" ],
                108   => [ "SN-Roaming-Sub-Use-GGSN",         "integer" ],
                109   => [ "SN-Home-Profile",                 "integer" ],
                110   => [ "SN-IP-Src-Validation-Drop-Limit", "integer" ],
                111   => [ "SN-QoS-Class-Conversational-PHB", "integer" ],
                112   => [ "SN-QoS-Class-Streaming-PHB",      "integer" ],
                113   => [ "SN-QoS-Class-Background-PHB",     "integer" ],
                114   => [ "SN-QoS-Class-Interactive-1-PHB",  "integer" ],
                115   => [ "SN-QoS-Class-Interactive-2-PHB",  "integer" ],
                116   => [ "SN-QoS-Class-Interactive-3-PHB",  "integer" ],
                117   => [ "SN-Visiting-Profile",             "integer" ],
                118   => [ "SN-Roaming-Profile",              "integer" ],
                119   => [ "SN-Home-Behavior",                "integer" ],
                120   => [ "SN-Visiting-Behavior",            "integer" ],
                121   => [ "SN-Roaming-Behavior",             "integer" ],
                122   => [ "SN-Internal-SM-Index",            "integer" ],
                123   => [ "SN-Mediation-Enabled",            "integer" ],
                124   => [ "SN-IPv6-Sec-Pool",                "string" ],
                125   => [ "SN-IPv6-Sec-Prefix",              "octets" ],
                126   => [ "SN-IPv6-DNS-Proxy",               "integer" ],
                127   => [ "SN-Subscriber-Nexthop-Address",   "integer" ],
                128   => [ "SN-Prepaid",                      "integer" ],
                129   => [ "SN-Prepaid-Preference",           "integer" ],
                130   => [ "SN-PPP-Always-On-Vse",            "integer" ],
                131   => [ "SN-Voice-Push-List-Name",         "string" ],
                132   => [ "SN-Unclassify-List-Name",         "string" ],
                133   => [ "SN-Subscriber-No-Interims",       "integer" ],
                134   => [ "SN-Permit-User-Mcast-PDUs",       "integer" ],
                135   => [ "SN-Prepaid-Final-Duration-Alg",   "integer" ],
                136   => [ "SN-IPv6-Min-Link-MTU",            "integer" ],
                137   => [ "SN-Charging-VPN-Name",            "string" ],
                138   => [ "SN-Chrg-Char-Selection-Mode",     "integer" ],
                139   => [ "SN-Cause-For-Rec-Closing",        "integer" ],
                140   => [ "SN-Change-Condition",             "integer" ],
                141   => [ "SN-Dynamic-Addr-Alloc-Ind-Flag",  "octets" ],
                142   => [ "SN-Ntk-Initiated-Ctx-Ind-Flag",   "octets" ],
                143   => [ "SN-Ntk-Session-Disconnect-Flag",  "integer" ],
                144   => [ "SN-Enable-QoS-Renegotiation",     "integer" ],
                145   => [ "SN-QoS-Renegotiation-Timeout",    "integer" ],
                146   => [ "SN-Mediation-No-Interims",        "integer" ],
                147   => [ "SN-QoS-Negotiated",               "string" ],
                148   => [ "SN-Primary-NBNS-Server",          "ipaddr" ],
                149   => [ "SN-Secondary-NBNS-Server",        "ipaddr" ],
                150   => [ "SN-IP-Header-Compression",        "integer" ],
                151   => [ "SN-Mode",                         "integer" ],
                152   => [ "SN-Assigned-VLAN-ID",             "short" ],
                153   => [ "SN-Direction",                    "integer" ],
                154   => [ "SN-MIP-HA-Assignment-Table",      "string" ],
                156   => [ "SN-Tun-Addr-Policy",              "integer" ],
                157   => [ "SN-DHCP-Lease-Expiry-Policy",     "integer" ],
                158   => [ "SN-Subscriber-Template-Name",     "string" ],
                159   => [ "SN-Subs-IMSA-Service-Name",       "string" ],
                161   => [ "SN-Traffic-Group",                "integer" ],
                162   => [ "SN-Rad-APN-Name",                 "octets" ],
                163   => [ "SN-MIP-Send-Ancid",               "integer" ],
                164   => [ "SN-MIP-Send-Imsi",                "integer" ],
                165   => [ "SN-MIP-Dual-Anchor",              "integer" ],
                166   => [ "SN-MIP-ANCID",                    "octets" ],
                167   => [ "SN-IMS-AM-Address",               "ipaddr" ],
                168   => [ "SN-IMS-AM-Domain-Name",           "octets" ],
                169   => [ "SN-Service-Address",              "ipaddr" ],
                170   => [ "SN-PDIF-MIP-Required",            "integer" ],
                171   => [ "SN-FMC-Location",                 "octets" ],
                172   => [ "SN-PDIF-MIP-Release-TIA",         "integer" ],
                173   => [ "SN-PDIF-MIP-Simple-IP-Fallback",  "integer" ],
                174   => [ "SN-Tunnel-Gn",                    "integer" ],
                175   => [ "SN-MIP-Reg-Lifetime-Realm",       "integer" ],
                176   => [ "SN-Ecs-Data-Volume",              "octets" ],
                177   => [ "SN-QoS-Traffic-Policy",           "octets" ],
                178   => [ "SN-ANID",                         "octets" ],
                187   => [ "SN-PPP-Reneg-Disc",               "integer" ],
                188   => [ "SN-MIP-Send-Correlation-Info",    "integer" ],
                189   => [ "SN-PDSN-Correlation-Id",          "octets" ],
                190   => [ "SN-PDSN-NAS-Id",                  "string" ],
                191   => [ "SN-PDSN-NAS-IP-Address",          "ipaddr" ],
                192   => [ "SN-Subscriber-Acct-Mode",         "integer" ],
                193   => [ "SN-IP-In-Plcy-Grp",               "string" ],
                194   => [ "SN-IP-Out-Plcy-Grp",              "string" ],
                196   => [ "SN-IP-Source-Violate-No-Acct",    "integer" ],
                198   => [ "SN-Firewall-Enabled",             "integer" ],
                200   => [ "SNA-PPP-Unfr-data-In-Oct",        "integer" ],
                201   => [ "SNA-PPP-Unfr-data-Out-Oct",       "integer" ],
                202   => [ "SNA-PPP-Unfr-Data-In-Gig",        "integer" ],
                203   => [ "SNA-PPP-Unfr-Data-Out-Gig",       "integer" ],
                204   => [ "SN-Admin-Expiry",                 "integer" ],
                206   => [ "SNA-Input-Gigawords",             "integer" ],
                207   => [ "SNA-Output-Gigawords",            "integer" ],
                214   => [ "SN-DNS-Proxy-Intercept-List",     "string" ],
                219   => [ "SN-Subscriber-Class",             "integer" ],
                220   => [ "SN-CFPolicy-ID",                  "integer" ],
                221   => [ "SN-Subs-VJ-Slotid-Cmp-Neg-Mode",  "integer" ],
                223   => [ "SN-Primary-DCCA-Peer",            "string" ],
                224   => [ "SN-Secondary-DCCA-Peer",          "string" ],
                225   => [ "SN-Subs-Acc-Flow-Traffic-Valid",  "integer" ],
                226   => [ "SN-Acct-Input-Packets-Dropped",   "integer" ],
                227   => [ "SN-Acct-Output-Packets-Dropped",  "integer" ],
                228   => [ "SN-Acct-Input-Octets-Dropped",    "integer64" ],
                229   => [ "SN-Acct-Output-Octets-Dropped",   "integer64" ],
                230   => [ "SN-Acct-Input-Giga-Dropped",      "integer" ],
                231   => [ "SN-Acct-Output-Giga-Dropped",     "integer" ],
                233   => [ "SN-Overload-Disc-Connect-Time",   "integer" ],
                235   => [ "SN-Overload-Disconnect",          "integer" ],
                236   => [ "SN-Radius-Returned-Username",     "integer" ],
                238   => [ "SN-ROHC-Profile-Name",            "string" ],
                239   => [ "SN-Firewall-Policy",              "octets" ],
                247   => [ "SN-Transparent-Data",             "octets" ],
                248   => [ "SN-MS-ISDN",                      "octets" ],
                249   => [ "SN-Routing-Area-Id",              "string" ],
                250   => [ "SN-Rulebase",                     "string" ],
                251   => [ "SN-Call-Id",                      "integer" ],
                252   => [ "SN-IMSI",                         "octets" ],
                253   => [ "SN-Long-Duration-Notification",   "integer" ],
                254   => [ "SN-SIP-Method",                   "integer" ],
                255   => [ "SN-Event",                        "string" ],
                256   => [ "SN-Role-Of-Node",                 "integer" ],
                257   => [ "SN-Session-Id",                   "string" ],
                258   => [ "SN-SIP-Request-Time-Stamp",       "string" ],
                259   => [ "SN-SIP-Response-Time-Stamp",      "string" ],
                260   => [ "SN-IMS-Charging-Identifier",      "string" ],
                261   => [ "SN-Originating-IOI",              "string" ],
                262   => [ "SN-Terminating-IOI",              "string" ],
                263   => [ "SN-SDP-Session-Description",      "string" ],
                264   => [ "SN-GGSN-Address",                 "ipaddr" ],
                265   => [ "SN-Sec-IP-Pool-Name",             "string" ],
                266   => [ "SN-Authorised-Qos",               "string" ],
                267   => [ "SN-Cause-Code",                   "integer" ],
                268   => [ "SN-Node-Functionality",           "integer" ],
                269   => [ "SN-Is-Unregistered-Subscriber",   "string" ],
                270   => [ "SN-Content-Type",                 "string" ],
                271   => [ "SN-Content-Length",               "string" ],
                272   => [ "SN-Content-Disposition",          "string" ],
                273   => [ "SN-CSCF-Rf-SDP-Media-Components", "octets" ],
                274   => [ "SN-ROHC-Flow-Marking-Mode",       "integer" ],
                275   => [ "SN-CSCF-App-Server-Info",         "octets" ],
                276   => [ "SN-ISC-Template-Name",            "string" ],
                277   => [ "SN-CF-Forward-Unconditional",     "string" ],
                278   => [ "SN-CF-Forward-No-Answer",         "string" ],
                279   => [ "SN-CF-Forward-Busy-Line",         "string" ],
                280   => [ "SN-CF-Forward-Not-Regd",          "string" ],
                281   => [ "SN-CF-Follow-Me",                 "string" ],
                282   => [ "SN-CF-CId-Display",               "integer" ],
                283   => [ "SN-CF-CId-Display-Blocked",       "integer" ],
                284   => [ "SN-CF-Call-Waiting",              "integer" ],
                285   => [ "SN-CF-Call-Transfer",             "integer" ],
                287   => [ "SN-Cscf-Subscriber-Ip-Address",   "ipaddr" ],
                288   => [ "SN-Software-Version",             "string" ],
                290   => [ "SN-Max-Sec-Contexts-Per-Subs",    "integer" ],
                291   => [ "SN-CF-Call-Local",                "integer" ],
                292   => [ "SN-CF-Call-LongDistance",         "integer" ],
                293   => [ "SN-CF-Call-International",        "integer" ],
                294   => [ "SN-CF-Call-Premium",              "integer" ],
                295   => [ "SN-CR-International-Cid",         "integer" ],
                296   => [ "SN-CR-LongDistance-Cid",          "integer" ],
                297   => [ "SN-NAT-IP-Address",               "ipaddr" ],
                298   => [ "SN-CF-Call-RoamingInternatnl",    "integer" ],
                299   => [ "SN-PDG-TTG-Required",             "integer" ],
                300   => [ "SN-Bandwidth-Policy",             "string" ],
                301   => [ "SN-Acs-Credit-Control-Group",     "string" ],
                302   => [ "SN-CBB-Policy",                   "string" ],
                303   => [ "SN-QOS-HLR-Profile",              "octets" ],
                304   => [ "SN-Fast-Reauth-Username",         "octets" ],
                305   => [ "SN-Pseudonym-Username",           "octets" ],
                306   => [ "SN-WiMAX-Auth-Only",              "integer" ],
                307   => [ "SN-TrafficSelector-Class",        "integer" ],
                309   => [ "SN-DHCP-Options",                 "octets" ],
                310   => [ "SN-Handoff-Indicator",            "integer" ],
                313   => [ "SN-User-Privilege",               "integer" ],
                314   => [ "SN-IPv6-Alloc-Method",            "integer" ],
                315   => [ "SN-Congestion-Mgmt-Policy",       "string" ],
                316   => [ "SN-WSG-MIP-Required",             "integer" ],
                317   => [ "SN-WSG-MIP-Release-TIA",          "integer" ],
                318   => [ "SN-WSG-MIP-Simple-IP-Fallback",   "integer" ],
                319   => [ "SN-WLAN-AP-Identifier",           "octets" ],
                320   => [ "SN-WLAN-UE-Identifier",           "octets" ],
                1001  => [ "SNA-PPP-Ctrl-Input-Octets",       "integer" ],
                1002  => [ "SNA-PPP-Ctrl-Output-Octets",      "integer" ],
                1003  => [ "SNA-PPP-Ctrl-Input-Packets",      "integer" ],
                1004  => [ "SNA-PPP-Ctrl-Output-Packets",     "integer" ],
                1005  => [ "SNA-PPP-Framed-Input-Octets",     "integer" ],
                1006  => [ "SNA-PPP-Framed-Output-Octets",    "integer" ],
                1007  => [ "SNA-PPP-Discards-Input",          "integer" ],
                1008  => [ "SNA-PPP-Discards-Output",         "integer" ],
                1009  => [ "SNA-PPP-Errors-Input",            "integer" ],
                1010  => [ "SNA-PPP-Errors-Output",           "integer" ],
                1011  => [ "SNA-PPP-Bad-Addr",                "integer" ],
                1012  => [ "SNA-PPP-Bad-Ctrl",                "integer" ],
                1013  => [ "SNA-PPP-Packet-Too-Long",         "integer" ],
                1014  => [ "SNA-PPP-Bad-FCS",                 "integer" ],
                1015  => [ "SNA-PPP-Echo-Req-Input",          "integer" ],
                1016  => [ "SNA-PPP-Echo-Req-Output",         "integer" ],
                1017  => [ "SNA-PPP-Echo-Rsp-Input",          "integer" ],
                1018  => [ "SNA-PPP-Echo-Rsp-Output",         "integer" ],
                1019  => [ "SNA-RPRRQ-Rcvd-Total",            "integer" ],
                1020  => [ "SNA-RPRRQ-Rcvd-Acc-Reg",          "integer" ],
                1021  => [ "SNA-RPRRQ-Rcvd-Acc-Dereg",        "integer" ],
                1022  => [ "SNA-RPRRQ-Rcvd-Msg-Auth-Fail",    "integer" ],
                1023  => [ "SNA-RPRRQ-Rcvd-Mis-ID",           "integer" ],
                1024  => [ "SNA-RPRRQ-Rcvd-Badly-Formed",     "integer" ],
                1025  => [ "SNA-RPRRQ-Rcvd-VID-Unsupported",  "integer" ],
                1026  => [ "SNA-RPRRQ-Rcvd-T-Bit-Not-Set",    "integer" ],
                1027  => [ "SNA-RPRAK-Rcvd-Total",            "integer" ],
                1028  => [ "SNA-RPRAK-Rcvd-Acc-Ack",          "integer" ],
                1029  => [ "SNA-RPRAK-Rcvd-Msg-Auth-Fail",    "integer" ],
                1030  => [ "SNA-RPRAK-Rcvd-Mis-ID",           "integer" ],
                1031  => [ "SNA-RP-Reg-Reply-Sent-Total",     "integer" ],
                1032  => [ "SNA-RP-Reg-Reply-Sent-Acc-Reg",   "integer" ],
                1033  => [ "SNA-RP-Reg-Reply-Sent-Acc-Dereg", "integer" ],
                1034  => [ "SNA-RP-Reg-Reply-Sent-Bad-Req",   "integer" ],
                1035  => [ "SNA-RP-Reg-Reply-Sent-Denied",    "integer" ],
                1036  => [ "SNA-RP-Reg-Reply-Sent-Mis-ID",    "integer" ],
                1037  => [ "SNA-RP-Reg-Reply-Sent-Send-Err",  "integer" ],
                1038  => [ "SNA-RP-Reg-Upd-Sent",             "integer" ],
                1039  => [ "SNA-RP-Reg-Upd-Re-Sent",          "integer" ],
                1040  => [ "SNA-RP-Reg-Upd-Send-Err",         "integer" ],
                65530 => [ "SN-Proxy-MIPV6",                  "integer" ],
            },
            8708 => {
                1 => [ "Infinera-User-Category",     "string" ],
                2 => [ "Infinera-ENM-User-Category", "string" ],
            },
            8741 => {
                1 => [ "SonicWall-User-Privilege", "integer" ],
                3 => [ "SonicWall-User-Group",     "string" ],
            },
            8744 => {
                "0" => [ "Colubris-AVPair",    "string" ],
                "1" => [ "Colubris-Intercept", "integer" ],
            },
            9148 => {
                1   => [ "Acme-FlowID_FS1_F",                      "string" ],
                2   => [ "Acme-FlowType_FS1_F",                    "string" ],
                3   => [ "Acme-Session-Ingress-CallId",            "string" ],
                4   => [ "Acme-Session-Egress-CallId",             "string" ],
                10  => [ "Acme-Flow-In-Realm_FS1_F",               "string" ],
                11  => [ "Acme-Flow-In-Src-Addr_FS1_F",            "ipaddr" ],
                12  => [ "Acme-Flow-In-Src-Port_FS1_F",            "integer" ],
                13  => [ "Acme-Flow-In-Dst-Addr_FS1_F",            "ipaddr" ],
                14  => [ "Acme-Flow-In-Dst-Port_FS1_F",            "integer" ],
                20  => [ "Acme-Flow-Out-Realm_FS1_F",              "string" ],
                21  => [ "Acme-Flow-Out-Src-Addr_FS1_F",           "ipaddr" ],
                22  => [ "Acme-Flow-Out-Src-Port_FS1_F",           "integer" ],
                23  => [ "Acme-Flow-Out-Dst-Addr_FS1_F",           "ipaddr" ],
                24  => [ "Acme-Flow-Out-Dst-Port_FS1_F",           "integer" ],
                28  => [ "Acme-Calling-Octets_FS1",                "integer" ],
                29  => [ "Acme-Calling-Packets_FS1",               "integer" ],
                32  => [ "Acme-Calling-RTCP-Packets-Lost_FS1",     "integer" ],
                33  => [ "Acme-Calling-RTCP-Avg-Jitter_FS1",       "integer" ],
                34  => [ "Acme-Calling-RTCP-Avg-Latency_FS1",      "integer" ],
                35  => [ "Acme-Calling-RTCP-MaxJitter_FS1",        "integer" ],
                36  => [ "Acme-Calling-RTCP-MaxLatency_FS1",       "integer" ],
                37  => [ "Acme-Calling-RTP-Packets-Lost_FS1",      "integer" ],
                38  => [ "Acme-Calling-RTP-Avg-Jitter_FS1",        "integer" ],
                39  => [ "Acme-Calling-RTP-MaxJitter_FS1",         "integer" ],
                40  => [ "Acme-Session-Generic-Id",                "string" ],
                41  => [ "Acme-Session-Ingress-Realm",             "string" ],
                42  => [ "Acme-Session-Egress-Realm",              "string" ],
                43  => [ "Acme-Session-Protocol-Type",             "string" ],
                44  => [ "Acme-Called-Octets_FS1",                 "integer" ],
                45  => [ "Acme-Called-Packets_FS1",                "integer" ],
                46  => [ "Acme-Called-RTCP-Packets-Lost_FS1",      "integer" ],
                47  => [ "Acme-Called-RTCP-Avg-Jitter_FS1",        "integer" ],
                48  => [ "Acme-Called-RTCP-Avg-Latency_FS1",       "integer" ],
                49  => [ "Acme-Called-RTCP-MaxJitter_FS1",         "integer" ],
                50  => [ "Acme-Called-RTCP-MaxLatency_FS1",        "integer" ],
                51  => [ "Acme-Called-RTP-Packets-Lost_FS1",       "integer" ],
                52  => [ "Acme-Called-RTP-Avg-Jitter_FS1",         "integer" ],
                53  => [ "Acme-Called-RTP-MaxJitter_FS1",          "integer" ],
                54  => [ "Acme-Session-Charging-Vector",           "string" ],
                55  => [ "Acme-Session-Charging-Function_Address", "string" ],
                56  => [ "Acme-Firmware-Version",                  "string" ],
                57  => [ "Acme-Local-Time-Zone",                   "string" ],
                58  => [ "Acme-Post-Dial-Delay",                   "integer" ],
                59  => [ "Acme-CDR-Sequence-Number",               "integer" ],
                60  => [ "Acme-Session-Disposition",               "integer" ],
                61  => [ "Acme-Disconnect-Initiator",              "integer" ],
                62  => [ "Acme-Disconnect-Cause",                  "integer" ],
                63  => [ "Acme-Intermediate_Time",                 "string" ],
                64  => [ "Acme-Primary-Routing-Number",            "string" ],
                65  => [ "Acme-Originating-Trunk-Group",           "string" ],
                66  => [ "Acme-Terminating-Trunk-Group",           "string" ],
                67  => [ "Acme-Originating-Trunk-Context",         "string" ],
                68  => [ "Acme-Terminating-Trunk-Context",         "string" ],
                69  => [ "Acme-P-Asserted-ID",                     "string" ],
                70  => [ "Acme-SIP-Diversion",                     "string" ],
                71  => [ "Acme-SIP-Status",                        "integer" ],
                74  => [ "Acme-Ingress-Local-Addr",                "string" ],
                75  => [ "Acme-Ingress-Remote-Addr",               "string" ],
                76  => [ "Acme-Egress-Local-Addr",                 "string" ],
                77  => [ "Acme-Egress-Remote-Addr",                "string" ],
                78  => [ "Acme-FlowID_FS1_R",                      "string" ],
                79  => [ "Acme-FlowType_FS1_R",                    "string" ],
                80  => [ "Acme-Flow-In-Realm_FS1_R",               "string" ],
                81  => [ "Acme-Flow-In-Src-Addr_FS1_R",            "ipaddr" ],
                82  => [ "Acme-Flow-In-Src-Port_FS1_R",            "integer" ],
                83  => [ "Acme-Flow-In-Dst-Addr_FS1_R",            "ipaddr" ],
                84  => [ "Acme-Flow-In-Dst-Port_FS1_R",            "integer" ],
                85  => [ "Acme-Flow-Out-Realm_FS1_R",              "string" ],
                86  => [ "Acme-Flow-Out-Src-Addr_FS1_R",           "ipaddr" ],
                87  => [ "Acme-Flow-Out-Src-Port_FS1_R",           "integer" ],
                88  => [ "Acme-Flow-Out-Dst-Addr_FS1_R",           "ipaddr" ],
                89  => [ "Acme-Flow-Out-Dst-Port_FS1_R",           "integer" ],
                90  => [ "Acme-FlowID_FS2_F",                      "string" ],
                91  => [ "Acme-FlowType_FS2_F",                    "string" ],
                92  => [ "Acme-Flow-In-Realm_FS2_F",               "string" ],
                93  => [ "Acme-Flow-In-Src-Addr_FS2_F",            "ipaddr" ],
                94  => [ "Acme-Flow-In-Src-Port_FS2_F",            "integer" ],
                95  => [ "Acme-Flow-In-Dst-Addr_FS2_F",            "ipaddr" ],
                96  => [ "Acme-Flow-In-Dst-Port_FS2_F",            "integer" ],
                97  => [ "Acme-Flow-Out-Realm_FS2_F",              "string" ],
                98  => [ "Acme-Flow-Out-Src-Addr_FS2_F",           "ipaddr" ],
                99  => [ "Acme-Flow-Out-Src-Port_FS2_F",           "integer" ],
                100 => [ "Acme-Flow-Out-Dst-Addr_FS2_F",           "ipaddr" ],
                101 => [ "Acme-Flow-Out-Dst-Port_FS2_F",           "integer" ],
                102 => [ "Acme-Calling-Octets_FS2",                "integer" ],
                103 => [ "Acme-Calling-Packets_FS2",               "integer" ],
                104 => [ "Acme-Calling-RTCP-Packets-Lost_FS2",     "integer" ],
                105 => [ "Acme-Calling-RTCP-Avg-Jitter_FS2",       "integer" ],
                106 => [ "Acme-Calling-RTCP-Avg-Latency_FS2",      "integer" ],
                107 => [ "Acme-Calling-RTCP-MaxJitter_FS2",        "integer" ],
                108 => [ "Acme-Calling-RTCP-MaxLatency_FS2",       "integer" ],
                109 => [ "Acme-Calling-RTP-Packets-Lost_FS2",      "integer" ],
                110 => [ "Acme-Calling-RTP-Avg-Jitter_FS2",        "integer" ],
                111 => [ "Acme-Calling-RTP-MaxJitter_FS2",         "integer" ],
                112 => [ "Acme-FlowID_FS2_R",                      "string" ],
                113 => [ "Acme-FlowType_FS2_R",                    "string" ],
                114 => [ "Acme-Flow-In-Realm_FS2_R",               "string" ],
                115 => [ "Acme-Flow-In-Src-Addr_FS2_R",            "ipaddr" ],
                116 => [ "Acme-Flow-In-Src-Port_FS2_R",            "integer" ],
                117 => [ "Acme-Flow-In-Dst-Addr_FS2_R",            "ipaddr" ],
                118 => [ "Acme-Flow-In-Dst-Port_FS2_R",            "integer" ],
                119 => [ "Acme-Flow-Out-Realm_FS2_R",              "string" ],
                120 => [ "Acme-Flow-Out-Src-Addr_FS2_R",           "ipaddr" ],
                121 => [ "Acme-Flow-Out-Src-Port_FS2_R",           "integer" ],
                122 => [ "Acme-Flow-Out-Dst-Addr_FS2_R",           "ipaddr" ],
                123 => [ "Acme-Flow-Out-Dst-Port_FS2_R",           "integer" ],
                124 => [ "Acme-Called-Octets_FS2",                 "integer" ],
                125 => [ "Acme-Called-Packets_FS2",                "integer" ],
                126 => [ "Acme-Called-RTCP-Packets-Lost_FS2",      "integer" ],
                127 => [ "Acme-Called-RTCP-Avg-Jitter_FS2",        "integer" ],
                128 => [ "Acme-Called-RTCP-Avg-Latency_FS2",       "integer" ],
                129 => [ "Acme-Called-RTCP-MaxJitter_FS2",         "integer" ],
                130 => [ "Acme-Called-RTCP-MaxLatency_FS2",        "integer" ],
                131 => [ "Acme-Called-RTP-Packets-Lost_FS2",       "integer" ],
                132 => [ "Acme-Called-RTP-Avg-Jitter_FS2",         "integer" ],
                133 => [ "Acme-Called-RTP-MaxJitter_FS2",          "integer" ],
                134 => [ "Acme-Egress-Final-Routing-Number",       "string" ],
                135 => [ "Acme-Session-Ingress-RPH",               "string" ],
                136 => [ "Acme-Session-Egress-RPH",                "string" ],
                137 => [ "Acme-Ingress-Network-Interface-Id",      "string" ],
                138 => [ "Acme-Ingress-Vlan-Tag-Value",            "integer" ],
                139 => [ "Acme-Egress-Network-Interface-Id",       "string" ],
                140 => [ "Acme-Egress-Vlan-Tag-Value",             "integer" ],
                141 => [ "Acme-Refer-Call-Transfer-Id",            "string" ],
                142 => [ "Acme-FlowMediaType_FS1_F",               "string" ],
                143 => [ "Acme-FlowMediaType_FS1_R",               "string" ],
                144 => [ "Acme-FlowMediaType_FS2_F",               "string" ],
                145 => [ "Acme-FlowMediaType_FS2_R",               "string" ],
                146 => [ "Acme-Flow-PTime_FS1_F",                  "integer" ],
                147 => [ "Acme-Flow-PTime_FS1_R",                  "integer" ],
                148 => [ "Acme-Flow-PTime_FS2_F",                  "integer" ],
                149 => [ "Acme-Flow-PTime_FS2_R",                  "integer" ],
                150 => [ "Acme-Session-Media-Process",             "string" ],
                151 => [ "Acme-Calling-R-Factor",                  "integer" ],
                152 => [ "Acme-Calling-MOS",                       "integer" ],
                153 => [ "Acme-Called-R-Factor",                   "integer" ],
                154 => [ "Acme-Called-MOS",                        "integer" ],
                155 => [ "Acme-Flow-In-Src-IPv6_Addr_FS1_F",       "ipv6addr" ],
                156 => [ "Acme-Flow-In-Dst-IPv6_Addr_FS1_F",       "ipv6addr" ],
                157 => [ "Acme-Flow-Out-Src-IPv6_Addr_FS1_F",      "ipv6addr" ],
                158 => [ "Acme-Flow-Out-Dst-IPv6_Addr_FS1_F",      "ipv6addr" ],
                159 => [ "Acme-Flow-In-Src-IPv6_Addr_FS1_R",       "ipv6addr" ],
                160 => [ "Acme-Flow-In-Dst-IPv6_Addr_FS1_R",       "ipv6addr" ],
                161 => [ "Acme-Flow-Out-Src-IPv6_Addr_FS1_R",      "ipv6addr" ],
                162 => [ "Acme-Flow-Out-Dst-IPv6_Addr_FS1_R",      "ipv6addr" ],
                163 => [ "Acme-Flow-In-Src-IPv6_Addr_FS2_F",       "ipv6addr" ],
                164 => [ "Acme-Flow-In-Dst-IPv6_Addr_FS2_F",       "ipv6addr" ],
                165 => [ "Acme-Flow-Out-Src-IPv6_Addr_FS2_F",      "ipv6addr" ],
                166 => [ "Acme-Flow-Out-Dst-IPv6_Addr_FS2_F",      "ipv6addr" ],
                167 => [ "Acme-Flow-In-Src-IPv6_Addr_FS2_R",       "ipv6addr" ],
                168 => [ "Acme-Flow-In-Dst-IPv6_Addr_FS2_R",       "ipv6addr" ],
                169 => [ "Acme-Flow-Out-Src-IPv6_Addr_FS2_R",      "ipv6addr" ],
                170 => [ "Acme-Flow-Out-Dst-IPv6_Addr_FS2_R",      "ipv6addr" ],
                171 => [ "Acme-Session-Forked-Call-Id",            "string" ],
                200 => [ "Acme-Custom-VSA-200",                    "string" ],
                201 => [ "Acme-Custom-VSA-201",                    "string" ],
                202 => [ "Acme-Custom-VSA-202",                    "string" ],
                203 => [ "Acme-Custom-VSA-203",                    "string" ],
                204 => [ "Acme-Custom-VSA-204",                    "string" ],
                205 => [ "Acme-Custom-VSA-205",                    "string" ],
                206 => [ "Acme-Custom-VSA-206",                    "string" ],
                207 => [ "Acme-Custom-VSA-207",                    "string" ],
                208 => [ "Acme-Custom-VSA-208",                    "string" ],
                209 => [ "Acme-Custom-VSA-209",                    "string" ],
                210 => [ "Acme-Custom-VSA-210",                    "string" ],
                211 => [ "Acme-Custom-VSA-211",                    "string" ],
                212 => [ "Acme-Custom-VSA-212",                    "string" ],
                213 => [ "Acme-Custom-VSA-213",                    "string" ],
                214 => [ "Acme-Custom-VSA-214",                    "string" ],
                215 => [ "Acme-Custom-VSA-215",                    "string" ],
                216 => [ "Acme-Custom-VSA-216",                    "string" ],
                217 => [ "Acme-Custom-VSA-217",                    "string" ],
                218 => [ "Acme-Custom-VSA-218",                    "string" ],
                219 => [ "Acme-Custom-VSA-219",                    "string" ],
                220 => [ "Acme-Custom-VSA-220",                    "string" ],
                221 => [ "Acme-Custom-VSA-221",                    "string" ],
                222 => [ "Acme-Custom-VSA-222",                    "string" ],
                223 => [ "Acme-Custom-VSA-223",                    "string" ],
                224 => [ "Acme-Custom-VSA-224",                    "string" ],
                225 => [ "Acme-Custom-VSA-225",                    "string" ],
                226 => [ "Acme-Custom-VSA-226",                    "string" ],
                227 => [ "Acme-Custom-VSA-227",                    "string" ],
                228 => [ "Acme-Custom-VSA-228",                    "string" ],
                229 => [ "Acme-Custom-VSA-229",                    "string" ],
                230 => [ "Acme-Custom-VSA-230",                    "string" ],
                231 => [ "Acme-Flow-Calling-Media-Stop-Time-FS1",  "string" ],
                232 => [ "Acme-Flow-Called-Media-Stop-Time-FS1",   "string" ],
                233 => [ "Acme-Flow-Calling-Media-Stop-Time-FS2",  "string" ],
                234 => [ "Acme-Flow-Called-Media-Stop-Time-FS2",   "string" ],
                235 => [ "Acme-SIP-Method-Type",                   "string" ],
                236 => [ "Acme-Domain-Name",                       "string" ],
                237 => [ "Acme-SIP-Contact",                       "string" ],
                238 => [ "Acme-SIP-Expires",                       "integer" ],
                239 => [ "Acme-Reason-Phrase",                     "string" ],
                253 => [ "Acme-User-Privilege",                    "string" ],
                254 => [ "Acme-User-Class",                        "string" ],
            },
            9694  => { 1 => [ "Arbor-Privilege-Level", "string" ] },
            10055 => {
                1 => [ "RP-Upstream-Speed-Limit",   "integer" ],
                2 => [ "RP-Downstream-Speed-Limit", "integer" ],
                3 => [ "RP-HURL",                   "string" ],
                4 => [ "RP-MOTM",                   "string" ],
                5 => [ "RP-Max-Sessions-Per-User",  "integer" ],
            },
            10415 => {
                1  => [ "3GPP-IMSI",                          "string" ],
                2  => [ "3GPP-Charging-ID",                   "integer" ],
                3  => [ "3GPP-PDP-Type",                      "integer" ],
                4  => [ "3GPP-Charging-Gateway-Address",      "ipaddr" ],
                5  => [ "3GPP-GPRS-Negotiated-QoS-profile",   "string" ],
                6  => [ "3GPP-SGSN-Address",                  "ipaddr" ],
                7  => [ "3GPP-GGSN-Address",                  "ipaddr" ],
                8  => [ "3GPP-IMSI-MCC-MNC",                  "string" ],
                9  => [ "3GPP-GGSN-MCC-MNC",                  "string" ],
                10 => [ "3GPP-NSAPI",                         "string" ],
                11 => [ "3GPP-Session-Stop-Indicator",        "byte" ],
                12 => [ "3GPP-Selection-Mode",                "string" ],
                13 => [ "3GPP-Charging-Characteristics",      "string" ],
                14 => [ "3GPP-Charging-Gateway-IPv6-Address", "ipv6addr" ],
                15 => [ "3GPP-SGSN-IPv6-Address",             "ipv6addr" ],
                16 => [ "3GPP-GGSN-IPv6-Address",             "ipv6addr" ],
                17 => [ "3GPP-IPv6-DNS-Servers",              "octets" ],
                18 => [ "3GPP-SGSN-MCC-MNC",                  "string" ],
                19 => [ "3GPP-Teardown-Indicator",            "byte" ],
                20 => [ "3GPP-IMEISV",                        "string" ],
                21 => [ "3GPP-RAT-Type",                      "byte" ],
                22 => [ "3GPP-User-Location-Info",            "octets" ],
                23 => [ "3GPP-MS-Time-Zone",                  "octets" ],
                24 => [ "3GPP-Camel-Charging-Info",           "octets" ],
                25 => [ "3GPP-Packet-Filter",                 "octets" ],
                26 => [ "3GPP-Negotiated-DSCP",               "byte" ],
                27 => [ "3GPP-Allocate-IP-Type",              "byte" ],
            },
            10529 => {
                21 => [ "Acct-Session-Input-Octets",     "integer" ],
                22 => [ "Acct-Session-Input-Gigawords",  "integer" ],
                23 => [ "Acct-Session-Output-Octets",    "integer" ],
                24 => [ "Acct-Session-Output-Gigawords", "integer" ],
                25 => [ "Acct-Session-Octets",           "integer" ],
                26 => [ "Acct-Session-Gigawords",        "integer" ],
            },
            10923 => {
                30 => [ "Suggested-Rule-Space",           "string" ],
                31 => [ "Suggested-Secondary-Rule-Space", "string" ],
            },
            11344 => {
                1   => [ "FreeRADIUS-802.1X-Anonce",           "octets" ],
                2   => [ "FreeRADIUS-802.1X-EAPoL-Key-Msg",    "octets" ],
                127 => [ "FreeRADIUS-Statistics-Type",         "integer" ],
                128 => [ "FreeRADIUS-Total-Access-Requests",   "integer" ],
                129 => [ "FreeRADIUS-Total-Access-Accepts",    "integer" ],
                130 => [ "FreeRADIUS-Total-Access-Rejects",    "integer" ],
                131 => [ "FreeRADIUS-Total-Access-Challenges", "integer" ],
                132 => [ "FreeRADIUS-Total-Auth-Responses",    "integer" ],
                133 =>
                  [ "FreeRADIUS-Total-Auth-Duplicate-Requests", "integer" ],
                134 =>
                  [ "FreeRADIUS-Total-Auth-Malformed-Requests", "integer" ],
                135 => [ "FreeRADIUS-Total-Auth-Invalid-Requests", "integer" ],
                136 => [ "FreeRADIUS-Total-Auth-Dropped-Requests", "integer" ],
                137 => [ "FreeRADIUS-Total-Auth-Unknown-Types",    "integer" ],
                138 => [ "FreeRADIUS-Total-Proxy-Access-Requests", "integer" ],
                139 => [ "FreeRADIUS-Total-Proxy-Access-Accepts",  "integer" ],
                140 => [ "FreeRADIUS-Total-Proxy-Access-Rejects",  "integer" ],
                141 =>
                  [ "FreeRADIUS-Total-Proxy-Access-Challenges", "integer" ],
                142 => [ "FreeRADIUS-Total-Proxy-Auth-Responses", "integer" ],
                143 => [
                    "FreeRADIUS-Total-Proxy-Auth-Duplicate-Requests", "integer"
                ],
                144 => [
                    "FreeRADIUS-Total-Proxy-Auth-Malformed-Requests", "integer"
                ],
                145 =>
                  [ "FreeRADIUS-Total-Proxy-Auth-Invalid-Requests", "integer" ],
                146 =>
                  [ "FreeRADIUS-Total-Proxy-Auth-Dropped-Requests", "integer" ],
                147 =>
                  [ "FreeRADIUS-Total-Proxy-Auth-Unknown-Types", "integer" ],
                148 => [ "FreeRADIUS-Total-Accounting-Requests",  "integer" ],
                149 => [ "FreeRADIUS-Total-Accounting-Responses", "integer" ],
                150 =>
                  [ "FreeRADIUS-Total-Acct-Duplicate-Requests", "integer" ],
                151 =>
                  [ "FreeRADIUS-Total-Acct-Malformed-Requests", "integer" ],
                152 => [ "FreeRADIUS-Total-Acct-Invalid-Requests", "integer" ],
                153 => [ "FreeRADIUS-Total-Acct-Dropped-Requests", "integer" ],
                154 => [ "FreeRADIUS-Total-Acct-Unknown-Types",    "integer" ],
                155 =>
                  [ "FreeRADIUS-Total-Proxy-Accounting-Requests", "integer" ],
                156 =>
                  [ "FreeRADIUS-Total-Proxy-Accounting-Responses", "integer" ],
                157 => [
                    "FreeRADIUS-Total-Proxy-Acct-Duplicate-Requests", "integer"
                ],
                158 => [
                    "FreeRADIUS-Total-Proxy-Acct-Malformed-Requests", "integer"
                ],
                159 =>
                  [ "FreeRADIUS-Total-Proxy-Acct-Invalid-Requests", "integer" ],
                160 =>
                  [ "FreeRADIUS-Total-Proxy-Acct-Dropped-Requests", "integer" ],
                161 =>
                  [ "FreeRADIUS-Total-Proxy-Acct-Unknown-Types", "integer" ],
                162 => [ "FreeRADIUS-Queue-Len-Internal",      "integer" ],
                163 => [ "FreeRADIUS-Queue-Len-Proxy",         "integer" ],
                164 => [ "FreeRADIUS-Queue-Len-Auth",          "integer" ],
                165 => [ "FreeRADIUS-Queue-Len-Acct",          "integer" ],
                166 => [ "FreeRADIUS-Queue-Len-Detail",        "integer" ],
                167 => [ "FreeRADIUS-Stats-Client-IP-Address", "ipaddr" ],
                168 => [ "FreeRADIUS-Stats-Client-Number",     "integer" ],
                169 => [ "FreeRADIUS-Stats-Client-Netmask",    "integer" ],
                170 => [ "FreeRADIUS-Stats-Server-IP-Address", "ipaddr" ],
                171 => [ "FreeRADIUS-Stats-Server-Port",       "integer" ],
                172 =>
                  [ "FreeRADIUS-Stats-Server-Outstanding-Requests", "integer" ],
                173 => [ "FreeRADIUS-Stats-Server-State",         "integer" ],
                174 => [ "FreeRADIUS-Stats-Server-Time-Of-Death", "date" ],
                175 => [ "FreeRADIUS-Stats-Server-Time-Of-Life",  "date" ],
                176 => [ "FreeRADIUS-Stats-Start-Time",           "date" ],
                177 => [ "FreeRADIUS-Stats-HUP-Time",             "date" ],
                178 => [ "FreeRADIUS-Server-EMA-Window",          "integer" ],
                179 => [ "FreeRADIUS-Server-EMA-USEC-Window-1",   "integer" ],
                180 => [ "FreeRADIUS-Server-EMA-USEC-Window-10",  "integer" ],
                181 => [ "FreeRADIUS-Queue-PPS-In",               "integer" ],
                182 => [ "FreeRADIUS-Queue-PPS-Out",              "integer" ],
                183 => [ "FreeRADIUS-Queue-Use-Percentage",       "integer" ],
                184 => [ "FreeRADIUS-Stats-Last-Packet-Recv",     "date" ],
                185 => [ "FreeRADIUS-Stats-Last-Packet-Sent",     "date" ],
                186 => [ "FreeRADIUS-EAP-FAST-PKCS",              "octets" ],
                187 => [ "FreeRADIUS-Stats-Error",                "string" ],
                188 => [ "FreeRADIUS-Stats-Client-IPv6-Address",  "ipv6addr" ],
                189 => [ "FreeRADIUS-Stats-Server-IPv6-Address",  "ipv6addr" ],
                191 => [ "FreeRADIUS-Total-Auth-Conflicts",       "integer" ],
                192 => [ "FreeRADIUS-Total-Acct-Conflicts",       "integer" ],
            },
            11862 => {
                "0" => [ "Sip-Method",                 "integer" ],
                "1" => [ "Sip-From",                   "string" ],
                "2" => [ "Sip-To",                     "string" ],
                "4" => [ "Sip-Translated-Request-URI", "string" ],
            },
            12356 => {
                1  => [ "Fortinet-Group-Name",                    "string" ],
                2  => [ "Fortinet-Client-IP-Address",             "ipaddr" ],
                3  => [ "Fortinet-Vdom-Name",                     "string" ],
                4  => [ "Fortinet-Client-IPv6-Address",           "octets" ],
                5  => [ "Fortinet-Interface-Name",                "string" ],
                6  => [ "Fortinet-Access-Profile",                "string" ],
                7  => [ "Fortinet-SSID",                          "string" ],
                8  => [ "Fortinet-AP-Name",                       "string" ],
                11 => [ "Fortinet-FAC-Auth-Status",               "string" ],
                12 => [ "Fortinet-FAC-Token-ID",                  "string" ],
                15 => [ "Fortinet-FAC-Challenge-Code",            "string" ],
                16 => [ "Fortinet-Webfilter-Category-Allow",      "octets" ],
                17 => [ "Fortinet-Webfilter-Category-Block",      "octets" ],
                18 => [ "Fortinet-Webfilter-Category-Monitor",    "octets" ],
                19 => [ "Fortinet-AppCtrl-Category-Allow",        "octets" ],
                20 => [ "Fortinet-AppCtrl-Category-Block",        "octets" ],
                21 => [ "Fortinet-AppCtrl-Risk-Allow",            "octets" ],
                22 => [ "Fortinet-AppCtrl-Risk-Block",            "octets" ],
                23 => [ "Fortinet-WirelessController-Device-MAC", "ether" ],
                24 => [ "Fortinet-WirelessController-WTP-ID",     "string" ],
                25 => [ "Fortinet-WirelessController-Assoc-Time", "date" ],
                26 => [ "Fortinet-FortiWAN-AVPair",               "string" ],
                30 => [ "Fortinet-FDD-Access-Profile",            "string" ],
                31 => [ "Fortinet-FDD-Trusted-Hosts",             "string" ],
                32 => [ "Fortinet-FDD-SPP-Name",                  "string" ],
                33 => [ "Fortinet-FDD-Is-System-Admin",           "string" ],
                34 => [ "Fortinet-FDD-Is-SPP-Admin",              "string" ],
                35 => [ "Fortinet-FDD-SPP-Policy-Group",          "string" ],
                36 => [ "Fortinet-FDD-Allow-API-Access",          "string" ],
                40 => [ "Fortinet-Fpc-User-Role",                 "string" ],
                41 => [ "Fortinet-Tenant-Identification",         "string" ],
                42 => [ "Fortinet-Host-Port-AVPair",              "string" ],
            },
            12394 => {
                1   => [ "Breezecom-Attr1",  "string" ],
                2   => [ "Breezecom-Attr2",  "string" ],
                3   => [ "Breezecom-Attr3",  "string" ],
                4   => [ "Breezecom-Attr4",  "string" ],
                5   => [ "Breezecom-Attr5",  "string" ],
                6   => [ "Breezecom-Attr6",  "string" ],
                7   => [ "Breezecom-Attr7",  "string" ],
                8   => [ "Breezecom-Attr8",  "string" ],
                9   => [ "Breezecom-Attr9",  "string" ],
                10  => [ "Breezecom-Attr10", "string" ],
                11  => [ "Breezecom-Attr11", "string" ],
                12  => [ "Alvarion-VSA-12",  "string" ],
                13  => [ "Alvarion-VSA-13",  "string" ],
                14  => [ "Alvarion-VSA-14",  "string" ],
                15  => [ "Alvarion-VSA-15",  "string" ],
                16  => [ "Alvarion-VSA-16",  "string" ],
                17  => [ "Alvarion-VSA-17",  "string" ],
                18  => [ "Alvarion-VSA-18",  "string" ],
                19  => [ "Alvarion-VSA-19",  "string" ],
                20  => [ "Alvarion-VSA-20",  "string" ],
                21  => [ "Alvarion-VSA-21",  "string" ],
                22  => [ "Alvarion-VSA-22",  "string" ],
                23  => [ "Alvarion-VSA-23",  "string" ],
                24  => [ "Alvarion-VSA-24",  "string" ],
                25  => [ "Alvarion-VSA-25",  "string" ],
                26  => [ "Alvarion-VSA-26",  "string" ],
                27  => [ "Alvarion-VSA-27",  "string" ],
                28  => [ "Alvarion-VSA-28",  "string" ],
                29  => [ "Alvarion-VSA-29",  "string" ],
                30  => [ "Alvarion-VSA-30",  "string" ],
                31  => [ "Alvarion-VSA-31",  "string" ],
                32  => [ "Alvarion-VSA-32",  "string" ],
                33  => [ "Alvarion-VSA-33",  "string" ],
                34  => [ "Alvarion-VSA-34",  "string" ],
                35  => [ "Alvarion-VSA-35",  "string" ],
                36  => [ "Alvarion-VSA-36",  "string" ],
                37  => [ "Alvarion-VSA-37",  "string" ],
                38  => [ "Alvarion-VSA-38",  "string" ],
                39  => [ "Alvarion-VSA-39",  "string" ],
                40  => [ "Alvarion-VSA-40",  "string" ],
                41  => [ "Alvarion-VSA-41",  "string" ],
                42  => [ "Alvarion-VSA-42",  "string" ],
                43  => [ "Alvarion-VSA-43",  "string" ],
                44  => [ "Alvarion-VSA-44",  "string" ],
                45  => [ "Alvarion-VSA-45",  "string" ],
                46  => [ "Alvarion-VSA-46",  "string" ],
                47  => [ "Alvarion-VSA-47",  "string" ],
                48  => [ "Alvarion-VSA-48",  "string" ],
                49  => [ "Alvarion-VSA-49",  "string" ],
                50  => [ "Alvarion-VSA-50",  "string" ],
                51  => [ "Alvarion-VSA-51",  "string" ],
                52  => [ "Alvarion-VSA-52",  "string" ],
                53  => [ "Alvarion-VSA-53",  "string" ],
                54  => [ "Alvarion-VSA-54",  "string" ],
                55  => [ "Alvarion-VSA-55",  "string" ],
                56  => [ "Alvarion-VSA-56",  "string" ],
                57  => [ "Alvarion-VSA-57",  "string" ],
                58  => [ "Alvarion-VSA-58",  "string" ],
                59  => [ "Alvarion-VSA-59",  "string" ],
                60  => [ "Alvarion-VSA-60",  "string" ],
                61  => [ "Alvarion-VSA-61",  "string" ],
                62  => [ "Alvarion-VSA-62",  "string" ],
                63  => [ "Alvarion-VSA-63",  "string" ],
                64  => [ "Alvarion-VSA-64",  "string" ],
                65  => [ "Alvarion-VSA-65",  "string" ],
                66  => [ "Alvarion-VSA-66",  "string" ],
                67  => [ "Alvarion-VSA-67",  "string" ],
                68  => [ "Alvarion-VSA-68",  "string" ],
                69  => [ "Alvarion-VSA-69",  "string" ],
                70  => [ "Alvarion-VSA-70",  "string" ],
                71  => [ "Alvarion-VSA-71",  "string" ],
                72  => [ "Alvarion-VSA-72",  "string" ],
                73  => [ "Alvarion-VSA-73",  "string" ],
                74  => [ "Alvarion-VSA-74",  "string" ],
                75  => [ "Alvarion-VSA-75",  "string" ],
                76  => [ "Alvarion-VSA-76",  "string" ],
                77  => [ "Alvarion-VSA-77",  "string" ],
                78  => [ "Alvarion-VSA-78",  "string" ],
                79  => [ "Alvarion-VSA-79",  "string" ],
                80  => [ "Alvarion-VSA-80",  "string" ],
                81  => [ "Alvarion-VSA-81",  "string" ],
                82  => [ "Alvarion-VSA-82",  "string" ],
                83  => [ "Alvarion-VSA-83",  "string" ],
                84  => [ "Alvarion-VSA-84",  "string" ],
                85  => [ "Alvarion-VSA-85",  "string" ],
                86  => [ "Alvarion-VSA-86",  "string" ],
                87  => [ "Alvarion-VSA-87",  "string" ],
                88  => [ "Alvarion-VSA-88",  "string" ],
                89  => [ "Alvarion-VSA-89",  "string" ],
                90  => [ "Alvarion-VSA-90",  "string" ],
                91  => [ "Alvarion-VSA-91",  "string" ],
                92  => [ "Alvarion-VSA-92",  "string" ],
                93  => [ "Alvarion-VSA-93",  "string" ],
                94  => [ "Alvarion-VSA-94",  "string" ],
                95  => [ "Alvarion-VSA-95",  "string" ],
                96  => [ "Alvarion-VSA-96",  "string" ],
                97  => [ "Alvarion-VSA-97",  "string" ],
                98  => [ "Alvarion-VSA-98",  "string" ],
                99  => [ "Alvarion-VSA-99",  "string" ],
                100 => [ "Alvarion-VSA-100", "string" ],
                101 => [ "Alvarion-VSA-101", "string" ],
                102 => [ "Alvarion-VSA-102", "string" ],
                103 => [ "Alvarion-VSA-103", "string" ],
                104 => [ "Alvarion-VSA-104", "string" ],
                105 => [ "Alvarion-VSA-105", "string" ],
                106 => [ "Alvarion-VSA-106", "string" ],
                107 => [ "Alvarion-VSA-107", "string" ],
                108 => [ "Alvarion-VSA-108", "string" ],
                109 => [ "Alvarion-VSA-109", "string" ],
                110 => [ "Alvarion-VSA-110", "string" ],
                111 => [ "Alvarion-VSA-111", "string" ],
                112 => [ "Alvarion-VSA-112", "string" ],
                113 => [ "Alvarion-VSA-113", "string" ],
                114 => [ "Alvarion-VSA-114", "string" ],
                115 => [ "Alvarion-VSA-115", "string" ],
                116 => [ "Alvarion-VSA-116", "string" ],
                117 => [ "Alvarion-VSA-117", "string" ],
                118 => [ "Alvarion-VSA-118", "string" ],
                119 => [ "Alvarion-VSA-119", "string" ],
                120 => [ "Alvarion-VSA-120", "string" ],
                121 => [ "Alvarion-VSA-121", "string" ],
                122 => [ "Alvarion-VSA-122", "string" ],
                123 => [ "Alvarion-VSA-123", "string" ],
                124 => [ "Alvarion-VSA-124", "string" ],
                125 => [ "Alvarion-VSA-125", "string" ],
                126 => [ "Alvarion-VSA-126", "string" ],
                127 => [ "Alvarion-VSA-127", "string" ],
                128 => [ "Alvarion-VSA-128", "string" ],
                129 => [ "Alvarion-VSA-129", "string" ],
                130 => [ "Alvarion-VSA-130", "string" ],
                131 => [ "Alvarion-VSA-131", "string" ],
                132 => [ "Alvarion-VSA-132", "string" ],
                133 => [ "Alvarion-VSA-133", "string" ],
                134 => [ "Alvarion-VSA-134", "string" ],
                135 => [ "Alvarion-VSA-135", "string" ],
                136 => [ "Alvarion-VSA-136", "string" ],
                137 => [ "Alvarion-VSA-137", "string" ],
                138 => [ "Alvarion-VSA-138", "string" ],
                139 => [ "Alvarion-VSA-139", "string" ],
                140 => [ "Alvarion-VSA-140", "string" ],
                141 => [ "Alvarion-VSA-141", "string" ],
                142 => [ "Alvarion-VSA-142", "string" ],
                143 => [ "Alvarion-VSA-143", "string" ],
                144 => [ "Alvarion-VSA-144", "string" ],
                145 => [ "Alvarion-VSA-145", "string" ],
                146 => [ "Alvarion-VSA-146", "string" ],
                147 => [ "Alvarion-VSA-147", "string" ],
                148 => [ "Alvarion-VSA-148", "string" ],
                149 => [ "Alvarion-VSA-149", "string" ],
                150 => [ "Alvarion-VSA-150", "string" ],
                151 => [ "Alvarion-VSA-151", "string" ],
                152 => [ "Alvarion-VSA-152", "string" ],
                153 => [ "Alvarion-VSA-153", "string" ],
                154 => [ "Alvarion-VSA-154", "string" ],
                155 => [ "Alvarion-VSA-155", "string" ],
                156 => [ "Alvarion-VSA-156", "string" ],
                157 => [ "Alvarion-VSA-157", "string" ],
                158 => [ "Alvarion-VSA-158", "string" ],
                159 => [ "Alvarion-VSA-159", "string" ],
                160 => [ "Alvarion-VSA-160", "string" ],
                161 => [ "Alvarion-VSA-161", "string" ],
                162 => [ "Alvarion-VSA-162", "string" ],
                163 => [ "Alvarion-VSA-163", "string" ],
                164 => [ "Alvarion-VSA-164", "string" ],
                165 => [ "Alvarion-VSA-165", "string" ],
                166 => [ "Alvarion-VSA-166", "string" ],
                167 => [ "Alvarion-VSA-167", "string" ],
                168 => [ "Alvarion-VSA-168", "string" ],
                169 => [ "Alvarion-VSA-169", "string" ],
                170 => [ "Alvarion-VSA-170", "string" ],
                171 => [ "Alvarion-VSA-171", "string" ],
                172 => [ "Alvarion-VSA-172", "string" ],
                173 => [ "Alvarion-VSA-173", "string" ],
                174 => [ "Alvarion-VSA-174", "string" ],
                175 => [ "Alvarion-VSA-175", "string" ],
                176 => [ "Alvarion-VSA-176", "string" ],
                177 => [ "Alvarion-VSA-177", "string" ],
                178 => [ "Alvarion-VSA-178", "string" ],
                179 => [ "Alvarion-VSA-179", "string" ],
                180 => [ "Alvarion-VSA-180", "string" ],
                181 => [ "Alvarion-VSA-181", "string" ],
                182 => [ "Alvarion-VSA-182", "string" ],
                183 => [ "Alvarion-VSA-183", "string" ],
                184 => [ "Alvarion-VSA-184", "string" ],
                185 => [ "Alvarion-VSA-185", "string" ],
                186 => [ "Alvarion-VSA-186", "string" ],
                187 => [ "Alvarion-VSA-187", "string" ],
                188 => [ "Alvarion-VSA-188", "string" ],
                189 => [ "Alvarion-VSA-189", "string" ],
                190 => [ "Alvarion-VSA-190", "string" ],
                191 => [ "Alvarion-VSA-191", "string" ],
                192 => [ "Alvarion-VSA-192", "string" ],
                193 => [ "Alvarion-VSA-193", "string" ],
                194 => [ "Alvarion-VSA-194", "string" ],
                195 => [ "Alvarion-VSA-195", "string" ],
                196 => [ "Alvarion-VSA-196", "string" ],
                197 => [ "Alvarion-VSA-197", "string" ],
                198 => [ "Alvarion-VSA-198", "string" ],
                199 => [ "Alvarion-VSA-199", "string" ],
                200 => [ "Alvarion-VSA-200", "string" ],
                201 => [ "Alvarion-VSA-201", "string" ],
                202 => [ "Alvarion-VSA-202", "string" ],
                203 => [ "Alvarion-VSA-203", "string" ],
                204 => [ "Alvarion-VSA-204", "string" ],
                205 => [ "Alvarion-VSA-205", "string" ],
                206 => [ "Alvarion-VSA-206", "string" ],
                207 => [ "Alvarion-VSA-207", "string" ],
                208 => [ "Alvarion-VSA-208", "string" ],
                209 => [ "Alvarion-VSA-209", "string" ],
                210 => [ "Alvarion-VSA-210", "string" ],
                211 => [ "Alvarion-VSA-211", "string" ],
                212 => [ "Alvarion-VSA-212", "string" ],
                213 => [ "Alvarion-VSA-213", "string" ],
                214 => [ "Alvarion-VSA-214", "string" ],
                215 => [ "Alvarion-VSA-215", "string" ],
                216 => [ "Alvarion-VSA-216", "string" ],
                217 => [ "Alvarion-VSA-217", "string" ],
                218 => [ "Alvarion-VSA-218", "string" ],
                219 => [ "Alvarion-VSA-219", "string" ],
                220 => [ "Alvarion-VSA-220", "string" ],
                221 => [ "Alvarion-VSA-221", "string" ],
                222 => [ "Alvarion-VSA-222", "string" ],
                223 => [ "Alvarion-VSA-223", "string" ],
                224 => [ "Alvarion-VSA-224", "string" ],
                225 => [ "Alvarion-VSA-225", "string" ],
                226 => [ "Alvarion-VSA-226", "string" ],
                227 => [ "Alvarion-VSA-227", "string" ],
                228 => [ "Alvarion-VSA-228", "string" ],
                229 => [ "Alvarion-VSA-229", "string" ],
                230 => [ "Alvarion-VSA-230", "string" ],
                231 => [ "Alvarion-VSA-231", "string" ],
                232 => [ "Alvarion-VSA-232", "string" ],
                233 => [ "Alvarion-VSA-233", "string" ],
                234 => [ "Alvarion-VSA-234", "string" ],
                235 => [ "Alvarion-VSA-235", "string" ],
                236 => [ "Alvarion-VSA-236", "string" ],
                237 => [ "Alvarion-VSA-237", "string" ],
                238 => [ "Alvarion-VSA-238", "string" ],
                239 => [ "Alvarion-VSA-239", "string" ],
                240 => [ "Alvarion-VSA-240", "string" ],
                241 => [ "Alvarion-VSA-241", "string" ],
                242 => [ "Alvarion-VSA-242", "string" ],
                243 => [ "Alvarion-VSA-243", "string" ],
                244 => [ "Alvarion-VSA-244", "string" ],
                245 => [ "Alvarion-VSA-245", "string" ],
                246 => [ "Alvarion-VSA-246", "string" ],
                247 => [ "Alvarion-VSA-247", "string" ],
                248 => [ "Alvarion-VSA-248", "string" ],
                249 => [ "Alvarion-VSA-249", "string" ],
                250 => [ "Alvarion-VSA-250", "string" ],
                251 => [ "Alvarion-VSA-251", "string" ],
                252 => [ "Alvarion-VSA-252", "string" ],
                253 => [ "Alvarion-VSA-253", "string" ],
                254 => [ "Alvarion-VSA-254", "string" ],
                255 => [ "Alvarion-VSA-255", "string" ],
            },
            12740 => {
                1 => [ "Equallogic-Admin-Full-Name",        "string" ],
                2 => [ "Equallogic-Admin-Email",            "string" ],
                3 => [ "Equallogic-Admin-Phone",            "string" ],
                4 => [ "Equallogic-Admin-Mobile",           "string" ],
                5 => [ "Equallogic-Poll-Interval",          "integer" ],
                6 => [ "Equallogic-EQL-Admin-Privilege",    "integer" ],
                7 => [ "Equallogic-Admin-Pool-Access",      "string" ],
                8 => [ "Equallogic-Admin-Repl-Site-Access", "string" ],
                9 => [ "Equallogic-Admin-Account-Type",     "string" ],
            },
            12951 => {
                200 => [ "Acct-Interim-Record-Number", "integer" ],
                201 => [ "UE-Info-Type",               "integer" ],
                202 => [ "UE-Info-Value",              "string" ],
                203 => [ "Dynamic-Address-Flag",       "integer" ],
                204 => [ "Local-Seq-Number",           "integer" ],
                205 => [ "Time-First-Usage",           "date" ],
                206 => [ "Time-Last-Usage",            "date" ],
                207 => [ "Charging-Group-ID",          "string" ],
                210 => [ "Service-Data-Container-Bin", "octets" ],
                211 => [ "Service-Data-Container",     "tlv" ],
            },
            13209 => {
                1   => [ "Aptilo-Subnet-Name",            "string" ],
                2   => [ "Aptilo-Octets-Limit",           "integer" ],
                3   => [ "Aptilo-Gigawords-Limit",        "integer" ],
                4   => [ "Aptilo-Input-Octets-Limit",     "integer" ],
                5   => [ "Aptilo-Input-Gigawords-Limit",  "integer" ],
                6   => [ "Aptilo-Output-Octets-Limit",    "integer" ],
                7   => [ "Aptilo-Output-Gigawords-Limit", "integer" ],
                8   => [ "Aptilo-Limit-Mode",             "integer" ],
                9   => [ "Aptilo-Apc-ID",                 "string" ],
                10  => [ "Aptilo-Opaque-Key",             "string" ],
                11  => [ "Aptilo-Denied-Cause",           "integer" ],
                12  => [ "Aptilo-Realm-ID",               "integer" ],
                13  => [ "Aptilo-Ap-ID",                  "integer" ],
                14  => [ "Aptilo-User-ID",                "integer" ],
                15  => [ "Aptilo-Zone",                   "string" ],
                16  => [ "Aptilo-First-Name",             "string" ],
                17  => [ "Aptilo-Last-Name",              "string" ],
                18  => [ "Aptilo-Phone",                  "string" ],
                19  => [ "Aptilo-Email",                  "string" ],
                20  => [ "Aptilo-Organization",           "string" ],
                21  => [ "Aptilo-Access-Profile",         "string" ],
                22  => [ "Aptilo-Realm-Concurrent-Login", "integer" ],
                23  => [ "Aptilo-Auth-Result",            "integer" ],
                24  => [ "Aptilo-Hotline-Indicator",      "string" ],
                25  => [ "Aptilo-User-Type",              "integer" ],
                26  => [ "Aptilo-Exclusive-Count",        "integer" ],
                27  => [ "Aptilo-Duration-Quota",         "integer" ],
                28  => [ "Aptilo-Volume-Quota",           "string" ],
                29  => [ "Aptilo-RX-Volume-Quota",        "string" ],
                30  => [ "Aptilo-TX-Volume-Quota",        "string" ],
                31  => [ "Aptilo-Resource-Quota",         "integer" ],
                32  => [ "Aptilo-Quota-ID",               "string" ],
                33  => [ "Aptilo-RX-Limit",               "integer" ],
                34  => [ "Aptilo-TX-Limit",               "integer" ],
                35  => [ "Aptilo-TRX-Limit",              "integer" ],
                36  => [ "Aptilo-Bw-Min-Up",              "integer" ],
                37  => [ "Aptilo-Bw-Max-Up",              "integer" ],
                38  => [ "Aptilo-Bw-Min-Down",            "integer" ],
                39  => [ "Aptilo-Bw-Max-Down",            "integer" ],
                40  => [ "Aptilo-Service-Profile",        "string" ],
                41  => [ "Aptilo-Automatic-Service",      "string" ],
                42  => [ "Aptilo-Auth-Type",              "integer" ],
                43  => [ "Aptilo-NAS-Capabilities",       "integer" ],
                44  => [ "Aptilo-Service",                "string" ],
                45  => [ "Aptilo-Service-Profile-ID",     "integer" ],
                50  => [ "Aptilo-Auth-Param",             "integer" ],
                53  => [ "Aptilo-Access-Profile-ID",      "integer" ],
                56  => [ "Aptilo-NAS-Model",              "string" ],
                57  => [ "Aptilo-Debug-Option",           "integer" ],
                58  => [ "Aptilo-Session-Id",             "string" ],
                59  => [ "Aptilo-Prepaid-Capabilities",   "octets" ],
                60  => [ "Aptilo-Octets-Quota",           "octets" ],
                61  => [ "Aptilo-Octets-Threshold",       "octets" ],
                62  => [ "Aptilo-Resource-Threshold",     "integer" ],
                63  => [ "Aptilo-Duration-Threshold",     "integer" ],
                64  => [ "Aptilo-Octets-Balance",         "octets" ],
                65  => [ "Aptilo-Resource-Balance",       "integer" ],
                66  => [ "Aptilo-Duration-Balance",       "integer" ],
                67  => [ "Aptilo-Octets-Used",            "octets" ],
                68  => [ "Aptilo-Resource-Used",          "integer" ],
                69  => [ "Aptilo-Duration-Used",          "integer" ],
                70  => [ "Aptilo-Octets-Request",         "octets" ],
                71  => [ "Aptilo-Resource-Request",       "integer" ],
                72  => [ "Aptilo-Duration-Request",       "integer" ],
                73  => [ "Aptilo-QoS-Indicator",          "string" ],
                74  => [ "Aptilo-Circuit-ID",             "octets" ],
                75  => [ "Aptilo-Remote-ID",              "octets" ],
                76  => [ "Aptilo-Location-Name",          "string" ],
                231 => [ "Aptilo-Key-IPv6-1",             "ipv6addr" ],
                232 => [ "Aptilo-Key-IPv6-2",             "ipv6addr" ],
                233 => [ "Aptilo-Key-IPv6-3",             "ipv6addr" ],
                234 => [ "Aptilo-Key-IPv6-4",             "ipv6addr" ],
                235 => [ "Aptilo-Key-IPv6-5",             "ipv6addr" ],
                236 => [ "Aptilo-Key-Octets-1",           "octets" ],
                237 => [ "Aptilo-Key-Octets-2",           "octets" ],
                238 => [ "Aptilo-Key-Octets-3",           "octets" ],
                239 => [ "Aptilo-Key-Octets-4",           "octets" ],
                240 => [ "Aptilo-Key-Octets-5",           "octets" ],
                241 => [ "Aptilo-Key-String-1",           "string" ],
                242 => [ "Aptilo-Key-String-2",           "string" ],
                243 => [ "Aptilo-Key-String-3",           "string" ],
                244 => [ "Aptilo-Key-String-4",           "string" ],
                245 => [ "Aptilo-Key-String-5",           "string" ],
                246 => [ "Aptilo-Key-IP-1",               "ipaddr" ],
                247 => [ "Aptilo-Key-IP-2",               "ipaddr" ],
                248 => [ "Aptilo-Key-IP-3",               "ipaddr" ],
                249 => [ "Aptilo-Key-IP-4",               "ipaddr" ],
                250 => [ "Aptilo-Key-IP-5",               "ipaddr" ],
                251 => [ "Aptilo-Key-Integer-1",          "integer" ],
                252 => [ "Aptilo-Key-Integer-2",          "integer" ],
                253 => [ "Aptilo-Key-Integer-3",          "integer" ],
                254 => [ "Aptilo-Key-Integer-4",          "integer" ],
                255 => [ "Aptilo-Key-Integer-5",          "integer" ],
            },
            13644 => {
                1 => [ "pfSense-Bandwidth-Max-Up",   "integer" ],
                2 => [ "pfSense-Bandwidth-Max-Down", "integer" ],
                3 => [ "pfSense-Max-Total-Octets",   "integer" ],
            },
            14122 => {
                1  => [ "WISPr-Location-ID",                  "string" ],
                2  => [ "WISPr-Location-Name",                "string" ],
                3  => [ "WISPr-Logoff-URL",                   "string" ],
                4  => [ "WISPr-Redirection-URL",              "string" ],
                5  => [ "WISPr-Bandwidth-Min-Up",             "integer" ],
                6  => [ "WISPr-Bandwidth-Min-Down",           "integer" ],
                7  => [ "WISPr-Bandwidth-Max-Up",             "integer" ],
                8  => [ "WISPr-Bandwidth-Max-Down",           "integer" ],
                9  => [ "WISPr-Session-Terminate-Time",       "string" ],
                10 => [ "WISPr-Session-Terminate-End-Of-Day", "string" ],
                11 => [ "WISPr-Billing-Class-Of-Service",     "string" ],
            },
            14179 => {
                1 => [ "Airespace-Wlan-Id",                         "integer" ],
                2 => [ "Airespace-QOS-Level",                       "integer" ],
                3 => [ "Airespace-DSCP",                            "integer" ],
                4 => [ "Airespace-8021p-Tag",                       "integer" ],
                5 => [ "Airespace-Interface-Name",                  "string" ],
                6 => [ "Airespace-ACL-Name",                        "string" ],
                7 => [ "Airespace-Data-Bandwidth-Average-Contract", "integer" ],
                8 => [
                    "Airespace-Real-Time-Bandwidth-Average-Contract", "integer"
                ],
                9  => [ "Airespace-Data-Bandwidth-Burst-Contract", "integer" ],
                10 =>
                  [ "Airespace-Real-Time-Bandwidth-Burst-Contract", "integer" ],
                11 => [ "Airespace-Guest-Role-Name", "string" ],
                13 => [
                    "Airespace-Data-Bandwidth-Average-Contract-Upstream",
                    "integer",
                ],
                14 => [
                    "Airespace-Real-Time-Bandwidth-Average-Contract-Upstream",
                    "integer",
                ],
                15 => [
                    "Airespace-Data-Bandwidth-Burst-Contract-Upstream",
                    "integer"
                ],
                16 => [
                    "Airespace-Real-Time-Bandwidth-Burst-Contract-Upstream",
                    "integer",
                ],
            },
            14436 => {
                1 => [ "Quiconnect-AVPair",          "string" ],
                2 => [ "Quiconnect-VNP-Information", "string" ],
                3 => [ "Quiconnect-HSP-Information", "string" ],
            },
            14501 => {
                1 => [ "Blue-Coat-Group",         "string" ],
                2 => [ "Blue-Coat-Authorization", "integer" ],
            },
            14525 => {
                1  => [ "Trapeze-VLAN-Name",           "string" ],
                2  => [ "Trapeze-Mobility-Profile",    "string" ],
                3  => [ "Trapeze-Encryption-Type",     "string" ],
                4  => [ "Trapeze-Time-Of-Day",         "string" ],
                5  => [ "Trapeze-SSID",                "string" ],
                6  => [ "Trap