export default {
  'fingerbank-1': { // Windows OS
    width: 448,
    height: 512,
    d: 'M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z'
  },
  'fingerbank-2': { // Mac OS X or macOS
    width: 384,
    height: 512,
    d: 'M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z'
  },
  'fingerbank-3': { // VoIP Device
    width: 576,
    height: 512,
    d: 'M128 416H192C209.625 416 224 401.625 224 384V32C224 14.375 209.625 0 192 0H128C110.375 0 96 14.375 96 32V384C96 401.625 110.375 416 128 416ZM528 32H256V384C256 419.25 227.25 448 192 448H128C92.75 448 64 419.25 64 384V32H48C21.5 32 0 53.5 0 80V464C0 490.5 21.5 512 48 512H528C554.5 512 576 490.5 576 464V80C576 53.5 554.5 32 528 32ZM384 432C384 440.875 376.875 448 368 448H336C327.125 448 320 440.875 320 432V400C320 391.125 327.125 384 336 384H368C376.875 384 384 391.125 384 400V432ZM384 304C384 312.875 376.875 320 368 320H336C327.125 320 320 312.875 320 304V272C320 263.125 327.125 256 336 256H368C376.875 256 384 263.125 384 272V304ZM512 432C512 440.875 504.875 448 496 448H464C455.125 448 448 440.875 448 432V400C448 391.125 455.125 384 464 384H496C504.875 384 512 391.125 512 400V432ZM512 304C512 312.875 504.875 320 496 320H464C455.125 320 448 312.875 448 304V272C448 263.125 455.125 256 464 256H496C504.875 256 512 263.125 512 272V304ZM512 192H320V96H512V192Z'
  },
  'fingerbank-4': { // Router, Access Point or Femtocell
    width: 576,
    height: 512,
    d: 'M200.254 105.523C283.941 28.471 420.064 28.471 503.75 105.523C513.5 114.502 528.688 113.861 537.656 104.1C541.906 99.486 544 93.65 544 87.834C544 81.357 541.406 74.881 536.25 70.141C434.658 -23.381 269.348 -23.381 167.754 70.141C157.973 79.104 157.379 94.324 166.348 104.1C175.316 113.861 190.504 114.502 200.254 105.523ZM528.004 320.012H376V248.016C376 234.762 365.256 224.018 352.002 224.018H352C338.746 224.018 328 234.762 328 248.018V320.012H48C21.49 320.012 0 341.502 0 368.012V464.002C0 490.51 21.49 512 47.998 512H528C554.51 512 576 490.51 576 464V368.008C576 341.5 554.512 320.012 528.004 320.012ZM96 448.004C78.375 448.004 64 433.629 64 416.006C64 398.381 78.375 384.008 96 384.008S128 398.381 128 416.006C128 433.629 113.625 448.004 96 448.004ZM192 448.004C174.375 448.004 160 433.629 160 416.006C160 398.381 174.375 384.008 192 384.008S224 398.381 224 416.006C224 433.629 209.625 448.004 192 448.004ZM248.16 149.867C238.191 158.596 237.223 173.77 245.973 183.779C254.723 193.744 269.879 194.729 279.848 185.969C319.627 150.994 384.377 150.994 424.158 185.969C434.127 194.729 449.283 193.744 458.033 183.779C462.031 179.211 464 173.564 464 167.934C464 161.256 461.25 154.607 455.846 149.867C398.596 99.533 305.408 99.533 248.16 149.867Z'
  },
  'fingerbank-5': { // Linux OS
    width: 448,
    height: 512,
    d: 'M220.8 123.3c1 .5 1.8 1.7 3 1.7 1.1 0 2.8-.4 2.9-1.5.2-1.4-1.9-2.3-3.2-2.9-1.7-.7-3.9-1-5.5-.1-.4.2-.8.7-.6 1.1.3 1.3 2.3 1.1 3.4 1.7zm-21.9 1.7c1.2 0 2-1.2 3-1.7 1.1-.6 3.1-.4 3.5-1.6.2-.4-.2-.9-.6-1.1-1.6-.9-3.8-.6-5.5.1-1.3.6-3.4 1.5-3.2 2.9.1 1 1.8 1.5 2.8 1.4zM420 403.8c-3.6-4-5.3-11.6-7.2-19.7-1.8-8.1-3.9-16.8-10.5-22.4-1.3-1.1-2.6-2.1-4-2.9-1.3-.8-2.7-1.5-4.1-2 9.2-27.3 5.6-54.5-3.7-79.1-11.4-30.1-31.3-56.4-46.5-74.4-17.1-21.5-33.7-41.9-33.4-72C311.1 85.4 315.7.1 234.8 0 132.4-.2 158 103.4 156.9 135.2c-1.7 23.4-6.4 41.8-22.5 64.7-18.9 22.5-45.5 58.8-58.1 96.7-6 17.9-8.8 36.1-6.2 53.3-6.5 5.8-11.4 14.7-16.6 20.2-4.2 4.3-10.3 5.9-17 8.3s-14 6-18.5 14.5c-2.1 3.9-2.8 8.1-2.8 12.4 0 3.9.6 7.9 1.2 11.8 1.2 8.1 2.5 15.7.8 20.8-5.2 14.4-5.9 24.4-2.2 31.7 3.8 7.3 11.4 10.5 20.1 12.3 17.3 3.6 40.8 2.7 59.3 12.5 19.8 10.4 39.9 14.1 55.9 10.4 11.6-2.6 21.1-9.6 25.9-20.2 12.5-.1 26.3-5.4 48.3-6.6 14.9-1.2 33.6 5.3 55.1 4.1.6 2.3 1.4 4.6 2.5 6.7v.1c8.3 16.7 23.8 24.3 40.3 23 16.6-1.3 34.1-11 48.3-27.9 13.6-16.4 36-23.2 50.9-32.2 7.4-4.5 13.4-10.1 13.9-18.3.4-8.2-4.4-17.3-15.5-29.7zM223.7 87.3c9.8-22.2 34.2-21.8 44-.4 6.5 14.2 3.6 30.9-4.3 40.4-1.6-.8-5.9-2.6-12.6-4.9 1.1-1.2 3.1-2.7 3.9-4.6 4.8-11.8-.2-27-9.1-27.3-7.3-.5-13.9 10.8-11.8 23-4.1-2-9.4-3.5-13-4.4-1-6.9-.3-14.6 2.9-21.8zM183 75.8c10.1 0 20.8 14.2 19.1 33.5-3.5 1-7.1 2.5-10.2 4.6 1.2-8.9-3.3-20.1-9.6-19.6-8.4.7-9.8 21.2-1.8 28.1 1 .8 1.9-.2-5.9 5.5-15.6-14.6-10.5-52.1 8.4-52.1zm-13.6 60.7c6.2-4.6 13.6-10 14.1-10.5 4.7-4.4 13.5-14.2 27.9-14.2 7.1 0 15.6 2.3 25.9 8.9 6.3 4.1 11.3 4.4 22.6 9.3 8.4 3.5 13.7 9.7 10.5 18.2-2.6 7.1-11 14.4-22.7 18.1-11.1 3.6-19.8 16-38.2 14.9-3.9-.2-7-1-9.6-2.1-8-3.5-12.2-10.4-20-15-8.6-4.8-13.2-10.4-14.7-15.3-1.4-4.9 0-9 4.2-12.3zm3.3 334c-2.7 35.1-43.9 34.4-75.3 18-29.9-15.8-68.6-6.5-76.5-21.9-2.4-4.7-2.4-12.7 2.6-26.4v-.2c2.4-7.6.6-16-.6-23.9-1.2-7.8-1.8-15 .9-20 3.5-6.7 8.5-9.1 14.8-11.3 10.3-3.7 11.8-3.4 19.6-9.9 5.5-5.7 9.5-12.9 14.3-18 5.1-5.5 10-8.1 17.7-6.9 8.1 1.2 15.1 6.8 21.9 16l19.6 35.6c9.5 19.9 43.1 48.4 41 68.9zm-1.4-25.9c-4.1-6.6-9.6-13.6-14.4-19.6 7.1 0 14.2-2.2 16.7-8.9 2.3-6.2 0-14.9-7.4-24.9-13.5-18.2-38.3-32.5-38.3-32.5-13.5-8.4-21.1-18.7-24.6-29.9s-3-23.3-.3-35.2c5.2-22.9 18.6-45.2 27.2-59.2 2.3-1.7.8 3.2-8.7 20.8-8.5 16.1-24.4 53.3-2.6 82.4.6-20.7 5.5-41.8 13.8-61.5 12-27.4 37.3-74.9 39.3-112.7 1.1.8 4.6 3.2 6.2 4.1 4.6 2.7 8.1 6.7 12.6 10.3 12.4 10 28.5 9.2 42.4 1.2 6.2-3.5 11.2-7.5 15.9-9 9.9-3.1 17.8-8.6 22.3-15 7.7 30.4 25.7 74.3 37.2 95.7 6.1 11.4 18.3 35.5 23.6 64.6 3.3-.1 7 .4 10.9 1.4 13.8-35.7-11.7-74.2-23.3-84.9-4.7-4.6-4.9-6.6-2.6-6.5 12.6 11.2 29.2 33.7 35.2 59 2.8 11.6 3.3 23.7.4 35.7 16.4 6.8 35.9 17.9 30.7 34.8-2.2-.1-3.2 0-4.2 0 3.2-10.1-3.9-17.6-22.8-26.1-19.6-8.6-36-8.6-38.3 12.5-12.1 4.2-18.3 14.7-21.4 27.3-2.8 11.2-3.6 24.7-4.4 39.9-.5 7.7-3.6 18-6.8 29-32.1 22.9-76.7 32.9-114.3 7.2zm257.4-11.5c-.9 16.8-41.2 19.9-63.2 46.5-13.2 15.7-29.4 24.4-43.6 25.5s-26.5-4.8-33.7-19.3c-4.7-11.1-2.4-23.1 1.1-36.3 3.7-14.2 9.2-28.8 9.9-40.6.8-15.2 1.7-28.5 4.2-38.7 2.6-10.3 6.6-17.2 13.7-21.1.3-.2.7-.3 1-.5.8 13.2 7.3 26.6 18.8 29.5 12.6 3.3 30.7-7.5 38.4-16.3 9-.3 15.7-.9 22.6 5.1 9.9 8.5 7.1 30.3 17.1 41.6 10.6 11.6 14 19.5 13.7 24.6zM173.3 148.7c2 1.9 4.7 4.5 8 7.1 6.6 5.2 15.8 10.6 27.3 10.6 11.6 0 22.5-5.9 31.8-10.8 4.9-2.6 10.9-7 14.8-10.4s5.9-6.3 3.1-6.6-2.6 2.6-6 5.1c-4.4 3.2-9.7 7.4-13.9 9.8-7.4 4.2-19.5 10.2-29.9 10.2s-18.7-4.8-24.9-9.7c-3.1-2.5-5.7-5-7.7-6.9-1.5-1.4-1.9-4.6-4.3-4.9-1.4-.1-1.8 3.7 1.7 6.5z'
  },
  'fingerbank-6': { // Gaming Console
    width: 640,
    height: 512,
    d: 'M448 64H192C85.961 64 0 149.961 0 256S85.961 448 192 448H448C554.039 448 640 362.039 640 256S554.039 64 448 64ZM248.055 267.988C248.055 274.613 242.68 279.988 236.055 279.988H184.055V331.988C184.055 338.613 178.68 343.988 172.055 343.988H148.055C141.43 343.988 136.055 338.613 136.055 331.988V279.988H84.055C77.43 279.988 72.055 274.613 72.055 267.988V243.988C72.055 237.363 77.43 231.988 84.055 231.988H136.055V179.988C136.055 173.363 141.43 167.988 148.055 167.988H172.055C178.68 167.988 184.055 173.363 184.055 179.988V231.988H236.055C242.68 231.988 248.055 237.363 248.055 243.988V267.988ZM432 344.012C409.875 344.012 392 326.137 392 304.012S409.875 264.012 432 264.012S472 281.887 472 304.012S454.125 344.012 432 344.012ZM496 248C473.875 248 456 230.125 456 208S473.875 168 496 168S536 185.875 536 208S518.125 248 496 248Z'
  },
  'fingerbank-7': { // Audio, Imaging or Video Equipment
    width: 576,
    height: 512,
    d: 'M384 112V400C384 426.51 362.51 448 336 448H48C21.49 448 0 426.51 0 400V112C0 85.49 21.49 64 48 64H336C362.51 64 384 85.49 384 112ZM576 127.5V384.406C576 409.906 546.812 424.797 525.594 410.203L416 334.703V177.297L525.594 101.703C546.906 87.094 576 102.094 576 127.5Z'
  },
  'fingerbank-8': { // Printer or Scanner
    width: 512,
    height: 512,
    d: 'M448 192H64C28.654 192 0 220.654 0 256V352C0 369.674 14.326 384 32 384H64V480C64 497.674 78.326 512 96 512H416C433.674 512 448 497.674 448 480V384H480C497.674 384 512 369.674 512 352V256C512 220.654 483.346 192 448 192ZM384 448H128V352H384V448ZM432 296C418.75 296 408 285.25 408 272C408 258.734 418.75 248 432 248S456 258.734 456 272C456 285.25 445.25 296 432 296ZM128 64H357.49L384 90.51V160H448V77.25C448 68.766 444.625 60.625 438.625 54.625L393.375 9.375C387.375 3.375 379.219 0 370.75 0H96C78.344 0 64 14.328 64 32V160H128V64Z'
  },
  'fingerbank-9': { // Switch and Wireless Controller
    width: 576,
    height: 512,
    d: 'M183.748 149.969C173.756 141.223 158.586 142.223 149.844 152.156C99.516 209.406 99.516 302.594 149.844 359.844C154.582 365.25 161.229 368 167.906 368C173.521 368 179.182 366.031 183.748 362.031C193.711 353.281 194.697 338.125 185.939 328.156C150.969 288.375 150.969 223.625 185.939 183.844C194.697 173.875 193.711 158.719 183.748 149.969ZM512.812 75.965C501.719 62.184 481.578 59.996 467.828 71.027C454.031 82.09 451.828 102.246 462.875 116.027C495.016 156.09 512 204.496 512 256C512 307.5 495.016 355.906 462.875 395.969C451.828 409.75 454.031 429.906 467.828 440.969C473.734 445.688 480.797 448 487.828 448C497.203 448 506.484 443.906 512.812 436.031C553.562 385.219 576 321.281 576 256C576 190.715 553.562 126.777 512.812 75.965ZM64 256C64 204.496 80.984 156.09 113.125 116.027C124.172 102.246 121.969 82.09 108.172 71.027C94.422 60.059 74.281 62.215 63.187 75.965C22.438 126.777 0 190.715 0 256C0 321.281 22.438 385.219 63.188 436.031C69.516 443.906 78.797 448 88.172 448C95.203 448 102.266 445.688 108.172 440.969C121.969 429.906 124.172 409.75 113.125 395.969C80.984 355.906 64 307.5 64 256ZM426.156 152.156C417.43 142.191 402.26 141.223 392.252 149.969C382.289 158.719 381.303 173.875 390.061 183.844C425.031 223.625 425.031 288.375 390.061 328.156C381.303 338.125 382.289 353.281 392.252 362.031C396.818 366.031 402.463 368 408.094 368C414.771 368 421.418 365.25 426.156 359.844C476.484 302.594 476.484 209.406 426.156 152.156ZM288 200C257.125 200 232 225.125 232 256S257.125 312 288 312S344 286.875 344 256S318.875 200 288 200Z'
  },
  'fingerbank-10': { // Storage Device
    width: 448,
    height: 512,
    d: 'M433.938 129.938L350.062 46.062C342.328 38.328 327.051 32 316.113 32H64C28.654 32 0 60.652 0 96V416C0 451.346 28.654 480 64 480H384C419.346 480 448 451.346 448 416V163.887C448 152.949 441.672 137.672 433.938 129.938ZM224 416C188.656 416 160 387.344 160 352S188.656 288 224 288S288 316.656 288 352S259.344 416 224 416ZM320 208C320 216.836 312.836 224 304 224H80C71.164 224 64 216.836 64 208V112C64 103.162 71.164 96 80 96H304C312.836 96 320 103.162 320 112V208Z'
  },
  'fingerbank-11': { // Phone, Tablet or Wearable
    width: 448,
    height: 512,
    d: 'M384 0H64C28.654 0 0 28.652 0 64V448C0 483.346 28.654 512 64 512H384C419.346 512 448 483.346 448 448V64C448 28.652 419.346 0 384 0ZM288 448C288 456.837 280.837 464 272 464H176C167.163 464 160 456.837 160 448V448C160 439.163 167.163 432 176 432H272C280.837 432 288 439.163 288 448V448Z'
  },
  'fingerbank-12': { // Monitoring and Testing Device
    width: 576,
    height: 512,
    d: 'M480 128H96V256H197C200 256 202.75 257.75 204.125 260.375L224 300.25L273.75 200.875C279.625 189 296.375 189 302.25 200.875L329.875 256H400C408.875 256 416 263.125 416 272S408.875 288 400 288H310.125L288 243.75L238.25 343.125C232.375 355 215.625 355 209.75 343.125L182.125 288H96V384H480V128ZM528 32H48C21.5 32 0 53.5 0 80V432C0 458.5 21.5 480 48 480H528C554.5 480 576 458.5 576 432V80C576 53.5 554.5 32 528 32ZM512 416H64V96H512V416Z'
  },
  'fingerbank-13': { // Video Conferencing
    width: 448,
    height: 512,
    d: 'M400.875 438.625L351.75 407.875C409.875 367.375 448 300.25 448 224C448 100.25 347.625 0 224 0C100.25 0 0 100.25 0 224C0 300.25 38.125 367.375 96.125 407.875L47 438.625C37.625 444.5 32 454.75 32 465.75V480C32 497.625 46.375 512 64 512H384C401.625 512 416 497.625 416 480V465.75C416 454.75 410.25 444.5 400.875 438.625ZM223.875 384C135.5 384 63.875 312.375 63.875 224S135.5 64 223.875 64S383.875 135.625 383.875 224S312.25 384 224 384H223.875ZM223.875 96C153.25 96 95.875 153.25 95.875 224S153.25 352 223.875 352C294.625 352 351.875 294.75 351.875 224C351.875 153.375 294.625 96 224 96H223.875ZM223.875 176C197.375 176 176 197.5 175.875 224C175.875 232.875 168.75 240 159.875 240C151.125 240 143.875 232.875 143.875 224C144 179.875 179.75 144 223.875 144C232.75 144 239.875 151.125 239.875 160S232.75 176 223.875 176Z'
  },
  'fingerbank-14': { // BSD OS
    width: 448,
    height: 512,
    d: 'M303.7 96.2c11.1-11.1 115.5-77 139.2-53.2 23.7 23.7-42.1 128.1-53.2 139.2-11.1 11.1-39.4.9-63.1-22.9-23.8-23.7-34.1-52-22.9-63.1zM109.9 68.1C73.6 47.5 22 24.6 5.6 41.1c-16.6 16.6 7.1 69.4 27.9 105.7 18.5-32.2 44.8-59.3 76.4-78.7zM406.7 174c3.3 11.3 2.7 20.7-2.7 26.1-20.3 20.3-87.5-27-109.3-70.1-18-32.3-11.1-53.4 14.9-48.7 5.7-3.6 12.3-7.6 19.6-11.6-29.8-15.5-63.6-24.3-99.5-24.3-119.1 0-215.6 96.5-215.6 215.6 0 119 96.5 215.6 215.6 215.6S445.3 380.1 445.3 261c0-38.4-10.1-74.5-27.7-105.8-3.9 7-7.6 13.3-10.9 18.8z'
  },
  'fingerbank-15': { // Internet of Things (IoT)
    width: 640,
    height: 512,
    d: 'M624 280C632.875 280 640 272.875 640 264V248C640 239.125 632.875 232 624 232H344V192H416C433.625 192 448 177.625 448 160V32C448 14.375 433.625 0 416 0H224C206.375 0 192 14.375 192 32V160C192 177.625 206.375 192 224 192H296V232H16C7.125 232 0 239.125 0 248V264C0 272.875 7.125 280 16 280H104V320H32C14.375 320 0 334.375 0 352V480C0 497.625 14.375 512 32 512H224C241.625 512 256 497.625 256 480V352C256 334.375 241.625 320 224 320H152V280H488V320H416C398.375 320 384 334.375 384 352V480C384 497.625 398.375 512 416 512H608C625.625 512 640 497.625 640 480V352C640 334.375 625.625 320 608 320H536V280H624ZM192 384V448H64V384H192ZM256 128V64H384V128H256ZM576 384V448H448V384H576Z'
  },
  'fingerbank-17': { // Network Boot Agent
    width: 512,
    height: 512,
    paths: [
      {
        d: 'M512 208V432C512 440.75 504.75 448 496 448H416V320H384V448H320V320H288V448H224V320H192V448H128V320H96V448H16C7.25 448 0 440.75 0 432V208C0 199.25 7.25 192 16 192H64V144C64 135.25 71.25 128 80 128H128V80C128 71.25 135.25 64 144 64H368C376.75 64 384 71.25 384 80V128H432C440.75 128 448 135.25 448 144V192H496C504.75 192 512 199.25 512 208Z'
      },
      {
        style: 'fill-opacity: 0.5',
        d: 'M96 448H128V320H96V448ZM192 448H224V320H192V448ZM288 448H320V320H288V448ZM384 320V448H416V320H384Z'
      }
    ]
  },
  'fingerbank-19': { // Solaris
    width: 512,
    height: 512,
    d: 'M256 160C202.98 160 160 202.98 160 256S202.98 352 256 352S352 309.02 352 256S309.019 160 256 160ZM509.263 347.008L446.109 255.998L509.262 164.988C515.594 155.863 510.365 143.246 499.435 141.269L390.429 121.57L370.728 12.562C368.754 1.63 356.135 -3.595 347.008 2.737L256 65.888L164.99 2.735C155.865 -3.597 143.246 1.628 141.269 12.56L121.57 121.57L12.562 141.267C1.633 143.244 -3.596 155.863 2.736 164.986L65.89 256L2.738 347.01C-3.594 356.135 1.633 368.752 12.562 370.727L121.57 390.426L141.269 499.436C143.244 510.366 155.863 515.595 164.99 509.261L256 446.108L347.01 509.261C356.137 515.595 368.756 510.368 370.73 499.438L390.428 390.426L499.437 370.727C510.369 368.752 515.596 356.135 509.263 347.008ZM256 384C185.306 384 128 326.692 128 256C128 185.306 185.306 128 256 128S384 185.306 384 256C384 326.692 326.693 384 256 384Z'
  },
  'fingerbank-20': { // Projector
    width: 640,
    height: 512,
    d: 'M416 128C429.25 128 440 117.25 440 104V24C440 10.75 429.25 0 416 0S392 10.75 392 24V104C392 117.25 402.75 128 416 128ZM512 136C518.156 136 524.281 133.656 528.969 128.969L584.969 72.969C594.344 63.594 594.344 48.406 584.969 39.031S560.406 29.656 551.031 39.031L495.031 95.031C485.656 104.406 485.656 119.594 495.031 128.969C499.719 133.656 505.844 136 512 136ZM303.031 128.969C307.719 133.656 313.844 136 320 136S332.281 133.656 336.969 128.969C346.344 119.594 346.344 104.406 336.969 95.031L280.969 39.031C271.594 29.656 256.406 29.656 247.031 39.031S237.656 63.594 247.031 72.969L303.031 128.969ZM592 192H511.121C484.473 172.156 451.779 160 416 160S347.527 172.156 320.879 192H48C21.5 192 0 213.5 0 240V400C0 426.5 21.5 448 48 448H64L77 499.875C78.75 507 85.125 512 92.5 512H131.5C138.875 512 145.25 507 147 499.875L160 448H320.879C347.527 467.844 380.221 480 416 480C440.438 480 463.336 474.088 484.055 464.291L493 499.875C494.75 507 501.125 512 508.5 512H547.5C554.875 512 561.25 507 563 499.875L576 448H592C618.5 448 640 426.5 640 400V240C640 213.5 618.5 192 592 192ZM96 352C78.375 352 64 337.625 64 320S78.375 288 96 288S128 302.375 128 320S113.625 352 96 352ZM192 352C174.375 352 160 337.625 160 320S174.375 288 192 288S224 302.375 224 320S209.625 352 192 352ZM416 416C362.98 416 320 373.02 320 320S362.98 224 416 224S512 266.98 512 320S469.02 416 416 416Z'
  },
  'fingerbank-21': { // Thin Client
    width: 512,
    height: 512,
    d: 'M448 64H64C28.625 64 0 92.625 0 128V384C0 419.375 28.625 448 64 448H448C483.375 448 512 419.375 512 384V128C512 92.625 483.375 64 448 64ZM160 368H80C71.125 368 64 360.875 64 352V336C64 327.125 71.125 320 80 320H160V368ZM288 352C288 360.875 280.875 368 272 368H192V320H272C280.875 320 288 327.125 288 336V352ZM448 224C448 241.625 433.625 256 416 256H96C78.375 256 64 241.625 64 224V160C64 142.375 78.375 128 96 128H416C433.625 128 448 142.375 448 160V224Z'
  },
  'fingerbank-22': { // Physical Security
    width: 512,
    height: 512,
    d: 'M466.5 83.68L274.5 3.672C269.625 1.641 261.344 0 256.062 0C250.75 0 242.5 1.641 237.594 3.672L45.594 83.68C27.688 91.07 16 108.574 16 127.98C16 385.158 205.163 512 255.953 512C307.952 512 496 383.814 496 127.98C496 108.574 484.312 91.07 466.5 83.68ZM256 446.496V65.508C256.006 65.484 256.047 65.316 256.047 65.316L431.881 138.586C427.777 319.703 319.023 417.07 256 446.496Z'
  },
  'fingerbank-23': { // Datacenter Appliance
    width: 512,
    height: 512,
    d: 'M480 288H32C14.375 288 0 302.375 0 320V448C0 465.625 14.375 480 32 480H480C497.625 480 512 465.625 512 448V320C512 302.375 497.625 288 480 288ZM352 408C338.75 408 328 397.25 328 384S338.75 360 352 360S376 370.75 376 384S365.25 408 352 408ZM416 408C402.75 408 392 397.25 392 384S402.75 360 416 360S440 370.75 440 384S429.25 408 416 408ZM480 32H32C14.375 32 0 46.375 0 64V192C0 209.625 14.375 224 32 224H480C497.625 224 512 209.625 512 192V64C512 46.375 497.625 32 480 32ZM352 152C338.75 152 328 141.25 328 128S338.75 104 352 104S376 114.75 376 128S365.25 152 352 152ZM416 152C402.75 152 392 141.25 392 128S402.75 104 416 104S440 114.75 440 128S429.25 152 416 152Z'
  },
  'fingerbank-24': { // Point of Sale Device
    width: 512,
    height: 512,
    d: 'M511.008 377.304L484.5 218.75C481.931 203.384 468.633 192.125 453.054 192.125H208.125V128.125H288.125C305.725 128.125 320.125 113.725 320.125 96.125V32C320.125 14.4 305.725 0 288.125 0H64.125C46.525 0 32.125 14.4 32.125 32V96C32.125 113.6 46.525 128 64.125 128H144.125V192H59.219C43.566 192 30.206 203.312 27.625 218.75L0.875 378.75C0.583 382.269 0.292 385.771 0 389.29V480C0 497.673 14.327 512 32 512H480C497.673 512 512 497.673 512 480V389.25C511.726 385.954 511.282 380.601 511.008 377.304ZM280.125 248C280.125 239.25 287.375 232 296.125 232H312.125C320.875 232 328.125 239.25 328.125 248V264C328.125 272.75 320.875 280 312.125 280H296.125C287.375 280 280.125 272.75 280.125 264V248ZM248.125 312H264.125C272.875 312 280.125 319.25 280.125 328V344C280.125 352.75 272.875 360 264.125 360H248.125C239.375 360 232.125 352.75 232.125 344V328C232.125 319.25 239.375 312 248.125 312ZM216.125 232C224.875 232 232.125 239.25 232.125 248V264C232.125 272.75 224.875 280 216.125 280H200.125C191.375 280 184.125 272.75 184.125 264V248C184.125 239.25 191.375 232 200.125 232H216.125ZM80.125 80V48H272.125V80H80.125ZM120.125 280H104.125C95.375 280 88.125 272.75 88.125 264V248C88.125 239.25 95.375 232 104.125 232H120.125C128.875 232 136.125 239.25 136.125 248V264C136.125 272.75 128.875 280 120.125 280ZM136.125 344V328C136.125 319.25 143.375 312 152.125 312H168.125C176.875 312 184.125 319.25 184.125 328V344C184.125 352.75 176.875 360 168.125 360H152.125C143.375 360 136.125 352.75 136.125 344ZM352.125 448C352.125 456.8 344.925 464 336.125 464H176.125C167.325 464 160.125 456.8 160.125 448V448C160.125 439.2 167.325 432 176.125 432H336.125C344.925 432 352.125 439.2 352.125 448V448ZM376.125 344C376.125 352.75 368.875 360 360.125 360H344.125C335.375 360 328.125 352.75 328.125 344V328C328.125 319.25 335.375 312 344.125 312H360.125C368.875 312 376.125 319.25 376.125 328V344ZM424.125 264C424.125 272.75 416.875 280 408.125 280H392.125C383.375 280 376.125 272.75 376.125 264V248C376.125 239.25 383.375 232 392.125 232H408.125C416.875 232 424.125 239.25 424.125 248V264Z'
  },
  'fingerbank-26': { // Microsoft Windows Kernel 5.1,5.2
    width: 448,
    height: 512,
    d: 'M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z'
  },
  'fingerbank-27': { // Microsoft Windows Kernel 5.0
    width: 448,
    height: 512,
    d: 'M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z'
  },
  'fingerbank-28': { // Microsoft Windows Kernel 4.90
    width: 448,
    height: 512,
    d: 'M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z'
  },
  'fingerbank-8238': { // Medical Device
    width: 576,
    height: 512,
    d: 'M528 0h-480C21.5 0 0 21.5 0 48v320C0 394.5 21.5 416 48 416h192L224 464H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24H352L336 416h192c26.5 0 48-21.5 48-48v-320C576 21.5 554.5 0 528 0zM512 352H64V64h448V352zM208 239.1H256v48C256 296.8 263.2 304 272 304h32c8.801 0 16-7.202 16-16v-48h48C376.8 239.1 384 232.8 384 224V191.1C384 183.2 376.8 176 368 176H320V128c0-8.801-7.199-16-16-16h-32C263.2 112 256 119.2 256 128v48H208C199.2 176 192 183.2 192 191.1V224C192 232.8 199.2 239.1 208 239.1z'
  },
  'fingerbank-16842': { // Robotics and Industrial Automation
    width: 640,
    height: 512,
    d: 'M9.375 233.375C3.375 239.375 0 247.5 0 256V384C0 392.5 3.375 400.625 9.375 406.625S23.5 416 32 416H64V224H32C23.5 224 15.375 227.375 9.375 233.375ZM464 96H352V32C352 14.375 337.625 0 320 0S288 14.375 288 32V96H176C131.75 96 96 131.75 96 176V448C96 483.375 124.625 512 160 512H480C515.375 512 544 483.375 544 448V176C544 131.75 508.25 96 464 96ZM256 416H192V384H256V416ZM224 296C201.875 296 184 278.125 184 256S201.875 216 224 216S264 233.875 264 256S246.125 296 224 296ZM352 416H288V384H352V416ZM448 416H384V384H448V416ZM416 296C393.875 296 376 278.125 376 256S393.875 216 416 216S456 233.875 456 256S438.125 296 416 296ZM630.625 233.375C624.625 227.375 616.5 224 608 224H576V416H608C616.5 416 624.625 412.625 630.625 406.625S640 392.5 640 384V256C640 247.5 636.625 239.375 630.625 233.375Z'
  },
  'fingerbank-16861': { // Hardware Manufacturer
    width: 512,
    height: 512,
    d: 'M160 352H352V160H160V352ZM448 176H496C504.838 176 512 168.836 512 160S504.838 144 496 144H448V128C448 92.654 419.348 64 384 64H368V16C368 7.164 360.838 0 352 0C343.164 0 336 7.164 336 16V64H272V16C272 7.164 264.838 0 256 0C247.164 0 240 7.164 240 16V64H176V16C176 7.164 168.838 0 160 0C151.164 0 144 7.164 144 16V64H128C92.654 64 64 92.654 64 128V144H16C7.164 144 0 151.164 0 160S7.164 176 16 176H64V240H16C7.164 240 0 247.164 0 256S7.164 272 16 272H64V336H16C7.164 336 0 343.164 0 352S7.164 368 16 368H64V384C64 419.346 92.654 448 128 448H144V496C144 504.836 151.164 512 160 512C168.838 512 176 504.836 176 496V448H240V496C240 504.836 247.164 512 256 512C264.838 512 272 504.836 272 496V448H336V496C336 504.836 343.164 512 352 512C360.838 512 368 504.836 368 496V448H384C419.348 448 448 419.346 448 384V368H496C504.838 368 512 360.836 512 352S504.838 336 496 336H448V272H496C504.838 272 512 264.836 512 256S504.838 240 496 240H448V176ZM384 368C384 376.836 376.838 384 368 384H144C135.164 384 128 376.836 128 368V144C128 135.164 135.164 128 144 128H368C376.838 128 384 135.164 384 144V368Z'
  },
  'fingerbank-16879': { // Operating System
    width: 384,
    height: 512,
    d: 'M0 352C0 440.375 71.625 512 160 512H224C312.375 512 384 440.375 384 352V224H0V352ZM176 0H160C71.625 0 0 71.625 0 160V192H176V0ZM224 0H208V192H384V160C384 71.625 312.375 0 224 0Z'
  },
  'fingerbank-33450': { // iOS
    width: 384,
    height: 512,
    d: 'M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z'
  },
  'fingerbank-33453': { // Android OS
    width: 576,
    height: 512,
    d: 'M420.55,301.93a24,24,0,1,1,24-24,24,24,0,0,1-24,24m-265.1,0a24,24,0,1,1,24-24,24,24,0,0,1-24,24m273.7-144.48,47.94-83a10,10,0,1,0-17.27-10h0l-48.54,84.07a301.25,301.25,0,0,0-246.56,0L116.18,64.45a10,10,0,1,0-17.27,10h0l47.94,83C64.53,202.22,8.24,285.55,0,384H576c-8.24-98.45-64.54-181.78-146.85-226.55'
  },
  'fingerbank-33471': { // Blackberry OS
    width: 512,
    height: 512,
    d: 'M166 116.9c0 23.4-16.4 49.1-72.5 49.1H23.4l21-88.8h67.8c42.1 0 53.8 23.3 53.8 39.7zm126.2-39.7h-67.8L205.7 166h70.1c53.8 0 70.1-25.7 70.1-49.1.1-16.4-11.6-39.7-53.7-39.7zM88.8 208.1H21L0 296.9h70.1c56.1 0 72.5-23.4 72.5-49.1 0-16.3-11.7-39.7-53.8-39.7zm180.1 0h-67.8l-18.7 88.8h70.1c53.8 0 70.1-23.4 70.1-49.1 0-16.3-11.7-39.7-53.7-39.7zm189.3-53.8h-67.8l-18.7 88.8h70.1c53.8 0 70.1-23.4 70.1-49.1.1-16.3-11.6-39.7-53.7-39.7zm-28 137.9h-67.8L343.7 381h70.1c56.1 0 70.1-23.4 70.1-49.1 0-16.3-11.6-39.7-53.7-39.7zM240.8 346H173l-18.7 88.8h70.1c56.1 0 70.1-25.7 70.1-49.1.1-16.3-11.6-39.7-53.7-39.7z'
  },
  'fingerbank-33507': { // Windows Phone OS
    width: 448,
    height: 512,
    d: 'M0 93.7l183.6-25.3v177.4H0V93.7zm0 324.6l183.6 25.3V268.4H0v149.9zm203.8 28L448 480V268.4H203.8v177.9zm0-380.6v180.1H448V32L203.8 65.7z'
  },
  'fingerbank-33738': { // Firewall and Security Appliance
    width: 256,
    height: 256,
    paths: [
      {
        d: 'M90.527 95.651c-1.358 1.357-2.036 2.963-2.036 4.821v13.712c0 1.856.678 3.463 2.036 4.821 1.357 1.357 2.963 2.035 4.82 2.035h30.291a12.852 12.852 0 0 1 20.956-8.594c2.299-5.939 3.846-12.201 4.657-18.83H95.348c-1.857 0-3.464.678-4.821 2.035zM67.924 175.99H38.856c-1.856 0-3.464.678-4.821 2.035-1.356 1.357-2.035 2.964-2.035 4.82v13.711c0 1.855.679 3.465 2.035 4.821 1.359 1.358 2.965 2.035 4.821 2.035h29.068c1.857 0 3.463-.681 4.821-2.035 1.356-1.356 2.035-2.964 2.035-4.821v-13.711c0-1.856-.679-3.463-2.035-4.82s-2.964-2.035-4.821-2.035zm-29.068-13.713h49.636c1.857 0 3.464-.678 4.82-2.034 1.356-1.357 2.036-2.963 2.036-4.82v-13.712c0-1.857-.679-3.464-2.036-4.82-1.356-1.357-2.962-2.035-4.82-2.035H38.856c-1.856 0-3.464.678-4.821 2.035-1.356 1.357-2.035 2.963-2.035 4.82v13.712c0 1.856.679 3.463 2.035 4.82 1.357 1.357 2.965 2.034 4.821 2.034zm79.322 27.26l-.004-.007a42.4 42.4 0 0 1-5.101-13.54H95.348c-1.856 0-3.464.678-4.82 2.035-1.358 1.357-2.036 2.964-2.036 4.82v13.711c0 1.857.678 3.465 2.036 4.821 1.357 1.358 2.964 2.035 4.82 2.035h34.977c-5.296-4.456-9.317-9.057-12.147-13.875zM158.15 73.82a12.943 12.943 0 0 1 12.902.246c1.063.639 2.34 1.472 4.021 2.622.013.007.024.016.036.024.771.532 2.026 1.441 4.552 3.48H217.1c1.868 0 3.484-.683 4.851-2.049 1.366-1.366 2.05-2.984 2.05-4.853V59.487c0-1.87-.684-3.486-2.05-4.853-1.365-1.367-2.981-2.049-4.851-2.049h-55.715c-1.867 0-3.488.682-4.853 2.049-1.366 1.366-2.05 2.983-2.05 4.853V73.29c0 1.028.207 1.98.621 2.856a13.1 13.1 0 0 1 3.047-2.326zM38.856 121.04h29.068c1.857 0 3.463-.679 4.821-2.037 1.356-1.357 2.035-2.964 2.035-4.821v-13.71c0-1.858-.679-3.464-2.035-4.821-1.358-1.357-2.964-2.037-4.821-2.037H38.856c-1.856 0-3.464.679-4.821 2.037C32.679 97.008 32 98.614 32 100.472v13.71c0 1.857.679 3.464 2.035 4.821 1.357 1.358 2.965 2.037 4.821 2.037zm77.06-41.032h18.42c1.857 0 3.465-.678 4.821-2.035 1.358-1.357 2.034-2.964 2.034-4.821V59.441c0-1.857-.676-3.464-2.034-4.82-1.356-1.358-2.964-2.035-4.821-2.035h-18.421c-1.857 0-3.464.677-4.821 2.035-1.356 1.356-2.035 2.963-2.035 4.82v13.712c0 1.856.679 3.463 2.035 4.821 1.358 1.355 2.965 2.034 4.822 2.034zm-77.06 0h49.636c1.857 0 3.464-.678 4.82-2.035s2.036-2.964 2.036-4.821V59.441c0-1.857-.679-3.464-2.036-4.82-1.356-1.358-2.964-2.035-4.82-2.035H38.856c-1.856 0-3.464.677-4.821 2.035C32.679 55.977 32 57.584 32 59.441v13.712c0 1.856.679 3.463 2.035 4.821 1.357 1.355 2.965 2.034 4.821 2.034z'
      },
      {
        style: 'fill-opacity: 0.5',
        d: 'M153.134 203.414c-11.873-6.711-19.833-13.508-23.875-20.391-4.044-6.881-5.123-14.883-3.226-24.006.859-3.612 3.052-9.42 6.581-17.422 3.524-8.001 5.462-14.41 5.81-19.229 3.439 6.368 5.419 12.735 5.938 19.099 13.074-16.171 19.873-35.013 20.391-56.526.859.516 1.977 1.25 3.354 2.194 1.375.948 3.912 2.968 7.614 6.065 3.699 3.097 6.97 6.324 9.808 9.68 2.84 3.354 5.508 7.613 8.003 12.776 2.491 5.161 4 10.325 4.518 15.485 1.374-3.097 2.233-6.537 2.581-10.324.344-3.781-.089-7.312-1.292-10.582 1.375 1.033 3.183 2.754 5.421 5.162 2.233 2.412 4.729 5.679 7.485 9.808a98.256 98.256 0 0 1 7.354 13.163c2.147 4.646 3.523 9.853 4.131 15.614.601 5.769.211 11.358-1.162 16.776-1.379 5.42-4.563 11.015-9.551 16.776-4.992 5.768-11.701 11.06-20.133 15.875 5.68-11.358 6.797-23.617 3.356-36.78-3.445-13.163-10.24-23.271-20.392-30.326.858 3.786.389 10.025-1.421 18.712-1.807 8.691-4.688 15.272-8.646 19.747.686-5.508.86-9.979.517-13.424-.346-3.438-.863-6.021-1.55-7.742l-1.29-2.321c-1.031 6.193-3.702 12.389-8.001 18.582-2.237 3.271-3.916 6.283-5.033 9.035-1.121 2.754-1.549 6.282-1.292 10.582.261 4.305 1.591 8.952 4.002 13.942z'
      }
    ]
  },
  'fingerbank-73235': { // Automotive, Energy and Tools
    width: 512,
    height: 512,
    d: 'M331.758 224.996C360.047 224.996 386.635 236.006 406.615 255.986L426.205 275.557C466.217 257.818 497.455 222.256 507.824 178.91C513.549 154.988 513.164 131.83 508.039 110.506C505.426 99.629 491.609 95.992 483.697 103.902L414.797 172.807H339.193V97.203L408.096 28.301C416.008 20.389 412.371 6.574 401.492 3.961C380.17 -1.164 357.012 -1.549 333.088 4.176C277.785 17.404 234.699 64.395 225.842 120.564C224.531 128.871 224.191 137.004 224.281 145.035L307.064 227.896C315.154 225.98 323.463 224.996 331.758 224.996ZM384 278.625C360.842 255.467 326.424 251.035 298.604 264.705L192 158V96L64 0L0 64L96 192H158L264.705 298.604C251.035 326.424 255.467 360.842 278.625 384L395.625 501.125C410.25 515.625 433.875 515.625 448.375 501.125L501.125 448.375C515.625 433.875 515.625 410.25 501.125 395.625L384 278.625ZM227.879 307.047L168.664 247.887L19.775 396.775C-6.592 423.143 -6.592 465.857 19.775 492.225C32.959 505.408 50.215 512 67.5 512S102.041 505.408 115.225 492.225L234.334 373.115C225.467 352.344 222.592 329.354 227.879 307.047ZM64 472C50.746 472 40 461.254 40 448C40 434.744 50.746 424 64 424S88 434.744 88 448C88 461.254 77.254 472 64 472Z'
  }
}